/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.checks;

import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.drc.DRC;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DeviceGridCheck
implements DRC.Check {
    protected DRC.Violations mViolations = new DRC.Violations();

    @Override
    public String getName() {
        return "Device on Mfg Grid";
    }

    @Override
    public DRC.Options getOptions() {
        return new DRC.Options();
    }

    @Override
    public DRC.Violations getViolations() {
        return this.mViolations;
    }

    @Override
    public long execute(DRC.Engine context) {
        Db db = context.getDb();
        this.mViolations.clear();
        Selection s2 = Selection.getCurrentSelectionForDb((Db)db);
        for (Device dev : db.getObjects(Device.class)) {
            Substrate s;
            NamedGrid ng;
            if (dev.hasChildren() || context.isJustSelected() && !s2.contains((DbObject)dev) || (ng = NamedGrid.get((Substrate)(s = dev.getSubstrate()), (String)"Manufacturing Grid")) == null) continue;
            AGrid grid = ng.getGrid();
            DevicePath dp = dev.getADevicePath();
            DevicePath substratePath = dp.pathToSubstrate();
            DevicePath relPath = substratePath.getRelativePath(dp);
            APoint2D p = relPath.getOrigin();
            long dx = AGridUtil.snapDS((long)p.getX(), (long)grid.getOrignX(), (long)grid.getDeltaX(), (boolean)false);
            long dy = AGridUtil.snapDS((long)p.getY(), (long)grid.getOrignY(), (long)grid.getDeltaY(), (boolean)false);
            if (dx == 0L && dy == 0L) continue;
            this.mViolations.add(new SnapViol(relPath, dp, dx, dy));
        }
        return this.mViolations.size();
    }

    public class SnapViol
    implements DRC.Violation {
        protected final DevicePath relPath;
        protected final DevicePath path;
        protected long dx;
        protected long dy;
        Action mSelect = new AbstractAction("Select"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selection s = Selection.getCurrentSelectionForDb((Db)SnapViol.this.path.getDb());
                s.add(SnapViol.this.path.parentPath(), (DbObject)SnapViol.this.path.getLast());
                OrbitIO.getApp().refreshCurrentView();
            }
        };
        Action mShow = new AbstractAction("Show"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMeTheWay.addDevicePath(SnapViol.this.path);
            }
        };
        Action mSnap = new AbstractAction("Snap"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"%s.moveBy(%dL, %dL)", (Object[])new Object[]{CpHelper.getObjCmdStr(SnapViol.this.path.getDevice()), SnapViol.this.dx, SnapViol.this.dy});
            }
        };

        public SnapViol(DevicePath relPath, DevicePath path, long dx, long dy) {
            this.relPath = relPath;
            this.path = path;
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public String getDescription() {
            Unit unit = Design.getUnit((Db)this.path.getDb());
            return String.format("<h1>Device Grid Violation</h1><div><span class='label'>Device:</span><span class='value'> %s</span></div><div>off the grid by %d, %d</div><div>off the grid by %.6f, %.6f %s</div>", this.relPath.toString(), this.dx, this.dy, unit.toUser(this.dx), unit.toUser(this.dy), unit.getUserName());
        }

        @Override
        public APoint2D getLocation() {
            return this.relPath.getOrigin();
        }

        @Override
        public String getName() {
            return String.format("%s", this.relPath.toString());
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.mSelect, this.mShow, this.mSnap);
        }

        @Override
        public ARect getBounds() {
            return this.path.getBB();
        }

        @Override
        public DRC.Check getCheck() {
            return DeviceGridCheck.this;
        }
    }
}

