/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.checks;

import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.drc.DRC;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class IOPadCheck
implements DRC.Check {
    protected DRC.Violations mViolations = new DRC.Violations();

    @Override
    public String getName() {
        return "IO Pad Check";
    }

    @Override
    public DRC.Options getOptions() {
        return new DRC.Options();
    }

    @Override
    public DRC.Violations getViolations() {
        return this.mViolations;
    }

    @Override
    public long execute(DRC.Engine context) {
        Db db = context.getDb();
        this.mViolations.clear();
        for (DevicePath path : Design.getDesignPath((Db)db).getDescendants()) {
            DeviceTemplate dt = path.getDeviceTemplate();
            ARect dieRect = dt.getBB();
            if (dt.getType() != DeviceTemplate.Type.DIE) continue;
            ArrayList<DevicePath> ioPads = new ArrayList<DevicePath>();
            for (DevicePath dp : path.getDescendants()) {
                DeviceTemplate ct = dp.getDeviceTemplate();
                if (ct.getType() != DeviceTemplate.Type.PAD) continue;
                ioPads.add(dp);
            }
            for (int i = 0; i < ioPads.size(); ++i) {
                DevicePath a = (DevicePath)ioPads.get(i);
                for (int j = i + 1; j < ioPads.size(); ++j) {
                    DevicePath b = (DevicePath)ioPads.get(j);
                    ARect ra = a.getBB();
                    ARect rb = b.getBB();
                    if (!(ra = ra.expandBy(-1L)).intersects(rb = rb.expandBy(-1L))) continue;
                    this.mViolations.add(new OverlapViolation(a, b));
                }
                float r = a.getRelativePathFromAnchor(dt).getRot();
                DevicePath relPath = a.getRelativePathFromAnchor(dt);
                ARect rect = relPath.getBB();
                long bDist = Math.abs(rect.bottom() - dieRect.bottom());
                long tDist = Math.abs(rect.top() - dieRect.top());
                long rDist = Math.abs(rect.right() - dieRect.right());
                long lDist = Math.abs(rect.left() - dieRect.left());
                if (rDist < bDist && rDist < tDist && rDist < lDist && r != 270.0f) {
                    this.mViolations.add(new RotationViolation(a, r, 270.0f));
                }
                if (bDist < rDist && bDist < tDist && bDist < lDist && r != 0.0f) {
                    this.mViolations.add(new RotationViolation(a, r, 0.0f));
                }
                if (tDist < rDist && tDist < bDist && tDist < lDist && r != 180.0f) {
                    this.mViolations.add(new RotationViolation(a, r, 180.0f));
                }
                if (lDist >= rDist || lDist >= bDist || lDist >= rDist || (double)r == 90.0) continue;
                this.mViolations.add(new RotationViolation(a, r, 90.0f));
            }
        }
        return this.mViolations.size();
    }

    public class RotationViolation
    implements DRC.Violation {
        protected DevicePath pathA;
        float curRot;
        float normRot;

        public RotationViolation(DevicePath pathA, float curRot, float normRot) {
            this.pathA = pathA;
            this.curRot = curRot;
            this.normRot = normRot;
        }

        @Override
        public String getDescription() {
            return String.format("<h1>Rotation Violation</h1><div><span class='label'>Device:</span><span class='value'> %s </span></div><div><span class='label'>Rotated:</span><span class='value'> %f </span></div><div><span class='label'>Expected:</span><span class='value'> %f </span></div>", this.pathA.toString(), Float.valueOf(this.curRot), Float.valueOf(this.normRot));
        }

        @Override
        public APoint2D getLocation() {
            return this.pathA.getOrigin();
        }

        @Override
        public String getName() {
            return String.format("%s", this.pathA.toString());
        }

        @Override
        public List<Action> getActions() {
            AbstractAction mSelect = new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action refresh;
                    Selection s = Selection.getCurrentSelectionForDb((Db)RotationViolation.this.pathA.getDb());
                    s.add(RotationViolation.this.pathA.parentPath(), (DbObject)RotationViolation.this.pathA.getLast());
                    AAppView v = OrbitIO.getOrbitIO().getWorkspace().getView(RotationViolation.this.pathA.getDb());
                    if (v != null && (refresh = v.getActions().get("Refresh")) != null) {
                        refresh.actionPerformed(null);
                    }
                }
            };
            AbstractAction mShow = new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowMeTheWay.addDevicePath(RotationViolation.this.pathA);
                }
            };
            return List.of(mSelect, mShow);
        }

        @Override
        public ARect getBounds() {
            return this.pathA.getBB();
        }

        @Override
        public DRC.Check getCheck() {
            return IOPadCheck.this;
        }
    }

    public class OverlapViolation
    implements DRC.Violation {
        protected DevicePath pathA;
        protected DevicePath pathB;

        public OverlapViolation(DevicePath pathA, DevicePath pathB) {
            this.pathA = pathA;
            this.pathB = pathB;
        }

        @Override
        public String getDescription() {
            return String.format("<h1>Overlap Violation</h1><div><span class='label'>Devices:</span><span class='value'> %s %s</span></div>overlap", this.pathA.toString(), this.pathB.toString());
        }

        @Override
        public APoint2D getLocation() {
            return this.pathA.getOrigin();
        }

        @Override
        public String getName() {
            return String.format("%s", this.pathA.toString());
        }

        @Override
        public List<Action> getActions() {
            AbstractAction mSelect = new AbstractAction("Select"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selection s = Selection.getCurrentSelectionForDb((Db)OverlapViolation.this.pathA.getDb());
                    s.add(OverlapViolation.this.pathA.parentPath(), (DbObject)OverlapViolation.this.pathA.getLast());
                    s.add(OverlapViolation.this.pathB.parentPath(), (DbObject)OverlapViolation.this.pathB.getLast());
                    OrbitIO.getApp().refreshCurrentView();
                }
            };
            AbstractAction mShow = new AbstractAction("Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowMeTheWay.addDevicePath(OverlapViolation.this.pathA);
                }
            };
            return List.of(mSelect, mShow);
        }

        @Override
        public ARect getBounds() {
            return this.pathA.getBB();
        }

        @Override
        public DRC.Check getCheck() {
            return IOPadCheck.this;
        }
    }
}

