/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.drc.DRC;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class LayerInterconnectCheck
implements DRC.Check {
    public DRC.Option<Scope> OptScope = new DRC.OptionEnum<Scope>("Scope of items to check", Scope.class, Scope.ALL);
    public DRC.Option<Boolean> OptCheckPadToTrace = new DRC.OptionBoolean("Check clearance between pads and traces", true);
    public DRC.Option<Boolean> OptTraceToTrace = new DRC.OptionBoolean("Check clearance between traces", true);
    public DRC.Option<Boolean> OptCheckClearToNetUnused = new DRC.OptionBoolean("Check clearance to NetUnused", true);
    protected DRC.Option<?>[] OPTIONS = new DRC.Option[]{this.OptScope, this.OptCheckPadToTrace, this.OptTraceToTrace, this.OptCheckClearToNetUnused};
    protected DRC.Options mOptions = new DRC.Options(this.OPTIONS);
    protected DRC.Violations mViolations = new DRC.Violations();

    public void setOptScope(Scope scope) {
        this.OptScope.set(scope);
    }

    public void setOptCheckPadToTrace(boolean b) {
        this.OptCheckPadToTrace.set(b);
    }

    public void setOptTraceToTrace(boolean b) {
        this.OptTraceToTrace.set(b);
    }

    public void setOptCheckClearToNetUnused(boolean b) {
        this.OptCheckClearToNetUnused.set(b);
    }

    public Scope getOptScope() {
        return this.OptScope.get();
    }

    public boolean getOptCheckPadToTrace() {
        return this.OptCheckPadToTrace.get();
    }

    public boolean getOptTraceToTrace() {
        return this.OptTraceToTrace.get();
    }

    public boolean getOptCheckClearToNetUnused() {
        return this.OptCheckClearToNetUnused.get();
    }

    @Override
    public String getName() {
        return "Layer Interconnect";
    }

    @Override
    public DRC.Options getOptions() {
        return this.mOptions;
    }

    @Override
    public long execute(DRC.Engine context) {
        Db db = context.getDb();
        Selection selection = context.getSelection();
        Selection s2 = Selection.getCurrentSelectionForDb((Db)db);
        this.mViolations.clear();
        for (Layer layer : db.getObjects(Layer.class)) {
            if (this.OptScope.get() == Scope.SELECTED_LAYERS && !selection.contains((DbObject)layer)) continue;
            Substrate substrate = layer.getSubstrate();
            if (substrate == null) {
                ALog.logError((String)"Layer '%s' has no substrate.", (Object[])new Object[]{layer.getName()});
                continue;
            }
            if (context.isJustSelected() && !s2.contains((DbObject)layer)) continue;
            ArrayList portsOnLayer = layer.getDPPOnLayer();
            for (int i = 0; i < portsOnLayer.size(); ++i) {
                PinInstance dport = ((HierPin)portsOnLayer.get(i)).getPin();
                if (this.OptScope.get() == Scope.SELECTED_INTERCONNECT && !selection.contains((DbObject)dport) || !this.OptCheckPadToTrace.get().booleanValue()) continue;
                for (Wire wire : layer.getWires()) {
                    if (this.OptScope.get() == Scope.SELECTED_INTERCONNECT && !selection.contains((DbObject)wire)) continue;
                    this.checkPadToWire((HierPin)portsOnLayer.get(i), wire);
                }
            }
            ArrayList wires = AUtil.arrayList((Iterator)layer.getWires());
            for (int i = 0; i < wires.size(); ++i) {
                Wire wire1 = (Wire)wires.get(i);
                if (this.OptScope.get() == Scope.SELECTED_INTERCONNECT && !selection.contains((DbObject)wire1)) continue;
                for (int j = i + 1; j < wires.size(); ++j) {
                    Wire wire2 = (Wire)wires.get(j);
                    if (this.OptScope.get() == Scope.SELECTED_INTERCONNECT && !selection.contains((DbObject)wire2)) continue;
                    this.checkWireToWire(wire1, wire2);
                }
            }
            ArrayList metals = AUtil.arrayList((Iterator)layer.getMetals());
            for (int i = 0; i < metals.size(); ++i) {
                Metal metal1 = (Metal)metals.get(i);
                if (this.OptScope.get() == Scope.SELECTED_INTERCONNECT && !selection.contains((DbObject)metal1)) continue;
                for (int j = i + 1; j < metals.size(); ++j) {
                    Metal metal2 = (Metal)metals.get(j);
                    if (this.OptScope.get() == Scope.SELECTED_INTERCONNECT && !selection.contains((DbObject)metal2)) continue;
                    LayerInterconnectCheck.addIfNotNull(this.mViolations, this.checkMetalToMetal(metal1, metal2));
                }
            }
        }
        return this.mViolations.size();
    }

    @Override
    public DRC.Violations getViolations() {
        return this.mViolations;
    }

    public void checkPadToWire(HierPin dpp, Wire wire) {
        ARect rj;
        DevicePath path = dpp.getPath();
        PinInstance port = dpp.getPin();
        Net wireNet = wire.getNet();
        Net portNet = dpp.getSubstrateNet();
        if (wire.getPath().getPointCount() == 0) {
            return;
        }
        if (portNet == wireNet) {
            return;
        }
        if (!this.OptCheckClearToNetUnused.get().booleanValue() && (portNet.isUnused() || wireNet.isUnused())) {
            return;
        }
        Layer layer = wire.getLayer();
        AGeom padGeom = port.getSubstrateShapeOnLayer(path, layer);
        if (padGeom == null) {
            return;
        }
        APath wirePath = wire.getPath();
        APath padPath = padGeom.toPoly().toPath();
        ARect ri = wire.getBB();
        if (!ri.intersects(rj = padPath.getBounds())) {
            return;
        }
        long dist = wirePath.distanceToPath(padPath);
        long clear = Math.max(this.getPortClearance(port), this.getWireClearance(path.getLast(), wire));
        if (clear > 0L && dist < clear - 1L) {
            this.mViolations.add(new ClearanceViolation(path, (DbObject)port, (DbObject)wire, clear, dist));
        }
    }

    public void checkWireToWire(Wire wire1, Wire wire2) {
        ARect rj;
        Net net2;
        if (!this.OptTraceToTrace.get().booleanValue()) {
            return;
        }
        Net net1 = wire1.getNet();
        if (net1 == (net2 = wire2.getNet())) {
            return;
        }
        if (!this.OptCheckClearToNetUnused.get().booleanValue() && (net1.isUnused() || net2.isUnused())) {
            return;
        }
        APath p1 = wire1.getPath();
        APath p2 = wire2.getPath();
        long dist = p1.distanceToPath(p2);
        ARect ri = wire1.getBB();
        if (!ri.intersects(rj = wire2.getBB())) {
            return;
        }
        for (Device d : wire1.getDeviceTemplate().getDeviceInstances()) {
            long clear = Math.max(this.getWireClearance(d, wire1), this.getWireClearance(d, wire2));
            if (clear <= 0L || dist >= clear - 1L) continue;
            DevicePath path = d.getADevicePath();
            this.mViolations.add(new ClearanceViolation(path, (DbObject)wire1, (DbObject)wire2, clear, dist));
        }
    }

    public DRC.Violation checkMetalToMetal(Metal metal1, Metal metal2) {
        return null;
    }

    long getPortClearance(PinInstance port) {
        return 0L;
    }

    long getWireClearance(Device device, Wire wire) {
        Layer l = wire.getLayer();
        if (l == null) {
            return 0L;
        }
        RuleSet ruleSet = RuleSetMgr.getMyRuleSet((DbObject)wire);
        if (ruleSet == null) {
            return 2L * Design.getDefaultUnitDistDbuCount();
        }
        long clear = (Long)RuleSetMgr.getConstraintValue((RuleSet)ruleSet, (Constraint.Descriptor)Constraint.WIRE_CLEAR, (Layer)l);
        return clear;
    }

    long getMetalClearance(Metal metal) {
        return 0L;
    }

    public static <T> void addIfNotNull(Collection<T> c, T i) {
        if (i != null) {
            c.add(i);
        }
    }

    public class ClearanceViolation
    implements DRC.Violation {
        protected DevicePath mPath;
        protected DbObject mDbo1;
        protected DbObject mDbo2;
        protected long mMin;
        protected long mActual;
        protected APoint2D mLocation = null;
        Action mSelect = new AbstractAction("Select"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selection s = Selection.getCurrentSelectionForDb((Db)ClearanceViolation.this.mDbo1.getDb());
                s.add(ClearanceViolation.this.mDbo1);
                s.add(ClearanceViolation.this.mDbo2);
                OrbitIO.getApp().refreshCurrentView();
            }
        };
        Action mShow = new AbstractAction("Show"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClearanceViolation.this.show(ClearanceViolation.this.mDbo1);
                ClearanceViolation.this.show(ClearanceViolation.this.mDbo2);
            }
        };

        public ClearanceViolation(DevicePath path, DbObject o1, DbObject o2, long min, long actual) {
            this.mPath = path;
            this.mDbo1 = o1;
            this.mDbo2 = o2;
            this.mMin = min;
            this.mActual = actual;
        }

        @Override
        public String getDescription() {
            Unit unit = Design.getUnit((Db)this.mDbo1.getDb());
            return String.format("<h1>Clearance violation</h1><div><span class='label'>%s:</span><span class='value'> %s</span></div><div><span class='label'>%s:</span><span class='value'> %s</span></div><div><span class='label'>Required separation:</span><span class='value'> %ss</span></div><div><span class='label'>Actual separation:</span><span class='value'> %ss</span></div>", this.getName(this.mDbo1), this.getDesc(this.mDbo1), this.getName(this.mDbo2), this.getDesc(this.mDbo2), unit.toUserStr(this.mMin, true), unit.toUserStr(this.mActual, true));
        }

        @Override
        public APoint2D getLocation() {
            if (this.mLocation == null) {
                AGeom s1 = this.getShape(this.mDbo1);
                AGeom s2 = this.getShape(this.mDbo2);
                this.mLocation = s1.distanceTo(s2).center();
            }
            return this.mLocation;
        }

        @Override
        public String getName() {
            return String.format("%s to %s", this.getName(this.mDbo1), this.getName(this.mDbo2));
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.mSelect, this.mShow);
        }

        @Override
        public ARect getBounds() {
            ARect r = this.getShape(this.mDbo1).getBounds();
            r.expand(this.getShape(this.mDbo1).getBounds());
            return r;
        }

        @Override
        public DRC.Check getCheck() {
            return LayerInterconnectCheck.this;
        }

        public AGeom getShape(DbObject dbo) {
            Class<?> cls = dbo.getClass();
            if (cls == PinInstance.class) {
                PinInstance port = (PinInstance)dbo;
                return port.getSubstrateShapeOnLayer(this.mPath, null);
            }
            if (cls == Wire.class) {
                Wire w = (Wire)dbo;
                return w.getPath().transform(this.mPath.getTransform());
            }
            if (cls == Metal.class) {
                Metal m = (Metal)dbo;
                return m.getGeom().transform(this.mPath.getTransform());
            }
            assert (false);
            return null;
        }

        public String getName(DbObject dbo) {
            if (dbo == null) {
                return "null";
            }
            Class<?> cls = dbo.getClass();
            if (cls == PinInstance.class) {
                PinInstance port = (PinInstance)dbo;
                return port.getName();
            }
            return dbo.getDbClass().getName();
        }

        public String getNetName(Net net) {
            if (net == null) {
                return "" + net;
            }
            Net topNet = NetMap.getTopmostNet((Net)net, (DevicePath)this.mPath);
            if (topNet == null) {
                return "" + topNet;
            }
            return topNet.getName();
        }

        public String getDesc(DbObject dbo) {
            if (dbo == null) {
                return "null";
            }
            Class<?> cls = dbo.getClass();
            if (cls == PinInstance.class) {
                PinInstance port = (PinInstance)dbo;
                String net = this.getNetName(port.getNet());
                return String.format("Net '%s'", net);
            }
            if (cls == Wire.class) {
                Wire wire = (Wire)dbo;
                String net = wire.getNet().getName();
                String lyr = wire.getLayer().getName();
                return String.format("Net '%s' on Layer '%s'", net, lyr);
            }
            if (cls == Metal.class) {
                Metal metal = (Metal)dbo;
                String net = this.getNetName(metal.getNet());
                String lyr = metal.getLayer().getName();
                return String.format("Net '%s' on Layer '%s'", net, lyr);
            }
            DbClass dbc = dbo.getDbClass();
            if (dbc.getField("name") != null) {
                return dbo.getStringValue("name");
            }
            return "Key: " + dbo.getKeyStr();
        }

        public void show(DbObject dbo) {
            Class<?> cls = dbo.getClass();
            if (cls == PinInstance.class) {
                PinInstance port = (PinInstance)dbo;
                ShowMeTheWay.addHierPin(new HierPin(this.mPath, port));
            } else if (cls == Wire.class) {
                DesignView2D view = (DesignView2D)OrbitIO.getCurView();
                if (view != null) {
                    Wire w = (Wire)dbo;
                    APoint2D pt = w.getPath().getCentralPoint().transform(this.mPath.getTransform());
                    ShowMeTheWay smtw = view.getShowMeTheWay();
                    smtw.addShowMe(pt, "Wire");
                }
            } else if (cls == Metal.class) {
                Metal m = (Metal)dbo;
                DesignView2D view = (DesignView2D)OrbitIO.getCurView();
                if (view != null) {
                    APoint2D pt = m.getGeom().getBounds().center().transform(this.mPath.getTransform());
                    ShowMeTheWay smtw = view.getShowMeTheWay();
                    smtw.addShowMe(pt, "Metal");
                }
            } else assert (false);
        }
    }

    public static enum Scope {
        ALL,
        SELECTED_LAYERS,
        SELECTED_INTERCONNECT;

    }
}

