/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.checks;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class PersonalityClearance {
    private PersonalityClearance() {
    }

    public static List<HierPin> codeTest(String devicePathString, String personalityA, String personalityB, double dist, String filename) throws FileNotFoundException {
        Optional b;
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return null;
        }
        DeviceTemplate devicetemplate = devicePath.getDeviceTemplate();
        Personality pA = new Personality();
        Personality pB = new Personality();
        Optional a = Personality.getPersonality((DeviceTemplate)devicetemplate, (Personality.Type)Personality.Type.PORT, (String)personalityA);
        if (a.isPresent()) {
            pA = (Personality)a.get();
        }
        if ((b = Personality.getPersonality((DeviceTemplate)devicetemplate, (Personality.Type)Personality.Type.PORT, (String)personalityB)).isPresent()) {
            pB = (Personality)b.get();
        }
        LinkedList<HierPin> hA = new LinkedList<HierPin>();
        LinkedList<HierPin> hB = new LinkedList<HierPin>();
        pA.getObjects().forEach(obj -> {
            if (obj.getSecond() instanceof PinInstance) {
                HierPin hp = new HierPin((DevicePath)obj.getFirst(), (PinInstance)obj.getSecond());
                hA.add(hp);
            }
        });
        pB.getObjects().forEach(obj -> {
            if (obj.getSecond() instanceof PinInstance) {
                HierPin hp = new HierPin((DevicePath)obj.getFirst(), (PinInstance)obj.getSecond());
                hB.add(hp);
            }
        });
        List<HierPin> c = PersonalityClearance.getMaxDistanceHierPin(hA, hB, dist);
        Selection sel = Selection.getCurrentSelectionForDb((Db)db);
        sel.clear();
        for (HierPin hierPin : c) {
            sel.add((DevicePath)hierPin.getFirst(), (DbObject)hierPin.getDbObject());
        }
        DesignCanvas2D dc = new DesignCanvas2D(db);
        dc.refresh();
        PersonalityClearance.generateCSV(filename, c, hB);
        return c;
    }

    public static void generateCSV(String filename, List<HierPin> C, List<HierPin> B) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(new File(filename));
        StringBuilder sb = new StringBuilder();
        sb.append("Pin Name");
        sb.append(", ");
        sb.append("Actual Distance");
        sb.append("\n");
        Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
        for (int i = 0; i < C.size(); ++i) {
            sb.append(C.get(i).toString());
            sb.append(", ");
            long temp = Long.MAX_VALUE;
            for (int j = 0; j < B.size(); ++j) {
                long var = Math.abs(C.get(i).dist(B.get(j)));
                if (temp <= var) continue;
                temp = var;
            }
            double x = unit.toUser(temp);
            sb.append(Double.toString(x));
            sb.append("\n");
        }
        pw.write(sb.toString());
        pw.close();
    }

    private static List<HierPin> getMaxDistanceHierPin(List<HierPin> A, List<HierPin> B, double dist) {
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        long x = unit.fromUser(dist);
        if (A.isEmpty() || B.isEmpty()) {
            return new LinkedList<HierPin>();
        }
        int Asize = A.size();
        for (int i = 0; i < Asize; ++i) {
            for (int j = 0; j < B.size(); ++j) {
                long var = Math.abs(B.get(j).dist(A.get(i)));
                if (var > x) continue;
                A.remove(i);
                --i;
                break;
            }
            Asize = A.size();
        }
        return A;
    }
}

