/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.checks;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.drc.DRC;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class WireGridCheck
implements DRC.Check {
    protected DRC.Violations mViolations = new DRC.Violations();

    @Override
    public String getName() {
        return "Wire on Mfg Grid";
    }

    @Override
    public DRC.Options getOptions() {
        return new DRC.Options();
    }

    @Override
    public DRC.Violations getViolations() {
        return this.mViolations;
    }

    @Override
    public long execute(DRC.Engine context) {
        Db db = context.getDb();
        Selection s2 = Selection.getCurrentSelectionForDb((Db)db);
        this.mViolations.clear();
        for (Wire wire : db.getObjects(Wire.class)) {
            DeviceTemplate template = wire.getDeviceTemplate();
            Substrate s = wire.getSubstrate();
            NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid");
            if (ng == null) continue;
            AGrid grid = ng.getGrid();
            if (context.isJustSelected() && !s2.contains((DbObject)wire) || ng == null || grid == null) continue;
            APath path = wire.getPath();
            for (APoint2D p : path.getPoints()) {
                if (grid.isOnGrid(p)) continue;
                Device aDevice = template.getAnInstance();
                DevicePath aPath = aDevice.getADevicePath();
                APoint2D pWorld = aPath.transformPt(p);
                this.mViolations.add(new SnapViol(wire, pWorld));
            }
        }
        return this.mViolations.size();
    }

    public class SnapViol
    implements DRC.Violation {
        Wire w;
        APoint2D p;
        Action mSelect = new AbstractAction("Select"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selection s = Selection.getCurrentSelectionForDb((Db)SnapViol.this.w.getDb());
                s.add((DbObject)SnapViol.this.w);
                OrbitIO.getApp().refreshCurrentView();
            }
        };
        Action mShow = new AbstractAction("Show"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMeTheWay.addWireVertex(SnapViol.this.w, SnapViol.this.p);
            }
        };

        public SnapViol(Wire w, APoint2D p) {
            this.w = w;
            this.p = p;
        }

        @Override
        public String getDescription() {
            return String.format("<h1>Wire Grid Violation</h1><div><span class='label'>Wire:</span><span class='value'> %s </span></div>off grid at %d %d", this.w.getNet().getName(), this.p.getX(), this.p.getY());
        }

        @Override
        public APoint2D getLocation() {
            return this.p;
        }

        @Override
        public String getName() {
            return String.format("%s", this.w.getNet().getName());
        }

        @Override
        public List<Action> getActions() {
            return List.of(this.mSelect, this.mShow);
        }

        @Override
        public ARect getBounds() {
            long aNumber = Design.micronToInternal((Db)(this.w == null ? null : this.w.getDb()), (double)10.0);
            ARect r = ARect.create((long)(-aNumber), (long)(-aNumber), (long)aNumber, (long)aNumber);
            r.moveCenterTo(this.p);
            return r;
        }

        @Override
        public DRC.Check getCheck() {
            return WireGridCheck.this;
        }
    }
}

