/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.ui;

import com.sigrity.acl.AProgress;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.drc.DRC;
import com.sigrity.orbit.drc.ui.DRCDisplay;
import com.sigrity.orbit.drc.ui.DRCOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class DRCDialog
extends DbDialog {
    protected DRCOptions mDrcOptions = null;
    protected DRCDisplay mDrcDisplay = null;
    protected JProgressBar mProgressBar = null;
    protected JComponent mButtonRowFiller;

    public static DRCDialog showUi() {
        return DRCDialog.showUi(null);
    }

    public static DRCDialog showUi(Db db) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            return null;
        }
        DRCDialog drcDialog = new DRCDialog(OrbitIO.getMainWindow(), db);
        drcDialog.setVisible(true);
        return drcDialog;
    }

    public DRCDialog(Window owner, Db db, DRC.Checks checks) {
        super(db, (Component)owner, "Check Rules");
        this.init(checks);
    }

    public DRCDialog(Window owner, Db db) {
        this(owner, db, null);
    }

    protected void init(DRC.Checks checks) {
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        if (checks != null) {
            this.mDrcDisplay = (DRCDisplay)l.add((Component)new DRCDisplay(this.mDb, checks), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        } else {
            this.mDrcOptions = (DRCOptions)l.add((Component)new DRCOptions(this.mDb), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        }
        l.newline();
        l.pushFillX();
        this.mProgressBar = (JProgressBar)l.add((Component)new JProgressBar(), (GridBagConstraints)GridBagManager.FILLX);
        this.mProgressBar.setVisible(false);
        this.mButtonRowFiller = l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("Run"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DRCDialog.this.runChecks();
            }
        });
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
    }

    protected void setProgressVisible(boolean b) {
        this.mProgressBar.setVisible(b);
        this.mButtonRowFiller.setVisible(!b);
        this.mProgressBar.getParent().doLayout();
    }

    protected void runChecks() {
        DRC.Engine drcEngine = new DRC.Engine(this.mDb);
        if (this.mDrcOptions == null || !this.mDrcOptions.apply()) {
            return;
        }
        boolean justSelected = this.mDrcOptions.mToggleChecks1.isSelected();
        drcEngine.isJustSelected(justSelected);
        for (DRCOptions.CheckListItem cli : this.mDrcOptions.getChecks()) {
            if (!cli.getIsSelected()) continue;
            DRC.Check check = cli.getCheck();
            drcEngine.addCheck(check);
        }
        if (drcEngine.getChecks().size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No checks selected, nothing to do.", "Check Rules", 2);
            return;
        }
        ProgressTracker progressTracker = new ProgressTracker(drcEngine);
        progressTracker.start();
        long violations = drcEngine.execute();
        progressTracker.end();
        if (violations == 0L) {
            JOptionPane.showMessageDialog(OrbitIO.getMainWindow(), "No violations found in the selected checks.", "Complete", 1);
        } else {
            this.setProgressVisible(true);
            this.setProgress(100, "Preparing results display...");
            DRCDialog drcDialog = new DRCDialog(OrbitIO.getMainWindow(), this.mDb, drcEngine.getChecks());
            drcDialog.setVisible(true);
            this.setProgressVisible(false);
        }
    }

    protected void setProgress(int percent, String msg) {
        this.mProgressBar.setValue(percent);
        if (msg == null || msg.length() < 1) {
            this.mProgressBar.setStringPainted(false);
        } else {
            this.mProgressBar.setStringPainted(true);
            this.mProgressBar.setString(msg);
        }
        this.mProgressBar.paintImmediately(this.mProgressBar.getVisibleRect());
    }

    protected class ProgressTracker
    implements DRC.EngineListener,
    AProgress.Listener {
        protected DRC.Engine mEngine;
        protected HashMap<DRC.Check, Integer> mCheck2CompletePct = new HashMap();
        protected String mCurProgressMsg = null;

        public ProgressTracker(DRC.Engine engine) {
            this.mEngine = engine;
        }

        public void start() {
            for (DRC.Check check : this.mEngine.getChecks()) {
                if (check instanceof AProgress.Provider) {
                    ((AProgress.Provider)check).addProgressListener((AProgress.Listener)this);
                }
                this.mCheck2CompletePct.put(check, 0);
            }
            DRCDialog.this.setProgressVisible(true);
            this.mEngine.addListener(this);
        }

        public void end() {
            this.mEngine.removeListener(this);
            DRCDialog.this.setProgressVisible(false);
        }

        @Override
        public void notifyCheckStart(DRC.Check check) {
            this.mCheck2CompletePct.put(check, 0);
            this.mCurProgressMsg = "Running " + check.getName() + ".";
            this.updateProgress();
        }

        @Override
        public void notifyCheckEnd(DRC.Check check) {
            this.mCheck2CompletePct.put(check, 100);
            this.mCurProgressMsg = check.getName() + " complete.";
            this.updateProgress();
        }

        public void progressUpdate(AProgress.Provider src, int percent, String message) {
            this.mCheck2CompletePct.put((DRC.Check)src, percent);
            this.mCurProgressMsg = message;
            this.updateProgress();
        }

        protected void updateProgress() {
            int complete = 0;
            for (int c : this.mCheck2CompletePct.values()) {
                complete += c;
            }
            DRCDialog.this.setProgress(complete /= this.mCheck2CompletePct.size(), this.mCurProgressMsg);
        }
    }
}

