/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.ui;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.ui.AContextMenu;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.drc.DRC;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DRCDisplay
extends JPanel {
    protected Db mDb;
    protected DRC.Checks mChecks;
    protected JTree mTree;
    protected HTMLViewer mHtmlViewer;
    protected JCheckBox mCbZoomOnSel;
    protected JCheckBox mCbSelectOnSel;
    protected JCheckBox mCbShowOnSel;

    public DRCDisplay(Db db, DRC.Checks checks) {
        this.mDb = db;
        this.mChecks = checks;
        GridBagManager l = GridBagManager.layout((Container)this);
        ATreeModel treeModel = new ATreeModel();
        treeModel.setRoot((TreeNode)((Object)new RootNode(treeModel)));
        this.mTree = new ATree(treeModel);
        this.mTree.setShowsRootHandles(true);
        this.mTree.setRootVisible(false);
        UIUtil.expandTreeLevels((JTree)this.mTree, (int)1);
        this.mHtmlViewer = new HTMLViewer();
        ASplitPane splitter = new ASplitPane(1, new JScrollPane(this.mTree), new JScrollPane(this.mHtmlViewer));
        l.add((Component)splitter, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.pushFillXRemainX();
        l.add("On select:");
        this.mCbZoomOnSel = (JCheckBox)l.add((Component)new JCheckBox("Zoom To"));
        this.mCbZoomOnSel.setSelected(true);
        this.mCbSelectOnSel = (JCheckBox)l.add((Component)new JCheckBox("Select"));
        this.mCbSelectOnSel.setSelected(true);
        this.mCbShowOnSel = (JCheckBox)l.add((Component)new JCheckBox("Show"));
        l.addFillX();
        l.pop();
        this.mTree.getSelectionModel().setSelectionMode(1);
        this.mTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DescriptiveNode node = (DescriptiveNode)((Object)DRCDisplay.this.mTree.getLastSelectedPathComponent());
                if (node == null) {
                    DRCDisplay.this.mHtmlViewer.setText("");
                } else {
                    Object text = node.getDescription();
                    if (node instanceof ViolationNode) {
                        AAppView view;
                        DRC.Violation violation = ((ViolationNode)node).mViolation;
                        IterableIterator<Action> actions = DRCDisplay.this.getActions(violation);
                        if (actions.hasNext()) {
                            text = (String)text + "<div id='links'>";
                            for (Action a : actions) {
                                text = (String)text + String.format("<a class='ActionLink' href='http://action/%s'>%s</a> ", a.getValue("Name"), a.getValue("Name"));
                            }
                            text = (String)text + "</div>";
                        }
                        if (DRCDisplay.this.mCbSelectOnSel.isSelected()) {
                            Selection selection = Selection.getCurrentSelectionForDb((Db)DRCDisplay.this.mDb);
                            if (selection != null) {
                                selection.clear();
                            }
                            DRCDisplay.this.doViolationAction(violation, "Select", "ViolationSelected");
                        }
                        if (DRCDisplay.this.mCbShowOnSel.isSelected() && (view = OrbitIO.getOrbitIO().getWorkspace().getView(DRCDisplay.this.mDb)) instanceof DesignView2D) {
                            DesignView2D v2d = (DesignView2D)view;
                            v2d.getShowMeTheWay().clearShowMe();
                            DRCDisplay.this.doViolationAction(violation, "Show", "ViolationSelected");
                        }
                        if (DRCDisplay.this.mCbZoomOnSel.isSelected()) {
                            DRCDisplay.this.doViolationAction(violation, "Zoom To", "ViolationSelected");
                        }
                    }
                    DRCDisplay.this.mHtmlViewer.setText((String)text);
                }
            }
        });
        AContextMenu.install((Component)this.mTree, (AContextMenu.MenuProvider)new AContextMenu.MenuProvider(){

            public void showMenu(Component c, int x, int y) {
                TreePath p = DRCDisplay.this.mTree.getPathForLocation(x, y);
                if (p == null) {
                    return;
                }
                if (!DRCDisplay.this.mTree.getSelectionModel().isPathSelected(p)) {
                    DRCDisplay.this.mTree.setSelectionPath(p);
                }
                if (p.getLastPathComponent() instanceof ViolationNode) {
                    DRC.Violation v = ((ViolationNode)((Object)p.getLastPathComponent())).mViolation;
                    IterableIterator<Action> actions = DRCDisplay.this.getActions(v);
                    if (!actions.hasNext()) {
                        return;
                    }
                    JPopupMenu m = new JPopupMenu();
                    for (Action a : actions) {
                        m.add(a);
                    }
                    UIUtil.setMnemonics((JPopupMenu)m);
                    m.show(c, x, y);
                }
            }
        });
    }

    protected IterableIterator<Action> getActions(final DRC.Violation violation) {
        LinkedList<Action> actions = new LinkedList<Action>();
        AAppView view = OrbitIO.getOrbitIO().getWorkspace().getView(this.mDb);
        if (view instanceof DesignView2D) {
            final DesignView2D v2d = (DesignView2D)view;
            AbstractAction zoomTo = new AbstractAction("Zoom To"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    v2d.getCanvas().zoomTo(violation.getBounds());
                }
            };
            actions.add(zoomTo);
        }
        actions.addAll(violation.getActions());
        return new AIterableItr(actions);
    }

    protected boolean doViolationAction(DRC.Violation v, String actionName, String actionCmd) {
        for (Action a : this.getActions(v)) {
            if (!a.getValue("Name").equals(actionName)) continue;
            ActionEvent event = new ActionEvent(this, 1001, actionCmd);
            a.actionPerformed(event);
            return true;
        }
        return false;
    }

    public class HTMLViewer
    extends JTextPane {
        HyperlinkListener mLinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL url = e.getURL();
                if (url.getHost().equals("action")) {
                    String actionName = url.getPath().substring(1);
                    Object selNode = DRCDisplay.this.mTree.getLastSelectedPathComponent();
                    if (selNode instanceof ViolationNode) {
                        ViolationNode vn = (ViolationNode)((Object)selNode);
                        DRC.Violation v = vn.mViolation;
                        DRCDisplay.this.doViolationAction(v, actionName, e.getDescription());
                    }
                }
            }
        };

        public HTMLViewer() {
            HTMLEditorKit hek = new HTMLEditorKit();
            this.setBorder(null);
            this.setEditorKit(hek);
            this.setEditable(false);
            this.addHyperlinkListener(this.mLinkListener);
            HTMLDocument doc = (HTMLDocument)hek.createDefaultDocument();
            StyleSheet styleSheet = doc.getStyleSheet();
            styleSheet.addRule("body {font-family: sans-serif; text-indent:-8px; margin-left:12px; margin-right:4px}");
            styleSheet.addRule("td {padding: 1px; border-width: 1px}");
            styleSheet.addRule("th {text-align: left}");
            styleSheet.addRule("h1 {text-decoration:none; margin-bottom:2px; margin-top:0px; font-size:1.1em}");
            styleSheet.addRule("h2 {text-decoration:none; margin-bottom:2px}");
            styleSheet.addRule("h3 {text-decoration:underline; margin-bottom:2px}");
            styleSheet.addRule("pre {font-size: x-small; font-family: sans-serif}");
            styleSheet.addRule("span.label {font-weight:bold}");
            styleSheet.addRule("div#links {margin-top:4px; text-align:right}");
            styleSheet.addRule("div#links a {text-decoration:none; background: #DDDDFF}");
            this.setDocument(doc);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            this.setCaretPosition(0);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = Math.max(d.width, 400);
            return d;
        }
    }

    protected class ViolationNode
    extends DescriptiveNode {
        protected DRC.Violation mViolation;

        public ViolationNode(CheckNode parent, DRC.Violation v) {
            super((ATreeNode)parent);
            this.mViolation = v;
        }

        public boolean isLeaf() {
            return true;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            return null;
        }

        public String getText() {
            return this.mViolation.getName();
        }

        @Override
        public String getDescription() {
            return this.mViolation.getDescription();
        }

        public Icon getIcon() {
            return OrbitIcons.DRC_ERROR;
        }
    }

    protected class CheckNode
    extends DescriptiveNode {
        protected DRC.Check mCheck;

        public CheckNode(RootNode parent, DRC.Check check) {
            super((ATreeNode)parent);
            this.setSortChildren(false);
            this.mCheck = check;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<ViolationNode> list = new ArrayList<ViolationNode>();
            for (DRC.Violation v : this.mCheck.getViolations()) {
                list.add(new ViolationNode(this, v));
            }
            return list;
        }

        public String getText() {
            Integer testcases = this.mCheck.getTestCaseCount();
            if (testcases != null) {
                return String.format("<html>%s <font color='gray'>(%d/%d)</font>", this.mCheck.getName(), this.getChildCount(), testcases);
            }
            return String.format("<html>%s <font color='gray'>(%d/?)</font>", this.mCheck.getName(), this.getChildCount());
        }

        @Override
        public String getDescription() {
            Object res = String.format("<div><span class='label'>Check:</span> <span class='value'>%s</span></div>", this.mCheck.getName());
            res = (String)res + String.format("<div><span class='label'>Violations:</span> <span class='value'>%d</span></div>", this.mCheck.getViolations().size());
            return res;
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }
    }

    protected class RootNode
    extends ALazyTreeNode {
        public RootNode(ATreeModel model) {
            super(model);
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<CheckNode> list = new ArrayList<CheckNode>();
            for (DRC.Check c : DRCDisplay.this.mChecks) {
                list.add(new CheckNode(this, c));
            }
            return list;
        }

        public String getText() {
            return "Checks and Violations";
        }
    }

    protected abstract class DescriptiveNode
    extends ALazyTreeNode {
        public DescriptiveNode(ATreeNode parent) {
            super(parent);
        }

        public abstract String getDescription();
    }
}

