/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.drc.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.drc.DRC;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DRCOptions
extends JPanel {
    protected AList<CheckListItem> mLstChecks;
    protected AListModel<CheckListItem> mChecks;
    protected ASplitPane mSplitPane;
    protected JScrollPane mRight;
    protected TogglePickedChecks mToggleChecks;
    protected TogglePickedChecks1 mToggleChecks1;

    public DRCOptions(Db db) {
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mSplitPane = new ASplitPane();
        l.add((Component)this.mSplitPane, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        JPanel leftPanel = new JPanel();
        this.mSplitPane.setLeftComponent(leftPanel);
        this.mRight = new JScrollPane();
        this.mSplitPane.setRightComponent(this.mRight);
        GridBagManager left = GridBagManager.layout((Container)leftPanel);
        this.mChecks = new AListModel();
        this.mLstChecks = new AList<CheckListItem>((ListModel<CheckListItem>)this.mChecks);
        this.mLstChecks.setShowCheckBoxes(true);
        this.mLstChecks.getSelectionModel().addListSelectionListener(new CurrentCheckListener());
        this.mLstChecks.setCellRenderer(new CheckListRenderer(this.mLstChecks));
        JScrollPane spChecks = new JScrollPane(this.mLstChecks);
        this.mLstChecks.addCheckListener(new CheckedListener());
        left.add((Component)spChecks, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
        l.newline();
        this.mToggleChecks = (TogglePickedChecks)l.add((Component)new TogglePickedChecks(), (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
        l.newline();
        this.mToggleChecks1 = (TogglePickedChecks1)l.add((Component)new TogglePickedChecks1(), (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
        this.setPreferredSize(new Dimension(500, 350));
        this.loadChecks();
        Dimension prefSize = spChecks.getPreferredSize();
        JScrollBar sb = spChecks.getVerticalScrollBar();
        Dimension minSize = new Dimension(prefSize.width + sb.getPreferredSize().width, 50);
        spChecks.setMinimumSize(minSize);
    }

    public IterableIterator<CheckListItem> getChecks() {
        return AIterableItr.itr(this.mChecks.getList());
    }

    public boolean apply() {
        CheckOptionsPanel curPnl = this.getCurCheckOptionsPnl();
        if (curPnl == null) {
            return true;
        }
        return curPnl.apply();
    }

    protected void loadChecks() {
        DRC.CheckRegistry reg = DRC.getCheckRegistry();
        for (Class checkCls : reg.getChecks()) {
            try {
                DRC.Check c = (DRC.Check)checkCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.mChecks.addItem(new CheckListItem(c));
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error instantiating DRC Check '%s'.", (Object[])new Object[]{checkCls.getName()});
            }
        }
    }

    protected CheckOptionsPanel getCurCheckOptionsPnl() {
        JViewport vp = this.mRight.getViewport();
        if (vp.getComponentCount() == 0) {
            return null;
        }
        Component curRightComponent = vp.getComponent(0);
        if (curRightComponent instanceof CheckOptionsPanel) {
            return (CheckOptionsPanel)curRightComponent;
        }
        return null;
    }

    protected boolean getAllChecksPicked() {
        for (CheckListItem cli : this.mChecks.getList()) {
            if (cli.getIsSelected()) continue;
            return false;
        }
        return true;
    }

    protected boolean getAllChecksPicked1() {
        return this.mChecks.getItemAt(0).getIsSelected();
    }

    protected CheckOptionsPanel getCheckOptionsPanel(DRC.Check check) {
        return new CheckOptionsPanel(check);
    }

    public static class OptionUIEnum
    extends OptionUI {
        protected DRC.Option<Enum<?>> mOpt;
        protected JComboBox<Enum<?>> mCbo = new JComboBox();

        public OptionUIEnum(DRC.Option<Enum<?>> opt) {
            this.mOpt = opt;
            for (Enum<?> e : opt.getType().getEnumConstants()) {
                this.mCbo.addItem(e);
            }
            this.mCbo.setSelectedItem(opt.get());
        }

        @Override
        public JComponent getUIComponent() {
            return this.mCbo;
        }

        @Override
        public boolean validateAndStore() {
            this.mOpt.set((Enum)this.mCbo.getSelectedItem());
            return true;
        }
    }

    public static class OptionUIDouble
    extends OptionUI {
        protected DRC.Option<Double> mOpt;
        protected JTextField mTxt = new JTextField(10);
        protected JCheckBox mCbDoCheck = new JCheckBox();

        public OptionUIDouble(DRC.Option<Double> opt) {
            this.mCbDoCheck.setSelected(true);
            this.mOpt = opt;
            this.mTxt.setText(AUtil.doubleToString((double)this.mOpt.get()));
        }

        public boolean doCheck() {
            return this.mCbDoCheck == null || this.mCbDoCheck.isSelected();
        }

        @Override
        public JComponent getDoCheckUIComponent() {
            return this.mCbDoCheck;
        }

        @Override
        public JComponent getUIComponent() {
            return this.mTxt;
        }

        @Override
        public boolean validateAndStore() {
            try {
                String s = AFieldValidator.validateDouble((JTextField)this.mTxt);
                this.mOpt.set(AUtil.doubleFromString((String)s));
                return true;
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
        }
    }

    public static class OptionUIBoolean
    extends OptionUI {
        protected DRC.Option<Boolean> mOpt;
        protected JCheckBox mCb = new JCheckBox();

        public OptionUIBoolean(DRC.Option<Boolean> opt) {
            this.mOpt = opt;
            this.mCb.setSelected(opt.get());
        }

        @Override
        public JComponent getUIComponent() {
            return this.mCb;
        }

        @Override
        public boolean validateAndStore() {
            boolean newVal = this.mCb.isSelected();
            if (newVal != this.mOpt.get()) {
                this.mOpt.set(newVal);
            }
            return true;
        }
    }

    public static abstract class OptionUI {
        public abstract JComponent getUIComponent();

        public abstract boolean validateAndStore();

        public JComponent getDoCheckUIComponent() {
            return null;
        }
    }

    protected class TogglePickedChecks1
    extends JCheckBox
    implements ActionListener {
        protected TogglePickedChecks1() {
            this.addActionListener(this);
            this.setText("Just Selected");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    protected class TogglePickedChecks
    extends JCheckBox
    implements ActionListener {
        protected TogglePickedChecks() {
            this.addActionListener(this);
            this.setText("Select/deselect all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean pick = !DRCOptions.this.getAllChecksPicked();
            for (CheckListItem cli : DRCOptions.this.mChecks.getList()) {
                cli.setIsSelected(pick);
            }
            DRCOptions.this.mLstChecks.repaint();
        }

        @Override
        public void paint(Graphics g) {
            this.setSelected(DRCOptions.this.getAllChecksPicked());
            super.paint(g);
        }
    }

    protected class CheckListItem
    extends AList.AListItem {
        protected DRC.Check mCheck;

        public CheckListItem(DRC.Check check) {
            super(check.getName());
            this.mCheck = check;
        }

        public DRC.Check getCheck() {
            return this.mCheck;
        }
    }

    protected class CheckOptionsPanel
    extends JPanel {
        protected DRC.Check mCheck;
        protected BiMap<DRC.Option<?>, OptionUI> mOptions2UI = HashBiMap.create();

        public CheckOptionsPanel(DRC.Check check) {
            this.mCheck = check;
            DRC.Options options = check.getOptions();
            GridBagManager l = GridBagManager.layout((Container)this);
            if (options == null || options.isEmpty()) {
                l.add((Component)new JLabel("This check has no options."));
                l.addFillAll();
                return;
            }
            boolean first = true;
            for (DRC.Option opt : options) {
                OptionUI ui;
                if (first) {
                    first = false;
                } else {
                    l.newline();
                }
                if ((ui = opt.getUI()) == null) continue;
                if (ui.getDoCheckUIComponent() != null) {
                    l.add((Component)ui.getDoCheckUIComponent());
                }
                l.add(opt.getDesc() + ": ");
                l.add((Component)ui.getUIComponent());
                this.mOptions2UI.put((Object)opt, (Object)ui);
            }
            l.addFillAll();
        }

        public DRC.Check getCheck() {
            return this.mCheck;
        }

        public boolean apply() {
            DRC.Options options = this.mCheck.getOptions();
            if (options == null || options.isEmpty()) {
                return true;
            }
            for (DRC.Option opt : options) {
                OptionUI oui = (OptionUI)this.mOptions2UI.get((Object)opt);
                if (oui.validateAndStore()) continue;
                return false;
            }
            return true;
        }
    }

    protected static class CheckListRenderer
    extends AList.SelectFileCellRenderer<CheckListItem> {
        public CheckListRenderer(AList<CheckListItem> list) {
            super(list);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CheckListItem> list, CheckListItem value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            return this;
        }
    }

    protected class CheckedListener
    implements AList.CheckListener {
        protected CheckedListener() {
        }

        @Override
        public void checkChanged(AList.AListItem item) {
            DRCOptions.this.mToggleChecks.repaint();
        }
    }

    protected class CurrentCheckListener
    implements ListSelectionListener {
        protected CurrentCheckListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CheckListItem check = (CheckListItem)DRCOptions.this.mLstChecks.getSelectedValue();
            CheckOptionsPanel curPnl = DRCOptions.this.getCurCheckOptionsPnl();
            if (curPnl != null && curPnl.getCheck() == check) {
                return;
            }
            if (curPnl != null && !curPnl.apply()) {
                return;
            }
            DRCOptions.this.mRight.setViewportView(DRCOptions.this.getCheckOptionsPanel(check.getCheck()));
        }
    }
}

