/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ABoolean;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.AIFOut;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AIFExport {
    protected Db mDb;
    protected Design mDesign;
    protected Unit mUnit;
    protected DevicePath mPackagePath = null;
    protected ArrayList<DevicePath> mDiePaths = new ArrayList();
    protected File mFile = null;
    protected FileWriter mFileWriter;
    ArrayList<PadTemplate> mPadTemplateList = new ArrayList();
    static final String rotPadStackSuffix = "_rot";
    protected boolean mPrefer = true;
    protected long mWireDiameter = -1L;
    protected String mFileName;
    protected boolean mIsWYSIWYG = false;
    protected Sort mSort = Sort.DIEPADS_CCW;
    protected DevicePath mRefDevicePath = null;
    protected Device mRefDevice = null;
    protected APoint2D mRefCenter = new APoint2D();
    protected float mRefR = 0.0f;
    protected boolean mRefM = false;
    protected HashMap<Net, LinkedHashSet<HierPort>> mNetBalls = new HashMap();
    protected LinkedHashSet<HierPort> mBondFingers = new LinkedHashSet();
    static final Comparator<AifDiePad> Comparator_DiePinCCW = new Comparator<AifDiePad>(){

        @Override
        public int compare(AifDiePad hpa, AifDiePad hpb) {
            ALine la = hpa.getDiePinFromCenter();
            float aa = ATransformUtil.normRot((float)((float)la.getAngle() - 135.0f));
            ALine lb = hpb.getDiePinFromCenter();
            float ab = ATransformUtil.normRot((float)((float)lb.getAngle() - 135.0f));
            return Float.compare(aa, ab);
        }
    };

    public static boolean exportAIF(String filePath, String devicePathString, boolean isWYSIWYG, boolean sortDiePads) {
        String useOldExportPropKey = String.format("%s.UseOldAIFExport", OrbitIO.class.getName());
        String useOldExportPropVal = System.getProperty(useOldExportPropKey);
        if (ABoolean.fromString((String)useOldExportPropVal)) {
            ALog.logInfo((String)"Using old AIF export ('%s' system property is set).", (Object[])new Object[]{useOldExportPropKey});
            return AIFOut.exportAIF(filePath, devicePathString, isWYSIWYG, sortDiePads);
        }
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot export '%s', there is no current database.", (Object[])new Object[]{filePath});
            return false;
        }
        DevicePath path = DevicePath.fromString((Db)db, (String)devicePathString);
        AIFExport w = new AIFExport();
        w.setFilename(filePath);
        DevicePath pathToSubstrate = path.pathToSubstrate();
        DeviceTemplate.Type type = pathToSubstrate.getDeviceTemplate().getType();
        if (type == DeviceTemplate.Type.PACKAGE || type == DeviceTemplate.Type.INTERPOSER) {
            w.setPackage(devicePathString);
        } else if (type == DeviceTemplate.Type.DIE) {
            w.addDie(devicePathString);
        }
        w.setWYSIWYG(isWYSIWYG);
        w.setSortDiePads(sortDiePads ? Sort.DIEPADS_CCW : Sort.NONE);
        w.write();
        return true;
    }

    public AIFExport() {
        this.mDb = OrbitIO.getCurDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mUnit = this.mDesign == null ? Unit.IDENTITY : this.mDesign.getUnit();
    }

    public void setFilename(String val) {
        this.mFileName = val;
    }

    public void setPackage(String devicePath) {
        this.mPackagePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePath);
        if (this.mPackagePath == null) {
            ALog.logError((String)"The device path '%s' specified for the package is invalid.", (Object[])new Object[]{devicePath});
            return;
        }
        ALog.logInfo((String)("Package " + this.mPackagePath.toString() + " will be exported"));
        for (DevicePath path : this.mPackagePath.getDescendants()) {
            if (!path.getLast().getIsSubstrate() || path.getDeviceTemplate().getType() != DeviceTemplate.Type.DIE || path.getParent().getDeviceTemplate().getType() == DeviceTemplate.Type.DIE) continue;
            this.mDiePaths.add(path);
        }
        Collections.sort(this.mDiePaths);
        for (DevicePath path : this.mDiePaths) {
            ALog.logInfo((String)("Die " + path.toString() + " will be exported"));
        }
        this.setReferenceDevice(this.mPackagePath);
    }

    public void addDie(String devicePath) {
        DevicePath path = DevicePath.fromString((Db)this.mDb, (String)devicePath);
        if (path == null) {
            ALog.logError((String)"The device path '%s' specified for the die is invalid.", (Object[])new Object[]{devicePath});
            return;
        }
        this.mDiePaths.add(path);
        ALog.logInfo((String)("Die " + path.toString() + " will be exported"));
        this.setReferenceDevice(this.mDiePaths.get(0));
    }

    protected void setReferenceDevice(DevicePath path) {
        this.mRefDevicePath = path;
        if (this.mRefDevicePath != null) {
            this.mRefDevice = this.mRefDevicePath.getLast();
            this.mRefR = ATransformUtil.normRot((float)(360.0f - this.mRefDevicePath.getRot()));
            this.mRefM = this.mRefDevicePath.getMirror();
        }
    }

    public void setWYSIWYG(boolean isWYSIWYG) {
        this.mIsWYSIWYG = isWYSIWYG;
    }

    public void setSortDiePads(Sort sort) {
        this.mSort = sort;
    }

    public boolean write() {
        if (this.mFileName == null) {
            ALog.logError((String)"An output file must be specified.");
            return false;
        }
        if (this.mPackagePath == null && this.mDiePaths.size() == 0) {
            ALog.logError((String)"No output device was specified.");
            return false;
        }
        try {
            this.mFile = new File(this.mFileName);
            this.mFileWriter = new FileWriter(this.mFile);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Unable to open '%s' for writing.", (Object[])new Object[]{this.mFileName});
            return false;
        }
        if (!this.mIsWYSIWYG) {
            if (this.mRefR != 0.0f) {
                float newR = ATransformUtil.normRot((float)(this.mRefDevice.getRotate() + this.mRefR));
                this.mRefDevice.setRotate(newR);
            }
            if (this.mRefM) {
                this.mRefDevice.setMirror(false);
            }
        }
        this.mRefCenter = this.mRefDevicePath.getBB().center();
        ALog.logInfo((String)"Writing AIF data to '%s'", (Object[])new Object[]{this.mFileName});
        try {
            this.emitDataBase();
            this.emitDie();
            this.emitPackage();
            this.emitPads();
            this.emitNetList();
            this.emitWireWidth();
            this.mFileWriter.flush();
            this.mFileWriter.close();
            ALog.logInfo((String)"AIF output complete.", (Object[])new Object[]{this.mFileName});
            boolean newR = true;
            return newR;
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error writing AIF data to '%s'.", (Object[])new Object[]{this.mFileName});
            boolean bl = false;
            return bl;
        }
        finally {
            if (!this.mIsWYSIWYG) {
                if (this.mRefR != 0.0f) {
                    this.mRefDevice.setRotate(ATransformUtil.normRot((float)(this.mRefDevice.getRotate() - this.mRefR)));
                }
                if (this.mRefM) {
                    this.mRefDevice.setMirror(true);
                }
            }
        }
    }

    protected void emitWireWidth() throws IOException {
        if (this.mWireDiameter != -1L) {
            this.print("\n[WIRE]\nDIAMETER=" + this.toUser(this.mWireDiameter) + "\n", new Object[0]);
        }
    }

    protected boolean emitDataBase() throws IOException {
        this.print("[DATABASE]\n", new Object[0]);
        this.print("TYPE=AIF\n", new Object[0]);
        this.print("VERSION=2.0\n", new Object[0]);
        this.print("UNITS=UM\n", new Object[0]);
        if (this.mDiePaths.size() > 1) {
            Set dts;
            this.print("MCM=TRUE\n", new Object[0]);
            this.print("\n[MCM_DIE]\n", new Object[0]);
            HashMap<DeviceTemplate, ArrayList> dt2d = new HashMap<DeviceTemplate, ArrayList>();
            for (DevicePath dp : this.mDiePaths) {
                ArrayList devices;
                Device d = dp.getLast();
                DeviceTemplate dt = d.getTemplate();
                dts = dt2d.keySet();
                if (dts.contains(dt)) {
                    devices = (ArrayList)dt2d.get(dt);
                } else {
                    devices = new ArrayList();
                    dt2d.put(dt, devices);
                }
                devices.add(d);
            }
            dts = dt2d.keySet();
            if (dts.isEmpty()) {
                return true;
            }
            ArrayList<DeviceTemplate> sortedDts = new ArrayList<DeviceTemplate>();
            for (DeviceTemplate dt : dts) {
                sortedDts.add(dt);
            }
            Collections.sort(sortedDts);
            for (DeviceTemplate dt : sortedDts) {
                ArrayList devices = (ArrayList)dt2d.get(dt);
                if (devices.isEmpty()) continue;
                this.print(String.format("%s=", dt.getName()), new Object[0]);
                Collections.sort(devices);
                Device first = (Device)devices.get(0);
                for (Device d : devices) {
                    this.print(String.format(d == first ? "%s" : ", %s", d.getName()), new Object[0]);
                }
                this.print(String.format("\n", new Object[0]), new Object[0]);
            }
        }
        return true;
    }

    protected void emitDie() throws IOException {
        boolean multiDie;
        boolean bl = multiDie = this.mDiePaths.size() > 1;
        if (!multiDie) {
            this.print("\n[DIE]\n", new Object[0]);
        }
        for (DevicePath dp : this.mDiePaths) {
            Device d = dp.getLast();
            if (multiDie) {
                DeviceTemplate dt = d.getTemplate();
                this.print(String.format("\n[MCM_%s_%s]\n", dt.getName(), d.getName()), new Object[0]);
            } else {
                this.print("NAME=" + d.getName() + "\n", new Object[0]);
            }
            ARect bb = dp.getBB();
            APoint2D center = this.mPackagePath != null || dp != this.mDiePaths.get(0) ? bb.center().sub(this.mRefCenter) : new APoint2D();
            this.print("WIDTH=" + this.toUser(bb.width()) + "\n", new Object[0]);
            this.print("HEIGHT=" + this.toUser(bb.height()) + "\n", new Object[0]);
            this.print("CENTER=" + this.toUser(center.getX()) + " " + this.toUser(center.getY()) + "\n", new Object[0]);
        }
    }

    protected void emitPadStackForPackage() throws IOException {
        if (this.mPackagePath == null) {
            return;
        }
        int numGenerated = 0;
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (DevicePath devicePath : this.mPackagePath.getDescendants()) {
            Device p = devicePath.getLast();
            if (p.getSubstrate() == null || !p.getIsSubstrate() || p.getType() != DeviceTemplate.Type.PACKAGE) continue;
            for (PinInstance port : p.getPins()) {
                ARect r;
                PadTemplate pt;
                PinTemplate dtp = port.getPinTemplate();
                if (dtp.getType() != PinTemplate.Type.BALLPAD && dtp.getType() != PinTemplate.Type.BONDFINGERPAD && dtp.getType() != PinTemplate.Type.CONTACT || this.mPadTemplateList.contains(pt = port.getPinTemplate().getPadTemplate())) continue;
                ++numGenerated;
                this.mPadTemplateList.add(pt);
                String ptName = pt.getName();
                if (dtp.getType() == PinTemplate.Type.BALLPAD) {
                    r = port.getWorldBounds(devicePath);
                    lines.add((CallSite)((Object)(ptName + "=CIRCLE " + this.toUser(r.width()) + "\n")));
                    continue;
                }
                r = null;
                for (LayerShape ls : pt.getLayerShapes()) {
                    r = ls.getBounds();
                }
                if (r == null) continue;
                lines.add((CallSite)((Object)(ptName + "=OBLONG " + this.toUser(r.width()) + " " + this.toUser(r.height()) + "\n")));
            }
        }
        Collections.sort(lines);
        for (String string : lines) {
            this.print(string, new Object[0]);
        }
        String pWord = numGenerated == 1 ? " padstack" : " padstacks";
        ALog.logInfo((String)(" " + numGenerated + pWord + " generated for the package"));
        if (numGenerated == 0) {
            ALog.logInfo((String)"Perhaps there where no Pads of Type Ball Pad?");
        }
    }

    protected void emitPadStackforDie() throws IOException {
        int numGenerated = 0;
        ArrayList<String> lines = new ArrayList<String>();
        for (DevicePath dp : this.mDiePaths) {
            for (DevicePath childPath : dp.getDescendants()) {
                Device child = childPath.getLast();
                if (!child.getIsPlaced()) continue;
                List dps = child.getWireBondPins();
                for (PinInstance wbPort : dps) {
                    if (wbPort == null || !this.emitPadTemplates(dp, wbPort, lines)) continue;
                    ++numGenerated;
                }
            }
        }
        Collections.sort(lines);
        for (String line : lines) {
            this.print(line, new Object[0]);
        }
        String pWord = (numGenerated *= 2) == 1 ? " padstack" : " padstacks";
        ALog.logInfo((String)(" " + numGenerated + pWord + " generated for the die"));
        if (numGenerated == 0) {
            ALog.logInfo((String)"Perhaps there where no Pads of Wire Bond Pad?");
        }
    }

    private boolean emitPadTemplates(DevicePath path, PinInstance wbPort, ArrayList<String> lines) {
        PinTemplate dtp = wbPort.getPinTemplate();
        PadTemplate pt = dtp.getPadTemplate();
        if (pt == null || this.mPadTemplateList.contains(pt)) {
            return false;
        }
        this.mPadTemplateList.add(pt);
        String ptName = pt.getName();
        LinkedList<LayerShape> layerShapes = AIFExport.getSortedLayerShapes(pt, this.mPrefer);
        LayerShape last = layerShapes.getLast();
        Layer topLayer = last.getLayer();
        int lsIdx = -1;
        for (LayerShape ls : layerShapes) {
            String outPtName;
            ++lsIdx;
            Layer layer = ls.getLayer();
            if (layer != topLayer) continue;
            AffineTransform xform = wbPort.getWorldTransform(path);
            AGeom s = ls.getGeom().transform(xform);
            if (s == null) continue;
            String string = outPtName = lsIdx == 0 ? ptName : ptName + "_" + Integer.toString(lsIdx);
            if (s instanceof ACircle) {
                ACircle c = (ACircle)s;
                lines.add(outPtName + "=CIRCLE " + this.toUser(c.getD()) + "\n");
                lines.add(outPtName + "_rot=CIRCLE " + this.toUser(c.getD()) + "\n");
                continue;
            }
            if (s instanceof APolygon) {
                APolygon poly = (APolygon)s;
                StringBuilder sb = new StringBuilder(String.format("%d %d %d", 1, 0, poly.getPointCount()));
                for (APoint2D p : poly.getPoints()) {
                    sb.append(" " + this.toUser(p.getX()) + " " + this.toUser(p.getY()));
                }
                lines.add(outPtName + "=POLYGON " + sb.toString() + "\n");
                lines.add(outPtName + "_rot=POLYGON " + sb.toString() + "\n");
                continue;
            }
            ARect r = s.getBounds();
            lines.add(outPtName + "=RECT " + this.toUser(r.width()) + " " + this.toUser(r.height()) + "\n");
            lines.add(outPtName + "_rot=RECT " + this.toUser(r.height()) + " " + this.toUser(r.width()) + "\n");
        }
        return true;
    }

    protected void emitPads() throws IOException {
        this.print("\n[PADS]\n", new Object[0]);
        this.emitPadStackforDie();
        this.emitPadStackForPackage();
    }

    protected void emitPackage() throws IOException {
        if (this.mPackagePath == null) {
            return;
        }
        this.print("\n[BGA]\n", new Object[0]);
        Device aPackage = this.mPackagePath.getLast();
        this.print("NAME=" + aPackage.getName() + "\n", new Object[0]);
        ARect r = this.mIsWYSIWYG ? aPackage.getLocalBB() : aPackage.getUntransformedShape().getBounds();
        this.print("WIDTH=" + this.toUser(r.width()) + "\n", new Object[0]);
        this.print("HEIGHT=" + this.toUser(r.height()) + "\n", new Object[0]);
    }

    protected void emitNetList() throws IOException {
        this.createBallAndBFList();
        boolean wroteHeader = false;
        if (this.mDiePaths.size() > 0) {
            this.print("\n[NETLIST]\n", new Object[0]);
            this.print(";NETNAME \tDIE_PAD# \tDIE_PADSTACK_NAME \tDIE_PAD_X \tDIE_PAD_Y \tBALL# \tBALL_PADSTACK_NAME \tBALL_X \tBALL_Y \tFIN# \tTYPE \tFIN_X    \tFIN_Y    \tANGLE\n", new Object[0]);
            wroteHeader = true;
        }
        for (DevicePath dp : this.mDiePaths) {
            LinkedList<AifDiePad> aifNets = new LinkedList<AifDiePad>();
            for (DevicePath childPath : dp.getDescendants()) {
                Device child = childPath.getLast();
                if (!child.getIsPlaced()) continue;
                ArrayList<PinTemplate> pins = new ArrayList<PinTemplate>();
                block5: for (PinTemplate pin : child.getTemplate().getPins()) {
                    switch (pin.getType()) {
                        case WIREBONDPAD: 
                        case BUMPPAD: 
                        case CONTACT: {
                            break;
                        }
                        default: {
                            continue block5;
                        }
                    }
                    pins.add(pin);
                }
                Collections.sort(pins, (a, b) -> AAlphaNumComp.get().compare((Object)a.getName(), (Object)b.getName()));
                for (PinTemplate pin : pins) {
                    for (PortTemplate diePort : pin.getPortTemplates()) {
                        aifNets.add(new AifDiePad(new HierPort(childPath, diePort)));
                    }
                }
            }
            ALog.logInfo((String)"Writing %d NETLIST die pad entries.", (Object[])new Object[]{aifNets.size()});
            if (this.mSort != null && this.mSort.getDiePadComparator() != null) {
                Collections.sort(aifNets, this.mSort.getDiePadComparator());
            }
            int pinNum = 0;
            for (AifDiePad aifNet : aifNets) {
                this.writeNetLine(++pinNum, aifNet);
            }
        }
        if (this.mPackagePath != null) {
            if (!wroteHeader) {
                this.print("\n[NETLIST]\n", new Object[0]);
                this.print(";NETNAME \tDIE_PAD# \tDIE_PADSTACK_NAME \tDIE_PAD_X \tDIE_PAD_Y \tBALL# \tBALL_PADSTACK_NAME \tBALL_X \tBALL_Y\n", new Object[0]);
                wroteHeader = true;
            }
            this.emitUnusedBallsandBFS(this.mPackagePath);
        }
    }

    protected void writeNetLine(int pinNum, AifDiePad aifNet) throws IOException {
        this.print("%s\t%d\t%s\t%s\t%s", aifNet.getNetName(), pinNum, aifNet.getDiePTName(), aifNet.getDiePinX(), aifNet.getDiePinY());
        this.print("\t%s\t%s\t%s\t%s", aifNet.getBallName(), aifNet.getBallPTName(), aifNet.getBallX(), aifNet.getBallY());
        if (aifNet.getBondFinger() != null) {
            this.print("%s\t%s\t%s\t%s\t%s", aifNet.getBFName(), aifNet.getBFPTName(), aifNet.getBFX(), aifNet.getBFY(), aifNet.getBFRot());
        }
        this.print("\n", new Object[0]);
    }

    protected void createBallAndBFList() {
        if (this.mPackagePath == null) {
            return;
        }
        for (DevicePath childPath : this.mPackagePath.getDescendants()) {
            Device device = childPath.getLast();
            DevicePath pathToSubstrate = childPath.pathToSubstrate();
            DeviceTemplate dt = pathToSubstrate.getDeviceTemplate();
            if (dt.getType() == DeviceTemplate.Type.DIE || device.getTemplate().getType() == DeviceTemplate.Type.CONTACT_DEVICE) continue;
            for (PinInstance pin : device.getPins()) {
                PinTemplate pinT = pin.getPinTemplate();
                PinTemplate.Type pinType = pinT.getType();
                if (pinType == PinTemplate.Type.BALLPAD || pinType == PinTemplate.Type.BUMPPAD) {
                    for (PortTemplate port : pinT.getPortTemplates()) {
                        LinkedHashSet<Object> list;
                        HierPort ball = new HierPort(childPath, port);
                        Net netOnPkg = NetMap.getNetAt((Net)pinT.getNet(), (DevicePath)childPath, (DeviceTemplate)this.mPackagePath.getDeviceTemplate());
                        if (netOnPkg == null) {
                            netOnPkg = this.mPackagePath.getDeviceTemplate().getNetUnused();
                        }
                        if ((list = this.mNetBalls.get(netOnPkg)) == null) {
                            list = new LinkedHashSet();
                            this.mNetBalls.put(netOnPkg, list);
                        }
                        list.add(ball);
                    }
                    continue;
                }
                if (pinType != PinTemplate.Type.BONDFINGERPAD) continue;
                for (PortTemplate port : pinT.getPortTemplates()) {
                    this.mBondFingers.add(new HierPort(childPath, port));
                }
                if (this.mWireDiameter != -1L) continue;
                Wire w = BondFingerUtil.getWireBond((PinTemplate)pinT);
                this.mWireDiameter = w.getWidth();
            }
        }
    }

    protected void emitUnusedBallsandBFS(DevicePath packagePath) throws IOException {
        String netName;
        LinkedList nets = AUtil.linkedList(this.mNetBalls.keySet());
        Collections.sort(nets);
        for (Net n : nets) {
            LinkedHashSet<HierPort> balls = this.mNetBalls.get(n);
            if (balls == null || balls.size() == 0) continue;
            netName = n.getName();
            LinkedList sortedBalls = AUtil.linkedList(balls);
            Collections.sort(sortedBalls);
            for (HierPort ball : sortedBalls) {
                String ballName = ball.getPinTemplate().getName();
                PadTemplate pt = ball.getPadTemplate();
                String ptName = pt == null ? "-" : pt.getName();
                APoint2D wloc = ball.getWorldLoc();
                wloc = this.exportXForm(wloc);
                long x = wloc.getX();
                long y = wloc.getY();
                this.print(netName + "\t-\t-\t-\t-\t" + ballName + "\t" + ptName + "\t" + this.toUser(x) + "\t" + this.toUser(y) + "\n", new Object[0]);
            }
        }
        LinkedList unusedBondFingers = AUtil.linkedList(this.mBondFingers);
        Collections.sort(unusedBondFingers);
        for (HierPort bf : unusedBondFingers) {
            netName = bf.getTopMostNet().getName();
            String bfName = bf.getPath().getLast().getName();
            PadTemplate pt = bf.getPadTemplate();
            String ptName = pt == null ? "-" : pt.getName();
            APoint2D wloc = bf.getWorldLoc();
            wloc = this.exportXForm(wloc);
            long x = wloc.getX();
            long y = wloc.getY();
            float r = ATransformUtil.normRot((float)(360.0f - bf.getPath().getRot()));
            this.print(netName + "\t-\t-\t-\t-\t-\t-\t-\t-\t" + bfName + "\t" + ptName + "\t" + this.toUser(x) + "\t" + this.toUser(y) + "\t" + r + "\n", new Object[0]);
        }
    }

    protected String toUser(long world) {
        return "" + this.mUnit.toUser(world);
    }

    protected boolean print(String fmt, Object ... args) throws IOException {
        String s = String.format(fmt, args);
        this.mFileWriter.write(s);
        return true;
    }

    private APoint2D exportXForm(APoint2D loc) {
        return loc.sub(this.mRefCenter);
    }

    public static LinkedList<LayerShape> getSortedLayerShapes(PadTemplate pt, boolean preferredOnly) {
        if (preferredOnly || !pt.hasPreferredAttachment()) {
            preferredOnly = false;
        }
        LinkedList<LayerShape> layerShapes = new LinkedList<LayerShape>();
        for (LayerShape ls : pt.getLayerShapes()) {
            if (preferredOnly && !ls.isPreferredAttachment()) continue;
            layerShapes.add(ls);
        }
        Collections.sort(layerShapes);
        return layerShapes;
    }

    class portPathPair
    implements Comparable<portPathPair> {
        PinInstance port;
        DevicePath path;

        portPathPair(PinInstance port, DevicePath path) {
            this.port = port;
            this.path = path;
        }

        public DevicePath getPath() {
            return this.path;
        }

        public PinInstance getPort() {
            return this.port;
        }

        @Override
        public int compareTo(portPathPair o) {
            return o.getPort().getName().compareTo(this.getPort().getName());
        }
    }

    protected class AifDiePad {
        protected HierPort mDiePin;
        protected boolean mConnInit = false;
        protected HierPort mBondFinger;
        protected HierPort mBall;
        protected ALine mDiePinFromCenter = null;

        public AifDiePad(HierPort diePin) {
            assert (diePin != null);
            this.mDiePin = diePin;
        }

        public HierPort getDiePin() {
            return this.mDiePin;
        }

        public HierPort getBondFinger() {
            this.populateConnectionsIfNeeded();
            return this.mBondFinger;
        }

        public HierPort getBall() {
            this.populateConnectionsIfNeeded();
            return this.mBall;
        }

        public APoint2D getDiePinLoc() {
            return this.mDiePin.getSubstrateLoc();
        }

        public Net getTopNet() {
            return NetMap.getTopmostNet((Net)this.mDiePin.getNet(), (DevicePath)this.mDiePin.getPath());
        }

        public String getNetName() {
            return this.mDiePin.getTopMostNet().getName();
        }

        public String getDiePTName() {
            float rotation = Device.getRotRelativeToSubstrate((DevicePath)this.mDiePin.getPath());
            PadTemplate padT = this.mDiePin.getPadTemplate();
            String suffix = rotation == 0.0f || rotation == 180.0f ? "" : AIFExport.rotPadStackSuffix;
            return padT == null ? "-" : padT.getName() + suffix;
        }

        public String getDiePinX() {
            return AIFExport.this.toUser(AIFExport.this.exportXForm(this.mDiePin.getWorldLoc()).getX());
        }

        public String getDiePinY() {
            return AIFExport.this.toUser(AIFExport.this.exportXForm(this.mDiePin.getWorldLoc()).getY());
        }

        public String getBallName() {
            this.populateConnectionsIfNeeded();
            if (this.mBall == null) {
                return "-";
            }
            return this.mBall.getPinTemplate().getName();
        }

        public String getBallPTName() {
            this.populateConnectionsIfNeeded();
            if (this.mBall == null) {
                return "-";
            }
            PadTemplate padT = this.mBall.getPadTemplate();
            return padT == null ? "-" : padT.getName();
        }

        public String getBallX() {
            this.populateConnectionsIfNeeded();
            if (this.mBall == null) {
                return "-";
            }
            return AIFExport.this.toUser(AIFExport.this.exportXForm(this.mBall.getWorldLoc()).getX());
        }

        public String getBallY() {
            this.populateConnectionsIfNeeded();
            if (this.mBall == null) {
                return "-";
            }
            return AIFExport.this.toUser(AIFExport.this.exportXForm(this.mBall.getWorldLoc()).getY());
        }

        public String getBFName() {
            this.populateConnectionsIfNeeded();
            if (this.mBondFinger == null) {
                return "-";
            }
            return this.mBondFinger.getPath().getLast().getName();
        }

        public String getBFPTName() {
            this.populateConnectionsIfNeeded();
            if (this.mBondFinger == null) {
                return "-";
            }
            PadTemplate padT = this.mBondFinger.getPadTemplate();
            return padT == null ? "-" : padT.getName();
        }

        public String getBFX() {
            this.populateConnectionsIfNeeded();
            if (this.mBondFinger == null) {
                return "-";
            }
            return AIFExport.this.toUser(AIFExport.this.exportXForm(this.mBondFinger.getWorldLoc()).getX());
        }

        public String getBFY() {
            this.populateConnectionsIfNeeded();
            if (this.mBondFinger == null) {
                return "-";
            }
            return AIFExport.this.toUser(AIFExport.this.exportXForm(this.mBondFinger.getWorldLoc()).getY());
        }

        public String getBFRot() {
            this.populateConnectionsIfNeeded();
            if (this.mBondFinger == null) {
                return "-";
            }
            return "" + ATransformUtil.normRot((float)(360.0f - this.mBondFinger.getPath().getRot()));
        }

        public ALine getDiePinFromCenter() {
            if (this.mDiePinFromCenter == null) {
                DevicePath die = this.mDiePin.getPath();
                Substrate substrateA = die.getSubstrate();
                die = die.pathToParent(substrateA);
                APoint2D dieCenterA = die.getLast().getBounds().center();
                this.mDiePinFromCenter = new ALine(dieCenterA, this.getDiePinLoc());
            }
            return this.mDiePinFromCenter;
        }

        protected void populateConnectionsIfNeeded() {
            if (this.mConnInit) {
                return;
            }
            this.mConnInit = true;
            if (AIFExport.this.mPackagePath != null) {
                LinkedHashSet<HierPort> balls;
                Net netOnPkg;
                PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)AIFExport.this.mDesign, (PinInstance)this.mDiePin.getPin());
                if (bf != null) {
                    this.mBondFinger = new HierPort(AIFExport.this.mPackagePath, bf.getFirstPortTemplate());
                    AIFExport.this.mBondFingers.remove(this.mBondFinger);
                }
                if ((netOnPkg = NetMap.getNetAt((Net)this.mDiePin.getNet(), (DevicePath)this.mDiePin.getPath(), (DeviceTemplate)AIFExport.this.mPackagePath.getDeviceTemplate())) != null && !netOnPkg.isUnused() && (balls = AIFExport.this.mNetBalls.get(netOnPkg)) != null && balls.size() > 0 && balls.size() < 3) {
                    this.mBall = (HierPort)balls.iterator().next();
                    balls.remove(this.mBall);
                }
            }
        }
    }

    public static enum Sort {
        NONE("None", null),
        DIEPADS_CCW("Die Pads (CCW)", Comparator_DiePinCCW);

        protected String mUserName;
        protected Comparator<AifDiePad> mDiePadComparator;

        private Sort(String userName, Comparator<AifDiePad> diePadComparator) {
            this.mUserName = userName;
            this.mDiePadComparator = diePadComparator;
        }

        public String getUserName() {
            return this.mUserName;
        }

        public Comparator<AifDiePad> getDiePadComparator() {
            return this.mDiePadComparator;
        }
    }
}

