/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.google.common.collect.Maps;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.RecDecParser;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.PartFactory;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class AIFIn
extends RecDecParser {
    public static final String FILEEXT_AIF = "aif";
    protected Db mDb = null;
    protected boolean mParseState = true;
    protected double mUnits = 1000.0;
    protected boolean mJustPackage = false;
    protected HashMap<String, Device> mDieName2Die = Maps.newLinkedHashMap();
    protected HashMap<PinInstance, String> mDiePin2NetName = Maps.newHashMap();
    protected Device mPackage = null;
    protected ArrayList<PadDef> padDefs = new ArrayList();
    protected LinkedList<String> mAIFSections = AUtil.linkedList((Object[])new String[]{"[DATABASE]", "[DIE]", "[BGA]", "[PADS]", "[NETLIST]", "[MCM_DIE]"});
    protected MCMSpecs mMCMSpecs = null;

    public static boolean importAIF(String filePath) {
        AIFIn aifIn = new AIFIn();
        aifIn.read(OrbitIO.getCurDb(), filePath);
        return true;
    }

    public static boolean importAIF(String filePath, boolean justPackage) {
        AIFIn aifIn = new AIFIn();
        aifIn.read(OrbitIO.getCurDb(), filePath, justPackage);
        return true;
    }

    public boolean read(Db db, String fileName) {
        return this.read(db, fileName, false);
    }

    public boolean read(Db db, String fileName, boolean justPackage) {
        this.mDb = db;
        this.mUnits = Design.getUnit((Db)db).getUnitPerUser();
        this.mJustPackage = justPackage;
        this.mDb.setListenersEnabled(false);
        this.mDb.setHistoryEnabled(false);
        ALog.logInfo((String)"Beginning to import AIF '%s'.", (Object[])new Object[]{fileName});
        if (!this.setInFile(fileName)) {
            ALog.logError((String)"Can not open file '%s'.", (Object[])new Object[]{fileName});
            return false;
        }
        try {
            this.parse();
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error reading file near line %d", (Object[])new Object[]{this.mCurLine});
            this.mParseState = false;
        }
        if (this.mParseState) {
            ALog.logInfo((String)"Done importing AIF '%s'.", (Object[])new Object[]{fileName});
        }
        this.postProcess();
        this.mDb.setHistoryEnabled(true);
        this.mDb.setListenersEnabled(true);
        this.closeFile();
        DbExplorerPanel.refreshAll();
        return true;
    }

    protected boolean isMCM() {
        return this.mMCMSpecs != null;
    }

    protected void parse() {
        this.mParseState = true;
        String foundString = this.parseKeywords(this.mAIFSections);
        while (foundString != null) {
            if (foundString.equals("[DATABASE]")) {
                this.doDataBase();
            } else if (foundString.equals("[DIE]") && !this.isMCM()) {
                this.doDie("", "");
            } else if (foundString.equals("[BGA]")) {
                this.doBGA();
            } else if (foundString.equals("[NETLIST]")) {
                this.doNetList();
            } else if (foundString.equals("[PADS]")) {
                this.doPadList();
            } else if (foundString.equals("[MCM_DIE]")) {
                this.doMCMList();
            } else if (this.mMCMSpecs != null && this.mMCMSpecs.getBySection(foundString) != null) {
                this.parseMCMDie(foundString);
            }
            if (this.mParseState) {
                foundString = this.parseKeywords(this.mAIFSections);
                continue;
            }
            return;
        }
    }

    protected void parseMCMDie(String section) {
        MCMSpec mcmSpec = this.mMCMSpecs.getBySection(section);
        if (mcmSpec == null) {
            assert (mcmSpec != null);
            return;
        }
        this.doDie(mcmSpec.getPkgName(), mcmSpec.getRefDes());
    }

    protected void doDataBase() {
        List<String> Kewords = List.of("TYPE", "UNITS", "VERSION", "MCM", "[");
        String foundString = this.parseKeywords(Kewords);
        String units = "";
        while (foundString != null) {
            if (foundString.equals("UNITS")) {
                Design design = Design.getDesign((Db)this.mDb);
                long internalPerMicron = design == null ? Design.getDefaultUnitDistDbuCount() : design.getInternalPerMicron();
                units = this.equalsAString();
                if (units.equals("UM")) {
                    this.mUnits = 1.0 * (double)internalPerMicron;
                }
            } else if (foundString.equals("TYPE")) {
                this.equalsAString();
            } else if (foundString.equals("VERSION")) {
                this.equalsAString();
            } else if (foundString.equals("MCM")) {
                String isMCM = this.equalsAString();
                if (isMCM.equals("TRUE")) {
                    this.mMCMSpecs = new MCMSpecs();
                    ALog.logInfo((String)"MCM detected.");
                }
            } else if (foundString.equals("[")) {
                this.restoreState();
                break;
            }
            this.saveState();
            foundString = this.parseKeywords(Kewords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDie(String templateName, String name) {
        List<String> Kewords = List.of("WIDTH", "HEIGHT", "NAME", "CENTER", "[");
        String foundString = this.parseKeywords(Kewords);
        long width = 0L;
        long height = 0L;
        APoint2D center = new APoint2D();
        while (foundString != null) {
            if (foundString.equals("WIDTH")) {
                width = (long)(this.equalsANumber() * this.mUnits);
            } else if (foundString.equals("HEIGHT")) {
                height = (long)(this.equalsANumber() * this.mUnits);
            } else if (foundString.equals("NAME")) {
                if (name == null || name.isEmpty()) {
                    name = this.equalsAString();
                }
            } else if (foundString.equals("CENTER")) {
                center = this.equalsAPoint();
            } else {
                this.restoreState();
                break;
            }
            this.saveState();
            foundString = this.parseKeywords(Kewords);
        }
        if (width > 0L && height > 0L && name != null && !name.isEmpty() && !this.mJustPackage) {
            PartFactory.mQuiet = true;
            try {
                Device d = templateName == null || templateName.isEmpty() ? PartFactory.makeDie(name + "template", name, width, height, 0, 0, 0, 0, 0L, 0L) : PartFactory.makeDie(templateName, name, width, height, 0, 0, 0, 0, 0L, 0L, false);
                d.getTemplate().setSourceType(DeviceTemplate.SourceType.AIF);
                d.getTemplate().setSourceFile(this.mFile.getAbsolutePath());
                this.mDieName2Die.put(d.getName(), d);
                d.setLoc(center);
            }
            finally {
                PartFactory.mQuiet = false;
            }
        }
    }

    protected void doMCMList() {
        boolean moreLines = true;
        while (moreLines) {
            this.saveState();
            boolean more = this.popLine();
            if (!more) {
                this.mParseState = false;
                return;
            }
            String line = this.getParsedTerminal();
            if (line.isEmpty()) {
                return;
            }
            if (line.charAt(0) == '[') {
                this.restoreState();
                return;
            }
            int equalsPos = line.indexOf(61);
            if (equalsPos == -1) {
                this.restoreState();
                return;
            }
            String packageName = line.substring(0, equalsPos).trim();
            String refDesignators = line.substring(equalsPos + 1);
            String splitOn = refDesignators.contains(",") ? "," : " ";
            for (String refDes : refDesignators.split(splitOn)) {
                MCMSpec spec = this.mMCMSpecs.put(packageName, refDes.trim());
                this.mAIFSections.add(spec.getSection());
            }
        }
    }

    protected void doBGA() {
        List<String> Kewords = List.of("WIDTH", "HEIGHT", "NAME", "[PADS]");
        int now = this.saveState();
        String foundString = this.parseKeywords(Kewords);
        long width = 0L;
        long height = 0L;
        String name = "";
        while (foundString != null) {
            if (foundString.equals("[PADS]")) {
                this.restoreState();
                return;
            }
            if (foundString.equals("WIDTH")) {
                width = (long)(this.equalsANumber() * this.mUnits);
                if (height > 0L && !name.isEmpty()) {
                    break;
                }
            } else if (foundString.equals("HEIGHT")) {
                height = (long)(this.equalsANumber() * this.mUnits);
                if (width > 0L && !name.isEmpty()) {
                    break;
                }
            } else if (foundString.equals("NAME")) {
                name = this.equalsAString();
                if (height > 0L && width > 0L) break;
            }
            foundString = this.parseKeywords(Kewords);
        }
        if (width > 0L && height > 0L && !name.isEmpty()) {
            Device d = PartFactory.makePackage(name + "template", name, false, width, height, 0, 0, 0, 0, 0, 0L, 0L, 0L, AGeomUtil.CompassCorners.NE, null);
            Object sn = name + "_Substrate";
            if (!((String)sn).startsWith("AIF_")) {
                sn = "AIF_" + (String)sn;
            }
            sn = Substrate.getUniqueName((Db)d.getDb(), (String)sn);
            d.getSubstrate().setName((String)sn);
            d.getTemplate().setSourceType(DeviceTemplate.SourceType.AIF);
            d.getTemplate().setSourceFile(this.mFile.getAbsolutePath());
            this.mPackage = d;
        } else {
            this.restoreState(now);
        }
    }

    protected void doPadList() {
        boolean moreLines = true;
        while (moreLines) {
            this.saveState();
            this.popLine();
            String line = this.getParsedTerminal();
            if (line.charAt(0) == ';') continue;
            if (line.charAt(0) == '[') {
                this.restoreState();
                return;
            }
            if (line.length() > 0) {
                this.doPadLine(line);
                if (this.mParseState) continue;
                moreLines = false;
                this.restoreState();
                continue;
            }
            moreLines = false;
        }
    }

    protected void doNetList() {
        boolean moreLines = true;
        while (moreLines) {
            this.saveState();
            boolean more = this.popLine();
            if (!more) {
                this.mParseState = false;
                return;
            }
            String line = this.getParsedTerminal();
            if (line.charAt(0) == '[') {
                this.restoreState();
                return;
            }
            if (line.charAt(0) == ';' || line.length() <= 0) continue;
            this.doNetListLine(line);
            if (this.mParseState) continue;
            moreLines = false;
            this.restoreState();
        }
    }

    protected void doNetListLine(String originalLine) {
        Device die;
        String dieName;
        int idxDot;
        String line = originalLine.replaceAll("\t", " ");
        StringTokenizer st = new StringTokenizer(line);
        ArrayList<String> v = new ArrayList<String>();
        int tokenCount = st.countTokens();
        for (int i = 0; i < tokenCount; ++i) {
            v.add(i, st.nextToken());
        }
        if (tokenCount < 5) {
            ALog.logInfo((String)"Invalid NETLIST line near %d:\n\t", (Object[])new Object[]{this.mCurLine, originalLine});
            return;
        }
        String netName = (String)v.get(0);
        if (netName.length() == 0 || netName.equals("-") || netName.equals("NetUnused")) {
            netName = null;
        }
        String dPadNum = (String)v.get(1);
        String dPadType = (String)v.get(2);
        String dPadX = (String)v.get(3);
        String dPadY = (String)v.get(4);
        if (!dPadType.equals("-") && this.mDieName2Die.size() > 0) {
            if (this.isMCM()) {
                idxDot = dPadNum.indexOf(46);
                if (idxDot <= 0) {
                    ALog.logError((String)"Invalid die name specified for die pad near line %d, the line is being ignored.", (Object[])new Object[]{this.mCurLine});
                    return;
                }
                dieName = dPadNum.substring(0, idxDot);
                dPadNum = dPadNum.substring(idxDot + 1);
                die = this.getDieByName(dieName);
                if (die != null) {
                    this.doDiePad(die, netName, dPadNum, dPadType, dPadX, dPadY);
                } else {
                    ALog.logWarn((String)"NETLIST references unknown die '%s' near line %d, ignoring.", (Object[])new Object[]{dieName, this.mCurLine});
                }
            } else {
                this.doDiePad(this.getFirstDie(), netName, dPadNum, dPadType, dPadX, dPadY);
            }
        }
        if (tokenCount < 6) {
            return;
        }
        if (this.isMCM()) {
            dPadNum = (String)v.get(5);
            dPadType = (String)v.get(6);
            dPadX = (String)v.get(7);
            dPadY = (String)v.get(8);
            if (!dPadType.equals("-") && this.mDieName2Die.size() > 0 && (idxDot = dPadNum.indexOf(46)) >= 0) {
                dieName = dPadNum.substring(0, idxDot);
                dPadNum = dPadNum.substring(idxDot + 1);
                die = this.getDieByName(dieName);
                if (die != null) {
                    this.doDiePad(die, netName, dPadNum, dPadType, dPadX, dPadY);
                    return;
                }
            }
        }
        String bPadName = (String)v.get(5);
        String bPadType = (String)v.get(6);
        String bPadX = (String)v.get(7);
        String bPadY = (String)v.get(8);
        if (!bPadType.equals("-") && this.mPackage != null) {
            this.doPackagePad(netName, bPadName, bPadType, bPadX, bPadY);
        }
    }

    protected Device getFirstDie() {
        return this.mDieName2Die.values().iterator().next();
    }

    protected Device getDieByName(String name) {
        return this.mDieName2Die.get(name);
    }

    protected PadDef getPadDef(String name) {
        for (PadDef pd : this.padDefs) {
            if (!pd.name.equals(name)) continue;
            return pd;
        }
        ALog.logWarn((String)("Pad Template " + name + " Can not be found"));
        return this.padDefs.get(0);
    }

    protected void doPackagePad(String netName, String pinName, String padName, String padX, String padY) {
        DeviceTemplate packageT = this.mPackage.getTemplate();
        Net net = netName == null ? packageT.getNetUnused() : Net.getOrCreate((DeviceTemplate)packageT, (String)netName);
        PinTemplate pinT = packageT.getPinByName(pinName);
        if (pinT == null) {
            pinT = PinTemplate.create((Net)net, (String)pinName);
            PadTemplate padT = PadTemplate.get((Db)this.mDb, (Substrate)this.mPackage.getSubstrate(), (String)padName);
            if (padT == null) {
                padT = PadTemplate.create((Db)this.mDb, (Substrate)this.mPackage.getSubstrate(), (String)padName);
                PadDef pd = this.getPadDef(padName);
                AGeom g = this.createPadShape(pd);
                Layer ballLayer = this.mPackage.getSubstrate().getLayer("Ball");
                if (ballLayer == null) {
                    ballLayer = Layer.create((Substrate)this.mPackage.getSubstrate(), (String)"Ball");
                }
                LayerShape.create((Db)this.mDb, (Layer)ballLayer, (DbObject)padT, (AGeom)g);
                ballLayer.setHeight(-g.getBounds().width());
            }
            pinT.setPadTemplate(padT);
            pinT.setType(PinTemplate.Type.BALLPAD);
            APoint2D loc = new APoint2D((long)(Double.parseDouble(padX) * this.mUnits), (long)(Double.parseDouble(padY) * this.mUnits));
            pinT.setLoc(loc);
            PinInstance.getPinInstance((Device)this.mPackage, (PinTemplate)pinT);
        }
    }

    protected void doDiePad(Device die, String netName, String pinName, String dPadName, String dPadX, String dPadY) {
        if (this.mJustPackage) {
            return;
        }
        DeviceTemplate deviceT = die.getTemplate();
        long x = (long)(Double.parseDouble(dPadX) * this.mUnits);
        long y = (long)(Double.parseDouble(dPadY) * this.mUnits);
        APoint2D pkgCenter = this.mPackage != null ? this.mPackage.center() : new APoint2D();
        APoint2D loc = new APoint2D(x -= die.center().getX() - pkgCenter.getX(), y -= die.center().getY() - pkgCenter.getY());
        PinTemplate pinT = deviceT.getPinByName(pinName);
        if (pinT == null) {
            pinT = PinTemplate.create((Net)deviceT.getNetUnused(), (String)pinName);
            pinT.setLoc(loc);
            pinT.setType(PinTemplate.Type.WIREBONDPAD);
            PadTemplate pt = PadTemplate.get((Db)this.mDb, (Substrate)die.getSubstrate(), (String)dPadName);
            if (pt == null) {
                pt = PadTemplate.create((Db)this.mDb, (Substrate)die.getSubstrate(), (String)dPadName);
                PadDef pd = this.getPadDef(dPadName);
                AGeom g = this.createPadShape(pd);
                LayerShape.create((Db)this.mDb, (Layer)die.getSubstrate().getM1(), (DbObject)pt, (AGeom)g);
            }
            pinT.setPadTemplate(pt);
        }
        PinInstance pin = PinInstance.getPinInstance((Device)die, (PinTemplate)pinT);
        try {
            int pinNum = Integer.parseInt(pinName);
            pin.setPinNum(pinNum);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.mDiePin2NetName.containsKey(pin)) {
            ALog.logWarn((String)"Duplicate NETLIST entry specified for die '%s' pin '%s' near line %d is being ignored.", (Object[])new Object[]{die.getName(), pinName, this.mCurLine});
        } else {
            this.mDiePin2NetName.put(pin, netName);
        }
    }

    protected AGeom createPadShape(PadDef pd) {
        if (pd.type.equals("RECTANGLE") || pd.type.equals("RECT")) {
            long wPin = (long)(pd.d1 * this.mUnits);
            long hPin = (long)(pd.d2 * this.mUnits);
            ARect rpad = new ARect(0L, 0L, wPin, hPin);
            rpad.moveCenterTo(0L, 0L);
            return rpad;
        }
        if (pd.type.equals("CIRCLE")) {
            long wPin = (long)(pd.d1 * this.mUnits);
            return new ACircle(0L, 0L, wPin / 2L);
        }
        if (pd.type.equals("SQUARE")) {
            long wPin = (long)(pd.d1 * this.mUnits);
            ARect rpad = new ARect(0L, 0L, wPin, wPin);
            rpad.moveCenterTo(0L, 0L);
            return rpad;
        }
        if (pd.type.equals("POLY") || pd.type.equals("POLYGON")) {
            assert (pd.polypts.size() > 5);
            APolygon poly = new APolygon();
            Long x = null;
            Long y = null;
            for (double d : pd.polypts) {
                if (x == null) {
                    x = (long)(this.mUnits * d);
                    continue;
                }
                y = (long)(this.mUnits * d);
                APoint2D pt = new APoint2D(x.longValue(), y.longValue());
                poly.addPoint(pt);
                y = null;
                x = null;
            }
            poly.moveCenterTo(0L, 0L);
            return poly;
        }
        ALog.logWarn((String)("Unrecognized Pad Type " + pd.type));
        long wPin = (long)(10.0 * this.mUnits);
        ARect rpad = new ARect(0L, 0L, wPin, wPin);
        rpad.moveCenterTo(0L, 0L);
        return rpad;
    }

    protected void doPadLine(String line) {
        block14: {
            int i = line.indexOf(61);
            if (i <= 0) {
                this.mParseState = false;
                return;
            }
            String name = line.substring(0, i);
            name = name.replaceAll(" ", "");
            StringTokenizer st = new StringTokenizer(line = line.substring(i + 1));
            if (!st.hasMoreTokens()) {
                ALog.logError((String)"Cannot parse the type of pad shape");
                throw new IllegalStateException();
            }
            String type = st.nextToken();
            PadDef pd = new PadDef(name, type);
            if (type.equals("RECT") || type.equals("OBLONG") || type.equals("RECTANGLE") || type.equals("SQUARE")) {
                if (st.hasMoreTokens()) {
                    pd.d1 = Double.parseDouble(st.nextToken());
                }
                pd.d2 = st.hasMoreTokens() ? Double.parseDouble(st.nextToken()) : pd.d1;
                this.padDefs.add(pd);
            } else if (type.equals("POLY")) {
                while (st.hasMoreTokens()) {
                    Double x = Double.parseDouble(st.nextToken());
                    pd.polypts.add(x);
                }
                this.padDefs.add(pd);
            } else if (type.equals("POLYGON")) {
                try {
                    int numPts;
                    st.nextToken();
                    st.nextToken();
                    pd.numCoords = numPts = Integer.parseInt(st.nextToken());
                    for (i = 0; i < numPts; ++i) {
                        double x = Double.parseDouble(st.nextToken());
                        double y = Double.parseDouble(st.nextToken());
                        pd.polypts.add(x);
                        pd.polypts.add(y);
                    }
                    if (pd.polypts.size() < 6) {
                        ALog.logError((String)"POLY specified near line %d with less than three points.", (Object[])new Object[]{this.mCurLine});
                        break block14;
                    }
                    this.padDefs.add(pd);
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Error reading parsing POLY near line %d", (Object[])new Object[]{this.mCurLine});
                }
            } else {
                pd.d1 = Double.parseDouble(st.nextToken());
                this.padDefs.add(pd);
            }
        }
    }

    protected String equalsAString() {
        this.popWhitespaces();
        if (this.popChar('=')) {
            return this.popANoSpaceTerminal();
        }
        this.mParseState = false;
        return "";
    }

    protected void postProcess() {
        DeviceTemplate packageT;
        DeviceTemplate deviceTemplate = packageT = this.mPackage == null ? null : this.mPackage.getTemplate();
        if (packageT != null) {
            for (Device die : this.mDieName2Die.values()) {
                die.setParent(packageT);
            }
        }
        DeviceTemplate parentT = this.mDieName2Die.size() == 1 && packageT == null ? null : (packageT != null ? packageT : Design.getDesign((Db)this.mDb));
        for (PinInstance diePin : this.mDiePin2NetName.keySet()) {
            Net dieNet;
            Device die = diePin.getDevice();
            DeviceTemplate dieT = die.getTemplate();
            String netName = this.mDiePin2NetName.get(diePin);
            if (parentT == null) {
                Net dieNet2;
                Net net = dieNet2 = netName == null ? dieT.getNetUnused() : dieT.getNet(netName);
                if (dieNet2 == null) {
                    dieNet2 = Net.create((DeviceTemplate)dieT, (String)netName);
                }
                diePin.setNet(dieNet2);
                continue;
            }
            if (netName == null) continue;
            Net parentNet = parentT.getNet(netName);
            if (parentNet == null) {
                parentNet = Net.create((DeviceTemplate)parentT, (String)netName);
            }
            if ((dieNet = diePin.getNet()) == null || dieNet.isUnused()) {
                dieNet = Net.create((DeviceTemplate)dieT, (String)diePin.getPinTemplate().getName());
                diePin.setNet(dieNet);
            }
            assert (NetMap.getParentNet((Device)die, (Net)dieNet) == null);
            NetMap.mapChildNet((Device)die, (Net)dieNet, (Net)parentNet);
        }
        if (this.mPackage != null) {
            this.mPackage.moveToClearArea();
        }
    }

    protected APoint2D equalsAPoint() {
        APoint2D p = new APoint2D();
        this.popLine();
        String line = this.getParsedTerminal();
        int k = line.indexOf(44);
        if (k == -1) {
            k = line.indexOf(32);
        }
        String dS1 = line.substring(1, k);
        String dS2 = line = line.substring(k + 1);
        p.setX((long)(Double.parseDouble(dS1) * this.mUnits));
        p.setY((long)(Double.parseDouble(dS2) * this.mUnits));
        return p;
    }

    protected double equalsANumber() {
        this.popWhitespaces();
        if (this.popChar('=')) {
            return this.forcePopDouble();
        }
        this.mParseState = false;
        return 0.0;
    }

    protected static class MCMSpecs {
        protected HashMap<String, MCMSpec> mSection2Spec = Maps.newHashMap();

        protected MCMSpecs() {
        }

        public MCMSpec put(String pkgName, String refDes) {
            MCMSpec spec = new MCMSpec(pkgName, refDes);
            this.mSection2Spec.put(spec.getSection(), spec);
            return spec;
        }

        public MCMSpec getBySection(String section) {
            return this.mSection2Spec.get(section);
        }

        public Iterable<String> getAllSections() {
            return this.mSection2Spec.keySet();
        }
    }

    protected static class MCMSpec {
        protected String mSection;
        protected String mPkgName;
        protected String mRefDes;

        public MCMSpec(String pkgName, String refDes) {
            this.mPkgName = pkgName;
            this.mRefDes = refDes;
            this.mSection = String.format("[MCM_%s_%s]", pkgName, refDes);
        }

        public String getSection() {
            return this.mSection;
        }

        public String getPkgName() {
            return this.mPkgName;
        }

        public String getRefDes() {
            return this.mRefDes;
        }
    }

    protected static class PadDef {
        final String name;
        final String type;
        double d1;
        double d2;
        int numCoords;
        ArrayList<Double> polypts = new ArrayList();

        PadDef(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

