/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.PortOrder;
import com.sigrity.orbit.export.PortShapeOrder;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AIFOut {
    protected Db mDb;
    protected Design mDesign;
    protected DevicePath mPackagePath = null;
    protected ArrayList<DevicePath> mDiePaths = new ArrayList();
    protected File mFile = null;
    protected FileWriter mFileWriter;
    ArrayList<PadTemplate> mPadTemplateList = new ArrayList();
    static final String rotPadStackSuffix = "_rot";
    protected boolean mPrefer = true;
    protected long mWireDiameter = -1L;
    protected String mFileName;
    protected boolean mIsWYSIWYG = false;
    protected PortShapeOrder.SortType mSortDiePads = PortShapeOrder.SortType.SORT_PORTS;
    protected DevicePath mRefDevicePath = null;
    protected Device mRefDevice = null;
    protected APoint2D mRefCenter = new APoint2D();
    protected float mRefR = 0.0f;
    protected boolean mRefM = false;
    ArrayList<HierPin> ballPadsUnused = new ArrayList();
    ArrayList<HierPin> bondFingersUnused = new ArrayList();

    public static boolean exportAIF(String filePath, String devicePathString, boolean isWYSIWYG, boolean sortDiePads) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot export '%s', there is no current database.", (Object[])new Object[]{filePath});
            return false;
        }
        DevicePath path = DevicePath.fromString((Db)db, (String)devicePathString);
        AIFOut w = new AIFOut();
        w.setVar("filename", filePath);
        DevicePath pathToSubstrate = path.pathToSubstrate();
        DeviceTemplate.Type type = pathToSubstrate.getDeviceTemplate().getType();
        if (type == DeviceTemplate.Type.PACKAGE) {
            w.setVar("package", devicePathString);
        } else if (type == DeviceTemplate.Type.DIE) {
            w.setVar("die", devicePathString);
        }
        w.setWYSIWYG(isWYSIWYG);
        w.setSortDiePads(sortDiePads ? PortShapeOrder.SortType.SORT_SHAPES_CCW : PortShapeOrder.SortType.NO_SORT);
        w.write();
        return true;
    }

    public AIFOut() {
        this.mDb = OrbitIO.getCurDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
    }

    public void setVar(String var, String val) {
        if (var.equals("filename")) {
            this.mFileName = val;
        } else if (var.equals("package")) {
            this.mPackagePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)val);
            ALog.logInfo((String)("Package " + this.mPackagePath.toString() + " will be exported"));
            for (DevicePath path : this.mPackagePath.getDescendants()) {
                if (!path.getLast().getIsSubstrate() || path.getDeviceTemplate().getType() != DeviceTemplate.Type.DIE || path.getParent().getDeviceTemplate().getType() == DeviceTemplate.Type.DIE) continue;
                this.mDiePaths.add(path);
            }
            Collections.sort(this.mDiePaths);
            for (DevicePath path : this.mDiePaths) {
                ALog.logInfo((String)("Die " + path.toString() + " will be exported"));
            }
            this.mRefDevicePath = this.mPackagePath;
        } else if (var.equals("die")) {
            ALog.logInfo((String)("Die " + val + " will be exported"));
            DevicePath path = DevicePath.fromString((Db)this.mDb, (String)val);
            this.mDiePaths.add(path);
            this.mRefDevicePath = this.mDiePaths.get(0);
        }
        if (this.mRefDevicePath != null) {
            this.mRefDevice = this.mRefDevicePath.getLast();
            this.mRefR = ATransformUtil.normRot((float)(360.0f - this.mRefDevicePath.getRot()));
            this.mRefM = this.mRefDevicePath.getMirror();
        }
    }

    public void setWYSIWYG(boolean isWYSIWYG) {
        this.mIsWYSIWYG = isWYSIWYG;
    }

    public void setSortDiePads(PortShapeOrder.SortType sortDiePads) {
        this.mSortDiePads = sortDiePads;
    }

    public boolean write() {
        float newR = ATransformUtil.normRot((float)(this.mRefDevice.getRotate() + this.mRefR));
        if (this.validate()) {
            if (!this.mIsWYSIWYG) {
                if (this.mRefR != 0.0f) {
                    this.mRefDevice.setRotate(newR);
                }
                if (this.mRefM) {
                    this.mRefDevice.setMirror(false);
                }
            }
            this.mRefCenter = this.mRefDevicePath.getBB().center();
            try {
                this.emitDataBase();
                this.emitDie();
                this.emitPackage();
                this.emitPads();
                this.emitNetList();
                this.emitWireWidth();
                this.mFileWriter.flush();
                this.mFileWriter.close();
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
            if (!this.mIsWYSIWYG) {
                if (this.mRefR != 0.0f) {
                    this.mRefDevice.setRotate(ATransformUtil.normRot((float)(this.mRefDevice.getRotate() - this.mRefR)));
                }
                if (this.mRefM) {
                    this.mRefDevice.setMirror(true);
                }
            }
            return true;
        }
        return false;
    }

    protected void emitWireWidth() {
        if (this.mWireDiameter != -1L) {
            try {
                this.print("\n[WIRE]\nDIAMETER=" + this.formatUM(this.mWireDiameter) + "\n");
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
    }

    protected boolean validate() {
        if (this.mFileName == null) {
            return false;
        }
        try {
            this.mFile = new File(this.mFileName);
            this.mFileWriter = new FileWriter(this.mFile);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Can not open '%s' for writing", (Object[])new Object[]{this.mFileName});
            return false;
        }
        return true;
    }

    protected boolean emitDataBase() {
        try {
            this.print("[DATABASE]\n");
            this.print("TYPE=AIF\n");
            this.print("VERSION=2.0\n");
            this.print("UNITS=UM\n");
            if (this.mDiePaths.size() > 1) {
                Set dts;
                this.print("MCM=TRUE\n");
                this.print("\n[MCM_DIE]\n");
                HashMap<DeviceTemplate, ArrayList> dt2d = new HashMap<DeviceTemplate, ArrayList>();
                for (DevicePath dp : this.mDiePaths) {
                    ArrayList devices;
                    Device d = dp.getLast();
                    DeviceTemplate dt = d.getTemplate();
                    dts = dt2d.keySet();
                    if (dts.contains(dt)) {
                        devices = (ArrayList)dt2d.get(dt);
                    } else {
                        devices = new ArrayList();
                        dt2d.put(dt, devices);
                    }
                    devices.add(d);
                }
                dts = dt2d.keySet();
                if (dts.isEmpty()) {
                    return true;
                }
                ArrayList<DeviceTemplate> sortedDts = new ArrayList<DeviceTemplate>();
                for (DeviceTemplate dt : dts) {
                    sortedDts.add(dt);
                }
                Collections.sort(sortedDts);
                for (DeviceTemplate dt : sortedDts) {
                    ArrayList devices = (ArrayList)dt2d.get(dt);
                    if (devices.isEmpty()) continue;
                    this.print(String.format("%s=", dt.getName()));
                    Collections.sort(devices);
                    Device first = (Device)devices.get(0);
                    for (Device d : devices) {
                        this.print(String.format(d == first ? "%s" : ", %s", d.getName()));
                    }
                    this.print(String.format("\n", new Object[0]));
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void emitDie() {
        try {
            boolean multiDie;
            boolean bl = multiDie = this.mDiePaths.size() > 1;
            if (!multiDie) {
                this.print("\n[DIE]\n");
            }
            for (DevicePath dp : this.mDiePaths) {
                Device d = dp.getLast();
                if (multiDie) {
                    DeviceTemplate dt = d.getTemplate();
                    this.print(String.format("\n[MCM_%s_%s]\n", dt.getName(), d.getName()));
                } else {
                    this.print("NAME=" + d.getName() + "\n");
                }
                ARect bb = dp.getBB();
                APoint2D center = this.mPackagePath != null || dp != this.mDiePaths.get(0) ? bb.center().sub(this.mRefCenter) : new APoint2D();
                this.print("WIDTH=" + this.formatUM(bb.width()) + "\n");
                this.print("HEIGHT=" + this.formatUM(bb.height()) + "\n");
                this.print("CENTER=" + this.formatUM(center.getX()) + " " + this.formatUM(center.getY()) + "\n");
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected void emitPadStackForPackage() {
        if (this.mPackagePath == null) {
            return;
        }
        int numGenerated = 0;
        try {
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            for (DevicePath devicePath : this.mPackagePath.getDescendants()) {
                Device p = devicePath.getLast();
                if (p.getSubstrate() == null || p.getTemplate().getType() != DeviceTemplate.Type.PACKAGE) continue;
                for (PinInstance port : p.getPins()) {
                    ARect r;
                    PadTemplate pt;
                    PinTemplate dtp = port.getPinTemplate();
                    if (dtp.getType() != PinTemplate.Type.BALLPAD && dtp.getType() != PinTemplate.Type.BONDFINGERPAD || this.mPadTemplateList.contains(pt = port.getPinTemplate().getPadTemplate())) continue;
                    ++numGenerated;
                    this.mPadTemplateList.add(pt);
                    String ptName = pt.getName();
                    if (dtp.getType() == PinTemplate.Type.BALLPAD) {
                        r = port.getWorldBounds(devicePath);
                        lines.add((CallSite)((Object)(ptName + "=CIRCLE " + this.formatUM(r.width()) + "\n")));
                        continue;
                    }
                    r = null;
                    for (LayerShape ls : pt.getLayerShapes()) {
                        r = ls.getBounds();
                    }
                    if (r == null) continue;
                    lines.add((CallSite)((Object)(ptName + "=OBLONG " + this.formatUM(r.width()) + " " + this.formatUM(r.height()) + "\n")));
                }
            }
            Collections.sort(lines);
            for (String string : lines) {
                this.print(string);
            }
            String pWord = numGenerated == 1 ? " padstack" : " padstacks";
            ALog.logInfo((String)(" " + numGenerated + pWord + " generated for the package"));
            if (numGenerated == 0) {
                ALog.logInfo((String)"Perhaps there where no Pads of Type Ball Pad?");
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected void emitPadStackforDie() {
        int numGenerated = 0;
        ArrayList<String> lines = new ArrayList<String>();
        for (DevicePath dp : this.mDiePaths) {
            for (DevicePath childPath : dp.getDescendants()) {
                Device child = childPath.getLast();
                if (!child.getIsPlaced()) continue;
                List dps = child.getWireBondPins();
                for (PinInstance wbPort : dps) {
                    if (wbPort == null || !this.emitPadTemplates(dp, wbPort, lines)) continue;
                    ++numGenerated;
                }
            }
        }
        try {
            Collections.sort(lines);
            for (String line : lines) {
                this.print(line);
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
        String pWord = (numGenerated *= 2) == 1 ? " padstack" : " padstacks";
        ALog.logInfo((String)(" " + numGenerated + pWord + " generated for the die"));
        if (numGenerated == 0) {
            ALog.logInfo((String)"Perhaps there where no Pads of Wire Bond Pad?");
        }
    }

    private boolean emitPadTemplates(DevicePath path, PinInstance wbPort, ArrayList<String> lines) {
        PinTemplate dtp = wbPort.getPinTemplate();
        PadTemplate pt = dtp.getPadTemplate();
        if (pt == null || this.mPadTemplateList.contains(pt)) {
            return false;
        }
        this.mPadTemplateList.add(pt);
        String ptName = pt.getName();
        ArrayList<LayerShape> layerShapes = AIFOut.getSortedLayerShapes(pt, this.mPrefer);
        LayerShape last = layerShapes.get(layerShapes.size() - 1);
        Layer topLayer = last.getLayer();
        for (LayerShape ls : layerShapes) {
            Layer layer = ls.getLayer();
            if (layer != topLayer) continue;
            AffineTransform xform = wbPort.getWorldTransform(path);
            AGeom s = ls.getGeom().transform(xform);
            if (s == null) continue;
            ARect r = s.getBounds();
            int index = layerShapes.indexOf(ls);
            String outPtName = index == 0 ? ptName : ptName + "_" + Integer.toString(index);
            lines.add(outPtName + "=RECT " + this.formatUM(r.width()) + " " + this.formatUM(r.height()) + "\n");
            lines.add(outPtName + "_rot=RECT " + this.formatUM(r.height()) + " " + this.formatUM(r.width()) + "\n");
        }
        return true;
    }

    private void emitNetPorts(DevicePath path, PinInstance wbPort, String netName, int pinNum, long x, long y, float rot, Net topNet, PinTemplate bf) {
        PinTemplate dtp = wbPort.getPinTemplate();
        PadTemplate pt = dtp.getPadTemplate();
        String ptName = pt == null ? "-" : pt.getName();
        ArrayList<LayerShape> layerShapes = AIFOut.getSortedLayerShapes(pt, this.mPrefer);
        if (layerShapes.size() < 2) {
            this.emitNetPort(netName, Integer.toString(pinNum), ptName, x, y, rot);
            this.emitNetBallAndBF(topNet, bf);
            return;
        }
        LayerShape last = layerShapes.get(layerShapes.size() - 1);
        Layer topLayer = last.getLayer();
        for (LayerShape ls : layerShapes) {
            Layer layer = ls.getLayer();
            if (layer != topLayer) continue;
            AffineTransform xform = wbPort.getWorldTransform(path);
            AGeom s = ls.getGeom().transform(xform);
            if (s == null) continue;
            ARect r = s.getBounds();
            int index = layerShapes.indexOf(ls);
            String attachIndex = "_" + Integer.toString(index);
            boolean theOne = r.contains(x, y);
            String outPinNum = theOne ? Integer.toString(pinNum) : Integer.toString(pinNum) + attachIndex;
            String outPtName = index == 0 ? ptName : ptName + attachIndex;
            long outX = theOne ? x : r.centerX();
            long outY = theOne ? y : r.centerY();
            this.emitNetPort(netName, outPinNum, outPtName, outX, outY, rot);
            this.emitNetBallAndBF(topNet, bf);
        }
    }

    private void emitNetPort(String netName, String outPinNum, String outPtName, long x, long y, float rot) {
        try {
            if (rot == 0.0f || rot == 180.0f) {
                this.print(netName + "\t" + outPinNum + "\t" + outPtName + "\t" + this.formatUM(x) + "\t" + this.formatUM(y));
            } else {
                this.print(netName + "\t" + outPinNum + "\t" + outPtName + "_rot\t" + this.formatUM(x) + "\t" + this.formatUM(y));
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    public static ArrayList<LayerShape> getSortedLayerShapes(PadTemplate pt, boolean prefer) {
        ArrayList<LayerShape> layerShapes = new ArrayList<LayerShape>();
        boolean preferredOnly = false;
        if (prefer) {
            for (LayerShape ls : pt.getLayerShapes()) {
                if (!ls.isPreferredAttachment()) continue;
                preferredOnly = true;
                break;
            }
        }
        for (LayerShape ls : pt.getLayerShapes()) {
            if (preferredOnly && !ls.isPreferredAttachment()) continue;
            layerShapes.add(ls);
        }
        Collections.sort(layerShapes);
        return layerShapes;
    }

    protected void emitPads() {
        try {
            this.print("\n[PADS]\n");
            this.emitPadStackforDie();
            this.emitPadStackForPackage();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected void emitPackage() {
        if (this.mPackagePath == null) {
            return;
        }
        try {
            this.print("\n[BGA]\n");
            Device aPackage = this.mPackagePath.getLast();
            this.print("NAME=" + aPackage.getName() + "\n");
            ARect r = this.mIsWYSIWYG ? aPackage.getLocalBB() : aPackage.getUntransformedShape().getBounds();
            this.print("WIDTH=" + this.formatUM(r.width()) + "\n");
            this.print("HEIGHT=" + this.formatUM(r.height()) + "\n");
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected void emitNetList() {
        this.createBallAndBFList();
        boolean wroteHeader = false;
        if (this.mDiePaths.size() > 0) {
            try {
                this.print("\n[NETLIST]\n");
                this.print(";NETNAME \tDIE_PAD# \tDIE_PADSTACK_NAME \tDIE_PAD_X \tDIE_PAD_Y \tBALL# \tBALL_PADSTACK_NAME \tBALL_X \tBALL_Y \tFIN# \tTYPE \tFIN_X    \tFIN_Y    \tANGLE\n");
                wroteHeader = true;
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
        ArrayList<HierPin> diePads = new ArrayList<HierPin>();
        for (DevicePath dp : this.mDiePaths) {
            int pinNum = 0;
            diePads.clear();
            for (DevicePath childPath : dp.getDescendants()) {
                Device child = childPath.getLast();
                if (!child.getIsPlaced()) continue;
                for (PinInstance port : child.getPins()) {
                    PinTemplate dtp = port.getPinTemplate();
                    if (dtp.getType() != PinTemplate.Type.WIREBONDPAD && dtp.getType() != PinTemplate.Type.BUMPPAD) continue;
                    diePads.add(new HierPin(childPath, port));
                }
            }
            if (this.mSortDiePads == PortShapeOrder.SortType.SORT_SHAPES_CCW) {
                boolean multiDie = this.mDiePaths.size() > 1;
                ArrayList<PortShapeOrder.PortShape> diePadShapes = PortShapeOrder.setCCWOrder(diePads, dp, this.mRefCenter, this.mSortDiePads, this.mPrefer);
                for (PortShapeOrder.PortShape ps : diePadShapes) {
                    PinInstance wbPort = ps.port;
                    DevicePath childPath = ps.path;
                    pinNum = diePadShapes.indexOf(ps) + 1;
                    PinTemplate bf = null;
                    if (this.mPackagePath != null) {
                        bf = BondFingerUtil.getConnectedBF((DeviceTemplate)this.mPackagePath.getDeviceTemplate(), (PinInstance)wbPort);
                    }
                    Net net = wbPort.getNet();
                    Net topNet = NetMap.getTopmostNet((Net)net, (DevicePath)childPath);
                    String netName = wbPort.isOnUsedNet() ? topNet.getName() : "NetUnused";
                    APoint2D wloc = ps.shape.center();
                    if (ps.layerShape != null) {
                        wloc = this.exportXForm(wloc);
                    }
                    long x = wloc.getX();
                    long y = wloc.getY();
                    float rot = Device.getRotRelativeToSubstrate((DevicePath)childPath);
                    Object pinName = multiDie ? childPath.pathToLowestDie().getLast().getName() + "." : "";
                    pinName = (String)pinName + Integer.toString(pinNum);
                    this.emitNetPort(netName, (String)pinName, ps.ptName, x, y, rot);
                    this.emitNetBallAndBF(topNet, bf);
                }
                continue;
            }
            if (this.mSortDiePads != PortShapeOrder.SortType.NO_SORT) {
                PortOrder.setCCWOrder(diePads, dp);
            }
            for (HierPin ppp : diePads) {
                PinInstance wbPort = ppp.getPin();
                DevicePath childPath = ppp.getPath();
                pinNum = wbPort.getPinNum();
                PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)this.mPackagePath.getDeviceTemplate(), (PinInstance)wbPort);
                Net net = wbPort.getNet();
                Net topNet = NetMap.getTopmostNet((Net)net, (DevicePath)childPath);
                String netName = wbPort.isOnUsedNet() ? topNet.getName() : "NetUnused";
                APoint2D wloc = wbPort.getWorldLoc(childPath);
                wloc = this.exportXForm(wloc);
                long x = wloc.getX();
                long y = wloc.getY();
                float rot = Device.getRotRelativeToSubstrate((DevicePath)childPath);
                this.emitNetPorts(childPath, wbPort, netName, pinNum, x, y, rot, topNet, bf);
            }
        }
        try {
            if (this.mPackagePath != null) {
                if (!wroteHeader) {
                    this.print("\n[NETLIST]\n");
                    this.print(";NETNAME \tDIE_PAD# \tDIE_PADSTACK_NAME \tDIE_PAD_X \tDIE_PAD_Y \tBALL# \tBALL_PADSTACK_NAME \tBALL_X \tBALL_Y\n");
                }
                this.emitUnusedBallsandBFS(this.mPackagePath);
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected void emitNetBallAndBF(Net topNet, PinTemplate bf) {
        try {
            PinInstance ball = null;
            HierPin candidatePath = null;
            for (HierPin ballPath : this.ballPadsUnused) {
                PinInstance candidate = ballPath.getPin();
                Net ballNet = candidate.getNet();
                Net ballTopNet = NetMap.getTopmostNet((Net)ballNet, (DevicePath)ballPath.getPath());
                if (ballTopNet != topNet) continue;
                ball = candidate;
                candidatePath = ballPath;
                break;
            }
            if (ball != null) {
                PinInstance ballPort = candidatePath.getPin();
                String ballName = ballPort.getPinTemplate().getName();
                PadTemplate pt = ballPort.getPinTemplate().getPadTemplate();
                String ptName = pt == null ? "-" : pt.getName();
                APoint2D wloc = ballPort.getWorldLoc(candidatePath.getPath());
                wloc = this.exportXForm(wloc);
                long x = wloc.getX();
                long y = wloc.getY();
                this.print("\t" + ballName + "\t" + ptName + "\t" + this.formatUM(x) + "\t" + this.formatUM(y));
                this.ballPadsUnused.remove(candidatePath);
            } else {
                this.print("\t- \t- \t - \t - ");
            }
            if (bf != null) {
                String bfName = bf.getName();
                PadTemplate pt = bf.getPadTemplate();
                String ptName = pt == null ? "-" : pt.getName();
                APoint2D wloc = bf.getLoc();
                wloc = this.exportXForm(wloc);
                long x = wloc.getX();
                long y = wloc.getY();
                float rot = ATransformUtil.normRot((float)(360.0f - bf.getFirstPortTemplate().getRotate()));
                this.print("\t" + bfName + "\t" + ptName + "\t" + this.formatUM(x) + "\t" + this.formatUM(y) + "\t" + rot + "\n");
                candidatePath = null;
                Iterator<HierPin> iterator = this.bondFingersUnused.iterator();
                while (iterator.hasNext()) {
                    HierPin bfPath;
                    candidatePath = bfPath = iterator.next();
                }
                this.bondFingersUnused.remove(candidatePath);
            } else {
                this.print("\n");
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected void createBallAndBFList() {
        if (this.mPackagePath == null) {
            return;
        }
        for (DevicePath childPath : this.mPackagePath.getDescendants()) {
            Device aPackage = childPath.getLast();
            for (PinInstance port : aPackage.getPins()) {
                Wire w;
                PinTemplate dtp = port.getPinTemplate();
                if (dtp.getType() == PinTemplate.Type.BALLPAD) {
                    this.ballPadsUnused.add(new HierPin(childPath, port));
                }
                if (dtp.getType() != PinTemplate.Type.BONDFINGERPAD) continue;
                this.bondFingersUnused.add(new HierPin(childPath, port));
                if (this.mWireDiameter != -1L || aPackage.getTemplate().getType() != DeviceTemplate.Type.BONDFINGER || (w = BondFingerUtil.getWireBond((PinTemplate)port.getPinTemplate())) == null) continue;
                this.mWireDiameter = w.getWidth();
            }
        }
        Collections.sort(this.ballPadsUnused);
        Collections.sort(this.bondFingersUnused);
    }

    protected void emitUnusedBallsandBFS(DevicePath packagePath) {
        try {
            long y;
            long x;
            APoint2D wloc;
            String ptName;
            PadTemplate pt;
            Net topNet;
            Net net;
            DevicePath childPath;
            PinInstance port;
            for (HierPin ppp : this.ballPadsUnused) {
                port = ppp.getPin();
                childPath = ppp.getPath();
                net = port.getNet();
                topNet = NetMap.getTopmostNet((Net)net, (DevicePath)childPath);
                String ballName = port.getPinTemplate().getName();
                pt = port.getPinTemplate().getPadTemplate();
                ptName = pt == null ? "-" : pt.getName();
                wloc = port.getWorldLoc(childPath);
                wloc = this.exportXForm(wloc);
                x = wloc.getX();
                y = wloc.getY();
                String netName = port.isOnUsedNet() ? topNet.getName() : "NetUnused";
                this.print(netName + "\t-\t-\t-\t-\t" + ballName + "\t" + ptName + "\t" + this.formatUM(x) + "\t" + this.formatUM(y) + "\n");
            }
            for (HierPin bf : this.bondFingersUnused) {
                port = bf.getPin();
                childPath = bf.getPath();
                net = port.getNet();
                topNet = NetMap.getTopmostNet((Net)net, (DevicePath)childPath);
                String bfName = childPath.getLast().getName();
                pt = port.getPinTemplate().getPadTemplate();
                ptName = pt == null ? "-" : pt.getName();
                wloc = port.getWorldLoc(childPath);
                wloc = this.exportXForm(wloc);
                x = wloc.getX();
                y = wloc.getY();
                float r = ATransformUtil.normRot((float)(360.0f - childPath.getRot()));
                String netName = port.isOnUsedNet() ? topNet.getName() : "NetUnused";
                this.print(netName + "\t-\t-\t-\t-\t-\t-\t-\t-\t" + bfName + "\t" + ptName + "\t" + this.formatUM(x) + "\t" + this.formatUM(y) + "\t" + r + "\n");
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected String formatUM(long d) {
        String ret = Double.toString(this.mDesign.getUser(d));
        return ret;
    }

    protected boolean print(String s) throws IOException {
        try {
            this.mFileWriter.write(s);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems writing", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private APoint2D exportXForm(APoint2D loc) {
        return loc.sub(this.mRefCenter);
    }

    class portPathPair
    implements Comparable<portPathPair> {
        PinInstance port;
        DevicePath path;

        portPathPair(PinInstance port, DevicePath path) {
            this.port = port;
            this.path = path;
        }

        public DevicePath getPath() {
            return this.path;
        }

        public PinInstance getPort() {
            return this.port;
        }

        @Override
        public int compareTo(portPathPair o) {
            return o.getPort().getName().compareTo(this.getPort().getName());
        }
    }
}

