/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.AFile;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.SelectionCriteria;
import com.sigrity.acl.db.Selector;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APoint2DDouble;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Color;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BabylonFile {
    private final File file;
    private final FileWriter w;
    private final ViewColorizer colorizer;
    private final Map<Color, Long> colors = new LinkedHashMap<Color, Long>();
    private final Map<APoint2DDouble, Long> pinShapeVertexMap = new LinkedHashMap<APoint2DDouble, Long>();
    private final Map<APolygon, Long> pinShapeMap = new LinkedHashMap<APolygon, Long>();
    private double scale;
    private double designMiddleZ;
    private ARect view;
    private LinkedList<Object> objects;
    private final double[] cameraLocation = new double[3];
    private final long[] cameraTarget = new long[2];
    private static final String LOG_ERROR = "Cannot write Orbit 3D Viewer file";
    private static final String LOG_OPEN_ERROR = "Cannot open 3D Viewer with default browser";

    public BabylonFile() throws IOException {
        this.file = AFile.createTempFile((String)"Orbit3DView", (String)".html", Optional.of(ALog.LVL_ERR)).orElseGet(() -> new File(String.format("%s/__Orbit3DView.html", System.getProperty("user.home"))));
        this.w = new FileWriter(this.file);
        DesignCanvas2D v2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
        this.colorizer = v2d.getColorizer();
        this.view = v2d.getVisibleBounds();
    }

    public File getFile() {
        return this.file;
    }

    public void initiateDefaultFile() {
        String filePath = OrbitIO.getInstallDir().getAbsolutePath();
        String babylonPath = filePath + "\\oem\\javascript\\babylon.js";
        String babylonExtraPath = filePath + "\\oem\\javascript\\3DExtension.js";
        Object iconPath = filePath.substring(0, filePath.length() - 3);
        iconPath = (String)iconPath + "src\\art\\icons\\OrbitIcon16.png";
        String code = "<html> \n<head> \n<meta http-equiv='Content-Type' content='text/html' charset='utf-8'> \n<title>Orbit</title> \n<link rel='icon' href='" + (String)iconPath + "'> \n<script src='" + babylonPath + "' type = text/javascript></script> \n<script src='" + babylonExtraPath + "'></script> \n<style> \nhtml, body { \noverflow: hidden; \nwidth   : 100%; \nheight  : 100%; \nmargin  : 0; \npadding : 0; \n} \n#renderCanvas { \nwidth   : 100%; \nheight  : 100%; \ntouch-action: none; \n} \n</style> \n</head> \n<body> \n<canvas id='renderCanvas' width='392' height='1078'></canvas> \n<script> \nvar scene = createScene(); \nvar camera = scene.currentCamera; \nvar engine = scene.engine; \n";
        try {
            this.w.append(code);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)LOG_ERROR, (Object[])new Object[0]);
        }
    }

    public void setCameraLocation(double x, double y, double height) {
        this.cameraLocation[0] = x;
        this.cameraLocation[1] = y;
        this.cameraLocation[2] = height;
    }

    public void setCameraTarget(long x, long y) {
        this.cameraTarget[0] = x;
        this.cameraTarget[1] = y;
    }

    public void findScale(boolean cameraDefaults) {
        long maxSize = 0L;
        long minX = 0L;
        long maxX = 0L;
        long minY = 0L;
        long maxY = 0L;
        long maxZ = 0L;
        long minZ = 0L;
        for (Object e : this.objects) {
            if (!(e instanceof DevicePath)) continue;
            DevicePath d = (DevicePath)e;
            if (Substrate.getZLoc((DevicePath)d) + d.getSubstrate().getHeight() > maxZ) {
                maxZ = Substrate.getZLoc((DevicePath)d) + d.getSubstrate().getHeight();
            }
            if (Substrate.getZLoc((DevicePath)d) < minZ) {
                minZ = Substrate.getZLoc((DevicePath)d);
            }
            if (d.getExtent().width() > maxSize) {
                maxSize = d.getExtent().width();
            }
            if (d.getExtent().height() > maxSize) {
                maxSize = d.getExtent().height();
            }
            if (d.getExtent().getLeftLine().getFirstPoint().getX() < minX) {
                minX = d.getExtent().getLeftLine().getFirstPoint().getX();
            }
            if (d.getExtent().getRightLine().getFirstPoint().getX() > maxX) {
                maxX = d.getExtent().getRightLine().getFirstPoint().getX();
            }
            if (d.getExtent().getTopLine().getFirstPoint().getY() > maxY) {
                maxY = d.getExtent().getTopLine().getFirstPoint().getY();
            }
            if (d.getExtent().getBottomLine().getFirstPoint().getY() >= minY) continue;
            minY = d.getExtent().getBottomLine().getFirstPoint().getY();
        }
        this.scale = 1.0;
        while ((double)maxSize / this.scale > 5000.0) {
            this.scale *= 2.0;
        }
        this.designMiddleZ = (double)(maxZ + minZ) / 2.0;
    }

    private void setupCamera() {
        String code = "camera.setTarget(new BABYLON.Vector3(" + (double)this.cameraTarget[0] / this.scale + ", " + this.designMiddleZ / this.scale + ", " + (double)this.cameraTarget[1] / this.scale + ")); \ncamera.originalTarget = " + this.designMiddleZ / this.scale + "; \ncamera.alpha = " + this.cameraLocation[0] + "; \ncamera.beta = " + this.cameraLocation[1] + "; \ncamera.radius = " + this.cameraLocation[2] + "; \n";
        try {
            this.w.append(code);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)LOG_ERROR, (Object[])new Object[0]);
        }
    }

    private void prepareBabylonWire(Wire wire, DevicePath devicePath) {
        APatternColor color = this.colorizer.getColor(devicePath, wire);
        this.addColorMap(color);
    }

    private void prepareBabylonPin(PinInstance pinInst, DevicePath devicePath) {
        APatternColor color;
        PadTemplate temp = pinInst.getPadTemplate();
        if (temp == null) {
            return;
        }
        for (Layer l : pinInst.getPadTemplate().getLayers()) {
            color = this.colorizer.getColor(devicePath, l);
            this.addColorMap(color);
        }
        if (pinInst.getType().equals((Object)PinTemplate.Type.VIA) && temp.getLayerShapeCount() >= 2) {
            ARect bounds = pinInst.getWorldTopLevelBounds(devicePath);
            if (bounds == null) {
                return;
            }
            Substrate sub = pinInst.getPortSubstrate();
            APair layers = temp.getLayerSpans();
            APair index = new APair((Object)-1, (Object)-1);
            int count = 1;
            for (Layer l : sub.getLayers(Layer.BottomFirstSort)) {
                if (l.equals(layers.getFirst())) {
                    index.first = count;
                }
                if (l.equals(layers.getSecond())) {
                    index.second = count;
                }
                ++count;
            }
            if ((Integer)index.getFirst() == -1 || (Integer)index.getSecond() == -1) {
                return;
            }
            APair shapes = new APair(null, null);
            shapes.first = temp.getLayerShapes((Layer)layers.getFirst()).next();
            shapes.second = temp.getLayerShapes((Layer)layers.getSecond()).next();
            if (shapes.getFirst() == null || shapes.getSecond() == null) {
                return;
            }
            APair colors = new APair((Object)this.colorizer.getColor(pinInst.getDeviceTemplate().getPathToPresentUser(), (Layer)layers.first), (Object)this.colorizer.getColor(pinInst.getDeviceTemplate().getPathToPresentUser(), (Layer)layers.second));
            if (colors.first == null || colors.second == null) {
                return;
            }
            APair materials = new APair((Object)this.getColorIndex((APatternColor)colors.first), (Object)this.getColorIndex((APatternColor)colors.second));
            if (materials.first == null || materials.second == null) {
                return;
            }
            this.addBabylonPinShape(((LayerShape)shapes.first).getGeom().toPoly());
            this.addBabylonPinShape(((LayerShape)shapes.second).getGeom().toPoly());
        } else {
            for (LayerShape ls : temp.getLayerShapes()) {
                color = this.colorizer.getColor(devicePath, ls.getLayer());
                if (color == null) {
                    return;
                }
                Long materialIndex = this.getColorIndex(color);
                if (materialIndex == null) {
                    return;
                }
                this.addBabylonPinShape(ls.getGeom().toPoly());
            }
        }
    }

    private void prepareBabylonObstacle(Obstacle obs, DevicePath path) {
        for (LayerShape ls : obs.getLayerShapes()) {
            APatternColor color = this.colorizer.getColor(path, obs, ls.getLayer());
            this.addColorMap(color);
        }
    }

    private void writeBabylonWire(Wire wire, DevicePath devicePath) {
        APath path = wire.getPath();
        LinkedList<APoint2D> points = new LinkedList<APoint2D>(path.getPointList());
        Substrate s = wire.getSubstrate();
        Layer layer = wire.getLayer();
        int index = s.getLayerCount();
        int count = 0;
        for (Layer l : s.getLayers(Layer.BottomFirstSort)) {
            if (l.equals(layer)) {
                index = count;
            }
            ++count;
        }
        double substrateLoc = Substrate.getZLoc((DevicePath)devicePath);
        double substrateHeight = wire.getSubstrate().getHeight();
        double layerHeight = substrateHeight / (double)wire.getSubstrate().getLayerCount();
        double height = substrateLoc + (double)index * layerHeight + 0.5 * layerHeight;
        String array = this.getPointArrayString(points, height / this.scale);
        double radius = (double)wire.getWidth() / this.scale;
        APatternColor color = this.colorizer.getColor(devicePath, wire);
        if (color == null) {
            return;
        }
        Long materialIndex = this.getColorIndex(color);
        if (materialIndex == null) {
            return;
        }
        String code = "var path = " + array + "\n" + this.getWire2DShape(radius, layerHeight / this.scale) + "createCustomWire('" + wire.getName() + "', shape2D, path, " + height / this.scale + ", " + this.getBabylonColorVar(materialIndex) + ", scene); \n";
        try {
            this.w.append(code);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)LOG_ERROR, (Object[])new Object[0]);
        }
    }

    private String getPointArrayString(LinkedList<APoint2D> points, double height) {
        StringBuilder script = new StringBuilder("[");
        for (APoint2D p : points) {
            script.append("new BABYLON.Vector3(" + (double)p.getX() / this.scale + ", " + height + ", " + (double)p.getY() / this.scale + "), ");
        }
        script.setLength(script.length() - 2);
        script.append("];");
        return script.toString();
    }

    private void writeBabylonPin(PinInstance pinInst, DevicePath devicePath) throws IOException {
        PadTemplate temp = pinInst.getPadTemplate();
        if (temp == null) {
            return;
        }
        double substrateLoc = Substrate.getZLoc((DevicePath)devicePath);
        double substrateHeight = temp.getSubstrate().getHeight();
        double layerHeight = substrateHeight / (double)temp.getSubstrate().getLayerCount();
        double rotation = pinInst.getRotate();
        if (pinInst.getType().equals((Object)PinTemplate.Type.VIA) && temp.getLayerShapeCount() >= 2) {
            ARect bounds = pinInst.getWorldTopLevelBounds(devicePath);
            if (bounds != null) {
                Substrate sub = pinInst.getPortSubstrate();
                APoint2D loc = pinInst.getWorldCenterLoc(devicePath);
                APair layers = temp.getLayerSpans();
                APair index = new APair((Object)-1, (Object)-1);
                int count = 1;
                for (Layer l : sub.getLayers(Layer.BottomFirstSort)) {
                    if (l.equals(layers.getFirst())) {
                        index.first = count;
                    }
                    if (l.equals(layers.getSecond())) {
                        index.second = count;
                    }
                    ++count;
                }
                if ((Integer)index.getFirst() == -1 || (Integer)index.getSecond() == -1) {
                    return;
                }
                APair shapes = new APair(null, null);
                shapes.first = temp.getLayerShapes((Layer)layers.getFirst()).next();
                shapes.second = temp.getLayerShapes((Layer)layers.getSecond()).next();
                if (shapes.getFirst() == null || shapes.getSecond() == null) {
                    return;
                }
                double top = substrateLoc + (double)((Integer)index.first).intValue() * layerHeight + layerHeight;
                double bottom = substrateLoc + (double)((Integer)index.second).intValue() * layerHeight;
                double middle = (top + bottom) / 2.0;
                APair zLocation = new APair((Object)((top + middle) / 2.0), (Object)((middle + bottom) / 2.0));
                double height = Math.abs(top - middle);
                APair colors = new APair((Object)this.colorizer.getColor(pinInst.getDeviceTemplate().getPathToPresentUser(), (Layer)layers.first), (Object)this.colorizer.getColor(pinInst.getDeviceTemplate().getPathToPresentUser(), (Layer)layers.second));
                if (colors.first == null || colors.second == null) {
                    return;
                }
                APair materials = new APair((Object)this.getColorIndex((APatternColor)colors.first), (Object)this.getColorIndex((APatternColor)colors.second));
                if (materials.first == null || materials.second == null) {
                    return;
                }
                APair arrays = new APair((Object)this.getPolygonStrings(((LayerShape)shapes.first).getGeom().toPoly(), height / this.scale), (Object)this.getPolygonStrings(((LayerShape)shapes.second).getGeom().toPoly(), height / this.scale));
                String code = (String)arrays.first + "createPolyPin('" + pinInst.getName() + "', shape2D, extrusion, " + (double)loc.getX() / this.scale + ", " + (Double)zLocation.first / this.scale + ", " + (double)loc.getY() / this.scale + ", " + rotation + ", " + materials.first + ", scene); \n" + (String)arrays.second + "createPolyPin('" + pinInst.getName() + "', shape2D, extrusion, " + (double)loc.getX() / this.scale + ", " + (Double)zLocation.second / this.scale + ", " + (double)loc.getY() / this.scale + ", " + rotation + ", " + materials.second + ", scene); \n";
                this.w.append(code);
            }
        } else {
            for (LayerShape ls : temp.getLayerShapes()) {
                APoint2D loc = pinInst.getWorldCenterLoc(devicePath);
                Substrate sub = pinInst.getPortSubstrate();
                Layer layer = ls.getLayer();
                int index = sub.getLayerCount();
                int count = 0;
                for (Layer l : sub.getLayers(Layer.BottomFirstSort)) {
                    if (l.equals(layer)) {
                        index = count;
                    }
                    ++count;
                }
                double z = substrateLoc + (double)index * layerHeight + 0.5 * layerHeight;
                APatternColor color = this.colorizer.getColor(devicePath, ls.getLayer());
                if (color == null) {
                    return;
                }
                Long materialIndex = this.getColorIndex(color);
                if (materialIndex == null) {
                    return;
                }
                this.writeBabylonExtrusion(layerHeight / this.scale);
                String shapeVar = this.getBabylonPinShapeVar(ls.getGeom().toPoly());
                String obstacle = "createPolyPin('" + pinInst.getName() + "', " + shapeVar + ", extrusion, " + (double)loc.getX() / this.scale + ", " + z / this.scale + ", " + (double)loc.getY() / this.scale + ", " + rotation + ", " + this.getBabylonColorVar(materialIndex) + ", scene); \n";
                this.w.append(obstacle);
            }
        }
    }

    private void createBabylonDevice(DevicePath path) {
        APatternColor color = this.colorizer.getColor(path);
        if (color == null) {
            return;
        }
        Long materialIndex = this.getColorIndex(color);
        if (materialIndex == null) {
            return;
        }
        Object device = "";
        AGeom geom = path.getDeviceTemplate().getBounds();
        if (geom == null) {
            return;
        }
        APolygon p = geom.toPoly();
        APoint2D loc = path.getBB().center();
        double thickness = (double)path.getSubstrate().getHeight() / this.scale;
        double rotation = (double)path.getLast().getWorldRotation(path) * (Math.PI / 180);
        double positionX = (double)loc.getX() / this.scale;
        double positionY = (double)Substrate.getZLoc((DevicePath)path) / this.scale + 0.5 * thickness;
        double positionZ = (double)loc.getY() / this.scale;
        String polyString = this.getPolygonStrings(p, thickness);
        if (geom instanceof ARect) {
            ARect r = (ARect)geom;
            device = "createDevice('" + path.toString() + "', " + positionX + ", " + positionY + ", " + positionZ + ", " + (double)r.width() / this.scale + ", " + thickness + ", " + (double)r.height() / this.scale + ", " + rotation + ", " + this.getBabylonColorVar(materialIndex) + ", scene); \n";
        } else {
            device = polyString + "createCustomDevice('" + path.toString() + "', shape2D, extrusion, " + positionY + ", " + thickness + ", " + rotation + ", " + this.getBabylonColorVar(materialIndex) + ", scene); \n";
        }
        try {
            this.w.append((CharSequence)device);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)LOG_ERROR, (Object[])new Object[0]);
        }
    }

    private void writeBabylonObstacle(Obstacle o, DevicePath devicePath) {
        Substrate sub = o.getSubstrate();
        double substrateHeight = sub.getHeight();
        double layerHeight = substrateHeight / (double)sub.getLayerCount() / this.scale;
        double substrateLoc = (double)Substrate.getZLoc((DevicePath)devicePath) / this.scale;
        List layers = sub.getLayers(Layer.BottomFirstSort).stream().collect(Collectors.toList());
        for (LayerShape ls : o.getLayerShapes()) {
            Layer layer = ls.getLayer();
            int index = sub.getLayerCount();
            int count = 1;
            for (Layer l : layers) {
                if (l.equals(layer)) {
                    index = count;
                }
                ++count;
            }
            double z = substrateLoc + (double)index * layerHeight - (double)((long)(0.5 * layerHeight));
            APolygon p = ls.getGeom().toPoly();
            APatternColor color = this.colorizer.getColor(devicePath, o, ls.getLayer());
            if (color == null) {
                return;
            }
            Long materialIndex = this.getColorIndex(color);
            if (materialIndex == null) {
                return;
            }
            String obstacle = this.getPolygonStrings(p, layerHeight) + "createPolyObstacle('" + o.getTypeName() + "', shape2D, extrusion, " + z + ", " + this.getBabylonColorVar(materialIndex) + ", scene); \n";
            try {
                this.w.append(obstacle);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)LOG_ERROR, (Object[])new Object[0]);
            }
        }
    }

    private String getPolygonStrings(APolygon p, double thickness) {
        StringBuilder script = new StringBuilder("var shape2D = [");
        AIterableItr points = p.getPoints();
        for (APoint2D point : points) {
            script.append("new BABYLON.Vector3(" + (double)point.getX() / this.scale + ", " + (double)point.getY() / this.scale + ", 0), ");
        }
        script.setLength(script.length() - 2);
        script.append("]; \n");
        script.append("shape2D.push(shape2D[0]); \n");
        script.append("var extrusion = [new BABYLON.Vector3(0,0,0), new BABYLON.Vector3(0,0," + thickness + ")]; \n");
        return script.toString();
    }

    private void writeBabylonExtrusion(double thickness) throws IOException {
        this.w.write("var extrusion = [new BABYLON.Vector3(0,0,0), new BABYLON.Vector3(0,0," + thickness + ")];\n");
    }

    private long addBabylonPinShape(APolygon p) {
        if (this.pinShapeMap.containsKey(p)) {
            return this.pinShapeMap.get(p);
        }
        long ret = this.pinShapeMap.size();
        this.pinShapeMap.put(p, ret);
        List points = p.getPointList();
        for (APoint2D pt : points) {
            APoint2DDouble dpt = new APoint2DDouble((double)pt.getX() / this.scale, (double)pt.getY() / this.scale);
            if (this.pinShapeVertexMap.containsKey(dpt)) continue;
            this.pinShapeVertexMap.put(dpt, Long.valueOf(this.pinShapeVertexMap.size()));
        }
        return ret;
    }

    private String getWire2DShape(double width, double height) {
        return "var shape2D = [new BABYLON.Vector3(" + -0.5 * width + ", " + -0.5 * height + ", 0),new BABYLON.Vector3(" + -0.5 * width + ", " + height / 2.0 + ", 0),new BABYLON.Vector3(" + width / 2.0 + ", " + height / 2.0 + ", 0),new BABYLON.Vector3(" + width / 2.0 + ", " + -0.5 * height + ", 0),]; \nshape2D.push(shape2D[0]);";
    }

    private void addColorMap(APatternColor pcolor) {
        Color color;
        Color color2 = color = pcolor == null ? null : pcolor.getColor();
        if (color != null && !this.colors.containsKey(color)) {
            this.colors.put(color, Long.valueOf(this.colors.size()));
        }
    }

    private Long getColorIndex(APatternColor pcolor) {
        Color color = pcolor == null ? null : pcolor.getColor();
        return this.colors.get(color);
    }

    private void prepareObjects() {
        for (Object e : this.objects) {
            DevicePath x = null;
            DevicePath path = null;
            if (e instanceof DevicePath) {
                x = path = (DevicePath)e;
            } else if (e instanceof HierInst) {
                HierInst inst = (HierInst)e;
                DbObject dbo = inst.getDbObject();
                x = dbo;
                path = inst.getPath();
            }
            if (x instanceof Wire) {
                Wire wire = (Wire)x;
                this.prepareBabylonWire(wire, path);
                continue;
            }
            if (x instanceof PinInstance) {
                PinInstance p = (PinInstance)x;
                this.prepareBabylonPin(p, path);
                continue;
            }
            if (x instanceof DevicePath) {
                DevicePath d = x;
                APatternColor color = this.colorizer.getColor(d);
                this.addColorMap(color);
                continue;
            }
            if (!(x instanceof Obstacle)) continue;
            Obstacle obs = (Obstacle)x;
            this.prepareBabylonObstacle(obs, path);
        }
    }

    private String getBabylonColorVar(Long index) {
        assert (index != null);
        return "materials[" + index + "]";
    }

    private String getBabylonPinShapeVar(APolygon p) {
        Long index = this.pinShapeMap.get(p);
        assert (index != null);
        return "pinShapeBuffer[" + index + "]";
    }

    private void writeBabylonColors() throws IOException {
        this.w.append("var colorVector = [");
        boolean first = true;
        for (Color c : this.colors.keySet()) {
            if (!first) {
                this.w.append(",");
            }
            first = false;
            this.w.append("" + (double)c.getRed() / 255.0);
            this.w.append("," + (double)c.getGreen() / 255.0);
            this.w.append("," + (double)c.getBlue() / 255.0);
        }
        this.w.append("];\n");
        this.w.append("var materials = [];\n");
        this.w.append("for (var i = 0; i < colorVector.length; i += 3) {\n");
        this.w.append("    var material = new BABYLON.StandardMaterial('material' + (i/3), scene);\n");
        this.w.append("    material.diffuseColor = new BABYLON.Color3(colorVector[i], colorVector[i+1], colorVector[i+2]);\n");
        this.w.append("    materials.push(material);\n");
        this.w.append("}\n");
    }

    private void writeBabylonObjects() throws IOException {
        for (Object e : this.objects) {
            if (e instanceof DevicePath) {
                this.createBabylonDevice((DevicePath)e);
                continue;
            }
            if (!(e instanceof HierInst)) continue;
            HierInst inst = (HierInst)e;
            DbObject dbo = inst.getDbObject();
            if (dbo instanceof Wire) {
                this.writeBabylonWire((Wire)dbo, inst.getPath());
                continue;
            }
            if (dbo instanceof PinInstance) {
                this.writeBabylonPin((PinInstance)dbo, inst.getPath());
                continue;
            }
            if (!(dbo instanceof Obstacle)) continue;
            this.writeBabylonObstacle((Obstacle)dbo, inst.getPath());
        }
    }

    private void writeBabylonShape() throws IOException {
        this.w.append("var pinShapeVertexBuffer = [");
        boolean first = true;
        for (APoint2DDouble dpt : this.pinShapeVertexMap.keySet()) {
            if (!first) {
                this.w.append(",");
            }
            first = false;
            this.w.append("[" + dpt.getX() + ", " + dpt.getY() + "]");
        }
        this.w.append("];\n");
        this.w.append("for (var i = 0; i < pinShapeVertexBuffer.length; i++) {\n");
        this.w.append("    pinShapeVertexBuffer[i] = new BABYLON.Vector3(pinShapeVertexBuffer[i][0], pinShapeVertexBuffer[i][1], 0);");
        this.w.append("}\n");
        this.w.append("var pinShapeBuffer = [");
        first = true;
        for (APolygon poly : this.pinShapeMap.keySet()) {
            if (!first) {
                this.w.append(",");
            }
            first = false;
            List pts = poly.getPointList();
            this.w.append("[");
            for (int i = 0; i < pts.size(); ++i) {
                APoint2D p = (APoint2D)pts.get(i);
                APoint2DDouble dpt = new APoint2DDouble((double)p.getX() / this.scale, (double)p.getY() / this.scale);
                if (i != 0) {
                    this.w.append(",");
                }
                this.w.append("" + this.pinShapeVertexMap.get(dpt));
            }
            this.w.append("]");
        }
        this.w.append("];\n");
        this.w.append("for (var i = 0; i < pinShapeBuffer.length; i++) {\n");
        this.w.append("    for (var j = 0; j < pinShapeBuffer[i].length; j++) {\n");
        this.w.append("        pinShapeBuffer[i][j] = pinShapeVertexBuffer[pinShapeBuffer[i][j]];\n");
        this.w.append("    }\n");
        this.w.append("    pinShapeBuffer[i].push(pinShapeBuffer[i][0])\n");
        this.w.append("}\n");
    }

    private void endFile() {
        String code = "scene.createOrUpdateSelectionOctree(); \nengine.runRenderLoop(function(){ \nscene.render(); \n}); \nwindow.addEventListener('resize', function(){ \nengine.resize(); \n}); \n</script></body></html>";
        try {
            this.w.append(code);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)LOG_ERROR, (Object[])new Object[0]);
        }
        try {
            this.w.close();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)LOG_ERROR, (Object[])new Object[0]);
        }
    }

    public void open() {
        try {
            Desktop.getDesktop().browse(this.file.toURI());
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)LOG_OPEN_ERROR, (Object[])new Object[0]);
        }
    }

    private double findCameraHeight() {
        double heightY;
        double heightX = (double)this.view.width() / Math.tan(0.8);
        double height = heightX > (heightY = (double)this.view.height() / Math.tan(0.8)) ? heightX : heightY;
        return height / this.scale;
    }

    public void writeFile() throws IOException {
        this.initiateDefaultFile();
        this.setCameraTarget(this.view.centerX(), this.view.centerY());
        this.getBabylonObjects();
        this.findScale(false);
        this.setCameraLocation(4.7124, 0.0, this.findCameraHeight());
        this.setupCamera();
        this.prepareObjects();
        this.writeBabylonShape();
        this.writeBabylonColors();
        this.writeBabylonObjects();
        this.endFile();
    }

    public void getBabylonObjects() {
        this.objects = AUtil.linkedList((Stream)AStream.of((Object[])new AStream[]{BabylonFile.getWires(this.view), BabylonFile.getDevices(this.view), BabylonFile.getObstacles(this.view), BabylonFile.getPins(this.view)}).flatMap(x -> x));
    }

    public static AStream<HierInst<Obstacle>> getObstacles(ARect r) {
        SelectionCriteria criteria = new SelectionCriteria();
        criteria.clearFilters();
        criteria.clearPropertyFilters();
        criteria.setSelArea((AGeom)r);
        criteria.setNetFilterConsidersConnectedNets(false);
        criteria.setMode(Selection.Mode.Intersect);
        SelectionContext selCtx = SelectionContext.create((Db)OrbitIO.getCurDb());
        Selector selector = Selectors.ObstacleLayerShapeSelector.Descriptor.createSelector(selCtx);
        List items = selector.getMatching((AGeom)r, Selection.AreaMode.Touch, criteria.getPropertyFilters(), Selection.Filters.aggregate((Iterable)criteria.getFilters())).stream().collect(Collectors.toList());
        HashSet<HierInst> selObsShapes = new HashSet<HierInst>();
        for (HierInst hierInst : items) {
            if (!(hierInst.getDbObject() instanceof LayerShape)) continue;
            LayerShape ls = (LayerShape)hierInst.getDbObject();
            Obstacle obs = (Obstacle)Obstacle.class.cast(ls.getOwner());
            selObsShapes.add(HierInst.create((DevicePath)hierInst.getPath(), (DbObject)obs));
        }
        return AStream.of(selObsShapes);
    }

    public static AStream<DevicePath> getDevices(ARect r) {
        SelectionCriteria criteria = new SelectionCriteria();
        criteria.clearFilters();
        criteria.clearPropertyFilters();
        criteria.setSelArea((AGeom)r);
        criteria.setNetFilterConsidersConnectedNets(false);
        criteria.setMode(Selection.Mode.Intersect);
        SelectionContext selCtx = SelectionContext.create((Db)OrbitIO.getCurDb());
        Selector selector = Selectors.DeviceSelector.Descriptor.createSelector(selCtx);
        List items = selector.getMatching((AGeom)r, Selection.AreaMode.Touch, criteria.getPropertyFilters(), Selection.Filters.aggregate((Iterable)criteria.getFilters())).stream().collect(Collectors.toList());
        LinkedList<DevicePath> selPaths = new LinkedList<DevicePath>();
        for (HierInst hierInst : items) {
            if (!(hierInst.getDbObject() instanceof Device)) continue;
            selPaths.add(new DevicePath(hierInst.getPath(), (Device)hierInst.getDbObject()));
        }
        return AStream.of(selPaths);
    }

    public static AStream<HierInst<Wire>> getWires(ARect r) {
        SelectionCriteria criteria = new SelectionCriteria();
        criteria.clearFilters();
        criteria.clearPropertyFilters();
        criteria.setSelArea((AGeom)r);
        criteria.setNetFilterConsidersConnectedNets(false);
        criteria.setMode(Selection.Mode.Intersect);
        SelectionContext selCtx = SelectionContext.create((Db)OrbitIO.getCurDb());
        Selector selector = Selectors.WireSelector.Descriptor.createSelector(selCtx);
        List items = selector.getMatching((AGeom)r, Selection.AreaMode.Touch, criteria.getPropertyFilters(), Selection.Filters.aggregate((Iterable)criteria.getFilters())).stream().collect(Collectors.toList());
        LinkedList<HierInst> selWires = new LinkedList<HierInst>();
        for (HierInst hierInst : items) {
            if (!(hierInst.getDbObject() instanceof Wire)) continue;
            selWires.add(HierInst.create((DevicePath)hierInst.getPath(), (DbObject)((Wire)hierInst.getDbObject())));
        }
        return AStream.of(selWires);
    }

    public static AStream<HierInst<PinInstance>> getPins(ARect r) {
        SelectionCriteria criteria = new SelectionCriteria();
        criteria.clearFilters();
        criteria.clearPropertyFilters();
        criteria.setSelArea((AGeom)r);
        criteria.setNetFilterConsidersConnectedNets(false);
        criteria.setMode(Selection.Mode.Intersect);
        LinkedList dbObjects = AUtil.linkedList((Iterator)new Selectors.DevicePortSelector(SelectionContext.create((Db)OrbitIO.getCurDb())).getMatching((AGeom)r, Selection.AreaMode.Touch, criteria.getPropertyFilters(), Selection.Filters.aggregate((Iterable)criteria.getFilters())));
        LinkedList<HierInst> pins = new LinkedList<HierInst>();
        for (HierInst h : dbObjects) {
            if (!(h.getDbObject() instanceof PinInstance)) continue;
            pins.add(HierInst.create((DevicePath)h.getPath(), (DbObject)((PinInstance)h.getDbObject())));
        }
        return AStream.of(pins);
    }
}

