/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AFile;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.acl.xml.AXslUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.JedecAlphabet;
import com.sigrity.orbit.OrbitIO;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BallMapOut {
    public static boolean LoggedExportConfigFilePath = false;

    public static boolean showFor(String strDevicePath) {
        AFileChooser fc = new AFileChooser();
        fc.setDialogTitle("Export Ball Map");
        fc.setAcceptAllFileFilterUsed(false);
        for (ExportConfig ec : BallMapOut.getExportConfigs()) {
            fc.addChoosableFileFilter((FileFilter)((Object)new ExportConfigFileFilter(ec)));
        }
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        String exportConfigName = ((ExportConfigFileFilter)((Object)fc.getFileFilter())).getExportConfig().getName();
        Cp.exec((String)"com.sigrity.orbit.export.BallMapOut.write(curDb(), \"%s\", %s, \"%s\")", (Object[])new Object[]{strDevicePath, Cp.getFileAsArgument((File)f), exportConfigName});
        return true;
    }

    public static List<ExportConfig> getExportConfigs() {
        File file = Settings.findConfigFile((String)"BallMapOut.xml");
        if (file == null) {
            ALog.logError((String)"Unable to find BallMapOut.xml configuration file.");
            return null;
        }
        if (!LoggedExportConfigFilePath) {
            LoggedExportConfigFilePath = true;
            try {
                ALog.logDebug((String)"Using output configuration from '%s'.", (Object[])new Object[]{file.getCanonicalPath()});
            }
            catch (IOException e) {
                ALog.logDebug((String)"Using output configuration from '%s'.", (Object[])new Object[]{file.getAbsolutePath()});
            }
        }
        LinkedList<ExportConfig> res = new LinkedList<ExportConfig>();
        Element doc = AXDomUtil.getDocumentElement((File)file);
        String defFmtName = doc.getAttribute("default");
        ExportConfig ecDefault = null;
        for (Element xeExportOption : AXDomUtil.getChildElems((Node)doc, (String)"ExportOption")) {
            ExportConfig ec = ExportConfig.fromXml(xeExportOption);
            if (ec == null) continue;
            if (defFmtName != null && defFmtName.length() > 0 && ec.getName().equals(defFmtName)) {
                ecDefault = ec;
            }
            res.add(ec);
        }
        if (ecDefault != null) {
            res.remove(ecDefault);
            res.add(0, ecDefault);
        }
        return res;
    }

    public static ExportConfig getExportConfig(String exportConfigName) {
        ExportConfig defaultExportConfig = null;
        for (ExportConfig exportConfig : BallMapOut.getExportConfigs()) {
            if (exportConfig.getName().equals(exportConfigName)) {
                return exportConfig;
            }
            if (defaultExportConfig != null) continue;
            defaultExportConfig = exportConfig;
        }
        return defaultExportConfig;
    }

    public static void write(Db db, String packagePathString, String fileName) {
        BallMapOut.write(db, packagePathString, fileName, null);
    }

    public static void write(Db db, String packagePathString, String fileName, String exportConfigName) {
        DevicePath dp = DevicePath.fromString((Db)db, (String)packagePathString);
        if (dp == null) {
            ALog.logError((String)("Device " + packagePathString + " not found"));
            return;
        }
        ExportConfig exportConfig = BallMapOut.getExportConfig(exportConfigName);
        if (exportConfig == null) {
            ALog.logError((String)"Ball map out configuration named '%s' was not found, output aborted.", (Object[])new Object[]{exportConfigName});
            return;
        }
        exportConfig.setExportDevicePath(dp);
        exportConfig.setExporFile(fileName);
        ALog.logInfo((String)"Exporting ball map file: %s", (Object[])new Object[]{fileName});
        final DeviceTemplate devT = dp.getDeviceTemplate();
        IterableIterator hPins = devT.getDescendantPins();
        FilteringIterator<HierInst<PinTemplate>> ballHPins = new FilteringIterator<HierInst<PinTemplate>>((Iterator)hPins){

            protected boolean include(HierInst<PinTemplate> pT) {
                return ((PinTemplate)pT.getDbObject()).getType() == PinTemplate.Type.BALLPAD && ((PinTemplate)pT.getDbObject()).getSubstrate() == devT.getSubstrate();
            }
        };
        HierInst[][] portMatrix = devT.getHierPortMatrix((Iterable)ballHPins);
        int length = portMatrix.length;
        Element xdoc = AXDomUtil.createXmlDoc((String)"BallMap");
        AXDomUtil.addElementWithText((Element)xdoc, (String)"Device", (String)packagePathString);
        HashSet<Personality> personalities = new HashSet<Personality>();
        Element xePersonalities = AXDomUtil.addElement((Element)xdoc, (String)"Personalities");
        boolean err = false;
        for (int row = 0; !err && row < length; ++row) {
            Element xeRow = AXDomUtil.addElement((Element)xdoc, (String)"Row");
            xeRow.setAttribute("name", JedecAlphabet.getNth((int)row));
            for (int col = 0; !err && col < portMatrix[row].length; ++col) {
                Personality pinPers;
                Element xeCol = AXDomUtil.addElement((Element)xeRow, (String)"Column");
                xeCol.setAttribute("name", String.format("%s", col + 1));
                HierInst hMatrixPinT = portMatrix[row][col];
                HierInst hPinT = null;
                if (hMatrixPinT != null) {
                    hPinT = new HierInst(dp.addPath(hMatrixPinT.getPath()), (DbObject)((PinTemplate)hMatrixPinT.getDbObject()));
                }
                boolean bl = err = !exportConfig.outputPinCell(xeCol, hPinT);
                PinInstance pin = hPinT == null ? null : (hPinT.getPath() == null ? null : (hPinT.getPath().isEmpty() ? null : hPinT.getPath().getLast().getPin((PinTemplate)hPinT.getDbObject())));
                Personality personality = pinPers = pin == null ? null : pin.getPersonality();
                if (pinPers == null) continue;
                personalities.add(pinPers);
            }
        }
        LinkedList ps = AUtil.linkedList(personalities);
        Collections.sort(ps, new Comparator<Personality>(){

            @Override
            public int compare(Personality l, Personality r) {
                return l.getName().compareTo(r.getName());
            }
        });
        for (Personality p : ps) {
            Element xePers = AXDomUtil.addElement((Element)xePersonalities, (String)"Personality");
            xePers.setAttribute("name", BallMapOut.getName(p));
            Color c = p.getColor();
            if (c == null) continue;
            xePers.setAttribute("color", AColor.formatColor((Color)c));
            xePers.setAttribute("contrastColor", AColor.formatColor((Color)BallMapOut.getContrastColor(c)));
        }
        exportConfig.transform(xdoc, fileName);
        ALog.logInfo((String)"Ball map export complete.");
    }

    public static String getName(Personality p) {
        return p.getName().replace('.', '_');
    }

    public static Color getContrastColor(Color c) {
        long yiq = ((long)c.getRed() * 299L + (long)c.getGreen() * 587L + (long)c.getBlue() * 114L) / 1000L;
        return yiq >= 128L ? Color.BLACK : Color.WHITE;
    }

    public static class ExportConfig {
        protected String mName;
        protected String mDesc;
        protected String mFileExt;
        protected String mXslStylesheet;
        protected String mColumnScript;
        protected Interpreter mInterpreter;

        public static ExportConfig fromXml(Element xe) {
            String name = xe.getAttribute("name");
            String desc = AXDomUtil.getTextContent((Node)xe, (String)"Description");
            String fileExt = AXDomUtil.getTextContent((Node)xe, (String)"FileExt");
            String xslStylesheet = AXDomUtil.getTextContent((Node)xe, (String)"XslTransform");
            String colScript = AXDomUtil.getTextContent((Node)xe, (String)"Column");
            return new ExportConfig(name, desc, fileExt, xslStylesheet, colScript);
        }

        public ExportConfig(String name, String desc, String fileExt, String xslStylesheet, String columScript) {
            this.mName = name;
            this.mDesc = desc;
            this.mFileExt = fileExt;
            this.mXslStylesheet = xslStylesheet;
            this.mColumnScript = columScript;
            this.mInterpreter = Cp.getCp().createChildInterpreter();
            try {
                this.mInterpreter.eval("import com.sigrity.orbit.export.BallMapOut;import com.sigrity.acl.xml.AXDomUtil;");
                String script = String.format("_ColumnScript() { %s }", this.mColumnScript);
                this.mInterpreter.eval(script);
            }
            catch (EvalError e) {
                ALog.logError((Throwable)e, (String)"Error during interpretter initialization.", (Object[])new Object[0]);
            }
        }

        public String getName() {
            return this.mName;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public String getFileExt() {
            return this.mFileExt;
        }

        public void setExportDevicePath(DevicePath dp) {
            try {
                this.mInterpreter.set("exportDevPath", (Object)dp);
            }
            catch (EvalError e) {
                ALog.logError((Throwable)e, (String)"Error initializing export configuration.", (Object[])new Object[0]);
            }
        }

        public void setExporFile(String fileName) {
            try {
                this.mInterpreter.set("exportFile", (Object)fileName);
            }
            catch (EvalError e) {
                ALog.logError((Throwable)e, (String)"Error initializing export configuration.", (Object[])new Object[0]);
            }
        }

        public boolean outputPinCell(Element xeColumn, HierInst<PinTemplate> hPinT) {
            try {
                this.mInterpreter.set("curPin", hPinT);
                this.mInterpreter.set("xmlElement", (Object)xeColumn);
                Cp.eval((Interpreter)this.mInterpreter, (String)"_ColumnScript();", (boolean)true);
            }
            catch (EvalError e) {
                ALog.logError((Throwable)e, (String)"The Column scipt of the BallMapOut.ExportConfig  generated an error, output aborted:\n%s", (Object[])new Object[]{this.mColumnScript});
                return false;
            }
            return true;
        }

        public void transform(Element xe, String outputFilePath) {
            if (this.mXslStylesheet == null || this.mXslStylesheet.isEmpty()) {
                try (FileOutputStream os = new FileOutputStream((String)outputFilePath);){
                    AXDomUtil.serialize((Node)xe, (OutputStream)os);
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Error writing ball map output.", (Object[])new Object[0]);
                }
                return;
            }
            File xslFile = Settings.findConfigFile((String)this.mXslStylesheet);
            if (xslFile == null) {
                ALog.logError((String)"Unable to locate '%s', ball map output will not be generated.", (Object[])new Object[]{this.mXslStylesheet});
            } else {
                String ext = AFile.getExtension((File)new File((String)outputFilePath));
                if (ext == null && this.mFileExt != null) {
                    if (!((String)outputFilePath).endsWith(".")) {
                        outputFilePath = (String)outputFilePath + ".";
                    }
                    outputFilePath = (String)outputFilePath + ext;
                }
                try (FileInputStream isXsl = new FileInputStream(xslFile);
                     FileOutputStream osHtml = new FileOutputStream((String)outputFilePath);){
                    AXslUtil.xslTransform((Node)xe, (InputStream)isXsl, (OutputStream)osHtml);
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Error writting HTML ball map file.", (Object[])new Object[0]);
                }
            }
        }
    }

    public static class ExportConfigFileFilter
    extends AFileFilter {
        protected ExportConfig mExportConfig;

        public ExportConfigFileFilter(ExportConfig ec) {
            super(ec.getFileExt(), ec.getName());
            this.mExportConfig = ec;
        }

        public ExportConfig getExportConfig() {
            return this.mExportConfig;
        }
    }
}

