/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import au.com.bytecode.opencsv.CSVParser;
import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.AFile;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AggregateIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.dbui.render.DeviceTemplateTypeListRenderer;
import com.sigrity.acl.dbui.render.SubstrateListRenderer;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.JedecAlphabet;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.DeviceConflictHelper;
import com.sigrity.orbit.factory.DeviceFactory;
import com.sigrity.orbit.ui.DevicePathChooser;
import com.sigrity.orbit.ui.DieExtentsUI;
import com.sigrity.orbit.ui.common.PinTypeSelector;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections15.multimap.MultiHashMap;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BgaDieTxtIO {
    public static final String TXT_FILE_EXT = "txt";
    public static final String CSV_FILE_EXT = "csv";
    public static final AFileFilter SUPPORTED_FILE_FILTER = new AFileFilter(new String[]{"txt", "csv"}, "Text and CSV files");
    public static final AFileFilter TXT_FILE_FILTER = AFileFilter.TXT;
    public static final AFileFilter CSV_FILE_FILTER = AFileFilter.CSV;
    public static final String PATTERN_COORD = "\\(([-+]?\\d*\\.?\\d+)\\s+([-+]?\\d*\\.?\\d+)\\)";
    public static final String PATTERN_TWO_COORDS = String.format("\\(%s\\s+%s\\)", "\\(([-+]?\\d*\\.?\\d+)\\s+([-+]?\\d*\\.?\\d+)\\)", "\\(([-+]?\\d*\\.?\\d+)\\s+([-+]?\\d*\\.?\\d+)\\)");
    protected static String sExportPadstackName = null;
    protected static final String BEGIN_PADSTACKS = "Begin padstacks:";
    protected static final String END_PADSTACKS = "End padstacks.";
    protected static final String PINUSE_NC = "NC";
    protected static boolean sCoordsRelCenter = false;
    protected static boolean sMatrixRenamePins = false;
    protected static String sExportFormat = null;
    protected static PinTemplate.Type[] sExportPinTypes = null;

    private BgaDieTxtIO() {
    }

    public static void setExportPadstackName(String name) {
        sExportPadstackName = name;
    }

    public static void setCoordsRelCenter(boolean b) {
        sCoordsRelCenter = b;
    }

    public static void setMatrixRenamePins(boolean b) {
        sMatrixRenamePins = b;
    }

    public static void setExportFormat(String key) {
        sExportFormat = key;
    }

    public static void setExportPinTypes(PinTemplate.Type ... types) {
        sExportPinTypes = types;
    }

    public static ImportUI showImportUI(DeviceTemplate.Type deviceType, String filePath) {
        ImportUI iui = new ImportUI(OrbitIO.getMainWindow());
        if (deviceType != null) {
            iui.setDeviceType(deviceType);
        }
        if (filePath != null) {
            iui.setFilePath(filePath);
        }
        iui.setVisible(true);
        return iui;
    }

    public static ImportUI showImportUI(DeviceTemplate.Type deviceType) {
        return BgaDieTxtIO.showImportUI(deviceType, null);
    }

    public static ImportUI showImportUI() {
        return BgaDieTxtIO.showImportUI(null);
    }

    public static ExportUI showExportUI(Db db, String devicePath) {
        if (db == null) {
            JOptionPane.showMessageDialog(OrbitIO.getMainWindow(), "No open design.", "Error", 0);
            return null;
        }
        ExportUI eui = new ExportUI(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), devicePath);
        eui.setVisible(true);
        return eui;
    }

    public static void exportDevice(Db db, String devicePath, String filePath) {
        Exporter exporter = new Exporter(db);
        exporter.exportDevice(devicePath, filePath);
    }

    public static void importDevice(Db db, String parentDevicePath, String filePath, DeviceTemplate.Type dtType, PinTemplate.Type ptType, Double padSize) {
        Importer importer = BgaDieTxtIO.createImporter(db, dtType, ptType, padSize);
        if (importer != null) {
            importer.importFile(parentDevicePath, filePath);
        }
    }

    public static Importer createImporter(Db db, DeviceTemplate.Type dtType, PinTemplate.Type ptType, Double padSize) {
        if (db == null) {
            ALog.logError((String)"An existing design must be provided for import.");
            return null;
        }
        Importer importer = new Importer(db);
        if (dtType != null) {
            importer.setImportDeviceType(dtType);
        }
        if (ptType != null) {
            importer.setImportPinType(ptType);
        }
        if (padSize != null) {
            long d = padSize.longValue();
            Design design = Design.getDesign((Db)db);
            if (design != null) {
                Unit.Distance u = design.getUnit();
                d = u.fromUser(padSize.doubleValue());
            }
            Object padShape = null;
            padShape = ptType == PinTemplate.Type.BALLPAD || ptType == null && dtType == DeviceTemplate.Type.PACKAGE ? new ACircle(0L, 0L, Math.round((double)d / 2.0)) : new ARect(-d / 2L, -d / 2L, d / 2L, d / 2L);
            importer.setImportPadShape((AGeom)padShape);
        }
        return importer;
    }

    public static void importDie(Db db, String parentDevicePath, String filePath, double bumpSize) {
        BgaDieTxtIO.importDevice(db, parentDevicePath, filePath, DeviceTemplate.Type.DIE, PinTemplate.Type.BUMPPAD, bumpSize);
    }

    public static void importBga(Db db, String parentDevicePath, String filePath, double ballSize) {
        BgaDieTxtIO.importDevice(db, parentDevicePath, filePath, DeviceTemplate.Type.PACKAGE, PinTemplate.Type.BALLPAD, ballSize);
    }

    public static void importDevice(Db db, String parentDevicePath, String filePath) {
        BgaDieTxtIO.importDevice(db, parentDevicePath, filePath, null, null, null);
    }

    public static void importDevice(Db db, String parentDevicePath, String filePath, double padSize) {
        BgaDieTxtIO.importDevice(db, parentDevicePath, filePath, null, null, padSize);
    }

    public static List<ExportFormat> getExportFormats(DeviceTemplate.Type dtType) {
        File file = Settings.findConfigFile((String)"BgaDieTxtIO.xml");
        if (file == null) {
            ALog.logError((String)"Unable to find BgaDieTxtIO.xml configuration file.");
            return null;
        }
        try {
            ALog.logDebug((String)"Using output configuration from '%s'.", (Object[])new Object[]{file.getCanonicalPath()});
        }
        catch (IOException e) {
            ALog.logDebug((String)"Using output configuration from '%s'.", (Object[])new Object[]{file.getAbsolutePath()});
        }
        Element doc = AXDomUtil.getDocumentElement((File)file);
        AXDomUtil.ElemItr sections = dtType == DeviceTemplate.Type.DIE ? AXDomUtil.getChildElems((Node)doc, (String)"DieExport") : (dtType == DeviceTemplate.Type.PACKAGE ? AXDomUtil.getChildElems((Node)doc, (String)"BgaExport") : AggregateIterator.itr((Iterable[])new Iterable[]{AXDomUtil.getChildElems((Node)doc, (String)"DieExport"), AXDomUtil.getChildElems((Node)doc, (String)"BgaExport")}));
        LinkedList<ExportFormat> res = new LinkedList<ExportFormat>();
        String defFmtName = null;
        for (Element elSection : sections) {
            String curTag = elSection.getTagName();
            DeviceTemplate.Type curType = DeviceTemplate.Type.UNKNOWN;
            if (curTag.equalsIgnoreCase("DieExport")) {
                curType = DeviceTemplate.Type.DIE;
            } else if (curTag.equalsIgnoreCase("BgaExport")) {
                curType = DeviceTemplate.Type.PACKAGE;
            }
            if (defFmtName == null || defFmtName.isEmpty()) {
                defFmtName = elSection.getAttribute("default");
            }
            for (Element elOutFmt : AXDomUtil.getChildElems((Node)elSection, (String)"OutputFormat")) {
                ExportFormat tef = ExportFormat.fromXml(curType, elOutFmt);
                if (tef == null) continue;
                if (defFmtName != null && defFmtName.length() > 0 && tef.getName().equals(defFmtName)) {
                    tef.setDefault(true);
                }
                res.add(tef);
            }
        }
        return res;
    }

    public static ExportFormat getExportFormat(String key) {
        if (key == null) {
            return null;
        }
        for (ExportFormat ef : BgaDieTxtIO.getExportFormats(null)) {
            if (!key.equals(ef.getKey())) continue;
            return ef;
        }
        return null;
    }

    public static ExportFormat getDefaultExportFormat(DeviceTemplate.Type type) {
        for (ExportFormat ef : BgaDieTxtIO.getExportFormats(type)) {
            if (!ef.getDefault()) continue;
            return ef;
        }
        Optional ef = BgaDieTxtIO.getExportFormats(type).stream().findFirst();
        if (ef.isPresent()) {
            return (ExportFormat)ef.get();
        }
        return null;
    }

    public static APoint2D getOriginOffset(DevicePath startPath) {
        if (!sCoordsRelCenter) {
            return null;
        }
        Substrate substrate = startPath.getSubstrate();
        if (substrate == null) {
            return null;
        }
        DevicePath dpSubstrate = startPath.pathToParent(substrate);
        if (dpSubstrate == null) {
            return null;
        }
        DeviceTemplate dtSubstrate = dpSubstrate.getFirst().getTemplate();
        if (dtSubstrate == null) {
            return null;
        }
        ARect bbSubstrate = dtSubstrate.getBB();
        if (bbSubstrate == null) {
            return null;
        }
        bbSubstrate.moveLLTo(APoint2D.Zero());
        APoint2D originOffset = bbSubstrate.center().sub(new APoint2D());
        double shrinkAmount = dtSubstrate.getShrinkAmount();
        if (shrinkAmount != 0.0) {
            AffineTransform t = new AffineTransform();
            t.scale(1.0 / (1.0 - shrinkAmount), 1.0 / (1.0 - shrinkAmount));
            originOffset.transform(t);
        }
        if (originOffset.getX() == 0L && originOffset.getY() == 0L) {
            originOffset = null;
        }
        return originOffset;
    }

    public static class AllegroPinUseMapper {
        public static PinTemplate.Use getOrbitPinUseBy(AllegroPinUse use) {
            if (use == AllegroPinUse.UNSPEC || use == null) {
                return PinTemplate.Use.SIGNAL;
            }
            if (use == AllegroPinUse.IN || use == AllegroPinUse.OUT || use == AllegroPinUse.BI) {
                return PinTemplate.Use.SIGNAL;
            }
            return PinTemplate.Use.valueOf((String)use.name());
        }

        public static PinTemplate.Direction getOrbitPinDirBy(AllegroPinUse use) {
            if (use == AllegroPinUse.IN) {
                return PinTemplate.Direction.IN;
            }
            if (use == AllegroPinUse.OUT || use == AllegroPinUse.TRI || use == AllegroPinUse.OCA || use == AllegroPinUse.OCL) {
                return PinTemplate.Direction.OUT;
            }
            if (use == AllegroPinUse.BI || use == AllegroPinUse.POWER || use == AllegroPinUse.GROUND) {
                return PinTemplate.Direction.INOUT;
            }
            return PinTemplate.Direction.INOUT;
        }

        public static Net.Use getOrbitNetUseBy(AllegroPinUse use) {
            if (use == AllegroPinUse.TRI || use == AllegroPinUse.OCA || use == AllegroPinUse.OCL) {
                return Net.Use.SIGNAL;
            }
            return Net.Use.valueOf((String)AllegroPinUseMapper.getOrbitPinUseBy(use).name());
        }

        public static Net.Direction getOrbitNetDirBy(AllegroPinUse use) {
            return Net.Direction.valueOf((String)AllegroPinUseMapper.getOrbitPinDirBy(use).name());
        }

        public static Term.Use getOrbitTermUseBy(AllegroPinUse use) {
            if (use == AllegroPinUse.NC) {
                return Term.Use.SIGNAL;
            }
            return Term.Use.valueOf((String)AllegroPinUseMapper.getOrbitNetUseBy(use).name());
        }

        public static Term.Type getOrbitTermTypeBy(AllegroPinUse use) {
            return Term.Type.valueOf((String)AllegroPinUseMapper.getOrbitPinDirBy(use).name());
        }

        public static AllegroPinUse getAllegroPinUseBy(String use) {
            if (use.isBlank()) {
                return null;
            }
            return AllegroPinUse.valueOf(use);
        }

        public static AllegroPinUse getAllegroPinUseBy(PinTemplate pinT) {
            PinTemplate.Use use = pinT.getUse();
            PinTemplate.Direction dir = pinT.getDirection();
            if (use == PinTemplate.Use.GROUND || use == PinTemplate.Use.NC || use == PinTemplate.Use.OCA || use == PinTemplate.Use.OCL || use == PinTemplate.Use.TRI || use == PinTemplate.Use.POWER) {
                return AllegroPinUse.valueOf(use.name());
            }
            if (use == PinTemplate.Use.SIGNAL) {
                if (dir == PinTemplate.Direction.IN) {
                    return AllegroPinUse.IN;
                }
                if (dir == PinTemplate.Direction.OUT) {
                    return AllegroPinUse.OUT;
                }
                if (dir == PinTemplate.Direction.INOUT) {
                    return AllegroPinUse.BI;
                }
            }
            return AllegroPinUse.UNSPEC;
        }

        public static enum AllegroPinUse {
            UNSPEC,
            POWER,
            GROUND,
            NC,
            IN,
            OUT,
            BI,
            TRI,
            OCA,
            OCL;

        }
    }

    public static class ExportPinData {
        protected static final DecimalFormat FMT_ROTATE = new DecimalFormat("#.######");
        public final HierPort hierarchicalPin;
        public final Unit unit;
        public final APoint2D originOffset;
        public final HierPort connectedBall;
        public final DevicePath devicePath;
        public final Device device;
        public final DeviceTemplate deviceTemplate;
        public final DeviceTemplate.Type deviceType;
        public final PinInstance pinInstance;
        public final PinTemplate pinTemplate;
        public final APoint2D location;
        public final Net net;
        public final Net substNet;
        public final String termName;
        public final String allegroPinUse;
        public final String name;
        public final String x;
        public final String y;
        public final String rot;
        public final String netName;
        public final String substNetName;
        public final String padstackName;
        public final String deviceName;
        public final Net packageNet;
        public final String matrixPinName;
        public final String packageNetName;

        public ExportPinData(ExportInfo exportData, HierPort hierarchicalPin, Unit unit, HierPort connectedBall, String pinName) {
            DevicePath startPath = exportData.getExportDevicePath();
            this.hierarchicalPin = hierarchicalPin;
            this.unit = unit;
            this.originOffset = BgaDieTxtIO.getOriginOffset(startPath);
            this.connectedBall = connectedBall;
            this.matrixPinName = pinName;
            this.devicePath = hierarchicalPin.getPath();
            this.device = this.devicePath.getLast();
            this.deviceTemplate = this.device.getTemplate();
            this.deviceType = this.deviceTemplate.getType();
            this.pinInstance = hierarchicalPin.getPin();
            this.pinTemplate = this.pinInstance.getPinTemplate();
            this.name = Exporter.determinePinName(this.pinInstance);
            this.deviceName = this.device.getName();
            this.allegroPinUse = String.valueOf((Object)AllegroPinUseMapper.getAllegroPinUseBy(this.pinTemplate));
            Term term = PinLabel.get((PinTemplate)this.pinTemplate).getTerm();
            this.termName = term != null ? term.getName() : "";
            APoint2D pinSubLoc = this.getSubstrateLocWithShrink(hierarchicalPin, startPath);
            if (this.originOffset != null) {
                pinSubLoc = pinSubLoc.sub(this.originOffset);
            }
            this.location = pinSubLoc;
            this.x = unit == null ? Long.toString(this.location.getX()) : "" + unit.toUser(this.location.getX());
            this.y = unit == null ? Long.toString(this.location.getY()) : "" + unit.toUser(this.location.getY());
            this.rot = FMT_ROTATE.format(hierarchicalPin.getSubstrateRotate());
            this.padstackName = sExportPadstackName != null ? sExportPadstackName : this.pinInstance.getPadTemplate().getName();
            this.net = this.pinTemplate.getNet();
            this.netName = this.net == null ? "" : this.net.getName();
            DeviceTemplate exportDevT = startPath.getDeviceTemplate();
            Net substrateNet = NetMap.getNetAt((Net)hierarchicalPin.getNet(), (DevicePath)hierarchicalPin.getPath(), (DeviceTemplate)exportDevT);
            if (substrateNet != null && substrateNet.getDeviceTemplate() != exportDevT) {
                substrateNet = exportDevT.getNetUnused();
            }
            this.substNet = substrateNet;
            String string = this.substNetName = this.substNet == null ? "" : this.substNet.getName();
            if (exportData.isDie()) {
                DevicePath packagePath;
                Net pkgNet = null;
                String pkgNetName = "";
                if (connectedBall != null && (packagePath = connectedBall.getPath().pathToSubstrate()) != null && (pkgNet = NetMap.getNetAt((Net)hierarchicalPin.getNet(), (DevicePath)((DevicePath)hierarchicalPin.first), (DeviceTemplate)packagePath.getFirst().getTemplate())) != null) {
                    pkgNetName = pkgNet.getName();
                }
                this.packageNet = pkgNet;
                this.packageNetName = pkgNetName;
            } else {
                this.packageNet = null;
                this.packageNetName = null;
            }
        }

        public String getUserDesc() {
            return String.format("%s pin %s", this.hierarchicalPin.getPath().toString(), this.hierarchicalPin.getPin().getName());
        }

        public APoint2D getSubstrateLocWithShrink(HierPort hPort, DevicePath startPath) {
            DevicePath dp = ((DevicePath)hPort.first).pathToParent(startPath);
            DeviceTemplate substrateTemplate = dp.getFirst().getTemplate();
            double shrinkAmount = substrateTemplate.getShrinkAmount();
            dp.removeFirst();
            if (shrinkAmount == 0.0) {
                return ((PortTemplate)hPort.second).getWorldLoc(dp);
            }
            AffineTransform t = new AffineTransform();
            t.scale(1.0 / (1.0 - shrinkAmount), 1.0 / (1.0 - shrinkAmount));
            return ((PortTemplate)hPort.second).getWorldLocWithShrink(dp, t);
        }
    }

    public static class ExportInfo {
        protected DevicePath mDPath;
        protected File mFile;
        protected PinTemplate.Type[] mPinTypes;
        protected boolean mMatrixRename;

        protected ExportInfo(DevicePath exportDevice, File outputFile, PinTemplate.Type[] pinTypes) {
            this.mDPath = exportDevice;
            this.mFile = outputFile;
            this.mPinTypes = pinTypes;
            this.mMatrixRename = false;
        }

        protected ExportInfo(DevicePath exportDevice, File outputFile, PinTemplate.Type[] pinTypes, boolean matrixRename) {
            this.mDPath = exportDevice;
            this.mFile = outputFile;
            this.mPinTypes = pinTypes;
            this.mMatrixRename = matrixRename;
        }

        public File getOutputFile() {
            return this.mFile;
        }

        public DevicePath getExportDevicePath() {
            return this.mDPath;
        }

        public DeviceTemplate getExportDeviceTemplate() {
            return this.mDPath.getDeviceTemplate();
        }

        public Device getExportDevice() {
            return this.mDPath.getDevice();
        }

        public DeviceTemplate.Type getExportDeviceType() {
            return this.getExportDeviceTemplate().getType();
        }

        public PinTemplate.Type[] getPinTypes() {
            return this.mPinTypes;
        }

        public String getPadLayerName() {
            return this.getPadLayer() == null ? null : this.getPadLayer().getName();
        }

        public Layer getPadLayer() {
            return ExportInfo.determinePadLayer(this.mDPath, this.getPinTypes());
        }

        public boolean doMatrixRename() {
            return this.mMatrixRename;
        }

        public boolean isDie() {
            return this.getExportDeviceTemplate().isDie();
        }

        public boolean isPackage() {
            return this.getExportDeviceTemplate().isPackage();
        }

        public boolean isPackageDie() {
            return this.getExportDeviceType() == DeviceTemplate.Type.PACKAGEDDIE;
        }

        protected static Layer determinePadLayer(DevicePath startPath, PinTemplate.Type[] pinTypes) {
            HashSet<PinTemplate.Type> pinTypeSet = pinTypes == null ? null : new HashSet<PinTemplate.Type>(Arrays.asList(pinTypes));
            for (DevicePath path : startPath.getDescendants(true)) {
                for (PinInstance pin : path.getLast().getPins()) {
                    Optional ls;
                    if (pinTypeSet != null && !pinTypeSet.contains(pin.getType()) || !(ls = pin.getLayersInUse().findFirst()).isPresent()) continue;
                    return (Layer)ls.get();
                }
            }
            return null;
        }
    }

    public static class ExportFormat {
        protected DeviceTemplate.Type mDeviceType = DeviceTemplate.Type.UNKNOWN;
        protected String mName;
        protected String mDesc;
        protected String mFileHeader;
        protected String mPinHeader;
        protected String mPinDetail;
        protected boolean mDefault = false;

        public static ExportFormat fromXml(DeviceTemplate.Type deviceType, Element e) {
            String name = e.getAttribute("name");
            String desc = AXDomUtil.getTextContent((Node)e, (String)"Description");
            String fileHeader = AXDomUtil.getTextContent((Node)e, (String)"FileHeader");
            String header = AXDomUtil.getTextContent((Node)e, (String)"PinHeader");
            String detail = AXDomUtil.getTextContent((Node)e, (String)"PinDetail");
            if (name == null || name.length() == 0) {
                ALog.logError((String)"Found XML OutputFormat element with no name. It is being ignored. The content of the element is:\n%s", (Object[])new Object[]{AXDomUtil.serialize((Node)e)});
                return null;
            }
            return new ExportFormat(deviceType, name, desc, fileHeader, header, detail);
        }

        public ExportFormat(DeviceTemplate.Type deviceType, String name, String desc, String fileHeader, String pinHeader, String detail) {
            this.mDeviceType = deviceType;
            this.mName = name;
            this.mDesc = desc;
            this.mFileHeader = fileHeader;
            this.mPinHeader = pinHeader;
            this.mPinDetail = detail;
        }

        public DeviceTemplate.Type getDeviceType() {
            return this.mDeviceType;
        }

        public void setDeviceType(DeviceTemplate.Type type) {
            this.mDeviceType = type;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public void setDesc(String desc) {
            this.mDesc = desc;
        }

        public String getFileHeader() {
            return this.mFileHeader;
        }

        public void setFileHeader(String fileHeader) {
            this.mFileHeader = fileHeader;
        }

        public String getPinHeader() {
            return this.mPinHeader;
        }

        public void setPinHeader(String header) {
            this.mPinHeader = header;
        }

        public String getPinDetail() {
            return this.mPinDetail;
        }

        public void setPinDetail(String detail) {
            this.mPinDetail = detail;
        }

        public boolean getDefault() {
            return this.mDefault;
        }

        public void setDefault(boolean b) {
            this.mDefault = b;
        }

        public String getKey() {
            return String.format("%s:%s", this.mDeviceType.name(), this.mName);
        }
    }

    public static class ExportUI
    extends ADialog {
        public static final String SETTING_SECTION = "BgaDieTxtIO-Export";
        public static final String SETTING_LASTUSED_CONFIG = "LastUsedConfig-%s";
        protected Db mDb;
        protected JTextField mTxtDevicePath;
        protected AFileChooserControl mFileChooser;
        protected JComboBox<ExportFormat> mCboFormat;
        protected JTextField mTxtPadstackName;
        protected JCheckBox mCbCoordRelCenter;
        protected JCheckBox mCbMatrixRenamePins;
        protected JTextField mScaleFactor;
        protected PinTypeSelector mPinTypeSelector;

        public ExportUI(Window owner, Db db, String devicePath) {
            super(owner, "Export Device Text");
            this.mDb = db;
            DevicePath dp = DevicePath.fromString((Db)db, (String)devicePath);
            DeviceTemplate devT = dp == null ? null : dp.getDeviceTemplate();
            DeviceTemplate.Type type = DeviceTemplate.Type.UNKNOWN;
            if (devT != null && (type = devT.getType()) == DeviceTemplate.Type.PACKAGEDDIE) {
                type = DeviceTemplate.Type.DIE;
            }
            switch (type) {
                case DIE: {
                    this.setTitle("Export Die Text");
                    break;
                }
                case PACKAGE: {
                    this.setTitle("Export BGA Text");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Device type is unsupported.");
                }
            }
            Settings settings = Settings.getSettings((String)SETTING_SECTION);
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            l.add("Device:");
            this.mTxtDevicePath = (JTextField)l.add((Component)new JTextField(30), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mTxtDevicePath.setMinimumSize(this.getPreferredSize());
            this.mTxtDevicePath.setEditable(false);
            this.mTxtDevicePath.setText(devicePath);
            l.newline();
            l.add("File:");
            this.mFileChooser = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mFileChooser.setUseSaveChooser(true);
            this.mFileChooser.setChoosableFileFilter(TXT_FILE_FILTER);
            l.newline();
            l.push("Output Options", (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.add("Format:");
            ExportFormat[] exportFormats = BgaDieTxtIO.getExportFormats(type).toArray(new ExportFormat[0]);
            this.mCboFormat = (JComboBox)l.addNl(new JComboBox<ExportFormat>(exportFormats), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mCboFormat.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value instanceof ExportFormat) {
                        ExportFormat ef = (ExportFormat)value;
                        this.setText(String.format("%s (%s)", ef.getName(), ef.getDeviceType().name()));
                        this.setToolTipText(String.format("<html>%s</html>", ef.getDesc()));
                    }
                    return this;
                }
            });
            this.mCboFormat.addActionListener(ae -> {
                Object o = this.mCboFormat.getSelectedItem();
                if (o instanceof ExportFormat) {
                    ExportFormat ef = (ExportFormat)o;
                    this.mCboFormat.setToolTipText(ef.getDesc());
                } else {
                    this.mCboFormat.setToolTipText(null);
                }
            });
            String lastUsedCfgSettingName = String.format(SETTING_LASTUSED_CONFIG, type.name());
            String dfltCfg = (String)settings.getSetting(lastUsedCfgSettingName, (Object)"");
            for (ExportFormat fmt : exportFormats) {
                if (dfltCfg != null && !dfltCfg.isEmpty() && dfltCfg.equals(fmt.getName())) {
                    this.mCboFormat.setSelectedItem(fmt);
                    break;
                }
                if (!fmt.getDefault()) continue;
                this.mCboFormat.setSelectedItem(fmt);
            }
            l.add("Export pins of type:");
            this.mPinTypeSelector = (PinTypeSelector)l.add((Component)new PinTypeSelector(Exporter.getDefaultPinTypes(type).collect(Collectors.toSet())), (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.pushFillXRemainX();
            JCheckBox cbSetPsName = (JCheckBox)l.add((Component)new JCheckBox("Override padstack name:"));
            this.mTxtPadstackName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtPadstackName.setEnabled(false);
            l.popNl();
            this.mCbCoordRelCenter = (JCheckBox)l.add((Component)new JCheckBox("Coordinates relative to device center"), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.newline();
            this.mCbMatrixRenamePins = (JCheckBox)l.add((Component)new JCheckBox("Matrix rename descendant pins"), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mCbMatrixRenamePins.setVisible(type == DeviceTemplate.Type.DIE);
            l.newline();
            l.add("Process Shrink :", (GridBagConstraints)GridBagManager.LEFT);
            this.mScaleFactor = new JTextField("1.0", 4);
            this.mScaleFactor.setToolTipText("The scale factor for the device (e.g., 0.75 to scale to 1/0.75 * 100%)");
            l.add((Component)this.mScaleFactor, (GridBagConstraints)GridBagManager.LEFT);
            l.popNl();
            l.addFillY();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            cbSetPsName.setSelected(false);
            cbSetPsName.addActionListener(ae -> this.mTxtPadstackName.setEnabled(cbSetPsName.isSelected()));
            this.mFileChooser.getTextField().requestFocus();
            btnOK.addActionListener(ae -> {
                Object o = this.mCboFormat.getSelectedItem();
                if (o instanceof ExportFormat) {
                    settings.putSetting(lastUsedCfgSettingName, (Object)((ExportFormat)o).getName());
                    settings.save();
                }
                this.ok();
            });
            Objects.requireNonNull(devT);
            double scale = 1.0 - devT.getShrinkAmount();
            this.mScaleFactor.setText(AUtil.doubleToString((double)scale, (int)1));
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            this.setMinimumSize(this.getMinimumSize());
            UIUtil.center((Component)((Object)this));
        }

        protected boolean validateParams() {
            boolean isValid = true;
            String devicePathStr = this.mTxtDevicePath.getText();
            DevicePath devPath = DevicePath.fromString((Db)this.mDb, (String)devicePathStr);
            try {
                if (devPath == null) {
                    throw AFieldValidator.createException(null, (String)"Device", null, (Component)this.mTxtDevicePath);
                }
                AFieldValidator.validateFileWritable((JTextField)this.mFileChooser.getTextField());
                if (this.mTxtPadstackName.isEnabled()) {
                    AFieldValidator.validateText((JTextComponent)this.mTxtPadstackName);
                }
                AFieldValidator.validateDouble((JTextField)this.mScaleFactor);
            }
            catch (AFieldValidator.AFieldValidationException e) {
                isValid = false;
            }
            return isValid;
        }

        protected void ok() {
            File f;
            Object filePath = this.mFileChooser.getPath().trim();
            if (((String)filePath).length() > 0 && !(f = new File((String)filePath)).getName().contains(".")) {
                filePath = (String)filePath + ".txt";
                this.mFileChooser.getTextField().setText((String)filePath);
            }
            if (!this.validateParams()) {
                return;
            }
            DevicePath devPath = DevicePath.fromString((Db)this.mDb, (String)this.mTxtDevicePath.getText());
            DeviceTemplate dt = devPath.getDeviceTemplate();
            double shrink = 1.0 - AFieldValidator.getDouble((JTextField)this.mScaleFactor, (double)1.0);
            if (shrink != dt.getShrinkAmount()) {
                Cp.exec((String)"DeviceTemplate.setShrinkAmount(\"%s\", \"%s\", %f)", (Object[])new Object[]{dt.getName(), dt.getSubstrate().getName(), shrink});
            }
            Cp.exec((String)"com.sigrity.orbit.export.BgaDieTxtIO.setExportPadstackName(%s)", (Object[])new Object[]{this.mTxtPadstackName.isEnabled() ? String.format("\"%s\"", this.mTxtPadstackName.getText()) : "null"});
            Cp.exec((String)"com.sigrity.orbit.export.BgaDieTxtIO.setCoordsRelCenter(%b)", (Object[])new Object[]{this.mCbCoordRelCenter.isSelected()});
            Cp.exec((String)"com.sigrity.orbit.export.BgaDieTxtIO.setMatrixRenamePins(%b)", (Object[])new Object[]{this.mCbMatrixRenamePins.isSelected()});
            Cp.exec((String)"com.sigrity.orbit.export.BgaDieTxtIO.setExportFormat(\"%s\")", (Object[])new Object[]{((ExportFormat)this.mCboFormat.getSelectedItem()).getKey()});
            String pinTypes = this.mPinTypeSelector.getSelectedTypes().stream().map(pt -> String.format("PinTemplate.Type.%s", pt.name())).collect(Collectors.joining(", "));
            Cp.exec((String)"com.sigrity.orbit.export.BgaDieTxtIO.setExportPinTypes(%s)", (Object[])new Object[]{pinTypes});
            Cp.exec((String)"com.sigrity.orbit.export.BgaDieTxtIO.exportDevice(curDb(), \"%s\", %s)", (Object[])new Object[]{this.mTxtDevicePath.getText(), Cp.getFileAsArgument((String)filePath)});
            UIUtil.closeWindow((Window)((Object)this));
        }
    }

    public static class ImportUI
    extends DbDialog {
        static final String DEFAULT_PAD_SIZE = "50";
        protected AFileChooserControl mFileChooser;
        protected JComboBox<DeviceTemplate.Type> mCboDevType;
        protected JTextField mTxtScale;
        protected JComboBox<Substrate> mCboSubstrate;
        protected JComboBox<PinStyle> mCboPinStyle;
        protected JRadioButton mRbAbsolute;
        protected JRadioButton mRbRelative;
        protected JButton mBtnReparent;
        protected DevicePath mRoot;
        private ActionListener mReparentSelector = ae -> {
            this.mRoot = DevicePathChooser.Dialog.createDialog((Window)((Object)this), this.mDb);
            if (this.mRoot != null) {
                this.mBtnReparent.setIcon(DbExplorerPanel.getIconForTemplate(this.mRoot.getDeviceTemplate()));
                this.mBtnReparent.setText("<html>" + this.mRoot.getDevice().getName() + "</html>");
            }
        };
        private ActionListener mOkListener = ae -> {
            Db db;
            if (!this.validateParams()) {
                return;
            }
            String deviceTemplateType = "null";
            if (this.mCboDevType.getSelectedItem() instanceof DeviceTemplate.Type) {
                DeviceTemplate.Type type = (DeviceTemplate.Type)this.mCboDevType.getSelectedItem();
                deviceTemplateType = String.format("DeviceTemplate.Type.%s", type.name());
            }
            if ((db = OrbitIO.getCurDb()) == null) {
                OrbitIO.getApp().createDesign();
            }
            db = OrbitIO.getCurDb();
            DbHistory history = db.getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Import BGA/Die Txt");){
                Cp.exec((String)"unset(\"_txtImporter\")", (Object[])new Object[0]);
                Cp.exec((String)"_txtImporter = com.sigrity.orbit.export.BgaDieTxtIO.createImporter(curDb(), %s, null, %s)", (Object[])new Object[]{deviceTemplateType, DEFAULT_PAD_SIZE});
                if (Cp.getCp().getInterpreterValue("_txtImporter") == null) {
                    ALog.logError((String)"Import failed, unablte to create BgaDieTxtIO.Importer. This appears to be a program bug. Please contact support for help.");
                    return;
                }
                Substrate substrate = (Substrate)this.mCboSubstrate.getSelectedItem();
                if (substrate != null) {
                    Cp.exec((String)"_txtImporter.setSubstrate(\"%s\")", (Object[])new Object[]{substrate.getKeyStr()});
                }
                Cp.exec((String)"_txtImporter.setImportCoordAbs(%b)", (Object[])new Object[]{this.mRbAbsolute.isSelected()});
                double scale = AFieldValidator.getDouble((JTextField)this.mTxtScale, (double)1.0);
                if (scale <= 0.0 || scale > 1.0) {
                    throw AFieldValidator.createException(null, (String)"Process shrink amount should be between 0 to 1.", null, null);
                }
                Cp.exec((String)"_txtImporter.setScale(%f)", (Object[])new Object[]{scale});
                Cp.exec((boolean)false, (String)"_txtImporter.setForcedEditPadStack(true)", (Object[])new Object[0]);
                Cp.exec((String)"_txtImporter.setInquireConflictDevice(false);", (Object[])new Object[0]);
                Cp.exec((boolean)false, (String)"_txtImporter.setInquireConflictDevice(true);", (Object[])new Object[0]);
                if (this.mRoot != null) {
                    Cp.exec((String)"_txtImporter.setNewParent(\"%s\")", (Object[])new Object[]{this.mRoot.getDevice().getKeyStr()});
                }
                Cp.exec((String)"_txtImporter.setInstAsDevice(%b)", (Object[])new Object[]{this.isInstAsDevice()});
                Device device = (Device)Cp.exec((String)"_txtImporter.importFile(\"/\", %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)this.mFileChooser.getPath())});
                if (device == null) {
                    ALog.logError((String)"Device is not created!");
                } else {
                    EventQueue.invokeLater(() -> {
                        if (device.isDie()) {
                            DieExtentsUI.showDialog(device);
                        }
                    });
                    UIUtil.closeWindow((Window)((Object)this));
                    OrbitIO.getApp().zoomFitCurrentView();
                }
            }
            catch (AFieldValidator.AFieldValidationException aFieldValidationException) {
            }
            finally {
                Cp.exec((String)"unset(\"_txtImporter\")", (Object[])new Object[0]);
            }
        };

        public ImportUI(Window owner) {
            super(OrbitIO.getCurDb(), (Component)owner, "Import BGA or Die Txt");
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            l.pushFillX("Source");
            l.add("File:");
            this.mFileChooser = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mFileChooser.setChoosableFileFilter(SUPPORTED_FILE_FILTER);
            this.mFileChooser.addChoosableFileFilter(CSV_FILE_FILTER);
            this.mFileChooser.addChoosableFileFilter(TXT_FILE_FILTER);
            l.popNl();
            l.pushFill("Options");
            l.add("Coordinates:");
            JPanel rbPanel = new JPanel();
            l.add((Component)rbPanel, (GridBagConstraints)GridBagManager.LEFT);
            GridBagManager lRb = GridBagManager.layout((Container)rbPanel);
            this.mRbAbsolute = (JRadioButton)lRb.add((Component)new JRadioButton("Absolute", false));
            this.mRbRelative = (JRadioButton)lRb.add((Component)new JRadioButton("Relative", true), (GridBagConstraints)GridBagManager.LEFT);
            this.mRbAbsolute.setToolTipText("Indicates that the X/Y coordinates for pin locations in the database file are relative to the origin of the design.");
            this.mRbRelative.setToolTipText("Indicates that the X/Y coordinates for pin locations in the database file are relative to the origin of the symbol.");
            ButtonGroup coordGroup = new ButtonGroup();
            coordGroup.add(this.mRbAbsolute);
            coordGroup.add(this.mRbRelative);
            l.newline();
            l.add("Device Type:");
            DeviceTemplate.Type[] deviceTypes = new DeviceTemplate.Type[]{null, DeviceTemplate.Type.PACKAGE, DeviceTemplate.Type.DIE};
            this.mCboDevType = (JComboBox)l.add(new JComboBox<DeviceTemplate.Type>(deviceTypes), (GridBagConstraints)GridBagManager.FILLX);
            this.mCboDevType.setRenderer(new DeviceTemplateTypeListRenderer("<From File>"));
            this.mCboDevType.setToolTipText("Die if DieType and DieOrient are not empty");
            l.newline();
            l.add("Substrate:");
            this.mCboSubstrate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX);
            this.updateAvailableSubstrates();
            this.mCboSubstrate.setRenderer(new SubstrateListRenderer());
            l.newline();
            l.add("Pin Style:");
            this.mCboPinStyle = (JComboBox)l.add(new JComboBox<PinStyle>(PinStyle.values()), (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add("Parent Device:");
            this.mBtnReparent = (JButton)l.add((Component)new JButton("<Design>"), (GridBagConstraints)GridBagManager.FILLX);
            this.mBtnReparent.setHorizontalAlignment(2);
            this.mBtnReparent.setForeground(Color.BLUE);
            this.mBtnReparent.setBackground(Color.WHITE);
            this.mBtnReparent.setOpaque(true);
            this.mBtnReparent.addActionListener(this.mReparentSelector);
            l.newline();
            l.add("Process shrink:");
            this.mTxtScale = (JTextField)l.add((Component)new JTextField("1.0", 10), (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtScale.setToolTipText("The scale factor for the device (e.g., 0.75 to scale to 75%)");
            l.popNl();
            this.mBtnReparent.setPreferredSize(this.mTxtScale.getPreferredSize());
            this.mBtnReparent.setBorder(this.mTxtScale.getBorder());
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
            btnOK.addActionListener(this.mOkListener);
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        public void setDeviceType(DeviceTemplate.Type type) {
            this.mCboDevType.setSelectedItem(type);
        }

        public void setFilePath(String filePath) {
            this.mFileChooser.getTextField().setText(filePath);
        }

        protected void updateAvailableSubstrates() {
            Object origSel = this.mCboSubstrate.getSelectedItem();
            this.mCboSubstrate.removeAllItems();
            this.mCboSubstrate.addItem(null);
            this.mCboSubstrate.setSelectedIndex(0);
            Db db = OrbitIO.getCurDb();
            LinkedList substrates = AUtil.linkedList((Iterator)db.getObjects(Substrate.class));
            Collections.sort(substrates);
            for (Substrate s : substrates) {
                this.mCboSubstrate.addItem(s);
            }
            if (origSel != null) {
                this.mCboSubstrate.setSelectedItem(origSel);
            } else {
                this.mCboSubstrate.setSelectedIndex(0);
            }
        }

        private boolean isInstAsDevice() {
            return this.mCboPinStyle.getSelectedItem() == PinStyle.DEVICE;
        }

        private boolean validateParams() {
            boolean ret = true;
            try {
                AFieldValidator.validateFileExists((JTextField)this.mFileChooser.getTextField());
                AFieldValidator.validateDouble((JTextField)this.mTxtScale);
            }
            catch (AFieldValidator.AFieldValidationException e) {
                ret = false;
            }
            return ret;
        }

        protected static enum PinStyle {
            PIN("Pin"),
            DEVICE("Device");

            private String name;

            private PinStyle(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    public static class Exporter {
        protected PrintWriter mOut = null;
        protected Db mDb;
        protected Design mDesign;
        protected Unit mUnit;
        protected long mLinesPrinted;
        protected Interpreter mInterpreter = null;
        protected ExportFormat mExportFormat = null;

        public static Stream<PinTemplate.Type> getDefaultPinTypes(DeviceTemplate.Type devType) {
            switch (devType) {
                case DIE: {
                    return AStream.of((Object[])new PinTemplate.Type[]{PinTemplate.Type.BUMPPAD, PinTemplate.Type.IOPAD, PinTemplate.Type.WIREBONDPAD, PinTemplate.Type.TSV, PinTemplate.Type.CONTACT});
                }
                case PACKAGE: {
                    return AStream.of((Object[])new PinTemplate.Type[]{PinTemplate.Type.BALLPAD, PinTemplate.Type.BONDFINGERPAD, PinTemplate.Type.CONTACT});
                }
            }
            return AStream.of((Object[])new PinTemplate.Type[]{PinTemplate.Type.BUMPPAD, PinTemplate.Type.IOPAD, PinTemplate.Type.WIREBONDPAD, PinTemplate.Type.TSV, PinTemplate.Type.BALLPAD, PinTemplate.Type.BONDFINGERPAD, PinTemplate.Type.CONTACT});
        }

        public static String determinePinName(PinInstance pinInst) {
            return pinInst.getDeviceTemplate().amIAPin() ? pinInst.getDevice().getName() : pinInst.getName();
        }

        public Exporter(Db db) {
            this.mDb = db;
            this.mDesign = Design.getDesign((Db)db);
            this.mUnit = this.mDesign.getUnit();
            this.mInterpreter = Cp.getCp().createChildInterpreter();
        }

        public void exportDevice(String devicePath, String filePath) {
            if (this.mDb == null) {
                ALog.logError((String)"No database was specified before calling exportDevice().");
                return;
            }
            if (this.mDesign == null) {
                ALog.logError((String)"There is no Design in the specified database for exportDevice().");
                return;
            }
            DevicePath path = DevicePath.fromString((Db)this.mDb, (String)devicePath);
            if (path == null) {
                ALog.logError((String)"The device path '%s' is invalid.", (Object[])new Object[]{devicePath});
                return;
            }
            try {
                this.mExportFormat = this.getExportFormatOrDefault(devicePath, filePath, path);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            File outputFile = new File(filePath);
            try {
                this.mOut = new PrintWriter(outputFile);
            }
            catch (FileNotFoundException fnfe) {
                ALog.logError((Throwable)fnfe, (String)"Unable to write to output file '%s'.", (Object[])new Object[]{filePath});
                return;
            }
            PinTemplate.Type[] pinTypes = this.getPinTypes(path.getDevice());
            ExportInfo exportInfo = new ExportInfo(path, outputFile, pinTypes, sMatrixRenamePins);
            this.writeFileHeader(exportInfo);
            this.writePinHeaders();
            this.writePins(exportInfo);
            this.writeFileTail(exportInfo);
            ALog.logInfo((String)"Wrote %d pins to file '%s'.", (Object[])new Object[]{this.mLinesPrinted, filePath});
            this.mOut.close();
        }

        private PinTemplate.Type[] getPinTypes(Device device) {
            boolean isDie = device.getTemplate().getType() == DeviceTemplate.Type.DIE;
            boolean isPkg = device.getTemplate().getType() == DeviceTemplate.Type.PACKAGE;
            PinTemplate.Type[] pinTypes = null;
            if (sExportPinTypes != null) {
                pinTypes = sExportPinTypes;
            } else if (isDie) {
                pinTypes = new PinTemplate.Type[]{PinTemplate.Type.BUMPPAD};
            } else if (isPkg) {
                pinTypes = new PinTemplate.Type[]{PinTemplate.Type.BALLPAD};
            }
            return pinTypes;
        }

        private ExportFormat getExportFormatOrDefault(String devicePath, String filePath, DevicePath path) {
            ExportFormat format = null;
            if (sExportFormat != null && sExportFormat.length() > 0 && (format = BgaDieTxtIO.getExportFormat(sExportFormat)) == null) {
                ALog.logWarn((String)"Unable to get BgaDieTxtIO export format '%s'.", (Object[])new Object[]{sExportFormat});
            }
            if (format == null) {
                format = BgaDieTxtIO.getDefaultExportFormat(path.getDeviceTemplate().getType());
            }
            if (format == null) {
                ALog.logError((String)"No default export format could be found for type '%s'. Export aborted.");
                throw new IllegalArgumentException();
            }
            ALog.logInfo((String)"Exporting '%s' to file '%s' using format '%s'.", (Object[])new Object[]{devicePath, filePath, format.getKey()});
            return format;
        }

        protected void header(String name, String data) {
            this.mOut.format("%s: %s", name, data);
            this.mOut.println();
        }

        protected void header(String name, APoint2D pt) {
            String x = this.mUnit == null ? Long.toString(pt.getX()) : "" + this.mUnit.toUser(pt.getX());
            String y = this.mUnit == null ? Long.toString(pt.getY()) : "" + this.mUnit.toUser(pt.getY());
            this.mOut.format("%s: (%s %s)", name, x, y);
            this.mOut.println();
        }

        protected void writeFileHeader(ExportInfo exportData) {
            String script = this.mExportFormat.getFileHeader();
            if (script == null || script.isEmpty()) {
                this.writeDefaultFileHeader(exportData);
            } else {
                try {
                    this.mInterpreter.set("exportInfo", (Object)exportData);
                    Object o = Cp.eval((Interpreter)this.mInterpreter, (String)script, (boolean)true);
                    if (o instanceof String) {
                        this.mOut.println((String)o);
                    } else {
                        ALog.logError((String)"The Header statement of the BgaDieTxtIO.ExportFormat '%s' returned an invalid file header of type %s. No file header is being output.", (Object[])new Object[]{o.getClass().getName()});
                    }
                }
                catch (EvalError e) {
                    ALog.logError((Throwable)e, (String)"The Header statement of the BgaDieTxtIO.ExportFormat '%s' generated an error. No file header is being output.", (Object[])new Object[0]);
                }
            }
        }

        protected void writeFileTail(ExportInfo exportData) {
            this.mOut.println();
            this.mOut.println();
            this.mOut.println("The following section defines padstack information for pins of this symbol.");
            this.mOut.println("Pad layer will be determined at the time of import.");
            this.mOut.println(BgaDieTxtIO.BEGIN_PADSTACKS);
            this.writePadstacks(exportData);
            this.mOut.println(BgaDieTxtIO.END_PADSTACKS);
        }

        protected void writePadstacks(ExportInfo exportData) {
            DevicePath path = exportData.getExportDevicePath();
            HashSet padSet = new HashSet();
            HashSet typeSet = new HashSet();
            AUtil.getIterable((Object[])exportData.getPinTypes()).forEach(type -> typeSet.add(type));
            path.getDeviceTemplate().getPins().forEach(pinT -> {
                PadTemplate padT;
                if (typeSet.contains(pinT.getType()) && !padSet.contains(padT = pinT.getPadTemplate())) {
                    ALog.flogInfo((String)"Write Padstack: %s", (Object[])new Object[]{padT});
                    padT.getLayerShapes(exportData.getPadLayer()).forEach(ls -> this.writeLayerShape(padT.getName(), (LayerShape)ls));
                    padSet.add(padT);
                }
            });
        }

        protected void writeLayerShape(String padstackName, LayerShape ls) {
            AGeom geom = ls.getGeom();
            if (geom instanceof ACircle) {
                this.mOut.println(this.layerShapeFormat(padstackName, "CIRCLE", this.mUnit.toUserStr(((ACircle)geom).getD()), this.mUnit.toUserStr(((ACircle)geom).getD()), null));
            } else if (geom instanceof AOctagon) {
                this.mOut.println(this.layerShapeFormat(padstackName, "OCTAGON", null, null, this.mUnit.toUserStr(((AOctagon)geom).radius() * 2L)));
            } else if (geom instanceof ARect) {
                this.mOut.println(this.layerShapeFormat(padstackName, "RECTANGLE", this.mUnit.toUserStr(((ARect)geom).width()), this.mUnit.toUserStr(((ARect)geom).height()), null));
            } else {
                ALog.flogWarn((String)"Unsupport layer shape: %s in Padstacks: %s", (Object[])new Object[]{ls.toString(), padstackName});
            }
        }

        protected String layerShapeFormat(String padstackName, String shape, String w, String h, String d) {
            StringBuilder ret = new StringBuilder();
            ret.append("PADSTACK: ");
            ret.append(String.format("NAME:%s", padstackName));
            ret.append(String.format("|SHAPE:%s", shape));
            if (w != null) {
                ret.append(String.format("|WIDTH:%s", w));
            }
            if (h != null) {
                ret.append(String.format("|HEIGHT:%s", h));
            }
            if (d != null) {
                ret.append(String.format("|DIAMETER:%s", d));
            }
            return ret.toString();
        }

        protected void writeDefaultFileHeader(ExportInfo exportData) {
            DeviceTemplate template = exportData.getExportDeviceTemplate();
            Device device = exportData.getExportDevice();
            APoint2D dimensions = this.getDimensionWIthShrink(template);
            this.header("File", exportData.getOutputFile().getPath());
            this.header("Date", new Date().toString());
            this.header("Units", "microns, 3 decimal places");
            this.header("Name", template.getName());
            if (device != null) {
                this.header("RefDes", device.getName());
            }
            this.header("Origin", exportData.getExportDevicePath().getOrigin());
            this.header("Rotation", String.format("%2f", Float.valueOf(exportData.getExportDevicePath().getRot())));
            if (exportData.getPadLayerName() != null) {
                this.header("Pad Layer", exportData.getPadLayerName());
            }
            this.header("Dimensions", dimensions);
            if (exportData.isDie() || exportData.isPackageDie()) {
                Layer mountLayer;
                String def = null;
                switch (template.getSourceType()) {
                    case LEFDEF: {
                        def = template.getSourceFile();
                        break;
                    }
                    case DIEBGATXT: {
                        def = template.getStringValue("TxtFile.Hdr.DEF_Design");
                        break;
                    }
                }
                if (def != null) {
                    this.header("DEF Design:", def);
                }
                Layer layer = mountLayer = device == null ? null : device.getMountLayer();
                if (mountLayer != null) {
                    this.header("DieOrient", mountLayer.getOrder() > 0 ? "ChipUp" : "ChipDown");
                    this.header("DieType", "FlipChip");
                } else if (device != null) {
                    this.header("DieOrient", device.getMirror() && device.getFlipped() ? "ChipDown" : "ChipUp");
                    this.header("DieType", "FlipChip");
                }
            }
            this.mOut.println();
        }

        private APoint2D getDimensionWIthShrink(DeviceTemplate template) {
            ARect r = template.getBB();
            double shrinkAmount = template.getShrinkAmount();
            APoint2D dimensions = shrinkAmount == 0.0 ? new APoint2D(r.width(), r.height()) : new APoint2D(Math.round((double)r.width() * (1.0 / (1.0 - shrinkAmount))), Math.round((double)r.height() * (1.0 / (1.0 - shrinkAmount))));
            return dimensions;
        }

        protected void writePinHeaders() {
            String script = this.mExportFormat.getPinHeader();
            try {
                Object o = Cp.eval((Interpreter)this.mInterpreter, (String)script, (boolean)true);
                if (o instanceof String) {
                    this.mOut.println((String)o);
                } else {
                    String msg = String.format("of type %s", o.getClass().getName());
                    ALog.logError((String)"The PinHeader statement of the BgaDieTxtIO.ExportFormat '%s' returned an invalid pin header %s. No pin header is being output.", (Object[])new Object[]{msg});
                }
            }
            catch (EvalError e) {
                ALog.logError((Throwable)e, (String)"The PinHeader statement of the BgaDieTxtIO.ExportFormat '%s' generated an error. No pin header is being output.", (Object[])new Object[0]);
            }
        }

        protected void writePins(ExportInfo exportData) {
            LinkedList<HierPort> hPorts = this.getHPortToExport(exportData);
            HashMap<HierPort, String> diePin2Name = exportData.doMatrixRename() ? this.getMatrixRenameMap(hPorts) : null;
            HashMap<HierPort, HierPort> dieBumpToPkgBall = exportData.isDie() ? this.getBumpToBallMap(hPorts) : null;
            this.mLinesPrinted = 0L;
            MultiHashMap names = new MultiHashMap();
            for (HierPort hp2 : hPorts) {
                names.put((Object)Exporter.determinePinName(hp2.getPin()), (Object)hp2);
                ExportPinData curPinData = new ExportPinData(exportData, hp2, this.mUnit, dieBumpToPkgBall != null ? dieBumpToPkgBall.get(hp2) : null, diePin2Name != null ? diePin2Name.get(hp2) : "");
                this.writePinData(exportData, curPinData);
            }
            if (!exportData.doMatrixRename()) {
                for (Map.Entry entry : names.entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    String pins = ((Collection)entry.getValue()).stream().map(hp -> ((DevicePath)hp.getFirst()).toString()).collect(Collectors.joining(", "));
                    ALog.logWarn((String)"Pin name '%s' is duplicated in these paths: %s", (Object[])new Object[]{entry.getKey(), pins});
                }
            }
        }

        private void writePinData(ExportInfo exportData, ExportPinData curPinData) {
            String script = this.mExportFormat.getPinDetail();
            try {
                this.mInterpreter.set("exportInfo", (Object)exportData);
                this.mInterpreter.set("curPin", (Object)curPinData);
                Object o = Cp.eval((Interpreter)this.mInterpreter, (String)script, (boolean)true);
                if (o instanceof String) {
                    this.mOut.println((String)o);
                    ++this.mLinesPrinted;
                } else {
                    String msg = o == null ? "'null'" : String.format("of type %s", o.getClass().getName());
                    ALog.logError((String)"The PinDetail statement of the BgaDieTxtIO.ExportFormat '%s'  returned invalid pin detail output %s. No pin detail is being output for %s.", (Object[])new Object[]{msg, curPinData.getUserDesc()});
                }
            }
            catch (EvalError e) {
                ALog.logError((Throwable)e, (String)"The PinHeader statement of the BgaDieTxtIO.ExportFormat '%s' generated an error. No pin header is being output.", (Object[])new Object[0]);
            }
        }

        private HashMap<HierPort, HierPort> getBumpToBallMap(LinkedList<HierPort> hPorts) {
            DevicePath testPath;
            DevicePath packagePath;
            HashMap<HierPort, HierPort> dieBumpToPkgBall = new HashMap<HierPort, HierPort>();
            boolean thereIsAPackage = true;
            if (!hPorts.isEmpty() && ((packagePath = (testPath = hPorts.get(0).getPath()).pathToLowestPackage()) == null || packagePath.isEmpty())) {
                thereIsAPackage = false;
            }
            if (thereIsAPackage) {
                this.findConnectedPackageBalls(hPorts, dieBumpToPkgBall);
            }
            return dieBumpToPkgBall;
        }

        private HashMap<HierPort, String> getMatrixRenameMap(LinkedList<HierPort> hPorts) {
            HashMap<HierPort, String> diePin2Name = new HashMap<HierPort, String>();
            HierPort[][] matrix = HierPort.matrixPorts(hPorts, null);
            for (int rowIdx = 0; rowIdx < matrix.length; ++rowIdx) {
                HierPort[] col = matrix[rowIdx];
                for (int colIdx = 0; colIdx < col.length; ++colIdx) {
                    HierPort hp = col[colIdx];
                    if (hp == null) continue;
                    String pinName = JedecAlphabet.getNth((int)rowIdx) + colIdx;
                    diePin2Name.put(hp, pinName);
                }
            }
            return diePin2Name;
        }

        private LinkedList<HierPort> getHPortToExport(ExportInfo exportData) {
            DevicePath startPath = exportData.getExportDevicePath();
            Substrate subst = startPath.getDevice().getSubstrate();
            PinTemplate.Type[] pinTypes = exportData.getPinTypes();
            HashSet<PinTemplate.Type> setPinTypes = pinTypes == null ? null : new HashSet<PinTemplate.Type>(Arrays.asList(pinTypes));
            LinkedList<HierPort> hPorts = new LinkedList<HierPort>();
            for (DevicePath path : startPath.getDescendants(true)) {
                if (path.getDevice().getSubstrate() != subst) continue;
                for (PinTemplate pin : path.getDeviceTemplate().getPins()) {
                    if (setPinTypes != null && !setPinTypes.contains(pin.getType())) continue;
                    for (PortTemplate pt : pin.getPortTemplates()) {
                        hPorts.add(new HierPort(path, pt));
                    }
                }
            }
            Collections.sort(hPorts);
            return hPorts;
        }

        protected void findConnectedPackageBalls(LinkedList<HierPort> hPorts, HashMap<HierPort, HierPort> bumpToBall) {
            HashMap<Net, HierPort> netToBall = new HashMap<Net, HierPort>();
            for (HierPort bump : hPorts) {
                Net packageNet;
                Net n = bump.getTopMostNet();
                if (netToBall.containsKey(n)) {
                    bumpToBall.put(bump, (HierPort)netToBall.get(n));
                    continue;
                }
                HierPort ball = null;
                for (HierPin candidate : NetMap.getConnectedDevicePathPorts((Net)bump.getNet(), (DevicePath)bump.getPath())) {
                    if (candidate.getPinTemplate().getType() != PinTemplate.Type.BALLPAD) continue;
                    ball = new HierPort(candidate.getPath(), candidate.getPinTemplate().getFirstPortTemplate());
                    bumpToBall.put(bump, ball);
                    break;
                }
                if (ball == null && (packageNet = NetMap.getTopmostNet((Net)bump.getNet(), (DevicePath)bump.getPath())).getDeviceTemplate().getType() == DeviceTemplate.Type.PACKAGE) {
                    ball = new HierPort(bump.getPath(), null);
                    bumpToBall.put(bump, ball);
                    netToBall.put(n, ball);
                }
                netToBall.put(n, ball);
            }
        }
    }

    public static class Importer {
        protected Db mDb;
        protected String mImportDeviceTemplateName = null;
        protected String mImportDeviceName = null;
        protected DeviceTemplate.Type mImportDeviceType = null;
        protected PinTemplate.Type mImportPinType = null;
        protected AGeom mImportPadShape = null;
        protected Substrate mSubstrate = null;
        protected boolean mImportCoordAbs = false;
        protected double mScale = 1.0;
        protected boolean mForcedEditPadStack = false;
        protected boolean mInquireConflictDevice = true;
        protected Device mNewParent = null;
        protected boolean mInstantiateAsDevices = false;
        protected HashMap<String, PadTemplate> mCreatedPadTemplates = new HashMap();
        protected File mFile;
        protected LineNumberReader mReader = null;
        protected String mReaderCurrentLineContent = null;
        protected CSVParser mCsvParser = null;
        protected boolean mCommaSep = false;
        protected Unit mFileUnit = null;
        protected Layer mPadLayer = null;
        protected ARect mPinLocBounds = null;
        protected static final String COL_NAME_PIN_NUMBER = "pin number";
        protected static final String COL_NAME_NET_NAME = "net name";
        protected static final String COL_NAME_PADSTACK = "padstack";
        protected static final String COL_NAME_X_COORD = "x coord";
        protected static final String COL_NAME_Y_COORD = "y coord";
        protected static final String COL_NAME_ROTATION = "rotation";
        protected static final String COL_NAME_PINUSE = "pin use";
        protected static final String COL_NAME_PINNAME = "pin name";
        protected static final String DICT_NAME = "NAME";
        protected static final String DICT_SHAPE = "SHAPE";
        protected static final String DICT_WIDTH = "WIDTH";
        protected static final String DICT_HEIGHT = "HEIGHT";
        protected static final String DICT_DIMENSION = "DIMENSION";
        protected static final String DICT_DIAMETER = "DIAMETER";
        protected static final String SHAPE_CIRCLE = "CIRCLE";
        protected static final String SHAPE_OCTAGON = "OCTAGON";
        protected static final String SHAPE_RECTANGLE = "RECTANGLE";
        protected static final String SHAPE_EMPTY = "EMPTY";
        protected static final Map<String, String> mAliasToColName = new HashMap<String, String>();

        public Importer(Db db) {
            this.mDb = db;
        }

        public void setSubstrate(String substrateKeyStr) {
            Substrate s = (Substrate)this.mDb.getByKeyStr(Substrate.class, substrateKeyStr);
            if (s == null) {
                String msg = String.format("The substrate '%s' does not exist, a new substrate will be created for the import.", substrateKeyStr);
                ALog.logError((Throwable)new IllegalArgumentException(msg), (String)msg, (Object[])new Object[0]);
            } else {
                ALog.logInfo((String)"Importing device into substrate '%s'.", (Object[])new Object[]{substrateKeyStr});
                this.mSubstrate = s;
            }
        }

        public void setImportDeviceType(DeviceTemplate.Type type) {
            this.mImportDeviceType = type;
        }

        public void setImportPinType(PinTemplate.Type type) {
            this.mImportPinType = type;
        }

        public void setImportPadShape(AGeom geom) {
            this.mImportPadShape = geom;
        }

        public void setImportCoordAbs(boolean isAbosolute) {
            this.mImportCoordAbs = isAbosolute;
        }

        public void setScale(double factor) {
            if (factor < 0.0) {
                factor = -(1.0 / factor);
            }
            this.mScale = factor;
        }

        public void setForcedEditPadStack(boolean forcedEditPadStack) {
            this.mForcedEditPadStack = forcedEditPadStack;
        }

        public void setInquireConflictDevice(boolean inquireConflictDevice) {
            this.mInquireConflictDevice = inquireConflictDevice;
        }

        public void setNewParent(String keyStr) {
            this.mNewParent = (Device)this.mDb.getByKeyStr(Device.class, keyStr);
        }

        public void setInstAsDevice(boolean instantiateAsDevices) {
            this.mInstantiateAsDevices = instantiateAsDevices;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Device importFile(String parentDevicePath, String filePath) {
            Device newDevice = null;
            try {
                DevicePath dpParent = this.getDPath(parentDevicePath);
                this.getFileAndParsers(filePath);
                HashMap<String, String> headers = this.readHeaders(this.mReader);
                HashMap<String, String> lcHeaders = this.getLowerCaseMap(headers);
                this.getDevTName(lcHeaders);
                this.getDevName(lcHeaders);
                this.createSubstrate(lcHeaders);
                newDevice = this.createDevice(dpParent.getDeviceTemplate(), lcHeaders);
                this.moveToParent(newDevice, dpParent.getDevice());
                this.setHeaderValue(newDevice.getTemplate(), headers);
                this.setDevLoc(newDevice, lcHeaders);
                this.readPins(newDevice, this.readColNames());
                this.setDevBound(newDevice, lcHeaders);
                this.solveNewParent(newDevice, dpParent.getDevice());
            }
            catch (IOException | IllegalArgumentException | InternalError e) {
                ALog.logError((Throwable)e, (String)"%s", (Object[])new Object[]{e.getMessage()});
            }
            finally {
                this.closeReader();
            }
            return newDevice;
        }

        private void moveToParent(Device newDevice, Device parent) {
            Device newParent = this.mNewParent == null ? parent : this.mNewParent;
            newDevice.setParent(newParent, true);
        }

        private void solveNewParent(Device newDevice, Device parent) {
            Device newParent = this.mNewParent == null ? parent : this.mNewParent;
            DeviceConflictHelper ihelper = DeviceConflictHelper.create(newParent, newDevice);
            ihelper.setPreferedTempltName(this.mImportDeviceTemplateName);
            ihelper.setPreferedInstName(this.mImportDeviceName);
            boolean needSolve = ihelper.preSolve();
            if (this.mInquireConflictDevice && needSolve) {
                EventQueue.invokeLater(() -> {
                    ihelper.setMode(DeviceConflictHelper.Mode.INQUIRE);
                    ihelper.solve();
                });
            }
        }

        private DevicePath getDPath(String strPath) {
            DevicePath dpParent = DevicePath.fromString((Db)this.mDb, (String)strPath);
            if (dpParent == null) {
                throw new IllegalArgumentException(String.format("The path '%s' does not exist in the specified database. The file was not read.", strPath));
            }
            return dpParent.isDesign() ? new DevicePath((DeviceTemplate)Design.getDesign((Db)this.mDb)) : dpParent;
        }

        private void getFileAndParsers(String filePath) throws FileNotFoundException {
            this.mFile = new File(filePath);
            if (!this.mFile.canRead()) {
                throw new FileNotFoundException(String.format("Unable to read from specified input file '%s', please check that the file path is correct and the file is readable.", filePath));
            }
            this.mCommaSep = AFile.getExtension((File)this.mFile).equals(BgaDieTxtIO.CSV_FILE_EXT);
            this.mCsvParser = this.mCommaSep ? new CSVParser(',') : new CSVParser('\t');
            this.mReader = new LineNumberReader(new FileReader(filePath));
        }

        private HashMap<String, String> getLowerCaseMap(HashMap<String, String> headers) {
            HashMap<String, String> lcHeaders = new HashMap<String, String>();
            for (Map.Entry<String, String> e : headers.entrySet()) {
                if (e.getKey() == null) continue;
                lcHeaders.put(e.getKey().toLowerCase(), e.getValue());
            }
            return lcHeaders;
        }

        private void getDevTName(HashMap<String, String> lcHeaders) {
            if (this.mImportDeviceTemplateName == null) {
                String devTemplateName = lcHeaders.get("name");
                this.mImportDeviceTemplateName = devTemplateName != null ? devTemplateName : FilenameUtils.getBaseName((String)this.mFile.getName());
            }
        }

        private void getDevName(HashMap<String, String> lcHeaders) {
            if (this.mImportDeviceName == null) {
                String devName = lcHeaders.get("refdes");
                this.mImportDeviceName = devName != null ? devName : this.mImportDeviceTemplateName;
            }
        }

        private void createSubstrate(HashMap<String, String> lcHeaders) {
            String substrateName;
            if (this.mSubstrate != null) {
                return;
            }
            this.mSubstrate = Substrate.create((Db)this.mDb, (String)substrateName, (Substrate.getSubstrate((Db)this.mDb, (String)(substrateName = this.mImportDeviceName + "_Substrate")) != null ? 1 : 0) != 0);
            if (this.mSubstrate == null) {
                throw new InternalError("Unable to create a new Substrate for the import.");
            }
            this.mSubstrate.setSourceType(DeviceTemplate.SourceType.DIEBGATXT);
            DeviceTemplate.Type deviceType = this.mImportDeviceType;
            if (this.mImportDeviceType == null) {
                deviceType = this.deduceDeviceType(lcHeaders);
            }
            DeviceFactory.createDefaultLayers(deviceType.name(), this.mSubstrate.getName(), this.mDb);
        }

        private DeviceTemplate.Type deduceDeviceType(HashMap<String, String> lcHeaders) {
            String dieOrient = lcHeaders.get("dieorient");
            String dieType = lcHeaders.get("dietype");
            return dieType != null || dieOrient != null ? DeviceTemplate.Type.DIE : DeviceTemplate.Type.PACKAGE;
        }

        private void setHeaderValue(DeviceTemplate template, HashMap<String, String> headers) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                String val = e.getValue();
                String key = e.getKey().replace(" ", "_");
                template.setValue("TxtFile.Hdr." + key, (Object)val);
            }
        }

        private void setDevLoc(Device newDevice, HashMap<String, String> lcHeaders) {
            String dieOrient;
            String rotation;
            APoint2D ptOrigin = this.getOrigin(lcHeaders);
            if (ptOrigin != null) {
                newDevice.setLoc(ptOrigin);
            }
            if ((rotation = lcHeaders.get(COL_NAME_ROTATION)) != null) {
                newDevice.setRotate(Float.parseFloat(rotation));
            }
            if ((dieOrient = lcHeaders.get("dieorient")) != null && dieOrient.equalsIgnoreCase("ChipDown")) {
                newDevice.setMirror(true);
                newDevice.setFlipped(true);
            }
        }

        private void setDevBound(Device device, HashMap<String, String> lcHeaders) {
            APoint2D ptDim;
            ARect bound = null;
            String extents = lcHeaders.get("extents");
            String dimensions = lcHeaders.get("dimensions");
            DeviceTemplate template = device.getTemplate();
            if (extents != null) {
                bound = this.getTranformedCoord(this.parseHdrRect(extents), device);
            } else if (dimensions != null && (ptDim = this.parseHdrPoint(dimensions)) != null) {
                bound = new ARect(0L, 0L, ptDim.getX(), ptDim.getY());
                if (this.mImportDeviceType != DeviceTemplate.Type.DIE || this.mPinLocBounds != null && !bound.contains((AGeom)this.mPinLocBounds)) {
                    bound.moveBy(-ptDim.getX() / 2L, -ptDim.getY() / 2L);
                }
            }
            if (bound == null) {
                bound = template.deriveContentBounds(true).orElse(null);
            }
            if (bound != null) {
                template.setBounds((AGeom)this.getScaledCoord(bound, device, this.mScale, false));
            }
        }

        private APoint2D getOrigin(HashMap<String, String> lcHeaders) {
            APoint2D ptOrigin = null;
            String strOrigin = lcHeaders.get("origin");
            if (strOrigin != null) {
                ptOrigin = this.parseHdrPoint(strOrigin);
            }
            return ptOrigin;
        }

        private void closeReader() {
            try {
                this.mReader.close();
                this.mReader = null;
            }
            catch (IOException ioe) {
                ALog.logWarn((Throwable)ioe, (String)"Unable to close file '%s'.", (Object[])new Object[]{this.mFile.getPath()});
            }
        }

        protected HashMap<String, String> readHeaders(LineNumberReader lnr) throws IOException {
            HashMap<String, String> headers = new HashMap<String, String>();
            while (true) {
                String[] vals;
                lnr.mark(4096);
                String line = lnr.readLine();
                if (line == null) {
                    throw new IllegalArgumentException(String.format("Unexpected end of file while reading headers from '%s'.", this.mFile.getPath()));
                }
                if ((line = line.trim()).isEmpty() && headers.isEmpty()) continue;
                if (line.startsWith("#")) {
                    if (!this.mCommaSep || !line.matches("^#((\\w+),)+(\\w+)")) continue;
                    lnr.reset();
                    return headers;
                }
                if (line.length() > 1 && line.startsWith("\"") && line.endsWith("\"") && !line.substring(1, line.length() - 1).contains("\"")) {
                    line = line.substring(1, line.length() - 1);
                }
                if ((vals = line.split(":", 2)).length != 2 && line.matches("^[Uu]nits,.*")) {
                    vals = line.split(",", 2);
                }
                if (vals.length != 2) {
                    lnr.reset();
                    return headers;
                }
                headers.put(vals[0].trim(), vals[1].trim());
            }
        }

        protected LinkedList<String> readColNames() throws IOException {
            String[] vals = this.readCsv();
            LinkedList<String> colNames = new LinkedList<String>();
            if (vals == null) {
                ALog.logError((String)"Unexpected end of file while reading column names from '%s'.", (Object[])new Object[]{this.mFile.getPath()});
                return colNames;
            }
            for (String val : vals) {
                String canonicalName;
                if ((val = val.trim()).startsWith("#")) {
                    val = val.substring(1);
                }
                if ((canonicalName = mAliasToColName.get(val)) != null) {
                    val = canonicalName;
                }
                colNames.add(val);
            }
            return colNames;
        }

        protected void readPins(Device device, LinkedList<String> colNames) throws IOException {
            ReadPinParameter param = new ReadPinParameter(device, colNames);
            boolean seenFirstPin = false;
            String[] vals = this.readCsv();
            while (vals != null) {
                if (vals.length != 0 || seenFirstPin) {
                    if (vals.length < 3) {
                        if (this.getCurLineContent().equals(BgaDieTxtIO.BEGIN_PADSTACKS)) {
                            this.readPadstack();
                        } else {
                            ALog.flogWarn((String)"Ignore Line %d: An unexpected number of values was found in '%s' of '%s'.", (Object[])new Object[]{this.getCurLineNo(), this.getCurLineContent(), this.mFile.getPath()});
                        }
                    } else {
                        seenFirstPin = true;
                        param.setVals(vals);
                        this.instantiate(param);
                    }
                }
                vals = this.readCsv();
            }
            for (PadTemplate pt : this.mCreatedPadTemplates.values()) {
                this.editPadStack(pt, device);
            }
        }

        private void readPadstack() throws IOException {
            String[] vals = this.readCsv();
            while (vals != null) {
                if (this.getCurLineContent().equals(BgaDieTxtIO.END_PADSTACKS)) {
                    return;
                }
                this.setPadstack(vals[vals.length - 1]);
                vals = this.readCsv();
            }
        }

        private void setPadstack(String instr) {
            String[] splitHead = instr.split(" ");
            if (splitHead.length != 2) {
                ALog.flogWarn((String)"Ignore Line %d: An unexpected format was found in '%s' of '%s'.", (Object[])new Object[]{this.getCurLineNo(), this.getCurLineContent(), this.mFile.getPath()});
                return;
            }
            String[] para = splitHead[splitHead.length - 1].split("\\|");
            Map<String, String> dict = this.createDict(para);
            PadTemplate pt = this.mCreatedPadTemplates.get(dict.get(DICT_NAME));
            if (pt == null) {
                return;
            }
            this.dimCreator(dict);
            Cp.exec((String)"_padstack = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(pt)});
            Cp.exec((String)"_layer = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mPadLayer)});
            String shape = dict.get(DICT_SHAPE);
            if (!shape.equals("Empty")) {
                String dim = dict.get(DICT_DIMENSION);
                if (dim == null) {
                    ALog.logWarn((String)("Could not create geometry on on layer " + this.mPadLayer.getName()));
                    return;
                }
                if (!PadStackDlg.GeomNameTranslator.createGeom(shape, dim)) {
                    ALog.logWarn((String)("Could not create geometry on on layer " + this.mPadLayer.getName()));
                    return;
                }
                Cp.exec((String)"_padstack.removeLayerShapes(_layer);", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.acl.db.std.LayerShape.create(curDb(), _layer, _padstack, _geom);", (Object[])new Object[0]);
                this.mCreatedPadTemplates.remove(dict.get(DICT_NAME));
            }
        }

        private Map<String, String> createDict(String[] para) {
            HashMap<String, String> ret = new HashMap<String, String>();
            for (String pair : para) {
                String[] keyValue = pair.split("\\:");
                if (keyValue.length != 2) {
                    ALog.flogWarn((String)"Ignore Line %d: An unexpected format was found in '%s' of '%s'.", (Object[])new Object[]{this.getCurLineNo(), this.getCurLineContent(), this.mFile.getPath()});
                    continue;
                }
                String key = keyValue[0];
                String value = keyValue[1];
                ret.put(key, value);
            }
            return ret;
        }

        private void dimCreator(Map<String, String> dict) {
            String shape = dict.get(DICT_SHAPE);
            if (shape.equalsIgnoreCase(SHAPE_CIRCLE) || shape.equalsIgnoreCase(SHAPE_OCTAGON)) {
                if (dict.get(DICT_DIAMETER) == null) {
                    dict.put(DICT_DIMENSION, dict.get(DICT_WIDTH));
                } else {
                    dict.put(DICT_DIMENSION, dict.get(DICT_DIAMETER));
                }
            } else if (shape.equalsIgnoreCase(SHAPE_RECTANGLE)) {
                dict.put(DICT_DIMENSION, dict.get(DICT_WIDTH) + " " + dict.get(DICT_HEIGHT));
            }
        }

        private void instantiate(ReadPinParameter param) {
            if (this.mInstantiateAsDevices) {
                this.instantiateAsDevice(param);
            } else {
                this.instantiateAsPin(param);
            }
        }

        private void instantiateAsDevice(ReadPinParameter param) {
            Net net = this.createAndMapNet(param.getDevice(), param.getNetName(), param.getPinUse());
            PadTemplate padTemplate = this.getOrCreatePadT(param.getDevice(), param.getPadStackName());
            DeviceTemplate pinDevT = this.getOrCreateDevicePinT(padTemplate, net, param.getPadStackName());
            Device device = this.createDevicePin(param, pinDevT);
            if (!net.isUnused()) {
                this.mapNetUpByName(device, device.getPinByName("pin").getNet(), net.getName());
            }
        }

        private void instantiateAsPin(ReadPinParameter param) {
            Net net = this.createAndMapNet(param.getDevice(), param.getNetName(), param.getPinUse());
            Term term = this.createTerm(net, param.getPinName(), param.getPinUse(), param.getDevice().getTemplate());
            PadTemplate padTemplate = this.getOrCreatePadT(param.getDevice(), param.getPadStackName());
            PinTemplate pinTemplate = this.createPinT(param, net, padTemplate);
            this.setPinLabel(pinTemplate, term);
            this.createPin(param, pinTemplate);
        }

        private void setPinUse(PinTemplate pt, AllegroPinUseMapper.AllegroPinUse use) {
            pt.setUse(AllegroPinUseMapper.getOrbitPinUseBy(use));
            pt.setDirection(AllegroPinUseMapper.getOrbitPinDirBy(use));
        }

        private void setNetUse(Net net, AllegroPinUseMapper.AllegroPinUse use) {
            if (net.isUnused()) {
                return;
            }
            if (net.getName().equalsIgnoreCase(BgaDieTxtIO.PINUSE_NC)) {
                net.setUse(Net.Use.NC);
                return;
            }
            net.setUse(AllegroPinUseMapper.getOrbitNetUseBy(use));
        }

        private void setNetDir(Net net, AllegroPinUseMapper.AllegroPinUse use) {
            if (net.isUnused() || net.isNC()) {
                return;
            }
            net.setDirection(AllegroPinUseMapper.getOrbitNetDirBy(use));
        }

        private void setTermUse(Term term, AllegroPinUseMapper.AllegroPinUse pinUSE) {
            term.setUse(AllegroPinUseMapper.getOrbitTermUseBy(pinUSE));
        }

        private void setTermType(Term term, AllegroPinUseMapper.AllegroPinUse pinUSE) {
            term.setType(AllegroPinUseMapper.getOrbitTermTypeBy(pinUSE));
        }

        private void setPinLabel(PinTemplate pin, Term term) {
            PinLabel pinLabel = PinLabel.get((PinTemplate)pin);
            pinLabel.setTerm(term);
        }

        private Net createAndMapNet(Device device, String netName) {
            Net net = this.createNet(device.getTemplate(), netName);
            this.mapNetUpByName(device, net, net.getName());
            return net;
        }

        private Net createAndMapNet(Device device, String netName, AllegroPinUseMapper.AllegroPinUse use) {
            Net net = this.createAndMapNet(device, netName);
            this.setNetUse(net, use);
            this.setNetDir(net, use);
            return net;
        }

        private Term createTerm(Net net, String termName, AllegroPinUseMapper.AllegroPinUse use, DeviceTemplate devT) {
            if (net.isUnused()) {
                return null;
            }
            if (termName.isBlank() || net.isNC()) {
                return null;
            }
            Term term = devT.getTerm(termName);
            if (term == null) {
                term = Term.create((String)termName, (Net)net);
                this.setTermUse(term, use);
                this.setTermType(term, use);
            }
            return term;
        }

        private Net createNet(DeviceTemplate template, String netName) {
            if (netName.isEmpty()) {
                return template.getNetUnused();
            }
            Net net = template.getNet(netName);
            if (net == null) {
                net = template.createNet(netName);
            }
            return net;
        }

        private void mapNetUpByName(Device device, Net net, String parentNetName) {
            if (net.isUnused() || net.isNC()) {
                return;
            }
            DeviceTemplate parentTemplate = device.getParent();
            Net parentNet = NetMap.getParentNet((Device)device, (Net)net);
            if (parentNet == null && NetMap.isMappable((Net)(parentNet = parentTemplate.getNet(parentNetName)))) {
                NetMap.mapChildNet((Device)device, (Net)net, (Net)parentNet);
            }
        }

        private DeviceTemplate getOrCreateDevicePinT(PadTemplate padT, Net net, String name) {
            DeviceTemplate devT = DeviceTemplate.getDeviceTemplate((Substrate)padT.getSubstrate(), (String)name);
            if (devT == null) {
                devT = this.createDevicePinT(padT, net, name);
            }
            return devT;
        }

        private PadTemplate getOrCreatePadT(Device device, String padStackName) {
            Db db = device.getDb();
            PadTemplate padTemplate = this.mCreatedPadTemplates.get(padStackName);
            if (padTemplate == null) {
                padTemplate = this.getPadT(device, padStackName);
            }
            if (padTemplate == null && this.mImportPadShape != null) {
                padTemplate = PadTemplate.create((Db)db, (Substrate)this.mPadLayer.getSubstrate(), (String)(padStackName.isEmpty() ? "PadTemplate" : padStackName));
                LayerShape.create((Db)db, (Layer)this.mPadLayer, (DbObject)padTemplate, (AGeom)this.mImportPadShape);
                this.mCreatedPadTemplates.put(padStackName, padTemplate);
            }
            if (padTemplate == null) {
                throw new NullPointerException();
            }
            return padTemplate;
        }

        private PadTemplate getPadT(Device device, String padStackName) {
            PadTemplate padTemplate = PadTemplate.get((Db)device.getDb(), (Substrate)device.getSubstrate(), (String)padStackName);
            return padTemplate == null ? null : this.copyPadTIfDifferentSubstrate(padTemplate, device);
        }

        private PadTemplate copyPadTIfDifferentSubstrate(PadTemplate origPadT, Device device) {
            PadTemplate newPadT = origPadT.copyToOtherSubstrate(device.getSubstrate());
            if (newPadT != origPadT) {
                this.mCreatedPadTemplates.put(origPadT.getName(), newPadT);
            }
            return newPadT;
        }

        private DeviceTemplate createDevicePinT(PadTemplate padT, Net net, String name) {
            DeviceTemplate devT = DeviceTemplate.create((Substrate)padT.getSubstrate(), (String)name, (boolean)true);
            Net pinNet = Net.getOrCreate((DeviceTemplate)devT, (String)"pad");
            PinTemplate pinT = PinTemplate.create((Net)pinNet, (String)"pin");
            pinT.setPadTemplate(padT);
            pinT.setType(PinTemplate.Type.BUMPPAD);
            devT.setBounds((AGeom)((LayerShape)padT.getLargestGeom(null).getFirst()).getGeom().getBounds());
            devT.setType(DeviceTemplate.Type.BUMP);
            return devT;
        }

        private PinTemplate createPinT(ReadPinParameter param, Net net, PadTemplate padTemplate) {
            PinTemplate pinTemplate = PinTemplate.create((Net)net, (String)param.getPinNum());
            PortTemplate portTemplate = PortTemplate.create((PinTemplate)pinTemplate);
            portTemplate.setPadTemplate(padTemplate);
            this.setPinType(pinTemplate);
            this.setPinUse(pinTemplate, param.getPinUse());
            this.setPortLoc(portTemplate, this.getTransformedCoord(param.getCoorX(), param.getCoorY(), param.getDevice()));
            this.setPinBound(portTemplate.getLoc());
            this.setPortRot(portTemplate, param.getRotVal());
            return pinTemplate;
        }

        private Device createDevicePin(ReadPinParameter param, DeviceTemplate pinDevT) {
            DeviceTemplate parentDevT = param.getDevice().getTemplate();
            String devicePinName = Device.getUniqueName((DeviceTemplate)parentDevT, (String)param.getPinNum());
            Device devicePin = Device.create((Db)this.mDb, (String)devicePinName, (DeviceTemplate)pinDevT, (DeviceTemplate)parentDevT);
            if (devicePin == null) {
                throw new IllegalArgumentException(String.format("Unable to create Device '%s' with template '%s' as a child of '%s'.", devicePinName, pinDevT, parentDevT.getName()));
            }
            devicePin.setParent(parentDevT);
            devicePin.setIsPlaced(true);
            this.setPinLoc(devicePin, this.getTransformedCoord(param.getCoorX(), param.getCoorY(), param.getDevice()));
            this.setPinRot(devicePin, param.getRotVal());
            return devicePin;
        }

        private List<PinInstance> createPin(ReadPinParameter param, PinTemplate pinTemplate) {
            LinkedList<PinInstance> pins = new LinkedList<PinInstance>();
            for (Device devInst : param.getDevice().getTemplate().getDeviceInstances()) {
                PinInstance pin = PinInstance.create((Db)param.getDevice().getDb(), (String)param.getPinNum(), (Device)devInst, (PinTemplate)pinTemplate);
                pins.add(pin);
            }
            return pins;
        }

        private void setPinType(PinTemplate pinTemplate) {
            PinTemplate.Type pinType = this.mImportPinType == null ? this.derivePinTypeFromDeviceType(this.mImportDeviceType) : this.mImportPinType;
            pinTemplate.setType(pinType);
        }

        private void setPortLoc(PortTemplate portTemplate, APoint2D loc) {
            portTemplate.setLoc(this.getScaledCoord(loc, this.mScale));
        }

        private void setPinLoc(Device device, APoint2D loc) {
            device.setLoc(this.getScaledCoord(loc, this.mScale));
        }

        private void setPinBound(APoint2D loc) {
            if (this.mPinLocBounds == null) {
                this.mPinLocBounds = new ARect(loc, loc);
            } else {
                this.mPinLocBounds.expand(loc);
            }
        }

        private void setPortRot(PortTemplate portTemplate, String rotVal) {
            if (!rotVal.isEmpty()) {
                float rot = Float.parseFloat(rotVal);
                portTemplate.setRotate(rot);
            }
        }

        private void setPinRot(Device device, String rotVal) {
            if (!rotVal.isEmpty()) {
                float rot = Float.parseFloat(rotVal);
                device.setRotate(rot);
            }
        }

        private PinTemplate.Type derivePinTypeFromDeviceType(DeviceTemplate.Type deviceType) {
            PinTemplate.Type pinType;
            switch (deviceType) {
                case DIE: {
                    pinType = PinTemplate.Type.BUMPPAD;
                    break;
                }
                case PACKAGE: 
                case PACKAGEDDIE: {
                    pinType = PinTemplate.Type.BALLPAD;
                    break;
                }
                default: {
                    pinType = PinTemplate.Type.UNKNOWN;
                }
            }
            return pinType;
        }

        private void editPadStack(PadTemplate padT, Device device) {
            ALog.logInfo((String)"New PadStack %s is added.", (Object[])new Object[]{padT.asString()});
            if (this.mForcedEditPadStack) {
                PadStackDlg.createDialog(OrbitIO.getMainWindow(), new DevicePath(device), padT);
                if (this.mScale != 1.0) {
                    AffineTransform scale = AffineTransform.getScaleInstance(this.mScale, this.mScale);
                    padT.getLayerShapes().stream().forEach(ls -> ls.setGeom(ls.getGeom().transform(scale)));
                }
            }
        }

        private APoint2D getTransformedCoord(String strX, String strY, Device device) {
            if (strX.length() == 0) {
                ALog.logWarn((String)"No X Coord specified in line %d, using 0.", (Object[])new Object[]{this.getCurLineNo()});
            }
            if (strY.length() == 0) {
                ALog.logWarn((String)"No Y Coord specified in line %d, using 0.", (Object[])new Object[]{this.getCurLineNo()});
            }
            Long x = this.mFileUnit.fromUserString(strX);
            Long y = this.mFileUnit.fromUserString(strY);
            return this.getTranformedCoord(new APoint2D(x.longValue(), y.longValue()), device);
        }

        private <T> T getTranformedCoord(T obj, Device device) {
            if (this.mImportCoordAbs) {
                APoint2D invTranlation = device.getLoc().multiply(-1.0);
                if (obj instanceof APoint2D) {
                    ((APoint2D)obj).moveBy(invTranlation);
                } else if (obj instanceof ARect) {
                    ((ARect)obj).moveBy(invTranlation);
                } else {
                    throw new IllegalArgumentException(String.format("Type %s is not supported", obj.getClass().getName()));
                }
            }
            return obj;
        }

        private APoint2D getScaledCoord(APoint2D obj, double factor) {
            if (factor == 1.0) {
                return obj;
            }
            return obj.multiply(factor);
        }

        private ARect getScaledCoord(ARect obj, Device device, double factor, boolean isAbsolute) {
            if (factor == 1.0) {
                return obj;
            }
            APoint2D origin = isAbsolute ? device.getLoc() : APoint2D.Zero();
            APoint2D middle = obj.center().add(origin).multiply(0.5);
            obj.scale(factor);
            obj.moveCenterTo(middle);
            return obj;
        }

        protected int getCurLineNo() {
            return this.mReader.getLineNumber();
        }

        protected String getCurLineContent() {
            return this.mReaderCurrentLineContent;
        }

        protected String[] readCsv() throws IOException {
            String line;
            for (line = null; line == null || line.length() == 0; line = line.trim()) {
                this.mReaderCurrentLineContent = this.mReader.readLine();
                line = this.mReaderCurrentLineContent;
                if (line != null) continue;
                return null;
            }
            return this.mCsvParser.parseLine(line);
        }

        private Device createDevice(DeviceTemplate parent, HashMap<String, String> lcHeaders) {
            if (parent == null) {
                throw new IllegalArgumentException("No parent specified to BgaDieTxtIO.createDevice().");
            }
            Db db = parent.getDb();
            Design design = Design.getDesign((Db)db);
            if (design == null) {
                ALog.logWarn((String)"No design found in database, defaults will be used where needed.");
            }
            DeviceTemplate template = this.createDevT();
            Device device = this.createDev(parent, template);
            if (this.mImportDeviceType == null) {
                this.mImportDeviceType = this.deduceDeviceType(lcHeaders);
            }
            template.setType(this.mImportDeviceType);
            this.getUnit(design, lcHeaders);
            this.createLayer(lcHeaders);
            return device;
        }

        private DeviceTemplate createDevT() {
            DeviceTemplate template = DeviceTemplate.create((Substrate)this.mSubstrate, (String)DeviceConflictHelper.getUniqueTempNameForDevT(this.mSubstrate), (boolean)false);
            if (template == null) {
                throw new IllegalArgumentException(String.format("Unable to create DeviceTemplate '%s'.", this.mImportDeviceTemplateName));
            }
            template.setSourceType(DeviceTemplate.SourceType.DIEBGATXT);
            template.setSourceFile(this.mFile.getAbsolutePath());
            template.setSourceFileModifiedTime(new File(this.mFile.getPath()).lastModified());
            template.setValue("BgaDieTxtIO.importTimestamp", (Object)System.currentTimeMillis());
            template.setShrinkAmount(1.0 - this.mScale);
            return template;
        }

        private Device createDev(DeviceTemplate parent, DeviceTemplate template) {
            return Device.create((String)DeviceConflictHelper.getUniqueTempNameForDev(parent), (DeviceTemplate)template, (DeviceTemplate)parent);
        }

        private void getUnit(Design design, HashMap<String, String> lcHeaders) {
            Unit designUnit = design == null ? Design.getDefaultUnitDist() : design.getUnit();
            String units = lcHeaders.get("units");
            if (units == null || units.isEmpty()) {
                this.mFileUnit = designUnit;
                ALog.logWarn((String)"No units specified in input file, defaulting to %s.", (Object[])new Object[]{this.mFileUnit.getUserName()});
            } else {
                String[] sa = units.split(",");
                String fileUnitName = sa[0].toLowerCase();
                if (fileUnitName.startsWith(designUnit.getUserName().toLowerCase())) {
                    this.mFileUnit = designUnit;
                } else if (fileUnitName.equals("millimeters")) {
                    long designDbuPerMicron = design == null ? Design.getDefaultUnitDistDbuPerMicron() : design.getInternalPerMicron();
                    this.mFileUnit = new Unit("millimeters", (double)(designDbuPerMicron * 1000L));
                } else {
                    this.mFileUnit = designUnit;
                    ALog.logWarn((String)"Unknown units '%s' specified in input file, defaulting to design unit %s.", (Object[])new Object[]{sa[0], this.mFileUnit.getUserName()});
                }
            }
        }

        private void createLayer(HashMap<String, String> lcHeaders) {
            String padLayer = lcHeaders.get("pad layer");
            if (padLayer == null) {
                padLayer = this.mImportDeviceType == DeviceTemplate.Type.DIE ? "Bump" : (this.mImportDeviceType == DeviceTemplate.Type.PACKAGE ? "Ball" : "Pad");
            }
            this.mPadLayer = Layer.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)padLayer);
            if (this.mPadLayer == null) {
                ALog.logInfo((String)"Pad layer '%s' not found, it is being created.", (Object[])new Object[]{padLayer});
                this.mPadLayer = Layer.create((Substrate)this.mSubstrate, (String)padLayer);
            }
        }

        protected APoint2D parseHdrPoint(String str) {
            Scanner scanner = new Scanner(str);
            if (scanner.findInLine(BgaDieTxtIO.PATTERN_COORD) == null) {
                ALog.logError((String)"Invalid format at line %d, expected '(x.xx y.yy)', found '%s'.", (Object[])new Object[]{this.getCurLineNo(), str});
                scanner.close();
                return null;
            }
            MatchResult result = scanner.match();
            String strX = result.group(1);
            String strY = result.group(2);
            scanner.close();
            long x = this.mFileUnit.fromUserString(strX);
            long y = this.mFileUnit.fromUserString(strY);
            return new APoint2D(x, y);
        }

        protected ARect parseHdrRect(String str) {
            Scanner scanner = new Scanner(str);
            if (scanner.findInLine(PATTERN_TWO_COORDS) == null) {
                ALog.logError((String)"Invalid format at line %d, expected '(x.xx y.yy) (x.xx y.yy)', found '%s'.", (Object[])new Object[]{this.getCurLineNo(), str});
                scanner.close();
                return null;
            }
            MatchResult result = scanner.match();
            String strX1 = result.group(1);
            String strY1 = result.group(2);
            String strX2 = result.group(3);
            String strY2 = result.group(4);
            scanner.close();
            long x1 = this.mFileUnit.fromUserString(strX1);
            long y1 = this.mFileUnit.fromUserString(strY1);
            long x2 = this.mFileUnit.fromUserString(strX2);
            long y2 = this.mFileUnit.fromUserString(strY2);
            return new ARect(x1, y1, x2, y2);
        }

        protected long userToDb(String u) {
            double d = Double.parseDouble(u);
            return this.mFileUnit.fromUser(d);
        }

        protected String dbToUser(long l) {
            return this.mFileUnit.toUserStr(l);
        }

        static {
            mAliasToColName.put("pinnumber", COL_NAME_NET_NAME);
            mAliasToColName.put("net", COL_NAME_NET_NAME);
            mAliasToColName.put("x", COL_NAME_X_COORD);
        }

        private class ReadPinParameter {
            private Device mDevice;
            private String[] vals = null;
            private int pinNumCol;
            private int pinNameCol;
            private int netNameCol;
            private int padStackCol;
            private int xCoordCol;
            private int yCoordCol;
            private int rotCol;
            private int pinUseCol;

            public ReadPinParameter(Device device, List<String> colNames) {
                this.mDevice = device;
                this.pinNumCol = this.getColName(Importer.COL_NAME_PIN_NUMBER, colNames);
                this.netNameCol = this.getColName(Importer.COL_NAME_NET_NAME, colNames);
                this.padStackCol = this.getColName(Importer.COL_NAME_PADSTACK, colNames);
                this.xCoordCol = this.getColName(Importer.COL_NAME_X_COORD, colNames);
                this.yCoordCol = this.getColName(Importer.COL_NAME_Y_COORD, colNames);
                this.rotCol = this.getColName(Importer.COL_NAME_ROTATION, colNames);
                this.pinUseCol = this.getColName(Importer.COL_NAME_PINUSE, colNames);
                this.pinNameCol = this.getColName(Importer.COL_NAME_PINNAME, colNames);
            }

            public void setVals(String[] vals) {
                this.vals = vals;
            }

            public Device getDevice() {
                return this.mDevice;
            }

            public String getNetName() {
                String netName = this.getColVal(this.vals, this.netNameCol);
                if (netName.isBlank()) {
                    netName = BgaDieTxtIO.PINUSE_NC;
                }
                return netName;
            }

            public String getRotVal() {
                return this.getColVal(this.vals, this.rotCol);
            }

            public String getPinNum() {
                String val = this.getColVal(this.vals, this.pinNumCol);
                if (val.isBlank()) {
                    throw new IllegalArgumentException(String.format("No 'Pin Number' specified in line %d, ignoring.", Importer.this.getCurLineNo()));
                }
                return val;
            }

            public String getPinName() {
                String pinName = this.getColVal(this.vals, this.pinNameCol);
                if (pinName.equals("")) {
                    return this.getNetName();
                }
                return pinName;
            }

            public AllegroPinUseMapper.AllegroPinUse getPinUse() {
                AllegroPinUseMapper.AllegroPinUse val;
                String useString = this.getColVal(this.vals, this.pinUseCol);
                try {
                    val = AllegroPinUseMapper.getAllegroPinUseBy(useString);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Unsupported Pin Use: %s in line %d, ignoring.", useString, Importer.this.getCurLineNo()));
                }
                if (val == null) {
                    return AllegroPinUseMapper.AllegroPinUse.UNSPEC;
                }
                return val;
            }

            public String getPadStackName() {
                return this.getColVal(this.vals, this.padStackCol);
            }

            public String getCoorX() {
                String val = this.getColVal(this.vals, this.xCoordCol);
                if (val.isBlank()) {
                    throw new IllegalArgumentException(String.format("No 'X Coord' specified in line %d, ignoring.", Importer.this.getCurLineNo()));
                }
                return val;
            }

            public String getCoorY() {
                String val = this.getColVal(this.vals, this.yCoordCol);
                if (val.isBlank()) {
                    throw new IllegalArgumentException(String.format("No 'Y Coord' specified in line %d, ignoring.", Importer.this.getCurLineNo()));
                }
                return val;
            }

            private int getColName(String colName, List<String> colNames) {
                for (int i = 0; i < colNames.size(); ++i) {
                    if (!colNames.get(i).equalsIgnoreCase(colName)) continue;
                    return i;
                }
                return -1;
            }

            private String getColVal(String[] vals, int col) {
                return col >= 0 && col <= vals.length - 1 ? vals[col].trim() : "";
            }
        }
    }
}

