/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class BumpLocExport {
    private DevicePath mDevP;
    private String mFilePath;
    private PrintWriter mWriter;
    private HashMap<DeviceTemplate, Boolean> mBumpT2PB;
    private HashMap<PinTemplate, String> mPin2PinLayer;

    public static void export(String filePath, String devP) {
        BumpLocExport bmpExport = new BumpLocExport(devP, filePath);
        bmpExport.export();
    }

    public BumpLocExport(String devP, String filePath) {
        this.mDevP = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devP);
        this.mFilePath = filePath;
    }

    public void export() {
        if (this.mDevP == null) {
            ALog.logError((String)"Invalid device path");
            return;
        }
        File file = new File(this.mFilePath);
        try (PrintWriter writer = new PrintWriter(file);){
            this.mWriter = writer;
            this.mBumpT2PB = new HashMap();
            this.mPin2PinLayer = new HashMap();
            HashSet<DevicePath> addedDevP = new HashSet<DevicePath>();
            for (HierInst hierPin : this.mDevP.getDeviceTemplate().getPinsAndDescendants(true)) {
                if (addedDevP.contains(hierPin.getPath())) continue;
                this.writeBump(hierPin.getPath());
                addedDevP.add(hierPin.getPath());
            }
            ALog.flogInfo((String)"Write bump location file to %s.", (Object[])new Object[]{file});
        }
        catch (FileNotFoundException fnfe) {
            ALog.logError((Throwable)fnfe, (String)"Unable to write to output file '%s'.", (Object[])new Object[]{file});
        }
    }

    private void writeBump(DevicePath p) {
        BumpData bumpD = new BumpData(p);
        if (!bumpD.init()) {
            return;
        }
        this.mWriter.format("%s %s %f %f %s %d", bumpD.getBumpName(), bumpD.getBumpTNane(), bumpD.getX(), bumpD.getY(), bumpD.getPB(), bumpD.getPins().size());
        if (!bumpD.getPins().isEmpty()) {
            this.mWriter.format(" %s", bumpD.getPins().get(0).getDieLevelNet());
        }
        bumpD.getPins().forEach(pinD -> this.mWriter.format(" %s %s %s %s", pinD.getPinLayer(), pinD.getPinText(), pinD.getPinLayer(), pinD.getLEFPIN()));
        this.mWriter.write(" 0 0 R0");
        this.mWriter.println();
    }

    protected class BumpData {
        private final DevicePath mBumpPath;
        private final Unit mUnit;
        private Device mBump;
        private String mBumpName;
        private String mBumpTName;
        private double mX;
        private double mY;
        private boolean mPB;
        private ArrayList<PinData> mPins;

        private BumpData(DevicePath path) {
            this.mBumpPath = path;
            this.mUnit = Design.getUnit((Db)path.getDb());
        }

        public String getBumpName() {
            return this.mBumpName;
        }

        public String getBumpTNane() {
            return this.mBumpTName;
        }

        public double getX() {
            return this.mX;
        }

        public double getY() {
            return this.mY;
        }

        public String getPB() {
            return this.mPB ? "Y" : "N";
        }

        public List<PinData> getPins() {
            return this.mPins;
        }

        private boolean init() {
            if (this.mBumpPath.getDeviceTemplate().getType() != DeviceTemplate.Type.BUMP) {
                return false;
            }
            if (this.mBumpPath.getLast() == null) {
                return false;
            }
            this.mBump = this.mBumpPath.getLast();
            this.initPlaceBlockage();
            this.initPins();
            return this.initBumpName() && this.initBumpTName() && this.initLoc();
        }

        private boolean initBumpName() {
            this.mBumpName = this.mBump.getName();
            return this.mBumpName != null && !this.mBumpName.isBlank();
        }

        private boolean initBumpTName() {
            if (this.mBumpPath.getDeviceTemplate() == null) {
                return false;
            }
            this.mBumpTName = this.mBumpPath.getDeviceTemplate().getName();
            return this.mBumpTName != null && !this.mBumpTName.isBlank();
        }

        private boolean initLoc() {
            if (this.mUnit == null) {
                return false;
            }
            this.mX = this.mUnit.toUser(this.mBump.getLocX());
            this.mY = this.mUnit.toUser(this.mBump.getLocY());
            return true;
        }

        private void initPlaceBlockage() {
            if (BumpLocExport.this.mBumpT2PB.get(this.mBump.getTemplate()) != null) {
                this.mPB = BumpLocExport.this.mBumpT2PB.get(this.mBump.getTemplate());
            }
            for (PinTemplate pin : this.mBump.getTemplate().getPins()) {
                for (PortTemplate port : pin.getPortTemplates()) {
                    for (LayerShape ls : port.getPadTemplate().getLayerShapes()) {
                        Layer l = ls.getLayer();
                        if (l.getType() != Layer.LayerType.Cut) continue;
                        BumpLocExport.this.mBumpT2PB.put(this.mBump.getTemplate(), Boolean.TRUE);
                        this.mPB = true;
                        return;
                    }
                }
            }
            BumpLocExport.this.mBumpT2PB.put(this.mBump.getTemplate(), Boolean.FALSE);
            this.mPB = false;
        }

        private boolean initPins() {
            this.mPins = new ArrayList();
            for (PinTemplate pin : this.mBump.getTemplate().getPins()) {
                PinData pinD = new PinData(pin);
                if (!pinD.init()) continue;
                this.mPins.add(pinD);
            }
            this.mPins.sort((p0, p1) -> p1.getLayerOrder() - p0.getLayerOrder());
            return true;
        }

        protected class PinData {
            private static final String PIN_LAYER_FIELD = "Pin.Layer";
            private PinTemplate mPinT;
            private String mDieLevelNet;
            private String mPinLayer;
            private String mPinText;
            private String mLEFpin;

            public PinData(PinTemplate pinT) {
                this.mPinT = pinT;
            }

            public boolean init() {
                if (!this.initDieLevelNet()) {
                    return false;
                }
                this.initPinLayer();
                this.initLEFpin();
                return true;
            }

            public String getDieLevelNet() {
                return this.mDieLevelNet;
            }

            public String getPinLayer() {
                return this.mPinLayer;
            }

            public String getPinText() {
                return this.mPinText;
            }

            public String getLEFPIN() {
                return this.mLEFpin;
            }

            private int getLayerOrder() {
                Layer l = this.mPinT.getSubstrate().getLayer(this.mPinLayer);
                return l == null ? -1 : l.getOrder();
            }

            private boolean initDieLevelNet() {
                Net net = NetMap.getParentNet((Device)BumpData.this.mBumpPath.getLast(), (Net)this.mPinT.getNet());
                if (net == null) {
                    return false;
                }
                this.mDieLevelNet = net.getName();
                this.initPinText(net);
                return true;
            }

            private void initPinText(Net net) {
                DevicePath pinPath = BumpLocExport.this.mDevP.getRelativePath(BumpData.this.mBumpPath);
                Term term = PinLabel.get((DevicePath)pinPath, (PinTemplate)this.mPinT).getTerm();
                this.mPinText = term != null ? term.getName() : (net.getTermsCount() == 1 ? ((Term)net.getTerms().next()).getName() : "-");
            }

            private void initPinLayer() {
                if (BumpLocExport.this.mPin2PinLayer.get(this.mPinT) != null) {
                    this.mPinLayer = BumpLocExport.this.mPin2PinLayer.get(this.mPinT);
                    return;
                }
                String pinLabelLayer = PinLabel.get((PinTemplate)this.mPinT).getStringValue(PIN_LAYER_FIELD);
                Layer userPinLayer = Layer.get((Db)BumpData.this.mBumpPath.getDb(), (Substrate)this.mPinT.getSubstrate(), (String)pinLabelLayer);
                this.findPinLayer(userPinLayer);
                if (this.mPinLayer == null) {
                    this.findPinLayer(null);
                }
                if (this.mPinLayer == null) {
                    this.mPinLayer = "-";
                    BumpLocExport.this.mPin2PinLayer.put(this.mPinT, this.mPinLayer);
                }
            }

            private boolean findPinLayer(Layer userPinLayer) {
                for (PortTemplate port : this.mPinT.getPortTemplates()) {
                    IterableIterator lss;
                    IterableIterator pms = PinMap.get((DevicePath)BumpData.this.mBumpPath, (PinTemplate)this.mPinT);
                    if (userPinLayer != null) {
                        lss = port.getPadTemplate().getLayerShapes(userPinLayer);
                    } else {
                        if (pms.hasNext()) {
                            Layer l = ((PinMap)pms.next()).getPinA() == this.mPinT ? ((PinMap)PinMap.get((DevicePath)BumpData.this.mBumpPath, (PinTemplate)this.mPinT).next()).getContactLayerA() : ((PinMap)PinMap.get((DevicePath)BumpData.this.mBumpPath, (PinTemplate)this.mPinT).next()).getContactLayerB();
                            this.mPinLayer = l.getName();
                            PinLabel.get((PinTemplate)this.mPinT).setValue(PIN_LAYER_FIELD, (Object)this.mPinLayer);
                            BumpLocExport.this.mPin2PinLayer.put(this.mPinT, this.mPinLayer);
                            return true;
                        }
                        lss = port.getPadTemplate().getLayerShapes();
                    }
                    lss = lss.sorted((ls1, ls2) -> ls2.getLayer().getOrder() - ls1.getLayer().getOrder());
                    for (LayerShape ls : lss) {
                        if (ls.getGeom() == null || ls.getLayer().getType() == Layer.LayerType.Cut) continue;
                        this.mPinLayer = ls.getLayer().getName();
                        PinLabel.get((PinTemplate)this.mPinT).setValue(PIN_LAYER_FIELD, (Object)this.mPinLayer);
                        BumpLocExport.this.mPin2PinLayer.put(this.mPinT, this.mPinLayer);
                        return true;
                    }
                }
                return false;
            }

            private void initLEFpin() {
                Term term = PinLabel.get((PinTemplate)this.mPinT).getTerm();
                if (term != null) {
                    this.mLEFpin = term.getName();
                    return;
                }
                if (this.mPinT.getNet().getTermsCount() != 1) {
                    this.mLEFpin = "-";
                    return;
                }
                this.mLEFpin = ((Term)this.mPinT.getNet().getTerms().next()).getName();
            }
        }
    }
}

