/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;

public class BumpLocUI {
    public static final String EXPORT_BUMP_TITLE = "Export Bump location...";

    public static Action getAction(final DevicePath path) {
        return new AbstractAction(EXPORT_BUMP_TITLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                BumpLocUI.showBumpLocOutDlg(path);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitApp.getCurDb() != null;
            }
        };
    }

    public static void showBumpLocOutDlg(DevicePath path) {
        DbDialog dlg = new DbDialog(path.getDb(), (Component)OrbitIO.getMainWindow(), EXPORT_BUMP_TITLE);
        GridBagManager l = GridBagManager.layout((Container)dlg.getContentPane());
        l.pushFillX("Source");
        l.add("File:");
        AFileChooserControl fc = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX);
        fc.setUseSaveChooser(true);
        fc.addChoosableFileFilter(AFileFilter.TXT);
        l.popNl();
        l.pushFillX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(e -> {
            try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)EXPORT_BUMP_TITLE);){
                Cp.exec((String)"com.sigrity.orbit.export.BumpLocExport.export(%s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)fc.getPath()), path.escapedString()});
            }
            UIUtil.closeWindow((Window)dlg);
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.popNl();
        l.pushFillY();
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
    }
}

