/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.PowerConfigExport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class BumpMappingExport {
    private final Db mDb;
    private final Set<PinMap> mSignalBumps = new HashSet<PinMap>();
    private final Set<PinMap> mPowerBumps = new HashSet<PinMap>();
    private final Set<PinMap> mGroundBumps = new HashSet<PinMap>();

    public BumpMappingExport(Db db) {
        this.mDb = db;
    }

    public void export(String filePath) {
        if (this.mDb == null || this.mDb.closed()) {
            ALog.flogError((String)"Device path is null.", (Object[])new Object[0]);
            return;
        }
        File file = new File(filePath);
        try (PrintWriter writer = new PrintWriter(file);){
            this.writeFileHeader(writer);
            this.writeBumpMappings(writer);
            ALog.flogInfo((String)"Write bump mapping to %s.", (Object[])new Object[]{file});
        }
        catch (FileNotFoundException fnfe) {
            ALog.logError((Throwable)fnfe, (String)"Unable to write to output file '%s'.", (Object[])new Object[]{file});
        }
    }

    private void writeFileHeader(PrintWriter writer) {
        writer.format("# OrbitIO System Planner version %s", OrbitIO.getApp().getVersion());
        writer.println();
        writer.format("# Build: %s (%s)", OrbitIO.getApp().getBuildVersion(), OrbitIO.getApp().getBuildTimestamp());
        writer.println();
        writer.format("# User: %s", System.getProperty("user.name"));
        writer.println();
        writer.format("# Time: %s", new Date());
        writer.println();
        writer.format("# Source design: %s", this.mDb.getFile());
        writer.println();
        writer.println();
    }

    private void writeBumpMappings(PrintWriter writer) {
        ContactLayer.getValid((Db)this.mDb).forEach(cl -> PinMap.get((ContactLayer)cl).forEach(pm -> this.typeClassification((PinMap)pm)));
        this.writeToFile(writer);
    }

    private void typeClassification(PinMap pm) {
        Net.Use useB;
        HierInst a = pm.getHierNetA();
        HierInst b = pm.getHierNetB();
        Net.Use useA = NetMap.getTopmostNet((Net)((Net)a.getDbObject()), (DevicePath)a.getPath()).getUse();
        if (useA != (useB = NetMap.getTopmostNet((Net)((Net)b.getDbObject()), (DevicePath)b.getPath()).getUse())) {
            ALog.logWarn((String)"Contact bump: %s with Use: %s is different from term %s with Use: %s", (Object[])new Object[]{a.getPath(), useA, b.getPath(), useB});
            return;
        }
        if (useA == null) {
            this.mSignalBumps.add(pm);
            return;
        }
        switch (useA) {
            case SIGNAL: {
                this.mSignalBumps.add(pm);
                break;
            }
            case POWER: {
                this.mPowerBumps.add(pm);
                break;
            }
            case GROUND: {
                this.mGroundBumps.add(pm);
                break;
            }
        }
    }

    private void writeToFile(PrintWriter writer) {
        this.writeByUse(writer, Net.Use.SIGNAL, this.mSignalBumps);
        this.writeByUse(writer, Net.Use.POWER, this.mPowerBumps);
        this.writeByUse(writer, Net.Use.GROUND, this.mGroundBumps);
    }

    private void writeByUse(PrintWriter writer, Net.Use use, Set<PinMap> pms) {
        if (use != Net.Use.SIGNAL && use != Net.Use.POWER && use != Net.Use.GROUND) {
            return;
        }
        writer.format("%s {", use.name());
        writer.println();
        pms.forEach(pm -> {
            PinTemplate pinA = pm.getPinA();
            PinTemplate pinB = pm.getPinB();
            DevicePath pathA = pm.getPinAPath();
            DevicePath pathB = pm.getPinBPath();
            boolean a_isPin = pathA.getLast().isPin();
            boolean b_isPin = pathB.getLast().isPin();
            String pinNameA = a_isPin ? pathA.getLast().getName() : pinA.getName();
            String pinNameB = b_isPin ? pathB.getLast().getName() : pinB.getName();
            HierInst<Net> netA = PowerConfigExport.getParentHierNetOnSubstrateInst((HierInst<Net>)pm.getHierNetA());
            HierInst<Net> netB = PowerConfigExport.getParentHierNetOnSubstrateInst((HierInst<Net>)pm.getHierNetB());
            if (netA != null && netB != null) {
                Term termB;
                DevicePath pinPathA = netA.getPath().getRelativePath(pathA);
                DevicePath pinPathB = netB.getPath().getRelativePath(pathB);
                Term termA = PinLabel.get((DevicePath)pinPathA, (PinTemplate)pm.getPinA()).getTerm();
                if (termA == null) {
                    if (((Net)netA.getDbObject()).getTerms().count() == 1L) {
                        termA = (Term)((Net)netA.getDbObject()).getTerms().next();
                    } else {
                        ALog.logWarn((String)"Cannot determine term for pin:%s on %s.", (Object[])new Object[]{pinA.getName(), pathA});
                    }
                }
                if ((termB = PinLabel.get((DevicePath)pinPathB, (PinTemplate)pm.getPinB()).getTerm()) == null) {
                    if (((Net)netB.getDbObject()).getTerms().count() == 1L) {
                        termB = (Term)((Net)netB.getDbObject()).getTerms().next();
                    } else {
                        ALog.logWarn((String)"Cannot determine term for pin:%s on %s.", (Object[])new Object[]{pinB.getName(), pathB});
                    }
                }
                this.writeBumpMapping(writer, netA.getPath(), termA, pinNameA, netB.getPath(), termB, pinNameB);
            }
        });
        writer.println('}');
    }

    private void writeBumpMapping(PrintWriter writer, DevicePath pathA, Term termA, String pinA, DevicePath pathB, Term termB, String pinB) {
        writer.format("%s(%s) %s %s %s(%s) %s %s", pathA.getLast().getName(), pathA.getDeviceTemplate().getName(), termA.getName(), pinA, pathB.getLast().getName(), pathB.getDeviceTemplate().getName(), termB.getName(), pinB);
        writer.println();
    }
}

