/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.BidiLinkHashMap;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.parsers.RecDecParser;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.CCTFile.CCTFileDBProcessor;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class CCTFileIn
extends RecDecParser {
    public static final boolean APR_TRACK_ROUTED_PINS = false;
    protected Db mDb = null;
    protected Design mDesign = null;
    protected CCTFileDBProcessor.CCTFileUnit mUnit = null;
    protected double mUnits = Design.micronToInternal(null, (double)1.0);
    protected DevicePath mDevicePath = null;
    protected AffineTransform mTransform = null;
    protected Device mDevice = null;
    protected Substrate mSubstrate = null;
    protected boolean mParseState = true;
    protected long mWireCount = 0L;
    protected boolean mQuotedTokens = false;
    protected BiMap<String, Net> mNetMap = HashBiMap.create();
    protected Map<String, HierInst<PinTemplate>> mHPinMap = new HashMap<String, HierInst<PinTemplate>>();
    protected BidiLinkHashMap<String, Layer> mLayerMap = new BidiLinkHashMap();
    protected HashMap<APair<String, String>, LinkedList<String>> mSPinPairs = new HashMap();
    protected HashMap<String, ArrayList<String>> mNetPinMap = new HashMap();
    protected ArrayList<Device> mDies = new ArrayList();
    protected ArrayList<PadDef> padDefs = new ArrayList();
    protected ArrayList<Net> mAddedNets = new ArrayList();
    protected String mLayerName;
    protected APath mPath;
    protected long mPathWidth;
    protected HashMap<APoint2D, LinkedList<Wire>> mWires = new HashMap();
    HashSet<String> mRoutedPins = new HashSet();
    protected Map<Net, List<Wire>> mNetWires = new HashMap<Net, List<Wire>>();

    public CCTFileIn() {
        this.mDb = OrbitIO.getCurDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mPoundKeyBeginningOnly = true;
    }

    public boolean read(File file, DevicePath devicePath, CCTFile.FileType type, CCTFile cctFile) {
        if (file == null) {
            return false;
        }
        if (!AFile.isFileReadable((File)file)) {
            ALog.logWarn((String)"Cannot read file %s.", (Object[])new Object[]{file});
            return false;
        }
        String fileName = file.getName();
        this.mDevicePath = devicePath;
        this.mTransform = this.mDevicePath.getInverseTransform();
        this.mDevice = this.mDevicePath.getLast();
        this.mDb = this.mDevice.getDb();
        ALog.logInfo((String)"Beginning to import '%s'.", (Object[])new Object[]{fileName});
        this.setFile(file);
        if (!this.setInFile(fileName)) {
            ALog.logError((String)"Cannot open file '%s'.", (Object[])new Object[]{fileName});
            return false;
        }
        if (file.length() == 0L) {
            ALog.logWarn((String)"%s is empty.", (Object[])new Object[]{file});
        }
        long fileSizeBefore = file.length();
        this.mSubstrate = this.mDevice.getSubstrate();
        this.mNetMap = cctFile.getNetMap();
        this.mHPinMap = cctFile.getHPinMap();
        this.mLayerMap = cctFile.getLayerMap();
        this.mSPinPairs = cctFile.getSelectedPinPairs();
        this.mNetPinMap = cctFile.getNetPinMap();
        this.parse();
        ALog.logInfo((String)"%d wires created from route file.", (Object[])new Object[]{this.mWireCount});
        long fileSizeAfter = file.length();
        if (fileSizeBefore != fileSizeAfter) {
            ALog.logError((Throwable)new IllegalStateException("File is changed"), (String)"Problems in %s", (Object[])new Object[]{file});
            return false;
        }
        if (this.mParseState) {
            ALog.logInfo((String)"Done importing '%s'.", (Object[])new Object[]{fileName});
        } else {
            ALog.logError((String)"Failed to import '%s'.", (Object[])new Object[]{fileName});
        }
        OrbitIO.getApp().refreshCurrentView(true);
        this.closeFile();
        return true;
    }

    protected void parse() {
        String foundString;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("routes")) {
                this.parseRoutes();
            }
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseRoutes() {
        String foundString;
        while ((foundString = this.getAKey()) != null & this.mParseState) {
            if (foundString.equalsIgnoreCase("resolution")) {
                this.parseResolution();
            } else if (foundString.equalsIgnoreCase("parser")) {
                this.parseParser();
            } else if (foundString.equalsIgnoreCase("structure_out")) {
                this.parseStructureOut();
            } else if (foundString.equalsIgnoreCase("library_out")) {
                this.parseLibraryOut();
            } else if (foundString.equalsIgnoreCase("network_out")) {
                this.parseNetworkOut();
            }
            this.mParseState = this.isAKey(')');
        }
    }

    private void parseResolution() {
        String unitName = this.getAString();
        String internalResolution = this.getAString();
        this.mUnits = Double.parseDouble(internalResolution);
    }

    protected void parseParser() {
        String foundString;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("space_in_quoted_tokens")) {
                String string = this.getAString();
            } else if (foundString.equalsIgnoreCase("string_quote")) {
                this.mQuoteChar = this.getAString().charAt(0);
                this.mQuotedTokens = true;
            }
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseStructureOut() {
        String foundString;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("layer")) {
                String layerName = this.getAString();
                Layer l = (Layer)this.mLayerMap.get((Object)layerName);
                if (l == null) {
                    ALog.logError((String)"Layer '%s' does not exist in %s.", (Object[])new Object[]{layerName, this.mDevicePath.toString()});
                    this.mParseState = false;
                    continue;
                }
                this.parseLayer(l);
            } else if (foundString.equalsIgnoreCase("rule")) {
                this.parseConstraint((DbObject)this.mDevice.getTemplate());
            }
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseLayer(Layer l) {
        String foundString;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("type")) {
                String string = this.getAString();
            } else if (foundString.equalsIgnoreCase("rule")) {
                this.parseConstraint((DbObject)this.mDevice.getTemplate());
            }
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseConstraint(DbObject o) {
        String foundString;
        boolean foundWidth = false;
        long width = 0L;
        long clear = 0L;
        if (o instanceof DeviceTemplate) {
            DeviceTemplate t = (DeviceTemplate)o;
            width = CCTFile.getWidthRule(t);
            clear = CCTFile.getClearanceRule(t);
        }
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("width")) {
                long w = (long)this.forcePopDouble();
                if (w != width) {
                    // empty if block
                }
                foundWidth = true;
            } else if (foundString.equalsIgnoreCase("clear")) {
                long clr = (long)this.forcePopDouble();
                if (clr != clear) {
                    // empty if block
                }
                if (!foundWidth) {
                    this.parseClearance();
                }
            } else if (foundString.equalsIgnoreCase("neck_down_width")) {
                long l = (long)this.forcePopDouble();
            }
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseClearance() {
        String foundString = this.getAKey();
        if (foundString == null) {
            String sameNet = this.getAString();
            while ((foundString = this.getAKey()) != null && this.mParseState) {
                if (foundString.equalsIgnoreCase("type")) {
                    String string = this.getAString();
                }
                this.mParseState = this.isAKey(')');
            }
        } else if (foundString.equalsIgnoreCase("type")) {
            String clearType = this.getAString();
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseLibraryOut() {
        String foundString;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("padstack")) {
                String padName = this.getAString();
                this.parsePadstack(padName);
            }
            this.mParseState = this.isAKey(')');
        }
    }

    private void parsePadstack(String padName) {
        String foundString;
        PadTemplate pad = PadTemplate.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)padName);
        boolean create = false;
        if (pad == null) {
            pad = PadTemplate.create((Db)this.mDb, (Substrate)this.mSubstrate, (String)padName);
            create = true;
        }
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("shape")) {
                this.parseShape(pad, create);
            }
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseShape(PadTemplate pad, boolean create) {
        String foundString = this.getAKey();
        if (foundString != null && this.mParseState) {
            ACircle geom = null;
            if (foundString.equalsIgnoreCase("circle")) {
                geom = this.parseCircle();
                this.mParseState = this.isAKey(')');
            } else if (foundString.equalsIgnoreCase("path")) {
                geom = this.parsePath();
            } else if (foundString.equalsIgnoreCase("poly") || foundString.equalsIgnoreCase("polygon")) {
                geom = this.parsePolygon();
            }
            if (geom != null && create) {
                Layer l = this.mSubstrate.getLayer(this.mLayerName);
                if (l == null) {
                    ALog.logWarn((String)"Invalid layer id '%s'. Near line %d", (Object[])new Object[]{this.mLayerName, this.mCurLine});
                    return;
                }
                LayerShape.create((Layer)l, (DbObject)pad, (AGeom)geom);
            }
        }
    }

    private ACircle parseCircle() {
        this.mLayerName = this.getAString();
        long diameter = (long)this.forcePopDouble();
        APoint2D point = this.equalsAPoint();
        return new ACircle(point, diameter >> 1);
    }

    private APath parsePath() {
        APoint2D point;
        this.mLayerName = this.getAString();
        this.mPathWidth = (long)this.forcePopDouble();
        this.mPath = new APath(this.toDbUnits(this.mPathWidth));
        while ((point = this.equalsAPoint()) != null) {
            APoint2D pt = new APoint2D(this.toDbUnits(point.getX()), this.toDbUnits(point.getY()));
            this.mPath.addPoint(pt.transform(this.mTransform));
        }
        return this.mPath;
    }

    private APolygon parsePolygon() {
        APoint2D point;
        this.mLayerName = this.getAString();
        this.forcePopDouble();
        APolygon poly = new APolygon();
        while ((point = this.equalsAPoint()) != null) {
            APoint2D pt = new APoint2D(this.toDbUnits(point.getX()), this.toDbUnits(point.getY()));
            poly.addPoint(pt.transform(this.mTransform));
        }
        return poly;
    }

    protected void parseNetworkOut() {
        String foundString;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("net")) {
                String netName = this.getAString();
                Net n = (Net)this.mNetMap.get((Object)netName);
                this.parseNet(n);
                if (n == null) {
                    ALog.logWarn((String)"Net '%s' does not exist in %s", (Object[])new Object[]{netName, this.mDevicePath.toString()});
                }
            }
            if (!this.mParseState) continue;
            this.mParseState = this.isAKey(')');
        }
    }

    protected void parseNet(Net net) {
        String foundString;
        ArrayList<Wire> wires = new ArrayList<Wire>();
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("wire")) {
                Wire w = this.parseWire(net);
                wires.add(w);
            } else if (foundString.equalsIgnoreCase("via")) {
                this.parseVia(net);
            }
            this.mParseState = this.isAKey(')');
        }
        Wire prevWire = null;
        for (Wire w : wires) {
            this.connectWires(prevWire, w);
            prevWire = w;
            if (w.getTouchPortA() == null) {
                ALog.logWarn((String)"Problem with getTouchPortA on net: %s", (Object[])new Object[]{net.getName()});
            }
            if (w.getTouchPortB() != null) continue;
            ALog.logWarn((String)"Problem with getTouchPortB on net: %s", (Object[])new Object[]{net.getName()});
        }
        this.mNetWires.put(net, wires);
        this.mWires.clear();
    }

    protected Wire parseWire(Net net) {
        String foundString;
        Wire w = null;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (foundString.equalsIgnoreCase("path")) {
                this.parsePath();
                Layer l = (Layer)this.mLayerMap.get((Object)this.mLayerName);
                if (l != null) {
                    if (this.mPath != null) {
                        w = Wire.create((Net)net, (Layer)l, (APath)this.mPath);
                        ++this.mWireCount;
                        continue;
                    }
                    ALog.logWarn((String)"Net '%s' has a problem with shape on layer '%s'", (Object[])new Object[]{net.getName(), l.getName()});
                    this.mParseState = false;
                    continue;
                }
                ALog.logWarn((String)"Layer '%s' does not exist in %s", (Object[])new Object[]{this.mLayerName, this.mDevicePath.toString()});
                this.mParseState = false;
                continue;
            }
            if (foundString.equalsIgnoreCase("net")) {
                String netName = this.getAString();
                this.mParseState = this.isAKey(')');
                continue;
            }
            if (!foundString.equalsIgnoreCase("connect")) continue;
            this.parseConnect(w);
            this.mParseState = this.isAKey(')');
        }
        return w;
    }

    protected void connectWires(Wire prevWire, Wire wire) {
        PinTemplate pinT;
        if (prevWire == null || wire == null) {
            return;
        }
        APoint2D p1 = prevWire.getPath().getFirstPoint();
        APoint2D p2 = prevWire.getPath().getLastPoint();
        APoint2D p3 = wire.getPath().getFirstPoint();
        APoint2D p4 = wire.getPath().getLastPoint();
        APoint2D connect = null;
        if (AUtil.equals((Object)p1, (Object)p3)) {
            connect = p1;
        } else if (AUtil.equals((Object)p1, (Object)p4)) {
            connect = p1;
        } else if (AUtil.equals((Object)p2, (Object)p3)) {
            connect = p2;
        } else if (AUtil.equals((Object)p2, (Object)p4)) {
            connect = p2;
        }
        if (connect == null) {
            return;
        }
        HierInst connectPortA = null;
        HierInst connectPortB = null;
        if (prevWire.getPinA() != null && ((PinTemplate)prevWire.getPinA().second).getWorldLoc((DevicePath)prevWire.getPinA().first).equals((Object)connect)) {
            connectPortA = prevWire.getPinA();
        } else if (prevWire.getPinB() != null && ((PinTemplate)prevWire.getPinB().second).getWorldLoc((DevicePath)prevWire.getPinB().first).equals((Object)connect)) {
            connectPortA = prevWire.getPinB();
        }
        if (wire.getPinA() != null && ((PinTemplate)wire.getPinA().second).getWorldLoc((DevicePath)wire.getPinA().first).equals((Object)connect)) {
            connectPortB = wire.getPinA();
        } else if (wire.getPinB() != null && ((PinTemplate)wire.getPinB().second).getWorldLoc((DevicePath)wire.getPinB().first).equals((Object)connect)) {
            connectPortB = wire.getPinB();
        }
        if (connectPortA != null && connectPortB != null) {
            return;
        }
        if (connectPortA == null && connectPortB == null) {
            PinTemplate we = PinTemplate.create((Net)wire.getNet(), (String)"we");
            PortTemplate portT = PortTemplate.create((PinTemplate)we);
            PadTemplate padT = PadTemplate.create((Db)this.mDb, (Substrate)wire.getSubstrate(), (String)("we" + wire.getWidth() / Design.getInternalPerMicron((Db)this.mDb)));
            LayerShape.create((Db)this.mDb, (Layer)wire.getLayer(), (DbObject)padT, (AGeom)new ACircle(new APoint2D(), wire.getWidth() / 2L));
            we.setType(PinTemplate.Type.WIREEND);
            portT.setPadTemplate(padT);
            portT.setLoc(connect.transform(this.mTransform));
            pinT = we;
        } else {
            pinT = connectPortA != null ? (PinTemplate)connectPortA.second : (PinTemplate)connectPortB.second;
        }
        if (connectPortA == null) {
            if (prevWire.getPinA() == null) {
                prevWire.setPinA(StoredPath.get((DeviceTemplate)pinT.getDeviceTemplate()), pinT);
            } else if (prevWire.getPinB() == null) {
                prevWire.setPinB(StoredPath.get((DeviceTemplate)pinT.getDeviceTemplate()), pinT);
            }
        }
        if (connectPortB == null) {
            if (wire.getPinA() == null) {
                wire.setPinA(StoredPath.get((DeviceTemplate)pinT.getDeviceTemplate()), pinT);
            } else if (wire.getPinB() == null) {
                wire.setPinB(StoredPath.get((DeviceTemplate)pinT.getDeviceTemplate()), pinT);
            }
        }
    }

    protected void parseConnect(Wire wire) {
        String foundString;
        boolean hasSavedForVia = false;
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            if (!foundString.equalsIgnoreCase("terminal")) continue;
            String type = this.getAString();
            if (type.equals("pin")) {
                String pinKey = this.getAString();
                HierInst<PinTemplate> hP = this.mHPinMap.get(pinKey);
                if (hP == null) {
                    ALog.logError((String)"Problem with pin key mapping: %s.", (Object[])new Object[]{hP});
                    continue;
                }
                this.mRoutedPins.add(pinKey);
                PinTemplate pinT = (PinTemplate)hP.getSecond();
                if (wire.getDeviceTemplate() != pinT.getDeviceTemplate()) {
                    PinTemplate we = PinTemplate.create((Net)wire.getNet(), (String)"we");
                    PortTemplate portT = PortTemplate.create((PinTemplate)we);
                    PadTemplate padT = PadTemplate.create((Db)this.mDb, (Substrate)we.getSubstrate(), (String)("we" + wire.getWidth() / Design.getInternalPerMicron((Db)this.mDb)));
                    LayerShape.create((Db)this.mDb, (Layer)wire.getLayer(), (DbObject)padT, (AGeom)new ACircle(new APoint2D(), wire.getWidth() / 2L));
                    we.setType(PinTemplate.Type.WIREEND);
                    portT.setPadTemplate(padT);
                    portT.setLoc(pinT.getWorldLoc((DevicePath)hP.getFirst()).transform(this.mTransform));
                    pinT = we;
                    DevicePath relPath = hP.getPath().getRelativePathFromAnchor(wire.getDeviceTemplate());
                    if (relPath != null) {
                        pinT.setConnectedPin(relPath, (PinTemplate)hP.getSecond());
                    }
                }
                if (wire.getPinA() == null) {
                    wire.setPinA(StoredPath.get((DeviceTemplate)pinT.getDeviceTemplate()), pinT);
                } else if (wire.getPinB() == null) {
                    wire.setPinB(StoredPath.get((DeviceTemplate)pinT.getDeviceTemplate()), pinT);
                } else {
                    ALog.logInfo((String)"Problem with setting ports '%s' on wire when parsing '%s'", (Object[])new Object[]{hP, pinKey});
                }
                this.mParseState = this.isAKey(')');
                continue;
            }
            if (!type.equals("via)") || hasSavedForVia) continue;
            Stream.of(this.mPath.getFirstPoint(), this.mPath.getLastPoint()).forEach(point -> {
                LinkedList<Wire> wireList = this.mWires.containsKey(point) ? this.mWires.get(point) : new LinkedList<Wire>();
                wireList.add(wire);
                this.mWires.put((APoint2D)point, wireList);
            });
            hasSavedForVia = true;
        }
    }

    protected void parseVia(Net net) {
        String foundString;
        String viaName = this.getAString();
        PadTemplate padT = PadTemplate.get((Db)this.mDb, (Substrate)net.getSubstrate(), (String)viaName);
        if (padT == null) {
            ALog.logError((String)"Can not find padstack definition via '%s' for '%s'. Near line %d.", (Object[])new Object[]{viaName, net, this.mCurLine});
            this.mParseState = false;
            return;
        }
        APoint2D loc = this.equalsAPoint();
        if (loc == null) {
            ALog.logError((String)"Via '%s' needs a specified location.  Near line %d.", (Object[])new Object[]{viaName, this.mCurLine});
            this.mParseState = false;
            return;
        }
        while ((foundString = this.getAKey()) != null && this.mParseState) {
            String netName = this.getAString();
            this.mParseState = this.isAKey(')');
        }
        PinTemplate pT = PinTemplate.create((Net)net, (String)viaName);
        PortTemplate portT = PortTemplate.create((PinTemplate)pT);
        pT.setType(PinTemplate.Type.VIA);
        pT.setValue("creatorProcess", (Object)"router");
        portT.setPadTemplate(padT);
        PinInstance pI = PinInstance.create((Db)this.mDb, (String)viaName, (Device)this.mDevice, (PinTemplate)pT);
        if (pI == null) {
            ALog.logError((String)"Can not create pin instance for via '%s'.", (Object[])new Object[]{viaName});
            this.mParseState = false;
            return;
        }
        String netName = (String)this.mNetMap.inverse().get((Object)net);
        if (netName == null) {
            ALog.logError((String)"Can not find mapped net '%s'.", (Object[])new Object[]{netName});
            this.mParseState = false;
            return;
        }
        ArrayList<String> pinList = this.mNetPinMap.get(netName);
        pinList.stream().forEach(pin -> {
            DevicePath relPath;
            HierInst<PinTemplate> hp = this.mHPinMap.get(pin);
            if (hp == null) {
                return;
            }
            DevicePath devPath = (DevicePath)hp.getFirst();
            PinTemplate pinT = (PinTemplate)hp.getSecond();
            APoint2D worldLoc = pinT.getWorldLoc(devPath);
            if (loc.equals((Object)worldLoc) && (relPath = hp.getPath().getRelativePathFromAnchor(pT.getDeviceTemplate())) != null) {
                pT.setConnectedPin(relPath, (PinTemplate)hp.getSecond());
            }
        });
        APoint2D newLoc = new APoint2D(this.toDbUnits(loc.getX()), this.toDbUnits(loc.getY())).transform(this.mTransform);
        LinkedList<Wire> wireList = this.mWires.get(newLoc);
        pT.setLoc(newLoc);
        if (wireList == null) {
            ALog.logInfo((String)"Problem determining location for via '%s' of net %s at location (%d, %d).", (Object[])new Object[]{viaName, net.getName(), loc.getX(), loc.getY()});
        } else {
            wireList.stream().forEach(w -> {
                if (!padT.getLayers().contains(w.getLayer())) {
                    return;
                }
                if (w.getPinA() == null) {
                    w.setPinA(StoredPath.get((DeviceTemplate)pT.getDeviceTemplate()), pT);
                } else if (w.getPinB() == null) {
                    w.setPinB(StoredPath.get((DeviceTemplate)pT.getDeviceTemplate()), pT);
                } else {
                    ALog.logInfo((String)"Problem with setting ports '%s' at (%d, %d) on wire (%s, %s)", (Object[])new Object[]{padT.getName(), newLoc.getX(), newLoc.getY(), w.getPinA(), w.getPinB()});
                }
            });
        }
    }

    protected String getAString() {
        this.popWhitespaces();
        if (this.containsSpaces() && this.mQuotedTokens) {
            this.popQuotedString();
        } else {
            this.popNoSpaceTerminal();
        }
        return this.getParsedTerminal();
    }

    protected boolean containsSpaces() {
        this.mQ.saveState();
        this.popWhitespaces();
        char c = (char)this.mQ.pop();
        this.mQ.restoreState();
        return c == this.mQuoteChar;
    }

    @Override
    public double forcePopDouble() {
        this.popWhitespaces();
        return super.forcePopDouble();
    }

    protected String getAKey() {
        this.popWhitespaces();
        if (this.popChar('(')) {
            return this.popANoSpaceTerminal();
        }
        return null;
    }

    protected String equalsAString() {
        this.popWhitespaces();
        if (this.popChar('=')) {
            return this.popANoSpaceTerminal();
        }
        this.mParseState = false;
        return "";
    }

    protected APoint2D equalsAPoint() {
        if (this.popChar(')')) {
            return null;
        }
        APoint2D p = new APoint2D();
        long x = (long)this.forcePopDouble();
        long y = (long)this.forcePopDouble();
        p.setX(x);
        p.setY(y);
        return p;
    }

    protected double equalsANumber() {
        this.popWhitespaces();
        if (this.popChar('=')) {
            return this.forcePopDouble();
        }
        this.mParseState = false;
        return 0.0;
    }

    private boolean isAKey(char cc) {
        this.popWhitespaces();
        return this.popChar(cc);
    }

    protected long toDbUnits(long number) {
        return this.mDesign.getInternal((double)number / this.mUnits);
    }

    public Map<Net, List<Wire>> getNetWiresResult() {
        return this.mNetWires;
    }

    private /* synthetic */ void lambda$read$0(Map.Entry ef) {
        String pin1 = (String)((APair)ef.getKey()).getFirst();
        String pin2 = (String)((APair)ef.getKey()).getSecond();
        String layers = CCTFile.formatStringList((List)ef.getValue());
        if (!this.mRoutedPins.contains(pin1)) {
            ALog.logInfo((String)(pin1 + " on layer " + layers + " is not routed or a via was used in place."));
        }
        if (!this.mRoutedPins.contains(pin2)) {
            ALog.logInfo((String)(pin2 + " on layer " + layers + " is not routed or a via was used in place."));
        }
    }

    protected static class PadDef {
        String name;
        String type;
        double d1;
        double d2;
        int numCoords;
        ArrayList<Double> polypts = new ArrayList();

        protected PadDef() {
        }
    }
}

