/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.std.ConstraintContext;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.CCTFile.CCTFileConstraints;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.export.CCTFileWriter;
import com.sigrity.orbit.export.RouterRules;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CCTFileOutDo {
    protected static final String COMMENT_SEPARATOR = "################################################################################";
    protected static final boolean APR_ALLOW_STACK_VIAS = false;
    protected static final String DEFINE = "define";
    protected static final String WIDTH = "width";
    protected static final String CLEARANCE = "clearance";
    protected Device mDevice;
    protected CCTFile mCCTFile;
    protected CCTFileWriter mWriter = null;
    protected List<CCTFileConstraints.CCTConstraint> mConstraints = null;
    protected BiMap<String, String> mDiffPairs = HashBiMap.create();
    protected BiMap<String, Net> mNetMap = HashBiMap.create();
    protected Map<String, List<String>> mClasses;

    public CCTFileOutDo(File file, DevicePath rootPath, CCTFile cctFile) {
        this.mDevice = rootPath.getLast();
        if (file.exists()) {
            AUtil.deleteFile((File)file);
        }
        this.mWriter = new CCTFileWriter();
        this.mWriter.init(file);
        this.mCCTFile = cctFile;
        this.mConstraints = cctFile.getConstraints();
        this.mDiffPairs = cctFile.getDiffPairs();
        this.mClasses = cctFile.getClassesDef();
        this.mNetMap = cctFile.getNetMap();
    }

    public void writeDo() {
        String title = String.format("# File is translated from OrbitIO file %s.", LocalDateTime.now().toString());
        this.mWriter.mOut.println(title);
        this.mWriter.mOut.print("##");
        this.mWriter.startElementNewLine("Do file");
        this.mWriter.closeElement();
        this.mWriter.flush();
        if (this.useConstraintContext()) {
            this.writeRuleTree();
        } else {
            this.writeClass();
            this.writeDiffPairs();
            this.writeConstraints(this.mConstraints);
            this.mWriter.flush();
        }
        this.mWriter.close();
    }

    protected boolean useConstraintContext() {
        boolean ret = false;
        if (this.mDevice.getDb().getObjectCount(ConstraintContext.class) > 0) {
            ret = true;
        }
        return ret;
    }

    protected void writeRuleTree() {
        RuleNode nodes = RouterRules.build(this.mDevice.getDb());
        this.writeRuleTreeRecr(nodes, 0);
    }

    protected void writeRuleTreeRecr(RuleNode n, int level) {
        if (level < 2) {
            this.mWriter.mOut.println();
            this.mWriter.putElement(n.getTag());
        } else {
            this.mWriter.startElement(n.getTag());
        }
        for (String val : n.getValues()) {
            this.mWriter.putElement(val);
        }
        for (RuleNode child : n.getChildren()) {
            this.writeRuleTreeRecr(child, level + 1);
        }
        if (level < 2) {
            this.mWriter.flush();
        } else {
            this.mWriter.closeElement();
        }
    }

    protected void writeClass() {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# CLASS DEFINITIONS");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mClasses.entrySet().stream().forEach(c -> {
            this.mWriter.putElement(DEFINE);
            this.mWriter.startElement("class");
            this.mWriter.putElement((String)c.getKey());
            for (String e : (List)c.getValue()) {
                this.mWriter.putElement(e);
            }
            this.mWriter.closeElement();
            this.mWriter.flush();
        });
    }

    protected void writeGroup(List<CCTFileConstraints.CCTConstraint> grpConsList) {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# CLASS RULE DEFINITIONS");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        grpConsList.forEach(this::writeOneGroup);
    }

    protected void writeRegions(List<CCTFileConstraints.CCTConstraint> grpConsList) {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# REGION RULE DEFINITIONS");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        grpConsList.forEach(this::writeOneClassRegionRule);
    }

    protected void writeOneGroup(CCTFileConstraints.CCTConstraint cons) {
        this.mWriter.putElement(DEFINE);
        this.mWriter.startElement("class");
        this.mWriter.putElement(cons.getName());
        for (String netName : cons.getMembers()) {
            this.isValidNet(netName).ifPresent(name -> this.mWriter.putElement((String)name));
        }
        this.writeLayeredRules(cons, false);
        this.mWriter.closeElement();
        this.mWriter.flush();
    }

    protected Optional<String> isValidNet(String netName) {
        Net net = Net.get((DeviceTemplate)this.mDevice.getTemplate(), (String)netName);
        if (net == null) {
            return Optional.empty();
        }
        String mappedNetName = (String)this.mNetMap.inverse().get((Object)net);
        if (mappedNetName == null) {
            return Optional.empty();
        }
        return Optional.of(mappedNetName);
    }

    protected void writeGroupGroup(List<CCTFileConstraints.CCTConstraint> grpConsList) {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# CLASS_CLASS RULE DEFINITIONS");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        grpConsList.forEach(cons -> {
            this.mWriter.putElement(DEFINE);
            this.mWriter.startElement("class_class");
            this.mWriter.startElement("classes");
            this.mWriter.putElement(cons.getName());
            this.mWriter.putElement(cons.getMembers()[0]);
            this.mWriter.closeElement();
            this.writeLayeredRules((CCTFileConstraints.CCTConstraint)cons, true);
            this.mWriter.closeElement();
            this.mWriter.flush();
        });
    }

    protected void writeLayeredRules(CCTFileConstraints.CCTConstraint cons, boolean clearanceOnly) {
        cons.getLayerRule().forEach((layer, value) -> {
            this.mWriter.startElementNewLine("layer_rule");
            this.mWriter.putElement(value.getName());
            this.writeOneRule((CCTFileConstraints.CCTConstraint)value, clearanceOnly);
            this.mWriter.closeElement();
            this.mWriter.flush();
        });
        this.mWriter.flush();
    }

    protected void writeOneRule(CCTFileConstraints.CCTConstraint ruleValue, boolean clearanceOnly) {
        this.mWriter.startElement("rule");
        for (CCTFileConstraints.ConstraintType typ : ruleValue.getClearances()) {
            if (!typ.hasValue() || typ.getName().compareTo("region") == 0) continue;
            if (CCTFileConstraints.isClearanceTypeId(typ.getId())) {
                this.mWriter.startElement(CLEARANCE);
                this.mWriter.putDouble(typ.getValue());
                this.mWriter.closeElement();
                continue;
            }
            if (clearanceOnly) continue;
            this.mWriter.startElement(typ.getName());
            this.mWriter.putDouble(typ.getValue());
            this.mWriter.closeElement();
        }
        this.mWriter.closeElement();
    }

    protected void writeOneClassRegionRule(CCTFileConstraints.CCTConstraint cons) {
        cons.getLayerRule().forEach((layer, value) -> {
            for (CCTFileConstraints.ConstraintType typ : value.getClearances()) {
                String[] regionArr;
                if (typ.getId() != CCTFileConstraints.ConstraintId.region || typ.getStringValue().isEmpty()) continue;
                for (String areaString : regionArr = typ.getStringValue().get().split(",")) {
                    this.mWriter.putElement(DEFINE);
                    this.mWriter.startElement("region");
                    String[] regionData = areaString.split(" ");
                    this.mWriter.startElement(regionData[0]);
                    this.mWriter.putElement((String)layer);
                    for (int i = 1; i < regionData.length; ++i) {
                        this.mWriter.putElement(regionData[i]);
                    }
                    this.mWriter.closeElement();
                    this.writeOneRule((CCTFileConstraints.CCTConstraint)value, false);
                    this.mWriter.closeElement();
                    this.mWriter.flush();
                }
            }
        });
    }

    protected void writeDiffPairs() {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# PAIR DEFINITIONS");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mDiffPairs.entrySet().stream().forEach(rec -> {
            this.mWriter.putElement(DEFINE);
            this.mWriter.startElement("pair");
            this.mWriter.startElement("nets");
            this.mWriter.putElement((String)rec.getKey());
            this.mWriter.putElement((String)rec.getValue());
            this.mWriter.closeElement();
            this.mWriter.closeElement();
            this.mWriter.flush();
        });
    }

    protected void writeMisc() {
        this.mWriter.putElement("rule pcb");
        this.mWriter.startElement("stack_via");
        this.mWriter.putElement("off");
        this.mWriter.closeElement();
        this.mWriter.flush();
    }

    protected void writeConstraints(List<CCTFileConstraints.CCTConstraint> consList) {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# SAMENET CLEARANCE RULES");
        List<CCTFileConstraints.CCTConstraint> pcbConstraint = consList.stream().filter(cons -> cons.getName().equals("PCB")).collect(Collectors.toList());
        List<CCTFileConstraints.CCTConstraint> netConstraint = consList.stream().filter(cons -> !cons.getName().equals("PCB")).collect(Collectors.toList());
        List<CCTFileConstraints.CCTConstraint> grpConstraint = consList.stream().filter(cons -> cons.getType().equals((Object)CCTFileConstraints.RuleType.GROUP)).collect(Collectors.toList());
        List<CCTFileConstraints.CCTConstraint> grpGrpConstraint = consList.stream().filter(cons -> cons.getType().equals((Object)CCTFileConstraints.RuleType.GROUP_GROUP)).collect(Collectors.toList());
        this.writePcbConstraint(pcbConstraint);
        this.writeGroup(grpConstraint);
        this.writeRegions(grpConstraint);
        this.writeGroupGroup(grpGrpConstraint);
        if (grpConstraint.isEmpty()) {
            this.writeNetConstraint(netConstraint);
        }
        this.writeDiffPairConstraint();
    }

    protected void writePcbConstraint(List<CCTFileConstraints.CCTConstraint> consList) {
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# rule assignments for PCB clearances");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        consList.stream().forEach(cons -> {
            String netName = cons.getName();
            CCTFileConstraints.ConstraintType[] clearances = cons.getClearances();
            String mappedNetName = netName;
            this.mWriter.putFieldName("rule");
            this.mWriter.putElement(mappedNetName);
            this.mWriter.startElement(WIDTH);
            this.mWriter.putDouble(clearances[0].getValue());
            this.mWriter.closeElement();
            this.mWriter.flush();
            this.mWriter.putFieldName("rule");
            this.mWriter.putElement(mappedNetName);
            this.mWriter.startElement(CLEARANCE);
            this.mWriter.putDouble(clearances[1].getValue());
            this.mWriter.closeElement();
            this.mWriter.flush();
        });
    }

    protected void writeNetConstraint(List<CCTFileConstraints.CCTConstraint> consList) {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# rule assignments for net clearances");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        consList.stream().forEach(cons -> {
            String netName = cons.getName();
            CCTFileConstraints.ConstraintType[] clearances = cons.getClearances();
            String mappedNetName = netName;
            Net net = Net.get((DeviceTemplate)this.mDevice.getTemplate(), (String)netName);
            if (net == null) {
                return;
            }
            mappedNetName = (String)this.mNetMap.inverse().get((Object)net);
            if (mappedNetName == null) {
                return;
            }
            this.mWriter.putFieldName("rule net");
            this.mWriter.putElement(mappedNetName);
            this.mWriter.startElement(WIDTH);
            this.mWriter.putDouble(clearances[0].getValue());
            this.mWriter.closeElement();
            this.mWriter.flush();
            this.mWriter.putFieldName("rule net");
            this.mWriter.putElement(mappedNetName);
            this.mWriter.startElement(CLEARANCE);
            this.mWriter.putDouble(clearances[1].getValue());
            this.mWriter.closeElement();
            this.mWriter.flush();
        });
    }

    protected void writeDiffPairConstraint() {
        this.mWriter.mOut.println();
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mWriter.mOut.println("# rule assignments for class diff pair");
        this.mWriter.mOut.println(COMMENT_SEPARATOR);
        this.mCCTFile.getDiffConstraints().entrySet().forEach(e -> {
            String diffClass = this.mCCTFile.getDiffPairClass((Net)e.getKey());
            if (diffClass == null) {
                return;
            }
            for (CCTFileConstraints.ConstraintType ct : ((CCTFileConstraints.CCTConstraint)e.getValue()).getList()) {
                this.mWriter.putFieldName("rule class");
                this.mWriter.putElement(diffClass);
                this.mWriter.startElement(ct.getName());
                this.mWriter.putDouble(ct.getValue());
                this.mWriter.closeElement();
                this.mWriter.flush();
            }
        });
    }

    public static interface RuleNode {
        public String getTag();

        public List<String> getValues();

        public List<RuleNode> getChildren();
    }
}

