/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.std.Device;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.DevicePath;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class CCTFileOutDof {
    protected Device mDevice;
    protected PrintWriter mWriter = null;
    protected CCTFile mCctFile;
    protected File mDoPath = null;
    protected CCTFile.RoutingFlow mRoutingFlow = CCTFile.RoutingFlow.Unspecified;

    public CCTFileOutDof(File file, DevicePath rootPath, CCTFile cctFile) {
        this.mCctFile = cctFile;
        this.mDevice = rootPath.getLast();
        try {
            if (file.exists()) {
                AUtil.deleteFile((File)file);
            }
            this.mWriter = new PrintWriter(file);
        }
        catch (IOException fnfe) {
            ALog.logError((Throwable)fnfe, (String)"Problem with file %s", (Object[])new Object[]{file});
        }
    }

    public void setDoPath(File path) {
        this.mDoPath = path;
    }

    public void setRoutingFlow(CCTFile.RoutingFlow rf) {
        this.mRoutingFlow = rf;
    }

    public void writeDof() {
        String res;
        String devName = this.mDevice.getName();
        if (this.mCctFile.getMaxPass() != Long.MAX_VALUE) {
            this.mWriter.println("max_pass " + this.mCctFile.getMaxPass());
        }
        this.mWriter.println("no_confirm on");
        String fileName = CCTFile.deriveFileName(devName, CCTFile.FileType.DesignFile);
        this.mWriter.println(String.format("read file %s", fileName));
        if (this.mRoutingFlow == CCTFile.RoutingFlow.Detail) {
            Object rteFileName = devName;
            res = this.mCctFile.getDofLayer();
            if (!res.equals("")) {
                rteFileName = (String)rteFileName + res;
            }
            fileName = CCTFile.deriveFileName((String)rteFileName, CCTFile.FileType.RouteFile);
            this.mWriter.println(String.format("read file %s", fileName));
        }
        fileName = this.mDoPath == null ? CCTFile.deriveFileName(devName, CCTFile.FileType.DoFile) : this.mDoPath.getAbsolutePath();
        this.mWriter.println(String.format("cmd %s", fileName));
        this.mWriter.println("disable new_rule_sys");
        this.mWriter.println("enable direct_connect");
        this.mWriter.println("vset Guides OFF");
        this.mWriter.println("disable soft_boundary");
        this.mWriter.println("enable base_pp");
        this.mWriter.println("enable complex_net");
        this.mWriter.println("enable pair_symmetrical dismissible (pass 30 all)");
        this.mWriter.println("enable packing");
        this.mWriter.println("node corner rect off");
        this.mWriter.println("enable rect_node_corner_escape_penalty");
        this.mWriter.println("enable rect_node_mandatory_extension");
        this.mWriter.println("disable pair_die_side_symmetrical");
        this.mWriter.println("enable write_session_changed");
        this.mWriter.println("enable cluster_escaping all");
        this.mWriter.println("enable min_escape");
        this.mWriter.println("enable route_strategy max_clean");
        this.mWriter.println("enable keepout_under_capacitor");
        if (this.mCctFile.getEarlyStopParams() != null) {
            this.mWriter.println(String.format("stagnate (pass %s)(min_progress %s)", Integer.toString(this.mCctFile.getEarlyStopParams().get("pass").intValue()), Float.toString(this.mCctFile.getEarlyStopParams().get("min_progress").floatValue())));
        }
        this.mWriter.println("orbit (path (delete off)) (multi_pin (min off))");
        this.mWriter.println("net (multi_pin on)");
        this.mWriter.println("orbit (route_file (min on))");
        this.mWriter.println("orbit (pin (overlap off))");
        this.mCctFile.getSelectedLayers().stream().forEach(name -> {
            String detStr = String.format("set detour_ratio (layer %s) %f", CCTFile.getElement(name), this.mCctFile.getDetourRatio());
            this.mWriter.println(detStr);
        });
        this.mWriter.println("min via_stack on");
        this.mWriter.println("enable route_power");
        if (this.mRoutingFlow == CCTFile.RoutingFlow.Global) {
            this.mWriter.println("set routing_flow global");
        } else if (this.mRoutingFlow == CCTFile.RoutingFlow.Detail) {
            this.mWriter.println("set routing_flow detail");
        } else if (this.mRoutingFlow == CCTFile.RoutingFlow.Full) {
            this.mWriter.println("set routing_flow full");
        } else {
            this.mWriter.println("enable post_process");
        }
        this.mWriter.println("enable route_problem_status APR_problem.txt");
        this.mWriter.println("test_connection 3");
        if (!this.mCctFile.getAllowLoop()) {
            this.mWriter.println("path backward off");
        }
        if (this.mCctFile.getRouteAngle() == CCTFile.RouteAngle.Ninety) {
            this.mWriter.println("disable min_length");
        }
        this.mWriter.println("cost (length (min on) (virtual on) )");
        this.mWriter.println("cost (delta (dynamic on))");
        this.mWriter.println("pair (strategy pack (non_preroute on) (preroute on) (entrance off ) (target off ) (source off ) )");
        if (this.mCctFile.getSequenceDriver()) {
            this.mWriter.println("strategy sequence_driven on (mode cost) (via off)");
        }
        if (this.mCctFile.getFastMode()) {
            this.mWriter.println("triangulation progressive on");
        }
        if (this.mRoutingFlow != CCTFile.RoutingFlow.Full) {
            this.mWriter.println("enable length_matching");
            this.mWriter.println("enable pair_symmetrical");
        }
        this.mCctFile.getSNetMap().keySet().stream().sorted().forEach(netName -> this.mWriter.println(String.format("select net %s", netName)));
        this.mCctFile.getBundleConstraints().stream().forEach(bc -> {
            String groupId = bc.mBundleId;
            this.mWriter.println(String.format("define (group %s", groupId));
            this.mWriter.println("  (type bundle)");
            for (APair<String, String> fromto : bc.mFromTo) {
                this.mWriter.println(String.format("  (fromto %s %s)", fromto.getFirst(), fromto.getSecond()));
            }
            String layers = CCTFile.formatStringList((List)bc.mLayerGroup.get(0).getSecond());
            this.mWriter.println(String.format("  (circuit (use_layer %s))", layers));
            this.mWriter.println(")");
        });
        this.mCctFile.getSelectedPinPairs().entrySet().stream().sorted((e1, e2) -> APair.compare((APair)((APair)e1.getKey()), (APair)((APair)e2.getKey()))).forEach(entry -> {
            String circuitLayer = ((LinkedList)entry.getValue()).isEmpty() ? "" : String.format("(circuit (use_layer %s))", CCTFile.formatStringList((List)entry.getValue()));
            this.mWriter.println("select rat " + (String)((APair)entry.getKey()).first + " " + (String)((APair)entry.getKey()).second + " " + circuitLayer);
            this.mWriter.flush();
        });
        String viaP = this.mCctFile.getViaPattern().name().toLowerCase();
        this.mWriter.println("via_method_die " + viaP);
        this.mWriter.println("via_method_bga " + viaP);
        this.mWriter.println("via_method_route " + viaP);
        if (this.mCctFile.getMaxTimeSec() != Integer.MAX_VALUE) {
            this.mWriter.println("max_seconds " + this.mCctFile.getMaxTimeSec());
        }
        String postFix = res = this.mCctFile.getDofLayer();
        if (res.equals("")) {
            StringBuilder sb = new StringBuilder();
            this.mCctFile.getSelectedLayers().stream().forEach(name -> {
                sb.append(" ");
                sb.append(CCTFile.getElement(name));
            });
            res = sb.toString();
            postFix = "";
        }
        this.mWriter.println(String.format("route (layer %s)", postFix.equals("") ? res : CCTFile.getElement(res)));
        fileName = CCTFile.deriveFileName(String.format("%s%s", devName, postFix), CCTFile.FileType.RouteFile);
        this.mWriter.println(String.format("write routes '%s'", fileName));
        this.mWriter.println(String.format("enable route_parameter_status 'APR_parameters%s.txt'", postFix));
        this.mWriter.println(String.format("report route_status 'APR_route_status%s.txt'", postFix));
        this.mWriter.println(String.format("report route_pass 'APR_route_pass_status%s.txt'", postFix));
        this.mWriter.println(String.format("write didfile 'APR%s.did'", postFix));
        this.mWriter.println("quit");
        this.mWriter.flush();
        this.mWriter.close();
    }
}

