/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.BidiLinkHashMap;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOutlineGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.CCTFile.CCTFileConstraints;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.export.CCTFileWriter;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class CCTFileOutDsn {
    protected Db mDb = null;
    protected Design mDesign = null;
    protected DevicePath mRootPath = null;
    protected Substrate mSubstrate;
    protected Device mDevice;
    protected DeviceTemplate mDeviceTemplate;
    protected DevicePath mDevicePath;
    protected HashSet<PadTemplate> mPadTemplates = new LinkedHashSet<PadTemplate>();
    protected ArrayList<DeviceTemplate> mImages = new ArrayList();
    protected HashMap<DeviceTemplate, ArrayList<HierInst<Device>>> mComps = new LinkedHashMap<DeviceTemplate, ArrayList<HierInst<Device>>>();
    protected HashMap<Net, Net> mDiffPairs = new HashMap();
    protected CCTFileWriter mWriter = null;
    protected CCTFile.FileType mFileType = CCTFile.FileType.DesignFile;
    protected Unit mUnit = null;
    protected boolean mSelectedOnly = false;
    protected boolean mSaveBFAsVias = true;
    protected LinkedList<Net> mNets = null;
    protected List<PadTemplate> mLimitViaPadStackList;
    protected LinkedList<CCTFile.BundleConstraint> mBundles = null;
    protected BidiLinkHashMap<String, Layer> mLayerMap = new BidiLinkHashMap();
    protected BiMap<String, Net> mNetMap = HashBiMap.create();
    protected final HashMap<String, ArrayList<String>> mNetPinMap;
    protected HashMap<PinTemplate, String> mPinTMap = new HashMap();
    protected Set<PinTemplate> mPinPairSet;
    protected List<CCTFileConstraints.CCTConstraint> mConstraints = null;
    protected long mWireWidth = 0L;
    protected DecimalFormat mOutputUnitFmt = null;

    public CCTFileOutDsn(File file, DevicePath rootPath, CCTFile cctFile) {
        this.mDb = rootPath.getDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mSubstrate = rootPath.getSubstrate();
        this.mDevicePath = rootPath;
        this.mDevice = this.mDevicePath.getLast();
        this.mDeviceTemplate = this.mDevice.getTemplate();
        this.mUnit = this.mDesign.getUnit();
        if (file.exists()) {
            AUtil.deleteFile((File)file);
        }
        this.mWriter = new CCTFileWriter();
        this.mWriter.init(file);
        this.mLayerMap = cctFile.getLayerMap();
        this.mNetMap = cctFile.getNetMap();
        this.mNetPinMap = cctFile.getNetPinMap();
        this.mPinTMap = cctFile.getPinTMap();
        this.mConstraints = cctFile.getConstraints();
        this.mBundles = cctFile.getBundleConstraints();
        this.mLimitViaPadStackList = cctFile.getLimitViaPadStackList();
        this.mWireWidth = this.mUnit.fromUser(this.mConstraints.get(0).getClearances()[0].getValue());
        this.mPinPairSet = cctFile.getPinPairSet();
    }

    public void writeDesign() {
        if (this.mWriter.mOut == null) {
            ALog.logError((String)"Writer is not open, unable to write design. Aborting.");
            return;
        }
        String canonPath = this.mDb.getCanonicalPath();
        this.writeHeader();
        this.mWriter.startElementNewLine("PCB");
        this.mWriter.putElement(canonPath != null ? canonPath : "temp_database_file");
        this.writeParser();
        this.writeResolution();
        this.writeTimeResolution();
        this.writeStructure();
        this.writePlacement();
        this.writeLibrary(false);
        this.writeNetwork();
        this.writeWires(true);
        this.mWriter.closeElement();
        this.mWriter.flush();
        this.mWriter.close();
    }

    protected void writeHeader() {
        String title = String.format("# File is translated from OrbitIO file %s.\n", LocalDateTime.now().toString());
        this.mWriter.mOut.println(title);
    }

    protected void writeResolution() {
        String unitStr = Design.getUnitDistName((Db)this.mDb);
        this.mWriter.startElementNewLine("resolution");
        this.mWriter.putElement(unitStr.equalsIgnoreCase("micron") ? "UM" : unitStr);
        this.mWriter.putLong(Design.getUnitDistDbuCount((Db)this.mDb));
        this.mWriter.closeElement();
    }

    protected void writeTimeResolution() {
        this.mWriter.startElementNewLine("time_resolution");
        this.mWriter.putElement("nsec");
        this.mWriter.putLong(1000000L);
        this.mWriter.closeElement();
    }

    protected void writeParser() {
        this.mWriter.startElementNewLine("parser");
        this.mWriter.startElementNewLine("string_quote");
        this.mWriter.putElement("'");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("space_in_quoted_tokens");
        this.mWriter.putElement("on");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("host_cad");
        this.mWriter.putElement(OrbitApp.getApp().getName());
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("host_version");
        String ver = OrbitApp.getApp().getVersion();
        if (ver.equals("")) {
            ver = "unknown";
        }
        this.mWriter.putElement(ver);
        this.mWriter.closeElement();
        String unitStr = Design.getUnitDistName((Db)this.mDb);
        this.mWriter.startElementNewLine("write_resolution");
        this.mWriter.putElement(unitStr.equalsIgnoreCase("micron") ? "UM" : unitStr);
        this.mWriter.putLong(Design.getUnitDistDbuCount((Db)this.mDb));
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("routes_include");
        this.mWriter.putElement("testpoint");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("via_rotate_first");
        this.mWriter.putElement("off");
        this.mWriter.closeElement();
        this.mWriter.closeElement();
    }

    protected void writeStructure() {
        this.mWriter.startElementNewLine("structure");
        this.writeBoundary();
        this.writeControl();
        this.writeLayers();
        this.writeUseVias();
        this.writeRules();
        this.mWriter.closeElement();
    }

    protected void writeControl() {
        this.mWriter.startElementNewLine("control");
        this.mWriter.startElement("off_grid");
        this.mWriter.putElement("off");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("force_to_terminal_point");
        this.mWriter.putElement("on");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("noise_accumulation");
        this.mWriter.putElement("RSS");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("noise_calculation");
        this.mWriter.putElement("linear_interpolation");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("crosstalk_model");
        this.mWriter.putElement("CCT1A");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("bbv_ctr2ctr");
        this.mWriter.putElement("on");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("roundoff_rotation");
        this.mWriter.putElement("on");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("average_pair_length");
        this.mWriter.putElement("off");
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("reroute_order_viols");
        this.mWriter.putElement("on");
        this.mWriter.closeElement();
        this.mWriter.closeElement();
    }

    protected void writeRules() {
        long width = CCTFile.getWidthRule(this.mDeviceTemplate);
        long clr = CCTFile.getClearanceRule(this.mDeviceTemplate);
        this.mWriter.startElementNewLine("rule");
        this.mWriter.startElement("clearance");
        this.mWriter.putElement(clr > 0L ? this.toUserUnits(clr) : new DecimalFormat().format(this.mConstraints.get(0).getClearances()[1].getValue()));
        this.mWriter.closeElement();
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("rule");
        this.mWriter.startElement("width");
        this.mWriter.putElement(width > 0L ? this.toUserUnits(width) : new DecimalFormat().format(this.mConstraints.get(0).getClearances()[0].getValue()));
        this.mWriter.closeElement();
        this.mWriter.closeElement();
    }

    protected void writeLayers() {
        this.mLayerMap.entrySet().stream().sorted((e1, e2) -> Layer.OrderComparator.reversed().compare((Layer)e1.getValue(), (Layer)e2.getValue())).forEach(entry -> {
            String name = (String)entry.getKey();
            Layer layer = (Layer)entry.getValue();
            this.mWriter.startElementNewLine("layer");
            this.mWriter.putElement(name);
            this.mWriter.startElementNewLine("type");
            this.mWriter.putElement("signal");
            this.mWriter.closeElement();
            if (layer.getWidth() > 0L) {
                this.mWriter.startElementNewLine("rule");
                this.mWriter.startElement("width");
                this.mWriter.putElement(this.toUserUnits(layer.getWidth()));
                this.mWriter.closeElement();
                this.mWriter.closeElement();
            }
            this.mWriter.closeElement();
        });
    }

    protected void writeBoundary() {
        AGeom shape = this.mDevice.getTemplate().getBounds();
        if (shape == null) {
            return;
        }
        if (shape instanceof AOutlineGeom) {
            AOutlineGeom ao = (AOutlineGeom)shape;
            APolygon newPoly = new APolygon();
            boolean outlineOk = false;
            for (AGeom g : ao.getChildren()) {
                if (g instanceof ALine) {
                    ALine l = (ALine)g;
                    APoint2D pt = new APoint2D(l.getP0().getX(), l.getP0().getY());
                    newPoly.addPoint(pt);
                    pt = new APoint2D(l.getP1().getX(), l.getP1().getY());
                    newPoly.addPoint(pt);
                    outlineOk = true;
                    continue;
                }
                if (!(g instanceof AArc)) continue;
                AArc a = (AArc)g;
                APolygon p2 = a.toPolyLine(100).toPoly();
                newPoly.addPoints((Collection)p2.getPointList());
                outlineOk = true;
            }
            if (outlineOk) {
                newPoly.removeDuplicatePoints();
                newPoly.addPoint(newPoly.getFirstPoint());
                this.mWriter.startElementNewLine("boundary");
                this.mWriter.startElement("path");
                this.mWriter.putElement("pcb");
                this.mWriter.putElement(this.toUserUnits(1000000L));
                newPoly.getPoints().stream().forEach(p -> {
                    this.mWriter.putElement(this.toUserUnits(p.getX()));
                    this.mWriter.putElement(this.toUserUnits(p.getY()));
                });
                this.mWriter.closeElement();
                this.mWriter.closeElement();
                this.mWriter.startElementNewLine("boundary");
                this.mWriter.startElement("path");
                this.mWriter.putElement("signal");
                this.mWriter.putElement(this.toUserUnits(1000000L));
                newPoly.getPoints().stream().forEach(p -> {
                    this.mWriter.putElement(this.toUserUnits(p.getX()));
                    this.mWriter.putElement(this.toUserUnits(p.getY()));
                });
                this.mWriter.closeElement();
                this.mWriter.closeElement();
            }
        } else if (shape instanceof APolygon) {
            APolygon newPoly = (APolygon)shape;
            this.mWriter.startElementNewLine("boundary");
            this.mWriter.startElement("path");
            this.mWriter.putElement("pcb");
            this.mWriter.putElement(this.toUserUnits(1000000L));
            newPoly.getPoints().stream().forEach(p -> {
                this.mWriter.putElement(this.toUserUnits(p.getX()));
                this.mWriter.putElement(this.toUserUnits(p.getY()));
            });
            this.mWriter.closeElement();
            this.mWriter.closeElement();
            this.mWriter.startElementNewLine("boundary");
            this.mWriter.startElement("path");
            this.mWriter.putElement("signal");
            this.mWriter.putElement(this.toUserUnits(1000000L));
            newPoly.getPoints().stream().forEach(p -> {
                this.mWriter.putElement(this.toUserUnits(p.getX()));
                this.mWriter.putElement(this.toUserUnits(p.getY()));
            });
            this.mWriter.closeElement();
            this.mWriter.closeElement();
        } else {
            ARect r = this.mDevice.getAllWorldBounds();
            if (r.area() <= 0.0) {
                return;
            }
            this.mWriter.startElementNewLine("boundary");
            this.mWriter.startElement("rect");
            this.mWriter.putElement("pcb");
            this.mWriter.putElement(this.toUserUnits(r.getLL().getX()));
            this.mWriter.putElement(this.toUserUnits(r.getLL().getY()));
            this.mWriter.putElement(this.toUserUnits(r.getUR().getX()));
            this.mWriter.putElement(this.toUserUnits(r.getUR().getY()));
            this.mWriter.closeElement();
            this.mWriter.closeElement();
            this.mWriter.startElementNewLine("boundary");
            this.mWriter.startElement("rect");
            this.mWriter.putElement("signal");
            this.mWriter.putElement(this.toUserUnits(r.getLL().getX()));
            this.mWriter.putElement(this.toUserUnits(r.getLL().getY()));
            this.mWriter.putElement(this.toUserUnits(r.getUR().getX()));
            this.mWriter.putElement(this.toUserUnits(r.getUR().getY()));
            this.mWriter.closeElement();
            this.mWriter.closeElement();
        }
    }

    protected void writeUseVias() {
        if (this.mLimitViaPadStackList == null) {
            this.createUseVias();
        } else {
            this.mLimitViaPadStackList.stream().forEach(pt -> this.mPadTemplates.add((PadTemplate)pt));
        }
        if (this.mPadTemplates.isEmpty()) {
            return;
        }
        this.mWriter.startElementNewLine("via");
        for (PadTemplate pt2 : this.mPadTemplates) {
            this.mWriter.putElement(pt2.getName());
        }
        this.mWriter.closeElement();
    }

    protected void writePlacement() {
        this.mWriter.startElementNewLine("placement");
        this.mWriter.startElementNewLine("place_control");
        this.mWriter.startElement("flip_style");
        this.mWriter.putElement("mirror_first");
        this.mWriter.closeElement();
        this.mWriter.closeElement();
        this.mComps.clear();
        this.collectComps();
        this.mComps.entrySet().stream().forEach(entry -> {
            ArrayList devList = (ArrayList)entry.getValue();
            DeviceTemplate devT = (DeviceTemplate)entry.getKey();
            this.mWriter.startElementNewLine("component");
            this.mWriter.putElement(devT.getName());
            devList.stream().forEach(hDev -> {
                DevicePath devP = (DevicePath)hDev.first;
                Device dev = (Device)hDev.second;
                APoint2D wP = dev.getWorldLoc(devP);
                boolean m = dev.getWorldMirror(devP);
                float rot = dev.getWorldRotation(devP);
                this.mWriter.startElementNewLine("place");
                this.mWriter.putElement(CCTFile.formatDeviceName(devP));
                this.mWriter.putElement(this.toUserUnits(wP.getX()));
                this.mWriter.putElement(this.toUserUnits(wP.getY()));
                this.mWriter.putElement("front");
                float outRot = m ? rot : 360.0f - rot;
                this.mWriter.putFloat(ATransformUtil.normRot((float)outRot));
                if (m) {
                    this.mWriter.startElement("mirror");
                    this.mWriter.putElement("y");
                    this.mWriter.closeElement();
                }
                if (dev.getIsFixed()) {
                    this.mWriter.startElement("lock_type");
                    this.mWriter.putElement("position");
                    this.mWriter.closeElement();
                }
                this.mWriter.closeElement();
            });
            this.mWriter.closeElement();
        });
        this.mWriter.closeElement();
    }

    private void collectImages() {
        this.mDevicePath.getDescendants().stream().forEach(dp -> {
            DeviceTemplate dt = dp.getDeviceTemplate();
            if (dt != null && !this.mImages.contains(dt)) {
                this.mImages.add(dt);
            }
        });
    }

    private void collectComps() {
        this.mComps.clear();
        this.mDevicePath.getDescendants().stream().forEach(devP -> {
            Device dev = devP.getLast();
            DeviceTemplate devT = dev.getTemplate();
            ArrayList<Object> list = this.mComps.get(devT);
            HierInst hI = new HierInst(devP, (DbObject)dev);
            if (list == null) {
                list = new ArrayList();
                this.mComps.put(devT, list);
            }
            list.add((HierInst<Device>)hI);
            if (!this.mImages.contains(devT)) {
                this.mImages.add(devT);
            }
        });
    }

    protected void writeLibrary(boolean out) {
        String str = out ? "library_out" : "library";
        this.mWriter.startElementNewLine(str);
        this.writeImages();
        this.writePadStacks();
        this.mWriter.closeElement();
    }

    protected void writeImages() {
        this.collectComps();
        this.mComps.entrySet().stream().forEach(entry -> {
            DeviceTemplate dT = (DeviceTemplate)entry.getKey();
            this.writeImage(dT);
        });
    }

    protected void writeSubstrateImage() throws IOException {
        this.writeImage(this.mDeviceTemplate);
    }

    private boolean validCCTImage(DeviceTemplate dt) {
        for (PinTemplate p : dt.getPins()) {
            if (!this.validCCTPort(p)) continue;
            return true;
        }
        return false;
    }

    private boolean validCCTPort(PinTemplate p) {
        PinInstance cp;
        PadTemplate pt = p.getPadTemplate();
        if (pt == null) {
            return false;
        }
        if (p.getType().equals((Object)PinTemplate.Type.TOPOLOGYPOINT) && !this.mPinPairSet.contains(p)) {
            return false;
        }
        for (LayerShape s : pt.getLayerShapes()) {
            if (!this.mLayerMap.values().contains(s.getLayer())) continue;
            return true;
        }
        PinInstance dp = (PinInstance)p.getPinInstances().next();
        PinInstance pinInstance = cp = dp == null ? null : (PinInstance)dp.getPinTemplate().getConnectedPin().map(DeviceTemplate.DescendantPin::getPinInstance).orElse(null);
        if (cp == null) {
            return false;
        }
        p = cp.getPinTemplate();
        pt = p.getPadTemplate();
        if (pt == null) {
            return false;
        }
        for (LayerShape s : pt.getLayerShapes()) {
            if (!this.mLayerMap.values().contains(s.getLayer())) continue;
            return true;
        }
        return false;
    }

    protected void writeImage(DeviceTemplate dt) {
        Layer outlineLayer = null;
        for (Layer l : this.mLayerMap.values()) {
            if (l.getType() != Layer.LayerType.Signal) continue;
            outlineLayer = l;
            break;
        }
        this.mWriter.startElementNewLine("image");
        this.mWriter.putElement(dt.getName());
        AGeom shape = dt.getBounds();
        if (shape != null && !(shape instanceof AOutlineGeom)) {
            this.mWriter.startElementNewLine("outline");
            this.writeShape(shape, outlineLayer);
            this.mWriter.closeElement();
        }
        this.writePins(dt);
        this.writeKeepouts(dt);
        this.mWriter.closeElement();
    }

    private void writeKeepouts(DeviceTemplate dt) {
        dt.getObstacles().stream().forEach(obs -> obs.getLayerShapes().forEach(ls -> {
            Layer l = ls.getLayer();
            if (!CCTFile.isCCTLayer(l)) {
                return;
            }
            this.mWriter.startElementNewLine("keepout");
            AGeom ag = ls.getGeom();
            this.writeShape(ag, ls.getLayer());
            this.mWriter.closeElement();
        }));
    }

    private void writePadStacks() {
        LinkedList<PadTemplate> padTemplates = new LinkedList<PadTemplate>();
        padTemplates.addAll(this.mPadTemplates);
        Collections.sort(padTemplates);
        for (PadTemplate padTemplate : padTemplates) {
            this.writePadstack(padTemplate);
        }
    }

    private void writePins(DeviceTemplate dt) {
        LinkedList pinTemplates = new LinkedList();
        HashSet unique = new HashSet();
        dt.getPins().stream().filter(pt -> this.validCCTPort((PinTemplate)pt)).forEach(pt -> {
            unique.add(pt);
            pt.getPortTemplates().forEach(port -> this.mPadTemplates.add(port.getPadTemplate()));
        });
        pinTemplates.addAll(unique);
        Collections.sort(pinTemplates, new PinSorter());
        for (PinTemplate pinTemplate : pinTemplates) {
            this.writePin(pinTemplate);
        }
    }

    private void writePin(PinTemplate pinTemplate) {
        for (PortTemplate portTemplate : pinTemplate.getPortTemplates()) {
            APoint2D loc = portTemplate.getLoc();
            PadTemplate padTemplate = portTemplate.getPadTemplate();
            this.mWriter.startElementNewLine("pin");
            this.mWriter.putElement(padTemplate.getName());
            if ((double)portTemplate.getRotate() != 0.0) {
                this.mWriter.startElement("rotate");
                this.mWriter.putLong((long)portTemplate.getRotate());
                this.mWriter.closeElement();
            }
            this.mWriter.putElement(String.format("%s:%d", this.mPinTMap.get(pinTemplate), portTemplate.getPortNum()));
            this.mWriter.putElement(this.toUserUnits(loc.getX()));
            this.mWriter.putElement(this.toUserUnits(loc.getY()));
            this.mWriter.closeElement();
        }
    }

    private ArrayList<PinTemplate> getSortedPorts(DeviceTemplate dt) {
        ArrayList<PinTemplate> ports = new ArrayList<PinTemplate>();
        for (PinTemplate p : dt.getPins()) {
            ports.add(p);
        }
        Collections.sort(ports, new PinSorter());
        return ports;
    }

    protected void writeNetwork() {
        this.mWriter.startElementNewLine("network");
        this.mNetPinMap.entrySet().stream().forEach(entry -> {
            String netName = (String)entry.getKey();
            ArrayList pinNames = (ArrayList)entry.getValue();
            if (pinNames.isEmpty()) {
                return;
            }
            this.mWriter.startElementNewLine("net");
            this.mWriter.putElement(netName);
            this.mWriter.startElementNewLine("pins");
            pinNames.stream().sorted().forEach(pinName -> this.mWriter.putElement((String)pinName));
            this.mWriter.closeElement();
            this.mWriter.closeElement();
        });
        this.mBundles.stream().forEach(entry -> {
            if (entry.mNets.isEmpty()) {
                return;
            }
            String bundleName = entry.mBundleId;
            this.mWriter.startElementNewLine("bundle");
            this.mWriter.putElement(bundleName);
            this.mWriter.startElementNewLine("nets");
            for (String string : entry.mNets) {
                this.mWriter.putElement(string);
            }
            this.mWriter.closeElement();
            for (APair aPair : entry.mLayerGroup) {
                this.mWriter.startElementNewLine("gap");
                this.mWriter.putElement(((Integer)aPair.getFirst()).toString());
                this.mWriter.startElementNewLine("layer");
                for (String layerName : (LinkedList)aPair.getSecond()) {
                    this.mWriter.putElement(layerName);
                }
                this.mWriter.closeElement();
                this.mWriter.closeElement();
            }
            this.mWriter.closeElement();
        });
        this.mWriter.closeElement();
    }

    private void collectNetsAndPorts(DevicePath devPath, ArrayList<Net> topNets, HashMap<DeviceTemplate, ArrayList<PinTemplate>> tPorts) {
        Device dev = devPath.getLast();
        if (dev == null || dev.getSubstrate() == null) {
            return;
        }
        DeviceTemplate devT = dev.getTemplate();
        if (devT == null) {
            return;
        }
        if (tPorts.get(devT) != null) {
            return;
        }
        ArrayList ports = new ArrayList();
        devT.getPins().stream().filter(pinT -> this.validCCTPort((PinTemplate)pinT)).forEach(pinT -> {
            ports.add(pinT);
            Net n = pinT.getNet();
            n = NetMap.getTopmostNet((Net)n, (DevicePath)devPath);
            if (!topNets.contains(n) && !this.isUnusedNet(n)) {
                topNets.add(n);
            }
        });
        Collections.sort(ports, new PinSorter());
        tPorts.put(devT, ports);
    }

    protected void writeWires(boolean allPts) {
        if (!this.mDeviceTemplate.getWires().hasNext()) {
            return;
        }
        this.mWriter.startElementNewLine("wiring");
        this.mDeviceTemplate.getWires().stream().forEach(w -> {
            Net net = w.getNet();
            this.writeWire(this.mDevicePath, (Wire)w, net, allPts);
        });
        this.mWriter.closeElement();
    }

    protected void writeWire(DevicePath p, Wire w, Net topNet, boolean allPts) {
        String layerName = (String)this.mLayerMap.getKey((Object)w.getLayer());
        if (layerName == null) {
            ALog.logInfo((String)("Error getting layer name " + w.getLayer().getName() + " on writing pre-routed wire to DSN file"));
            return;
        }
        String netName = (String)this.mNetMap.inverse().get((Object)topNet);
        if (netName == null) {
            ALog.logInfo((String)("Error getting net name " + topNet.getName() + " on writing pre-routed wire to DSN file"));
            return;
        }
        this.mWriter.startElementNewLine("wire");
        APath path = w.getPath();
        this.mWriter.startElement("path");
        this.mWriter.putElement(layerName);
        this.mWriter.putElement(this.toUserUnits(path.getWidth()));
        if (allPts) {
            for (APoint2D pnt : path.getPoints()) {
                AffineTransform worldXform = p.getTransform();
                APoint2D wP = pnt.transform(worldXform);
                this.mWriter.putElement(this.toUserUnits(wP.getX()));
                this.mWriter.putElement(this.toUserUnits(wP.getY()));
            }
        } else {
            APoint2D pnt = path.getFirstPoint();
            AffineTransform worldXform = p.getTransform();
            APoint2D wP = pnt.transform(worldXform);
            this.mWriter.putElement(this.toUserUnits(wP.getX()));
            this.mWriter.putElement(this.toUserUnits(wP.getY()));
            pnt = path.getLastPoint();
            worldXform = p.getTransform();
            wP = pnt.transform(worldXform);
            this.mWriter.putElement(this.toUserUnits(wP.getX()));
            this.mWriter.putElement(this.toUserUnits(wP.getY()));
        }
        this.mWriter.closeElement();
        if (topNet != null) {
            this.mWriter.startElement("net");
            this.mWriter.putElement(netName);
            this.mWriter.closeElement();
        }
        this.mWriter.closeElement();
    }

    protected void writeBonds(DevicePath dp) throws IOException {
        if (this.mSaveBFAsVias) {
            return;
        }
        Device d = dp.getLast();
        if (!d.getIsPlaced()) {
            return;
        }
        List dps = d.getWireBondPins();
        for (PinInstance wbPort : dps) {
            PinTemplate pt;
            if (wbPort == null || (pt = wbPort.getPinTemplate()) == null) continue;
            APoint2D wP = wbPort.getWorldLoc(dp);
            float rotate = wbPort.getWorldRotation(dp);
            this.writeABF(wbPort, wP, rotate);
        }
    }

    protected void writeABF(PinInstance wbPort, APoint2D wP, float rotate) throws IOException {
        PinTemplate pt = wbPort.getPinTemplate();
        Device parent = wbPort.getDevice();
        this.mWriter.startElementNewLine("bond");
        this.mWriter.putElement(parent.getName() + "-" + wbPort.getName());
        this.mWriter.putElement(pt.getName());
        this.mWriter.putElement(this.toUserUnits(wP.getX()));
        this.mWriter.putElement(this.toUserUnits(wP.getY()));
        this.mWriter.putElement("front");
        this.mWriter.putElement(Float.toString(rotate));
        this.mWriter.closeElement();
    }

    protected void writePortVias(DevicePath dp) throws IOException {
        Device device = dp.getLast();
        for (PinInstance port : device.getPins()) {
            PinTemplate pt;
            if (!this.isVia(port) || (pt = port.getPinTemplate()) == null || pt.getPadTemplate() == null) continue;
            Net n = port.getNet();
            n = NetMap.getTopmostNet((Net)n, (DevicePath)dp);
            APoint2D wP = port.getWorldLoc(dp);
            float rotate = port.getWorldRotation(dp);
            this.writeAVia(pt.getPadTemplate().getName(), this.isUnusedNet(n) ? null : n, wP, rotate, port.fixed());
        }
    }

    protected void writeAVia(String viaName, Net n, APoint2D wP, float rotate, boolean fixed) throws IOException {
        this.mWriter.startElementNewLine("via");
        this.mWriter.putElement(viaName);
        this.mWriter.putElement(this.toUserUnits(wP.getX()));
        this.mWriter.putElement(this.toUserUnits(wP.getY()));
        if (n != null) {
            this.mWriter.startElement("net");
            this.mWriter.putElement(n.getName());
            this.mWriter.closeElement();
        }
        if ((double)rotate != 0.0) {
            this.mWriter.startElement("rotate");
            this.mWriter.putElement(Float.toString(rotate));
            this.mWriter.closeElement();
        }
        if (fixed) {
            this.mWriter.startElement("type");
            this.mWriter.putElement("fixed");
            this.mWriter.closeElement();
        }
        this.mWriter.closeElement();
    }

    protected void writeNetBFs(DevicePath p, ArrayList<PinInstance> ports) throws IOException {
        if (ports == null || ports.isEmpty()) {
            return;
        }
        for (PinInstance port : ports) {
            Device parent = port.getDevice();
            DevicePath dp = new DevicePath(parent);
            APoint2D wLoc = port.getWorldLoc(dp);
            float rotate = port.getWorldRotation(dp);
            this.writeABF(port, wLoc, rotate);
        }
    }

    protected void writeNetVias(DevicePath dp, ArrayList<PinInstance> ports) throws IOException {
        if (ports == null || ports.isEmpty()) {
            return;
        }
        for (PinInstance port : ports) {
            PinTemplate pt = port.getPinTemplate();
            if (pt == null || pt.getPadTemplate() == null) continue;
            APoint2D wP = port.getWorldLoc(dp);
            float rotate = port.getWorldRotation(dp);
            this.writeAVia(pt.getPadTemplate().getName(), null, wP, rotate, port.fixed());
        }
    }

    private void writePadstack(PadTemplate pt) {
        if (pt == null) {
            return;
        }
        if (pt.getName().contains("WireEnd")) {
            return;
        }
        this.mWriter.startElementNewLine("padstack");
        this.mWriter.putElement(pt.getName());
        for (LayerShape ls : pt.getLayerShapes()) {
            this.writeLayerShape(ls);
        }
        this.mWriter.closeElement();
    }

    private void writeLayerShape(LayerShape layerShape) {
        Layer l = layerShape.getLayer();
        if (!CCTFile.isCCTLayer(l)) {
            return;
        }
        AGeom geom = layerShape.getGeom();
        this.mWriter.startElementNewLine("shape");
        this.writeShape(geom, layerShape.getLayer());
        this.mWriter.closeElement();
    }

    private void writeShape(AGeom geom, Layer layer) {
        String layerName;
        String string = layerName = layer != null ? (String)this.mLayerMap.getKey((Object)layer) : "signal";
        if (layerName == null) {
            return;
        }
        this.mWriter.writeShape(geom, layerName, this::toUserUnits);
    }

    protected String toUserUnits(long d) {
        if (this.mOutputUnitFmt == null) {
            Unit.Distance designDistUnit = this.mDesign.getUnit();
            this.mOutputUnitFmt = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            double maxFractionalDigits = Math.log10(designDistUnit.getUnitPerUser());
            this.mOutputUnitFmt.setMaximumFractionDigits((int)Math.round(maxFractionalDigits));
        }
        return this.mOutputUnitFmt.format(this.mDesign.getUser(d));
    }

    private boolean isVia(PinInstance port) {
        PinTemplate tp = port.getPinTemplate();
        if (tp.getType() == PinTemplate.Type.WIREBONDPAD) {
            return false;
        }
        if (tp.getType() == PinTemplate.Type.BUMPPAD) {
            return false;
        }
        return tp.getType() != PinTemplate.Type.BALLPAD;
    }

    private boolean isUnusedNet(Net n) {
        return n.isUnused() || n.getName().contains("NetUnused");
    }

    private void createUseVias() {
        ArrayList<Layer> layerList = new ArrayList<Layer>(this.mLayerMap.values());
        layerList.sort(Layer.OrderComparator.reversed());
        for (int i = 0; i < layerList.size() - 1; ++i) {
            for (int j = i + 1; j < layerList.size(); ++j) {
                ACircle rpad;
                String layerToLayer = (String)this.mLayerMap.getKey((Object)((Layer)layerList.get(i))) + "_" + (String)this.mLayerMap.getKey((Object)((Layer)layerList.get(j)));
                String padName = "VIA_USER_" + layerToLayer + "_r" + this.mWireWidth / 2L;
                PadTemplate pt = PadTemplate.get((Db)this.mDb, (Substrate)((Layer)layerList.get(i)).getSubstrate(), (String)padName);
                if (this.checkExistedPadTemplate(pt, rpad = new ACircle(0L, 0L, this.mWireWidth / 2L), layerList, i, j)) {
                    this.mPadTemplates.add(pt);
                    continue;
                }
                pt = PadTemplate.create((Db)this.mDb, (Substrate)layerList.get(i).getSubstrate(), (String)padName);
                for (int k = i; k <= j; ++k) {
                    LayerShape.create((Db)this.mDb, (Layer)layerList.get(k), (DbObject)pt, (AGeom)rpad);
                }
                this.mPadTemplates.add(pt);
            }
        }
    }

    private boolean checkExistedPadTemplate(PadTemplate pt, ACircle rpad, ArrayList<Layer> layerList, int start, int end) {
        if (pt == null) {
            return false;
        }
        Set l = pt.getLayers();
        if (l.size() != end - start + 1) {
            return false;
        }
        for (int i = start; i <= end; ++i) {
            if (l.contains(layerList.get(i))) continue;
            return false;
        }
        for (LayerShape ls : pt.getLayerShapes()) {
            if (ls.getGeom().equals((Object)rpad)) continue;
            return false;
        }
        return true;
    }

    public static class PinSorter
    implements Comparator<PinTemplate> {
        @Override
        public int compare(PinTemplate p0, PinTemplate p1) {
            int relation = p0.getName().compareTo(p1.getName());
            if (relation != 0) {
                return relation;
            }
            APoint2D l0 = p0.getLoc();
            APoint2D l1 = p1.getLoc();
            return l0.compareTo(l1);
        }
    }
}

