/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.BidiLinkHashMap;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.CCTFile.CCTFileConstraints;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.export.CCTFileWriter;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CCTFileOutSes {
    protected Db mDb = null;
    protected Design mDesign = null;
    protected DevicePath mRootPath = null;
    protected CCTFile mCCTFile = null;
    protected Substrate mSubstrate;
    protected Device mDevice;
    protected DeviceTemplate mDeviceTemplate;
    protected DevicePath mDevicePath;
    protected HashSet<PadTemplate> mPadTemplates = new HashSet();
    protected CCTFileWriter mWriter = null;
    protected CCTFile.FileType mFileType = CCTFile.FileType.SessionFile;
    protected Unit mUnit = null;
    protected LinkedList<Net> mNets = null;
    protected BidiLinkHashMap<String, Layer> mLayerMap = new BidiLinkHashMap();
    protected BiMap<String, Net> mNetMap = HashBiMap.create();
    protected HashMap<String, ArrayList<String>> mNetPinMap = new HashMap();
    protected Map<String, HierInst<PinTemplate>> mHPinMap = new HashMap<String, HierInst<PinTemplate>>();
    protected HashMap<PinTemplate, String> mPinTMap = new HashMap();
    protected List<CCTFileConstraints.CCTConstraint> mConstraints = null;
    protected long mWireWidth = 0L;
    public static final boolean APR_SES_WRITE_CONNECT = false;

    public CCTFileOutSes(File file, DevicePath rootPath, CCTFile cctFile) {
        this.mDb = rootPath.getDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mCCTFile = cctFile;
        this.mSubstrate = rootPath.getSubstrate();
        this.mDevicePath = rootPath;
        this.mDevice = this.mDevicePath.getLast();
        this.mDeviceTemplate = this.mDevice.getTemplate();
        this.mUnit = this.mDesign.getUnit();
        if (file.exists()) {
            AUtil.deleteFile((File)file);
        }
        this.mWriter = new CCTFileWriter();
        this.mWriter.init(file);
        this.mLayerMap = cctFile.getLayerMap();
        this.mNetMap = cctFile.getNetMap();
        this.mNetPinMap = cctFile.getNetPinMap();
        this.mPinTMap = cctFile.getPinTMap();
        this.mHPinMap = cctFile.getHPinMap();
        this.mConstraints = cctFile.getConstraints();
        this.mWireWidth = this.mUnit.fromUser(this.mConstraints.get(0).getClearances()[0].getValue());
    }

    public void writeSession() {
        String canonPath = this.mDb.getCanonicalPath();
        this.writeHeader();
        this.mWriter.startElementNewLine("session");
        this.mWriter.putElement(canonPath != null ? canonPath : "temp_database_file");
        this.writeBaseDesign();
        this.writeRoutes();
        this.mWriter.closeElement();
        this.mWriter.flush();
        this.mWriter.close();
    }

    private void writeRoutes() {
        this.writeResolution();
        this.writeParser();
        this.writeStructure();
        this.writeLibrary();
        this.writeNetwork();
    }

    protected void writeHeader() {
        String title = String.format("# File is translated from OrbitIO file %s.\n", LocalDateTime.now().toString());
        this.mWriter.mOut.println(title);
    }

    protected void writeResolution() {
        String unitStr = Design.getUnitDistName((Db)this.mDb);
        this.mWriter.startElementNewLine("resolution");
        this.mWriter.putElement(unitStr.equalsIgnoreCase("micron") ? "UM" : unitStr);
        this.mWriter.putLong(Design.getUnitDistDbuCount((Db)this.mDb));
        this.mWriter.closeElement();
    }

    protected void writeBaseDesign() {
        String canonPath = this.mDb.getCanonicalPath();
        this.mWriter.startElementNewLine("base_design");
        this.mWriter.putElement(canonPath != null ? canonPath : "temp_database_file");
        this.mWriter.closeElement();
    }

    protected void writeParser() {
        this.mWriter.startElementNewLine("parser");
        this.mWriter.startElementNewLine("host_cad");
        this.mWriter.putElement(OrbitApp.getApp().getName());
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("host_version");
        this.mWriter.putElement(OrbitApp.getApp().getVersion());
        this.mWriter.closeElement();
        this.mWriter.closeElement();
        this.mWriter.closeElement();
    }

    protected void writeStructure() {
        this.mWriter.startElementNewLine("structure_out");
        this.writeLayers();
        this.writeControl();
        this.mWriter.closeElement();
    }

    protected void writeControl() {
        this.mWriter.startElementNewLine("control");
        this.mWriter.startElementNewLine("roundoff_rotation");
        this.mWriter.putElement("on");
        this.mWriter.closeElement();
        this.mWriter.closeElement();
    }

    protected void writeRules() {
        long width = CCTFile.getWidthRule(this.mDeviceTemplate);
        long clr = CCTFile.getClearanceRule(this.mDeviceTemplate);
        this.mWriter.startElementNewLine("rule");
        this.mWriter.startElement("clearance");
        this.mWriter.putElement(clr > 0L ? this.toOutputUnits(clr) : Double.toString(this.mConstraints.get(0).getClearances()[1].getValue()));
        this.mWriter.closeElement();
        this.mWriter.closeElement();
        this.mWriter.startElementNewLine("rule");
        this.mWriter.startElement("width");
        this.mWriter.putElement(width > 0L ? this.toOutputUnits(width) : Double.toString(this.mConstraints.get(0).getClearances()[0].getValue()));
        this.mWriter.closeElement();
        this.mWriter.closeElement();
    }

    protected void writeLayers() {
        this.mLayerMap.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            Layer layer = (Layer)entry.getValue();
            this.mWriter.startElementNewLine("layer");
            this.mWriter.putElement(name);
            this.mWriter.startElementNewLine("type");
            this.mWriter.putElement("signal");
            this.mWriter.closeElement();
            if (layer.getWidth() > 0L) {
                this.mWriter.startElementNewLine("rule");
                this.mWriter.startElement("width");
                this.mWriter.putElement(this.toOutputUnits(layer.getWidth()));
                this.mWriter.closeElement();
                this.mWriter.closeElement();
            }
            this.mWriter.closeElement();
        });
    }

    protected void writeLibrary() {
        this.mWriter.startElementNewLine("library_out");
        this.writePadStacks();
        this.mWriter.closeElement();
    }

    private void writePadStacks() {
        this.collectPadstacks();
        LinkedList<PadTemplate> padTemplates = new LinkedList<PadTemplate>();
        padTemplates.addAll(this.mPadTemplates);
        Collections.sort(padTemplates);
        for (PadTemplate padTemplate : padTemplates) {
            this.writePadstack(padTemplate);
        }
    }

    protected void writeNetwork() {
        this.mWriter.startElementNewLine("network_out");
        this.mNetMap.entrySet().stream().forEach(entry -> {
            String netName = (String)entry.getKey();
            Net net = (Net)entry.getValue();
            this.mWriter.startElementNewLine("Net");
            this.mWriter.putElement(netName);
            this.writeWires(net, true);
            this.mWriter.closeElement();
        });
        this.mWriter.closeElement();
    }

    protected void writeWires(Net net, boolean allPts) {
        if (!net.getWires().hasNext()) {
            return;
        }
        net.getWires().stream().forEach(w -> this.writeWire(this.mDevicePath, (Wire)w, allPts));
    }

    protected void writeWire(DevicePath devPath, Wire w, boolean allPts) {
        APoint2D wP;
        APoint2D pnt;
        AffineTransform worldXform = devPath.getTransform();
        String layerName = (String)this.mLayerMap.getKey((Object)w.getLayer());
        Net topNet = w.getNet();
        if (layerName == null) {
            ALog.logInfo((String)("Error getting layer name " + w.getLayer().getName() + " on writing pre-routed wire to SES file"));
            return;
        }
        String netName = (String)this.mNetMap.inverse().get((Object)topNet);
        if (netName == null) {
            ALog.logInfo((String)("Error getting net name " + topNet.getName() + " on writing pre-routed wire to SES file"));
            return;
        }
        HierInst hpA = w.getPinA();
        HierInst hpB = w.getPinB();
        if (hpA == null || hpB == null) {
            ALog.logWarn((String)"Discarding dangling wire.");
            return;
        }
        hpA = new HierInst(((DevicePath)hpA.getFirst()).getAFullPath(), (DbObject)((PinTemplate)hpA.getSecond()));
        hpB = new HierInst(((DevicePath)hpB.getFirst()).getAFullPath(), (DbObject)((PinTemplate)hpB.getSecond()));
        HierInst hportA = w.getTouchPortA();
        HierInst hportB = w.getTouchPortB();
        if (hportA == null || hportB == null) {
            ALog.logWarn((String)"Problem retrieving port ends from wire.");
            return;
        }
        String hpAStr = this.mCCTFile.getPortMappedName((HierInst<PinTemplate>)hpA, hportA.getPortTemplate());
        String hpBStr = this.mCCTFile.getPortMappedName((HierInst<PinTemplate>)hpB, hportB.getPortTemplate());
        if (hpAStr == null || hpBStr == null || !this.mHPinMap.containsKey(hpAStr) || !this.mHPinMap.containsKey(hpBStr)) {
            ALog.logInfo((String)"Problem retrieving pin ends from wire.");
            return;
        }
        this.mWriter.startElementNewLine("wire");
        APath path = w.getPath();
        this.mWriter.startElement("path");
        this.mWriter.putElement(layerName);
        this.mWriter.putElement(this.toOutputUnits(path.getWidth()));
        if (allPts) {
            for (APoint2D pnt2 : path.getPoints()) {
                APoint2D wP2 = pnt2.transform(worldXform);
                this.mWriter.putElement(this.toOutputUnits(wP2.getX()));
                this.mWriter.putElement(this.toOutputUnits(wP2.getY()));
            }
        } else {
            APoint2D pnt3 = path.getFirstPoint();
            APoint2D wP3 = pnt3.transform(worldXform);
            this.mWriter.putElement(this.toOutputUnits(wP3.getX()));
            this.mWriter.putElement(this.toOutputUnits(wP3.getY()));
            pnt3 = path.getLastPoint();
            wP3 = pnt3.transform(worldXform);
            this.mWriter.putElement(this.toOutputUnits(wP3.getX()));
            this.mWriter.putElement(this.toOutputUnits(wP3.getY()));
        }
        this.mWriter.closeElement();
        this.mWriter.startElement("net");
        this.mWriter.putElement(netName);
        this.mWriter.closeElement();
        boolean isViaA = false;
        boolean isViaB = false;
        this.mWriter.closeElement();
        if (isViaA) {
            this.mWriter.startElementNewLine("via");
            this.mWriter.putElement(((PinTemplate)hpA.second).getPadTemplate().getName());
            pnt = ((PinTemplate)hpA.second).getWorldLoc(devPath);
            wP = pnt.transform(worldXform);
            this.mWriter.putElement(this.toOutputUnits(wP.getX()));
            this.mWriter.putElement(this.toOutputUnits(wP.getY()));
            this.mWriter.startElement("net");
            this.mWriter.putElement(netName);
            this.mWriter.closeElement();
            this.mWriter.closeElement();
        }
        if (isViaB) {
            this.mWriter.startElementNewLine("via");
            this.mWriter.putElement(((PinTemplate)hpB.second).getPadTemplate().getName());
            pnt = ((PinTemplate)hpB.second).getWorldLoc(devPath);
            wP = pnt.transform(worldXform);
            this.mWriter.putElement(this.toOutputUnits(wP.getX()));
            this.mWriter.putElement(this.toOutputUnits(wP.getY()));
            this.mWriter.startElement("net");
            this.mWriter.putElement(netName);
            this.mWriter.closeElement();
            this.mWriter.closeElement();
        }
    }

    private void writePadstack(PadTemplate pt) {
        if (pt == null) {
            return;
        }
        if (pt.getName().contains("WireEnd")) {
            return;
        }
        this.mWriter.startElementNewLine("padstack");
        this.mWriter.putElement(pt.getName());
        for (LayerShape ls : pt.getLayerShapes()) {
            this.writeLayerShape(ls);
        }
        this.mWriter.closeElement();
    }

    private void writeLayerShape(LayerShape layerShape) {
        Layer l = layerShape.getLayer();
        if (!CCTFile.isCCTLayer(l)) {
            return;
        }
        AGeom geom = layerShape.getGeom();
        this.mWriter.startElementNewLine("shape");
        this.writeShape(geom, layerShape.getLayer());
        this.mWriter.closeElement();
    }

    private void writeShape(AGeom geom, Layer layer) {
        String layerName = layer != null ? (String)this.mLayerMap.getKey((Object)layer) : "signal";
        this.mWriter.writeShape(geom, layerName, this::toOutputUnits);
    }

    private void collectPadstacks() {
        for (PadTemplate pad : this.mDb.getObjects(PadTemplate.class)) {
            this.mPadTemplates.add(pad);
        }
    }

    protected String toOutputUnits(long d) {
        return Long.toString(d);
    }
}

