/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOutlineGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;

public class CCTFileWriter {
    public static final int CCT_MAX_COLUMNS = 100;
    public static final String ENVVAR_DEFAULT_ARC_TO_POLY_RESOLUTION = "OIO_CCT_FILE_WRITER_ARC2POLY_RES";
    public static int DEFAULT_ARC_TO_POLY_RESOLUTION;
    public static int sArc2PolyResolution;
    int mIndent;
    int mColumn;
    int mMaxColumns;
    char[] mLine;
    PrintWriter mOut = null;
    protected HashSet<String> mShapeMsgsOutput = new HashSet();
    protected boolean mArc2PolyMsgOutput = false;

    public boolean init(File file) {
        this.mMaxColumns = 100;
        this.mLine = new char[100];
        try {
            this.mOut = new PrintWriter(file);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            ALog.logError((Throwable)fnfe, (String)"Error opening output file '%s'.", (Object[])new Object[]{file.getAbsolutePath()});
            return false;
        }
    }

    public void close() {
        this.mOut.close();
    }

    public void startElement(String str) {
        this.putString(str, Directive.Start);
    }

    public void startElementNewLine(String str) {
        this.printString();
        Arrays.fill(this.mLine, ' ');
        this.putString(str, Directive.Start);
    }

    public void closeElement() {
        this.putString(")", Directive.No_Space);
        --this.mIndent;
    }

    protected void putString(String str, Directive space) {
        int extra = 0;
        int strLen = str.length();
        if (space == Directive.Space) {
            extra = 1;
        } else if (space == Directive.Start) {
            extra = 2;
        }
        if (this.mColumn + strLen + extra >= this.mMaxColumns) {
            this.printString();
        }
        if (this.mColumn != this.mIndent && space != Directive.No_Space) {
            this.mLine[this.mColumn++] = 32;
            --extra;
        }
        if (space == Directive.Start) {
            this.mLine[this.mColumn++] = 40;
            --extra;
            ++this.mIndent;
        }
        if (this.mColumn + strLen + extra >= this.mMaxColumns) {
            this.printString();
            this.mOut.println(String.valueOf(str));
            this.resetLine();
        } else {
            for (int i = 0; i < str.length(); ++i) {
                this.mLine[this.mColumn + i] = str.charAt(i);
            }
            this.mColumn += strLen;
        }
    }

    public void flush() {
        this.printString();
    }

    private void printString() {
        if (this.mColumn != this.mIndent) {
            this.mOut.println(this.mLine);
            Arrays.fill(this.mLine, ' ');
        }
        this.resetLine();
    }

    public void putFieldName(String str) {
        this.putString(str, Directive.Space);
    }

    public void putElement(String str) {
        if (str.contains(" ") || str.contains("(") || str.contains(")")) {
            str = String.format("'%s'", str);
        }
        this.putString(str, Directive.Space);
    }

    public void putLong(long l) {
        String str = String.format("%d", l);
        this.putString(str, Directive.Space);
    }

    public void putFloat(float l) {
        String str = String.format("%f", Float.valueOf(l));
        this.putString(str, Directive.Space);
    }

    public void putDouble(double l) {
        String str = new DecimalFormat().format(l);
        this.putString(str, Directive.Space);
    }

    private void resetLine() {
        for (int i = 0; i < this.mIndent; ++i) {
            this.mLine[i] = 32;
        }
        this.mColumn = this.mIndent;
    }

    public static void testCCTWriter() {
        CCTFileWriter cctW = new CCTFileWriter();
        File file = new File("d:\\new.txt");
        cctW.init(file);
        cctW.startElement("World");
        cctW.putElement(OrbitIO.getCurDb().toString());
        cctW.startElementNewLine("Places");
        cctW.startElementNewLine("Bali");
        cctW.putElement("cool");
        cctW.closeElement();
        cctW.startElementNewLine("Belize");
        cctW.putElement("yo cool");
        cctW.closeElement();
        cctW.startElementNewLine("Toronto");
        cctW.putElement("very bad");
        cctW.closeElement();
        cctW.closeElement();
        cctW.closeElement();
        cctW.flush();
        cctW.close();
    }

    public void writeShape(AGeom geom, String layerName, Function<Long, String> unitConversion) {
        if (geom instanceof ACircle) {
            ACircle c = (ACircle)geom;
            this.startElementNewLine("circle");
            this.putElement(layerName);
            this.putElement(unitConversion.apply(c.getD()));
            this.putElement(unitConversion.apply(c.getC().getX()));
            this.putElement(unitConversion.apply(c.getC().getY()));
            this.closeElement();
        } else if (geom instanceof ALine) {
            ALine l = (ALine)geom;
            this.startElementNewLine("path");
            this.putElement(layerName);
            this.putElement(unitConversion.apply(1000000L));
            this.putElement(unitConversion.apply(l.getP0().getX()));
            this.putElement(unitConversion.apply(l.getP0().getY()));
            this.putElement(unitConversion.apply(l.getP1().getX()));
            this.putElement(unitConversion.apply(l.getP1().getY()));
            this.closeElement();
        } else if (geom instanceof ARect) {
            ARect r = (ARect)geom;
            this.startElementNewLine("rect");
            this.putElement(layerName);
            this.putElement(unitConversion.apply(r.getLL().getX()));
            this.putElement(unitConversion.apply(r.getLL().getY()));
            this.putElement(unitConversion.apply(r.getUR().getX()));
            this.putElement(unitConversion.apply(r.getUR().getY()));
            this.closeElement();
        } else if (geom instanceof APath) {
            APath path = (APath)geom;
            this.startElementNewLine("path");
            this.putElement(layerName);
            this.putElement(unitConversion.apply(path.getWidth()));
            path.getPoints().stream().forEach(pt -> {
                this.putElement((String)unitConversion.apply(pt.getX()));
                this.putElement((String)unitConversion.apply(pt.getY()));
            });
            this.closeElement();
        } else if (geom instanceof APolygon) {
            APolygon poly = (APolygon)geom;
            this.startElementNewLine("polygon");
            this.putElement(layerName);
            this.putElement(unitConversion.apply(0L));
            for (APoint2D p : poly.getPoints()) {
                this.putElement(unitConversion.apply(p.getX()));
                this.putElement(unitConversion.apply(p.getY()));
            }
            this.closeElement();
        } else if (geom instanceof AArc) {
            AArc arc = (AArc)geom;
            this.startElementNewLine("qarc");
            this.putElement(layerName);
            this.putElement(unitConversion.apply(1000000L));
            this.putElement(unitConversion.apply(arc.getP1().getX()));
            this.putElement(unitConversion.apply(arc.getP1().getY()));
            this.putElement(unitConversion.apply(arc.getP0().getX()));
            this.putElement(unitConversion.apply(arc.getP0().getY()));
            this.putElement(unitConversion.apply(arc.getCenter().getX()));
            this.putElement(unitConversion.apply(arc.getCenter().getY()));
            this.closeElement();
        } else if (geom instanceof AOutlineGeom) {
            if (!this.mArc2PolyMsgOutput) {
                ALog.logInfo((String)"Converting AOutlineGeom to polygon, arcs will be estimated with %d points.", (Object[])new Object[]{sArc2PolyResolution});
                this.mArc2PolyMsgOutput = true;
            }
            AOutlineGeom og = (AOutlineGeom)geom;
            int oldResolution = ((AOutlineGeom)geom).setArcToPolyResultion(sArc2PolyResolution);
            APolygon poly = geom.toPoly();
            this.writeShape((AGeom)poly, layerName, unitConversion);
            og.setArcToPolyResultion(oldResolution);
        } else {
            String msg = String.format("Using polygon for shapes of type: %s", geom.getClass().getName());
            if (!this.mShapeMsgsOutput.contains(msg)) {
                ALog.logInfo((String)msg);
                this.mShapeMsgsOutput.add(msg);
            }
            APolygon poly = geom.toPoly();
            this.writeShape((AGeom)poly, layerName, unitConversion);
        }
    }

    static {
        sArc2PolyResolution = DEFAULT_ARC_TO_POLY_RESOLUTION = Optional.ofNullable(System.getenv(ENVVAR_DEFAULT_ARC_TO_POLY_RESOLUTION)).map(val -> AUtil.parseInt((String)val)).orElse(32).intValue();
    }

    public static enum Directive {
        No_Space,
        Space,
        Start;

    }
}

