/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashSet;

public class CelsiusBumpFilesExport {
    private final Db mDb;
    private Unit mUnit;

    public CelsiusBumpFilesExport(Db db) {
        this.mDb = db;
    }

    public void export(String filePath) {
        if (this.mDb == null || this.mDb.closed()) {
            ALog.flogError((String)"Cannot find database.", (Object[])new Object[0]);
            return;
        }
        this.mUnit = Design.getUnit((Db)this.mDb);
        File file = new File(filePath);
        this.writeBumpFiles(file);
    }

    private void writeBumpFiles(File folder) {
        if (!folder.isDirectory()) {
            ALog.logError((String)"%s is not a folder.", (Object[])new Object[]{folder});
            return;
        }
        ContactLayer.getValid((Db)this.mDb).forEach(cl -> this.writeBumpFile(folder, (ContactLayer)cl));
    }

    private void writeBumpFile(File folder, ContactLayer cl) {
        String pathA = AFile.escapeName((String)cl.getDevicePathA().escapedString());
        String layerA = cl.getContactLayerA().getName();
        String pathB = AFile.escapeName((String)cl.getDevicePathB().escapedString());
        String layerB = cl.getContactLayerB().getName();
        File bumpFile = new File(folder, String.format("%s(%s)-%s(%s).map", pathA, layerA, pathB, layerB));
        try (PrintWriter writer = new PrintWriter(bumpFile);){
            this.writeDieBumpDefinition(writer, cl);
            ALog.flogInfo((String)"Write bump file to %s.", (Object[])new Object[]{bumpFile});
        }
        catch (FileNotFoundException fnfe) {
            ALog.logError((Throwable)fnfe, (String)"Unable to write to output file '%s'.", (Object[])new Object[]{bumpFile});
        }
    }

    private void writeDieBumpDefinition(PrintWriter writer, ContactLayer cl) {
        writer.append("DIE_BUMP_DEFINITION");
        writer.println();
        writer.format(" UNIT %s", this.mUnit.getUserName());
        writer.println();
        ARect bb = cl.getDeviceA().getTemplate().getBB();
        writer.format("DIEAREA %f %f %f %f", this.mUnit.toUser(bb.getLL().getX()), this.mUnit.toUser(bb.getLL().getY()), this.mUnit.toUser(bb.getUR().getX()), this.mUnit.toUser(bb.getUR().getY()));
        writer.println();
        this.writeBumpModel(writer, cl);
        this.writeBumpInst(writer, cl);
        writer.append("END_DIE_BUMP_DEFINITION");
    }

    private void writeBumpModel(PrintWriter writer, ContactLayer cl) {
        writer.append("BUMP_MODEL");
        writer.println();
        HashSet padTs = new HashSet();
        cl.getPinOnContactLayerA().forEach(hierPin -> {
            PinTemplate pin = (PinTemplate)hierPin.getDbObject();
            PadTemplate padT = pin.getPadTemplate();
            boolean isPower = Net.isPowerNet((Net)pin.getNet(), (DevicePath)hierPin.getPath());
            if (isPower && !padTs.contains(padT)) {
                ARect bb = padT.getBounds(cl.getContactLayerA());
                writer.format(" %s %f", padT.getName(), bb != null ? this.mUnit.toUser(Math.min(bb.width(), bb.height())) : this.mUnit.toUser(0L));
                writer.println();
                padTs.add(padT);
            }
        });
        writer.append("END_BUMP_MODEL");
        writer.println();
    }

    private void writeBumpInst(PrintWriter writer, ContactLayer cl) {
        writer.append("BUMP_INST");
        writer.println();
        cl.getPinOnContactLayerA().forEach(hierPin -> {
            Device bump = hierPin.getPath().getDevice();
            PinTemplate pin = (PinTemplate)hierPin.getDbObject();
            Net net = pin.getNet();
            PadTemplate padT = pin.getPadTemplate();
            boolean isPower = Net.isPowerNet((Net)net, (DevicePath)hierPin.getPath());
            if (bump != null && bump.getType() == DeviceTemplate.Type.BUMP && isPower) {
                writer.format("%s %s %f %f", bump.getName(), padT.getName(), this.mUnit.toUser(bump.getLocX()), this.mUnit.toUser(bump.getLocY()));
                writer.println();
            }
        });
        writer.append("END_BUMP_INST");
        writer.println();
    }
}

