/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CsvIo {
    protected static boolean verbose = false;
    protected Db mDb;
    protected URL mConfigFile;
    protected Element mXeConfigDoc;
    protected Properties mProperties = new Properties();
    protected Interpreter mInterpreter;
    protected Stack<Context> mContext = new Stack();
    protected CsvOut mWriter;
    protected CsvIn mReader;
    protected HashSet<String> mEvalErrsOutput = new HashSet();
    protected StatusDlg mStatusDlg = null;
    protected Object mStatusDlgLock = new Object();

    public static void exportCsv(Db db, String configFile, String dataFile, String ... properties) throws MalformedURLException {
        CsvIo.csvIo(true, db, configFile, dataFile, properties);
    }

    public static void importCsv(Db db, String configFile, String dataFile, String ... properties) throws MalformedURLException {
        CsvIo.csvIo(false, db, configFile, dataFile, properties);
    }

    protected static void csvIo(boolean export, Db db, String configFile, String dataFile, String ... properties) throws MalformedURLException {
        CsvIo cio = new CsvIo(db, new URL(configFile));
        if (properties != null) {
            Properties p = new Properties();
            for (int i = 0; i < properties.length; ++i) {
                String key = properties[i];
                String val = i + i < properties.length ? properties[++i] : "";
                p.setProperty(key, val);
            }
            cio.putProperties(p);
        }
        URL urlDataFile = new URL(dataFile);
        Thread worker = new Thread(() -> {
            try {
                if (export) {
                    cio.exportCsv(urlDataFile);
                } else {
                    cio.importCsv(urlDataFile);
                }
            }
            finally {
                cio.closeStatusDlg();
            }
        });
        worker.start();
        cio.showStatusDlg();
    }

    public CsvIo(Db db, URL configFile) {
        this.mDb = db;
        this.mConfigFile = configFile;
    }

    protected boolean init() {
        if (this.mXeConfigDoc != null) {
            return true;
        }
        this.mXeConfigDoc = AXDomUtil.getDocumentElement((URL)this.mConfigFile);
        if (this.mXeConfigDoc == null) {
            String msg = String.format("Invalid CsvIo configuration '%s'.", this.mConfigFile.toExternalForm());
            ALog.logError((String)msg);
            return false;
        }
        this.mInterpreter = new Interpreter();
        this.eval("import com.sigrity.orbit.*;");
        this.eval("import com.sigrity.orbit.cmd.*");
        this.eval("import com.sigrity.acl.*");
        this.eval("import com.sigrity.acl.db.*;");
        this.eval("import com.sigrity.acl.db.std.*;");
        this.eval("curObj() { return Context.getDbObj(); }");
        this.eval("parentObj() { return Context.getOwnerDbObj(); }");
        try {
            this.mInterpreter.set("CsvIo", (Object)this);
        }
        catch (EvalError ee) {
            ALog.logError((Throwable)ee, (String)"Error initializing CsvIo.", (Object[])new Object[0]);
            throw new RuntimeException(ee);
        }
        Object init = "";
        for (Element xe : AXDomUtil.getChildElems((Node)this.mXeConfigDoc, (String)"Init")) {
            init = (String)init + xe.getTextContent();
        }
        if (((String)init).length() > 0) {
            this.eval((String)init);
        }
        return true;
    }

    public void putProperties(Properties properties) {
        this.mProperties.putAll((Map<?, ?>)properties);
    }

    public String get(String propKey) {
        return this.mProperties.getProperty(propKey);
    }

    public Db getDb() {
        return this.mDb;
    }

    public boolean exportCsv(URL dataFile) {
        this.init();
        try {
            if (dataFile.getProtocol().equalsIgnoreCase("file")) {
                String path = dataFile.getPath();
                FileWriter fw = new FileWriter(path);
                this.mWriter = new CsvOut(fw);
            } else {
                URLConnection connection = dataFile.openConnection();
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                this.mWriter = new CsvOut(out);
            }
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Error opening output file '%s'.", (Object[])new Object[]{dataFile.toExternalForm()});
            return false;
        }
        DbContext dbContext = new DbContext(this.mXeConfigDoc);
        dbContext.write();
        try {
            this.mWriter.close();
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Error closing output file '%s', data may be incomplete.", (Object[])new Object[]{dataFile.toExternalForm()});
            return false;
        }
        this.mWriter = null;
        return true;
    }

    public boolean importCsv(URL dataFile) {
        this.init();
        try {
            URLConnection connection = dataFile.openConnection();
            InputStreamReader r = new InputStreamReader(connection.getInputStream());
            this.mReader = new CsvIn(r);
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Error opening output file '%s'.", (Object[])new Object[]{dataFile.toExternalForm()});
            return false;
        }
        DbContext dbContext = new DbContext(this.mXeConfigDoc);
        dbContext.read();
        try {
            this.mReader.close();
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Error closing input file '%s', data may be incomplete.", (Object[])new Object[]{dataFile.toExternalForm()});
            return false;
        }
        return true;
    }

    protected Context setContext(Context c) {
        Context res = null;
        try {
            Object o = this.mInterpreter.get("Context");
            if (o instanceof Context) {
                res = (Context)o;
            }
            this.mInterpreter.set("Context", (Object)c);
        }
        catch (EvalError e) {
            ALog.logError((Throwable)e, (String)"Error setting CsvIo context.", (Object[])new Object[0]);
        }
        return res;
    }

    protected Context pushContext(Context c) {
        this.mContext.push(c);
        this.setContext(c);
        return c;
    }

    protected Context popContext() {
        Context res = this.mContext.pop();
        this.setContext(this.mContext.isEmpty() ? null : this.mContext.peek());
        return res;
    }

    protected Context getContext() {
        if (this.mContext.isEmpty()) {
            return null;
        }
        return this.mContext.peek();
    }

    protected Object eval(String s) {
        try {
            return this.mInterpreter.eval(s);
        }
        catch (EvalError e) {
            ALog.logWarn((Throwable)e, (String)"Evaluation error while processing CsvIo.", (Object[])new Object[0]);
            return null;
        }
    }

    protected Context getContextForElement(Context owner, Element xe) {
        String tagName = xe.getTagName();
        if (tagName.equalsIgnoreCase("Path")) {
            return new PathContext(owner, xe);
        }
        if (tagName.equalsIgnoreCase("Relation")) {
            return new RelationContext(owner, xe);
        }
        return null;
    }

    protected boolean readChildElements(Context owner, Element xe) {
        boolean result = false;
        for (Element child : AXDomUtil.getChildElems((Node)xe)) {
            Context context = this.getContextForElement(owner, child);
            if (context == null) continue;
            result = true;
            this.pushContext(context);
            context.read();
            this.popContext();
        }
        return result;
    }

    public static boolean isMissingFieldEvalError(EvalError e) {
        return e.getCause() != null && e.getCause().getClass().getSimpleName().equals("ReflectError") && e.getCause().getMessage().startsWith("No such field:");
    }

    protected void showStatusDlg() {
        StatusDlg d = new StatusDlg(OrbitIO.getMainWindow());
        d.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(String text, Object ... args) {
        Object object = this.mStatusDlgLock;
        synchronized (object) {
            if (this.mStatusDlg == null) {
                return;
            }
        }
        if (args.length > 0) {
            text = String.format(text, args);
        }
        this.mStatusDlg.setStatus(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStatusDlg() {
        Object object = this.mStatusDlgLock;
        synchronized (object) {
            if (this.mStatusDlg != null) {
                this.mStatusDlg.dispose();
                this.mStatusDlg = null;
            }
        }
    }

    public static class CsvIn {
        protected CsvStatus mStatus = new CsvStatus();
        protected CSVReader mCsvReader;
        protected String[] mCurLine = null;
        protected long mCurLineNum = 0L;

        public CsvIn(Reader r) {
            this.mCsvReader = new CSVReader(r);
        }

        public String[] readLine() {
            try {
                this.mStatus.setStatus("Reading line %d", this.mCurLineNum + 1L);
                this.mCurLine = this.mCsvReader.readNext();
                if (this.mCurLine != null) {
                    ++this.mCurLineNum;
                }
                return this.mCurLine;
            }
            catch (IOException ioe) {
                ALog.logError((Throwable)ioe, (String)"Error reading CSV input file.", (Object[])new Object[0]);
                return null;
            }
        }

        public void close() throws IOException {
            this.mCsvReader.close();
        }

        public long getCurLineNum() {
            return this.mCurLineNum;
        }

        public CsvStatus status() {
            return this.mStatus;
        }
    }

    public static class CsvOut {
        protected CsvStatus mStatus = new CsvStatus();
        protected CSVWriter mCsvWriter;
        protected long mCurLineNum = 0L;

        public CsvOut(Writer w) {
            this.mCsvWriter = new CSVWriter(w);
        }

        public void write(String[] line) {
            this.mStatus.setStatus("Writing line %d", this.mCurLineNum + 1L);
            this.mCsvWriter.writeNext(line);
            ++this.mCurLineNum;
        }

        public void write(List<String> line) {
            this.write(line.toArray(new String[0]));
        }

        public void writeLine(String ... args) {
            this.write(args);
        }

        public void close() throws IOException {
            this.mCsvWriter.close();
        }

        public long getCurLineNum() {
            return this.mCurLineNum;
        }

        public CsvStatus status() {
            return this.mStatus;
        }
    }

    protected static class CsvStatus {
        protected LinkedHashSet<Listener> mListeners = new LinkedHashSet();
        protected String mCurStatus = null;

        protected CsvStatus() {
        }

        public boolean addListener(Listener l) {
            return this.mListeners.add(l);
        }

        public boolean removeListener(Listener l) {
            return this.mListeners.remove(l);
        }

        public void setStatus(String fmt, Object ... args) {
            String msg = String.format(fmt, args);
            for (Listener l : this.mListeners) {
                l.csvStatusUpdate(msg);
            }
            this.mCurStatus = msg;
        }

        public String getStatus() {
            return this.mCurStatus;
        }

        public static interface Listener {
            public void csvStatusUpdate(String var1);
        }
    }

    protected class StatusDlg
    extends ADialog {
        protected JLabel mProgress;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatusDlg(Component owner) {
            super(owner);
            this.setModal(true);
            this.setTitle("Csv I/O Status");
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.setContentPane(new JPanel());
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            this.mProgress = new JLabel();
            this.mProgress.setText("Initializing CSV I/O...");
            this.mProgress.setHorizontalTextPosition(0);
            l.add((Component)this.mProgress, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.pack();
            UIUtil.center((Component)((Object)this));
            Object object = CsvIo.this.mStatusDlgLock;
            synchronized (object) {
                CsvIo.this.mStatusDlg = this;
            }
        }

        public void setStatus(String text) {
            this.mProgress.setText(text);
        }
    }

    public class RelationContext
    extends DbObjectContext {
        protected DbObject mDboOwner;
        protected DbRelationDef mRelation;
        protected DbObject mCurDbObject;

        public RelationContext(Context owner, Element xe) {
            super(owner, xe);
            this.mCurDbObject = null;
            this.mElement = xe;
            String name = xe.getAttribute("name");
            if (name.length() == 0) {
                ALog.logError((String)"Relation selector specified with no name, it is being ignored.");
                return;
            }
            DbRelationDef rel = CsvIo.this.mDb.getRelation(name);
            if (rel == null) {
                ALog.logError((String)"Relation selector specifies a nonexistant relation '%s', it is being ignored.");
                return;
            }
            DbObject dboOwner = this.getOwnerDbObj();
            if (dboOwner == null) {
                assert (false);
                ALog.logError((String)"Relation context created without a DbObject owner context.");
                return;
            }
            DbClass dbcOwner = dboOwner.getDbClass();
            if (rel.getDbClassL() != dbcOwner && rel.getDbClassR() != dbcOwner) {
                ALog.logError((String)"Relation context created for relation '%s', but the class '%s' of the DbObject owner '%s' context is not involved in the relation.", (Object[])new Object[]{rel.getName(), dbcOwner, dboOwner.getKeyStr()});
                dboOwner = null;
                return;
            }
            this.mDboOwner = dboOwner;
            this.mRelation = rel;
        }

        @Override
        protected boolean processCsvInputData(ColumnDef col) {
            if (this.mCurDbObject == null) {
                String stmtLookup = this.mElement.getAttribute("importLookup");
                if (stmtLookup.length() == 0) {
                    ALog.logError((String)"Relation element '%s' does not contain an 'importLookup' attribute, unable to lookup related object.", (Object[])new Object[]{col.mName});
                    return false;
                }
                Object o = CsvIo.this.eval(stmtLookup);
                if (!(o instanceof DbObject) && stmtLookup.length() == 0) {
                    ALog.logError((String)"Relation element InputLookup statment '%s' did not return a DbObject, unable to process relation.", (Object[])new Object[]{stmtLookup});
                    return false;
                }
                this.mCurDbObject = (DbObject)o;
                return true;
            }
            return super.processCsvInputData(col);
        }

        @Override
        protected void inputLineComplete() {
            this.mCurDbObject = null;
        }

        @Override
        public boolean write() {
            if (this.mDboOwner == null) {
                return false;
            }
            Iterator iterator = this.mRelation.getRelated(this.mDboOwner).iterator();
            while (iterator.hasNext()) {
                DbObject dbo;
                this.mCurDbObject = dbo = (DbObject)iterator.next();
                super.write();
            }
            this.mCurDbObject = null;
            return true;
        }

        @Override
        public DbObject getDbObj() {
            return this.mCurDbObject;
        }
    }

    public class PathContext
    extends DbObjectContext {
        protected DevicePath mPath;
        protected PathOutputInclude mInclude;
        protected DevicePath mCurPath;

        public PathContext(Context owner, Element xe) {
            PathOutputInclude poi;
            super(owner, xe);
            String path = "" + CsvIo.this.eval(xe.getAttribute("path"));
            this.mPath = DevicePath.fromString((Db)CsvIo.this.mDb, (String)path);
            String include = xe.getAttribute("outputInclude");
            this.mInclude = poi = PathOutputInclude.fromString(include);
        }

        @Override
        protected boolean processCsvInputData(ColumnDef col) {
            int pathCol = 1;
            String strPathCol = this.mElement.getAttribute("pathCol");
            if (strPathCol.length() > 0) {
                pathCol = Integer.parseInt(strPathCol);
            }
            ColumnDef colPath = (ColumnDef)this.mColumns.get(pathCol - 1);
            if (this.mCurPath == null) {
                this.mCurPath = DevicePath.fromString((Db)CsvIo.this.mDb, (String)colPath.mValue);
                if (this.mCurPath == null) {
                    ALog.logWarn((String)"Unable to retrieve Device specified by path '%s'.", (Object[])new Object[]{colPath.mValue});
                    return false;
                }
            }
            if (col == colPath) {
                return true;
            }
            return super.processCsvInputData(col);
        }

        @Override
        protected void inputLineComplete() {
            this.mCurPath = null;
        }

        @Override
        public boolean write() {
            if (this.mPath == null) {
                return false;
            }
            this.write(this.mPath, this.mInclude);
            return true;
        }

        protected void write(DevicePath path, PathOutputInclude poi) {
            DevicePath oldCurPath = this.mCurPath;
            this.mCurPath = path;
            switch (this.mInclude) {
                case ONE: {
                    super.write();
                    break;
                }
                case CHILDREN: {
                    for (DevicePath child : path.getChildren()) {
                        this.write(child, PathOutputInclude.ONE);
                    }
                    break;
                }
                case DESCENDANTS: {
                    if (path.getChildren().hasNext()) {
                        for (DevicePath subPath : path.getDescendants(false)) {
                            this.write(subPath, PathOutputInclude.DESCENDANTS);
                        }
                        break;
                    }
                    if (path.equals((Object)this.mPath)) break;
                    super.write();
                }
            }
            this.mCurPath = oldCurPath;
        }

        public String getPath() {
            if (this.mCurPath != null) {
                return this.mCurPath.getString();
            }
            if (this.mPath != null) {
                return this.mPath.getString();
            }
            return "";
        }

        @Override
        public DbObject getDbObj() {
            if (this.mCurPath != null) {
                return this.mCurPath.getLast();
            }
            if (this.mPath != null) {
                return this.mPath.getLast();
            }
            return null;
        }
    }

    public class DbContext
    extends DbObjectContext {
        public DbContext(Element xe) {
            super(null, xe);
        }

        @Override
        public DbObject getDbObj() {
            return Design.getDesign((Db)CsvIo.this.mDb);
        }
    }

    public abstract class DbObjectContext
    extends Context {
        public DbObjectContext(Context owner, Element e) {
            super(owner, e);
        }

        public abstract DbObject getDbObj();
    }

    public abstract class Context {
        protected Context mOwner = null;
        protected Element mElement = null;
        protected Values mColumns = new Values();
        protected boolean filterMsg1 = true;
        protected boolean filterMsg2 = true;
        protected boolean filterMsg3 = true;

        public Context(Context owner, Element e) {
            this.mOwner = owner;
            this.mElement = e;
        }

        public boolean write() {
            int startSize = this.mColumns.size();
            for (Object xeCol : AXDomUtil.getChildElems((Node)this.mElement, (String)"Col")) {
                String name = xeCol.getAttribute("name");
                if (name.length() == 0) {
                    ALog.logWarn((String)"Invalid column definition, no 'name' attribute specified.");
                    continue;
                }
                String val = this.getOutputData(name, xeCol.getAttribute("val"));
                this.mColumns.add(name, val);
            }
            int childContextCount = 0;
            for (Element child : AXDomUtil.getChildElems((Node)this.mElement)) {
                Context context = CsvIo.this.getContextForElement(this, child);
                if (context == null) continue;
                ++childContextCount;
                CsvIo.this.pushContext(context);
                context.write();
                CsvIo.this.popContext();
            }
            if (childContextCount == 0 && this.filterOutputIncludes()) {
                if (CsvIo.this.mWriter.getCurLineNum() == 0L) {
                    LinkedList<String> cols = new LinkedList<String>();
                    for (Context c : CsvIo.this.mContext) {
                        for (ColumnDef v : c.mColumns) {
                            cols.add(v.mName);
                        }
                    }
                    CsvIo.this.mWriter.write(cols);
                }
                LinkedList<String> vals = new LinkedList<String>();
                for (Context c : CsvIo.this.mContext) {
                    for (ColumnDef v : c.mColumns) {
                        vals.add(v.mGetStmt);
                    }
                }
                CsvIo.this.mWriter.write(vals);
            }
            this.mColumns.setSize(startSize);
            return true;
        }

        public boolean read() {
            int startSize = this.mColumns.size();
            for (Object xeCol : AXDomUtil.getChildElems((Node)this.mElement, (String)"Col")) {
                String name = xeCol.getAttribute("name");
                if (name.length() == 0) {
                    ALog.logWarn((String)"Invalid column definition, no 'name' attribute specified.");
                    continue;
                }
                String val = xeCol.getAttribute("val");
                this.mColumns.add(name, val);
            }
            int childContextCount = 0;
            for (Element child : AXDomUtil.getChildElems((Node)this.mElement)) {
                Context context = CsvIo.this.getContextForElement(this, child);
                if (context == null) continue;
                ++childContextCount;
                CsvIo.this.pushContext(context);
                context.read();
                CsvIo.this.popContext();
            }
            if (childContextCount == 0) {
                if (CsvIo.this.mReader.getCurLineNum() == 0L) {
                    String[] colHeader = CsvIo.this.mReader.readLine();
                    LinkedList<String> defCols = new LinkedList<String>();
                    for (Context c : CsvIo.this.mContext) {
                        for (ColumnDef v : c.mColumns) {
                            defCols.add(v.mName);
                        }
                    }
                    Iterator defColItr = defCols.iterator();
                    for (String colName : colHeader) {
                        if (!defColItr.hasNext()) {
                            ALog.logError((String)"Fewer defined columns than columns in CSV input file at input file column '%s'.", (Object[])new Object[]{colName});
                            this.logColumns(defCols.toArray(new String[0]), colHeader);
                            return false;
                        }
                        String defCol = (String)defColItr.next();
                        if (colName.equalsIgnoreCase(defCol)) continue;
                        ALog.logError((String)"Defined column '%s' does not match CSV input file column '%s'.", (Object[])new Object[]{defCol, colName});
                        this.logColumns(defCols.toArray(new String[0]), colHeader);
                        return false;
                    }
                }
                String[] line = CsvIo.this.mReader.readLine();
                while (line != null) {
                    int curCol = 0;
                    boolean processDataOk = true;
                    for (Context c : CsvIo.this.mContext) {
                        for (ColumnDef colDef : c.mColumns) {
                            if (curCol >= line.length) {
                                colDef.mValue = null;
                                continue;
                            }
                            colDef.mValue = line[curCol++];
                        }
                    }
                    for (Context c : CsvIo.this.mContext) {
                        Context oldContext = CsvIo.this.setContext(c);
                        for (ColumnDef colDef : c.mColumns) {
                            boolean ok;
                            if (colDef.mValue == null || (ok = c.processCsvInputData(colDef))) continue;
                            processDataOk = false;
                            break;
                        }
                        CsvIo.this.setContext(oldContext);
                        if (processDataOk) continue;
                        break;
                    }
                    for (Context c : CsvIo.this.mContext) {
                        c.inputLineComplete();
                    }
                    if (processDataOk && line.length > curCol) {
                        ALog.logWarn((String)"Line %d of the input CSV file contains more than the defined number of columns, extra values are being ignored.", (Object[])new Object[]{CsvIo.this.mReader.getCurLineNum()});
                    }
                    line = CsvIo.this.mReader.readLine();
                }
            }
            this.mColumns.setSize(startSize);
            return true;
        }

        protected boolean processCsvInputData(ColumnDef col) {
            String curVal = this.getOutputData(col.mName, col.mGetStmt);
            if (col.mValue.equals(curVal)) {
                return true;
            }
            int lastDot = col.mGetStmt.lastIndexOf(46);
            if (lastDot >= 0) {
                String fieldName = col.mGetStmt.substring(lastDot + 1);
                String dbo = col.mGetStmt.substring(0, lastDot);
                if (verbose) {
                    String obj = "" + CsvIo.this.eval(dbo);
                    ALog.logInfo((String)"Setting object '%s' field '%s' to value '%s'.", (Object[])new Object[]{obj, fieldName, col.mValue});
                }
                try {
                    String setStmt = String.format("%s.setValue(\"%s\", \"%s\")", dbo, fieldName, col.mValue);
                    CsvIo.this.mInterpreter.eval(setStmt);
                    return true;
                }
                catch (EvalError evalError) {
                    // empty catch block
                }
            }
            String stmt = String.format("%s = \"%s\"", col.mGetStmt, col.mValue);
            try {
                CsvIo.this.mInterpreter.eval(stmt);
            }
            catch (EvalError ee) {
                ALog.logError((Throwable)ee, (String)"Unable to set value for column '%s' to '%s' by manipulating 'val' statement '%s'.", (Object[])new Object[]{col.mName, col.mGetStmt, col.mValue});
                return false;
            }
            return true;
        }

        protected void inputLineComplete() {
        }

        protected String getOutputData(String name, String stmt) {
            try {
                return "" + CsvIo.this.mInterpreter.eval(stmt);
            }
            catch (EvalError e) {
                if (!CsvIo.isMissingFieldEvalError(e) && !CsvIo.this.mEvalErrsOutput.contains(e.getMessage())) {
                    CsvIo.this.mEvalErrsOutput.add(e.getMessage());
                    ALog.logWarn((Throwable)e, (String)"Evaluation error while processing CsvIo. Statement: '%s'", (Object[])new Object[]{stmt});
                }
                return "";
            }
        }

        protected void logColumns(String[] xml, String[] csv) {
            ALog.logInfo((String)"Defined columns: %s", (Object[])new Object[]{Arrays.toString(xml)});
            ALog.logInfo((String)"CSV input columns: %s", (Object[])new Object[]{Arrays.toString(csv)});
        }

        public DbObject getOwnerDbObj() {
            if (this.mOwner instanceof DbObjectContext) {
                return ((DbObjectContext)this.mOwner).getDbObj();
            }
            return null;
        }

        public boolean filterOutputIncludes() {
            for (Element xeCol : AXDomUtil.getChildElems((Node)this.mElement, (String)"OutputFilter")) {
                String test = xeCol.getAttribute("test");
                if (test.length() == 0) {
                    if (!this.filterMsg1) continue;
                    ALog.logWarn((String)"Invalid OutputFilter definition, no 'test' attribute specified. The filter is being ignored.");
                    this.filterMsg1 = false;
                    continue;
                }
                try {
                    Object result = CsvIo.this.mInterpreter.eval(test);
                    if (result instanceof Boolean) {
                        if (((Boolean)result).booleanValue()) continue;
                        return false;
                    }
                    if (!this.filterMsg2) continue;
                    ALog.logWarn((String)"Invalid OutputFilter definition, test '%s' did not return a boolean result. The filter is being ignored.", (Object[])new Object[]{test});
                    this.filterMsg2 = false;
                }
                catch (EvalError ee) {
                    if (!this.filterMsg3) continue;
                    ALog.logWarn((Throwable)ee, (String)"Evaluation error in OutputFilter test '%s'. The filter is being ignored.", (Object[])new Object[]{test});
                    this.filterMsg3 = false;
                }
            }
            return true;
        }

        public String getColVal(int col) {
            return ((ColumnDef)this.mColumns.get((int)(col - 1))).mValue;
        }

        public Context getOwner() {
            return this.mOwner;
        }

        public Element getElement() {
            return this.mElement;
        }
    }

    public class Values
    extends LinkedList<ColumnDef> {
        public void add(String name, String getStmt) {
            this.add(new ColumnDef(name, getStmt));
        }

        public void setSize(int size) {
            while (this.size() < size) {
                this.add(null, null);
            }
            while (this.size() > size) {
                this.remove(this.size() - 1);
            }
        }
    }

    public class ColumnDef {
        String mName;
        String mGetStmt;
        String mValue;

        public ColumnDef(String a, String b, String c) {
            this.mName = a;
            this.mGetStmt = b;
            this.mValue = c;
        }

        public ColumnDef(String first, String second) {
            this(first, second, null);
        }

        public String toString() {
            return String.format("[%s, '%s', %s]", this.mName, this.mGetStmt, this.mValue);
        }
    }

    public static enum PathOutputInclude {
        ONE,
        CHILDREN,
        DESCENDANTS;


        public static PathOutputInclude fromString(String s) {
            try {
                return Enum.valueOf(PathOutputInclude.class, s.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

