/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import bsh.ABshUtil;
import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.Parser;
import bsh.SimpleNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.sigrity.acl.ACsvReader;
import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.LEFDEFOrient;
import com.sigrity.acl.parsers.LEFDEFSyntax;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.export.ImportExportUtils;
import com.sigrity.orbit.factory.ViaFactory;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.javatuples.Pair;

public class DEFOut {
    private static final int STRINGBUILDER_INITIAL_CAPCITY = 4096;
    public static final String DBF_DEFOUTNAME = "DEFOutName";
    static final int[] LEFDEF_VALID_DBUPERMICRON = new int[]{100, 200, 1000, 2000, 10000, 20000};
    protected static final boolean SORT_OUTPUT = true;
    protected static final boolean DEBUG = true;
    protected boolean mForTesting = false;
    protected BufferedWriter mOut;
    protected Db mDb;
    protected DevicePath mDiePath;
    protected Substrate mSubstrate;
    protected boolean mInclFromSynTemplate;
    protected boolean mWriteNets;
    protected boolean mWritePinSection;
    protected boolean mOverwriteDefOutNames = true;
    private boolean mWriteWires = true;
    private boolean mWriteVias = true;
    protected boolean mWriteLEFDEFIgnoreOnWrite = false;
    private double mDistanceScale;
    private JustTheseWiresFilter justTheseWiresFilter = null;
    private JustTheseDevicesFilter justTheseDevicesFilter = null;
    private LinkedHashSet<DevicePath> mFilteredDevices;
    private Map<DevicePath, List<PinLabel>> mBumpToPinLabels;
    private Map<Layer, List<Layer>> mFullViaLayersByOneLayer;
    private Map<Pair<Layer, Layer>, List<Layer>> mFullViaLayersByTwoLayers;
    private Set<DeviceTemplate> mIncludedTemplates;
    private Map<PinTemplate, Pair<Layer, Layer>> mVia2Layers;
    private List<Term> mTerms;
    private Set<String> mLEFSource;
    private Map<DeviceTemplate, Integer> mTemplateTermCount;
    private static CustomDefWS sCustomWS = null;
    private static final String SEP = ",";

    public void setOverwriteDefOutNames(boolean overwrite) {
        this.mOverwriteDefOutNames = overwrite;
    }

    public void setJustTheseWiresFilter(JustTheseWiresFilter justTheseWiresFilter) {
        this.justTheseWiresFilter = justTheseWiresFilter;
    }

    public void setJustTheseDevicesFilter(JustTheseDevicesFilter justTheseDevicesFilter) {
        this.justTheseDevicesFilter = justTheseDevicesFilter;
    }

    public void setWritePinSection(boolean writePinSection) {
        this.mWritePinSection = writePinSection;
    }

    public void setWriteWires(boolean v) {
        this.mWriteWires = v;
    }

    public void setWriteVias(boolean v) {
        this.mWriteVias = v;
    }

    private Writer newGZIPOutput(String filename) {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(filename)), StandardCharsets.US_ASCII);
            return osw;
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
            return null;
        }
    }

    private Writer newASCIIOutput(String filename) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(filename);
            return fw;
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
            return null;
        }
    }

    private BufferedWriter newOutputDEF(String filename) {
        Writer writer = filename.endsWith(".gz") ? this.newGZIPOutput(filename) : this.newASCIIOutput(filename);
        if (writer == null) {
            return null;
        }
        BufferedWriter bw = null;
        bw = new BufferedWriter(writer);
        return bw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDEF(String filename) {
        try (BufferedWriter writer = this.newOutputDEF(filename);){
            this.mOut = writer;
            this.preDEFOut();
            this.collectImportedLEF(this.mSubstrate);
            this.writePrelude();
            if (this.mWritePinSection) {
                List<Term> pinsWithDifferentNetName = this.writePins();
                this.writePinProperties(pinsWithDifferentNetName);
            }
            this.writeComponents();
            this.writeBlockages();
            if (this.mWriteNets) {
                this.writeReferencedViaDefs();
                this.writeNets();
            }
            this.mOut.write("END DESIGN \n");
        }
        catch (IOException e) {
            ALog.flogError((Throwable)e, (String)"Problem writing to '%s'", (Object[])new Object[]{filename});
        }
        finally {
            this.postDEFOut();
        }
    }

    private DbHistory.DbTransaction createTmpTransaction() {
        double scale;
        String transName = "Unscale Substrate for DEF Export";
        DbHistory.DbTransaction trans = null;
        if (this.mSubstrate != null && !Double.isNaN(scale = this.mSubstrate.getScale()) && scale != 1.0) {
            trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Unscale Substrate for DEF Export");
            this.mSubstrate.scaleDependents(1.0 / scale);
            ALog.flogDebug((String)"Scale substrate %f temporarily", (Object[])new Object[]{1.0 / scale});
        }
        return trans;
    }

    public void write(DevicePath dp, boolean includeSynthesized, boolean writeNets, String fileName, boolean forTesting) {
        this.mInclFromSynTemplate = includeSynthesized;
        this.mWriteNets = writeNets;
        this.mDb = dp.getDb();
        this.mDiePath = dp;
        this.mForTesting = forTesting;
        try {
            this.mSubstrate = dp.pathToSubstrate().getSubstrate();
        }
        catch (Exception e) {
            ALog.flogError((String)"Failed to DEF out, as there is no substrate on device path '%s'.", (Object[])new Object[]{dp});
            return;
        }
        try (DbHistory.DbTransaction trans = this.createTmpTransaction();){
            long timeSpent = System.nanoTime();
            this.writeDEF(fileName);
            timeSpent = System.nanoTime() - timeSpent;
            ALog.logInfo((String)"Done exporting DEF, used %.3f seconds.", (Object[])new Object[]{(double)timeSpent / 1.0E9});
            if (trans != null) {
                trans.cancel();
            }
        }
    }

    private void preDEFOut() {
        this.mFilteredDevices = this.getFilteredDevices();
        this.mBumpToPinLabels = new HashMap<DevicePath, List<PinLabel>>();
        this.mFullViaLayersByOneLayer = new HashMap<Layer, List<Layer>>();
        this.mFullViaLayersByTwoLayers = new HashMap<Pair<Layer, Layer>, List<Layer>>();
        this.mIncludedTemplates = null;
        this.mVia2Layers = new HashMap<PinTemplate, Pair<Layer, Layer>>();
        this.mTerms = null;
        this.mLEFSource = new LinkedHashSet<String>();
        this.indexFullViaLayers(this.mSubstrate);
        this.buildBumpToPinsMap(this.mFilteredDevices);
        this.mTemplateTermCount = new HashMap<DeviceTemplate, Integer>();
    }

    private void postDEFOut() {
        this.mFilteredDevices = null;
        this.mBumpToPinLabels = null;
        this.mFullViaLayersByOneLayer = null;
        this.mFullViaLayersByTwoLayers = null;
        this.mIncludedTemplates = null;
        this.mVia2Layers = null;
        this.mTerms = null;
        this.mTemplateTermCount = null;
    }

    private Set<DeviceTemplate> getIncludedTemplates() {
        if (this.mIncludedTemplates == null) {
            this.mIncludedTemplates = this.mFilteredDevices.stream().map(DevicePath::getDeviceTemplate).collect(Collectors.toSet());
            this.mIncludedTemplates.add(this.mDiePath.getDeviceTemplate());
        }
        return this.mIncludedTemplates;
    }

    protected long scale(long l) {
        return DEFOut.scale(this.mDistanceScale, l);
    }

    protected static long scale(double factor, long l) {
        return Math.round((double)l * factor);
    }

    protected void writePrelude() throws IOException {
        ALog.flogDebug((String)"writePrelude begin...", (Object[])new Object[0]);
        ARect bb = this.mDiePath.getDeviceTemplate().getBB();
        Date now = new Date();
        int daPerMicron = ImportExportUtils.getBestDbuPerMicron(this.mDiePath.getDeviceTemplate(), LEFDEF_VALID_DBUPERMICRON);
        this.mDistanceScale = (double)daPerMicron / (double)Design.getInternalPerMicron((Db)this.mDb);
        if (!this.mForTesting) {
            this.mOut.write(String.format("#\n# Written by OrbitIO (%s) on %s (build %s)\n#\n", System.getProperty("user.name"), now.toString(), ABuildInfo.getVersion()));
        }
        this.mOut.write(String.format("VERSION 5.8 ;\nDIVIDERCHAR \"/\" ;\nBUSBITCHARS \"[]\" ;\nDESIGN " + this.mDiePath.getLast().getName() + " ;\nUNITS DISTANCE MICRONS %d ;\n", daPerMicron));
        this.writePropertyDefinitions();
        APoint2D ll = bb.getLL();
        APoint2D ur = bb.getUR();
        long llx = ll.getX();
        long lly = ll.getY();
        long urx = ur.getX();
        long ury = ur.getY();
        this.mOut.write(String.format("DIEAREA ( %d %d ) ( %d %d ) ;\n", this.scale(llx), this.scale(lly), this.scale(urx), this.scale(ury)));
    }

    protected void writePropertyDefinitions() throws IOException {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("\tSPECIALNET BUMP_ASSIGNMENT STRING ;\n");
        sb.append("\tCOMPONENT BUMP_TO_PIN STRING ;\n");
        sb.append("\tCOMPONENTPIN ORBIT_NET STRING ;\n");
        if (sb.length() != 0) {
            this.mOut.write("PROPERTYDEFINITIONS\n");
            this.mOut.write(sb.toString());
            this.mOut.write("END PROPERTYDEFINITIONS\n");
        }
    }

    protected void writeReferencedViaDefs() throws IOException {
        ALog.flogDebug((String)"writeReferencedViaDefs", (Object[])new Object[0]);
        Set vias = this.getIncludedTemplates().stream().flatMap(dt -> dt.getPins().stream()).filter(pt -> pt.getType().equals((Object)PinTemplate.Type.VIA) && pt.getPadTemplate() != null).map(PinTemplate::getPadTemplate).collect(Collectors.toSet());
        if (!vias.isEmpty()) {
            ArrayList sortedVias = AUtil.arrayList(vias);
            Collections.sort(sortedVias, PadTemplate.TopLayerSorter);
            this.mOut.write("VIAS " + sortedVias.size() + " ;\n");
            StringBuilder sb = new StringBuilder(4096);
            for (PadTemplate via : sortedVias) {
                AUtil.reuse((StringBuilder)sb);
                this.appendToSBThisVia(sb, via);
                this.mOut.write(sb.toString());
            }
            this.mOut.write("END VIAS \n");
        }
    }

    private void appendToSBThisVia(StringBuilder sb, PadTemplate pt) {
        Object viaRuleName = pt.getValue("VIARULE");
        if (viaRuleName == null) {
            this.appendToSBThisViaFixed(sb, pt);
        } else {
            this.appendToSBThisViaGenerated(sb, pt);
        }
    }

    private void appendToSBThisViaGenerated(StringBuilder sb, PadTemplate pt) {
        String pattern;
        List offset;
        List origin;
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"- ", pt.getName(), "\n"});
        sb.append(" + VIARULE ");
        sb.append(pt.getValue("VIARULE"));
        sb.append("\n");
        sb.append(" + CUTSIZE ");
        List cutSize = (List)pt.getValue("CUTSIZE");
        this.appendToSBList(sb, cutSize);
        sb.append("\n");
        List layers = (List)pt.getValue("LAYERS");
        sb.append(" + LAYERS ");
        this.appendToSBList(sb, layers);
        sb.append("\n");
        sb.append(" + CUTSPACING ");
        List cutSpacing = (List)pt.getValue("CUTSPACING");
        this.appendToSBList(sb, cutSpacing);
        sb.append("\n");
        sb.append(" + ENCLOSURE ");
        List enc = (List)pt.getValue("ENCLOSURE");
        this.appendToSBList(sb, enc);
        sb.append("\n");
        List rowCol = (List)pt.getValue("ROWCOL");
        if (rowCol != null) {
            sb.append(" + ROWCOL ");
            this.appendToSBList(sb, rowCol);
            sb.append("\n");
        }
        if ((origin = (List)pt.getValue("ORIGIN")) != null) {
            sb.append(" + ORIGIN ");
            this.appendToSBList(sb, origin);
            sb.append("\n");
        }
        if ((offset = (List)pt.getValue("OFFSET")) != null) {
            sb.append(" + OFFSET ");
            this.appendToSBList(sb, offset);
            sb.append("\n");
        }
        if ((pattern = (String)pt.getValue("PATTERN")) != null && pattern.isEmpty()) {
            sb.append(" + PATTERN ");
            sb.append(pattern);
            sb.append("\n");
        }
        sb.append(" ;\n");
    }

    private void appendToSBList(StringBuilder sb, List<?> list) {
        boolean first = true;
        for (Object obj : list) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(obj);
            first = false;
        }
    }

    private void indexFullViaLayers(Substrate s) {
        ArrayList orderedLayers = new ArrayList();
        s.getLayers(Layer.TopFirstSort).forEachRemaining(orderedLayers::add);
        for (int i = 1; i < orderedLayers.size() - 1; ++i) {
            Layer layer = (Layer)orderedLayers.get(i);
            if (layer.getType() != Layer.LayerType.Cut) continue;
            List<Layer> viaLayers = Arrays.asList((Layer)orderedLayers.get(i - 1), layer, (Layer)orderedLayers.get(i + 1));
            this.mFullViaLayersByOneLayer.put(layer, viaLayers);
            this.mFullViaLayersByTwoLayers.put((Pair<Layer, Layer>)new Pair((Object)((Layer)orderedLayers.get(i - 1)), (Object)layer), viaLayers);
            this.mFullViaLayersByTwoLayers.put((Pair<Layer, Layer>)new Pair((Object)layer, (Object)((Layer)orderedLayers.get(i + 1))), viaLayers);
            this.mFullViaLayersByTwoLayers.put((Pair<Layer, Layer>)new Pair((Object)((Layer)orderedLayers.get(i - 1)), (Object)((Layer)orderedLayers.get(i + 1))), viaLayers);
        }
    }

    private List<Pair<Layer, AGeom>> completeViaDef(PadTemplate pt) {
        List layers = pt.getLayers().stream().sorted(Layer.TopFirstSort).collect(Collectors.toList());
        List<Object> viaLayers = Collections.emptyList();
        switch (layers.size()) {
            case 0: {
                ALog.flogWarn((String)"Can not convert padtemplate '%s' to a valid via, as it no layershapes!", (Object[])new Object[]{pt.getName()});
                break;
            }
            case 1: {
                viaLayers = this.mFullViaLayersByOneLayer.get(layers.get(0));
                break;
            }
            case 2: {
                viaLayers = this.mFullViaLayersByTwoLayers.get(new Pair((Object)((Layer)layers.get(0)), (Object)((Layer)layers.get(1))));
                break;
            }
            case 3: {
                viaLayers = layers;
                break;
            }
            default: {
                ALog.flogWarn((String)"Can not convert padtemplate '%s' to a valid via, as it has more than 3 layers!", (Object[])new Object[]{pt.getName()});
            }
        }
        if (layers.equals(viaLayers)) {
            return pt.getLayerShapes().stream().map(ls -> new Pair((Object)ls.getLayer(), (Object)ls.getGeom())).collect(Collectors.toList());
        }
        ArrayList<Pair<Layer, AGeom>> layerGeoms = new ArrayList<Pair<Layer, AGeom>>();
        ARect maxBB = pt.getBB(null);
        for (Layer layer : viaLayers) {
            if (!layers.contains(layer)) {
                layerGeoms.add((Pair<Layer, AGeom>)new Pair((Object)layer, (Object)maxBB));
                continue;
            }
            pt.getLayerShapes(layer).stream().forEach(ls -> layerGeoms.add(new Pair((Object)l, (Object)ls.getGeom())));
        }
        return layerGeoms;
    }

    private void appendToSBThisViaFixed(StringBuilder sb, PadTemplate pt) {
        List<Pair<Layer, AGeom>> layerGeoms = null;
        layerGeoms = this.completeViaDef(pt);
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"- ", pt.getName(), "\n"});
        for (Pair<Layer, AGeom> lg : layerGeoms) {
            AGeom geom = (AGeom)lg.getValue1();
            if (geom instanceof APolygon) {
                this.appendToSBLayerPolygon(sb, (Layer)lg.getValue0(), (APolygon)geom);
                continue;
            }
            if (geom instanceof ARect) {
                this.appendToSBLayerRect(sb, (Layer)lg.getValue0(), geom.getBounds());
                continue;
            }
            ALog.flogWarn((String)"DEFOut: Cannot process the shape '%s'. Use bound box instead of.", (Object[])new Object[]{geom});
            this.appendToSBLayerRect(sb, (Layer)lg.getValue0(), geom.getBounds());
        }
        sb.append("\n ;\n");
    }

    private void appendToSBLayerRect(StringBuilder sb, Layer l, ARect r) {
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"+ RECT ", l.getName(), " "});
        APoint2D ll = r.getLL();
        APoint2D ur = r.getUR();
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"( ", Long.toString(this.scale(ll.getX())), " ", Long.toString(this.scale(ll.getY())), " ) ", "( ", Long.toString(this.scale(ur.getX())), " ", Long.toString(this.scale(ur.getY())), " )\n"});
    }

    private ArrayList<APoint2D> normalizePolygonPoints(APolygon poly) {
        AIterableItr pts = poly.getPoints();
        ArrayList list = Lists.newArrayList((Iterator)pts);
        if (((APoint2D)list.get(0)).equals(list.get(list.size() - 1))) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    private void appendToSBLayerPolygon(StringBuilder sb, Layer l, APolygon p) {
        p = p.toPoly();
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"+ POLYGON ", l.getName(), " "});
        for (APoint2D pt : this.normalizePolygonPoints(p)) {
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"( ", Long.toString(this.scale(pt.getX())), " ", Long.toString(this.scale(pt.getY())), ") "});
        }
        sb.append("\n");
    }

    protected void writeThisVia(PadTemplate pt) throws IOException {
        StringBuilder sb = new StringBuilder(4096);
        this.appendToSBThisVia(sb, pt);
        this.mOut.write(sb.toString());
    }

    private void writePin(Term term, boolean isSpecial) throws IOException {
        String use;
        String direction;
        Net net = term.getNet();
        this.mOut.write("- " + term.getName() + " + NET " + net.getName() + "\n");
        if (isSpecial) {
            this.mOut.write(" + SPECIAL");
        }
        if (!(direction = LEFDEFSyntax.PinDirection.getPinDirection(term.getType())).isEmpty()) {
            this.mOut.write(" + DIRECTION " + direction);
        }
        if (!(use = LEFDEFSyntax.PinUse.getPinUse(term.getUse())).isEmpty()) {
            this.mOut.write(" + USE " + use);
        }
        this.writePinPorts(term);
        this.mOut.write(" ;\n");
    }

    private void writePinPortLayerShapes(PortTemplate port) throws IOException {
        StringBuilder sb = new StringBuilder(4096);
        for (LayerShape ls : port.getLayerShapes()) {
            AUtil.reuse((StringBuilder)sb);
            if (ls.getGeom() instanceof ARect) {
                this.writePinPortRect(sb, ls);
            } else if (ls.getGeom() instanceof APolygon) {
                this.writePinPortPolygon(sb, ls);
            } else {
                ALog.flogWarn((String)"Use polygon for unsupported shape %s on layer %s, for DEF PIN.", (Object[])new Object[]{ls.getGeom(), ls.getLayer()});
                this.writePinPortAsPolygon(sb, ls);
            }
            this.mOut.write(sb.toString());
        }
    }

    private void writePinPortRect(StringBuilder sb, LayerShape ls) {
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{" + LAYER ", ls.getLayer().getName(), "\n"});
        ARect r = (ARect)ls.getGeom();
        APoint2D ll = r.getLL();
        APoint2D ur = r.getUR();
        sb.append(" ");
        this.appendToSBPt(sb, ll);
        this.appendToSBPt(sb, ur);
        sb.append("\n");
    }

    private void writePinPortPolygon(StringBuilder sb, LayerShape ls) {
        APolygon poly = (APolygon)ls.getGeom();
        if (poly.getPointCount() > 0) {
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{" + POLYGON ", ls.getLayer().getName(), "\n"});
            for (APoint2D pt : poly.getPoints()) {
                this.appendToSBPt(sb, pt);
            }
            sb.append("\n");
        }
    }

    private void writePinPortAsPolygon(StringBuilder sb, LayerShape ls) {
        APolygon poly = ls.getGeom().toPoly();
        if (poly.getPointCount() > 0) {
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{" + POLYGON ", ls.getLayer().getName(), "\n"});
            sb.append(" ");
            for (APoint2D pt : poly.getPoints()) {
                this.appendToSBPt(sb, pt);
            }
            sb.append("\n");
        }
    }

    private void writePinPorts(Term term) throws IOException {
        for (PinLabel pl : PinLabel.get((Term)term)) {
            PinTemplate pinT = pl.getPin();
            if (!this.inPinInSameTemplate(pinT, pl)) continue;
            this.mOut.write(" + PORT\n");
            for (PortTemplate port : pinT.getPortTemplates()) {
                this.writePinPortLayerShapes(port);
            }
            if (pinT.getType().equals((Object)PinTemplate.Type.BUMPPAD)) {
                this.mOut.write(" + COVER ");
            } else {
                this.writePlacementInfo(pinT, term);
            }
            StringBuilder sb = new StringBuilder(4096);
            APoint2D loc = pinT.getLoc();
            this.appendToSBPtAndOrient(sb, loc, LEFDEFOrient.ORIENT.getOrient((long)pinT.getRotate(), pinT.getMirror()).toLEFDEFString());
            this.mOut.write(sb.toString());
        }
    }

    private boolean inPinInSameTemplate(PinTemplate pinT, PinLabel pl) {
        return pinT != null && pl.getPinPath().size() == 0;
    }

    private void writePlacementInfo(PinTemplate pinT, Term term) throws IOException {
        List pinsts = pinT.getPinInstances().stream().collect(Collectors.toList());
        if (pinsts.size() != 1) {
            ALog.flogWarn((String)"DEF PIN %s has %d pininstances while expecting only 1.", (Object[])new Object[]{term.getName(), pinsts.size()});
        }
        if (pinsts.isEmpty() || !((PinInstance)pinsts.get(0)).fixed()) {
            this.mOut.write(" + PLACED ");
        } else {
            this.mOut.write(" + FIXED ");
        }
    }

    private List<Term> getTerms() {
        if (this.mTerms == null) {
            this.mTerms = this.mDiePath.getDeviceTemplate().getTerms().stream().sorted().collect(Collectors.toList());
        }
        return this.mTerms;
    }

    protected List<Term> writePins() throws IOException {
        List<Term> terms = this.getTerms();
        if (terms.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Term> pinsWithDifferentNetName = new LinkedList<Term>();
        this.mOut.write("PINS " + terms.size() + " ;\n");
        Set<Term> specialPins = this.buildSpecialPins(this.mDiePath.getDeviceTemplate());
        for (Term term : terms) {
            this.writePin(term, specialPins.contains(term));
            if (term.getName().equals(term.getNet().getName())) continue;
            pinsWithDifferentNetName.add(term);
        }
        this.mOut.write("END PINS\n");
        return pinsWithDifferentNetName;
    }

    private void writePinProperties(List<Term> terms) throws IOException {
        if (terms.isEmpty()) {
            return;
        }
        this.mOut.write("PINPROPERTIES " + terms.size() + " ;\n");
        StringBuilder sb = new StringBuilder();
        for (Term term : terms) {
            this.writePinProperty(term, sb);
            AUtil.reuse((StringBuilder)sb);
        }
        this.mOut.write("END PINPROPERTIES\n");
    }

    private void writePinProperty(Term term, StringBuilder sb) throws IOException {
        sb.append("- PIN ").append(term.getName()).append(" + PROPERTY ORBIT_NET \"").append(term.getNet().getName()).append("\"").append(" ;\n");
        this.mOut.write(sb.toString());
    }

    private LinkedHashSet<DevicePath> getFilteredDevices() {
        Stream<DevicePath> devices = this.mDiePath.getDescendants(false).stream().filter(childPath -> this.shouldInclude(childPath.getLast()));
        if (this.justTheseDevicesFilter != null) {
            devices = devices.filter(path -> this.justTheseDevicesFilter.include((DevicePath)path));
        }
        devices = devices.sorted();
        return devices.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<Obstacle> getSortedBlockages() {
        return this.mDb.getObjects(Obstacle.class).stream().filter(obs -> this.getIncludedTemplates().contains(obs.getDeviceTemplate())).filter(obs -> obs.getType().equals((Object)Obstacle.ObstacleType.DefBlockageLayer) || obs.getType().equals((Object)Obstacle.ObstacleType.DefBlockagePlacement)).sorted(new ObstacleSorter()).collect(Collectors.toList());
    }

    protected void writeBlockages() throws IOException {
        ALog.flogDebug((String)"writeBlockages begin...", (Object[])new Object[0]);
        List<Obstacle> sortedObs = this.getSortedBlockages();
        int numObs = sortedObs.size();
        if (numObs > 0) {
            this.mOut.write("BLOCKAGES " + numObs + " ;\n");
            StringBuilder sb = new StringBuilder(4096);
            for (Obstacle obs : sortedObs) {
                if (obs.getType() == Obstacle.ObstacleType.DefBlockagePlacement) {
                    this.writePlacementBlockage(obs, sb);
                    continue;
                }
                this.writeRoutingBlockage(obs, sb);
            }
            this.mOut.write("END BLOCKAGES\n");
        }
    }

    private void writeRoutingBlockage(Obstacle obs, StringBuilder sb) throws IOException {
        AUtil.reuse((StringBuilder)sb);
        Layer l = null;
        sb.append("\t - LAYER ");
        for (LayerShape ls : obs.getLayerShapes()) {
            if (l == null) {
                l = ls.getLayer();
                sb.append(l.getName());
                sb.append(" ");
            }
            ARect r = ls.getGeom().getBounds();
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"RECT ", this.getRectString(r), " \n"});
        }
        sb.append(" ;\n");
        this.mOut.write(sb.toString());
    }

    private Set<ARect> getDifferentRects(Obstacle obs) {
        return obs.getLayerShapes().stream().map(ls -> ls.getGeom().getBounds()).collect(Collectors.toSet());
    }

    private void writePlacementBlockage(Obstacle obs, StringBuilder sb) throws IOException {
        AUtil.reuse((StringBuilder)sb);
        sb.append("\t - PLACEMENT ");
        Set<ARect> diffRects = this.getDifferentRects(obs);
        diffRects.forEach(r -> AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"RECT ", this.getRectString((ARect)r), " \n"}));
        sb.append(" ;\n");
        this.mOut.write(sb.toString());
    }

    String getRectString(ARect r) {
        StringBuilder sb = new StringBuilder(4096);
        APoint2D ll = r.getLL();
        APoint2D ur = r.getUR();
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"( ", Long.toString(this.scale(ll.getX())), " ", Long.toString(this.scale(ll.getY())), " ) ", "( ", Long.toString(this.scale(ur.getX())), "  ", Long.toString(this.scale(ur.getY())), " )"});
        return sb.toString();
    }

    private void collectLEFSourceFileInfo(DeviceTemplate template, Set<DeviceTemplate> collected) {
        if (!collected.contains(template)) {
            collected.add(template);
            Substrate s = template.getSubstrate();
            if (s != null) {
                this.collectImportedLEF(s);
            }
        }
    }

    private void collectImportedLEF(Substrate s) {
        List list = s.getImportedLEF();
        this.mLEFSource.addAll(list);
    }

    public Set<String> getSourceFiles() {
        return this.mLEFSource;
    }

    private void appendToSBSource(StringBuilder sb, Device d) {
        String source;
        Object obj = d.getValue("DEF.SOURCE");
        if (obj != null && !(source = (String)obj).isEmpty()) {
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{" + SOURCE ", source});
        }
    }

    protected void writeComponents() {
        ALog.flogDebug((String)"writeComponents begin...", (Object[])new Object[0]);
        HashMap<Device, String> device2SetDefName = new HashMap<Device, String>();
        try {
            this.writeComponents(device2SetDefName);
        }
        catch (IOException e) {
            ALog.flogError((Throwable)e, (String)"In writing COMPONENTS section", (Object[])new Object[0]);
        }
        finally {
            this.setDeferredDefOutNames(device2SetDefName);
        }
    }

    private void writeComponents(Map<Device, String> device2SetDefName) throws IOException {
        long numComps;
        DbClass dbcDevice = this.mDb.getDbClass(Device.class);
        if (dbcDevice.getField(DBF_DEFOUTNAME) == null) {
            dbcDevice.addSoftField(DBF_DEFOUTNAME, String.class);
        }
        if ((numComps = (long)this.mFilteredDevices.size()) == 0L) {
            return;
        }
        HashSet<DeviceTemplate> collected = new HashSet<DeviceTemplate>();
        StringBuilder sb = new StringBuilder(4096);
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"COMPONENTS ", Long.toString(numComps), " ;\n"});
        this.mOut.write(sb.toString());
        for (DevicePath path : this.mFilteredDevices) {
            String propString;
            AUtil.reuse((StringBuilder)sb);
            Device device = path.getLast();
            DeviceTemplate template = device.getTemplate();
            this.collectLEFSourceFileInfo(template, collected);
            String name = DEFOut.setDefOutName(path, this.mOverwriteDefOutNames, device2SetDefName);
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"- ", name, " ", template.getName()});
            this.appendToSBSource(sb, device);
            if (device.getIsPlaced()) {
                if (device.getIsFixed()) {
                    sb.append(" + FIXED ");
                } else {
                    sb.append(" + PLACED ");
                }
                DevicePath pathToExportRoot = this.mDiePath.getRelativePath(path);
                ARect bb = pathToExportRoot.getBB();
                Float r = Float.valueOf(pathToExportRoot.getRot());
                LEFDEFOrient.ORIENT o = LEFDEFOrient.ORIENT.getOrient(r.longValue(), device.getMirror());
                String orient = o.toLEFDEFString();
                this.appendToSBPtAndOrient(sb, bb.getLL(), orient);
            }
            if (!(propString = this.writeComponentProperties(template, path)).isEmpty()) {
                sb.append(propString);
            }
            sb.append(" ;\n");
            this.mOut.write(sb.toString());
        }
        this.mOut.write("END COMPONENTS\n");
    }

    private void buildBumpToPinsMap(Collection<DevicePath> paths) {
        HashMap<DevicePath, DevicePath> pinPath2DevPath = null;
        DeviceTemplate owner = this.mDiePath.getDeviceTemplate();
        for (PinLabel pl : new StreamIterableIterator(this.getTermPins(owner))) {
            DevicePath path;
            if (pinPath2DevPath == null) {
                pinPath2DevPath = new HashMap<DevicePath, DevicePath>(paths.size() / 3 * 4);
                for (DevicePath path2 : paths) {
                    if (path2.getRoot() == owner) {
                        pinPath2DevPath.put(path2, path2);
                        continue;
                    }
                    pinPath2DevPath.put(path2.getRelativePathFromAnchor(owner), path2);
                }
            }
            if ((path = (DevicePath)pinPath2DevPath.get(pl.getPinPath())) == null) continue;
            List pls = this.mBumpToPinLabels.computeIfAbsent(path, k -> new LinkedList());
            pls.add(pl);
        }
    }

    private Stream<PinLabel> getTermPins(DeviceTemplate owner) {
        return PinLabel.get((DeviceTemplate)owner).stream().filter(pl -> pl.getTerm() != null);
    }

    private int getTermCount(DeviceTemplate template) {
        return this.mTemplateTermCount.computeIfAbsent(template, k -> (int)template.getTermCount());
    }

    private String writeComponentProperties(DeviceTemplate template, DevicePath path) {
        List<PinLabel> pls = this.mBumpToPinLabels.get(path);
        if (pls == null || pls.isEmpty()) {
            return "";
        }
        if (this.getTermCount(template) == 1) {
            PinLabel pl = pls.get(0);
            return String.format(" + PROPERTY BUMP_TO_PIN \"%s\" ", pl.getTerm().getName());
        }
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (PinLabel pl : pls) {
            if (!isFirst) {
                sb.append(SEP);
            }
            sb.append(pl.getTerm().getName());
            sb.append(":");
            sb.append(pl.getPin().getName());
            isFirst = false;
        }
        return String.format(" + PROPERTY BUMP_TO_PIN \"%s\" ", sb.toString());
    }

    private void appendToSBPtAndOrient(StringBuilder sb, APoint2D pt, String orient) {
        this.appendToSBPt(sb, pt);
        sb.append(orient);
    }

    private void appendToSBPt(StringBuilder sb, APoint2D pt) {
        sb.append("( ");
        sb.append(this.scale(pt.getX()));
        sb.append(" ");
        sb.append(this.scale(pt.getY()));
        sb.append(" ) ");
    }

    protected boolean writeThisVia(HierPin via) {
        if (this.justTheseDevicesFilter == null) {
            return true;
        }
        ARect viaBounds = via.getWorldBounds();
        return this.justTheseDevicesFilter.intersects(viaBounds);
    }

    private void writeNetAttributes(Net n) throws IOException {
        Net.Use use = n.getUse();
        if (use != null && use != Net.Use.UNKNOWN) {
            this.mOut.write("+ USE " + use.name() + "\n");
        }
    }

    private boolean hasMatchWire(Net n) {
        return n.getWires().stream().anyMatch(w -> this.justTheseWiresFilter.include((Wire)w));
    }

    private void appendToSBCompPin(StringBuilder sb, String name, String pinName) {
        if (Strings.isNullOrEmpty((String)name)) {
            name = "PIN";
        }
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"( ", name, " ", pinName, " ) \n"});
    }

    private String getDefOutName(DevicePath dp) {
        DevicePath substrateRelPath = dp.pathToSubstrate();
        if (substrateRelPath == null) {
            return "";
        }
        if ((substrateRelPath = substrateRelPath.getRelativePath(dp)) == null) {
            return "";
        }
        return DEFOut.getDefOutName(dp, substrateRelPath);
    }

    private void writeBumpPin(StringBuilder sb, DevicePath dp, PinTemplate pin) throws IOException {
        String name = this.getDefOutName(dp);
        String pinName = pin.getName();
        AUtil.reuse((StringBuilder)sb);
        this.appendToSBCompPin(sb, name, pinName);
        this.mOut.write(sb.toString());
    }

    private Stream<HierPin> getConnectedVias(DeviceTemplate dt, Net n) {
        return NetMap.getConnectedHierPins((DevicePath)new DevicePath(dt), (Net)n).stream().filter(dpp -> ((PinTemplate)dpp.getDbObject()).getType().equals((Object)PinTemplate.Type.VIA)).filter(dpp -> ((PinTemplate)dpp.getDbObject()).getSubstrate() == this.mSubstrate).map(hpt -> {
            DevicePath p = this.mDiePath.addPath(hpt.getPath());
            return new HierPin(p, PinInstance.getPinInstance((Device)p.getDevice(), (PinTemplate)((PinTemplate)hpt.getDbObject())));
        });
    }

    private Stream<Net> getFilteredNets(DeviceTemplate dt) {
        Stream<Net> nets = dt.getNets().stream().filter(n -> !n.isNC());
        if (this.justTheseWiresFilter != null) {
            nets = nets.filter(this::hasMatchWire);
        }
        return nets;
    }

    private static boolean isBump(DevicePath dp) {
        return DEFOut.isBump(dp.getDevice());
    }

    private static boolean isBump(Device d) {
        if (d.isTypeOf(DeviceTemplate.Type.BUMP)) {
            return true;
        }
        return d.getTemplate().getPins().anyMatch(pt -> pt.isTypeOf(PinTemplate.Type.BUMPPAD));
    }

    private void writeNetTerms(Net n, StringBuilder sb) throws IOException {
        AUtil.reuse((StringBuilder)sb);
        Stream<Term> s = n.getTerms().stream();
        s = s.sorted();
        s.forEach(t -> this.appendToSBCompPin(sb, "PIN", t.getName()));
        this.mOut.write(sb.toString());
    }

    private AMap2Set<Net, PinInstance> getConnectedViaPins(DeviceTemplate dt, Net n) {
        Stream<HierPin> dpps = this.getConnectedVias(dt, n);
        dpps = dpps.sorted();
        AMap2Set<Net, PinInstance> viaPins = new AMap2Set<Net, PinInstance>();
        dpps.forEach(dpp -> {
            if (this.writeThisVia((HierPin)dpp)) {
                viaPins.add(dpp.getNet(), dpp.getPin());
            }
        });
        return viaPins;
    }

    private boolean writeThisWire(Wire w) {
        return this.justTheseWiresFilter == null || this.justTheseWiresFilter.include(w);
    }

    private boolean writeWiresOnNet(Net n, StringBuilder sb) throws IOException {
        List wires = n.getWires().stream().filter(this::writeThisWire).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(wires, Wire.StableComparator);
        return this.writeWires(wires, sb);
    }

    private Set<Term> buildSpecialPins(DeviceTemplate dt) {
        Stream<Net> nets = dt.getNets().stream();
        if (this.justTheseWiresFilter != null) {
            nets = nets.filter(this::hasMatchWire);
        }
        return nets.flatMap(n -> n.getTerms().stream()).collect(Collectors.toSet());
    }

    private Map<Net, List<BumpPins>> getNetConnectedBumpPins(DeviceTemplate dt, Collection<DevicePath> from) {
        HashMap<Net, List<BumpPins>> netHierBumpPins = new HashMap<Net, List<BumpPins>>();
        from.stream().filter(DEFOut::isBump).forEach(dp -> {
            DeviceTemplate t = dp.getDeviceTemplate();
            t.getPins().forEach(p -> {
                Net topNet = this.getNetAtTemplate(dt, p.getNet(), (DevicePath)dp);
                if (topNet != null) {
                    BumpPins bumpPins = new BumpPins((DevicePath)dp);
                    List dpps = netHierBumpPins.computeIfAbsent(topNet, k -> new LinkedList());
                    dpps.add(bumpPins);
                    bumpPins.addPin((PinTemplate)p);
                }
            });
        });
        return netHierBumpPins;
    }

    private Net getNetAtTemplate(DeviceTemplate t, Net net, DevicePath path) {
        Iterator it = path.descendingIterator();
        while (it.hasNext()) {
            if (net.getDeviceTemplate() == t) {
                return net;
            }
            Device d = (Device)it.next();
            Net parentNet = NetMap.getParentNet((Device)d, (Net)net);
            if (parentNet == null) {
                return null;
            }
            net = parentNet;
        }
        return null;
    }

    protected void writeNets() throws IOException {
        ALog.flogDebug((String)"writeNets", (Object[])new Object[0]);
        DeviceTemplate dt = this.mDiePath.getDeviceTemplate();
        Stream<Net> netsOnDie = this.getFilteredNets(dt);
        netsOnDie = netsOnDie.sorted();
        List nets = netsOnDie.collect(Collectors.toList());
        if (nets.isEmpty()) {
            return;
        }
        this.mOut.write("SPECIALNETS " + nets.size() + " ;\n");
        Map<Net, List<BumpPins>> connectedBumpPins = this.getNetConnectedBumpPins(dt, this.mFilteredDevices);
        StringBuilder sb = new StringBuilder(4096);
        for (Net n : nets) {
            boolean didWriteWires;
            AUtil.reuse((StringBuilder)sb);
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"- ", n.getName(), "\n"});
            this.mOut.write(sb.toString());
            this.writeNetTerms(n, sb);
            boolean writeAnyHierBumpPin = false;
            List<BumpPins> bps = connectedBumpPins.get(n);
            if (bps != null) {
                writeAnyHierBumpPin = this.writeBumpPins(bps, sb);
            }
            boolean bl = didWriteWires = this.mWriteWires && this.writeWiresOnNet(n, sb);
            if (didWriteWires && this.mWriteVias) {
                AMap2Set<Net, PinInstance> viaPins = this.getConnectedViaPins(dt, n);
                this.writeViaOnNet(viaPins, n, sb);
            }
            this.writeNetAttributes(n);
            if (writeAnyHierBumpPin) {
                this.mOut.write(" + PROPERTY BUMP_ASSIGNMENT \"ASSIGNED\"\n");
            }
            this.mOut.write(" ;\n");
        }
        this.mOut.write("END SPECIALNETS\n");
    }

    private boolean writeBumpPins(List<BumpPins> bps, StringBuilder sb) throws IOException {
        boolean writeAtLeaseOne = false;
        for (BumpPins hbp : bps) {
            DevicePath dp = hbp.bump;
            List<PinTemplate> pins = hbp.pins;
            Collections.sort(pins);
            for (PinTemplate pin : pins) {
                this.writeBumpPin(sb, dp, pin);
                writeAtLeaseOne = true;
            }
        }
        return writeAtLeaseOne;
    }

    private boolean writeWires(List<Wire> wires, StringBuilder sb) throws IOException {
        boolean hasWires = !wires.isEmpty();
        boolean firstWire = true;
        for (Wire w : wires) {
            AUtil.reuse((StringBuilder)sb);
            APath p = w.getPath();
            if (firstWire) {
                sb.append("\n+ ROUTED ");
            } else {
                sb.append("\n NEW ");
            }
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{w.getLayer().getName(), " ", Long.toString(this.scale(p.getWidth())), "\n"});
            this.mOut.write(sb.toString());
            firstWire = false;
            for (APoint2D ap : this.getAdjustedWirePoints(w)) {
                AUtil.reuse((StringBuilder)sb);
                AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"( ", Long.toString(this.scale(ap.getX())), " ", Long.toString(this.scale(ap.getY())), " )", "\n"});
                this.mOut.write(sb.toString());
            }
        }
        return hasWires;
    }

    private void writeViaOnNet(AMap2Set<Net, PinInstance> net2Via, Net n, StringBuilder sb) throws IOException {
        for (PinInstance via : net2Via.getCollection(n)) {
            Layer topLayer;
            String viaName = ViaFactory.getViaName(via.getPinTemplate());
            if (viaName.equals("Unknown")) {
                viaName = ViaFactory.getViaNameByPadTemplate(via.getPinTemplate());
            }
            if ((topLayer = (Layer)this.getTopBotLayers(via).getValue0()) == null) {
                ALog.flogError((String)"SPECIALNETS: via '%s' has no top layer!", (Object[])new Object[]{viaName});
                throw new IllegalArgumentException();
            }
            APoint2D loc = via.getLoc();
            long x = loc.getX();
            long y = loc.getY();
            AUtil.reuse((StringBuilder)sb);
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"\n NEW ", topLayer.getName(), " 0 ", " ( ", Long.toString(this.scale(x)), " ", Long.toString(this.scale(y)), " ) ", viaName, "\n"});
            this.mOut.write(sb.toString());
        }
    }

    protected Pair<Layer, Layer> getTopBotLayers(PinInstance via) {
        PinTemplate pt = via.getPinTemplate();
        return this.mVia2Layers.computeIfAbsent(pt, key -> {
            List l = key.getLayersInUse().sorted().collect(Collectors.toList());
            return new Pair((Object)((Layer)l.get(0)), (Object)((Layer)l.get(l.size() - 1)));
        });
    }

    protected Iterable<APoint2D> getAdjustedWirePoints(final Wire wire) {
        boolean hasNonOrtho;
        final APath path = wire.getPath();
        final int pointCount = path.getPointCount();
        final boolean noExtend = hasNonOrtho = path.getSegments().stream().anyMatch(l -> !l.isOrthogonal());
        return new ProcessingIterator<APoint2D, APoint2D>((Iterator)path.getPoints()){
            int curPtIdx;

            protected void init() {
                super.init();
                this.curPtIdx = -1;
            }

            protected APoint2D process(APoint2D curPt) {
                if (noExtend) {
                    return curPt;
                }
                ++this.curPtIdx;
                if (pointCount > 1 && wire.getEndCapType() != Constraint.EndCapType.NONE) {
                    if (this.curPtIdx == 0) {
                        APoint2D next = path.getPoint(1);
                        ALine l = new ALine(curPt, next);
                        l.extendEnds(path.getWidth() / 2L);
                        return l.getP0();
                    }
                    if (this.curPtIdx == pointCount - 1) {
                        APoint2D prev = path.getPoint(pointCount - 2);
                        ALine l = new ALine(prev, curPt);
                        l.extendEnds(path.getWidth() / 2L);
                        return l.getP1();
                    }
                }
                return curPt;
            }
        };
    }

    private boolean isFromSynTemplate(Device d) {
        return d.getTemplate().getIsSynthesized();
    }

    private boolean shouldInclude(Device child) {
        Boolean b;
        if (child.hasChildren() || child.getSubstrate() != this.mSubstrate) {
            return false;
        }
        if (!this.mInclFromSynTemplate && this.isFromSynTemplate(child)) {
            return false;
        }
        return this.mWriteLEFDEFIgnoreOnWrite || (b = (Boolean)child.getTemplate().getValue("LEFDEF.ignoreOnWrite")) == null || b == false;
    }

    private void setDeferredDefOutNames(Map<Device, String> device2SetDefName) {
        for (Map.Entry<Device, String> ent : device2SetDefName.entrySet()) {
            Device device = ent.getKey();
            String defOutName = ent.getValue();
            if (defOutName == null) {
                device.unsetSoftValue(DBF_DEFOUTNAME);
                continue;
            }
            device.setValue(DBF_DEFOUTNAME, (Object)defOutName);
        }
    }

    protected static String setDefOutName(DevicePath path, boolean overwrite) {
        return DEFOut.setDefOutName(path, null, overwrite, false, null);
    }

    protected static String setDefOutName(DevicePath path, boolean overwrite, Map<Device, String> deferredNameMap) {
        return DEFOut.setDefOutName(path, null, overwrite, false, deferredNameMap);
    }

    protected static String setDefOutName(DevicePath path, String name, boolean overwrite, boolean writeEvenIfDefault, Map<Device, String> deferredNameMap) {
        Device device = path.getDevice();
        String curDefOutName = (String)device.getValue(DBF_DEFOUTNAME, String.class);
        if (curDefOutName != null && !overwrite) {
            return curDefOutName;
        }
        DevicePath substratePath = path.pathToSubstrate();
        substratePath = substratePath.getRelativePath(path);
        if (name == null) {
            name = DEFOut.getDefOutName(path, substratePath);
        }
        if (curDefOutName != null && !curDefOutName.equals(name)) {
            ALog.flogInfo((String)"Changing DEFOutName of '%s' from '%s' to '%s'.", (Object[])new Object[]{path, curDefOutName, name});
        }
        if (name.equals(DEFOut.getDefaultDefOutName(substratePath)) && !writeEvenIfDefault) {
            if (curDefOutName != null) {
                if (deferredNameMap != null) {
                    deferredNameMap.put(device, null);
                } else {
                    device.unsetSoftValue(DBF_DEFOUTNAME);
                }
            }
        } else if (deferredNameMap != null) {
            deferredNameMap.put(device, name);
        } else {
            device.setValue(DBF_DEFOUTNAME, (Object)name);
        }
        return name;
    }

    public static String getDefOutName(DevicePath fullPath, DevicePath substrateRelPath) {
        String name;
        if (sCustomWS == null) {
            sCustomWS = new CustomDefWS();
        }
        if ((name = sCustomWS.getCustomOutName(fullPath, substrateRelPath)) == null) {
            name = DEFOut.getDefaultDefOutName(substrateRelPath);
        }
        return name;
    }

    public static String getDefaultDefOutName(DevicePath substrateRelPath) {
        String name = substrateRelPath.getString(null);
        if (name.startsWith("/")) {
            name = name.replaceFirst("/", "");
        }
        return name;
    }

    public static void exportDEFNameMap(String devicePath, String filePath, boolean writeDefaultNames) {
        Db db = OrbitApp.getCurDb();
        DevicePath dpStart = DevicePath.fromString((Db)db, (String)devicePath);
        if (dpStart == null) {
            ALog.flogError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
            return;
        }
        DeviceTemplate dpStartTemplate = dpStart.getDeviceTemplate();
        try (ACsvWriter csv = ACsvWriter.open((String)filePath);){
            csv.header(new String[]{"Device", "DEFName"});
            LinkedList list = AUtil.linkedList((Iterator)dpStart.getDescendants(false));
            Collections.sort(list);
            for (DevicePath dp : list) {
                DevicePath substratePath = dp.pathToSubstrate();
                substratePath = substratePath.getRelativePath(dp);
                String defOutName = dp.getDevice().getStringValue(DBF_DEFOUTNAME);
                if (defOutName == null && writeDefaultNames) {
                    defOutName = DEFOut.getDefOutName(dp, substratePath);
                }
                if (defOutName != null) {
                    DevicePath relPath = dp.getRelativePath(dpStartTemplate);
                    if (!relPath.isEmpty()) {
                        relPath.removeFirst();
                    }
                    csv.colData(relPath.toString());
                    csv.colData(defOutName);
                    csv.endRow();
                    continue;
                }
                ALog.flogInfo((String)(dp.toString() + "has no stored Def name"), (Object[])new Object[0]);
            }
        }
    }

    public static void importDEFNameMap(String filePath, String devicePath, boolean explicitlySetDefaultNames) {
        Db db = OrbitApp.getCurDb();
        DevicePath dpStart = DevicePath.fromString((Db)db, (String)devicePath);
        if (dpStart == null) {
            ALog.flogError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
            return;
        }
        try (ACsvReader csv = ACsvReader.open((String)filePath);){
            if (!csv.validateHeader(new String[]{"Device", "DEFName"})) {
                ALog.flogWarn((String)"Unexpected header in input file '%s", (Object[])new Object[0]);
            }
            for (String[] row : csv.getRows()) {
                DevicePath dp = dpStart.addPath(row[0]);
                if (dp == null) {
                    ALog.flogWarn((String)"Invalid DevicePath '%s' specified on line %d, it is being ignored.", (Object[])new Object[]{row[0], csv.getCurLine()});
                    continue;
                }
                String name = DEFOut.setDefOutName(dp, row[1], true, explicitlySetDefaultNames, null);
                if (name.equals(row[1])) continue;
                ALog.flogWarn((String)"Setting DefOut name for '%s' to '%s' failed for CSV input line %d.", (Object[])new Object[]{row[0], row[1], csv.getCurLine()});
            }
        }
    }

    private static void writeCustomWires(List<Wire> wires, Unit unit, BufferedWriter out, StringBuilder sb) throws IOException {
        for (Wire w : wires) {
            APath p = w.getPath();
            String net = w.getNet().getName();
            String layer = w.getLayer().getName();
            String width = unit.toUserStr(p.getWidth());
            for (ALine l : p.getLines()) {
                AUtil.reuse((StringBuilder)sb);
                APoint2D p0 = l.getP0();
                APoint2D p1 = l.getP1();
                String x0 = unit.toUserStr(p0.getX());
                String y0 = unit.toUserStr(p0.getY());
                String x1 = unit.toUserStr(p1.getX());
                String y1 = unit.toUserStr(p1.getY());
                double angle = l.getAngle();
                AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"Wire", SEP, net, SEP, layer, SEP, width, SEP, Double.toString(angle), SEP, x0, SEP, y0, SEP, x1, SEP, y1, "\n"});
                out.write(sb.toString());
            }
        }
    }

    private static void writeCustomVias(List<HierPin> vias, Unit unit, BufferedWriter out, StringBuilder sb) throws IOException {
        for (HierPin via : vias) {
            AUtil.reuse((StringBuilder)sb);
            APoint2D loc = via.getSubstrateLoc();
            String x0 = unit.toUserStr(loc.getX());
            String y0 = unit.toUserStr(loc.getY());
            AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"Via", SEP, via.getSubstrateNet().getName(), SEP + ViaFactory.getViaName(((PinInstance)via.second).getPinTemplate()), SEP, x0, SEP, y0 + "\n"});
            out.write(sb.toString());
        }
    }

    public static void writeCustom(List<Wire> wires, List<HierPin> vias, String fileName) {
        Db db = OrbitApp.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        StringBuilder sb = new StringBuilder(4096);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(fileName));){
            DEFOut.writeCustomWires(wires, unit, out, sb);
            DEFOut.writeCustomVias(vias, unit, out, sb);
        }
        catch (IOException e) {
            ALog.flogError((Throwable)e, (String)"Exception while writing to file '%s'.", (Object[])new Object[]{fileName});
        }
    }

    private void appendToSBPinGeom(StringBuilder sb, LayerShape ls) {
        Layer l = ls.getLayer();
        AUtil.appendToSBStrings((StringBuilder)sb, (String[])new String[]{"+ POLYGON ", l.getName(), " "});
        APolygon transP = ls.getGeom().toPoly();
        for (APoint2D pts : transP.getPoints()) {
            this.appendToSBPt(sb, pts);
        }
        sb.append(" \n");
    }

    public String pinGeom(PortTemplate port, LayerShape ls) {
        StringBuilder sb = new StringBuilder(4096);
        this.appendToSBPinGeom(sb, ls);
        return sb.toString();
    }

    private class AMap2Set<KEY, TYPE>
    extends HashMap<KEY, Set<TYPE>> {
        private transient Set<TYPE> mSet = new LinkedHashSet<TYPE>();

        private AMap2Set() {
        }

        public Iterable<TYPE> getCollection(KEY k) {
            LinkedHashSet set = (LinkedHashSet)this.get(k);
            if (set == null) {
                set = new LinkedHashSet();
                this.put(k, set);
            }
            return set;
        }

        public Set<TYPE> getValueSet() {
            return this.mSet;
        }

        public int getCollectionSize(KEY k) {
            LinkedHashSet set = (LinkedHashSet)this.get(k);
            if (set == null) {
                set = new LinkedHashSet();
                this.put(k, set);
            }
            return set.size();
        }

        public void add(KEY k, TYPE o) {
            LinkedHashSet<TYPE> set = (LinkedHashSet<TYPE>)this.get(k);
            if (set == null) {
                set = new LinkedHashSet<TYPE>();
                this.put(k, set);
            }
            set.add(o);
        }

        public void removeEntry(KEY k, TYPE o) {
            Set set = (Set)this.get(k);
            set.remove(o);
        }

        @Override
        public int size() {
            return this.mSet.size();
        }
    }

    public static class CustomDefWS {
        private boolean hasCustomOutName = false;
        private boolean canOpt = false;
        private BshMethod mOutNameMethod = null;
        private String mCmd = (String)Settings.get((String)"LefDefConfig", (String)"DEFOutNameFunction", (Object)"");
        private int[] mPlaced;
        public static final String BSH_DEF_OUTPATH = "defOutPath";
        public static final String BSH_DEF_FULLPATH = "defOutPathFull";

        private CustomDefWS() {
            if (!this.mCmd.isEmpty()) {
                this.hasCustomOutName = true;
                this.setupOutNameMethod();
            }
        }

        private void setupOutNameMethod() {
            String testCmd = MessageFormat.format(this.mCmd, "{0}", "{1}") + ";";
            ByteArrayInputStream in = new ByteArrayInputStream(testCmd.getBytes());
            this.canOpt = false;
            try {
                Parser parser2 = new Parser((InputStream)in);
                parser2.Line();
                Interpreter interpreter = Cp.getCp().getInterpreter();
                APair config = ABshUtil.getCommand((SimpleNode)parser2.popNode(), (Interpreter)interpreter);
                if (config == null || ((Object[])config.getSecond()).length > 2) {
                    return;
                }
                int n = ((Object[])config.getSecond()).length;
                this.mPlaced = new int[n];
                for (int i = 0; i < n; ++i) {
                    if (((Object[])config.getSecond())[i].equals("{0}")) {
                        this.mPlaced[i] = 0;
                        continue;
                    }
                    if (((Object[])config.getSecond())[i].equals("{1}")) {
                        this.mPlaced[i] = 1;
                        continue;
                    }
                    return;
                }
                this.mOutNameMethod = (BshMethod)config.getFirst();
                this.canOpt = true;
            }
            catch (ParseException e) {
                ALog.flogError((Throwable)e, (String)"Error getting DEF output name using command:\n\t%s", (Object[])new Object[]{this.mCmd});
            }
        }

        public String getCustomOutName(DevicePath fullPath, DevicePath substrateRelPath) {
            if (!this.hasCustomOutName) {
                return null;
            }
            if (!this.canOpt) {
                return this.getCustomOutNameNaive(fullPath, substrateRelPath);
            }
            try {
                Interpreter interpreter = Cp.getCp().getInterpreter();
                interpreter.set(BSH_DEF_OUTPATH, (Object)substrateRelPath);
                interpreter.set(BSH_DEF_FULLPATH, (Object)fullPath);
                Object[] objs = new Object[this.mPlaced.length];
                String strSubstrRelPath = substrateRelPath.toString();
                String strPath = fullPath.toString();
                for (int i = 0; i < objs.length; ++i) {
                    objs[i] = this.mPlaced[i] == 0 ? strSubstrRelPath : strPath;
                }
                String name = "" + this.mOutNameMethod.invoke(objs, Cp.getCp().getInterpreter());
                interpreter.unset(BSH_DEF_OUTPATH);
                interpreter.unset(BSH_DEF_FULLPATH);
                return name;
            }
            catch (EvalError e) {
                ALog.flogError((Throwable)e, (String)"Error getting DEF output name using command:\n\t%s", (Object[])new Object[]{this.mCmd});
                return null;
            }
        }

        private String getCustomOutNameNaive(DevicePath fullPath, DevicePath substrateRelPath) {
            String strSubstrRelPath = substrateRelPath.toString();
            String strPath = fullPath.toString();
            strSubstrRelPath = AUtil.escapeBackslashes((String)strSubstrRelPath);
            strPath = AUtil.escapeBackslashes((String)strPath);
            String c = MessageFormat.format(this.mCmd, strSubstrRelPath, strPath);
            try {
                Interpreter interpreter = Cp.getCp().getInterpreter();
                interpreter.set(BSH_DEF_OUTPATH, (Object)substrateRelPath);
                interpreter.set(BSH_DEF_FULLPATH, (Object)fullPath);
                String name = "" + interpreter.eval(c);
                interpreter.unset(BSH_DEF_OUTPATH);
                interpreter.unset(BSH_DEF_FULLPATH);
                return name;
            }
            catch (EvalError e) {
                ALog.flogError((Throwable)e, (String)"Error getting DEF output name using command:\n\t%s", (Object[])new Object[]{c});
            }
            catch (Exception e) {
                ALog.flogError((Throwable)e, (String)"Unexpected error getting DEF output name using command:\n\t%s", (Object[])new Object[]{c});
            }
            return null;
        }
    }

    static class BumpPins {
        DevicePath bump;
        List<PinTemplate> pins = new ArrayList<PinTemplate>();

        BumpPins(DevicePath bump) {
            this.bump = bump;
        }

        void addPin(PinTemplate pin) {
            this.pins.add(pin);
        }
    }

    protected static class ObstacleSorter
    implements Comparator<Obstacle> {
        protected ObstacleSorter() {
        }

        @Override
        public int compare(Obstacle c0, Obstacle c1) {
            return Long.compare(c0.getId(), c1.getId());
        }
    }

    public static interface JustTheseDevicesFilter {
        public boolean include(DevicePath var1);

        public boolean intersects(ARect var1);
    }

    public static interface JustTheseWiresFilter {
        public boolean include(Wire var1);
    }
}

