/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.google.common.collect.HashMultimap;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.verilog.VerilogSyntax;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.export.VerilogExport;
import javax.swing.SwingUtilities;

public class DEFOutNames {

    public static class VerilogStyle {
        static Cp.Listener sCpListener = null;
        static HashMultimap<DeviceTemplate, String> sDevT2BusNames = null;

        public static String getName(DevicePath dieRelPath) {
            boolean exist;
            Device device;
            DeviceTemplate parentT;
            if (dieRelPath.isEmpty()) {
                return "";
            }
            Object name = "";
            for (Device device2 : dieRelPath) {
                if (!((String)name).isEmpty()) {
                    name = (String)name + "/";
                }
                name = (String)name + device2.getName();
            }
            if (VerilogExport.ReplaceSquareBracketsWithUnderscoresInInstNames) {
                name = ((String)name).replace('[', '_').replace(']', '_');
            }
            DeviceTemplate deviceTemplate = parentT = (device = dieRelPath.getDevice()) == null ? null : device.getParent();
            if (parentT == null) {
                return name;
            }
            boolean bl = exist = parentT.getNet((String)name) != null;
            if (!exist) {
                if (sCpListener == null && Cp.getCp().getCmd() != null) {
                    sCpListener = new Cp.Listener(){

                        public void cmdStart(String cmd, boolean record) {
                        }

                        public void cmdEnd(String cmd, boolean record) {
                            if (sCpListener != null) {
                                sDevT2BusNames = null;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Cp.getCp().removeListener(sCpListener);
                                    }
                                });
                                sCpListener = null;
                            }
                        }
                    };
                    Cp.getCp().addListener(sCpListener);
                }
                if (sDevT2BusNames == null) {
                    sDevT2BusNames = HashMultimap.create();
                }
                if (!sDevT2BusNames.containsKey((Object)parentT)) {
                    for (Net net : parentT.getNets()) {
                        String netName;
                        if (net.isUnused() || !VerilogSyntax.isBusName((String)(netName = net.getName()))) continue;
                        String busName = (String)VerilogSyntax.parseBusName((String)netName).first;
                        sDevT2BusNames.put((Object)parentT, (Object)busName);
                    }
                    if (!sDevT2BusNames.containsKey((Object)parentT)) {
                        sDevT2BusNames.put((Object)parentT, null);
                    }
                }
                exist = sDevT2BusNames.containsEntry((Object)parentT, name);
            }
            if (exist) {
                name = (String)name + "Inst";
            }
            if (sCpListener == null) {
                sDevT2BusNames = null;
            }
            return name;
        }
    }
}

