/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ABoolean;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ReferencePoint;
import com.sigrity.orbit.export.DeviceCSVOut;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class DeviceCSVIn {
    public static final String TITLE = "Import CSV Devices...";
    private Db mDb = null;
    private DevicePath mInPath;
    private Unit mInUnit = null;
    private ReferencePoint mRefP = new ReferencePoint();
    private int numChanges = 0;

    public static void showUI(DevicePath devicePath) {
        DbDialog dlg = new DbDialog(devicePath.getDb(), (Component)OrbitIO.getMainWindow(), TITLE);
        GridBagManager l = GridBagManager.layout((Container)dlg.getContentPane());
        l.push("Source", (GridBagConstraints)GridBagManager.FILLX);
        l.add("File:");
        AFileChooserControl fc = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        fc.addChoosableFileFilter(AFileFilter.CSV);
        l.popNl();
        l.pushFill("Options");
        l.add("Placement Origin:").setToolTipText("Reference point inside each device");
        ReferencePoint.Reference[] refs = new ReferencePoint.Reference[]{ReferencePoint.Reference.ORIG, ReferencePoint.Reference.LL, ReferencePoint.Reference.LR, ReferencePoint.Reference.UL, ReferencePoint.Reference.UR, ReferencePoint.Reference.CENTER};
        JComboBox cb = (JComboBox)l.add(new JComboBox<ReferencePoint.Reference>(refs), (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
        btnOK.addActionListener(e -> {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)TITLE);){
                Cp.exec((String)"unset(\"_deviceCsvIn\")", (Object[])new Object[0]);
                Cp.exec((String)"_deviceCsvIn = new com.sigrity.orbit.export.DeviceCSVIn()", (Object[])new Object[0]);
                Cp.exec((String)"_deviceCsvIn.setReference(%s.%s)", (Object[])new Object[]{ReferencePoint.Reference.class.getName(), ((ReferencePoint.Reference)cb.getSelectedItem()).name()});
                Cp.exec((String)"_deviceCsvIn.importCSV(curDb(), %s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)fc.getPath()), devicePath});
                Cp.exec((String)"unset(\"_deviceCsvIn\")", (Object[])new Object[0]);
            }
            UIUtil.closeWindow((Window)dlg);
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOK);
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
    }

    public void setReference(ReferencePoint.Reference ref) {
        this.mRefP.setRef(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importCSV(Db db, String filePath, String devicePath) {
        DevicePath startDevPath = DevicePath.fromString((Db)db, (String)devicePath);
        if (startDevPath == null) {
            ALog.logError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
            return false;
        }
        this.mInUnit = Design.getUnit((Db)db);
        this.mDb = db;
        this.mInPath = startDevPath;
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            CSVDocument csvDoc = parser2.parse(filePath);
            for (int i = 0; i != csvDoc.getItemCount(); ++i) {
                this.importDevice(csvDoc, i);
            }
        }
        catch (CSVDOMParser.CSVDOMException e) {
            boolean bl;
            try {
                ALog.logWarn((String)"Problems reading %s", (Object[])new Object[]{filePath});
                bl = false;
            }
            catch (Throwable throwable) {
                ALog.flogInfo((String)"%d field values were updated.", (Object[])new Object[]{this.numChanges});
                throw throwable;
            }
            ALog.flogInfo((String)"%d field values were updated.", (Object[])new Object[]{this.numChanges});
            return bl;
        }
        ALog.flogInfo((String)"%d field values were updated.", (Object[])new Object[]{this.numChanges});
        return true;
    }

    private void importDevice(CSVDocument csvDoc, int index) {
        String name = csvDoc.getItemValue(index, "Device");
        String subName = csvDoc.getItemValue(index, "Substrate");
        String templateName = csvDoc.getItemValue(index, "Device_Template");
        DeviceTemplate parentTemplate = this.mInPath.getDeviceTemplate();
        Device targetDev = parentTemplate.getChild(name);
        if (targetDev == null) {
            DeviceTemplate template;
            if (subName != null) {
                template = (DeviceTemplate)this.mDb.getByKeyStr(DeviceTemplate.class, templateName);
                if (template == null) {
                    template = DeviceTemplate.getDeviceTemplate((Substrate)Substrate.getSubstrate((Db)this.mDb, (String)subName), (String)templateName);
                }
                if (template == null) {
                    ALog.flogError((String)"Cannot create a new device because tempate key '%s' is not found", (Object[])new Object[]{templateName});
                    return;
                }
            } else {
                template = DeviceTemplate.getDeviceTemplate((Substrate)this.mInPath.getSubstrate(), (String)templateName);
                if (template == null) {
                    ALog.flogError((String)"Cannot create a new device because tempate consist of substrate '%s' and name '%s' is not found.", (Object[])new Object[]{subName, templateName});
                    return;
                }
            }
            targetDev = Device.create((String)name, (DeviceTemplate)template, (DeviceTemplate)parentTemplate);
            ALog.flogInfo((String)"Create a new device '%s': line %d", (Object[])new Object[]{targetDev, index});
        }
        this.mRefP.setDbObj((DbObject)targetDev);
        for (int i = 0; i < DeviceCSVOut.headerFields.size(); ++i) {
            String column = DeviceCSVOut.headerFields.get(i);
            String value = csvDoc.getItemValue(index, column);
            if (value == null || value.isEmpty() || !this.updateFieldValue(targetDev, column, value)) continue;
            ++this.numChanges;
        }
    }

    private boolean updateFieldValue(Device device, String column, String value) {
        try {
            if (column.equals("X")) {
                APoint2D loc = device.getLoc();
                Long x = this.mInUnit.fromUserString(value);
                if (x == null) {
                    return false;
                }
                device.setLoc(new APoint2D(this.mRefP.toRefX(x.longValue()), loc.getY()));
                device.setIsPlaced(true);
                return true;
            }
            if (column.equals("Y")) {
                APoint2D loc = device.getLoc();
                Long y = this.mInUnit.fromUserString(value);
                if (y == null) {
                    return false;
                }
                device.setLoc(new APoint2D(loc.getX(), this.mRefP.toRefY(y.longValue())));
                device.setIsPlaced(true);
                return true;
            }
            if (column.equals("Flip")) {
                boolean b = ABoolean.fromString((String)value);
                device.setFlipped(b);
                return true;
            }
            if (column.equals("Mirror")) {
                boolean b = ABoolean.fromString((String)value);
                device.setMirror(b);
                return true;
            }
            if (column.equals("Rotate")) {
                device.setRotate(Float.parseFloat(value));
                return true;
            }
            if (column.equals("Device") || column.equals("Device_Template") || column.equals("Substrate")) {
                return false;
            }
            throw new UnsupportedOperationException("Unimplemented Column " + column);
        }
        catch (Exception e) {
            ALog.flogError((Throwable)e, (String)"Unrecognized format: value '%s' in column '%s'", (Object[])new Object[]{value, column});
            return false;
        }
    }
}

