/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ReferencePoint;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class DeviceCSVOut {
    public static final String TITLE = "Export CSV Devices...";
    public static final String NULLSTR = "";
    private static final String VERSION = "0.2";
    private Unit mUnit = null;
    private Db mDb = null;
    private DevicePath mOutPath = null;
    private Set<DeviceTemplate.Type> mOutDevTypes = null;
    private ReferencePoint mRefP = new ReferencePoint();
    static final String COL_DEVICE = "Device";
    static final String COL_SUBSTRATE = "Substrate";
    static final String COL_DEVICE_TEMPLATE = "Device_Template";
    static final String COL_LOC_X = "X";
    static final String COL_LOC_Y = "Y";
    static final String COL_FLIP = "Flip";
    static final String COL_MIRROR = "Mirror";
    static final String COL_ROTATE = "Rotate";
    protected static final List<String> headerFields = AUtil.arrayList((Object[])new String[]{"Device", "Substrate", "Device_Template", "X", "Y", "Flip", "Mirror", "Rotate"});

    public static List<String> getHeader() {
        return headerFields;
    }

    public static void showUI(DevicePath devicePath) {
        DeviceCSVOut.showUI(devicePath, null);
    }

    public static void showUI(DevicePath devicePath, DeviceTemplate.Type initType) {
        DbDialog dlg = new DbDialog(devicePath.getDb(), (Component)OrbitIO.getMainWindow(), TITLE);
        GridBagManager l = GridBagManager.layout((Container)dlg.getContentPane());
        l.pushFillX("Source");
        l.add("File:");
        AFileChooserControl fc = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        fc.setUseSaveChooser(true);
        fc.addChoosableFileFilter(AFileFilter.CSV);
        l.popNl();
        l.pushFill("Options");
        l.add("Placement Origin:").setToolTipText("Reference point inside each device");
        ReferencePoint.Reference[] refs = new ReferencePoint.Reference[]{ReferencePoint.Reference.ORIG, ReferencePoint.Reference.LL, ReferencePoint.Reference.LR, ReferencePoint.Reference.UL, ReferencePoint.Reference.UR, ReferencePoint.Reference.CENTER};
        JComboBox cb = (JComboBox)l.add(new JComboBox<ReferencePoint.Reference>(refs), (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
        btnOK.addActionListener(e -> {
            Cp.exec((String)"unset(\"_deviceCsvOut\")", (Object[])new Object[0]);
            Cp.exec((String)"_deviceCsvOut = new com.sigrity.orbit.export.DeviceCSVOut()", (Object[])new Object[0]);
            if (initType != null) {
                Cp.exec((String)"_deviceCsvOut.matchDeviceType(%s.%s)", (Object[])new Object[]{DeviceTemplate.Type.class.getName(), initType.name()});
            }
            Cp.exec((String)"_deviceCsvOut.setReference(%s.%s)", (Object[])new Object[]{ReferencePoint.Reference.class.getName(), ((ReferencePoint.Reference)cb.getSelectedItem()).name()});
            Cp.exec((String)"_deviceCsvOut.write(curDb(), %s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)fc.getPath()), devicePath});
            Cp.exec((String)"unset(\"_deviceCsvOut\")", (Object[])new Object[0]);
            UIUtil.closeWindow((Window)dlg);
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOK);
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
    }

    public void matchDeviceType(DeviceTemplate.Type type) {
        if (this.mOutDevTypes == null) {
            this.mOutDevTypes = new HashSet<DeviceTemplate.Type>();
        }
        this.mOutDevTypes.add(type);
    }

    public void setReference(ReferencePoint.Reference ref) {
        this.mRefP.setRef(ref);
    }

    public boolean write(Db db, String filePath, String devicePath) {
        boolean bl;
        block10: {
            DevicePath startDevPath = DevicePath.fromString((Db)db, (String)devicePath);
            if (startDevPath == null) {
                DevicePath.fromString((Db)db, (String)devicePath, (boolean)true);
                ALog.logError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
                return false;
            }
            this.mDb = db;
            this.mUnit = Design.getUnit((Db)db);
            this.mOutPath = startDevPath;
            ACsvWriter writer = ACsvWriter.open((String)filePath);
            try {
                boolean result = this.write(writer);
                if (result) {
                    ALog.logInfo((String)"Export Device CSV '%s'", (Object[])new Object[]{new File(filePath)});
                }
                bl = result;
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"There was an unexpected exception while writing file.", (Object[])new Object[0]);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    private void writeDeviceInfo(ACsvWriter writer) {
        writer.row(new String[]{"#. Version: 0.2"});
        writer.row(new String[]{"#. Date: " + new Date()});
        writer.row(new String[]{"#. Orbit: " + OrbitIO.getApp().getBuildVersion()});
        writer.row(new String[]{"#. FilePath: " + this.mDb.getCanonicalPath()});
        writer.row(new String[]{"#. DevicePath: " + this.mOutPath.toString()});
        writer.row(new String[]{"#. Unit: " + this.mUnit.getUserName()});
        writer.row(new String[]{"#. Reference: " + this.mRefP.getRef().name()});
        writer.row(new String[]{"#. Columns: Device, Substrate(optional, default as substrate of device path), Device Template, X, Y, Flip, Mirror, Rotate" + this.mUnit.getUserName()});
    }

    private boolean write(ACsvWriter writer) {
        int count = 0;
        try {
            this.writeDeviceInfo(writer);
            this.writeHeader(writer);
            DeviceTemplate startDevT = this.mOutPath.getDeviceTemplate();
            for (Device device : startDevT.getChildren()) {
                if (this.mOutDevTypes != null && !this.mOutDevTypes.contains(device.getType())) continue;
                this.writeDevice(writer, device);
                ++count;
            }
            ALog.logInfo((String)"Wrote %d devices.", (Object[])new Object[]{count});
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)"Problem writing", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private void writeHeader(ACsvWriter writer) {
        for (String head : headerFields) {
            writer.colData(head);
        }
        writer.endRow();
    }

    private void writeDevice(ACsvWriter writer, Device device) {
        this.mRefP.setDbObj((DbObject)device);
        for (String column : headerFields) {
            String name;
            if (column.equals(COL_DEVICE)) {
                writer.colData(device.getName());
                continue;
            }
            if (column.equals(COL_SUBSTRATE)) {
                name = device.getSubstrate().getName();
                writer.colData(name);
                continue;
            }
            if (column.equals(COL_DEVICE_TEMPLATE)) {
                name = device.getTemplate().getName();
                writer.colData(name);
                continue;
            }
            if (column.equals(COL_LOC_X)) {
                writer.colData(this.toUserUnit(device.getLoc().getX() + this.mRefP.getRefX()));
                continue;
            }
            if (column.equals(COL_LOC_Y)) {
                writer.colData(this.toUserUnit(device.getLoc().getY() + this.mRefP.getRefY()));
                continue;
            }
            if (column.equals(COL_FLIP)) {
                writer.colData(Boolean.toString(device.getFlipped()));
                continue;
            }
            if (column.equals(COL_MIRROR)) {
                writer.colData(Boolean.toString(device.getMirror()));
                continue;
            }
            if (column.equals(COL_ROTATE)) {
                writer.colData(Double.toString(device.getRotate()));
                continue;
            }
            throw new UnsupportedOperationException("Unimplemented Column " + column);
        }
        writer.endRow();
    }

    protected String toUserUnit(long d) {
        return this.mUnit == null ? Long.toString(d) : NULLSTR + this.mUnit.toUser(d);
    }
}

