/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import au.com.bytecode.opencsv.CSVReader;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;

public class DiePackageNetMapping {
    /*
     * Unable to fully structure code
     */
    public static void importCSV(String diePathString, String filePath) throws FileNotFoundException {
        db = OrbitIO.getCurDb();
        if (db == null) {
            return;
        }
        diePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (diePath == null || diePath.isEmpty()) {
            ALog.logError((String)"The specified top device path '%s' is invalid.", (Object[])new Object[]{diePath});
            return;
        }
        fr = new FileReader(filePath);
        try {
            reader = new CSVReader((Reader)fr);
            try {
                ALog.logInfo((String)"Importing net assignments from '%s'.", (Object[])new Object[]{filePath});
                dieTemplate = diePath.getDeviceTemplate();
                packageTemplate = diePath.getParent().getDeviceTemplate();
                i = 0;
                while (true) {
                    block31: {
                        if ((l = reader.readNext()) == null) {
                            break;
                        }
                        if (l.length == 0 || l.length == 1 && l[0].trim().length() == 0) break block31;
                        msgCtx = String.format("line %d", new Object[]{i});
                        dieCur = DiePackageNetMapping.get(l, 0);
                        if (dieCur == null || dieCur.startsWith("#")) break block31;
                        dieNew = DiePackageNetMapping.get(l, 1);
                        packageCur = DiePackageNetMapping.get(l, 2);
                        packageNew = DiePackageNetMapping.get(l, 3);
                        if (dieNew == null || dieNew.isEmpty() || dieCur.equals(dieNew)) ** GOTO lbl42
                        curDieNet = dieTemplate.getNet(dieCur);
                        if (curDieNet == null) {
                            ALog.logWarn((String)(msgCtx + " There is no net on the die called " + dieCur));
                        } else {
                            renamed = true;
                            if (dieTemplate.getNet(dieNew) == null) {
                                Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").setName(\"%s\")", (Object[])new Object[]{curDieNet.getKeyStr(), dieNew});
                                if (renamed) {
                                    ALog.logInfo((String)"Net '%s' renamed into Net '%s' on die.", (Object[])new Object[]{dieCur, dieNew});
                                }
                            } else {
                                Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").moveContents(\"%s\", true)", (Object[])new Object[]{curDieNet.getKeyStr(), dieNew});
                                if (renamed) {
                                    ALog.logInfo((String)"Net '%s' merged into Net '%s' on die.", (Object[])new Object[]{dieCur, dieNew});
                                }
                            }
lbl42:
                            // 5 sources

                            if (packageNew != null && !packageNew.isEmpty() && packageCur != null && !packageCur.equals(dieNew)) {
                                if (packageCur.equals("NC")) {
                                    if (packageTemplate.getNet(packageNew) == null) {
                                        Cp.exec((String)"curDb().getByKeyStr(DeviceTemplate.class, \"%s\").createNet(\"%s\")", (Object[])new Object[]{packageTemplate.getKeyStr(), packageNew});
                                    }
                                    if (dieNew != null && !dieNew.isEmpty() && !dieCur.equals(dieNew)) {
                                        dieCur = dieNew;
                                    }
                                    if ((curDieNet = dieTemplate.getNet(dieCur)) != null) {
                                        NetMap.mapThroughPath((DevicePath)diePath, (Net)curDieNet, (String)packageNew);
                                        ALog.logInfo((String)("Mapping net " + dieCur + " to the package on net " + packageNew));
                                    } else {
                                        ALog.logWarn((String)("Attempting to connect net " + dieCur + " to the package. But it does not exist on the die"));
                                    }
                                } else {
                                    curPackageNet = packageTemplate.getNet(packageCur);
                                    if (curPackageNet == null) {
                                        ALog.logWarn((String)(msgCtx + " There is no net on the package called " + packageCur));
                                    } else {
                                        renamed = true;
                                        if (packageTemplate.getNet(packageNew) == null) {
                                            Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").setName(\"%s\")", (Object[])new Object[]{curPackageNet.getKeyStr(), packageNew});
                                            if (renamed) {
                                                ALog.logInfo((String)"Net '%s' renamed into Net '%s'. on the Package", (Object[])new Object[]{packageCur, packageNew});
                                            }
                                        } else {
                                            Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").moveContents(\"%s\", true)", (Object[])new Object[]{curPackageNet.getKeyStr(), packageNew});
                                            if (renamed) {
                                                ALog.logInfo((String)"Net '%s' merged into Net '%s'. on the Package", (Object[])new Object[]{packageCur, packageNew});
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            ALog.flogError((String)"Error when reading the csv file '%s'", (Object[])new Object[]{filePath});
        }
    }

    protected static boolean pinABump(PinInstance p) {
        PinTemplate pt = p.getPinTemplate();
        DeviceTemplate dt = pt.getDeviceTemplate();
        return p.getPinTemplate().getType().equals((Object)PinTemplate.Type.BUMPPAD) || dt.getType().equals((Object)DeviceTemplate.Type.COVER) || dt.getType().equals((Object)DeviceTemplate.Type.BUMP);
    }

    public static void exportCSV(String diePathString, String filePath) throws FileNotFoundException {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return;
        }
        DevicePath diePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (diePath == null || diePath.isEmpty()) {
            ALog.logError((String)"The specified top device path '%s' is invalid.", (Object[])new Object[]{diePath});
            return;
        }
        PrintStream out = new PrintStream(filePath);
        String header = "#" + diePath.toString();
        out.println(header);
        String columns = "#Die Bump Current, Die Bump New, Package Ball Current, Package Ball New, Interfaces";
        out.println(columns);
        LinkedList<Net> nets = new LinkedList<Net>();
        AHashCollection netToInterfaceNames = new AHashCollection();
        for (DevicePath child : diePath.getDescendants()) {
            for (PinInstance pin : child.getLast().getPins()) {
                if (!DiePackageNetMapping.pinABump(pin)) continue;
                DevicePath pathToDie = new DevicePath(child);
                pathToDie.removeFirst();
                Net n = NetMap.getTopmostNet((Net)pin.getNet(), (DevicePath)pathToDie);
                if (!nets.contains(n)) {
                    if (!n.getDeviceTemplate().equals(diePath.getDeviceTemplate())) {
                        ALog.logInfo((String)("Net " + n.getName() + " is on a bump but not on the die"));
                        continue;
                    }
                    nets.add(n);
                }
                if (n.getName().equals("VSS")) {
                    ALog.logInfo((String)"");
                }
                String interfaceName = child.getParent().getLast().getName();
                boolean found = false;
                for (String currentInterfaceName : netToInterfaceNames.getCollection((Object)n)) {
                    if (!currentInterfaceName.equals(interfaceName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                netToInterfaceNames.add((Object)n, (Object)interfaceName);
            }
        }
        Collections.sort(nets);
        int netCount = 0;
        for (Net net : nets) {
            Net parentNet = NetMap.getParentNet((Device)diePath.getLast(), (Net)net);
            String line = net.getName() + ", ,";
            line = parentNet != null ? line + parentNet.getName() + ", ," : line + "NC, ,";
            for (String interfaceName : (LinkedList)netToInterfaceNames.get((Object)net)) {
                line = line + "<" + interfaceName + "> ";
            }
            out.println(line);
            ++netCount;
        }
        ALog.logInfo((String)(netCount + " net written to " + filePath));
        out.close();
    }

    private static String get(String[] line, int column) {
        if (column >= line.length) {
            return null;
        }
        String s = line[column];
        if ((s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }
}

