/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import au.com.bytecode.opencsv.CSVReader;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.PartFactory;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class DiePadSpreadsheetSerializer {
    protected ArrayList<Personality> mNewPersonality;
    protected CSVDocument mDocument;
    protected int mCurrentItemIndex = -1;
    protected DevicePath mDevicePath;
    protected Personality mLastPersonality = null;
    protected boolean mLastPersonalityWasBlank = true;
    protected int mCurrentMajorSlot;
    protected FileWriter mFileWriter = null;
    protected int previousExtra;
    protected ArrayList<ArrayList<DevicePath>> mToBePlacedBySide = new ArrayList();
    protected final float devicePersonalityTransparancy = 0.5f;

    public void importDie(String filePath, DevicePath dp) {
        this.mNewPersonality = new ArrayList();
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        this.mDevicePath = dp;
        Device die = dp.getLast();
        if (die == null) {
            return;
        }
        File file = this.read(die, filePath);
        if (file == null) {
            return;
        }
        APoint2D ll = new APoint2D();
        for (Personality p : this.mNewPersonality) {
            ALog.logInfo((String)("Synthesizing Personality For " + p.getName()));
            Device parent = p.createParent(this.mDevicePath);
            p.arrangeDevicesInArea();
            p.encompassChildDevices();
            parent.moveTo(ll.getX(), ll.getY());
            ll.moveBy(0L, parent.getLocalBB().height());
            Boolean hard = (Boolean)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.HARD_PERSONALITY);
            if (hard == null || !hard.booleanValue()) continue;
            parent.getTemplate().setType(DeviceTemplate.Type.MACRO);
            p.getObjects().filter(hi -> ((DevicePath)hi.first).equals((Object)this.mDevicePath)).forEach(hi -> {
                Device d = (Device)hi.second;
                d.setIsFixed(true);
            });
        }
        ALog.logInfo((String)"Placing Personalities");
        ARect r = new ARect(die.getUntransformedShape().getBounds());
        this.placePersonalities(r);
        for (Personality p : this.mNewPersonality) {
            DevicePath parent = p.getParentDevicePath();
            parent.getLast().setSourceType(Device.SourceType.DIESPREADSHEET);
            if (!p.isSynthesizedByTool()) continue;
            DevicePath holder = p.getParentDevicePath();
            if (holder != null) {
                Device.unGroup((DevicePath)holder);
            }
            p.deleteFromDb();
        }
        Device.manageAllUnplaceQs();
        currentDesign.binAllDevices();
        die.getTemplate().setSourceFile(filePath);
        die.getTemplate().setSourceFileModifiedTime(file.lastModified());
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public void exportDie(String filePath, DevicePath dp) {
        this.mDevicePath = dp;
        if (filePath == null) {
            return;
        }
        try {
            File file = new File(filePath);
            this.mFileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)("Can not open " + filePath + " for writing"), (Object[])new Object[0]);
            return;
        }
        this.determineToBePlaced();
        this.sortByLocation();
        this.writeCSV();
    }

    protected void determineToBePlaced() {
        for (int i = 0; i < 4; ++i) {
            this.mToBePlacedBySide.add(new ArrayList());
        }
        for (DevicePath child : this.mDevicePath.getDescendants()) {
            Device c = child.getLast();
            if (c.getTemplate().getType() != DeviceTemplate.Type.PAD && c.getTemplate().getType() != DeviceTemplate.Type.BLOCK) continue;
            int q = this.getQuadrant(child.getOrigin(), this.mDevicePath.getBB());
            this.mToBePlacedBySide.get(q).add(child);
        }
        ALog.logInfo((String)(this.mToBePlacedBySide.get(0).size() + " will be placed on right side"));
        ALog.logInfo((String)(this.mToBePlacedBySide.get(1).size() + " will be placed on top side"));
        ALog.logInfo((String)(this.mToBePlacedBySide.get(2).size() + " will be placed on left side"));
        ALog.logInfo((String)(this.mToBePlacedBySide.get(3).size() + " will be placed on bottom side"));
    }

    protected void sortByLocation() {
        for (int side = 0; side < 4; ++side) {
            ArrayList<DevicePath> devicesOnSide = this.mToBePlacedBySide.get(side);
            if (devicesOnSide.size() == 0) continue;
            if (side == 0) {
                Collections.sort(devicesOnSide, new DevicePathSortV(true));
                continue;
            }
            if (side == 1) {
                Collections.sort(devicesOnSide, new DevicePathSortH(false));
                continue;
            }
            if (side == 2) {
                Collections.sort(devicesOnSide, new DevicePathSortV(false));
                continue;
            }
            Collections.sort(devicesOnSide, new DevicePathSortH(true));
        }
    }

    protected void groupByPersonality(ArrayList<DevicePath> paths) {
        ArrayList<Personality> arrayPersonalities = new ArrayList<Personality>();
        for (int i = 0; i < paths.size(); ++i) {
            Personality p = paths.get(i).getLast().getPersonality();
            if (p == null || arrayPersonalities.contains(p)) continue;
            arrayPersonalities.add(p);
        }
        ArrayList<DevicePath> result = new ArrayList<DevicePath>(paths.size());
        for (int i = 0; i < arrayPersonalities.size(); ++i) {
            Personality p = (Personality)arrayPersonalities.get(i);
            for (int j = 0; j < paths.size(); ++j) {
                DevicePath path = paths.get(j);
                if (path.getLast().getPersonality() != p) continue;
                result.add(path);
            }
        }
        paths.clear();
        paths.addAll(result);
    }

    protected long getCornerGap(int side) {
        ArrayList<DevicePath> ps;
        if (side == 3) {
            return 0L;
        }
        boolean isVert = true;
        if (side == 0) {
            ps = this.mToBePlacedBySide.get(3);
        } else if (side == 1) {
            ps = this.mToBePlacedBySide.get(0);
            isVert = false;
        } else {
            ps = this.mToBePlacedBySide.get(1);
        }
        if (ps.size() == 0) {
            return 0L;
        }
        Device dp = ps.get(ps.size() - 1).getLast();
        Personality p = dp.getPersonality();
        long gap = 0L;
        for (DevicePath path : ps) {
            if (path.getLast().getPersonality() != p) continue;
            if (isVert) {
                long h = path.getLast().getLocalBB().height();
                if (gap >= h) continue;
                gap = h;
                continue;
            }
            long w = path.getLast().getLocalBB().width();
            if (gap >= w) continue;
            gap = w;
        }
        return gap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<PositionInfo> getPositionInfos(int side) {
        float rot;
        ArrayList<DevicePath> paths = this.mToBePlacedBySide.get(side);
        ArrayList<PositionInfo> infos = new ArrayList<PositionInfo>();
        int startIndex = 0;
        int endIndex = 0;
        switch (side) {
            case 0: {
                rot = 90.0f;
                break;
            }
            case 1: {
                rot = 180.0f;
                break;
            }
            case 2: {
                rot = 270.0f;
                break;
            }
            default: {
                rot = 0.0f;
            }
        }
        float oldRot = this.mDevicePath.getLast().getRotate();
        this.mDevicePath.getLast().setRotate(oldRot + rot);
        try {
            while (endIndex < paths.size()) {
                startIndex = endIndex;
                Personality cp = paths.get(startIndex).getLast().getPersonality();
                while (endIndex < paths.size() && paths.get(endIndex).getLast().getPersonality() == cp) {
                    ++endIndex;
                }
                ArrayList<Device> mainDevices = new ArrayList<Device>();
                for (int i = startIndex; i < endIndex; ++i) {
                    DevicePath path = paths.get(i);
                    Device d = path.getLast();
                    if (d.getMinorSlot() != 0) continue;
                    mainDevices.add(d);
                }
                for (Device mainDevice : mainDevices) {
                    int majorSlot = mainDevice.getMajorSlot();
                    ArrayList<Device> addDevices = new ArrayList<Device>();
                    for (int i = startIndex; i < endIndex; ++i) {
                        DevicePath path = paths.get(i);
                        Device d = path.getLast();
                        if (d.getMinorSlot() == 0 || d.getMajorSlot() != majorSlot) continue;
                        addDevices.add(d);
                    }
                    PositionInfo info = new PositionInfo(0.0f, 0.0f, mainDevice, addDevices);
                    infos.add(info);
                }
            }
            Device prevMajorDevice = null;
            Unit unit = Design.getUnit((Db)this.mDevicePath.getDb());
            for (int i = 0; i < infos.size(); ++i) {
                PositionInfo info = (PositionInfo)infos.get(i);
                Device mainDevice = info.mMainDevice;
                Constraint c = Constraint.getConstraint((Db)mainDevice.getDb(), (DbObject)mainDevice.getPersonality(), (Constraint.Descriptor)Constraint.POSITION);
                if (c != null && ((String)c.getValue()).equalsIgnoreCase("corner")) {
                    prevMajorDevice = mainDevice;
                    continue;
                }
                if (i == 0) {
                    long gap = mainDevice.getADevicePath().getOrigin().getX() - this.mDevicePath.getBB().getLL().getX();
                    info.mGap = (float)unit.toUser(gap -= this.getCornerGap(side));
                } else {
                    long w = prevMajorDevice.getADevicePath().getBB().right() - prevMajorDevice.getADevicePath().getOrigin().getX();
                    long gap = mainDevice.getADevicePath().getOrigin().getX() - prevMajorDevice.getADevicePath().getOrigin().getX() - w;
                    info.mGap = (float)unit.toUser(gap);
                }
                long inset = mainDevice.getADevicePath().getBB().getLL().getY() - this.mDevicePath.getBB().getLL().getY();
                info.mInset = (float)unit.toUser(inset);
                for (int j = 0; j < info.mAddDevices.size(); ++j) {
                    Device addDevice = info.mAddDevices.get(j);
                    long gap = addDevice.getADevicePath().getOrigin().getX() - mainDevice.getADevicePath().getOrigin().getX();
                    float fgap = (float)unit.toUser(gap);
                    for (PositionInfo.AdditionInfo addInfo : info.mAdditionInfos) {
                        if (addInfo.mAddDevice != addDevice) continue;
                        addInfo.mAddGap = fgap;
                    }
                }
                prevMajorDevice = mainDevice;
            }
        }
        finally {
            this.mDevicePath.getLast().setRotate(oldRot);
        }
        return infos;
    }

    protected void reOrganizePersonality() {
        ArrayList pss = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            HashMap<Personality, Personality> newPersons = new HashMap<Personality, Personality>();
            pss.add(newPersons);
            ArrayList<DevicePath> devices = this.mToBePlacedBySide.get(i);
            for (DevicePath p : devices) {
                Device d = p.getLast();
                Personality ps = d.getPersonality();
                if (ps == null) continue;
                Personality nps = (Personality)newPersons.get(ps);
                if (nps != null) {
                    if (ps == nps) continue;
                    d.assignToPersonality(nps);
                    ALog.logInfo((String)"%s assign to new personality %s", (Object[])new Object[]{d.getADevicePath().toString(), nps.getName()});
                    continue;
                }
                for (int j = 0; j < i; ++j) {
                    nps = (Personality)((HashMap)pss.get(j)).get(ps);
                    if (nps == null) continue;
                    Personality.Type type = ps.getType();
                    DeviceTemplate devTemp = ps.getOwner();
                    String name = ps.getName();
                    String newName = Personality.getUniqueName((DeviceTemplate)devTemp, (Personality.Type)type, (String)name);
                    nps = new Personality(devTemp, type, newName);
                    d.getDb().add((DbObject)nps);
                    if (ps.getColor() != null) {
                        nps.setColor(ps.getColor());
                    }
                    nps.setValue("side", (Object)this.getSideName(i));
                    if (ps.getValue("inset") != null) {
                        nps.setValue("inset", ps.getValue("inset"));
                    }
                    Constraint.setConstraintValue((DbObject)nps, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)((Boolean)Constraint.getValue((Db)ps.getDb(), (DbObject)ps, (Constraint.Descriptor)Constraint.HARD_PERSONALITY)));
                    d.assignToPersonality(nps);
                    ALog.logInfo((String)"%s assign to new personality %s", (Object[])new Object[]{d.getADevicePath().toString(), nps.getName()});
                    newPersons.put(ps, nps);
                    break;
                }
                if (newPersons.get(ps) != null) continue;
                newPersons.put(ps, ps);
            }
        }
    }

    protected String getSideName(int side) {
        String[] sideNames = new String[]{"right", "top", "left", "bottom"};
        assert (side >= 0 && side < 4);
        return sideNames[side];
    }

    protected void writeCSV() {
        Design cd = Design.getDesign((Db)OrbitIO.getCurDb());
        try {
            this.reOrganizePersonality();
            String header = "Personality,CellInstanceName,TemplateName,Width,Height,Side,PinName,PinPersonalityName,PinType,NetName,Position,Transform,Inset,Gap,AddInstanceName,AddTemplateName,AddInset,AddGap,AddPinName,AddPinPersonalityName,AddPinType,AddTransform";
            this.printCSV(header);
            for (int side = 0; side < 4; ++side) {
                ArrayList<PositionInfo> infos = this.getPositionInfos(side);
                for (int i = 0; i < infos.size(); ++i) {
                    PositionInfo info = infos.get(i);
                    boolean multiLine = info.mAdditionInfos.size() > 1;
                    for (PositionInfo.AdditionInfo addInfo : info.mAdditionInfos) {
                        Constraint c;
                        Object line = "";
                        Personality p = info.mMainDevice.getPersonality();
                        if (p != null) {
                            line = (String)line + p.getName();
                        }
                        line = (String)line + ",";
                        if (multiLine) {
                            line = (String)line + "$";
                        }
                        line = (String)line + info.mMainDevice.getName();
                        line = (String)line + ",";
                        line = (String)line + info.mMainDevice.getTemplate().getName();
                        line = (String)line + ",";
                        Double w = cd.getUser(info.mMainDevice.getTemplate().getBB().width());
                        Double h = cd.getUser(info.mMainDevice.getTemplate().getBB().height());
                        line = (String)line + w.toString();
                        line = (String)line + ",";
                        line = (String)line + h.toString();
                        line = (String)line + ",";
                        line = (String)line + this.getSideName(side);
                        line = (String)line + ",";
                        if (addInfo.mMainPin != null) {
                            line = (String)line + addInfo.mMainPin.getName();
                        }
                        line = (String)line + ",";
                        if (addInfo.mMainPin != null && addInfo.mMainPin.getPersonality() != null) {
                            line = (String)line + addInfo.mMainPin.getPersonality().getName();
                        }
                        line = (String)line + ",";
                        if (addInfo.mMainPin != null) {
                            line = (String)line + addInfo.mMainPin.getPinTemplate().getType().name();
                        }
                        line = (String)line + ",";
                        if (addInfo.mMainNet != null) {
                            line = (String)line + addInfo.mMainNet.getName();
                        }
                        line = (String)line + ",";
                        if (p != null && (c = Constraint.getConstraint((Db)p.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.POSITION)) != null) {
                            String position = (String)c.getValue();
                            line = (String)line + position;
                        }
                        line = (String)line + ",";
                        line = (String)line + ",";
                        line = (String)line + info.mInset;
                        line = (String)line + ",";
                        line = (String)line + info.mGap;
                        line = (String)line + ",";
                        if (addInfo.mAddDevice != null) {
                            line = (String)line + addInfo.mAddDevice.getName();
                        }
                        line = (String)line + ",";
                        if (addInfo.mAddDevice != null) {
                            line = (String)line + addInfo.mAddDevice.getTemplate().getName();
                        }
                        line = (String)line + ",";
                        line = (String)line + addInfo.mAddInset;
                        line = (String)line + ",";
                        line = (String)line + addInfo.mAddGap;
                        line = (String)line + ",";
                        if (addInfo.mAddPin != null) {
                            line = (String)line + addInfo.mAddPin.getName();
                        }
                        line = (String)line + ",";
                        if (addInfo.mAddPin != null && addInfo.mAddPin.getPersonality() != null) {
                            line = (String)line + addInfo.mAddPin.getPersonality().getName();
                        }
                        line = (String)line + ",";
                        if (addInfo.mAddPin != null) {
                            line = (String)line + addInfo.mAddPin.getPinTemplate().getType().name();
                        }
                        line = (String)line + ",";
                        if (addInfo.mAddDevice != null && addInfo.mAddDevice.getRotate() != 0.0f) {
                            line = (String)line + this.getRotationOrient((int)addInfo.mAddDevice.getRotate());
                        }
                        line = (String)line + ",";
                        this.printCSV((String)line);
                    }
                }
            }
            this.mFileWriter.close();
        }
        catch (IOException e) {
            return;
        }
    }

    protected String getRotationOrient(int angle) {
        angle = (angle + 360) % 360;
        switch (angle) {
            case 90: {
                return AGeomUtil.Orient.E.name();
            }
            case 0: {
                return AGeomUtil.Orient.N.name();
            }
            case 270: {
                return AGeomUtil.Orient.W.name();
            }
            case 180: {
                return AGeomUtil.Orient.S.name();
            }
        }
        return "";
    }

    protected boolean printCSV(String s) throws IOException {
        try {
            this.mFileWriter.write(s);
            this.mFileWriter.write("\n");
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems writing", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    protected File read(Device owner, String filePath) {
        boolean res = false;
        File file = new File(filePath);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to read '%s'.", (Object[])new Object[]{filePath});
            return null;
        }
        res = this.readCsv(owner, fis);
        if (!res) {
            return null;
        }
        return file;
    }

    protected boolean readCsv(Device owner, FileInputStream fis) {
        int goodRows = 0;
        int badRows = 0;
        this.mCurrentItemIndex = 0;
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            this.mDocument = parser2.parse((InputStream)fis);
            for (int i = 0; i < this.mDocument.getItemCount(); ++i) {
                this.mCurrentItemIndex = i;
                boolean status = this.addDevice(owner, i);
                if (!status) {
                    ++badRows;
                    continue;
                }
                ++goodRows;
            }
            ALog.logInfo((String)("There were " + goodRows + " device(s) read and " + badRows + " device(s) ignored because of problems"));
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logError((Throwable)e, (String)"Error reading input file.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    protected String uniqueInstanceName(String name, DeviceTemplate t) {
        Object newName = name;
        int i = 1;
        if (t.getChild(name) != null) {
            newName = name + "_1";
        }
        while (t.getChild((String)newName) != null) {
            newName = name + "_" + i++;
        }
        if (i == 2) {
            Device firstDevice = t.getChild(name);
            firstDevice.setName(name + "_0");
        }
        return newName;
    }

    protected boolean validateRow(Device owner, int row) {
        String instanceName = this.getColumnData("CellInstanceName");
        String templateName = this.getColumnData("TemplateName");
        String w = this.getColumnData("Width");
        String h = this.getColumnData("Height");
        String sideName = this.getColumnData("Side");
        boolean status = true;
        if (instanceName.isEmpty()) {
            ALog.logWarn((String)("There is no CellInstanceName defined on row " + row + ", this device will be ignored"));
            status = false;
        }
        if (sideName.isEmpty()) {
            ALog.logWarn((String)("There is no Side defined on row " + row + ", this device will be ignored"));
            status = false;
        } else {
            sideName = sideName.toLowerCase();
            boolean validSide = false;
            if (sideName.contains("left")) {
                validSide = true;
            }
            if (sideName.contains("right")) {
                validSide = true;
            }
            if (sideName.contains("top")) {
                validSide = true;
            }
            if (sideName.contains("bottom")) {
                validSide = true;
            }
            if (!validSide) {
                ALog.logWarn((String)("Side of name " + sideName + " not recognized this device will be ignored"));
                status = false;
            }
        }
        if (templateName.isEmpty() && w.isEmpty() && h.isEmpty()) {
            ALog.logWarn((String)("There is no Template or dimensions defined on row " + row + " this device will be ignored"));
            status = false;
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean addDevice(Device owner, int row) {
        int localRow = row + 2;
        String ignore = this.getColumnData("Ignore");
        if (ignore != null && !(ignore = ignore.replace(" ", "")).isEmpty()) {
            return false;
        }
        if (!this.validateRow(owner, localRow)) {
            return false;
        }
        boolean createdPersonalityForBlank = false;
        String personalityName = this.getColumnData("Personality");
        Object instanceName = this.getColumnData("CellInstanceName");
        String templateName = this.getColumnData("TemplateName");
        String w = this.getColumnData("Width");
        String h = this.getColumnData("Height");
        String sideName = this.getColumnData("Side");
        Object pinName = this.getColumnData("PinName");
        String pinPersonalityName = this.getColumnData("PinPersonalityName");
        Object netName = this.getColumnData("NetName");
        String position = this.getColumnData("Position");
        String transformName = this.getColumnData("Transform");
        String pinType = this.getColumnData("PinType");
        String instances = this.getColumnData("Instances");
        DeviceTemplate dtSub = owner.getTemplate();
        sideName = sideName.toLowerCase();
        instances = instances.replaceAll(" ", "");
        int instanceCount = 0;
        boolean multipleInstances = false;
        String baseInstanceName = instanceName;
        String basePinName = pinName;
        String baseNetName = netName;
        if (!instances.isEmpty()) {
            instanceCount = Integer.parseInt(instances);
            multipleInstances = true;
        } else {
            instanceCount = 1;
        }
        Db db = owner.getDb();
        Design cd = Design.getDesign((Db)db);
        for (int iCount = 0; iCount < instanceCount; ++iCount) {
            PinTemplate dtp;
            Personality devicePersonality;
            String deSpacedInstanceName;
            if (multipleInstances) {
                instanceName = baseInstanceName + iCount;
                pinName = basePinName + iCount;
                netName = baseNetName + iCount;
                if (iCount >= 1) {
                    ++this.previousExtra;
                }
            }
            if (personalityName.isEmpty()) {
                if (this.mLastPersonalityWasBlank) {
                    if (this.mLastPersonality != null) {
                        personalityName = this.mLastPersonality.getName();
                    } else {
                        personalityName = Personality.getUniqueName((DeviceTemplate)dtSub, (Personality.Type)Personality.Type.DEVICE, (String)("NP" + sideName));
                        createdPersonalityForBlank = true;
                    }
                } else {
                    personalityName = Personality.getUniqueName((DeviceTemplate)dtSub, (Personality.Type)Personality.Type.DEVICE, (String)("NP" + sideName));
                    createdPersonalityForBlank = true;
                }
                this.mLastPersonalityWasBlank = true;
            } else {
                this.mLastPersonalityWasBlank = false;
            }
            String deSpacedDevicePersonalityName = this.deSpace(personalityName);
            Optional devicePersonalityOpt = Personality.getPersonality((DeviceTemplate)dtSub, (Personality.Type)Personality.Type.DEVICE, (String)deSpacedDevicePersonalityName);
            String deSpacedPinPersonalityName = this.deSpace(pinPersonalityName);
            Optional perOpt = Personality.getPersonality((DeviceTemplate)dtSub, (Personality.Type)Personality.Type.PORT, (String)deSpacedPinPersonalityName);
            Personality pinPersonality = perOpt.orElse(null);
            String deSpacedTemplateName = this.deSpace(templateName);
            DeviceTemplate dt = DeviceTemplate.getDeviceTemplate((Substrate)dtSub.getSubstrate(), (String)deSpacedTemplateName);
            if (dt == null) {
                if (w.isEmpty() || h.isEmpty()) {
                    ALog.logWarn((String)("A valid Template was not specified, and there is no width or height specified on row " + localRow));
                    return false;
                }
                if (!deSpacedTemplateName.isEmpty()) {
                    ALog.logWarn((String)("A template name of " + deSpacedTemplateName + " was specified on row " + localRow + " but does not exist in the design."));
                }
                dt = PartFactory.makeIOPadTemplate(owner, cd.getInternal(Double.valueOf(w).doubleValue()), cd.getInternal(Double.valueOf(h).doubleValue()), (String)pinName, true, null, true, deSpacedTemplateName);
            }
            boolean makeUniqueInstanceName = true;
            boolean madeAnInstance = false;
            if (((String)instanceName).isEmpty()) {
                instanceName = deSpacedDevicePersonalityName;
            }
            if ((deSpacedInstanceName = this.deSpace((String)instanceName)).charAt(0) == '$') {
                makeUniqueInstanceName = false;
                deSpacedInstanceName = deSpacedInstanceName.substring(1);
            }
            DeviceTemplate ownerDevT = owner.getTemplate();
            Device instance = ownerDevT.getChild(deSpacedInstanceName);
            Device nextInstance = ownerDevT.getChild(deSpacedInstanceName + "_0");
            if (instance == null && nextInstance == null) {
                instance = new Device(deSpacedInstanceName, owner.getTemplate(), dt);
                instance.setSourceType(Device.SourceType.DIESPREADSHEET);
                if (this.getColumnData("Decoration").equalsIgnoreCase("true")) {
                    instance.setSourceType(Device.SourceType.DECORATOR);
                }
                db.add((DbObject)instance);
                madeAnInstance = true;
            } else if (makeUniqueInstanceName) {
                instance = new Device(this.uniqueInstanceName(deSpacedInstanceName, owner.getTemplate()), owner.getTemplate(), dt);
                instance.setSourceType(Device.SourceType.DIESPREADSHEET);
                if (this.getColumnData("Decoration").equalsIgnoreCase("true")) {
                    instance.setSourceType(Device.SourceType.DECORATOR);
                }
                db.add((DbObject)instance);
                madeAnInstance = true;
            }
            if (madeAnInstance) {
                instance.addUnusedPins();
                String attr = this.getColumnData("Attribute");
                if (attr.toLowerCase().contains("overlay")) {
                    instance.setIsOverlay(true);
                }
            }
            if (!devicePersonalityOpt.isPresent()) {
                Color c;
                devicePersonality = new Personality(dtSub, Personality.Type.DEVICE, deSpacedDevicePersonalityName);
                if (createdPersonalityForBlank) {
                    devicePersonality.setSynthesizedByTool(true);
                }
                if ((c = AUtil.colorFromString((String)Personality.nextColor())) != null) {
                    devicePersonality.setColor(AUtil.makeTransparent((Color)c, (float)0.5f));
                }
                sideName = sideName.toLowerCase();
                devicePersonality.setValue("side", (Object)sideName.toLowerCase());
                devicePersonality.setValue("inset", (Object)this.getColumnData("PersonalityInset").toLowerCase());
                devicePersonality.setValue("gap", (Object)this.getColumnData("PersonalityGap").toLowerCase());
                Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)false);
                Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.DEVICE_MANAGED, (Object)true);
                String string = this.getColumnData("Attribute");
                if (string.toLowerCase().equals("hard")) {
                    Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)true);
                }
                this.mNewPersonality.add(devicePersonality);
                this.mLastPersonality = devicePersonality;
            } else {
                devicePersonality = (Personality)devicePersonalityOpt.get();
                if (this.mNewPersonality.contains(devicePersonality)) {
                    if (this.mLastPersonality == null) {
                        this.mLastPersonality = devicePersonality;
                    } else if (this.mLastPersonality != devicePersonality) {
                        ALog.logWarn((String)("The personality " + this.mLastPersonality.getName() + " is not contiguous in the spreadsheet on row " + localRow));
                        this.mLastPersonality = devicePersonality;
                    }
                } else {
                    sideName = sideName.toLowerCase();
                    devicePersonality.setValue("side", (Object)sideName.toLowerCase());
                    this.mNewPersonality.add(devicePersonality);
                    this.mLastPersonality = devicePersonality;
                }
                if (!devicePersonality.getValue("side").equals(sideName.toLowerCase())) {
                    sideName = sideName.toLowerCase();
                    String pName = this.getColumnData("Personality");
                    if (pName != null && !pName.isEmpty()) {
                        ALog.logWarn((String)("The personality " + devicePersonality.getName() + " is referenced with both " + devicePersonality.getValue("side") + " and " + sideName.toLowerCase() + " on row " + localRow));
                    }
                    personalityName = Personality.getUniqueName((DeviceTemplate)dtSub, (Personality.Type)Personality.Type.DEVICE, (String)("NP" + sideName));
                    deSpacedDevicePersonalityName = this.deSpace(personalityName);
                    devicePersonality = new Personality(dtSub, Personality.Type.DEVICE, deSpacedDevicePersonalityName);
                    db.add((DbObject)devicePersonality);
                    devicePersonality.setSynthesizedByTool(true);
                    Color color = AUtil.colorFromString((String)Personality.nextColor());
                    if (color != null) {
                        devicePersonality.setColor(AUtil.makeTransparent((Color)color, (float)0.5f));
                    }
                    sideName = sideName.toLowerCase();
                    devicePersonality.setValue("side", (Object)sideName.toLowerCase());
                    devicePersonality.setValue("inset", (Object)this.getColumnData("PersonalityInset").toLowerCase());
                    devicePersonality.setValue("gap", (Object)this.getColumnData("PersonalityGap").toLowerCase());
                    Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)false);
                    Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.DEVICE_MANAGED, (Object)true);
                    String attr = this.getColumnData("Attribute");
                    if (attr.toLowerCase().equals("hard")) {
                        Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)true);
                    }
                    this.mNewPersonality.add(devicePersonality);
                    this.mLastPersonality = devicePersonality;
                }
            }
            if (!transformName.isEmpty()) {
                boolean setValue = false;
                for (AGeomUtil.Orient orient : AGeomUtil.Orient.values()) {
                    if (!orient.name().equalsIgnoreCase(transformName)) continue;
                    instance.setRotate((float)orient.getOrientRotation());
                    instance.setMirror(orient.getOrientMirror());
                    setValue = true;
                }
                if (!setValue) {
                    ALog.logWarn((String)("Transform of " + transformName + " not recognized on row " + localRow));
                }
            }
            if (!pinPersonalityName.isEmpty() && pinPersonality == null) {
                pinPersonality = new Personality(dtSub, Personality.Type.PORT, deSpacedPinPersonalityName);
                Color c = AUtil.colorFromString((String)Personality.nextColor());
                if (c != null) {
                    pinPersonality.setValue("color", (Object)c);
                }
            }
            if ((dtp = dt.getPinByName((String)pinName)) == null) {
                dtp = PartFactory.makeIOPadPinTemplate(dt, (String)pinName, true, null, true);
            }
            Object var43_52 = null;
            if (dtp != null) {
                if (instance.getPinByName((String)pinName) == null) {
                    PinInstance.create((Db)db, (String)pinName, (Device)instance, (PinTemplate)dtp);
                }
                dtp.setValue("SpreadSheet", (Object)true);
                if (!pinType.isEmpty()) {
                    dtp.setType(PinTemplate.Type.valueOf((String)pinType));
                } else {
                    dtp.setType(PinTemplate.Type.IOPAD);
                }
                for (PinInstance p2 : instance.getPins()) {
                    if (p2.getPinTemplate() != dtp) continue;
                    p2.assignToPersonality(pinPersonality);
                    if (((String)netName).isEmpty()) continue;
                    p2.setValue("deferredNet", netName);
                }
                String diffPair = this.getColumnData("DiffPair");
                if (!diffPair.isEmpty() && netName != null && !((String)netName).isEmpty()) {
                    void var43_55;
                    DeviceTemplate dieTemplate = this.mDevicePath.getDeviceTemplate();
                    Net net = dieTemplate.getNet((String)netName);
                    if (net == null) {
                        Net net2 = Net.create((DeviceTemplate)dieTemplate, (String)netName);
                    }
                    Personality netPersonality = Personality.getOrCreate((DeviceTemplate)instance.getTemplate(), (Personality.Type)Personality.Type.NET, (String)diffPair, p -> {
                        Color c = AUtil.colorFromString((String)Personality.nextColor());
                        if (c != null) {
                            p.setColor(c);
                        }
                        Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH, (Object)true);
                    });
                    var43_55.assignToPersonality(netPersonality, null);
                }
            }
            if (madeAnInstance) {
                instance.setIsPlaced(false);
                instance.assignToPersonality(devicePersonality);
                instance.moveTo(0L, 0L);
                instance.setMajorSlot(row + this.previousExtra);
                instance.setMinorSlot(0);
                instance.setValue("side", (Object)this.getColumnData("Side").toLowerCase());
                if (!position.isEmpty()) {
                    Constraint.setConstraintValue((DbObject)devicePersonality, (Constraint.Descriptor)Constraint.POSITION, (Object)position);
                    if (position.equalsIgnoreCase("overlay")) {
                        instance.setMajorSlot(row - 1 + this.previousExtra);
                        instance.setMinorSlot(1);
                    }
                }
                String inset = this.getColumnData("Inset");
                String gap = this.getColumnData("Gap");
                this.mCurrentMajorSlot = instance.getMajorSlot();
                if (!pinType.isEmpty()) {
                    if (dtp != null) {
                        dtp.setType(PinTemplate.Type.valueOf((String)pinType));
                    }
                } else if (dtp != null) {
                    dtp.setType(PinTemplate.Type.IOPAD);
                }
                if (!inset.isEmpty()) {
                    instance.setValue("inset", (Object)inset);
                }
                if (!gap.isEmpty()) {
                    instance.setValue("gap", (Object)gap);
                }
            }
            String addInstance = this.getColumnData("AddInstanceName");
            String addTemplate = this.getColumnData("AddTemplateName");
            String aPinType = this.getColumnData("AddPinType");
            addTemplate = addTemplate.replaceAll(" ", "");
            if (!addInstance.isEmpty() && !addTemplate.isEmpty()) {
                DeviceTemplate dtAdd = DeviceTemplate.getDeviceTemplate((Substrate)dtSub.getSubstrate(), (String)addTemplate);
                if (dtAdd != null) {
                    String addTransformName;
                    instance = new Device(this.uniqueInstanceName(addInstance, owner.getTemplate()), owner.getTemplate(), dtAdd);
                    instance.setSourceType(Device.SourceType.DIESPREADSHEET);
                    db.add((DbObject)instance);
                    instance.addUnusedPins();
                    instance.setIsPlaced(false);
                    instance.assignToPersonality(devicePersonality);
                    instance.moveTo(0L, 0L);
                    instance.setMajorSlot(this.mCurrentMajorSlot);
                    instance.setMinorSlot(1);
                    String addInset = this.getColumnData("AddInset");
                    String addGap = this.getColumnData("AddGap");
                    instance.setValue("side", (Object)this.getColumnData("Side").toLowerCase());
                    if (!addInset.isEmpty()) {
                        instance.setValue("inset", (Object)addInset);
                    }
                    if (!addGap.isEmpty()) {
                        instance.setValue("gap", (Object)addGap);
                    }
                    if (!(addTransformName = this.getColumnData("AddTransform")).isEmpty()) {
                        boolean setValue = false;
                        for (AGeomUtil.Orient orient : AGeomUtil.Orient.values()) {
                            if (!orient.name().equalsIgnoreCase(addTransformName)) continue;
                            instance.setRotate((float)orient.getOrientRotation());
                            instance.setMirror(orient.getOrientMirror());
                            setValue = true;
                        }
                        if (!setValue) {
                            ALog.logWarn((String)("Transform of " + addTransformName + " not recognized on row " + localRow));
                        }
                    }
                    String addPinPersonalityName = this.getColumnData("AddPinPersonalityName");
                    Personality addPinPersonality = null;
                    if (!addPinPersonalityName.isEmpty()) {
                        String deSpacedAddPinPersonalityName = this.deSpace(addPinPersonalityName);
                        addPinPersonality = Personality.getOrCreate((DeviceTemplate)dtSub, (Personality.Type)Personality.Type.PORT, (String)deSpacedAddPinPersonalityName, p -> {
                            Color c = AUtil.colorFromString((String)Personality.nextColor());
                            if (c != null) {
                                p.setColor(c);
                            }
                        });
                    }
                    String addPinName = this.getColumnData("AddPinName");
                    PinTemplate adtp = null;
                    if (!addPinName.isEmpty() && (adtp = dtAdd.getPinByName(addPinName)) != null) {
                        adtp.setValue("SpreadSheet", (Object)true);
                        PinInstance theDp = null;
                        for (PinInstance p3 : instance.getPins()) {
                            if (p3.getPinTemplate() != adtp) continue;
                            theDp = p3;
                            break;
                        }
                        if (theDp != null) {
                            if (addPinPersonality != null) {
                                theDp.assignToPersonality(addPinPersonality);
                            }
                            if (!((String)netName).isEmpty()) {
                                theDp.setValue("deferredNet", netName);
                            }
                        }
                    }
                    if (aPinType.isEmpty() || adtp == null) continue;
                    adtp.setType(PinTemplate.Type.valueOf((String)aPinType));
                    continue;
                }
                ALog.logWarn((String)("A template name of " + addTemplate + " was specified on row " + localRow + " but does not exist in the design."));
                continue;
            }
            if (addInstance.isEmpty() && !addTemplate.isEmpty()) {
                ALog.logWarn((String)("There is no AddInstanceName defined on row " + localRow + ", this additional device will be ignored."));
                continue;
            }
            if (addInstance.isEmpty() || !addTemplate.isEmpty()) continue;
            ALog.logWarn((String)("There is no AddTemplateName defined on row " + localRow + ", this additional device will be ignored."));
        }
        return true;
    }

    protected ArrayList<Personality> buildPSide(int side, String ring) {
        Object regex;
        ArrayList<Personality> pList = new ArrayList<Personality>();
        switch (side) {
            case 3: {
                regex = "^left(\\s*|_)" + ring + "$";
                break;
            }
            case 0: {
                regex = "^bottom(\\s*|_)" + ring + "$";
                break;
            }
            case 1: {
                regex = "^right(\\s*|_)" + ring + "$";
                break;
            }
            case 2: {
                regex = "^top(\\s*|_)" + ring + "$";
                break;
            }
            default: {
                regex = ".*";
            }
        }
        Pattern pattern = Pattern.compile((String)regex);
        for (Personality p : this.mNewPersonality) {
            String s = ((String)p.getValue("side")).toLowerCase();
            if (!pattern.matcher(s).matches()) continue;
            pList.add(p);
        }
        return pList;
    }

    public ArrayList<Long> placePersonalities(ARect r) {
        Device lastPD = null;
        Design cd = Design.getDesign((Db)OrbitIO.getCurDb());
        int ring = 0;
        boolean moreRings = true;
        ArrayList<Long> requiredRoomOnSide = new ArrayList<Long>();
        for (int i = 0; i < 4; ++i) {
            requiredRoomOnSide.add(i, 0L);
        }
        while (moreRings) {
            moreRings = false;
            lastPD = null;
            for (int side = 0; side < 4; ++side) {
                long lastW = 0L;
                long lastH = 0L;
                if (lastPD != null) {
                    lastH = lastPD.getLocalBB().height();
                    lastW = lastPD.getLocalBB().width();
                }
                lastPD = null;
                long x = 0L;
                long y = 0L;
                long dx = 0L;
                long dy = 0L;
                long rot = 0L;
                long xAdj = 0L;
                long yAdj = 0L;
                long xEnd = 0L;
                long yEnd = 0L;
                long xStart = 0L;
                long yStart = 0L;
                boolean mirror = false;
                if (side == 0) {
                    x = xStart = r.left();
                    y = yStart = r.bottom();
                    xEnd = r.right();
                    yEnd = yStart;
                    dx = 1L;
                    dy = 0L;
                    rot = 0L;
                } else if (side == 1) {
                    x = xStart = r.right();
                    y = r.bottom() + lastH;
                    yStart = r.bottom();
                    xEnd = r.right();
                    yEnd = r.top();
                    rot = 270L;
                    dx = 0L;
                    dy = 1L;
                } else if (side == 2) {
                    x = r.right() - lastW;
                    xStart = r.right();
                    y = yStart = r.top();
                    xEnd = r.left();
                    yEnd = r.top();
                    dx = -1L;
                    dy = 0L;
                    mirror = false;
                    rot = 180L;
                    xAdj = 0L;
                    yAdj = 0L;
                } else if (side == 3) {
                    x = xStart = r.left();
                    y = r.top() - lastH;
                    yStart = r.top();
                    xEnd = r.left();
                    yEnd = r.bottom();
                    dx = 0L;
                    dy = -1L;
                    rot = 90L;
                    xAdj = 0L;
                    yAdj = 0L;
                }
                String ringString = ring == 0 ? "" : Integer.toString(ring);
                ArrayList<Personality> pSide = this.buildPSide(side, ringString);
                if (pSide.size() > 0) {
                    moreRings = true;
                }
                for (int i = 0; i < pSide.size(); ++i) {
                    Optional<HierInst> hInst;
                    Device pd;
                    Personality p = pSide.get(i);
                    String position = "";
                    Constraint c = Constraint.getConstraint((Db)p.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.POSITION);
                    if (c != null) {
                        position = (String)c.getValue();
                    }
                    Device device = pd = (hInst = p.getObjects().filter(hi -> ((DevicePath)hi.first).equals((Object)this.mDevicePath)).findFirst()).isPresent() ? ((Device)hInst.get().second).getAParentDevice() : null;
                    if (pd == null) continue;
                    long startX = pd.getTemplate().getBB().left();
                    if (startX != 0L) {
                        ARect adjustedR = new ARect(pd.getTemplate().getBB());
                        long width = adjustedR.width();
                        adjustedR.left(0L);
                        adjustedR.right(width);
                        pd.getTemplate().setBounds((AGeom)adjustedR);
                        ALog.logInfo((String)("adjusting " + p.getName() + " by " + startX));
                        p.getObjects().filter(hi -> ((DevicePath)hi.first).equals((Object)this.mDevicePath)).forEach(hi -> {
                            Device d = (Device)hi.second;
                            d.moveBy(-startX, 0L);
                        });
                        x += startX * dx;
                        y += startX * dy;
                    }
                    pd.setRotate((float)rot);
                    pd.setMirror(mirror);
                    if (!position.equals("corner")) {
                        String gapS;
                        pd.moveTo(x, y);
                        pd.moveBy(xAdj * pd.getLocalBB().width(), yAdj * pd.getLocalBB().height());
                        String insetS = (String)p.getValue("inset");
                        if (insetS != null && !insetS.isEmpty()) {
                            double insetD = Double.parseDouble(insetS);
                            long inset = cd.getInternal(insetD);
                            if (side == 0) {
                                pd.moveBy(0L, inset);
                            } else if (side == 1) {
                                pd.moveBy(-inset, 0L);
                            } else if (side == 2) {
                                pd.moveBy(0L, -inset);
                            } else {
                                pd.moveBy(inset, 0L);
                            }
                        }
                        if ((gapS = (String)p.getValue("gap")) != null && !gapS.isEmpty()) {
                            double gapD = Double.parseDouble(gapS);
                            long gap = cd.getInternal(gapD);
                            if (side == 0) {
                                pd.moveBy(gap, 0L);
                            } else if (side == 1) {
                                pd.moveBy(0L, gap);
                            } else if (side == 2) {
                                pd.moveBy(-gap, 0L);
                            } else {
                                pd.moveBy(0L, -gap);
                            }
                        }
                        long cx = dx < 0L ? pd.getLocalBB().left() : (dx > 0L ? pd.getLocalBB().right() : x);
                        long cy = dy < 0L ? pd.getLocalBB().bottom() : (dy > 0L ? pd.getLocalBB().top() : y);
                        x = dx < 0L ? Math.min(x, cx) : Math.max(x, cx);
                        y = dy < 0L ? Math.min(y, cy) : Math.max(y, cy);
                    } else if (position.equals("corner")) {
                        long thisY;
                        pd.setIsFixed(true);
                        if (i == 0) {
                            long thisX = x = xStart;
                            thisY = y = yStart;
                            pd.moveTo(thisX, thisY);
                            x += dx * pd.getLocalBB().width();
                            y += dy * pd.getLocalBB().height();
                            lastW = 0L;
                            lastH = 0L;
                        } else {
                            long thisX = xEnd;
                            thisY = yEnd;
                            pd.moveTo(thisX += -dx * pd.getLocalBB().width(), thisY += -dy * pd.getLocalBB().height());
                        }
                    }
                    lastPD = pd;
                }
                if (side % 2 == 0) {
                    requiredRoomOnSide.set(side, Math.max(requiredRoomOnSide.get(side), Math.abs(x - xStart)));
                    continue;
                }
                requiredRoomOnSide.set(side, Math.max(requiredRoomOnSide.get(side), Math.abs(y - yStart)));
            }
            ++ring;
        }
        return requiredRoomOnSide;
    }

    public String deSpace(String s) {
        Object r = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || (short)c >= 128) continue;
            r = (String)r + s.charAt(i);
        }
        return r;
    }

    protected String getColumnData(String colName) {
        try {
            return this.mDocument.getItemValue(this.mCurrentItemIndex, colName);
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
            return "";
        }
    }

    protected int getQuadrant(APoint2D loc, ARect ref) {
        ALine v = new ALine(ref.center(), loc);
        double av = v.getAngle();
        ALine vur = new ALine(ref.center(), ref.getUR());
        double aur = vur.getAngle();
        double alr = 360.0 - aur;
        double all = 180.0 + aur;
        double aul = 180.0 - aur;
        if (av >= 0.0 && av < aur) {
            return 0;
        }
        if (av >= aur && av < aul) {
            return 1;
        }
        if (av >= aul && av < all) {
            return 2;
        }
        if (av >= all && av < alr) {
            return 3;
        }
        return 0;
    }

    protected void setNetThrough(HierPin dpp, String netName) {
        DevicePath dpath = dpp.getPath();
        PinInstance dp = dpp.getPin();
        Net net = dp.getNet();
        NetMap.mapThroughPath((DevicePath)dpath, (Net)net, (String)netName);
    }

    public static void test(String inFile, String outFile) {
        File fi = new File(inFile);
        File fo = new File(outFile);
        FileInputStream fis = null;
        FileInputStream fos = null;
        try {
            fis = new FileInputStream(fi);
            fos = new FileInputStream(fo);
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to read.", (Object[])new Object[0]);
            return;
        }
        try (CSVReader readerIn = new CSVReader((Reader)new InputStreamReader(fis));
             CSVReader readerOut = new CSVReader((Reader)new InputStreamReader(fos));){
            String[] row;
            String[] colNames = new String[]{"templatename", "width", "height", "side", "pinname", "pinpersonalityname", "pintype", "netname", "position", "transform", "inset", "gap", "addinstancename", "addtemplatename", "addinset", "addgap", "addpinname", "addpinpersonalityname", "addpintype", "addtransform"};
            String[] columnsIn = readerIn.readNext();
            String[] columnsOut = readerOut.readNext();
            ArrayList<String> headerIn = new ArrayList<String>();
            for (String s : columnsIn) {
                headerIn.add(s.toLowerCase());
            }
            ArrayList<String> headerOut = new ArrayList<String>();
            for (String s : columnsOut) {
                headerOut.add(s.toLowerCase());
            }
            HashMap<String, ArrayList<String>> mapOut = new HashMap<String, ArrayList<String>>();
            while ((row = readerOut.readNext()) != null) {
                ArrayList<String> a = new ArrayList<String>(Arrays.asList(row));
                int i = headerOut.indexOf("personality");
                String personality = i < a.size() ? a.get(i) : "";
                i = headerOut.indexOf("cellinstancename");
                String cellName = i < a.size() ? a.get(i) : "";
                i = headerOut.indexOf("addinstancename");
                String addCellName = i < a.size() ? a.get(i) : "";
                String key = String.format("%s_%s_%s", personality, cellName, addCellName).toLowerCase();
                mapOut.put(key, a);
            }
            int i = 1;
            HashSet<Object> keys = new HashSet<Object>();
            while ((row = readerIn.readNext()) != null) {
                ArrayList out;
                ++i;
                ArrayList<String> a = new ArrayList<String>(Arrays.asList(row));
                int n = headerIn.indexOf("personality");
                String personality = n < a.size() ? (String)a.get(n) : "";
                n = headerIn.indexOf("cellinstancename");
                String cellName = n < a.size() ? (String)a.get(n) : "";
                n = headerIn.indexOf("addinstancename");
                String addCellName = n < a.size() ? (String)a.get(n) : "";
                Object key = String.format("%s_%s_%s", personality, cellName, addCellName).toLowerCase();
                boolean existed = true;
                if (keys.contains(key)) {
                    String m = (String)key + "_0";
                    keys.add(m);
                    keys.remove(key);
                } else {
                    keys.add(key);
                    existed = false;
                }
                int k = 0;
                if (keys.contains((String)key + "_0")) {
                    String kk = (String)key + "_" + ++k;
                    while (keys.contains(kk)) {
                        kk = (String)key + "_" + ++k;
                    }
                    key = kk;
                    keys.add(key);
                }
                if ((out = (ArrayList)mapOut.get(key)) == null && !existed) {
                    out = (ArrayList)mapOut.get((String)key + "_0");
                }
                if (out == null) {
                    int m = headerIn.indexOf("addtemplatename");
                    String tpl = m < a.size() ? (String)a.get(m) : "";
                    ALog.logError((String)("Can not found " + (String)key + " addtemplate : " + tpl + " on row " + i));
                    continue;
                }
                for (int j = 0; j < colNames.length; ++j) {
                    int ii = headerIn.indexOf(colNames[j]);
                    int io = headerOut.indexOf(colNames[j]);
                    if (ii < 0) {
                        ALog.logError((String)("can not found column " + colNames[j] + " in " + inFile));
                        continue;
                    }
                    if (io < 0) {
                        System.out.println("can not found column " + colNames[j] + " in " + outFile);
                        continue;
                    }
                    String ci = ii < a.size() ? (String)a.get(ii) : "";
                    String co = io < out.size() ? (String)out.get(io) : "";
                    double d1 = 0.0;
                    double d2 = 0.0;
                    boolean isNum = false;
                    try {
                        d1 = ci == null || ci.isEmpty() ? 0.0 : Double.parseDouble(ci);
                        d2 = co == null || co.isEmpty() ? 0.0 : Double.parseDouble(co);
                        isNum = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if ((!isNum || d1 == d2) && (isNum || ci == null || ci.equalsIgnoreCase(co))) continue;
                    String s = String.format("!= : column: %s row: %d in: %s out %s", colNames[j], i, ci, co);
                    ALog.logDebug((String)s);
                }
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error reading input file.", (Object[])new Object[0]);
        }
    }

    protected class PositionInfo {
        protected ArrayList<AdditionInfo> mAdditionInfos = new ArrayList();
        protected ArrayList<Device> mAddDevices = new ArrayList();
        protected float mGap = 0.0f;
        protected float mInset = 0.0f;
        protected Device mMainDevice = null;

        public PositionInfo(float gap, float inset, Device mainDevice, ArrayList<Device> addDevices) {
            this.mGap = gap;
            this.mInset = inset;
            this.mMainDevice = mainDevice;
            this.mAddDevices.addAll(addDevices);
            this.init();
        }

        /*
         * WARNING - void declaration
         */
        private void init() {
            ArrayList<PinInstance> mainPins = new ArrayList<PinInstance>();
            HashMap<Device, ArrayList<PinInstance>> addPins = new HashMap<Device, ArrayList<PinInstance>>();
            for (PinInstance pinInstance : this.mMainDevice.getPins()) {
                Boolean bl = (Boolean)pinInstance.getPinTemplate().getValue("SpreadSheet");
                if (bl == null || !bl.booleanValue()) continue;
                mainPins.add(pinInstance);
            }
            for (Device device : this.mAddDevices) {
                for (PinInstance p : device.getPins()) {
                    Boolean b = (Boolean)p.getPinTemplate().getValue("SpreadSheet");
                    if (b == null || !b.booleanValue()) continue;
                    ArrayList<PinInstance> ps = (ArrayList<PinInstance>)addPins.get(device);
                    if (ps == null) {
                        ps = new ArrayList<PinInstance>();
                        addPins.put(device, ps);
                    }
                    ps.add(p);
                }
            }
            if (mainPins.isEmpty() && addPins.isEmpty()) {
                for (PinInstance pinInstance : this.mMainDevice.getPins()) {
                    if (!this.isOutputPin(pinInstance)) continue;
                    mainPins.add(pinInstance);
                }
                for (Device device : this.mAddDevices) {
                    for (PinInstance p : device.getPins()) {
                        if (!this.isOutputPin(p)) continue;
                        ArrayList<PinInstance> ps = (ArrayList<PinInstance>)addPins.get(device);
                        if (ps == null) {
                            ps = new ArrayList<PinInstance>();
                            addPins.put(device, ps);
                        }
                        ps.add(p);
                    }
                }
                if (mainPins.isEmpty() || addPins.isEmpty()) {
                    Net n;
                    HashSet topNets = new HashSet();
                    for (PinInstance pinInstance : mainPins) {
                        Net n2 = NetMap.getTopmostNet((Net)pinInstance.getNet(), (DevicePath)this.mMainDevice.getADevicePath());
                        topNets.add(n2);
                    }
                    for (Device device : this.mAddDevices) {
                        for (PinInstance p : device.getPins()) {
                            n = NetMap.getTopmostNet((Net)p.getNet(), (DevicePath)device.getADevicePath());
                            topNets.add(n);
                        }
                    }
                    if (mainPins.isEmpty()) {
                        for (PinInstance pinInstance : this.mMainDevice.getPins()) {
                            Iterator n2 = NetMap.getTopmostNet((Net)pinInstance.getNet(), (DevicePath)this.mMainDevice.getADevicePath());
                            if (!topNets.contains(n2)) continue;
                            mainPins.add(pinInstance);
                        }
                    }
                    if (addPins.isEmpty()) {
                        for (Device device : this.mAddDevices) {
                            for (PinInstance p : device.getPins()) {
                                n = NetMap.getTopmostNet((Net)p.getNet(), (DevicePath)device.getADevicePath());
                                if (!topNets.contains(n)) continue;
                                ArrayList ps = (ArrayList)addPins.get(device);
                                if (ps == null) {
                                    ps = new ArrayList();
                                    addPins.put(device, ps);
                                }
                                ps.add(p);
                            }
                        }
                    }
                }
            }
            if (mainPins.isEmpty()) {
                ALog.logWarn((String)(this.mMainDevice.getADevicePath() + " does not have a IOPAD, WIREBONDPAD or BUMPPAD pad definition."));
            }
            for (Device device : this.mAddDevices) {
                if (!((ArrayList)addPins.get(device)).isEmpty()) continue;
                ALog.logWarn((String)(device.getADevicePath() + " does not have a IOPAD, WIREBONDPAD or BUMPPAD pad definition."));
            }
            Comparator<PinInstance> portSorter = new Comparator<PinInstance>(){

                @Override
                public int compare(PinInstance p1, PinInstance p2) {
                    return Long.compare(p1.getLocalLoc().getX(), p2.getLocalLoc().getX());
                }
            };
            Collections.sort(mainPins, portSorter);
            for (Device device : this.mAddDevices) {
                Collections.sort((List)addPins.get(device), portSorter);
            }
            if (mainPins.isEmpty() && this.mAddDevices.isEmpty()) {
                AdditionInfo additionInfo = new AdditionInfo(null, null, null, null, 0.0f, 0.0f);
                this.mAdditionInfos.add(additionInfo);
            } else {
                void var5_44;
                void var5_42;
                Port2AddDevice pd2;
                void var5_40;
                ArrayList<Port2AddDevice> arrayList = new ArrayList<Port2AddDevice>();
                for (PinInstance p : mainPins) {
                    AGeom g = p.getWorldShape(this.mMainDevice.getADevicePath());
                    if (g instanceof ACompositeGeom) {
                        ACompositeGeom cg = (ACompositeGeom)g;
                        for (AGeom geom : cg.getChildren()) {
                            arrayList.add(new Port2AddDevice(p, null, geom));
                        }
                        continue;
                    }
                    arrayList.add(new Port2AddDevice(p, null, g));
                }
                for (Device d : this.mAddDevices) {
                    ARect bb = d.getADevicePath().getBB();
                    arrayList.add(new Port2AddDevice(null, d, (AGeom)bb));
                }
                Collections.sort(arrayList, new Comparator<Port2AddDevice>(){

                    @Override
                    public int compare(Port2AddDevice p1, Port2AddDevice p2) {
                        return Long.compare(p1.mGeom.getBounds().left(), p2.mGeom.getBounds().left());
                    }
                });
                boolean bl = true;
                while (var5_40 < arrayList.size()) {
                    boolean isPort2;
                    Port2AddDevice pd1 = (Port2AddDevice)arrayList.get((int)(var5_40 - true));
                    boolean isPort1 = pd1.mMainPort != null;
                    pd2 = (Port2AddDevice)arrayList.get((int)var5_40);
                    boolean bl2 = isPort2 = pd2.mMainPort != null;
                    if (isPort1 ^ isPort2 && pd2.mGeom.getBounds().right() <= pd1.mGeom.getBounds().right()) {
                        if (isPort2) {
                            pd1.mMainPort = pd2.mMainPort;
                        } else {
                            pd1.mAddDevice = pd2.mAddDevice;
                        }
                        arrayList.remove((int)var5_40);
                    }
                    ++var5_40;
                }
                boolean bl3 = false;
                while (var5_42 < arrayList.size()) {
                    Port2AddDevice pd = (Port2AddDevice)arrayList.get((int)var5_42);
                    if (pd.mMainPort != null) {
                        void j = var5_42 + true;
                        while (j < arrayList.size()) {
                            pd2 = (Port2AddDevice)arrayList.get((int)j);
                            if (pd2.mAddDevice == null && pd2.mMainPort == pd.mMainPort) {
                                arrayList.remove((int)j);
                                continue;
                            }
                            ++j;
                        }
                    }
                    ++var5_42;
                }
                boolean bl4 = false;
                while (var5_44 < arrayList.size()) {
                    Net mainNet = null;
                    Port2AddDevice pd = (Port2AddDevice)arrayList.get((int)var5_44);
                    PinInstance mainPin = pd.mMainPort;
                    Device addDevice = pd.mAddDevice;
                    ArrayList pins = addDevice != null ? (ArrayList)addPins.get(addDevice) : new ArrayList();
                    if (pins.size() == 0) {
                        pins.add(null);
                    }
                    for (PinInstance addPin : pins) {
                        if (mainPin != null) {
                            mainNet = NetMap.getTopmostNet((Net)mainPin.getNet(), (DevicePath)this.mMainDevice.getADevicePath());
                        }
                        if ((mainNet == null || mainNet.isUnused()) && addPin != null) {
                            mainNet = NetMap.getTopmostNet((Net)addPin.getNet(), (DevicePath)addDevice.getADevicePath());
                        }
                        if (mainNet != null && mainNet.isUnused()) {
                            mainNet = null;
                        }
                        AdditionInfo info = new AdditionInfo(mainPin, mainNet, addDevice, addPin, 0.0f, 0.0f);
                        this.mAdditionInfos.add(info);
                    }
                    ++var5_44;
                }
            }
        }

        private boolean isOutputPin(PinInstance p) {
            PinTemplate dtp = p.getPinTemplate();
            PinTemplate.Type t = dtp.getType();
            return t == PinTemplate.Type.WIREBONDPAD || t == PinTemplate.Type.BUMPPAD || t == PinTemplate.Type.IOPAD;
        }

        class Port2AddDevice {
            protected PinInstance mMainPort;
            protected Device mAddDevice;
            protected AGeom mGeom;

            public Port2AddDevice(PinInstance mainPort, Device addDevice, AGeom geom) {
                this.mMainPort = mainPort;
                this.mAddDevice = addDevice;
                this.mGeom = geom;
            }
        }

        protected class AdditionInfo {
            protected PinInstance mMainPin = null;
            protected Net mMainNet = null;
            protected Device mAddDevice = null;
            protected PinInstance mAddPin = null;
            protected float mAddGap = 0.0f;
            protected float mAddInset = 0.0f;

            public AdditionInfo(PinInstance mainPin, Net mainNet, Device addDevice, PinInstance addPin, float addGap, float addInset) {
                this.mMainPin = mainPin;
                this.mMainNet = mainNet;
                this.mAddDevice = addDevice;
                this.mAddPin = addPin;
                this.mAddGap = addGap;
                this.mAddInset = addInset;
            }
        }
    }

    protected class DevicePathSortH
    implements Comparator<DevicePath> {
        boolean mIncreasing;

        public DevicePathSortH(boolean increasing) {
            this.mIncreasing = increasing;
        }

        @Override
        public int compare(DevicePath o1, DevicePath o2) {
            long d = o1.getBB().left() - o2.getBB().left();
            if (!this.mIncreasing) {
                d = -d;
            }
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        }
    }

    protected class DevicePathSortV
    implements Comparator<DevicePath> {
        boolean mIncreasing;

        public DevicePathSortV(boolean increasing) {
            this.mIncreasing = increasing;
        }

        @Override
        public int compare(DevicePath o1, DevicePath o2) {
            long d = o1.getBB().top() - o2.getBB().top();
            if (!this.mIncreasing) {
                d = -d;
            }
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

