/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.xml.AXmlUtil;
import com.sigrity.orbit.AlphabetFull;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ImportSpreadsheetReader;
import com.sigrity.orbit.ui.SymbolSpreadsheet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rx.Observable;
import rx.subjects.PublishSubject;

public class ExportSymbolSpreadsheet
extends SymbolSpreadsheet {
    public static final int EXCEL_START_ROW = 4;
    public static final int EXCEL_START_COL = 4;
    public static final String EXCEL_XML_VERSION = "1.0";
    public static final String EXCEL_XML_SPREADSHEET_NS = "urn:schemas-microsoft-com:office:spreadsheet";
    public static final String EXCEL_XML_OFFICE_NS = "urn:schemas-microsoft-com:office:office";
    public static final String EXCEL_XML_EXCEL_NS = "urn:schemas-microsoft-com:office:excel";
    public static final String EXCEL_XML_NS_URL = "http://www.w3.org/TR/REC-html40";
    public static final String EXCEL_DEFAULT_PIN_STYLE = "Pin";
    public static final String EXCEL_CELL_DEFAULT_WIDTH = "80";
    public static final String EXCEL_CELL_DEFAULT_HEIGHT = "60";
    protected static ExcelXmlWriter mXmlWriter = null;
    protected static AFileChooser mFileChooser = null;
    protected static JCheckBox mInsertSheet;
    protected static boolean mInsertFlag;
    protected static JCheckBox mOpenExcel;
    protected static boolean mOpenExcelFlag;
    protected static JTextField mDisplayText;
    protected static JComboBox<String> mPTextCombo;
    protected static JComboBox<String> mSTextCombo;
    protected static JComboBox<String> mTTextCombo;
    protected static String mPTextStr;
    protected static String mSTextStr;
    protected static String mTTextStr;
    protected static final String[] mFieldTextList;
    protected static JComboBox<String> mColorSourceCombo;
    protected static String mColorSource;
    protected static final String[] mColorSourceList;
    protected static boolean mApplyHeaders;
    protected static long mMaxColumns;
    protected static long mMaxRows;
    protected static HashMap<Long, String> mRowHeaderList;
    protected static HashMap<Long, String> mColHeaderList;
    protected static ActionListener mInsertListener;
    protected static ActionListener mPTextListener;
    protected static ActionListener mSTextListener;
    protected static ActionListener mTTextListener;
    protected static ActionListener mColorSourceListener;
    protected static ActionListener mOpenExcelListener;

    public static void getData(String fieldName1, String fieldName2, String fieldName3, String colorSource) {
        ExportSymbolSpreadsheet.derivePinData(colorSource);
        if (mApplyHeaders) {
            if (ExportSymbolSpreadsheet.checkHeadersOk(true) && ExportSymbolSpreadsheet.checkHeadersOk(false)) {
                mMaxRows += 2L;
                mMaxColumns += 2L;
                ExportSymbolSpreadsheet.adjustPinRowsAndColumns();
                ExportSymbolSpreadsheet.createHeaderRowColumnCells();
            } else {
                mApplyHeaders = false;
            }
        }
        if (!mApplyHeaders) {
            ALog.logInfo((String)"Note that row and column headers could not be generated from the pin names of this package device, so please select pin name as part of the primary or secondary text.");
        }
        ExportSymbolSpreadsheet.createPinRowsAndCells(fieldName1, fieldName2, fieldName3);
        ExportSymbolSpreadsheet.createLegendCells();
    }

    private static void derivePinData(String colorSource) {
        long llX = Long.MAX_VALUE;
        long llY = Long.MIN_VALUE;
        long brX = Long.MIN_VALUE;
        long brY = Long.MAX_VALUE;
        long pinSize = Long.MAX_VALUE;
        long xPitch = 0L;
        long yPitch = 0L;
        long numRows = 0L;
        long numColumns = 0L;
        if (mDevicePath == null) {
            return;
        }
        Substrate subst = mDevicePath.getDevice().getSubstrate();
        for (DevicePath path : mDevicePath.getDescendants(true)) {
            if (path.getDevice().getSubstrate() != subst) continue;
            for (PinInstance pin : path.getLast().getPins()) {
                Net net;
                long pinHeight;
                long pinWidth;
                long minDim;
                PinTemplate pt;
                if (pin.getType() != PinTemplate.Type.BALLPAD || (pt = pin.getPinTemplate()) == null) continue;
                if (llX > pin.getLoc().getX()) {
                    llX = pin.getLoc().getX();
                }
                if (llY < pin.getLoc().getY()) {
                    llY = pin.getLoc().getY();
                }
                if (brX < pin.getLoc().getX()) {
                    brX = pin.getLoc().getX();
                }
                if (brY > pin.getLoc().getY()) {
                    brY = pin.getLoc().getY();
                }
                if (pinSize > (minDim = Math.min(pinWidth = pt.getBounds().width(), pinHeight = pt.getBounds().height()))) {
                    pinSize = minDim;
                }
                Personality dbObj = null;
                if (!colorSource.equals("None")) {
                    FloorplanPin fPin;
                    boolean isInterface = false;
                    Personality personality = dbObj = pin != null ? pin.getPersonality() : null;
                    if (colorSource.equals("Interfaces/Personalities") && (fPin = FloorplanPin.find((PinTemplate)pt, (DevicePath)path)) != null && fPin.getOwner() != null) {
                        dbObj = fPin.getOwner().getMyInterface();
                        isInterface = true;
                    }
                    if (dbObj != null) {
                        int count = 0;
                        if (isInterface) {
                            if (ExportSymbolSpreadsheet.mWorksheet.interfacesList.get(((Interface)dbObj).toStringPath()) == null) {
                                ExportSymbolSpreadsheet.mWorksheet.interfacesList.put(((Interface)dbObj).toStringPath(), 1);
                            } else {
                                count = ExportSymbolSpreadsheet.mWorksheet.interfacesList.get(((Interface)dbObj).toStringPath());
                                ExportSymbolSpreadsheet.mWorksheet.interfacesList.put(((Interface)dbObj).toStringPath(), ++count);
                            }
                        } else if (ExportSymbolSpreadsheet.mWorksheet.personalitiesList.get(dbObj.getName()) == null) {
                            ExportSymbolSpreadsheet.mWorksheet.personalitiesList.put(dbObj.getName(), 1);
                        } else {
                            count = ExportSymbolSpreadsheet.mWorksheet.personalitiesList.get(dbObj.getName());
                            ExportSymbolSpreadsheet.mWorksheet.personalitiesList.put(dbObj.getName(), ++count);
                        }
                    }
                }
                if ((net = NetMap.getNetAt((Net)pin.getNet(), (DevicePath)path, (DeviceTemplate)mDevicePath.getDeviceTemplate())) != null && net.getDeviceTemplate() != mDevicePath.getDeviceTemplate()) {
                    net = mDevicePath.getDeviceTemplate().getNetUnused();
                }
                String netName = net == null ? "" : net.getName();
                String pinName = pt.getName();
                String part1 = null;
                String part2 = null;
                if (mApplyHeaders) {
                    if (!pinName.isEmpty() && pinName.matches(".*[A-Za-z].*") && pinName.matches(".*[1-9].*")) {
                        Pattern pattern = Pattern.compile("\\d+");
                        Matcher matcher = pattern.matcher(pinName);
                        String numericStr = null;
                        int indexNum = -1;
                        while (matcher.find()) {
                            if (numericStr != null) {
                                mApplyHeaders = false;
                                break;
                            }
                            numericStr = pinName.substring(matcher.start(), matcher.end());
                            indexNum = matcher.start();
                        }
                        if (mApplyHeaders) {
                            pattern = Pattern.compile("\\D+");
                            matcher = pattern.matcher(pinName);
                            String alphaStr = null;
                            int indexAlpha = -1;
                            while (matcher.find()) {
                                if (alphaStr != null) {
                                    mApplyHeaders = false;
                                    break;
                                }
                                alphaStr = pinName.substring(matcher.start(), matcher.end());
                                indexAlpha = matcher.start();
                            }
                            part1 = indexNum < indexAlpha ? numericStr : alphaStr;
                            part2 = indexNum > indexAlpha ? numericStr : alphaStr;
                        }
                    } else {
                        mApplyHeaders = false;
                    }
                }
                SymbolSpreadsheet.Worksheet.PinInfo p = new SymbolSpreadsheet.Worksheet.PinInfo(pt, 0L, 0L, pt.getLoc().getX(), pt.getLoc().getY(), (DbObject)dbObj, netName, part1, part2);
                ExportSymbolSpreadsheet.mWorksheet.pinsList.add(p);
            }
        }
        Collections.sort(ExportSymbolSpreadsheet.mWorksheet.pinsList, new XCompare());
        xPitch = ExportSymbolSpreadsheet.calculatePitch(ExportSymbolSpreadsheet.mWorksheet.pinsList, pinSize / 2L, true);
        Collections.sort(ExportSymbolSpreadsheet.mWorksheet.pinsList, new YCompare());
        yPitch = ExportSymbolSpreadsheet.calculatePitch(ExportSymbolSpreadsheet.mWorksheet.pinsList, pinSize / 2L, false);
        numRows = (llY - brY) / yPitch + 1L;
        numColumns = (brX - llX) / xPitch + 1L;
        if (numRows > 500L || numColumns > 500L) {
            ALog.logInfo((String)"Warning: identified more than 500 rows or columns");
        }
        for (SymbolSpreadsheet.Worksheet.PinInfo pin : ExportSymbolSpreadsheet.mWorksheet.pinsList) {
            pin.rowNum = Math.abs(pin.yLoc - llY) / yPitch + 4L;
            pin.colNum = Math.abs(pin.xLoc - llX) / xPitch + 4L;
            mMaxColumns = Math.max(pin.colNum, mMaxColumns);
            mMaxRows = Math.max(pin.rowNum, mMaxRows);
        }
    }

    private static boolean checkHeadersOk(boolean rowCheck) {
        long curIndex = -1L;
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        if (ExportSymbolSpreadsheet.mWorksheet.pinsList.isEmpty()) {
            return false;
        }
        Collections.sort(ExportSymbolSpreadsheet.mWorksheet.pinsList, rowCheck ? new RowColCompare() : new ColRowCompare());
        for (SymbolSpreadsheet.Worksheet.PinInfo pin : ExportSymbolSpreadsheet.mWorksheet.pinsList) {
            long index;
            long l = index = rowCheck ? pin.rowNum : pin.colNum;
            if (curIndex == -1L) {
                curIndex = index;
            }
            if (pin.part1Str == null || pin.part2Str == null) {
                return false;
            }
            boolean match = true;
            if (curIndex != index) {
                String str = null;
                for (String curStr : list1) {
                    if (str == null) {
                        str = curStr;
                    }
                    if (curStr.isEmpty() || str.equals(curStr)) continue;
                    match = false;
                    break;
                }
                if (!match) {
                    str = null;
                    match = true;
                    for (String curStr : list2) {
                        if (str == null) {
                            str = curStr;
                        }
                        if (curStr.isEmpty() || str.equals(curStr)) continue;
                        match = false;
                        break;
                    }
                }
                if (match) {
                    if (rowCheck) {
                        mRowHeaderList.put(curIndex, str);
                    } else {
                        mColHeaderList.put(curIndex, str);
                    }
                    list1.clear();
                    list2.clear();
                    curIndex = index;
                } else {
                    return false;
                }
            }
            list1.add(pin.part1Str);
            list2.add(pin.part2Str);
        }
        Iterator itr = list1.iterator();
        String str = null;
        boolean match = true;
        while (itr.hasNext()) {
            String curStr = (String)itr.next();
            if (str == null) {
                str = curStr;
            }
            if (curStr.isEmpty() || str.equals(curStr)) continue;
            match = false;
            break;
        }
        if (!match) {
            str = null;
            match = true;
            for (String curStr : list2) {
                if (str == null) {
                    str = curStr;
                }
                if (curStr.isEmpty() || str.equals(curStr)) continue;
                return false;
            }
        }
        if (match) {
            if (rowCheck) {
                mRowHeaderList.put(curIndex, str);
            } else {
                mColHeaderList.put(curIndex, str);
            }
        } else {
            return false;
        }
        return true;
    }

    private static void adjustPinRowsAndColumns() {
        for (SymbolSpreadsheet.Worksheet.PinInfo pin : ExportSymbolSpreadsheet.mWorksheet.pinsList) {
            ++pin.rowNum;
            ++pin.colNum;
        }
    }

    private static void createHeaderRowColumnCells() {
        SymbolSpreadsheet.WorksheetCell wsCell;
        String str;
        int i;
        for (i = 1; i <= 2; ++i) {
            long rowNum = i == 1 ? 4L : mMaxRows;
            SymbolSpreadsheet.WorksheetRow wsRow = new SymbolSpreadsheet.WorksheetRow(rowNum, EXCEL_CELL_DEFAULT_HEIGHT, "0", "");
            ExportSymbolSpreadsheet.mWorksheet.rows.put(rowNum, wsRow);
            for (Map.Entry<Long, String> entry : mColHeaderList.entrySet()) {
                long colNum = entry.getKey();
                str = entry.getValue();
                wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum, colNum + 1L, EXCEL_DEFAULT_PIN_STYLE, "String", str, "");
                wsRow.cells.add(wsCell);
            }
        }
        for (i = 1; i <= 2; ++i) {
            long colNum = i == 1 ? 4L : mMaxColumns;
            SymbolSpreadsheet.WorksheetCol wsCol = new SymbolSpreadsheet.WorksheetCol(colNum, EXCEL_CELL_DEFAULT_WIDTH, "0", "");
            ExportSymbolSpreadsheet.mWorksheet.cols.put(colNum, wsCol);
            for (Map.Entry<Long, String> entry : mRowHeaderList.entrySet()) {
                long rowNum = entry.getKey();
                str = entry.getValue();
                wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum + 1L, colNum, EXCEL_DEFAULT_PIN_STYLE, "String", str, "");
                SymbolSpreadsheet.WorksheetRow wsRow = ExportSymbolSpreadsheet.mWorksheet.rows.get(rowNum + 1L);
                if (wsRow == null) {
                    wsRow = new SymbolSpreadsheet.WorksheetRow(rowNum + 1L, EXCEL_CELL_DEFAULT_HEIGHT, "0", "");
                    ExportSymbolSpreadsheet.mWorksheet.rows.put(rowNum + 1L, wsRow);
                }
                wsRow.cells.add(wsCell);
            }
        }
    }

    private static void createPinRowsAndCells(String fieldName1, String fieldName2, String fieldName3) {
        if (ExportSymbolSpreadsheet.mWorksheet.pinsList.isEmpty()) {
            return;
        }
        Collections.sort(ExportSymbolSpreadsheet.mWorksheet.pinsList, new RowColCompare());
        for (SymbolSpreadsheet.Worksheet.PinInfo pin : ExportSymbolSpreadsheet.mWorksheet.pinsList) {
            String soft;
            Object st;
            SymbolSpreadsheet.WorksheetRow wsRow = ExportSymbolSpreadsheet.mWorksheet.rows.get(pin.rowNum);
            if (wsRow == null) {
                wsRow = new SymbolSpreadsheet.WorksheetRow(pin.rowNum, EXCEL_CELL_DEFAULT_HEIGHT, "0", "");
                ExportSymbolSpreadsheet.mWorksheet.rows.put(pin.rowNum, wsRow);
            }
            SymbolSpreadsheet.WorksheetCell wsCell = new SymbolSpreadsheet.WorksheetCell(pin.rowNum, pin.colNum, "", "String", "", "");
            String styleId = EXCEL_DEFAULT_PIN_STYLE;
            if (pin.perOrIntf != null && (st = (SymbolSpreadsheet.Style)mStyles.get(styleId = pin.perOrIntf instanceof Personality ? ((Personality)pin.perOrIntf).getName() : ((Interface)pin.perOrIntf).toStringPath())) == null) {
                st = new SymbolSpreadsheet.Style(styleId, styleId, EXCEL_DEFAULT_PIN_STYLE);
                Color color = pin.perOrIntf instanceof Personality ? ((Personality)pin.perOrIntf).getColor() : ((Interface)pin.perOrIntf).getColor();
                ((SymbolSpreadsheet.Style)st).createInterior("ss:Color", AColor.formatColor((Color)color, (boolean)false));
                ((SymbolSpreadsheet.Style)st).createInterior("ss:Pattern", "Solid");
                if (color.getRGB() != -1) {
                    AColor compColor = AColor.getComplementary((Color)color);
                    ((SymbolSpreadsheet.Style)st).createFont("ss:Color", AColor.formatColor((Color)compColor, (boolean)false));
                }
                ((SymbolSpreadsheet.Style)st).createBorder("Left", "", "Continuous", "2");
                ((SymbolSpreadsheet.Style)st).createBorder("Right", "", "Continuous", "2");
                ((SymbolSpreadsheet.Style)st).createBorder("Top", "", "Continuous", "2");
                ((SymbolSpreadsheet.Style)st).createBorder("Bottom", "", "Continuous", "2");
                mStyles.put(styleId, st);
            }
            wsCell.style = styleId;
            switch (fieldName1) {
                case "Pin Name": {
                    wsCell.data = pin.pin.getName();
                    break;
                }
                case "Net Name": {
                    wsCell.data = pin.pin.getNet().isUnused() ? "" : pin.netName;
                    break;
                }
                default: {
                    if (fieldName1.equals("None")) break;
                    soft = pin.pin.getStringValue(fieldName1);
                    wsCell.data = soft == null ? "" : soft;
                    break;
                }
            }
            switch (fieldName2) {
                case "Pin Name": {
                    wsCell.data = wsCell.data + "\n" + pin.pin.getName();
                    break;
                }
                case "Net Name": {
                    wsCell.data = wsCell.data + (String)(pin.pin.getNet().isUnused() ? "\n" : "\n" + pin.netName);
                    break;
                }
                default: {
                    if (fieldName2.equals("None")) break;
                    soft = pin.pin.getStringValue(fieldName2);
                    wsCell.data = wsCell.data + (String)(soft == null ? "\n" : "\n" + soft);
                    break;
                }
            }
            switch (fieldName3) {
                case "Pin Name": {
                    wsCell.data = wsCell.data + "\n" + pin.pin.getName();
                    break;
                }
                case "Net Name": {
                    wsCell.data = wsCell.data + (String)(pin.pin.getNet().isUnused() ? "\n" : "\n" + pin.netName);
                    break;
                }
                default: {
                    if (fieldName3.equals("None")) break;
                    soft = pin.pin.getStringValue(fieldName3);
                    wsCell.data = wsCell.data + (String)(soft == null ? "\n" : "\n" + soft);
                    break;
                }
            }
            wsRow.cells.add(wsCell);
            SymbolSpreadsheet.WorksheetCol wsCol = ExportSymbolSpreadsheet.mWorksheet.cols.get(pin.colNum);
            if (wsCol != null) continue;
            wsCol = new SymbolSpreadsheet.WorksheetCol(pin.colNum, EXCEL_CELL_DEFAULT_WIDTH, "0", "");
            ExportSymbolSpreadsheet.mWorksheet.cols.put(pin.colNum, wsCol);
        }
    }

    private static void createLegendCells() {
        SymbolSpreadsheet.Style st;
        String styleId;
        SymbolSpreadsheet.WorksheetCell wsCell;
        SymbolSpreadsheet.WorksheetRow wsRow;
        int count;
        if (ExportSymbolSpreadsheet.mWorksheet.personalitiesList.isEmpty() && ExportSymbolSpreadsheet.mWorksheet.interfacesList.isEmpty()) {
            return;
        }
        boolean once = true;
        long rowNum = 4L;
        long colNum = mMaxColumns + 5L;
        for (Map.Entry<String, Integer> entry : ExportSymbolSpreadsheet.mWorksheet.personalitiesList.entrySet()) {
            String persona = entry.getKey();
            count = entry.getValue();
            wsRow = null;
            wsCell = null;
            if (once) {
                wsRow = ExportSymbolSpreadsheet.mWorksheet.rows.get(rowNum);
                if (wsRow == null) {
                    wsRow = new SymbolSpreadsheet.WorksheetRow(rowNum, EXCEL_CELL_DEFAULT_HEIGHT, "0", "");
                    ExportSymbolSpreadsheet.mWorksheet.rows.put(rowNum, wsRow);
                }
                wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum, colNum, "", "String", "", "");
                wsCell.data = "Personalities";
                wsCell.style = "Default";
                wsRow.cells.add(wsCell);
                ++rowNum;
                once = false;
            }
            if ((wsRow = ExportSymbolSpreadsheet.mWorksheet.rows.get(rowNum)) == null) {
                wsRow = new SymbolSpreadsheet.WorksheetRow(rowNum, EXCEL_CELL_DEFAULT_HEIGHT, "0", "");
                ExportSymbolSpreadsheet.mWorksheet.rows.put(rowNum, wsRow);
            }
            wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum, colNum, "", "String", "", "");
            styleId = persona;
            st = (SymbolSpreadsheet.Style)mStyles.get(styleId);
            if (st == null) {
                ALog.logInfo((String)("Style problem for personality " + persona));
            }
            wsCell.data = styleId;
            wsCell.style = styleId;
            wsRow.cells.add(wsCell);
            wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum, colNum + 1L, "", "String", "", "");
            wsCell.data = Integer.toString(count);
            wsCell.style = "Default";
            wsRow.cells.add(wsCell);
            SymbolSpreadsheet.WorksheetCol wsCol = new SymbolSpreadsheet.WorksheetCol(colNum, EXCEL_CELL_DEFAULT_WIDTH, "0", "");
            ExportSymbolSpreadsheet.mWorksheet.cols.put(colNum, wsCol);
            ++rowNum;
        }
        rowNum += 2L;
        once = true;
        for (Map.Entry<String, Integer> entry : ExportSymbolSpreadsheet.mWorksheet.interfacesList.entrySet()) {
            String intface = entry.getKey();
            count = entry.getValue();
            wsRow = null;
            wsCell = null;
            if (once) {
                wsRow = ExportSymbolSpreadsheet.mWorksheet.rows.get(rowNum);
                if (wsRow == null) {
                    wsRow = new SymbolSpreadsheet.WorksheetRow(rowNum, EXCEL_CELL_DEFAULT_HEIGHT, "0", "");
                    ExportSymbolSpreadsheet.mWorksheet.rows.put(rowNum, wsRow);
                }
                wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum, colNum, "", "String", "", "");
                wsCell.data = "Interfaces";
                wsCell.style = "Default";
                wsRow.cells.add(wsCell);
                ++rowNum;
                once = false;
            }
            if ((wsRow = ExportSymbolSpreadsheet.mWorksheet.rows.get(rowNum)) == null) {
                wsRow = new SymbolSpreadsheet.WorksheetRow(rowNum, EXCEL_CELL_DEFAULT_HEIGHT, "0", "");
                ExportSymbolSpreadsheet.mWorksheet.rows.put(rowNum, wsRow);
            }
            wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum, colNum, "", "String", "", "");
            styleId = intface;
            st = (SymbolSpreadsheet.Style)mStyles.get(styleId);
            if (st == null) {
                ALog.logInfo((String)("Style problem for interface " + intface));
            }
            wsCell.data = styleId;
            wsCell.style = styleId;
            wsRow.cells.add(wsCell);
            wsCell = new SymbolSpreadsheet.WorksheetCell(rowNum, colNum + 1L, "", "String", "", "");
            wsCell.data = Integer.toString(count);
            wsCell.style = "Default";
            wsRow.cells.add(wsCell);
            ++rowNum;
        }
    }

    private static long calculatePitch(ArrayList<SymbolSpreadsheet.Worksheet.PinInfo> pinsList, long halfPinSize, boolean xDirection) {
        long minPitch = 1L;
        if (pinsList.isEmpty()) {
            return minPitch;
        }
        long lastValue = xDirection ? pinsList.get((int)0).xLoc : pinsList.get((int)0).yLoc;
        long delta = Long.MAX_VALUE;
        for (SymbolSpreadsheet.Worksheet.PinInfo p : pinsList) {
            long coord = xDirection ? p.xLoc : p.yLoc;
            long pitch = 0L;
            if (lastValue == coord) continue;
            pitch = coord - lastValue;
            if (pitch >= halfPinSize && delta >= pitch) {
                delta = pitch;
            }
            lastValue = coord;
        }
        return Math.max(minPitch, delta);
    }

    public static void init(String strDevicePath) {
        mWorksheet = null;
        if (mWorksheets != null) {
            mWorksheets.clear();
        } else {
            mWorksheets = new HashMap();
        }
        if (mStyles != null) {
            mStyles.clear();
        } else {
            mStyles = new HashMap();
        }
        mWorksheetName = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)strDevicePath).getLast().getName();
    }

    private static ArrayList<String> getSoftFields() {
        DbClass pinTClass = OrbitApp.getCurDb().getDbClass("PinTemplate");
        ArrayList<String> fields = new ArrayList<String>();
        for (DbFieldDef f : pinTClass.getFields()) {
            if (!f.getIsSoft()) continue;
            fields.add(f.getName());
        }
        Collections.sort(fields);
        return fields;
    }

    public static boolean showFor(String strDevicePath) {
        int i;
        Cp.exec((String)"com.sigrity.orbit.export.ExportSymbolSpreadsheet.init(\"%s\")", (Object[])new Object[]{strDevicePath});
        mFileChooser = new AFileChooser();
        mFileChooser.setDialogTitle("Export Ball Map");
        AFileFilter ffXml = AFileFilter.XML;
        mFileChooser.addChoosableFileFilter((FileFilter)ffXml);
        mFileChooser.setFileFilter((FileFilter)ffXml);
        String fileName = strDevicePath;
        int lastSlashIdx = fileName.lastIndexOf(47);
        if (lastSlashIdx < 0 || fileName.length() > lastSlashIdx + 1) {
            // empty if block
        }
        fileName = fileName.substring(lastSlashIdx + 1);
        mFileChooser.setSelectedFile(new File(fileName));
        JPanel pnlOptions = new JPanel();
        pnlOptions.setBorder(new TitledBorder("Export Options"));
        GridBagManager options = GridBagManager.layout((Container)pnlOptions);
        mInsertSheet = (JCheckBox)options.addNl((Component)new JCheckBox("Add/Update worksheet in existing spreadsheet"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        mInsertSheet.setToolTipText("<html>If selected, the corresponding work sheet of the selected spreadsheet file will be updated. ");
        mInsertSheet.setSelected(false);
        mInsertFlag = false;
        mInsertSheet.addActionListener(mInsertListener);
        mDisplayText = new JTextField("", 30);
        mDisplayText.setEditable(false);
        mDisplayText.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0, 0), 2));
        options.addNl((Component)mDisplayText, (GridBagConstraints)GridBagManager.LEFT);
        Object[] softFieldsList = ExportSymbolSpreadsheet.getSoftFields().toArray();
        options.pushNoFill();
        options.add("Primary Text:", (GridBagConstraints)GridBagManager.LEFT);
        mPTextCombo = new JComboBox();
        options.add(mPTextCombo, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        for (i = 0; i < mFieldTextList.length; ++i) {
            if (mFieldTextList[i].equals("None")) continue;
            mPTextCombo.addItem(mFieldTextList[i]);
        }
        for (i = 0; i < softFieldsList.length; ++i) {
            mPTextCombo.addItem((String)softFieldsList[i]);
        }
        mPTextStr = mPTextCombo.getSelectedItem().toString();
        mPTextCombo.addActionListener(mPTextListener);
        options.newline();
        options.add("Secondary Text:", (GridBagConstraints)GridBagManager.LEFT);
        mSTextCombo = new JComboBox();
        options.add(mSTextCombo, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        for (i = 0; i < mFieldTextList.length; ++i) {
            mSTextCombo.addItem(mFieldTextList[i]);
        }
        for (i = 0; i < softFieldsList.length; ++i) {
            mSTextCombo.addItem((String)softFieldsList[i]);
        }
        mSTextStr = mSTextCombo.getSelectedItem().toString();
        mSTextCombo.addActionListener(mSTextListener);
        options.newline();
        options.add("Tertiary Text:", (GridBagConstraints)GridBagManager.LEFT);
        mTTextCombo = new JComboBox();
        options.add(mTTextCombo, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        for (i = 0; i < mFieldTextList.length; ++i) {
            mTTextCombo.addItem(mFieldTextList[i]);
        }
        for (i = 0; i < softFieldsList.length; ++i) {
            mTTextCombo.addItem((String)softFieldsList[i]);
        }
        mTTextStr = mSTextCombo.getSelectedItem().toString();
        mTTextCombo.addActionListener(mTTextListener);
        options.newline();
        options.add("Color Source:", (GridBagConstraints)GridBagManager.LEFT);
        mColorSourceCombo = new JComboBox();
        options.add(mColorSourceCombo, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        for (i = 0; i < mColorSourceList.length; ++i) {
            mColorSourceCombo.addItem(mColorSourceList[i]);
        }
        mColorSource = mColorSourceCombo.getSelectedItem().toString();
        mColorSourceCombo.addActionListener(mColorSourceListener);
        options.popNl();
        options.newline();
        mOpenExcel = (JCheckBox)options.addNl((Component)new JCheckBox("Open saved spreadsheet (uses default system application)"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        mOpenExcel.setSelected(true);
        mOpenExcelFlag = true;
        mOpenExcel.addActionListener(mOpenExcelListener);
        options.addFillY();
        mFileChooser.setAccessory((JComponent)pnlOptions);
        ExportSymbolSpreadsheet.setDefaultColorOption(strDevicePath);
        if (mFileChooser.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = mFileChooser.getSelectedFile();
        Cp.exec((String)"com.sigrity.orbit.export.ExportSymbolSpreadsheet.write(curDb(), %s, \"%s\", \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((File)f), strDevicePath, mPTextStr, mSTextStr, mTTextStr, mColorSource});
        if (mOpenExcelFlag) {
            try {
                Desktop.getDesktop().open(f);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
        return true;
    }

    protected static void setDefaultColorOption(String devicePath) {
        DevicePath devPath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePath);
        if (devPath == null) {
            return;
        }
        Substrate subst = devPath.getDevice().getSubstrate();
        boolean isPersonality = false;
        boolean isInterface = false;
        for (DevicePath path : devPath.getDescendants(true)) {
            if (path.getDevice().getSubstrate() != subst) continue;
            for (PinInstance pin : path.getLast().getPins()) {
                FloorplanPin fPin;
                PinTemplate pt;
                if (pin.getType() != PinTemplate.Type.BALLPAD || (pt = pin.getPinTemplate()) == null) continue;
                if (pin != null && pin.getPersonality() != null) {
                    isPersonality = true;
                }
                if ((fPin = FloorplanPin.find((PinTemplate)pt, (DevicePath)path)) != null && fPin.getOwner() != null && fPin.getOwner().getMyInterface() != null) {
                    isInterface = true;
                }
                if (!isPersonality || !isInterface) continue;
                break;
            }
            if (!isPersonality || !isInterface) continue;
            break;
        }
        if (isPersonality && isInterface) {
            mColorSourceCombo.setSelectedItem("Interfaces/Personalities");
        } else if (isPersonality) {
            mColorSourceCombo.setSelectedItem("Personalities");
        } else {
            mColorSourceCombo.setSelectedItem("None");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean write(Db db, String filePath, String devicePath, String fieldName1, String fieldName2, String fieldName3, String colorSource) throws FileNotFoundException {
        block26: {
            mApplyHeaders = true;
            mMaxColumns = 0L;
            mMaxRows = 0L;
            mRowHeaderList.clear();
            mColHeaderList.clear();
            mDevicePath = DevicePath.fromString((Db)db, (String)devicePath);
            if (mDevicePath == null) {
                ALog.logWarn((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
                return false;
            }
            File file = new File(filePath);
            if (mInsertFlag && file.exists()) {
                ImportSpreadsheetReader reader = new ImportSpreadsheetReader(null, file, null, null, null, null, null);
                reader.parseFile();
                if (mWorksheets.get(mWorksheetName) != null) {
                    mWorksheets.remove(mWorksheetName);
                }
            }
            ExportSymbolSpreadsheet.createStartupStyles();
            if (mWorksheetName == null) {
                mWorksheetName = mDevicePath.getDevice() != null ? mDevicePath.getDevice().getName() : (mDevicePath.getDeviceTemplate() != null ? mDevicePath.getDeviceTemplate().getName() : "Sheet");
            }
            mWorksheet = new SymbolSpreadsheet.Worksheet(mWorksheetName);
            ExportSymbolSpreadsheet.getData(fieldName1, fieldName2, fieldName3, colorSource);
            mWorksheets.put(mWorksheetName, mWorksheet);
            try (BufferedOutputStream os1 = new BufferedOutputStream(new FileOutputStream(file));){
                mXmlWriter = ExcelXmlWriter.create(os1);
                if (mXmlWriter == null) {
                    boolean bl = false;
                    return bl;
                }
                mXmlWriter.observeDuplicateCells().subscribe(cells -> ALog.logWarn((String)"Multiple values encountered for row %d, column %d (%s): '%s', '%s'", (Object[])new Object[]{((SymbolSpreadsheet.WorksheetCell)cells.first).rowNum, ((SymbolSpreadsheet.WorksheetCell)cells.first).colNum, AlphabetFull.get().getNthUnique((int)((SymbolSpreadsheet.WorksheetCell)cells.first).colNum - 1), ((SymbolSpreadsheet.WorksheetCell)cells.first).data, ((SymbolSpreadsheet.WorksheetCell)cells.second).data}));
                mXmlWriter.writeHeader(EXCEL_XML_VERSION);
                mXmlWriter.writeDocumentProperties();
                mXmlWriter.writeStyles(mStyles);
                for (String key : mWorksheets.keySet()) {
                    SymbolSpreadsheet.Worksheet ws = (SymbolSpreadsheet.Worksheet)mWorksheets.get(key);
                    mXmlWriter.writeWorksheet(ws);
                }
                mXmlWriter.writeFooter();
                try {
                    mXmlWriter.close();
                }
                catch (XMLStreamException e) {
                    ALog.logWarn((Throwable)e, (String)"Error closing output.", (Object[])new Object[0]);
                }
                ALog.logInfo((String)"Wrote xml file %s", (Object[])new Object[]{file});
                break block26;
                catch (XMLStreamException e) {
                    boolean bl;
                    try {
                        ALog.logError((Throwable)e, (String)"Error writing output.", (Object[])new Object[0]);
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        try {
                            mXmlWriter.close();
                        }
                        catch (XMLStreamException e2) {
                            ALog.logWarn((Throwable)e2, (String)"Error closing output.", (Object[])new Object[0]);
                        }
                        ALog.logInfo((String)"Wrote xml file %s", (Object[])new Object[]{file});
                        throw throwable;
                    }
                    try {
                        mXmlWriter.close();
                    }
                    catch (XMLStreamException e3) {
                        ALog.logWarn((Throwable)e3, (String)"Error closing output.", (Object[])new Object[0]);
                    }
                    ALog.logInfo((String)"Wrote xml file %s", (Object[])new Object[]{file});
                    ((OutputStream)os1).close();
                    return bl;
                }
            }
            catch (FileNotFoundException fnfe) {
                ALog.logError((Throwable)fnfe, (String)"Unable to open output file '%s'.", (Object[])new Object[]{file});
                return false;
            }
            catch (IOException ioe) {
                ALog.logError((Throwable)ioe, (String)"Error writing to output file '%s'.", (Object[])new Object[]{file});
                return false;
            }
        }
        return true;
    }

    public static void createStartupStyles() {
        SymbolSpreadsheet.Style st = null;
        if (mStyles.get("Default") == null) {
            st = new SymbolSpreadsheet.Style("Default", "Normal", "");
            st.createAlignment("ss:Vertical", "Center");
            st.createAlignment("ss:Horizontal", "Center");
            st.createAlignment("ss:WrapText", "1");
            mStyles.put(st.id, st);
        }
        if (mStyles.get(EXCEL_DEFAULT_PIN_STYLE) == null) {
            st = new SymbolSpreadsheet.Style(EXCEL_DEFAULT_PIN_STYLE, EXCEL_DEFAULT_PIN_STYLE, "Default");
            st.createBorder("Left", "", "Continuous", "2");
            st.createBorder("Right", "", "Continuous", "2");
            st.createBorder("Top", "", "Continuous", "2");
            st.createBorder("Bottom", "", "Continuous", "2");
            mStyles.put(st.id, st);
        }
        if (mStyles.get("Border") == null) {
            st = new SymbolSpreadsheet.Style("Border", "Border", "Default");
            mStyles.put(st.id, st);
        }
    }

    static {
        mInsertFlag = false;
        mOpenExcelFlag = false;
        mPTextStr = "";
        mSTextStr = "";
        mTTextStr = "";
        mFieldTextList = new String[]{"None", "Net Name", "Pin Name"};
        mColorSource = "";
        mColorSourceList = new String[]{"None", "Personalities", "Interfaces/Personalities"};
        mApplyHeaders = true;
        mMaxColumns = 0L;
        mMaxRows = 0L;
        mRowHeaderList = new HashMap();
        mColHeaderList = new HashMap();
        mInsertListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mInsertFlag = mInsertSheet.isSelected();
                mDisplayText.setText((String)(mInsertFlag ? "Sheet '" + mWorksheetName + "' will be replaced in spreadsheet file." : ""));
            }
        };
        mPTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mPTextStr = mPTextCombo.getSelectedItem().toString();
            }
        };
        mSTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mSTextStr = mSTextCombo.getSelectedItem().toString();
            }
        };
        mTTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mTTextStr = mTTextCombo.getSelectedItem().toString();
            }
        };
        mColorSourceListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mColorSource = mColorSourceCombo.getSelectedItem().toString();
            }
        };
        mOpenExcelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mOpenExcelFlag = mOpenExcel.isSelected();
            }
        };
    }

    public static class ExcelXmlWriter {
        protected XMLStreamWriter mWriter = null;
        protected PublishSubject<APair<SymbolSpreadsheet.WorksheetCell, SymbolSpreadsheet.WorksheetCell>> mDuplicateCellSubject = PublishSubject.create();

        public static ExcelXmlWriter create(OutputStream os) {
            ExcelXmlWriter dxw = new ExcelXmlWriter(os);
            return dxw.mWriter == null ? null : dxw;
        }

        private ExcelXmlWriter(OutputStream os) {
            this.mWriter = AXmlUtil.createXmlStreamWriter((OutputStream)os);
        }

        public Observable<APair<SymbolSpreadsheet.WorksheetCell, SymbolSpreadsheet.WorksheetCell>> observeDuplicateCells() {
            return this.mDuplicateCellSubject;
        }

        public void close() throws XMLStreamException {
            this.mWriter.close();
        }

        public void writeHeader(String ver) throws XMLStreamException {
            String toString = "mso-application progid=\"Excel.Sheet\"";
            this.mWriter.writeStartDocument(ver);
            this.mWriter.writeProcessingInstruction(toString);
            this.mWriter.writeCharacters("\n");
            this.mWriter.writeStartElement("Workbook");
            this.mWriter.writeNamespace("xmlns", ExportSymbolSpreadsheet.EXCEL_XML_SPREADSHEET_NS);
            this.mWriter.writeNamespace("o", ExportSymbolSpreadsheet.EXCEL_XML_OFFICE_NS);
            this.mWriter.writeNamespace("x", ExportSymbolSpreadsheet.EXCEL_XML_EXCEL_NS);
            this.mWriter.writeNamespace("ss", ExportSymbolSpreadsheet.EXCEL_XML_SPREADSHEET_NS);
            this.mWriter.writeNamespace("html", ExportSymbolSpreadsheet.EXCEL_XML_NS_URL);
        }

        public void writeDocumentProperties() throws XMLStreamException {
            this.mWriter.writeStartElement("DocumentProperties");
            this.mWriter.writeNamespace("xmlns", ExportSymbolSpreadsheet.EXCEL_XML_OFFICE_NS);
            this.writeElement("Author", OrbitIO.getApp().getName());
            this.writeElement("LastAuthor", OrbitIO.getApp().getName());
            this.writeElement("Created", "" + new Date());
            this.writeElement("Company", "Cadence Design Systems");
            this.writeElement("Version", ExportSymbolSpreadsheet.EXCEL_XML_VERSION);
            this.mWriter.writeEndElement();
        }

        public void writeStyles(Map<String, SymbolSpreadsheet.Style> styles) throws XMLStreamException {
            this.mWriter.writeStartElement("Styles");
            for (String id : styles.keySet()) {
                SymbolSpreadsheet.Style st = styles.get(id);
                this.mWriter.writeStartElement("Style");
                this.mWriter.writeAttribute("ss:ID", id);
                this.mWriter.writeAttribute("ss:Name", st.name);
                if (!st.borders.isEmpty()) {
                    this.mWriter.writeStartElement("Borders");
                    for (SymbolSpreadsheet.StyleBorder styleBorder : st.borders) {
                        this.mWriter.writeStartElement("Border");
                        this.mWriter.writeAttribute("ss:Position", styleBorder.position);
                        if (!styleBorder.color.isEmpty()) {
                            this.mWriter.writeAttribute("ss:Color", styleBorder.color);
                        }
                        this.mWriter.writeAttribute("ss:LineStyle", styleBorder.lineStyle);
                        this.mWriter.writeAttribute("ss:Weight", styleBorder.weight);
                        this.mWriter.writeEndElement();
                    }
                    this.mWriter.writeEndElement();
                }
                if (!st.alignments.isEmpty()) {
                    this.mWriter.writeStartElement("Alignment");
                    for (APair aPair : st.alignments) {
                        this.mWriter.writeAttribute((String)aPair.first, (String)aPair.second);
                    }
                    this.mWriter.writeEndElement();
                }
                if (!st.fonts.isEmpty()) {
                    this.mWriter.writeStartElement("Font");
                    for (APair aPair : st.fonts) {
                        this.mWriter.writeAttribute((String)aPair.first, (String)aPair.second);
                    }
                    this.mWriter.writeEndElement();
                }
                if (!st.interiors.isEmpty()) {
                    this.mWriter.writeStartElement("Interior");
                    for (APair aPair : st.interiors) {
                        this.mWriter.writeAttribute((String)aPair.first, (String)aPair.second);
                    }
                    this.mWriter.writeEndElement();
                }
                this.mWriter.writeEndElement();
            }
            this.mWriter.writeEndElement();
        }

        public void writeWorksheet(SymbolSpreadsheet.Worksheet ws) throws XMLStreamException {
            this.mWriter.writeStartElement("Worksheet");
            this.mWriter.writeAttribute("ss:Name", ws.name);
            this.mWriter.writeStartElement("Table");
            long rowNumOffset = -ws.rows.firstEntry().getValue().rowNum + 1L;
            long colNumOffset = -ws.cols.firstEntry().getValue().colNum + 1L;
            for (long key : ws.cols.keySet()) {
                SymbolSpreadsheet.WorksheetCol col = ws.cols.get(key);
                this.mWriter.writeStartElement("Column");
                this.mWriter.writeAttribute("ss:Index", Long.toString(col.colNum + colNumOffset));
                this.mWriter.writeAttribute("ss:Width", col.width);
                this.mWriter.writeEndElement();
            }
            for (long key : ws.rows.keySet()) {
                SymbolSpreadsheet.WorksheetRow row = ws.rows.get(key);
                this.mWriter.writeStartElement("Row");
                this.mWriter.writeAttribute("ss:Index", Long.toString(row.rowNum + rowNumOffset));
                this.mWriter.writeAttribute("ss:Height", row.height);
                Collections.sort(row.cells, new CellRowColCompare());
                for (int curIdx = 0; curIdx < row.cells.size(); ++curIdx) {
                    SymbolSpreadsheet.WorksheetCell cell = row.cells.get(curIdx);
                    this.mWriter.writeStartElement("Cell");
                    this.mWriter.writeAttribute("ss:StyleID", cell.style);
                    this.mWriter.writeAttribute("ss:Index", Long.toString(cell.colNum + rowNumOffset));
                    if (!cell.formula.isEmpty()) {
                        this.mWriter.writeAttribute("ss:Formula", cell.formula);
                    }
                    Object data = cell.data;
                    for (int nextIdx = curIdx + 1; nextIdx < row.cells.size(); ++nextIdx) {
                        SymbolSpreadsheet.WorksheetCell nextCell = row.cells.get(nextIdx);
                        if (nextCell.colNum != cell.colNum) break;
                        if (((String)data).length() > 0) {
                            data = (String)data + ", ";
                        }
                        data = (String)data + nextCell.data;
                        this.mDuplicateCellSubject.onNext((Object)APair.create((Object)cell, (Object)nextCell));
                        ++curIdx;
                    }
                    this.mWriter.writeStartElement("Data");
                    this.mWriter.writeAttribute("ss:Type", cell.type);
                    this.mWriter.writeCData((String)data);
                    this.mWriter.writeEndElement();
                    this.mWriter.writeEndElement();
                }
                this.mWriter.writeEndElement();
            }
            this.mWriter.writeEndElement();
            this.mWriter.writeEndElement();
        }

        public void writeFooter() throws XMLStreamException {
            this.mWriter.writeEndElement();
            this.mWriter.writeEndDocument();
        }

        public void writeElement(String name, String text) throws XMLStreamException {
            this.mWriter.writeStartElement(name);
            this.mWriter.writeCharacters(text);
            this.mWriter.writeEndElement();
        }
    }

    private static class ColRowCompare
    implements Comparator<SymbolSpreadsheet.Worksheet.PinInfo> {
        private ColRowCompare() {
        }

        @Override
        public int compare(SymbolSpreadsheet.Worksheet.PinInfo o1, SymbolSpreadsheet.Worksheet.PinInfo o2) {
            if (o1.colNum < o2.colNum) {
                return -1;
            }
            if (o1.colNum > o2.colNum) {
                return 1;
            }
            if (o1.rowNum < o2.rowNum) {
                return -1;
            }
            return 1;
        }
    }

    private static class CellRowColCompare
    implements Comparator<SymbolSpreadsheet.WorksheetCell> {
        private CellRowColCompare() {
        }

        @Override
        public int compare(SymbolSpreadsheet.WorksheetCell o1, SymbolSpreadsheet.WorksheetCell o2) {
            if (o1.rowNum < o2.rowNum) {
                return -1;
            }
            if (o1.rowNum > o2.rowNum) {
                return 1;
            }
            if (o1.colNum < o2.colNum) {
                return -1;
            }
            return 1;
        }
    }

    private static class RowColCompare
    implements Comparator<SymbolSpreadsheet.Worksheet.PinInfo> {
        private RowColCompare() {
        }

        @Override
        public int compare(SymbolSpreadsheet.Worksheet.PinInfo o1, SymbolSpreadsheet.Worksheet.PinInfo o2) {
            if (o1.rowNum != o2.rowNum) {
                return Long.compare(o1.rowNum, o2.rowNum);
            }
            if (o1.colNum != o2.colNum) {
                return Long.compare(o1.rowNum, o2.rowNum);
            }
            return AUtil.compare((Comparable)o1.pin, (Object)o2.pin);
        }
    }

    private static class YCompare
    implements Comparator<SymbolSpreadsheet.Worksheet.PinInfo> {
        private YCompare() {
        }

        @Override
        public int compare(SymbolSpreadsheet.Worksheet.PinInfo o1, SymbolSpreadsheet.Worksheet.PinInfo o2) {
            return Long.valueOf(o1.yLoc).compareTo(o2.yLoc);
        }
    }

    private static class XCompare
    implements Comparator<SymbolSpreadsheet.Worksheet.PinInfo> {
        private XCompare() {
        }

        @Override
        public int compare(SymbolSpreadsheet.Worksheet.PinInfo o1, SymbolSpreadsheet.Worksheet.PinInfo o2) {
            return Long.valueOf(o1.xLoc).compareTo(o2.xLoc);
        }
    }
}

