/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.JedecAlphabet;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class HierExportSelectedPortsToCSV {
    protected Db mDb;
    protected Design mDesign;
    protected DevicePath mDevicePath;
    protected ArrayList<DevicePath> mDiePaths = new ArrayList();
    protected File mFile;
    protected FileWriter mFileWriter;
    protected String mFileName;
    boolean mAPDStyle = false;
    boolean mMatrixPorts = false;
    String mPadStackName = "PAD";

    public static void writeNow(String fileName, boolean apdStyle, boolean matrixports, String padstackname) {
        HierExportSelectedPortsToCSV pOut = new HierExportSelectedPortsToCSV();
        pOut.write(fileName, apdStyle, matrixports, padstackname);
    }

    public void write(String fileName, boolean apdStyle, boolean matrixports, String padstackname) {
        this.mFile = null;
        this.mFileName = fileName;
        this.mDb = OrbitIO.getCurDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mAPDStyle = apdStyle;
        this.mMatrixPorts = matrixports;
        this.mPadStackName = padstackname;
        if (this.validate()) {
            this.writeTheFile();
        }
    }

    protected String formatUM(long d) {
        return Double.toString(this.mDesign.getUser(d));
    }

    private void writeTheFile() {
        ArrayList<HierPort> hps = new ArrayList<HierPort>();
        Design design = Design.getDesign((Db)this.mDb);
        Selection s = design.getCurSelection();
        for (PinInstance pin : s.get(PinInstance.class)) {
            for (DevicePath dp : s.getSelectedPaths((DbObject)pin)) {
                for (PortTemplate port : pin.getPinTemplate().getPortTemplates()) {
                    HierPort hp = new HierPort(dp, port);
                    hps.add(hp);
                }
            }
        }
        try {
            if (this.mAPDStyle) {
                Object name = "Unknown";
                String refdes = "Unknown";
                String w = "0.0";
                String h = "0.0";
                float r = 0.0f;
                if (!hps.isEmpty()) {
                    DevicePath diePath = ((HierPort)hps.get(0)).getPath().pathToLowestDie();
                    name = diePath.getDeviceTemplate().getName();
                    refdes = diePath.getLast().getName();
                    w = this.formatUM(diePath.getDeviceTemplate().getBB().width());
                    h = this.formatUM(diePath.getDeviceTemplate().getBB().height());
                    r = diePath.getLast().getRotate();
                }
                Date now = new Date();
                String tab = "\t";
                this.print("File: " + this.mFile.getCanonicalPath() + "\n");
                this.print("Date: " + now.toString() + "\n");
                this.print("Units: microns, 1 decimal places\n");
                this.print("Name: " + (String)name + "\n");
                this.print("RefDes: " + refdes + "\n");
                this.print("Origin: (0.0 0.0)\n");
                this.print("Rotation: " + r + "\n");
                this.print("Dimensions: (" + w + " " + h + ")\n");
                this.print("\n");
                this.print("Pin Number" + tab + "Pin Name" + tab + "Padstack" + tab + "X Coord" + tab + "Y Coord" + tab + "Rotation" + tab + "Net Name" + tab + "Ref Des" + tab + "Package Pin\n");
                this.print("\n");
                HashMap<HierPort, HierPort> bumpToBall = new HashMap<HierPort, HierPort>();
                for (HierPort bump : hps) {
                    Net packageNet;
                    boolean foundBump = false;
                    for (HierPin candidate : NetMap.getConnectedDevicePathPorts((Net)bump.getNet(), (DevicePath)bump.getPath())) {
                        if (candidate.getPinTemplate().getType() != PinTemplate.Type.BALLPAD) continue;
                        HierPort ball = new HierPort(candidate.getPath(), candidate.getPin().getPinTemplate().getFirstPortTemplate());
                        bumpToBall.put(bump, ball);
                        foundBump = true;
                        break;
                    }
                    if (foundBump || (packageNet = NetMap.getTopmostNet((Net)bump.getNet(), (DevicePath)bump.getPath())).getDeviceTemplate().getType() != DeviceTemplate.Type.PACKAGE) continue;
                    HierPort ball = new HierPort(bump.getPath(), null);
                    bumpToBall.put(bump, ball);
                }
                if (this.mMatrixPorts) {
                    HierPort[][] matrix = this.matrixPorts(hps);
                    int length = matrix.length;
                    int maxColumns = 0;
                    for (int row = 0; row < length; ++row) {
                        maxColumns = Math.max(maxColumns, matrix[row].length);
                        for (int col = 0; col < matrix[row].length; ++col) {
                            HierPort hp = matrix[row][col];
                            if (hp == null) continue;
                            long x = hp.getSubstrateLoc().getX();
                            long y = hp.getSubstrateLoc().getY();
                            String portName = JedecAlphabet.getNth((int)row) + col;
                            String dieNetName = "";
                            Net n = hp.getSubstrateNet();
                            if (n != null) {
                                dieNetName = n.getName();
                            }
                            String refDes = "";
                            HierPort ball = (HierPort)bumpToBall.get(hp);
                            String ballName = "";
                            String packageNetName = "NC";
                            if (ball != null) {
                                ballName = ball.getDPort() == null ? "" : ball.getPin().getName();
                                DevicePath packagePath = ball.getPath().substratePath();
                                if (packagePath != null) {
                                    refDes = packagePath.getFirst().getName();
                                    Net packageNet = NetMap.getNetAt((Net)hp.getNet(), (DevicePath)((DevicePath)hp.first), (DeviceTemplate)packagePath.getFirst().getTemplate());
                                    if (packageNet != null) {
                                        packageNetName = packageNet.getName();
                                    }
                                }
                            }
                            this.print(portName + tab + dieNetName + tab + this.mPadStackName + tab + this.formatUM(x) + tab + this.formatUM(y) + tab + "0.000" + tab + packageNetName + tab + refDes + tab + ballName + "\n");
                        }
                    }
                } else {
                    for (HierPort dpp : hps) {
                        APoint2D p = dpp.getSubstrateLoc();
                        long x = p.getX();
                        long y = p.getY();
                        String portName = "";
                        if (dpp.getPin().getName() != null) {
                            portName = dpp.getPin().getName();
                        }
                        String dieNetName = "";
                        Net n = dpp.getSubstrateNet();
                        if (n != null) {
                            dieNetName = n.getName();
                        }
                        HierPort ball = (HierPort)bumpToBall.get(dpp);
                        String ballName = "";
                        String refDes = "";
                        String packageNetName = "NC";
                        if (ball != null) {
                            ballName = ball.getDPort() == null ? "" : ball.getPin().getName();
                            DevicePath packagePath = ball.getPath().substratePath();
                            if (packagePath != null) {
                                refDes = packagePath.getFirst().getName();
                                Net packageNet = NetMap.getNetAt((Net)dpp.getNet(), (DevicePath)((DevicePath)dpp.first), (DeviceTemplate)packagePath.getFirst().getTemplate());
                                if (packageNet != null) {
                                    packageNetName = packageNet.getName();
                                }
                            }
                        }
                        this.print(portName + tab + dieNetName + tab + this.mPadStackName + tab + this.formatUM(x) + tab + this.formatUM(y) + tab + "0.000" + tab + packageNetName + tab + refDes + tab + ballName + "\n");
                    }
                }
            } else {
                this.print("x,y,PIN_NAME,PIN_NUMBER,PIN_PERSONALITY\n");
                for (HierPort dpp : hps) {
                    long x = dpp.getSubstrateLoc().getX();
                    long y = dpp.getSubstrateLoc().getY();
                    String portName = "";
                    if (dpp.getPin().getName() != null) {
                        portName = dpp.getPin().getName();
                    }
                    String pName = dpp.getPin().getPersonalitiesString(false, true);
                    String nName = "";
                    Net n = dpp.getSubstrateNet();
                    if (n != null) {
                        nName = n.getName();
                    }
                    this.print(this.formatUM(x) + "," + this.formatUM(y) + "," + nName + "," + portName + "," + pName + "\n");
                }
            }
            this.mFileWriter.flush();
            this.mFileWriter.close();
            ALog.logInfo((String)("Wrote " + hps.size() + " ports to" + this.mFileName));
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problem writing", (Object[])new Object[0]);
        }
    }

    protected boolean validate() {
        if (this.mFileName == null) {
            return false;
        }
        try {
            this.mFile = new File(this.mFileName);
            this.mFileWriter = new FileWriter(this.mFile);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)("Can not open " + this.mFileName + " for reading"), (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    protected boolean print(String s) throws IOException {
        try {
            this.mFileWriter.write(s);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems writing", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    protected HierPort[][] matrixPorts(ArrayList<HierPort> incoming) {
        ArrayList<Long> xs = new ArrayList<Long>();
        ArrayList<Long> ys = new ArrayList<Long>();
        for (HierPort dpp : incoming) {
            APoint2D p = dpp.getSubstrateLoc();
            long px = p.getX();
            long py = p.getY();
            boolean foundX = false;
            for (Long l : xs) {
                if (px != l) continue;
                foundX = true;
            }
            if (!foundX) {
                xs.add(px);
            }
            boolean foundY = false;
            for (Long y : ys) {
                if (py != y) continue;
                foundY = true;
            }
            if (foundY) continue;
            ys.add(py);
        }
        HierPort[][] mlist = new HierPort[ys.size()][xs.size()];
        Collections.sort(xs);
        Collections.sort(ys);
        Collections.reverse(ys);
        for (HierPort dpp : incoming) {
            long x;
            long y;
            APoint2D p = dpp.getSubstrateLoc();
            long px = p.getX();
            long py = p.getY();
            for (int row = 0; row < ys.size() && py != (y = ((Long)ys.get(row)).longValue()); ++row) {
            }
            for (int i = 0; i < xs.size() && px != (x = ((Long)xs.get(i)).longValue()); ++i) {
            }
            mlist[row][i] = dpp;
        }
        return mlist;
    }
}

