/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.orbit.DevicePath;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;

public class ImportExportUtils {
    public static Unit getExportUnit(DeviceTemplate devT) {
        return ImportExportUtils.getImportUnit(devT).orElseGet(() -> ImportExportUtils.getFinestDescendantImportUnit(devT).orElseGet(() -> Design.getUnit((Db)devT.getDb())));
    }

    public static Optional<Unit> getImportUnit(DeviceTemplate devT) {
        String name = (String)devT.getValue("sourceUnitName", String.class);
        Double dbuPer = (Double)devT.getValue("sourceUnitDbuPer", Double.class);
        return Optional.ofNullable(name != null && dbuPer != null ? new Unit(name, dbuPer.doubleValue()) : null);
    }

    public static Optional<Unit> getFinestDescendantImportUnit(DeviceTemplate devT) {
        return devT.getDescendantDevices().stream().map(DevicePath::getDevice).map(Device::getTemplate).distinct().filter(t -> t.getSubstrate() == devT.getSubstrate()).map(t -> APair.create((Object)t, ImportExportUtils.getImportUnit(t))).filter(pair -> ((Optional)pair.second).isPresent()).min((a, b) -> ImportExportUtils.finerUnitSort((Unit)((Optional)a.second).get(), (Unit)((Optional)b.second).get())).map(pair -> (Unit)((Optional)pair.second).get());
    }

    public static int finerUnitSort(Unit a, Unit b) {
        return -Double.compare(a.getUnitPerUser(), b.getUnitPerUser());
    }

    public static int getBestDbuPerMicron(DeviceTemplate devT, int[] validOptions) {
        int cur;
        assert (devT != null && devT.getDb() != null && Design.getDesign((Db)devT.getDb()) != null);
        assert (validOptions != null && validOptions.length > 0);
        Integer best = null;
        LinkedList<Integer> opts = new LinkedList<Integer>();
        for (int i : validOptions) {
            opts.add(i);
        }
        Collections.sort(opts);
        long dbPerMicron = Design.getInternalPerMicron((Db)devT.getDb());
        Iterator iterator = opts.iterator();
        while (iterator.hasNext() && (long)(best = Integer.valueOf(cur = ((Integer)iterator.next()).intValue())).intValue() < dbPerMicron) {
        }
        Unit exportUnit = ImportExportUtils.getExportUnit(devT);
        if (exportUnit != null) {
            if (exportUnit.getUserName().toLowerCase().startsWith("micron")) {
                int exportUnitPerUser = (int)exportUnit.getUnitPerUser();
                if (opts.contains(exportUnitPerUser)) {
                    best = exportUnitPerUser;
                } else {
                    int cur2;
                    Iterator iterator2 = opts.iterator();
                    while (iterator2.hasNext() && (best = Integer.valueOf(cur2 = ((Integer)iterator2.next()).intValue())) < exportUnitPerUser) {
                    }
                    ALog.logInfo((String)"Attempt to use resolution %d/micron, using best valid option of %d/micron.", (Object[])new Object[]{exportUnitPerUser, best});
                }
            } else {
                ALog.logWarn((String)"Unrecogized export unit '%f/%s', using: %d/micron.", (Object[])new Object[]{exportUnit.getUnitPerUser(), exportUnit.getUserName(), best});
            }
        }
        return best;
    }
}

