/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.PersonalityMappingMgmt;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class JSONExport {
    static final String DesignFileName = "design.js";

    private JSONExport() {
    }

    public static void dumpJSON(String pathToFiles, boolean launch, String designName) {
        try (FileWriter fw = new FileWriter(pathToFiles + "/design.js");){
            File file = new File(pathToFiles + "/design.js");
            File in = new File(AApp.getInstallDir(), "oem/javascript/index.html");
            File out = new File(file.getParent(), designName + ".html");
            String filePath = out.getAbsolutePath();
            Db db = OrbitIO.getCurDb();
            String line = "var design = {\n \t";
            fw.write(line);
            JSONExport.doStructure(fw, db);
            JSONExport.doShapes(designName, file, fw);
            fw.flush();
            JSONExport.moveFiles(file, in, out);
            fw.write("};");
            if (launch) {
                ABrowserControl.displayFile((String)filePath);
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected static void doStructure(FileWriter fw, Db db) {
        Design currentDesign = Design.getDesign((Db)db);
        try {
            fw.write("\"structure\":{");
            fw.write("\n\t\t\"devices\":[");
            boolean first = true;
            for (Device child : currentDesign.getChildren()) {
                if (!first) {
                    fw.write(",");
                }
                first = false;
                JSONExport.doThisDevice(fw, child, 0);
            }
            fw.write("\t\t]\n");
            fw.write("\t},\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void tab(FileWriter fw, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            fw.write("\t");
        }
    }

    protected static void writeLayers(DevicePath path, FileWriter fw, Device device, int level) throws IOException {
        Substrate s = device.getSubstrate();
        fw.write("[");
        boolean first = true;
        Db db = device.getDb();
        for (Layer l : s.getLayers(Layer.TopFirstSort)) {
            Color color;
            String text = "";
            Unit unit = Design.getUnit((Db)db);
            double x = 0.0;
            double y = 0.0;
            double fontsize = 0.0;
            double subx = 0.0;
            double suby = 0.0;
            double subw = 0.0;
            double subh = 0.0;
            ViewColorizer colorizer = OrbitIO.getCurColorizer();
            APatternColor pcolor = colorizer.getColor(path, l);
            Color color2 = color = pcolor == null ? null : pcolor.getColor();
            if (color == null) {
                color = Color.LIGHT_GRAY;
            }
            for (Text t : db.getObjects(Text.class)) {
                if (t.getLayer() == null || !t.getLayer().equals(l)) continue;
                text = t.getText();
                text = text.replaceAll("<[^>]*>", "");
                fontsize = 30.0;
                Substrate s1 = t.getLayer().getSubstrate();
                subx = unit.toUser(s1.getADevicePathUsing().getBB().left());
                suby = unit.toUser(s1.getADevicePathUsing().getBB().bottom());
                subw = unit.toUser(s1.getADevicePathUsing().getBB().width());
                subh = unit.toUser(s1.getADevicePathUsing().getBB().height());
                x = unit.toUser(t.getLoc().getX());
                y = unit.toUser(t.getLoc().getY());
            }
            if (!first) {
                fw.write(",");
            }
            first = false;
            JSONExport.tab(fw, level);
            fw.write("\n\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\"name\":\"" + l.getName() + "\",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"text_x\": " + x + ",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"text_y\": " + y + ",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"sub_x\": " + subx + ",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"sub_y\": " + suby + ",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"sub_w\": " + subw + ",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"sub_h\": " + subh + ",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"text_fontsize\": " + fontsize + ",\n");
            JSONExport.tab(fw, level);
            fw.write("\t\t\t\t\t\t\t\"layertext\": \"" + text + "\",\n");
            JSONExport.tab(fw, level);
            String line = String.format("\t\t\t\t\t\t\t\"color\": \"#%s\"\n\t\t\t\t\t\t}", JSONExport.toHexColor(color));
            JSONExport.tab(fw, level);
            fw.write(line);
        }
        fw.write("\n\t\t\t\t\t]");
    }

    protected static void doThisDevice(FileWriter fw, Device parent, int level) throws IOException {
        if (!parent.getIsSubstrate()) {
            return;
        }
        JSONExport.tab(fw, level);
        fw.write("\n\t\t\t{");
        JSONExport.tab(fw, level + 1);
        fw.write("\n\t\t\t\t\"name\":\"" + parent.getSubstrate().getName() + "\",");
        fw.write("\n\t\t\t\t\"layers\":");
        JSONExport.writeLayers(parent.getADevicePath(), fw, parent, level);
        fw.write("\n\t\t\t}");
        if (parent.hasChildren()) {
            for (Device child : parent.getChildren()) {
                if (child.getIsSubstrate()) {
                    fw.write(",\n");
                }
                JSONExport.doThisDevice(fw, child, level + 1);
            }
            JSONExport.tab(fw, level + 1);
        }
        fw.write("\n");
    }

    protected static void moveFiles(File file, File in, File out) {
        if (!AUtil.copy((File)in, (File)out)) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/drawDesign.js")), (File)(out = new File(file.getParent(), "drawDesign.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/first.css")), (File)(out = new File(file.getParent(), "first.css")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/BootSideMenu.js")), (File)(out = new File(file.getParent(), "BootSideMenu.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/layout-default.css")), (File)(out = new File(file.getParent(), "layout-default.css")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/jquery.layout.js")), (File)(out = new File(file.getParent(), "jquery.layout.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/jquery.js")), (File)(out = new File(file.getParent(), "jquery.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/jquery-ui.js")), (File)(out = new File(file.getParent(), "jquery-ui.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/BootSideMenu.css")), (File)(out = new File(file.getParent(), "BootSideMenu.css")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/second.js")), (File)(out = new File(file.getParent(), "second.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/third.js")), (File)(out = new File(file.getParent(), "third.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/fabric.js")), (File)(out = new File(file.getParent(), "fabric.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/ViewerHelp.html")), (File)(out = new File(file.getParent(), "ViewerHelp.html")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/FileUploadHelp.html")), (File)(out = new File(file.getParent(), "FileUploadHelp.html")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/ViewerDownload.php")), (File)(out = new File(file.getParent(), "ViewerDownload.php")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/FileUploadHelp.html")), (File)(out = new File(file.getParent(), "FileUploadHelp.html")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        in = new File(AApp.getInstallDir(), "oem/javascript/ViewerDownload.php");
        out = new File(file.getParent(), "ViewerDownload.php");
        in = new File(AApp.getInstallDir(), "oem/javascript/help.jpeg");
        if (!AUtil.copy((File)in, (File)(out = new File(file.getParent(), "help.jpeg")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)(in = new File(AApp.getInstallDir(), "oem/javascript/CollapsibleLists.js")), (File)(out = new File(file.getParent(), "CollapsibleLists.js")))) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
        if (!AUtil.copy((File)in, (File)out)) {
            ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
        }
    }

    protected static void doShapes(String designName, File file, FileWriter fw) {
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Unit.Distance unit = currentDesign.getUnit();
        String line = "\"shapes\":{\n \t\t\"objects\": [\n";
        boolean first = true;
        try {
            fw.write(line);
            first = true;
            for (DevicePath childPath : currentDesign.getDescendantDevices()) {
                String tempX;
                Object snakePointsForJson;
                APoint2D p1;
                APoint2D p0;
                HierPin hpAux;
                HierInst hPinT;
                ArrayList<Long> snakeX;
                Object list;
                ArrayList<Long> ptsArrayY;
                ArrayList<Long> ptsArrayX;
                Long pathWidth;
                APath p;
                APoint2D world;
                String tempY;
                Object pointsForJson;
                Color color;
                Device childDevice = childPath.getLast();
                DeviceTemplate dt = childPath.getDeviceTemplate();
                ARect deviceRect = childPath.getBB();
                double x0 = unit.toUser(deviceRect.left());
                double y0 = unit.toUser(deviceRect.bottom());
                double w = unit.toUser(deviceRect.width());
                double h = unit.toUser(deviceRect.height());
                String subName = childDevice.getSubstrate().getName();
                String name = childDevice.getName();
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                APatternColor pcolor = colorizer.getColor(childPath);
                Color color2 = color = pcolor == null ? null : pcolor.getColor();
                if (color == null) {
                    color = Color.LIGHT_GRAY;
                }
                String devName = "device";
                String pinName = "pin";
                String obsName = "obs";
                if (!first) {
                    fw.write(",\n");
                } else {
                    fw.write("\n");
                }
                line = String.format("\t\t\t{\n \t\t\t\t \"x\" : %f,\t\n \t\t\t\t \"y\" : %f, \n \t\t\t\t \"width\" : %f, \n \t\t\t\t \"height\" : %f, \n \t\t\t\t \"color\" : \"#%s\", \n \t\t\t\t \"name\" : \"%s\", \n \t\t\t\t \"type\" : \"%s\",\t\n \t\t\t\t \"Layer\" : \"%s\" \n \t\t\t}", x0, y0, w, h, Integer.toHexString(color.getRGB() & 0xFFFFFF), name, devName, subName);
                fw.write(line);
                first = false;
                AffineTransform t = childPath.getTransform();
                for (Obstacle obs : dt.getObstacles()) {
                    for (LayerShape ls : obs.getLayerShapes()) {
                        Layer l = ls.getLayer();
                        AGeom geom = ls.getGeom();
                        if (l != null) {
                            pcolor = colorizer.getColor(childPath, l);
                            Color color3 = color = pcolor == null ? null : pcolor.getColor();
                        }
                        if (color == null) {
                            color = Color.ORANGE;
                        }
                        APolygon polygon = geom.toPoly();
                        ArrayList<Long> pointsArrayX = new ArrayList<Long>();
                        ArrayList<Long> pointsArrayY = new ArrayList<Long>();
                        for (APoint2D current : polygon.getPoints()) {
                            APoint2D world2 = current.transform(t);
                            long currentX = world2.getX();
                            pointsArrayX.add(currentX);
                            long currentY = world2.getY();
                            pointsArrayY.add(currentY);
                        }
                        String poly = "polygon";
                        pointsForJson = "\"points\":[";
                        for (int j = 0; j < pointsArrayX.size(); ++j) {
                            String tempX2 = "{\"x\":";
                            tempY = "\"y\":";
                            pointsForJson = (String)pointsForJson + tempX2 + unit.toUser(((Long)pointsArrayX.get(j)).longValue()) + ",";
                            pointsForJson = pointsForJson + tempY + unit.toUser(((Long)pointsArrayY.get(j)).longValue()) + "}";
                            pointsForJson = j == pointsArrayY.size() - 1 ? (String)pointsForJson + "]" : (String)pointsForJson + ",";
                        }
                        if (!first) {
                            fw.write(",\n");
                        } else {
                            fw.write("\n");
                        }
                        line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"shape\" : \"%s\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), obsName, poly, pointsForJson);
                        fw.write(line);
                        first = false;
                    }
                }
                for (Metal metal : dt.getMetals()) {
                    pcolor = colorizer.getColor(childPath, metal);
                    color = pcolor == null ? null : pcolor.getColor();
                    AGeom geom = metal.getGeom();
                    APolygon polygon = geom.toPoly();
                    ArrayList<Long> pointsArrayX = new ArrayList<Long>();
                    ArrayList<Long> pointsArrayY = new ArrayList<Long>();
                    for (APoint2D current : polygon.getPoints()) {
                        world = current.transform(t);
                        long currentX = world.getX();
                        pointsArrayX.add(currentX);
                        long currentY = world.getY();
                        pointsArrayY.add(currentY);
                    }
                    Object pointsForJson2 = "\"points\":[";
                    for (int j = 0; j < pointsArrayX.size(); ++j) {
                        String tempX3 = "{\"x\":";
                        String tempY2 = "\"y\":";
                        pointsForJson2 = (String)pointsForJson2 + tempX3 + unit.toUser(((Long)pointsArrayX.get(j)).longValue()) + ",";
                        pointsForJson2 = (String)pointsForJson2 + tempY2 + unit.toUser(((Long)pointsArrayY.get(j)).longValue()) + "}";
                        pointsForJson2 = j == pointsArrayY.size() - 1 ? (String)pointsForJson2 + "]" : (String)pointsForJson2 + ",";
                    }
                    if (!first) {
                        fw.write(",\n");
                    } else {
                        fw.write("\n");
                    }
                    line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"shape\" : \"%s\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "metal", "polygon", pointsForJson2);
                    fw.write(line);
                    first = false;
                }
                for (Bundle bundle : dt.getBundles()) {
                    p = bundle.getPath();
                    color = bundle.getColor();
                    pathWidth = p.getWidth();
                    ptsArrayX = new ArrayList<Long>();
                    ptsArrayY = new ArrayList<Long>();
                    for (APoint2D current : p.getPoints()) {
                        world = current.transform(t);
                        long currentX = world.getX();
                        ptsArrayX.add(currentX);
                        long currentY = world.getY();
                        ptsArrayY.add(currentY);
                    }
                    list = bundle.getRakePattern(true);
                    int i = 0;
                    snakeX = new ArrayList<Long>();
                    ArrayList<Long> snakeY = new ArrayList<Long>();
                    for (SchedConn sc : bundle.getSchedConn()) {
                        PinInstance pin;
                        if (sc.getDPPA() == null || RouteQueue.hasARouteFromBundle(bundle, sc.getDPPA())) continue;
                        Personality personality = PersonalityMappingMgmt.getConnectedPersonality((Net)sc.getDPPA().getNet(), (DevicePath)sc.getDPPA().getPath());
                        color = personality != null ? personality.getColor() : bundle.getColor();
                        hPinT = HierInst.create((DevicePath)((DevicePath)sc.getDPPA().first), (DbObject)((PinInstance)sc.getDPPA().second).getPinTemplate());
                        PinInstance pinInstance = pin = hPinT.getPath().isEmpty() ? PinInstance.getPinInstance((Device)childDevice, (PinTemplate)((PinTemplate)hPinT.getDbObject())) : PinInstance.getPinInstance((HierInst)hPinT);
                        assert (pin != null);
                        if (pin == null) continue;
                        hpAux = new HierPin(hPinT.getPath(), pin);
                        p0 = hpAux.getWorldLoc().transform(t);
                        p1 = (APoint2D)((ArrayList)list).get(i);
                        p1 = p1.transform(t);
                        snakeX.add(p0.getX());
                        snakeX.add(p1.getX());
                        snakeY.add(p0.getY());
                        snakeY.add(p1.getY());
                        ++i;
                        snakePointsForJson = "\"points\":[";
                        for (int j = 0; j < snakeX.size(); ++j) {
                            tempX = "{\"x\":";
                            String tempY3 = "\"y\":";
                            snakePointsForJson = (String)snakePointsForJson + tempX + unit.toUser(((Long)snakeX.get(j)).longValue()) + ",";
                            snakePointsForJson = (String)snakePointsForJson + tempY3 + unit.toUser(((Long)snakeY.get(j)).longValue()) + "}";
                            snakePointsForJson = j == snakeX.size() - 1 ? (String)snakePointsForJson + "]" : (String)snakePointsForJson + ",";
                        }
                        if (!first) {
                            fw.write(",\n");
                        } else {
                            fw.write("\n");
                        }
                        double lwidth = 20.0;
                        line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"net\" : \"%s\",\n \t\t\t\t \"width\" : \"%f\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "wire", "", lwidth, snakePointsForJson);
                        fw.write(line);
                        first = false;
                        snakeX.clear();
                        snakeY.clear();
                    }
                    pointsForJson = "\"points\":[";
                    for (int j = 0; j < ptsArrayX.size(); ++j) {
                        String tempX4 = "{\"x\":";
                        tempY = "\"y\":";
                        pointsForJson = pointsForJson + tempX4 + unit.toUser(((Long)ptsArrayX.get(j)).longValue()) + ",";
                        pointsForJson = (String)pointsForJson + tempY + unit.toUser(((Long)ptsArrayY.get(j)).longValue()) + "}";
                        pointsForJson = j == ptsArrayY.size() - 1 ? (String)pointsForJson + "]" : (String)pointsForJson + ",";
                    }
                    if (!first) {
                        fw.write(",\n");
                    } else {
                        fw.write("\n");
                    }
                    color = bundle.getColor();
                    line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"width\" : \"%f\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "bundle", unit.toUser(pathWidth.longValue()), pointsForJson);
                    fw.write(line);
                    first = false;
                }
                for (Bundle bundle : dt.getBundles()) {
                    p = bundle.getPath();
                    color = bundle.getColor();
                    pathWidth = p.getWidth();
                    ptsArrayX = new ArrayList();
                    ptsArrayY = new ArrayList();
                    for (APoint2D current : p.getPoints()) {
                        world = current.transform(t);
                        long currentX = world.getX();
                        ptsArrayX.add(currentX);
                        long currentY = world.getY();
                        ptsArrayY.add(currentY);
                    }
                    list = bundle.getRakePattern(false);
                    int i = 0;
                    snakeX = new ArrayList();
                    ArrayList<Long> snakeY = new ArrayList<Long>();
                    for (SchedConn sc : bundle.getSchedConn()) {
                        PinInstance pin;
                        if (sc.getDPPB() == null || RouteQueue.hasARouteFromBundle(bundle, sc.getDPPB())) continue;
                        Personality personality = PersonalityMappingMgmt.getConnectedPersonality((Net)sc.getDPPB().getNet(), (DevicePath)sc.getDPPB().getPath());
                        color = personality != null ? personality.getColor() : bundle.getColor();
                        hPinT = HierInst.create((DevicePath)((DevicePath)sc.getDPPB().first), (DbObject)((PinInstance)sc.getDPPB().second).getPinTemplate());
                        PinInstance pinInstance = pin = hPinT.getPath().size() == 0 ? PinInstance.getPinInstance((Device)childDevice, (PinTemplate)((PinTemplate)hPinT.getDbObject())) : PinInstance.getPinInstance((HierInst)hPinT);
                        assert (pin != null);
                        if (pin == null) continue;
                        hpAux = new HierPin(hPinT.getPath(), pin);
                        p0 = hpAux.getWorldLoc().transform(t);
                        p1 = (APoint2D)((ArrayList)list).get(i);
                        p1 = p1.transform(t);
                        snakeX.add(p0.getX());
                        snakeX.add(p1.getX());
                        snakeY.add(p0.getY());
                        snakeY.add(p1.getY());
                        ++i;
                        snakePointsForJson = "\"points\":[";
                        for (int j = 0; j < snakeX.size(); ++j) {
                            tempX = "{\"x\":";
                            String tempY4 = "\"y\":";
                            snakePointsForJson = (String)snakePointsForJson + tempX + unit.toUser(((Long)snakeX.get(j)).longValue()) + ",";
                            snakePointsForJson = (String)snakePointsForJson + tempY4 + unit.toUser(((Long)snakeY.get(j)).longValue()) + "}";
                            snakePointsForJson = j == snakeX.size() - 1 ? (String)snakePointsForJson + "]" : (String)snakePointsForJson + ",";
                        }
                        if (!first) {
                            fw.write(",\n");
                        } else {
                            fw.write("\n");
                        }
                        double lwidth = 20.0;
                        line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"net\" : \"%s\",\n \t\t\t\t \"width\" : \"%f\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "wire", "", lwidth, snakePointsForJson);
                        fw.write(line);
                        first = false;
                        snakeX.clear();
                        snakeY.clear();
                    }
                    if (((ArrayList)list).size() > 0) {
                        APoint2D pt;
                        long xSum = 0L;
                        long ySum = 0L;
                        long xSum1 = 0L;
                        p0 = ((ArrayList)list).iterator();
                        while (p0.hasNext()) {
                            pt = (APoint2D)p0.next();
                            if (xSum < pt.getX()) {
                                xSum = pt.getX();
                            }
                            ySum = pt.getY();
                        }
                        xSum1 = xSum;
                        p0 = ((ArrayList)list).iterator();
                        while (p0.hasNext()) {
                            pt = (APoint2D)p0.next();
                            if (xSum1 <= pt.getX()) continue;
                            xSum1 = pt.getX();
                        }
                        APoint2D midSeqBar = new APoint2D(xSum, ySum);
                        midSeqBar = midSeqBar.transform(t);
                        Object midSeqBar1 = new APoint2D(xSum1, ySum);
                        midSeqBar1 = midSeqBar1.transform(t);
                        if (midSeqBar != null) {
                            snakePointsForJson = "\"points\":[";
                            String tempX5 = "{\"x\":";
                            String tempY5 = "\"y\":";
                            snakePointsForJson = (String)snakePointsForJson + tempX5 + unit.toUser(midSeqBar.getX()) + ",";
                            snakePointsForJson = (String)snakePointsForJson + tempY5 + unit.toUser(midSeqBar.getY()) + "}";
                            snakePointsForJson = (String)snakePointsForJson + ",";
                            snakePointsForJson = (String)snakePointsForJson + tempX5 + unit.toUser(midSeqBar1.getX()) + ",";
                            snakePointsForJson = (String)snakePointsForJson + tempY5 + unit.toUser(midSeqBar1.getY()) + "}";
                            snakePointsForJson = (String)snakePointsForJson + "]";
                            fw.write(",\n");
                            double lwidth = 20.0;
                            line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"net\" : \"%s\",\n \t\t\t\t \"width\" : \"%f\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "wire", "", lwidth, snakePointsForJson);
                            fw.write(line);
                        }
                    }
                    Object pointsForJson3 = "\"points\":[";
                    for (int j = 0; j < ptsArrayX.size(); ++j) {
                        String tempX6 = "{\"x\":";
                        tempY = "\"y\":";
                        pointsForJson3 = (String)pointsForJson3 + tempX6 + unit.toUser(((Long)ptsArrayX.get(j)).longValue()) + ",";
                        pointsForJson3 = (String)pointsForJson3 + tempY + unit.toUser(((Long)ptsArrayY.get(j)).longValue()) + "}";
                        pointsForJson3 = j == ptsArrayY.size() - 1 ? (String)pointsForJson3 + "]" : (String)pointsForJson3 + ",";
                    }
                    if (!first) {
                        fw.write(",\n");
                    } else {
                        fw.write("\n");
                    }
                    color = bundle.getColor();
                    line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"width\" : \"%f\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "bundle", unit.toUser(pathWidth.longValue()), pointsForJson3);
                    fw.write(line);
                    first = false;
                }
                for (Wire wire : dt.getWires()) {
                    Layer l = wire.getLayer();
                    pcolor = colorizer.getColor(childPath, wire);
                    color = pcolor == null ? null : pcolor.getColor();
                    Net n = NetMap.getTopmostNet((Net)wire.getNet(), (DevicePath)childPath);
                    String netName = n.getName();
                    APath path = wire.getPath();
                    subName = l.getName();
                    Long pathWidth2 = path.getWidth();
                    ArrayList<Long> ptsArrayX2 = new ArrayList<Long>();
                    ArrayList<Long> ptsArrayY2 = new ArrayList<Long>();
                    for (APoint2D current : path.getPoints()) {
                        APoint2D world3 = current.transform(t);
                        long currentX = world3.getX();
                        ptsArrayX2.add(currentX);
                        long currentY = world3.getY();
                        ptsArrayY2.add(currentY);
                    }
                    Object pointsForJson4 = "\"points\":[";
                    for (int j = 0; j < ptsArrayX2.size(); ++j) {
                        String tempX7 = "{\"x\":";
                        String tempY6 = "\"y\":";
                        pointsForJson4 = (String)pointsForJson4 + tempX7 + unit.toUser(((Long)ptsArrayX2.get(j)).longValue()) + ",";
                        pointsForJson4 = (String)pointsForJson4 + tempY6 + unit.toUser(((Long)ptsArrayY2.get(j)).longValue()) + "}";
                        pointsForJson4 = j == ptsArrayY2.size() - 1 ? (String)pointsForJson4 + "]" : (String)pointsForJson4 + ",";
                    }
                    if (!first) {
                        fw.write(",\n");
                    } else {
                        fw.write("\n");
                    }
                    line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"net\" : \"%s\",\n \t\t\t\t \"width\" : \"%f\",\t\n \t\t\t\t \"Layer\" : \"%s\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "wire", netName, unit.toUser(pathWidth2.longValue()), subName, pointsForJson4);
                    fw.write(line);
                    first = false;
                }
                for (PinTemplate pt : dt.getPins()) {
                    PinInstance pinInstance = childDevice.getPin(pt);
                    Personality personality = pinInstance.getPersonality();
                    color = null;
                    if (personality != null) {
                        color = personality.getColor();
                    }
                    Net n = NetMap.getTopmostNet((Net)pt.getNet(), (DevicePath)childPath);
                    String netName = n.getName();
                    pinName = pinInstance.getName();
                    for (PortTemplate portTemplate : pt.getPortTemplates()) {
                        PadTemplate padTemplate = portTemplate.getPadTemplate();
                        if (padTemplate == null) continue;
                        for (LayerShape ls : padTemplate.getLayerShapes()) {
                            AffineTransform xform;
                            Layer layer = ls.getLayer();
                            if (color == null) {
                                pcolor = colorizer.getColor(childPath, pt, layer);
                                Color color4 = color = pcolor == null ? null : pcolor.getColor();
                            }
                            if (color == null) {
                                color = Color.red;
                            }
                            if ((xform = portTemplate.getTransform()) != null) {
                                xform.preConcatenate(t);
                            } else {
                                xform = t;
                            }
                            AGeom geom = ls.getGeom();
                            subName = layer.getName();
                            if (geom instanceof ACircle) {
                                ARect c = geom.transform(xform).getBounds();
                                x0 = unit.toUser(c.left());
                                y0 = unit.toUser(c.bottom());
                                w = unit.toUser(c.width());
                                h = unit.toUser(c.height());
                                String circ = "circle";
                                if (!first) {
                                    fw.write(",\n");
                                } else {
                                    fw.write("\n");
                                }
                                line = String.format("\t\t\t{\n \t\t\t\t \"x\" : %f,\t\n \t\t\t\t \"y\" : %f, \n \t\t\t\t \"radius\" : %f, \n \t\t\t\t \"color\" : \"#%s\", \n \t\t\t\t \"opacity\" : \"%f\", \n \t\t\t\t \"shape\" : \"%s\", \n \t\t\t\t \"net\" : \"%s\", \n \t\t\t\t \"name\" : \"%s\", \n \t\t\t\t \"type\" : \"%s\", \n \t\t\t\t \"Layer\" : \"%s\" \n \t\t\t}", x0 + w / 2.0, y0 + h / 2.0, w / 2.0, JSONExport.toHexColor(color), (double)color.getAlpha() / 255.0, circ, netName, pinName, "pin", subName);
                                fw.write(line);
                                first = false;
                                continue;
                            }
                            if (geom instanceof APolygon) {
                                APolygon p2 = (APolygon)geom;
                                ArrayList<Long> pointsArrayX = new ArrayList<Long>();
                                ArrayList<Long> pointsArrayY = new ArrayList<Long>();
                                for (APoint2D current : p2.getPoints()) {
                                    APoint2D world4 = current.transform(xform);
                                    long currentX = world4.getX();
                                    pointsArrayX.add(currentX);
                                    long currentY = world4.getY();
                                    pointsArrayY.add(currentY);
                                }
                                String poly = "polygon";
                                Object pointsForJson5 = "\"points\":[";
                                for (int j = 0; j < pointsArrayX.size(); ++j) {
                                    String tempX8 = "{\"x\":";
                                    String tempY7 = "\"y\":";
                                    pointsForJson5 = (String)pointsForJson5 + tempX8 + unit.toUser(((Long)pointsArrayX.get(j)).longValue()) + ",";
                                    pointsForJson5 = (String)pointsForJson5 + tempY7 + unit.toUser(((Long)pointsArrayY.get(j)).longValue()) + "}";
                                    pointsForJson5 = j == pointsArrayY.size() - 1 ? (String)pointsForJson5 + "]" : (String)pointsForJson5 + ",";
                                }
                                if (!first) {
                                    fw.write(",\n");
                                } else {
                                    fw.write("\n");
                                }
                                line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"net\" : \"%s\",\n \t\t\t\t \"name\" : \"%s\",\n \t\t\t\t \"shape\" : \"%s\", \n \t\t\t\t \"Layer\" : \"%s\",\n \t\t\t\t %s \n \t\t\t}", JSONExport.toHexColor(color), "pin", netName, pinName, poly, subName, pointsForJson5);
                                fw.write(line);
                                first = false;
                                continue;
                            }
                            ARect r = geom.transform(xform).getBounds();
                            x0 = unit.toUser(r.left());
                            y0 = unit.toUser(r.bottom());
                            w = unit.toUser(r.width());
                            h = unit.toUser(r.height());
                            name = pt.getName();
                            String rec = "rectangle";
                            if (!first) {
                                fw.write(",\n");
                            } else {
                                fw.write("\n");
                            }
                            line = String.format("\t\t\t{\n \t\t\t\t \"x\" : %f,\t\n \t\t\t\t \"y\" : %f, \n \t\t\t\t \"width\" : %f, \n \t\t\t\t \"height\" : %f, \n \t\t\t\t \"color\" : \"#%s\", \n \t\t\t\t \"opacity\" : \"%f\", \n \t\t\t\t \"shape\" : \"%s\", \n \t\t\t\t \"net\" : \"%s\", \n \t\t\t\t \"name\" : \"%s\", \n \t\t\t\t \"type\" : \"%s\", \n \t\t\t\t \"Layer\" : \"%s\" \n \t\t\t}", x0, y0, w, h, JSONExport.toHexColor(color), (double)color.getAlpha() / 255.0, rec, netName, pinName, "pin", subName);
                            fw.write(line);
                            first = false;
                        }
                    }
                }
            }
            for (Connection c : db.getObjects(Connection.class)) {
                Color color;
                DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
                ViewColorizer colorizer = dv2d.getColorizer();
                APatternColor pcolor = colorizer.getColor(c);
                Color color5 = color = pcolor == null ? null : pcolor.getColor();
                if (color == null) continue;
                Net n = c.getNet();
                ALine l = c.getLine();
                if (l == null) continue;
                double x0 = unit.toUser(l.getP0().getX());
                double y0 = unit.toUser(l.getP0().getY());
                double x1 = unit.toUser(l.getP1().getX());
                double y1 = unit.toUser(l.getP1().getY());
                if (!first) {
                    fw.write(",\n");
                } else {
                    fw.write("\n");
                }
                double lwidth = 10.0;
                line = String.format("\t\t\t{\n \t\t\t\t \"color\" : \"#%s\",\n \t\t\t\t \"type\" : \"%s\",\n \t\t\t\t \"net\" : \"%s\",\n \t\t\t\t \"width\" : %f,\n \t\t\t\t \"x0\" : %f,\n \t\t\t\t \"y0\" : %f,\n \t\t\t\t \"x1\" : %f,\n \t\t\t\t \"y1\" : %f \n \t\t\t}", JSONExport.toHexColor(color), "rat", n.getName(), lwidth, x0, y0, x1, y1);
                fw.write(line);
                first = false;
            }
            line = "\n\t\t\t]\n\t}}\n";
            fw.write(line);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static String toHexColor(Color color) {
        int rgb = 0;
        rgb = color != null ? color.getRGB() & 0xFFFFFF : 0xFFFFFF;
        return String.format("%06x", rgb);
    }
}

