/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.LEFDEFSyntax;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.export.DEFOut;
import com.sigrity.orbit.export.ImportExportUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class LEFOut {
    protected Db mDb;
    protected File mFile;
    protected BufferedWriter mOut;
    private double mDistanceScale;
    private int mBestDbuPerMicron;
    static final String[] kLayerDirections = new String[]{"HORIZONTAL", "VERTICAL"};
    int mAlternateDirection;

    public static LEFOut create(Db db) {
        return new LEFOut(db);
    }

    public LEFOut(Db db) {
        this.mDb = db;
    }

    public LEFOut() {
        this(OrbitApp.getCurDb());
    }

    public void setFile(String filePath) {
        this.mFile = new File(filePath);
    }

    @Deprecated
    public void writeDescendants(String devTKey) {
        DeviceTemplate devT;
        DeviceTemplate deviceTemplate = devT = this.mDb == null ? null : (DeviceTemplate)this.mDb.getByKeyStr(DeviceTemplate.class, devTKey);
        if (devT == null) {
            ALog.logError((String)"No DeviceTemplate with key '%s' found in database '%s'.", (Object[])new Object[]{devTKey, this.mDb});
            return;
        }
        if (!this.open()) {
            return;
        }
        try {
            devT.getDescendantOnSubstrate().stream().map(DevicePath::getDeviceTemplate).distinct().filter(this::canWriteToLEF).sorted().forEach(this::writeTemplate);
        }
        finally {
            this.close();
        }
    }

    public void writeDescendantsWithSubstrates(String devicePath, String fileName) {
        this.writeDescendantsWithSubstrates(devicePath, fileName, false);
    }

    public void writeDescendantsWithSubstrates(String devicePath, String fileName, boolean includeSynthesized) {
        DevicePath dp = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePath);
        this.write(dp, fileName, WriteMode.WITHSUBSTRATE);
        if (includeSynthesized) {
            this.write(dp, fileName, WriteMode.SYNTHESIZED_ONLY);
        }
    }

    private void preLEFWrite(DevicePath dp) {
        this.mBestDbuPerMicron = ImportExportUtils.getBestDbuPerMicron(dp.getDeviceTemplate(), DEFOut.LEFDEF_VALID_DBUPERMICRON);
        this.mDistanceScale = 1.0 / (double)Design.getInternalPerMicron((Db)this.mDb);
    }

    private double scale(long v) {
        return this.mDistanceScale * (double)v;
    }

    private double scale(double v) {
        return this.mDistanceScale * v;
    }

    private String scaleAndRoundFormat(long v) {
        double d = this.scale(v);
        return this.roundFormat(d);
    }

    private String scaleAndRoundFormat(double v) {
        double d = this.scale(v);
        return this.roundFormat(d);
    }

    private String roundFormat(double value) {
        DecimalFormat df = new DecimalFormat("#.###");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(value);
    }

    private void postLEFWrite(DevicePath dp) {
    }

    public void write(DevicePath dp, String fileName, WriteMode mode) {
        this.preLEFWrite(dp);
        switch (mode) {
            case SYNTHESIZED_ONLY: {
                this.writeModeSynthesized(dp, fileName);
                break;
            }
            case WITHSUBSTRATE: {
                this.writeModeWithSubstrates(dp, fileName);
                break;
            }
            default: {
                ALog.logInfo((String)"Unrecognized LEFOut.write mode: '%s'.", (Object[])new Object[]{mode});
            }
        }
        this.postLEFWrite(dp);
    }

    @Deprecated
    public void write(DevicePath dp, String fileName, String mode) {
        WriteMode writeMode;
        switch (mode) {
            case "synthesized": {
                writeMode = WriteMode.SYNTHESIZED_ONLY;
                break;
            }
            case "withSubstrate": {
                writeMode = WriteMode.WITHSUBSTRATE;
                break;
            }
            default: {
                ALog.logError((String)"Unrecognized LEFOut.write mode: '%s'.", (Object[])new Object[]{mode});
                throw new IllegalArgumentException();
            }
        }
        this.write(dp, fileName, writeMode);
    }

    private boolean canWriteToLEF(DeviceTemplate t) {
        if (t.getSourceType() == DeviceTemplate.SourceType.LEFDEF) {
            return true;
        }
        DeviceTemplate.Type type = t.getType();
        return type == DeviceTemplate.Type.DIE || type == DeviceTemplate.Type.PACKAGE || type == DeviceTemplate.Type.INTERPOSER || type == DeviceTemplate.Type.PACKAGEDDIE || type == DeviceTemplate.Type.BLOCK || type == DeviceTemplate.Type.PAD || type == DeviceTemplate.Type.CORE || type == DeviceTemplate.Type.MACRO || type == DeviceTemplate.Type.HARDMACRO || type == DeviceTemplate.Type.SOFTMACRO || type == DeviceTemplate.Type.BUMP || type == DeviceTemplate.Type.STDCELL;
    }

    private boolean canWriteToLEFNonSynthesized(DeviceTemplate t) {
        return !t.getIsSynthesized() && this.canWriteToLEF(t);
    }

    private boolean canWriteToLEFSynthesized(DeviceTemplate t) {
        return t.getIsSynthesized() && this.canWriteToLEF(t);
    }

    private String getTechLEFFilename(String fileName, String substrateName) {
        return this.insertSuffix(fileName, "_" + substrateName, "_sub");
    }

    private String getSynLEFFilename(String fileName) {
        return this.insertSuffix(fileName, "_syn");
    }

    private String insertSuffix(String fileName, String ... suffix) {
        int extIndex = fileName.lastIndexOf(46);
        String ext = extIndex > -1 ? fileName.substring(extIndex) : "";
        Object fileNoExtName = extIndex > -1 ? fileName.substring(0, extIndex) : fileName;
        for (String s : suffix) {
            fileNoExtName = (String)fileNoExtName + s;
        }
        return (String)fileNoExtName + ext;
    }

    public void writeModeSynthesized(DevicePath dp, String fileName) {
        this.mFile = new File(this.getSynLEFFilename(fileName));
        if (!this.open()) {
            return;
        }
        this.writePrelude(dp.getSubstrate());
        dp.getDeviceTemplate().getDescendantOnSubstrate().stream().map(DevicePath::getDeviceTemplate).distinct().filter(this::canWriteToLEFSynthesized).filter(devT -> devT.getType() != DeviceTemplate.Type.DIE).forEach(this::writeTemplate);
        this.close();
    }

    protected void writeTemplates(DevicePath dp, String fileName) {
        this.mFile = new File(fileName);
        if (!this.open()) {
            return;
        }
        try {
            this.writePrelude(dp.getSubstrate());
            dp.getDeviceTemplate().getDescendantOnSubstrate().stream().map(DevicePath::getDeviceTemplate).distinct().filter(this::canWriteToLEFNonSynthesized).sorted().forEach(this::writeTemplate);
        }
        finally {
            this.close();
        }
    }

    public void writeModeWithSubstrates(DevicePath dp, String fileName) {
        Substrate.getDescendantSubstrates((DevicePath)dp).stream().forEach(s -> {
            String subFilename = this.getTechLEFFilename(fileName, s.getName());
            this.mFile = new File(subFilename);
            if (!this.open()) {
                return;
            }
            this.writeSubstrate((Substrate)s);
            this.close();
        });
        this.writeTemplates(dp, fileName);
    }

    protected boolean open() {
        try {
            if (this.mFile.delete()) {
                ALog.logDebug((String)"Delete file '%s'", (Object[])new Object[]{this.mFile});
            }
            this.mOut = new BufferedWriter(new FileWriter(this.mFile));
            Date now = new Date();
            String buffer = "#\n# Writen by OrbitIO on " + now.toString() + "\n#\n";
            this.print(buffer, new Object[0]);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error: LEF Export: %s.", (Object[])new Object[]{e.getLocalizedMessage()});
            return false;
        }
        return true;
    }

    protected boolean close() {
        try {
            this.mOut.close();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error: LEF Export close: %s.", (Object[])new Object[]{e.getLocalizedMessage()});
            return false;
        }
        return true;
    }

    protected void writeUnits(Substrate s) {
        this.println("UNITS", new Object[0]);
        this.println("  DATABASE MICRONS %d ;", this.mBestDbuPerMicron);
        this.println("  TIME NANOSECONDS 1 ;", new Object[0]);
        this.println("  CAPACITANCE PICOFARADS 1 ;", new Object[0]);
        this.println("  RESISTANCE OHMS 1 ;", new Object[0]);
        this.println("  POWER MILLIWATTS 1 ;", new Object[0]);
        this.println("  CURRENT MILLIAMPS 1 ;", new Object[0]);
        this.println("  VOLTAGE VOLTS 1 ;", new Object[0]);
        this.println("  FREQUENCY MEGAHERTZ 1 ;", new Object[0]);
        this.println("END UNITS", new Object[0]);
        this.println("", new Object[0]);
    }

    protected void writePropertyDefinitions(Substrate s) {
        List<String> liststr = this.getPropertyDefinitions(s);
        if (!liststr.isEmpty()) {
            this.println("PROPERTYDEFINITIONS", new Object[0]);
            for (String str : liststr) {
                this.println(str, new Object[0]);
            }
            this.println("END PROPERTYDEFINITIONS", new Object[0]);
        }
    }

    private List<String> getPropertyDefinitions(Substrate s) {
        Object pds = s.getValue("LEF58.PROPERTYDEFINITIONS");
        if (pds != null) {
            if (pds.getClass() == String.class) {
                return List.of((String)pds);
            }
            return (List)pds;
        }
        return Collections.emptyList();
    }

    protected void writePrelude(Substrate s) {
        this.println("VERSION 5.8 ;", new Object[0]);
        this.println("BUSBITCHARS \"[]\" ;", new Object[0]);
        this.println("DIVIDERCHAR \"/\" ;", new Object[0]);
        this.println("CLEARANCEMEASURE EUCLIDEAN ;", new Object[0]);
        this.writePropertyDefinitions(s);
        this.println("", new Object[0]);
        if (s != null) {
            this.writeUnits(s);
        }
        this.println("MANUFACTURINGGRID %f ;", 1.0 / (double)this.mBestDbuPerMicron);
        this.println("USEMINSPACING OBS OFF ;", new Object[0]);
        this.println("", new Object[0]);
    }

    protected void writeSubstrate(Substrate s) {
        this.writePrelude(s);
        this.writeLayers(s);
    }

    protected void writeLayers(Substrate s) {
        List layers = s.getLayers(Layer.BottomFirstSort).stream().collect(Collectors.toList());
        boolean fakeDirection = layers.stream().allMatch(l -> l.getValue("direction") == null);
        if (fakeDirection) {
            this.mAlternateDirection = 0;
        }
        layers.stream().forEach(l -> this.writeLayer((Layer)l, fakeDirection));
    }

    private boolean isLayerAllowedInLEF(Layer l) {
        Layer.LayerType type = l.getType();
        return type == Layer.LayerType.Cut || type == Layer.LayerType.Route || type == Layer.LayerType.Signal || type == Layer.LayerType.Overlap || type == Layer.LayerType.MasterSlice;
    }

    private void writeCutLayer(Layer l) {
        this.println("TYPE CUT ;", new Object[0]);
        Long spacing = (Long)l.getValue("spacing");
        if (spacing != null) {
            this.println("SPACING " + this.scaleAndRoundFormat(spacing) + " ;", new Object[0]);
        }
        this.println("WIDTH " + this.scaleAndRoundFormat(l.getWidth()) + " ;", new Object[0]);
    }

    private void writeImplantLayer(Layer l) {
        this.println("TYPE IMPLANT ;", new Object[0]);
        double w = this.scale(l.getWidth());
        if (w == 0.0) {
            w = 0.1;
        }
        this.println("WIDTH " + this.scaleAndRoundFormat(w) + " ;", new Object[0]);
        Long spacing = (Long)l.getValue("spacing");
        if (spacing != null) {
            this.println("SPACING " + this.scaleAndRoundFormat(spacing) + " ;", new Object[0]);
        }
    }

    private void writeMasterSliceOrOverlapLayer(Layer l) {
        this.println(l.getType() == Layer.LayerType.MasterSlice ? "TYPE MASTERSLICE ;" : "TYPE OVERLAP ;", new Object[0]);
    }

    private String toNoScientificNotation(Double v) {
        return String.format("%f", v);
    }

    private void writeRoutingLayerDirection(Layer l, boolean fakeDirection) {
        String direction;
        String string = direction = fakeDirection ? kLayerDirections[this.mAlternateDirection++ & 1] : (String)l.getValue("direction");
        if (direction == null) {
            direction = "HORIZONTAL";
        }
        this.println("DIRECTION " + direction + " ;", new Object[0]);
    }

    private void writeRoutingLayerPitch(Layer l) {
        Double pitch1 = (Double)l.getValue("pitch1");
        if (pitch1 != null) {
            this.print("PITCH " + this.toNoScientificNotation(pitch1), new Object[0]);
            Double pitch2 = (Double)l.getValue("pitch2");
            if (pitch2 != null) {
                this.print(" " + this.toNoScientificNotation(pitch2), new Object[0]);
            }
            this.println(" ;", new Object[0]);
        } else {
            double kPitch = 0.56;
            ALog.logWarn((String)"[LAYER] No pitch information for '%s'! Default %f.", (Object[])new Object[]{l.getName(), 0.56});
            this.println("PITCH " + Double.toString(0.56) + " ;", new Object[0]);
        }
    }

    private void writeRoutingLayerWidth(Layer l) {
        if (l.getWidth() == 0L) {
            this.println("WIDTH 0.1 ;", new Object[0]);
        } else {
            this.println("WIDTH " + this.scaleAndRoundFormat(l.getWidth()) + " ;", new Object[0]);
        }
    }

    private void writeRoutingLayerSpacing(Layer l) {
        Long spacing = (Long)l.getValue("spacing");
        if (spacing != null) {
            this.println("SPACING " + this.scaleAndRoundFormat(spacing) + " ;", new Object[0]);
        } else {
            double kSpacing = 0.23;
            ALog.logWarn((String)"[LAYER] No spacing information for '%s'! Default %f.", (Object[])new Object[]{l.getName(), 0.23});
            this.println("SPACING " + Double.toString(0.23) + " ;", new Object[0]);
        }
    }

    private void writeRoutingLayerWireExtension(Layer l) {
        Constraint wem = Constraint.getConstraint((DbObject)l, (Constraint.Descriptor)Constraint.getDescriptor((String)"Wire Extension Model"));
        if (wem != null) {
            String extensionModel = (String)wem.getValue();
            if (extensionModel.equals(Constraint.WireExtensionModel.ZERO.name())) {
                this.println("WIREEXTENSION 0 ;", new Object[0]);
            } else if (extensionModel.equals(Constraint.WireExtensionModel.SPECIAL.name())) {
                Constraint wel = Constraint.getConstraint((DbObject)l, (Constraint.Descriptor)Constraint.getDescriptor((String)"Wire Extension Length"));
                if (wel != null) {
                    String length = (String)wel.getValue();
                    if (length != null) {
                        this.println("WIREEXTENSION " + this.toNoScientificNotation(Double.parseDouble(length)), new Object[0]);
                    }
                } else {
                    this.println("WIREEXTENSION 0 ;", new Object[0]);
                }
            }
        }
    }

    private void writeRoutingLayer(Layer l, boolean fakeDirection) {
        this.println("TYPE ROUTING ;", new Object[0]);
        this.writeRoutingLayerDirection(l, fakeDirection);
        this.writeRoutingLayerPitch(l);
        this.writeRoutingLayerWidth(l);
        this.writeRoutingLayerSpacing(l);
        this.writeRoutingLayerWireExtension(l);
        this.println("RESISTANCE RPERSQ " + this.toNoScientificNotation(l.getResistance()) + " ;", new Object[0]);
        this.println("CAPACITANCE CPERSQDIST " + this.toNoScientificNotation(l.getCapacitance()) + " ;", new Object[0]);
    }

    protected void writeLayerProperty(Layer l) {
        List str;
        Object prop = l.getValue("LEFDEF.PROPERTY");
        if (prop != null && !(str = (List)prop).isEmpty()) {
            for (String s : str) {
                this.println("PROPERTY " + s + " ;", new Object[0]);
            }
        }
    }

    protected void writeLayer(Layer l, boolean fakeDirection) {
        if (!this.isLayerAllowedInLEF(l)) {
            return;
        }
        this.println("LAYER " + l.getName(), new Object[0]);
        switch (l.getType()) {
            case Cut: {
                this.writeCutLayer(l);
                break;
            }
            case MasterSlice: 
            case Overlap: {
                this.writeMasterSliceOrOverlapLayer(l);
                break;
            }
            case Route: 
            case Signal: {
                this.writeRoutingLayer(l, fakeDirection);
                break;
            }
            case Implant: {
                this.writeImplantLayer(l);
                break;
            }
            default: {
                if (!AclInfo.getDebugMode()) break;
                ALog.logDebug((Throwable)new UnsupportedOperationException(), (String)"Unsupport: Layer Type", (Object[])new Object[0]);
            }
        }
        this.writeLayerProperty(l);
        this.println("END " + l.getName(), new Object[0]);
        this.println("", new Object[0]);
    }

    protected void writeTemplateForeign(DeviceTemplate t) {
        String nameStr;
        Object o = t.getValue("LEFDEF.FOREIGN");
        if (o != null && !(nameStr = (String)o).isEmpty()) {
            Object ptStr = "";
            String orientStr = "";
            o = t.getValue("LEFDEF.FOREIGN.PT");
            if (o != null) {
                APoint2D pt = (APoint2D)o;
                ptStr = this.scaleAndRoundFormat(pt.getX()) + " " + this.scaleAndRoundFormat(pt.getY()) + " ";
                o = t.getValue("LEFDEF.FOREIGN.ORIENT");
                if (o != null) {
                    orientStr = (String)o;
                }
            }
            this.println("FOREIGN " + nameStr + " " + (String)ptStr + orientStr + " ;", new Object[0]);
        }
    }

    protected void writeTemplate(DeviceTemplate t) {
        this.println("MACRO " + t.getName(), new Object[0]);
        this.println(this.getMacroType(t), new Object[0]);
        this.writeTemplateForeign(t);
        this.println("ORIGIN 0.000 0.000 ;", new Object[0]);
        AGeom shape = t.getBounds();
        ARect bb = t.getBB();
        APoint2D offset = bb.getLL();
        this.println("SIZE " + this.scaleAndRoundFormat(bb.width()) + " BY " + this.scaleAndRoundFormat(bb.height()) + " ;", new Object[0]);
        this.println("SYMMETRY X Y R90 ;", new Object[0]);
        t.getNets().forEach(n -> this.writeTerm((Net)n, offset));
        APoint2D obsOffset = APoint2D.Zero().sub(offset);
        t.getObstacles().forEach(obs -> this.writeObs((Obstacle)obs, obsOffset));
        if (!(shape instanceof ARect)) {
            this.writeSynthObs(shape, obsOffset);
        }
        this.println("END " + t.getName() + "\n", new Object[0]);
    }

    @Deprecated
    protected void writeNet(Net n, APoint2D offset) {
        n.getPinTemplates().stream().filter(pinT -> pinT.getType() != PinTemplate.Type.TOPOLOGYPOINT).forEach(pinT -> {
            this.println("PIN " + pinT.getName(), new Object[0]);
            pinT.getPortTemplates().forEach(port -> this.writePort((PortTemplate)port, offset));
            this.println("END " + pinT.getName(), new Object[0]);
        });
    }

    private void writeTerm(Net n, APoint2D offset) {
        n.getTerms().stream().forEach(term -> {
            this.println("PIN " + term.getName(), new Object[0]);
            this.writeTermAttrs((Term)term);
            this.writeNetPins(n, offset);
            this.println("END " + term.getName(), new Object[0]);
        });
    }

    private void writeTermAttrs(Term term) {
        this.println("DIRECTION " + LEFDEFSyntax.PinDirection.getPinDirection(term.getType()) + " ;", new Object[0]);
        this.println("USE " + LEFDEFSyntax.PinUse.getPinUse(term.getUse()) + " ;", new Object[0]);
    }

    private void writeNetPins(Net n, APoint2D offset) {
        n.getPinTemplates().stream().filter(pinT -> pinT.getType() != PinTemplate.Type.TOPOLOGYPOINT).forEach(pinT -> pinT.getPortTemplates().forEach(port -> this.writePort((PortTemplate)port, offset)));
    }

    protected void writePort(PortTemplate port, APoint2D offset) {
        this.println("PORT", new Object[0]);
        PadTemplate padT = port.getPadTemplate();
        if (padT == null) {
            return;
        }
        APoint2D p = port.getLoc().sub(offset);
        padT.getLayerShapes().forEach(ls -> this.writeLayerShape((LayerShape)ls, p));
        this.println("END", new Object[0]);
    }

    protected void writeLayerShape(LayerShape ls, APoint2D loc) {
        AGeom geom = ls.getGeom();
        this.println("LAYER  " + ls.getLayer().getName() + " ;", new Object[0]);
        this.writeGeom(geom, loc);
    }

    protected void writeGeom(AGeom geom, APoint2D offset) {
        if (geom instanceof ACircle) {
            ACircle circle = (ACircle)geom;
            ACircle zeroCircle = circle.copy();
            zeroCircle.moveBy(offset);
            APolygon poly = zeroCircle.toPoly(8);
            this.print("POLYGON", new Object[0]);
            for (APoint2D pts : poly.getPoints()) {
                double x = pts.getX();
                double y = pts.getY();
                this.print(" " + this.scaleAndRoundFormat(x) + " " + this.scaleAndRoundFormat(y), new Object[0]);
            }
            this.println(" ;", new Object[0]);
        } else if (geom instanceof APolygon) {
            APolygon transP = ((APolygon)geom).toPoly();
            transP.moveBy(offset.getX(), offset.getY());
            this.print("POLYGON", new Object[0]);
            for (APoint2D pts : transP.getPoints()) {
                double x = pts.getX();
                double y = pts.getY();
                this.print(" " + this.scaleAndRoundFormat(x) + " " + this.scaleAndRoundFormat(y), new Object[0]);
            }
            this.println(" ;", new Object[0]);
        } else if (geom instanceof ARect) {
            ARect boundRect = (ARect)geom;
            boundRect = boundRect.normalize();
            APoint2D c = new APoint2D(offset);
            boundRect.moveBy(c.getX(), c.getY());
            APoint2D ll = boundRect.getLL();
            APoint2D ur = boundRect.getUR();
            this.println("RECT " + this.scaleAndRoundFormat(ll.getX()) + " " + this.scaleAndRoundFormat(ll.getY()) + " " + this.scaleAndRoundFormat(ur.getX()) + " " + this.scaleAndRoundFormat(ur.getY()) + " ;", new Object[0]);
        } else {
            try {
                APolygon p = geom.toPoly();
                this.writeGeom((AGeom)p, offset);
            }
            catch (Exception e) {
                ALog.flogWarn((Throwable)e, (String)"LEFOut: Cannot process the shape '%s'. Use bound box instead of.", (Object[])new Object[]{geom});
                this.writeGeom((AGeom)geom.getBounds(), offset);
            }
        }
    }

    protected void writeObs(Obstacle obs, APoint2D offset) {
        if (obs == null) {
            return;
        }
        obs.getLayerShapes().forEach(ls -> {
            this.println("OBS", new Object[0]);
            this.println("LAYER %s ;", ls.getLayer().getName());
            AGeom g = ls.getGeom();
            this.writeGeom(g, offset);
            this.println("END", new Object[0]);
        });
    }

    private String getLayerWithSameUppercaseName(String nameInUppercase) {
        return Substrate.getSubstrates((Db)OrbitApp.getCurDb()).stream().flatMap(s -> s.getLayers().stream()).map(Layer::getName).filter(n -> n.equalsIgnoreCase(nameInUppercase)).findAny().orElse(null);
    }

    protected void writeSynthObs(AGeom geom, APoint2D loc) {
        if (geom == null) {
            return;
        }
        this.println("OBS", new Object[0]);
        String overlapLayerName = this.getLayerWithSameUppercaseName("OVERLAP");
        if (overlapLayerName == null) {
            this.println("LAYER OVERLAP ;", new Object[0]);
        } else {
            this.println("LAYER %s ;", overlapLayerName);
        }
        this.writeGeom(geom, loc);
        this.println("END", new Object[0]);
    }

    protected boolean println(String fmt, Object ... args) {
        return this.print(fmt + "\n", args);
    }

    protected boolean print(String fmt, Object ... args) {
        try {
            this.mOut.write(String.format(fmt, args));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected String getMacroType(DeviceTemplate t) {
        if (t.getType().equals((Object)DeviceTemplate.Type.COVER)) {
            return "CLASS COVER ;";
        }
        if (t.getType().equals((Object)DeviceTemplate.Type.BUMP)) {
            return "CLASS COVER BUMP ;";
        }
        if (t.getType().equals((Object)DeviceTemplate.Type.BLOCK)) {
            return "CLASS BLOCK ;";
        }
        if (t.getType().equals((Object)DeviceTemplate.Type.RING)) {
            return "CLASS RING ;";
        }
        if (t.getType().equals((Object)DeviceTemplate.Type.CORE)) {
            return "CLASS CORE ;";
        }
        if (t.getType().equals((Object)DeviceTemplate.Type.ENDCAP)) {
            return "CLASS ENDCAP ;";
        }
        if (t.getType() == DeviceTemplate.Type.HARDMACRO) {
            return "CLASS BLOCK BLACKBOX ;";
        }
        if (t.getType() == DeviceTemplate.Type.SOFTMACRO) {
            return "CLASS BLOCK SOFT ;";
        }
        return "CLASS PAD ;";
    }

    public static enum WriteMode {
        SYNTHESIZED_ONLY,
        WITHSUBSTRATE;

    }
}

