/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class NetLengthOut {
    protected Db mDb;
    protected File mFile = null;
    protected FileWriter mFileWriter;
    protected String mFileName;
    protected Design mDesign;
    ArrayList<Long> mLengthOnSubs = new ArrayList();

    public NetLengthOut() {
        this.mDb = OrbitIO.getCurDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
    }

    protected boolean validate() {
        if (this.mFileName == null) {
            return false;
        }
        try {
            this.mFile = new File(this.mFileName);
            this.mFileWriter = new FileWriter(this.mFile);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Can not open %s for writing", (Object[])new Object[]{this.mFileName});
            return false;
        }
        return true;
    }

    public void write(String fileName, boolean justSelected, boolean openWhenFinished) {
        Net n;
        this.mFileName = fileName;
        if (!this.validate()) {
            return;
        }
        List<Substrate> subList = this.mDb.getObjects(Substrate.class).stream().distinct().sorted().collect(Collectors.toList());
        this.writeHeader(subList);
        for (int i = 0; i <= subList.size(); ++i) {
            this.mLengthOnSubs.add(i, 0L);
        }
        List netLists = !justSelected ? this.mDb.getObjects(Net.class).stream().map(obj -> obj).distinct().sorted().collect(Collectors.toList()) : this.mDesign.getCurSelection().get(Net.class).stream().distinct().sorted().collect(Collectors.toList());
        List<Connection> connectionList = this.mDb.getObjects(Connection.class).stream().collect(Collectors.toList());
        Iterator iterator = netLists.iterator();
        while (iterator.hasNext() && ((n = (Net)iterator.next()).isUnused() || this.writeNet(n, subList, connectionList))) {
        }
        this.writeTotals();
        try {
            this.mFileWriter.close();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems closing", (Object[])new Object[0]);
            return;
        }
        if (openWhenFinished) {
            this.openWhenFinished();
        }
    }

    protected void writeTotals() {
        Object s = "Totals";
        int l = this.mLengthOnSubs.size();
        for (int i = 0; i < l; ++i) {
            s = (String)s + ",";
            s = (String)s + this.mDesign.getUser(this.mLengthOnSubs.get(i).longValue());
        }
        s = (String)s + "\n";
        try {
            this.mFileWriter.write((String)s);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems writing", (Object[])new Object[0]);
        }
    }

    protected void openWhenFinished() {
        String fixedFileName = this.mFileName.replace("\\", "\\\\");
        UIUtil.openLocalEditor((String)"EditorCSV", (String)fixedFileName);
    }

    protected void writeHeader(List<Substrate> subList) {
        try {
            this.print(" ");
            for (Substrate s : subList) {
                this.print(",");
                this.print(s.getName());
            }
            this.print(", Design");
            this.print("\n");
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems closing", (Object[])new Object[0]);
        }
    }

    protected boolean writeNet(Net n, List<Substrate> subList, List<Connection> connectionList) {
        ArrayList<Long> lengthOnSub = new ArrayList<Long>();
        int l = subList.size();
        for (int i = 0; i <= l; ++i) {
            lengthOnSub.add(i, 0L);
        }
        connectionList.stream().filter(c -> c.getDPPA().getTopMostNet().equals(n)).forEach(c -> {
            long length;
            Substrate s0 = c.getPortA().getSubstrate();
            Substrate s1 = c.getPortB().getSubstrate();
            int s0Index = subList.indexOf(s0);
            int s1Index = subList.indexOf(s1);
            long s0Length = length = c.getLine().getLength();
            long s1Length = 0L;
            if (s0Index != s1Index && c.getDPPA().getWorldBounds().area() < c.getDPPB().getWorldBounds().area()) {
                s0Length = 0L;
                s1Length = length;
            }
            lengthOnSub.set(s0Index, s0Length + (Long)lengthOnSub.get(s0Index));
            lengthOnSub.set(s1Index, s1Length + (Long)lengthOnSub.get(s1Index));
            lengthOnSub.set(l, s1Length + s0Length + (Long)lengthOnSub.get(l));
            this.mLengthOnSubs.set(s0Index, s0Length + this.mLengthOnSubs.get(s0Index));
            this.mLengthOnSubs.set(s1Index, s1Length + this.mLengthOnSubs.get(s1Index));
            this.mLengthOnSubs.set(l, s1Length + s0Length + this.mLengthOnSubs.get(l));
        });
        String s = n.getFullPathName();
        for (int i = 0; i <= l; ++i) {
            s = s + ",";
            s = s + this.mDesign.getUser(((Long)lengthOnSub.get(i)).longValue());
        }
        s = s + "\n";
        try {
            this.mFileWriter.write(s);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems writing", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    protected boolean print(String s) throws IOException {
        try {
            this.mFileWriter.write(s);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems writing", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

