/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NetMapExport {
    private static final String FIELD_SELECTED = "SELECTED";
    private static final String[] FIELDS_NET = new String[]{"name", "isPower", "SELECTED"};
    private static final String[] FIELDS_DEVICE = new String[]{"name", "SELECTED"};
    private static final String[] FIELDS_PORT_TEMPLATE = new String[]{"name", "SELECTED"};
    private static final String[] FIELDS_PORT = new String[]{"SELECTED"};
    protected Db mDb;
    protected Selection mSelection = null;

    public static void exportXml(Db db, String filePath) {
        NetMapExport export = new NetMapExport(db);
        Element xeDoc = AXDomUtil.createXmlDoc((String)"NetMapExport");
        export.populateDom(xeDoc);
        try (FileOutputStream os = new FileOutputStream(filePath);){
            AXDomUtil.serialize((Node)xeDoc, (OutputStream)os);
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Error writing to '%s'.", (Object[])new Object[]{filePath});
        }
    }

    public NetMapExport(Db db) {
        this.mDb = db;
    }

    public void populateDom(Element xeRoot) {
        Design design = Design.getDesign((Db)this.mDb);
        if (design == null) {
            ALog.logWarn((String)"No Design found in database, nothing to do.");
            return;
        }
        this.mSelection = Selection.getCurrentSelectionForDb((Db)this.mDb);
        this.writeDeviceTemplate(xeRoot, (DeviceTemplate)design, null);
        this.mSelection = null;
    }

    protected void writeDeviceTemplate(Element xeElement, DeviceTemplate dt, DevicePath instPath) {
        Device inst = instPath == null ? null : instPath.getLast();
        for (Net net : dt.getNets()) {
            Object parentNet;
            Element xeNet = this.addDbObj(xeElement, (DbObject)net, FIELDS_NET);
            if (inst != null && (parentNet = NetMap.getParentNet((Device)inst, (Net)net)) != null) {
                xeNet.setAttribute("PARENT", parentNet.getName());
                HierInst top = NetMap.getTop((DevicePath)instPath, (Net)net);
                xeNet.setAttribute("TOPPATH", ((DevicePath)top.first).toString());
                xeNet.setAttribute("TOPNET", ((Net)top.second).getName());
            }
            parentNet = net.getPins().iterator();
            while (parentNet.hasNext()) {
                PinInstance dPort;
                PinTemplate tPort = (PinTemplate)parentNet.next();
                Element xePort = this.addDbObj(xeNet, (DbObject)tPort, FIELDS_PORT_TEMPLATE);
                if (inst == null || (dPort = inst.getPin(tPort)) == null) continue;
                this.writeFields(xePort, (DbObject)dPort, FIELDS_PORT);
            }
        }
        for (Device d : dt.getChildren()) {
            DevicePath childPath = new DevicePath(instPath, d);
            Element xeDevice = this.addDbObj(xeElement, (DbObject)d, FIELDS_DEVICE);
            xeDevice.setAttribute("PATH", childPath.toString());
            this.writeDeviceTemplate(xeDevice, d.getTemplate(), childPath);
        }
    }

    public Element addDbObj(Element xeParent, DbObject dbo, String[] fields) {
        Element xe = AXDomUtil.addElement((Element)xeParent, (String)dbo.getTypeName());
        this.writeFields(xe, dbo, fields);
        return xe;
    }

    public void writeFields(Element xe, DbObject dbo, String[] fields) {
        for (String fieldName : fields) {
            this.writeField(xe, dbo, fieldName);
        }
    }

    public void writeField(Element xe, DbObject dbo, String fieldName) {
        if (fieldName.equals(FIELD_SELECTED)) {
            if (this.mSelection.contains(dbo)) {
                xe.setAttribute(fieldName, "true");
            }
            return;
        }
        Object val = dbo.getValue(fieldName);
        if (val == null) {
            return;
        }
        if (Boolean.class.isInstance(val) && !((Boolean)val).booleanValue()) {
            return;
        }
        xe.setAttribute(fieldName, DbFieldDef.getStringValue((Object)val));
    }
}

