/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import au.com.bytecode.opencsv.CSVReader;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;

public class NetMapImport {
    protected static boolean mAutoCreateParentNets = false;
    protected static boolean mAutoCreateTopNets = false;

    public static void setAutoCreateParentNets(boolean b) {
        mAutoCreateParentNets = b;
    }

    public static void setAutoCreateTopNets(boolean b) {
        mAutoCreateTopNets = b;
    }

    /*
     * Unable to fully structure code
     */
    public static void importCsv(String filePath) throws IOException {
        db = OrbitIO.getCurDb();
        fr = new FileReader(filePath);
        reader = new CSVReader((Reader)fr);
        try {
            ALog.logInfo((String)"Importing net assignments from '%s'.", (Object[])new Object[]{filePath});
            i = 0;
            while (true) {
                block14: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    if ((l = reader.readNext()) == null) {
                                        break;
                                    }
                                    if (l.length == 0 || l.length == 1 && l[0].trim().length() == 0) break block14;
                                    msgCtx = String.format("line %d", new Object[]{i});
                                    devicePath = NetMapImport.get(l, 0);
                                    if (devicePath != null) break block15;
                                    ALog.flogError((String)"No DevicePath specified, %s is being ignored.", (Object[])new Object[]{msgCtx});
                                    break block14;
                                }
                                if (devicePath.startsWith("#")) break block14;
                                netName = NetMapImport.get(l, 1);
                                parentNetName = NetMapImport.get(l, 2);
                                topDevicePath = NetMapImport.get(l, 3);
                                topNetName = NetMapImport.get(l, 4);
                                portNames = NetMapImport.get(l, 5);
                                refDevPath = DevicePath.fromString((Db)db, (String)devicePath);
                                if (refDevPath != null) break block16;
                                ALog.flogError((String)"Invalid DevicePath '%s', %s is being ignored.", (Object[])new Object[]{devicePath, msgCtx});
                                break block14;
                            }
                            refDev = refDevPath.getLast();
                            if (refDev != null) break block17;
                            ALog.flogError((String)"'%s' does not specify a device, %s is being ignored.", (Object[])new Object[]{devicePath, msgCtx});
                            break block14;
                        }
                        refDt = refDev.getTemplate();
                        ports = NetMapImport.parsePorts(refDev, portNames, msgCtx);
                        refNet = null;
                        if (netName == null) break block18;
                        refNet = refDt.getNet(netName);
                        if (refNet == null) {
                            refNet = refDt.createNet(netName);
                        }
                        ** GOTO lbl46
                    }
                    if (ports.isEmpty()) {
                        ALog.flogError((String)"No net or pin specified in %s, the line is being ignored.", (Object[])new Object[]{msgCtx});
                    } else {
                        refNet = ports.get(0).getNet();
lbl46:
                        // 3 sources

                        for (PinTemplate port : ports) {
                            port.setNet(refNet);
                        }
                        parentNet = NetMapImport.processParentNet(refDev, refNet, parentNetName, msgCtx);
                        if (parentNet != null) {
                            NetMapImport.processTopNet(refDevPath.getParent(), parentNet, topDevicePath, topNetName, msgCtx);
                        } else {
                            NetMapImport.processTopNet(refDevPath, refNet, topDevicePath, topNetName, msgCtx);
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            reader.close();
        }
    }

    protected static Net processParentNet(Device refDev, Net refNet, String parentNetName, String msgCtx) {
        DeviceTemplate parentDt = refDev.getParent();
        if (parentNetName == null || parentNetName.length() == 0) {
            return null;
        }
        if (parentDt == null) {
            ALog.flogError((String)"Device '%s' does not have a parent, parent net '%s' is being ignored in %s.", (Object[])new Object[]{refDev.getName(), parentNetName, msgCtx});
            return null;
        }
        Net parentNet = parentDt.getNet(parentNetName);
        if (parentNet == null) {
            if (mAutoCreateParentNets) {
                parentNet = parentDt.createNet(parentNetName);
            } else {
                ALog.flogError((String)"Device '%s' parent does not have a net '%s', the parent net is being ignored in %s.", (Object[])new Object[]{refDev.getName(), parentNetName, msgCtx});
                return null;
            }
        }
        if (!NetMap.mapChildNet((Device)refDev, (Net)refNet, (Net)parentNet)) {
            ALog.flogError((String)"Creating the parent net map failed %s.", (Object[])new Object[]{msgCtx});
            return null;
        }
        return parentNet;
    }

    protected static void processTopNet(DevicePath refDevPath, Net refNet, String topDevicePath, String topNetName, String msgCtx) {
        if (topDevicePath == null || topDevicePath.length() == 0 || topNetName == null || topNetName.length() == 0) {
            return;
        }
        DevicePath topPath = DevicePath.fromString((Db)refNet.getDb(), (String)topDevicePath);
        if (topPath == null) {
            ALog.flogError((String)"The top device path '%s' specified in %s is invalid, no mapping tothe top net will be done.", (Object[])new Object[]{topDevicePath, msgCtx});
            return;
        }
        DeviceTemplate topDt = topPath.getDeviceTemplate();
        if (topDt == null) {
            ALog.flogError((String)"Unable to get the top device tempate for '%s' specified in %s, no mapping to the top net will be done.", (Object[])new Object[]{topDevicePath, msgCtx});
            assert (false);
            return;
        }
        Net topNet = topDt.getNet(topNetName);
        if (topNet == null) {
            if (mAutoCreateTopNets) {
                topNet = topDt.createNet(topNetName);
            } else {
                ALog.flogError((String)"The device '%s' does not have a net '%s' as specified in %s, no mapping to the top net will be done.", (Object[])new Object[]{topDevicePath, topNetName, msgCtx});
                return;
            }
        }
        NetMap.mapUpTo((DevicePath)refDevPath, (Net)refNet, (Net)topNet);
    }

    public static List<PinTemplate> parsePorts(Device device, String portList, String msgCtx) {
        LinkedList<PinTemplate> ports = new LinkedList<PinTemplate>();
        if (portList == null || portList.isEmpty()) {
            return ports;
        }
        DeviceTemplate dt = device.getTemplate();
        for (String portName : portList.split("\\s")) {
            PinTemplate dtp = dt.getPinByName(portName = portName.trim());
            if (dtp == null) {
                ALog.flogError((String)"'%s' does not specify a valid pin on device '%s' in %s, it is being ignored.", (Object[])new Object[]{portName, device.getName(), msgCtx});
                continue;
            }
            ports.add(dtp);
        }
        return ports;
    }

    public static String get(String[] line, int column) {
        if (column >= line.length) {
            return null;
        }
        String s = line[column];
        if ((s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    private NetMapImport() {
    }
}

