/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.export.PersonalityCSVColumnHeader;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.input.BOMInputStream;

public class PersonalityCSVIn {
    public static final String COLOR = "color";
    protected boolean mImportNetPersonalities = false;
    protected boolean mImportPinPersonalities = false;
    protected boolean mImportDevicePersonalities = false;
    protected boolean mByParentNetName = false;
    protected boolean mApplytoDescendents = false;
    boolean mStopAtSubstrateInstance = false;
    boolean mRemoveExistingPersonalities = false;

    public void setImportNetPersonalities(boolean b) {
        this.mImportNetPersonalities = b;
    }

    public void setImportPinPersonalities(boolean b) {
        this.mImportPinPersonalities = b;
    }

    public void setImportDevicePersonalities(boolean b) {
        this.mImportDevicePersonalities = b;
    }

    public void setByParentNetName(boolean b) {
        this.mByParentNetName = b;
    }

    public void setApplytoDescendents(boolean b) {
        this.mApplytoDescendents = b;
    }

    public void setStopAtSubstrateInstance(boolean b) {
        this.mStopAtSubstrateInstance = b;
    }

    public void setRemoveExistingPersonalities(boolean b) {
        this.mRemoveExistingPersonalities = b;
    }

    public boolean importCSV(Db db, String filePath, String devicePath) {
        CSVImporter psnImporter;
        boolean result = true;
        if (this.mRemoveExistingPersonalities) {
            Personality.removeAll((Db)db);
        }
        if (this.mImportNetPersonalities) {
            psnImporter = new NetPersonalityImporter(this);
            result &= psnImporter.importCSV(db, filePath, devicePath);
        }
        if (this.mImportDevicePersonalities) {
            psnImporter = new DevicePersonalityImporter();
            result &= ((DevicePersonalityImporter)psnImporter).importCSV(db, filePath, devicePath);
        }
        if (this.mImportPinPersonalities) {
            psnImporter = new PinPersonalityImporter();
            result &= psnImporter.importCSV(db, filePath, devicePath);
        }
        return result;
    }

    static class PinPersonalityImporter
    implements CSVImporter {
        private Set<Personality> coloredPsns = new HashSet<Personality>();
        private String pinName = "";
        private String personality = "";
        private String portAssignRatio = "";
        private String allowSwapping = "";
        private String color = "";
        DeviceTemplate startTemplate;
        DevicePath startDevicePath;

        PinPersonalityImporter() {
        }

        @Override
        public boolean validateRow(int rowNumber) {
            if (this.pinName.isEmpty()) {
                ALog.logWarn((String)"row: %d, pin name isn't specified.", (Object[])new Object[]{rowNumber});
                return false;
            }
            if (this.personality.isEmpty()) {
                ALog.logWarn((String)"row: %d, interface not specified.", (Object[])new Object[]{rowNumber});
                return false;
            }
            return true;
        }

        @Override
        public boolean readRow(CSVDocument document, int rowNumber) {
            try {
                this.pinName = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.PIN.asColumnHeader());
                this.personality = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.GROUP.asColumnHeader());
                this.portAssignRatio = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.PIN_ASSIGN_RATIO.asColumnHeader());
                this.allowSwapping = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.ALLOW_SWAPPING.asColumnHeader());
                this.color = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.COLOR.asColumnHeader());
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error reading row %d.", (Object[])new Object[]{rowNumber});
                return false;
            }
            return this.validateRow(rowNumber);
        }

        private void processColumnPortAssignRatio(Set<Personality> psns) {
            if (!this.portAssignRatio.isEmpty()) {
                Long par = Long.valueOf(this.portAssignRatio);
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.PORT_ASSIGN_RATIO, (Object)par);
                }
            }
        }

        private void processColumnAllowSwapping(Set<Personality> psns) {
            if (!this.allowSwapping.isEmpty()) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.ALLOW_SWAPPING, (Object)true);
                }
            }
        }

        private PinInstance processColumnPin(DeviceTemplate dt, DevicePath dp, int rowNumber) {
            PinTemplate pinT = dt.getPinByName(this.pinName);
            PinInstance pin = pinT.getPinInstance(dp);
            if (pin == null) {
                ALog.logWarn((String)"row: %d, cannot find pin '%s' under '%s'.", (Object[])new Object[]{rowNumber, this.pinName, dt.getKeyStr()});
            }
            return pin;
        }

        @Override
        public boolean processRow(CSVDocument document, int row) {
            if (!this.readRow(document, row)) {
                return false;
            }
            PinInstance pin = this.processColumnPin(this.startTemplate, this.startDevicePath, row);
            if (pin == null) {
                return false;
            }
            Set<Personality> psns = this.processColumnGroup(this.startTemplate, Personality.Type.PORT, this.personality);
            this.processColumnPortAssignRatio(psns);
            this.processColumnAllowSwapping(psns);
            for (Personality p : psns) {
                this.processColumnColor(p, this.color, this.coloredPsns);
                pin.assignToPersonality(p);
            }
            return true;
        }

        @Override
        public void preProcess(DeviceTemplate devT, DevicePath dp) {
            this.startTemplate = devT;
            this.startDevicePath = dp;
        }

        @Override
        public boolean postProcess() {
            return true;
        }
    }

    static class DevicePersonalityImporter
    implements CSVImporter {
        private Set<Personality> coloredPsns = new HashSet<Personality>();
        private String deviceName = "";
        private String personality = "";
        private String color = "";
        private String placeGrid = "";
        private String placeArea = "";
        private String routeArea = "";
        private String hard = "";
        private String ignoreGrid = "";
        private String placeAreaExclusive = "";
        private String deviceManaged = "";
        private String position = "";
        private long mDbuPerMicron;
        private static Pattern mPatternAFloating = Pattern.compile("[+-]?([0-9]+([.][0-9]*)?|[.][0-9]+)");
        DeviceTemplate startTemplate;
        DevicePath startDevicePath;

        DevicePersonalityImporter() {
        }

        private ArrayList<Double> text2FloatingNums(String text) {
            ArrayList<Double> nums = new ArrayList<Double>();
            Matcher m = mPatternAFloating.matcher(text);
            while (m.find()) {
                nums.add(Double.valueOf(m.group()));
            }
            return nums;
        }

        private AGrid text2Grid(String text) {
            ArrayList<Double> nums = this.text2FloatingNums(text);
            if (nums.size() == 4) {
                long ox = (long)(nums.get(0) * (double)this.mDbuPerMicron);
                long oy = (long)(nums.get(1) * (double)this.mDbuPerMicron);
                long dx = (long)(nums.get(2) * (double)this.mDbuPerMicron);
                long dy = (long)(nums.get(3) * (double)this.mDbuPerMicron);
                return new AGrid(dx, dy, ox, oy);
            }
            ALog.logWarn((String)"'%s' can not be recognized as grid. Try (1.0, 2.0), (3.0, -4.0)", (Object[])new Object[]{text});
            return null;
        }

        private ARect text2Area(String text) {
            ArrayList<Double> nums = this.text2FloatingNums(text);
            if (nums.size() == 4) {
                long llx = (long)(nums.get(0) * (double)this.mDbuPerMicron);
                long lly = (long)(nums.get(1) * (double)this.mDbuPerMicron);
                long urx = (long)(nums.get(2) * (double)this.mDbuPerMicron);
                long ury = (long)(nums.get(3) * (double)this.mDbuPerMicron);
                return ARect.create((long)llx, (long)lly, (long)urx, (long)ury);
            }
            ALog.logWarn((String)"'%s' can not be recognized as area. Try (1.0, 2.0), (3.0, 4.0)", (Object[])new Object[]{text});
            return null;
        }

        @Override
        public boolean validateRow(int rowNumber) {
            if (this.deviceName.isEmpty()) {
                ALog.logWarn((String)"row: %d, device name not specified.", (Object[])new Object[]{rowNumber});
                return false;
            }
            if (this.personality.isEmpty()) {
                ALog.logWarn((String)"row: %d, interface not specified.", (Object[])new Object[]{rowNumber});
                return false;
            }
            return true;
        }

        @Override
        public boolean readRow(CSVDocument document, int rowNumber) {
            try {
                this.deviceName = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.DEVICE.asColumnHeader());
                this.personality = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.GROUP.asColumnHeader());
                this.color = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.COLOR.asColumnHeader());
                this.placeGrid = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.PLACE_GRID.asColumnHeader());
                this.placeArea = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.PLACE_AREA.asColumnHeader());
                this.routeArea = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.ROUTE_AREA.asColumnHeader());
                this.hard = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.HARD_PERSONALITY.asColumnHeader());
                this.ignoreGrid = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.IGNORE_GRID.asColumnHeader());
                this.placeAreaExclusive = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.PLACE_AREA_EXCLUSIVE.asColumnHeader());
                this.deviceManaged = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.DEVICE_MANAGED.asColumnHeader());
                this.position = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.POSITION.asColumnHeader());
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error reading line %d.", (Object[])new Object[]{rowNumber});
                return false;
            }
            return this.validateRow(rowNumber);
        }

        private void processColumnPlaceGrid(Set<Personality> psns) {
            AGrid grid;
            if (!this.placeGrid.isEmpty() && (grid = this.text2Grid(this.placeGrid)) != null) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.PLACE_GRID, (Object)grid);
                }
            }
        }

        private void processColumnPlaceArea(Set<Personality> psns) {
            ARect area;
            if (!this.placeArea.isEmpty() && (area = this.text2Area(this.placeArea)) != null) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.PLACE_AREA, (Object)area);
                }
            }
        }

        private void processColumnRouteArea(Set<Personality> psns) {
            ARect area;
            if (!this.routeArea.isEmpty() && (area = this.text2Area(this.routeArea)) != null) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_AREA, (Object)area);
                }
            }
        }

        private void processColumnHard(Set<Personality> psns) {
            if (!this.hard.isEmpty()) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.HARD_PERSONALITY, (Object)true);
                }
            }
        }

        private void processColumnIgnoreGrid(Set<Personality> psns) {
            if (!this.ignoreGrid.isEmpty()) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.IGNORE_GRID, (Object)true);
                }
            }
        }

        private void processColumnAreaExclusive(Set<Personality> psns) {
            if (!this.placeAreaExclusive.isEmpty()) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.PLACE_AREA_EXCLUSIVE, (Object)true);
                }
            }
        }

        private void processColumnDeviceManaged(Set<Personality> psns) {
            if (!this.deviceManaged.isEmpty()) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.DEVICE_MANAGED, (Object)true);
                }
            }
        }

        private void processColumnPosition(Set<Personality> psns) {
            if (!this.position.isEmpty()) {
                for (Personality p : psns) {
                    Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.POSITION, (Object)this.position);
                }
            }
        }

        private Device processColumnDevice(DeviceTemplate dt, int rowNumber) {
            Device device = dt.getChild(this.deviceName);
            if (device == null) {
                ALog.logWarn((String)"line: %d, cannot find device '%s' under '%s'.", (Object[])new Object[]{rowNumber, this.deviceName, dt.getKeyStr()});
            }
            return device;
        }

        @Override
        public boolean processRow(CSVDocument document, int row) {
            if (!this.readRow(document, row)) {
                return false;
            }
            Device device = this.processColumnDevice(this.startTemplate, row);
            if (device == null) {
                return false;
            }
            Set<Personality> psns = this.processColumnGroup(this.startTemplate, Personality.Type.DEVICE, this.personality);
            this.processColumnPlaceGrid(psns);
            this.processColumnPlaceArea(psns);
            this.processColumnRouteArea(psns);
            this.processColumnHard(psns);
            this.processColumnIgnoreGrid(psns);
            this.processColumnAreaExclusive(psns);
            this.processColumnDeviceManaged(psns);
            this.processColumnPosition(psns);
            for (Personality p : psns) {
                this.processColumnColor(p, this.color, this.coloredPsns);
                device.assignToPersonality(p);
            }
            return true;
        }

        @Override
        public boolean importCSV(Db db, String filePath, String devicePath) {
            this.mDbuPerMicron = Design.getUnitDistDbuPerMicron((Db)db);
            return CSVImporter.super.importCSV(db, filePath, devicePath);
        }

        @Override
        public void preProcess(DeviceTemplate devT, DevicePath dp) {
            this.startTemplate = devT;
            this.startDevicePath = dp;
        }

        @Override
        public boolean postProcess() {
            return true;
        }
    }

    static class NetPersonalityImporter
    implements CSVImporter {
        private Set<Personality> coloredPsns = new HashSet<Personality>();
        PersonalityCSVIn pcsvin;
        private String netName = "";
        private String group = "";
        private String powerNet = "";
        private String diffPair = "";
        private String voltage = "";
        private String color = "";
        private String powerNetColor = "";
        private String diffPairColor = "";
        Set<Personality> mDiffPairPsns = new HashSet<Personality>();
        DeviceTemplate startTemplate;
        DevicePath startDevicePath;

        NetPersonalityImporter(PersonalityCSVIn pcsvin) {
            this.pcsvin = pcsvin;
        }

        @Override
        public boolean validateRow(int rowNumber) {
            if (this.netName.isEmpty()) {
                ALog.logWarn((String)"row: %d, net name isn't specified.", (Object[])new Object[]{rowNumber});
                return false;
            }
            if (this.group.isEmpty() && this.diffPair.isEmpty() && this.powerNet.isEmpty()) {
                ALog.logWarn((String)"row: %d, nothing is specified.", (Object[])new Object[]{rowNumber});
                return false;
            }
            if (this.diffPair.isEmpty() && !this.diffPairColor.isEmpty()) {
                ALog.logWarn((String)"row: %d, %s specified, %s can not be empty.", (Object[])new Object[]{rowNumber, PersonalityCSVColumnHeader.DIFF_PAIR_COLOR.asColumnHeader(), PersonalityCSVColumnHeader.DIFF_PAIR.asColumnHeader()});
                return false;
            }
            if (this.powerNet.isEmpty() && !this.powerNetColor.isEmpty()) {
                ALog.logWarn((String)"row: %d, %s specified, %s can not be empty.", (Object[])new Object[]{rowNumber, PersonalityCSVColumnHeader.POWER_NET_COLOR.asColumnHeader(), PersonalityCSVColumnHeader.POWER_NET.asColumnHeader()});
                return false;
            }
            return true;
        }

        @Override
        public boolean readRow(CSVDocument document, int rowNumber) {
            try {
                this.netName = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.NET.asColumnHeader());
                this.group = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.GROUP.asColumnHeader());
                this.diffPair = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.DIFF_PAIR.asColumnHeader());
                this.powerNet = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.POWER_NET.asColumnHeader());
                this.voltage = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.VOLTAGE.asColumnHeader());
                this.color = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.COLOR.asColumnHeader());
                this.powerNetColor = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.POWER_NET_COLOR.asColumnHeader());
                this.diffPairColor = document.getItemValue(rowNumber, PersonalityCSVColumnHeader.DIFF_PAIR_COLOR.asColumnHeader());
            }
            catch (Exception e) {
                ALog.logError((String)"Error reading row %d. Exception:%s", (Object[])new Object[]{rowNumber, e.toString()});
                return false;
            }
            return this.validateRow(rowNumber);
        }

        private Personality processColumnPowerNet(DeviceTemplate dt) {
            if (!this.powerNet.isEmpty()) {
                Personality p = this.getOrMakePersonality(Personality.Type.NET, dt, this.powerNet);
                Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.IS_POWER, (Object)true);
                return p;
            }
            return null;
        }

        private Personality processColumnDiffPair(DeviceTemplate dt) {
            if (!this.diffPair.isEmpty()) {
                Personality p = this.getOrMakePersonality(Personality.Type.NET, dt, this.diffPair);
                Constraint.getOrCreate((DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH, (Object)true);
                return p;
            }
            return null;
        }

        private Set<Net> processColumnNet(DeviceTemplate dt, int rowNumber) {
            Set<Net> nets = new HashSet<Net>();
            if (this.pcsvin.mByParentNetName) {
                Net net = this.findNetInUpstream(this.pcsvin.mStopAtSubstrateInstance);
                if (net == null) {
                    ALog.logWarn((String)"row: %d, cannot find net '%s' in any parents of '%s'.", (Object[])new Object[]{rowNumber, this.netName, dt.getKeyStr()});
                } else {
                    nets = this.getTargetDeviceNets(Set.of(net));
                }
            } else {
                Net net = dt.getNet(this.netName);
                if (net == null) {
                    ALog.logWarn((String)"row: %d, cannot find net '%s' under '%s'.", (Object[])new Object[]{rowNumber, this.netName, dt.getKeyStr()});
                } else {
                    nets.add(net);
                }
            }
            return nets;
        }

        private void processColumnVoltage(Set<Net> nets) {
            if (!this.voltage.isEmpty()) {
                for (Net net : nets) {
                    net.setValue(PersonalityCSVColumnHeader.VOLTAGE.asColumnHeader(), (Object)this.voltage);
                }
            }
        }

        private Stream<DeviceTemplate> getParents(DeviceTemplate t) {
            return t.getHierarchicalInstances().stream().map(dp -> dp.getDevice().getParent());
        }

        private Net findNetInUpstream(boolean stopAtSubstrateInstance) {
            Device device = this.startDevicePath.getDevice();
            Set<Object> ancestors = new HashSet<DeviceTemplate>();
            ancestors.add(device.getParent());
            do {
                Optional<DeviceTemplate> found;
                if (!(found = ancestors.stream().filter(template -> template.getNet(this.netName) != null).findFirst()).isPresent()) continue;
                return found.get().getNet(this.netName);
            } while (!(ancestors = ancestors.stream().filter(t -> !stopAtSubstrateInstance || !t.amIASubstrate()).flatMap(this::getParents).collect(Collectors.toSet())).isEmpty());
            return null;
        }

        private Set<Net> getDescendantNets(Net net) {
            if (this.pcsvin.mStopAtSubstrateInstance) {
                return NetMap.getAllDescendantNetsStopAtSubstrateInstance((Net)net);
            }
            return NetMap.getDescendantNets((Net)net).stream().map(NetMap::getChildNet).collect(Collectors.toSet());
        }

        private Set<Net> getTargetDescendantNets(Set<Net> nets) {
            HashSet<Net> targetNets = new HashSet<Net>();
            targetNets.addAll(nets);
            if (this.pcsvin.mApplytoDescendents) {
                for (Net net : nets) {
                    targetNets.addAll(this.getDescendantNets(net));
                }
            }
            return targetNets;
        }

        private Set<Net> getTargetDeviceNets(Set<Net> nets) {
            HashSet<Net> targetNets = new HashSet<Net>();
            for (Net net : nets) {
                if (!net.getDeviceTemplate().equals(this.startTemplate)) {
                    targetNets.addAll(NetMap.getAllDescendantNetsAt((Net)net, (Device)this.startDevicePath.getDevice()));
                    continue;
                }
                targetNets.addAll(nets);
            }
            return targetNets;
        }

        private void processColumnColor(Set<Personality> psns, String color) {
            if (!psns.isEmpty()) {
                for (Personality p : psns) {
                    this.processColumnColor(p, color, this.coloredPsns);
                }
            }
        }

        @Override
        public boolean processRow(CSVDocument document, int row) {
            Personality psnPowerNet;
            if (!this.readRow(document, row)) {
                return false;
            }
            Set<Net> nets = this.processColumnNet(this.startTemplate, row);
            if (nets.isEmpty()) {
                return false;
            }
            Set<Personality> psnsGroup = this.processColumnGroup(this.startTemplate, Personality.Type.NET, this.group);
            this.processColumnColor(psnsGroup, this.color);
            Personality psnDiffPair = this.processColumnDiffPair(this.startTemplate);
            if (psnDiffPair != null) {
                this.mDiffPairPsns.add(psnDiffPair);
                if (!this.diffPairColor.isEmpty()) {
                    this.processColumnColor(psnDiffPair, this.diffPairColor, this.coloredPsns);
                }
            }
            if ((psnPowerNet = this.processColumnPowerNet(this.startTemplate)) != null && !this.powerNetColor.isEmpty()) {
                this.processColumnColor(psnPowerNet, this.powerNetColor, this.coloredPsns);
            }
            this.processColumnVoltage(nets);
            HashSet<Personality> psns = new HashSet<Personality>();
            psns.addAll(psnsGroup);
            if (psnDiffPair != null) {
                psns.add(psnDiffPair);
            }
            if (psnPowerNet != null) {
                psns.add(psnPowerNet);
            }
            Set<Net> targetNets = this.pcsvin.mApplytoDescendents ? this.getTargetDescendantNets(nets) : this.getTargetDeviceNets(nets);
            targetNets.stream().forEach(n -> {
                for (Personality psn : psns) {
                    if (psn == null) continue;
                    n.assignToPersonality(psn, null, false);
                }
            });
            return true;
        }

        @Override
        public void preProcess(DeviceTemplate devT, DevicePath dp) {
            this.startTemplate = devT;
            this.startDevicePath = dp;
        }

        @Override
        public boolean postProcess() {
            return this.checkDiffPair();
        }

        private boolean checkDiffPair() {
            MutableBoolean result = new MutableBoolean(true);
            this.mDiffPairPsns.stream().forEach(p -> {
                Map<DevicePath, List<HierInst>> byDevicePath = p.getObjects().collect(Collectors.groupingBy(HierInst::getPath));
                byDevicePath.entrySet().stream().forEach(e -> {
                    List nets = (List)e.getValue();
                    if (nets.size() != 2) {
                        result.setValue(false);
                        ALog.logWarn((String)"Diff Pair:'%s' in path:'%s' has %d nets.", (Object[])new Object[]{p.getName(), ((HierInst)nets.get(0)).getPath(), nets.size()});
                        for (HierInst net : nets) {
                            Net n = (Net)net.getSecond();
                            ALog.logWarn((String)"Net:'%s'", (Object[])new Object[]{n.getName()});
                        }
                    }
                });
            });
            return result.getValue();
        }
    }

    static interface CSVImporter {
        default public Personality getOrMakePersonality(Personality.Type t, DeviceTemplate dt, String name) {
            return Personality.getOrCreate((DeviceTemplate)dt, (Personality.Type)t, (String)name);
        }

        default public Color getColor(String col) {
            return AColor.getColor((String)col);
        }

        public static CSVDocument openCSVFile(String filePath) {
            CSVDocument document = null;
            try (BOMInputStream fis = new BOMInputStream((InputStream)new FileInputStream(filePath));){
                CSVDOMParser parser2 = new CSVDOMParser(true, null);
                document = parser2.parse((InputStream)fis);
            }
            catch (FileNotFoundException e) {
                ALog.logError((Throwable)e, (String)"File '%s' does not exist.", (Object[])new Object[]{filePath});
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error reading input file '%s'.", (Object[])new Object[]{filePath});
            }
            return document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public boolean importCSV(Db db, String filePath, String devicePath) {
            DevicePath startDevPath = DevicePath.fromString((Db)db, (String)devicePath);
            if (startDevPath == null) {
                ALog.logError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
                return false;
            }
            CSVDocument document = CSVImporter.openCSVFile(filePath);
            if (document == null) {
                return false;
            }
            int numUpdates = 0;
            int totalRows = document.getItemCount();
            try {
                Device dev = startDevPath.getLast();
                DeviceTemplate dt = dev.getTemplate();
                this.preProcess(dt, startDevPath);
                for (int row = 0; row < totalRows; ++row) {
                    if (!this.processRow(document, row)) continue;
                    ++numUpdates;
                }
            }
            catch (Exception e) {
                boolean bl;
                try {
                    ALog.logError((Throwable)e, (String)"Error reading input file '%s'.", (Object[])new Object[]{filePath});
                    bl = false;
                }
                catch (Throwable throwable) {
                    ALog.logInfo((String)"%d rows processed, out of %d rows", (Object[])new Object[]{numUpdates, totalRows});
                    throw throwable;
                }
                ALog.logInfo((String)"%d rows processed, out of %d rows", (Object[])new Object[]{numUpdates, totalRows});
                return bl;
            }
            ALog.logInfo((String)"%d rows processed, out of %d rows", (Object[])new Object[]{numUpdates, totalRows});
            return true;
        }

        default public void processColumnColor(Personality p, String color, Set<Personality> coloredPsns) {
            if (this.shouldSetColor(p, coloredPsns)) {
                Color c = null;
                if (!color.isEmpty()) {
                    c = this.getColor(color);
                }
                if (c == null) {
                    c = AUtil.colorFromString((String)Personality.nextColor());
                }
                p.setColor(c);
                this.markColored(p, coloredPsns);
            }
        }

        default public boolean shouldSetColor(Personality p, Set<Personality> coloredPsns) {
            if (p == null) {
                return false;
            }
            return !coloredPsns.contains(p);
        }

        default public void markColored(Personality psn, Set<Personality> coloredPsns) {
            coloredPsns.add(psn);
        }

        default public Set<Personality> processColumnGroup(DeviceTemplate dt, Personality.Type type, String group) {
            if (!group.isEmpty()) {
                String[] gs;
                HashSet<Personality> psns = new HashSet<Personality>();
                for (String g : gs = group.split(",")) {
                    Personality psn = this.getOrMakePersonality(type, dt, g = g.trim());
                    if (psn == null) {
                        ALog.logWarn((String)"Failed to create %s personality named:'%s'", (Object[])new Object[]{type, g});
                        continue;
                    }
                    psns.add(psn);
                }
                return psns;
            }
            return Collections.emptySet();
        }

        public boolean processRow(CSVDocument var1, int var2);

        public boolean readRow(CSVDocument var1, int var2);

        public boolean validateRow(int var1);

        public void preProcess(DeviceTemplate var1, DevicePath var2);

        public boolean postProcess();
    }
}

