/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ACsvFile;
import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.export.PersonalityCSVColumnHeader;
import java.awt.Color;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PersonalityCSVOut {
    protected boolean mExportNetPersonalities = false;
    protected boolean mExportPinPersonalities = false;
    protected boolean mExportDevicePersonalities = false;

    public void setExportNetPersonalities(boolean b) {
        this.mExportNetPersonalities = b;
    }

    public void setExportPinPersonalities(boolean b) {
        this.mExportPinPersonalities = b;
    }

    public void setExportDevicePersonalities(boolean b) {
        this.mExportDevicePersonalities = b;
    }

    public boolean exportCSV(Db db, String filePath, String devicePath) {
        CSVExporter psnExporter;
        boolean result = true;
        if (this.mExportNetPersonalities) {
            psnExporter = new NetPersonalityExporter();
            result &= psnExporter.exportCSV(db, filePath, devicePath);
        }
        if (this.mExportDevicePersonalities) {
            psnExporter = new DevicePersonalityExporter();
            result &= psnExporter.exportCSV(db, filePath, devicePath);
        }
        if (this.mExportPinPersonalities) {
            psnExporter = new PinPersonalityExporter();
            result &= psnExporter.exportCSV(db, filePath, devicePath);
        }
        return result;
    }

    static class PinPersonalityExporter
    implements CSVExporter {
        DeviceTemplate mOwner;
        long mNumDataRows;

        PinPersonalityExporter() {
        }

        @Override
        public boolean writeData(ACsvWriter w, DevicePath dp) {
            try {
                this.mNumDataRows = w.getCurLine();
                Personality.getPersonalities((DeviceTemplate)this.mOwner).filter(psn -> psn.getType() == Personality.Type.PORT).forEach(psn -> {
                    List pins = psn.getPersonalityMaps().filter(pm -> pm.getObject() instanceof PinInstance).map(pm -> (PinInstance)pm.getObject()).distinct().sorted((a, b) -> this.compareName(a.getName(), b.getName())).collect(Collectors.toList());
                    String psnName = psn.getName();
                    String clrString = AColor.getString((Color)psn.getColor());
                    for (PinInstance pin : pins) {
                        w.colData(pin.getName());
                        w.colData(psnName);
                        w.colData(clrString);
                        w.endRow();
                    }
                });
                this.mNumDataRows = w.getCurLine() - this.mNumDataRows;
                return true;
            }
            catch (Exception e) {
                this.mNumDataRows = w.getCurLine() - this.mNumDataRows;
                ALog.logError((Throwable)e, (String)"Failed when exporting pin personalites for '%s'.", (Object[])new Object[]{dp});
                return false;
            }
        }

        @Override
        public boolean writeHeaders(ACsvWriter w) {
            try {
                this.writeCommonHeaders(w, this.mOwner);
                w.header(new String[]{PersonalityCSVColumnHeader.PIN.asColumnHeader(), PersonalityCSVColumnHeader.GROUP.asColumnHeader(), PersonalityCSVColumnHeader.COLOR.asColumnHeader()});
                return true;
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Failed when exporting pin personalites headers for '%s'.", (Object[])new Object[]{this.mOwner});
                return false;
            }
        }

        @Override
        public boolean preWrite(DevicePath dp) {
            Device dev = dp.getLast();
            if (dev == null) {
                ALog.logError((String)"No device found on '%s'!", (Object[])new Object[]{dp});
                return false;
            }
            this.mOwner = dev.getTemplate();
            if (this.mOwner == null) {
                ALog.logError((String)"Device '%s' has no template!", (Object[])new Object[]{dev});
                return false;
            }
            return true;
        }

        @Override
        public long getNumDataRows() {
            return this.mNumDataRows;
        }
    }

    static class NetPersonalityExporter
    implements CSVExporter {
        DeviceTemplate mOwner;
        long mNumDataRows;
        Set<Personality> colorWritten = new HashSet<Personality>();

        NetPersonalityExporter() {
        }

        private boolean isPowerNet(Personality psn, Db db) {
            Boolean isPower = (Boolean)Constraint.getValue((Db)db, (DbObject)psn, (Constraint.Descriptor)Constraint.IS_POWER);
            return isPower != null && isPower != false;
        }

        private boolean isDiffPair(Personality psn, Db db) {
            Boolean diffPair = (Boolean)Constraint.getValue((Db)db, (DbObject)psn, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
            return diffPair != null && diffPair != false;
        }

        private boolean shouldWriteColor(Personality p) {
            return !this.colorWritten.contains(p);
        }

        private void markColorWritten(Personality p) {
            this.colorWritten.add(p);
        }

        private boolean writeNetPersonalityGroup(ACsvWriter w, Net n, List<Personality> psns, String voltage) {
            for (Personality p : psns) {
                w.colData(n.getName());
                w.colData(p.getName());
                w.colData("");
                w.colData("");
                if (voltage != null) {
                    w.colData(voltage);
                    voltage = null;
                } else {
                    w.colData("");
                }
                if (this.shouldWriteColor(p)) {
                    w.colData(AColor.getString((Color)p.getColor()));
                    this.markColorWritten(p);
                } else {
                    w.colData("");
                }
                w.colData("");
                w.colData("");
                w.endRow();
            }
            return !psns.isEmpty();
        }

        private boolean writeNetPersonalityPowerNet(ACsvWriter w, Net n, List<Personality> psns, String voltage) {
            for (Personality p : psns) {
                w.colData(n.getName());
                w.colData("");
                w.colData(p.getName());
                w.colData("");
                if (voltage != null) {
                    w.colData(voltage);
                    voltage = null;
                } else {
                    w.colData("");
                }
                w.colData("");
                if (this.shouldWriteColor(p)) {
                    w.colData(AColor.getString((Color)p.getColor()));
                    this.markColorWritten(p);
                } else {
                    w.colData("");
                }
                w.colData("");
                w.endRow();
            }
            return !psns.isEmpty();
        }

        private boolean writeNetPersonalityDiffPair(ACsvWriter w, Net n, List<Personality> psns, String voltage) {
            for (Personality p : psns) {
                w.colData(n.getName());
                w.colData("");
                w.colData("");
                w.colData(p.getName());
                if (voltage != null) {
                    w.colData(voltage);
                    voltage = null;
                } else {
                    w.colData("");
                }
                w.colData("");
                w.colData("");
                if (this.shouldWriteColor(p)) {
                    w.colData(AColor.getString((Color)p.getColor()));
                    this.markColorWritten(p);
                } else {
                    w.colData("");
                }
                w.endRow();
            }
            return !psns.isEmpty();
        }

        private void writeNet(ACsvWriter w, Net n, Map<DbObject, List<PersonalityMap>> netPsns, Db db) {
            String voltage;
            Object o = n.getValue(PersonalityCSVColumnHeader.VOLTAGE.asColumnHeader());
            String string = voltage = o != null ? (String)o : null;
            if ((voltage == null || voltage.isEmpty()) && !netPsns.containsKey(n)) {
                return;
            }
            List<Personality> psns = netPsns.get(n).stream().map(PersonalityMap::getPersonality).distinct().sorted((a, b) -> this.compareName(a.getName(), b.getName())).collect(Collectors.toList());
            if (psns != null && !psns.isEmpty()) {
                List<Personality> powerNetPsns = psns.stream().filter(p -> this.isPowerNet((Personality)p, db)).sorted((a, b) -> this.compareName(a.getName(), b.getName())).collect(Collectors.toList());
                List<Personality> diffPairPsns = psns.stream().filter(p -> this.isDiffPair((Personality)p, db)).sorted((a, b) -> this.compareName(a.getName(), b.getName())).collect(Collectors.toList());
                psns.removeAll(powerNetPsns);
                psns.removeAll(diffPairPsns);
                if (this.writeNetPersonalityGroup(w, n, psns, voltage)) {
                    voltage = null;
                }
                if (this.writeNetPersonalityPowerNet(w, n, powerNetPsns, voltage)) {
                    voltage = null;
                }
                if (this.writeNetPersonalityDiffPair(w, n, diffPairPsns, voltage)) {
                    voltage = null;
                }
            } else {
                w.colData(n.getName());
                w.colData("");
                w.colData("");
                w.colData("");
                w.colData(voltage);
                w.colData("");
                w.endRow();
            }
        }

        @Override
        public boolean writeData(ACsvWriter w, DevicePath dp) {
            try {
                this.mNumDataRows = w.getCurLine();
                Db db = this.mOwner.getDb();
                Map<DbObject, List<PersonalityMap>> netPsns = Personality.getPersonalities((DeviceTemplate)this.mOwner).filter(psn -> psn.getType() == Personality.Type.NET).flatMap(Personality::getPersonalityMaps).collect(Collectors.groupingBy(PersonalityMap::getObject));
                this.mOwner.getNets().stream().sorted((a, b) -> this.compareName(a.getName(), b.getName())).forEach(n -> this.writeNet(w, (Net)n, netPsns, db));
                this.mNumDataRows = w.getCurLine() - this.mNumDataRows;
                return true;
            }
            catch (Exception e) {
                this.mNumDataRows = w.getCurLine() - this.mNumDataRows;
                ALog.logError((Throwable)e, (String)"Failed when exporting net personalites for '%s'.", (Object[])new Object[]{dp});
                return false;
            }
        }

        @Override
        public boolean writeHeaders(ACsvWriter w) {
            try {
                this.writeCommonHeaders(w, this.mOwner);
                w.header(new String[]{PersonalityCSVColumnHeader.NET.asColumnHeader(), PersonalityCSVColumnHeader.GROUP.asColumnHeader(), PersonalityCSVColumnHeader.POWER_NET.asColumnHeader(), PersonalityCSVColumnHeader.DIFF_PAIR.asColumnHeader(), PersonalityCSVColumnHeader.VOLTAGE.asColumnHeader(), PersonalityCSVColumnHeader.COLOR.asColumnHeader(), PersonalityCSVColumnHeader.POWER_NET_COLOR.asColumnHeader(), PersonalityCSVColumnHeader.DIFF_PAIR_COLOR.asColumnHeader()});
                return true;
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Failed when exporting net personalites headers for '%s'.", (Object[])new Object[]{this.mOwner});
                return false;
            }
        }

        @Override
        public boolean preWrite(DevicePath dp) {
            Device dev = dp.getLast();
            if (dev == null) {
                ALog.logError((String)"No device found on '%s'!", (Object[])new Object[]{dp});
                return false;
            }
            this.mOwner = dev.getTemplate();
            if (this.mOwner == null) {
                ALog.logError((String)"Device '%s' has no template!", (Object[])new Object[]{dev});
                return false;
            }
            return true;
        }

        @Override
        public long getNumDataRows() {
            return this.mNumDataRows;
        }
    }

    static class DevicePersonalityExporter
    implements CSVExporter {
        DeviceTemplate mOwner;
        long mNumDataRows;

        DevicePersonalityExporter() {
        }

        @Override
        public boolean writeData(ACsvWriter w, DevicePath dp) {
            try {
                this.mNumDataRows = w.getCurLine();
                Personality.getPersonalities((DeviceTemplate)this.mOwner).filter(psn -> psn.getType() == Personality.Type.DEVICE).forEach(psn -> {
                    List devices = psn.getPersonalityMaps().filter(pm -> pm.getObject() instanceof Device).map(pm -> (Device)pm.getObject()).distinct().sorted((a, b) -> this.compareName(a.getShortName(), b.getShortName())).collect(Collectors.toList());
                    String psnName = psn.getName();
                    String clrString = AColor.getString((Color)psn.getColor());
                    for (Device d : devices) {
                        w.colData(d.getShortName());
                        w.colData(psnName);
                        w.colData(clrString);
                        w.endRow();
                    }
                });
                this.mNumDataRows = w.getCurLine() - this.mNumDataRows;
                return true;
            }
            catch (Exception e) {
                this.mNumDataRows = w.getCurLine() - this.mNumDataRows;
                ALog.logError((Throwable)e, (String)"Failed when exporting device personalites for '%s'.", (Object[])new Object[]{dp});
                return false;
            }
        }

        @Override
        public boolean writeHeaders(ACsvWriter w) {
            try {
                this.writeCommonHeaders(w, this.mOwner);
                w.header(new String[]{PersonalityCSVColumnHeader.DEVICE.asColumnHeader(), PersonalityCSVColumnHeader.GROUP.asColumnHeader(), PersonalityCSVColumnHeader.COLOR.asColumnHeader()});
                return true;
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Failed when exporting device personalites headers for '%s'.", (Object[])new Object[]{this.mOwner});
                return false;
            }
        }

        @Override
        public boolean preWrite(DevicePath dp) {
            Device dev = dp.getLast();
            if (dev == null) {
                ALog.logError((String)"No device found on '%s'!", (Object[])new Object[]{dp});
                return false;
            }
            this.mOwner = dev.getTemplate();
            if (this.mOwner == null) {
                ALog.logError((String)"Device '%s' has no template!", (Object[])new Object[]{dev});
                return false;
            }
            return true;
        }

        @Override
        public long getNumDataRows() {
            return this.mNumDataRows;
        }
    }

    static interface CSVExporter {
        default public int compareName(String a, String b) {
            AAlphaNumComp c = AAlphaNumComp.get();
            return c.compare((Object)a, (Object)b);
        }

        public boolean preWrite(DevicePath var1);

        public boolean writeHeaders(ACsvWriter var1);

        public boolean writeData(ACsvWriter var1, DevicePath var2);

        public long getNumDataRows();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        default public boolean exportCSV(Db db, String filePath, String devicePath) {
            boolean result;
            DevicePath startDevPath = DevicePath.fromString((Db)db, (String)devicePath);
            if (startDevPath == null) {
                ALog.logError((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
                return false;
            }
            ALog.logInfo((String)"Exporting personalities to '%s'.", (Object[])new Object[]{new File(filePath)});
            try (ACsvWriter out = ACsvWriter.open((String)filePath);){
                if (out == null) {
                    boolean bl = false;
                    return bl;
                }
                result = this.preWrite(startDevPath) && this.writeHeaders(out) && this.writeData(out, startDevPath);
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error exporting personalities: %s.", (Object[])new Object[]{e});
                result = false;
            }
            if (this.getNumDataRows() == 0L) {
                ALog.logInfo((String)"No personalites has been found!");
                return result;
            }
            ALog.logInfo((String)"Export complete, %d row(s) written.", (Object[])new Object[]{this.getNumDataRows()});
            return result;
        }

        default public void writeCommonHeaders(ACsvWriter w, DeviceTemplate owner) {
            ACsvFile.getStandardHeaders().forEach(h -> w.header(new String[]{"# " + h}));
            w.header(new String[]{String.format("# Owner: %s", owner.getKeyStr())});
            String standardColorsStr = AColor.getStandardColorStrings().stream().collect(Collectors.joining(" ,"));
            w.header(new String[]{"# Color can be, case insensitive, any of the following: " + standardColorsStr});
        }
    }
}

