/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.export.CsvIo;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;

public class PinTableIO {
    public static final String FLDNAME_CHIPPADFUNC = "ChipPadFunction";
    public static final String FLDNAME_USERMEMFUNC = "UserMemoryFunction";
    public static final String FLDNAME_USERDIFFFUNC = "UserDifferentialFunction";
    public static final String FLDNAME_NOTENUMBER = "NoteNumber";

    public static boolean exportCsv(Db db, String devicePath, String filePath) {
        DevicePath devPath = DevicePath.fromString((Db)db, (String)devicePath);
        if (devicePath == null) {
            ALog.logError((String)"Invalid device path '%s' specified to PinTableIO.exportCsv().", (Object[])new Object[]{devicePath});
            return false;
        }
        Exporter exporter = new Exporter(filePath);
        return exporter.exportCsv(devPath);
    }

    public static boolean importCsv(Db db, String devicePath, String filePath) {
        DevicePath devPath = DevicePath.fromString((Db)db, (String)devicePath);
        if (devicePath == null) {
            ALog.logError((String)"Invalid device path '%s' specified to PinTableIO.importCsv().", (Object[])new Object[]{devicePath});
            return false;
        }
        Importer importer = new Importer(filePath);
        return importer.importCsv(devPath);
    }

    public static String formatHierPin(HierInst<PinTemplate> hp) {
        return hp == null ? "" : String.format("%s/%s/%s", hp.first, ((PinTemplate)hp.second).getNet().getName(), ((PinTemplate)hp.second).getName());
    }

    public static HierInst<PinTemplate> getHierPin(DevicePath context, String strPinPath) {
        Object str = strPinPath;
        int finalSep = ((String)str).lastIndexOf(47);
        if (finalSep < 0 || finalSep == ((String)str).length() - 1) {
            ALog.logError((String)"Invalid pin specification '%s'.", (Object[])new Object[]{strPinPath});
            return null;
        }
        String pinTName = ((String)str).substring(finalSep + 1);
        if ((finalSep = ((String)(str = ((String)str).substring(0, finalSep))).lastIndexOf(47)) < 0 || finalSep == ((String)str).length() - 1) {
            ALog.logError((String)"Invalid pin specification '%s'.", (Object[])new Object[]{strPinPath});
            return null;
        }
        String netName = ((String)str).substring(finalSep + 1);
        String strPath = ((String)str).substring(0, finalSep);
        DevicePath path = DevicePath.fromString((Db)context.getDb(), (String)strPath, (DeviceTemplate)context.getDeviceTemplate());
        if (path == null) {
            ALog.logError((String)"The device path '%s' was not found while getting pin '%s'.", (Object[])new Object[]{strPath, strPinPath});
            return null;
        }
        Net net = path.getDeviceTemplate().getNet(netName);
        if (net == null) {
            ALog.logError((String)"The Net '%s' was not found while getting pin '%s'.", (Object[])new Object[]{netName, strPinPath});
            return null;
        }
        PinTemplate pinT = net.getPinTemplate(pinTName);
        if (pinT == null) {
            ALog.logError((String)"The PinTemplate '%s' was not found while getting pin '%s'.", (Object[])new Object[]{pinTName, strPinPath});
            return null;
        }
        return HierInst.create((DevicePath)path, (DbObject)pinT);
    }

    public static class Importer {
        protected String mFilePath;
        protected CsvIo.CsvIn mCsvIn;

        public Importer(String filePath) {
            this.mFilePath = filePath;
        }

        public boolean importCsv(DevicePath devicePath) {
            FileReader fr;
            try {
                fr = new FileReader(this.mFilePath);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"Error opening input file '%s'.", (Object[])new Object[]{this.mFilePath});
                return false;
            }
            this.mCsvIn = new CsvIo.CsvIn(fr);
            ALog.logInfo((String)"Reading file...");
            String[] line = this.mCsvIn.readLine();
            while (line != null && (line.length == 1 && line[0].trim().length() == 0 || line.length > 0 && line[0].startsWith("#"))) {
                line = this.mCsvIn.readLine();
            }
            line = this.mCsvIn.readLine();
            while (line != null) {
                if (line.length != 1 || line[0].trim().length() != 0) {
                    if (line.length < 13) {
                        ALog.logWarn((String)"No IOPad specified on line %d, the line is being igored.", (Object[])new Object[]{this.mCsvIn.getCurLineNum()});
                    } else {
                        String strIoPad = line[12].trim();
                        HierInst<PinTemplate> hIoPadT = PinTableIO.getHierPin(devicePath, strIoPad);
                        if (hIoPadT != null) {
                            PinInstance ioPad = PinInstance.getPinInstance((Device)hIoPadT.getPath().getLast(), (PinTemplate)((PinTemplate)hIoPadT.getDbObject()));
                            this.updateUserField((DbObject)ioPad, strIoPad, PinTableIO.FLDNAME_CHIPPADFUNC, line[6].trim());
                            this.updateUserField((DbObject)ioPad, strIoPad, PinTableIO.FLDNAME_USERMEMFUNC, line[7].trim());
                            this.updateUserField((DbObject)ioPad, strIoPad, PinTableIO.FLDNAME_USERDIFFFUNC, line[8].trim());
                            this.updateUserField((DbObject)ioPad, strIoPad, PinTableIO.FLDNAME_NOTENUMBER, line[9].trim());
                        }
                    }
                }
                line = this.mCsvIn.readLine();
            }
            ALog.logInfo((String)"Import complete.");
            try {
                this.mCsvIn.close();
            }
            catch (IOException e) {
                ALog.logWarn((Throwable)e, (String)"Error closing input file.", (Object[])new Object[0]);
                return false;
            }
            return true;
        }

        protected boolean updateUserField(DbObject dbo, String dboDesc, String fieldName, String newVal) {
            String curVal;
            if (newVal != null && newVal.length() == 0) {
                newVal = null;
            }
            if (AUtil.equals((Object)(curVal = dbo.getStringValue(fieldName)), (Object)newVal)) {
                return false;
            }
            if (newVal == null) {
                dbo.unsetSoftValue(fieldName);
            } else {
                dbo.setValue(fieldName, (Object)newVal);
            }
            if (dboDesc != null) {
                ALog.logInfo((String)"Updated %s field %s from '%s' to '%s'.", (Object[])new Object[]{dboDesc, fieldName, curVal, newVal});
            }
            return true;
        }
    }

    public static class Exporter {
        protected String mFilePath;
        protected CsvIo.CsvOut mCsvOut;

        public Exporter(String filePath) {
            this.mFilePath = filePath;
        }

        public boolean exportCsv(DevicePath devicePath) {
            FileWriter fw;
            try {
                fw = new FileWriter(this.mFilePath);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"Error opening output file '%s'.", (Object[])new Object[]{this.mFilePath});
                return false;
            }
            this.mCsvOut = new CsvIo.CsvOut(fw);
            LinkedList<DeviceTemplate.DescendantPin> ioPads = new LinkedList<DeviceTemplate.DescendantPin>();
            for (Object hpin : devicePath.getLast().getDescendantPins()) {
                if (hpin.getPinTemplate().getType() != PinTemplate.Type.IOPAD) continue;
                ioPads.add((DeviceTemplate.DescendantPin)hpin);
            }
            Collections.sort(ioPads);
            this.mCsvOut.write(new String[]{"Bank Number", "Bump ID", "Bump X", "Bump Y", "Template Name", "OrbitIO Pin Net Name", "Chip Pad Function", "User Memory Function", "User Differential Function", "Note Number", "Die  Net Name", "Package Net Name", "IOPad", "Bump"});
            Unit unit = Design.getUnit((Db)devicePath.getDb());
            ALog.logInfo((String)"Exporting %d IOPads...", (Object[])new Object[]{ioPads.size()});
            for (DeviceTemplate.DescendantPin ioPad : ioPads) {
                String strIoPad = PinTableIO.formatHierPin((HierInst<PinTemplate>)ioPad);
                Net dieNet = ioPad.getTopMostNet();
                if (dieNet.getDeviceTemplate() != devicePath.getDeviceTemplate()) {
                    ALog.logWarn((String)"The net '%s' on IOPad '%s' is not mapped to the die device.", (Object[])new Object[]{ioPad.getPinTemplate().getNet(), strIoPad});
                    dieNet = null;
                }
                HierInst bump = null;
                for (HierInst candidate : NetMap.getConnectedHierPins((DevicePath)ioPad.getDevicePath(), (Net)ioPad.getPinTemplate().getNet())) {
                    if (((PinTemplate)candidate.getDbObject()).getType() != PinTemplate.Type.BUMPPAD) continue;
                    if (bump == null) {
                        bump = candidate;
                        continue;
                    }
                    ALog.logWarn((String)"The IOPad '%s' is connected to multiple Bumps.", (Object[])new Object[]{strIoPad});
                    break;
                }
                if (bump == null) {
                    ALog.logWarn((String)"The IOPad '%s' is not connected to a Bump.", (Object[])new Object[]{strIoPad});
                }
                APoint2D bumpLoc = bump == null ? null : ((PinTemplate)bump.getDbObject()).getLoc().transform(bump.getPath().getTransform());
                DevicePath macroDevice = ioPad.getDevicePath();
                DevicePath interfaceDevice = ioPad.getDevicePath().anscestorOfType(DeviceTemplate.Type.PERSONALITY);
                if (interfaceDevice == null) {
                    ALog.logWarn((String)"Unable to determine bank (interface) for IOPad '%s'.", (Object[])new Object[]{strIoPad});
                }
                Net interfaceNet = interfaceDevice == null ? null : NetMap.getNetAt((Net)ioPad.getPinTemplate().getNet(), (DevicePath)ioPad.getDevicePath(), (DeviceTemplate)interfaceDevice.getDeviceTemplate());
                Net packageNet = null;
                DevicePath pkg = devicePath.pathToLowestPackage();
                if (pkg != null) {
                    DevicePath fullPath = devicePath.addPath(ioPad.getDevicePath());
                    packageNet = NetMap.getNetAt((Net)ioPad.getPinTemplate().getNet(), (DevicePath)fullPath, (DeviceTemplate)pkg.getDeviceTemplate());
                    if (packageNet.getDeviceTemplate() != pkg.getDeviceTemplate()) {
                        packageNet = null;
                    }
                }
                String bankNumber = interfaceDevice == null ? "" : interfaceDevice.getLast().getName();
                String bumpId = bump == null ? "" : ((PinTemplate)bump.getDbObject()).getName();
                String bumpX = bumpLoc == null ? "" : unit.toUserStr(bumpLoc.getX());
                String bumpY = bumpLoc == null ? "" : unit.toUserStr(bumpLoc.getY());
                String templateName = macroDevice.getDeviceTemplate().getName();
                String oioPinNetName = interfaceNet == null ? "" : interfaceNet.getName();
                PinInstance pinInst = ioPad.getPinInstance();
                String chipPadFunc = pinInst.getStringValue(PinTableIO.FLDNAME_CHIPPADFUNC);
                String userMemoryFunc = pinInst.getStringValue(PinTableIO.FLDNAME_USERMEMFUNC);
                String userDifferentialFunc = pinInst.getStringValue(PinTableIO.FLDNAME_USERDIFFFUNC);
                String noteNumber = pinInst.getStringValue(PinTableIO.FLDNAME_NOTENUMBER);
                String dieNetName = dieNet == null ? "" : dieNet.getName();
                String packageNetName = packageNet == null ? "" : packageNet.getName();
                String strBump = PinTableIO.formatHierPin((HierInst<PinTemplate>)bump);
                this.mCsvOut.writeLine(bankNumber, bumpId, bumpX, bumpY, templateName, oioPinNetName, chipPadFunc, userMemoryFunc, userDifferentialFunc, noteNumber, dieNetName, packageNetName, strIoPad, strBump);
            }
            ALog.logInfo((String)"Export complete.");
            try {
                this.mCsvOut.close();
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"Error closing output file.", (Object[])new Object[0]);
                return false;
            }
            return true;
        }
    }
}

