/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PinToDeviceScript {
    static final String DEFAULT_PINTEMPLATE_NAME_IN_BUMP = "PAD";
    private List<DeviceTemplate> mDevTs;
    private PrintWriter mOutput;
    private boolean mSetBumpRotation;

    public static void exportAllDefaultScript(String outFilePath) {
        PinToDeviceScript.exportAllDefaultScript(outFilePath, false);
    }

    public static void exportAllDefaultScript(String outFilePath, boolean setBumpRotation) {
        Db curDb = OrbitIO.getCurDb();
        if (curDb == null) {
            ALog.logWarn((String)"No active database, ignore exportAllDefaultScript");
            return;
        }
        List<DeviceTemplate> devTs = curDb.getObjects(DeviceTemplate.class).parallelStream().map(devT -> devT).filter(devT -> devT.getType() != DeviceTemplate.Type.BUMP && !(devT instanceof Design) && devT.getPins().hasNext()).collect(Collectors.toList());
        Collections.sort(devTs);
        outFilePath = outFilePath.replace(".ojs", "");
        for (DeviceTemplate devT2 : devTs) {
            String outFile = String.format("%s_%s_%s.ojs", outFilePath, devT2.getSubstrate().getName(), devT2.getName());
            PinToDeviceScript.exportDefaultScript(devT2.getSubstrate().getName(), devT2.getName(), outFile, setBumpRotation);
        }
        PinToDeviceScript.exportAllDeviceTemplate(devTs, outFilePath, setBumpRotation);
    }

    private static void exportAllDeviceTemplate(List<DeviceTemplate> devTs, String outFilePath, boolean setBumpRotation) {
        String outFile = String.format("%s_all.ojs", outFilePath);
        PinToDeviceScript sc = new PinToDeviceScript(devTs, setBumpRotation);
        sc.exportDefaultScript(outFile);
    }

    public static void exportDefaultScript(String substrateName, String deviceTemplateName, String outFilePath) {
        PinToDeviceScript.exportDefaultScript(substrateName, deviceTemplateName, outFilePath, false);
    }

    public static void exportDefaultScript(String substrateName, String deviceTemplateName, String outFilePath, boolean setBumpRotation) {
        Db curDb = OrbitIO.getCurDb();
        Substrate substrate = Substrate.getSubstrate((Db)curDb, (String)substrateName);
        if (substrate == null) {
            ALog.logError((String)"Cannot find the substrate %s", (Object[])new Object[]{substrateName});
            return;
        }
        DeviceTemplate devT = substrate.getDeviceTemplate(deviceTemplateName);
        if (devT == null) {
            ALog.logError((String)"Cannot find the deviceTemplate %s", (Object[])new Object[]{substrateName});
            return;
        }
        PinToDeviceScript sc = new PinToDeviceScript(devT, setBumpRotation);
        sc.exportDefaultScript(outFilePath);
    }

    private PinToDeviceScript(List<DeviceTemplate> devTs, boolean setBumpRotation) {
        this.mDevTs = devTs;
        this.mSetBumpRotation = setBumpRotation;
    }

    private PinToDeviceScript(DeviceTemplate devT, boolean setBumpRotation) {
        this.mDevTs = new LinkedList<DeviceTemplate>();
        this.mDevTs.add(devT);
        this.mSetBumpRotation = setBumpRotation;
    }

    private void exportDefaultScript(String outFilePath) {
        try {
            this.mOutput = new PrintWriter(new File(outFilePath));
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to open specified file '%s' for writing.", (Object[])new Object[]{outFilePath});
            return;
        }
        try {
            this.exportDefaultScript();
        }
        catch (Throwable t) {
            ALog.logError((Throwable)t, (String)"There was an unexpected exception while writing a script.", (Object[])new Object[0]);
            this.mOutput.close();
            return;
        }
        if (this.mOutput.checkError()) {
            ALog.logError((String)"There was an error writing the file '%s'.", (Object[])new Object[]{outFilePath});
            this.mOutput.close();
            return;
        }
        this.mOutput.close();
        ALog.logInfo((String)"Export script to %s complete.", (Object[])new Object[]{outFilePath});
    }

    private void exportDefaultScript() {
        this.printDesignInfo();
        this.mOutput.println("import com.sigrity.orbit.factory.PinToDevice;");
        this.mOutput.println();
        this.mDevTs.forEach(dt -> this.printPinToDeviceScript((DeviceTemplate)dt));
    }

    private void printDesignInfo() {
        this.mOutput.format("// %s version %s\n", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion());
        this.mOutput.format("// Build: %s (%s)\n", ABuildInfo.getVersion(), ABuildInfo.getTimestamp());
        this.mOutput.format("// User: %s\n", System.getProperty("user.name"));
        this.mOutput.format("// Time: %s\n", new Date());
        String file = this.mDevTs.get(0).getDb().getCanonicalPath();
        this.mOutput.format("// Source design: %s\n", file != null ? file : "<Unsaved Design>");
        this.mOutput.println();
    }

    private Set<PadTemplate> getDevTPads(DeviceTemplate dt) {
        return dt.getPins().parallelStream().map(pin -> pin.getPadTemplate()).collect(Collectors.toSet());
    }

    private void printPinToDeviceScript(DeviceTemplate dt) {
        this.mOutput.format("// Subatrate: %s, DeviceTemplate: %s\n", dt.getSubstrate().getName(), dt.getName());
        this.getDevTPads(dt).forEach(pad -> this.printPinToDeviceScript(dt, (PadTemplate)pad));
        this.mOutput.println();
    }

    private void printPinToDeviceScript(DeviceTemplate dt, PadTemplate pad) {
        this.mOutput.format("// PadTemplate: %s\n", pad.getName());
        this.mOutput.format("PinToDevice ptd = new PinToDevice();\n", new Object[0]);
        this.mOutput.format("ptd.loadTemplate(\"%s\", \"%s\");\n", dt.getSubstrate().getName(), dt.getName());
        this.mOutput.format("ptd.loadPadTemplate(\"%s\");\n", pad.getName());
        this.mOutput.format("ptd.loadDevice(\"%s\");\n", pad.getName());
        this.mOutput.format("ptd.loadPin(\"%s\");\n", DEFAULT_PINTEMPLATE_NAME_IN_BUMP);
        this.printPinsToDevicesCommand();
        this.mOutput.println();
    }

    private void printPinsToDevicesCommand() {
        if (this.mSetBumpRotation) {
            this.mOutput.format("ptd.pinsToDevices(true);\n", new Object[0]);
        } else {
            this.mOutput.format("ptd.pinsToDevices();\n", new Object[0]);
        }
    }
}

