/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ABoolean;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.CreatePinFactory;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.PortCSVOut;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PortCSVIn {
    private final File f;
    private final Db mDb;
    private final Unit mUnit;
    private final DevicePath mDevPath;
    private final CreatePinFactory mPinF;
    private Mode mMode = Mode.MERGE;
    private CreatePinFactory.Type mType = CreatePinFactory.Type.PIN;
    private boolean mPortCenter = false;
    static final String[] NECESSARY_HEADER = new String[]{"PIN_NUMBER", "PIN_NAME", "X", "Y"};

    public void setMode(Mode mode) {
        this.mMode = mode;
    }

    public void setType(CreatePinFactory.Type type) {
        this.mType = type;
    }

    public void setPortCenter(boolean b) {
        this.mPortCenter = b;
    }

    public List<PadTemplate> getNeedEditPads() {
        if (this.mPinF != null) {
            return this.mPinF.getNeedEditPads();
        }
        return new ArrayList<PadTemplate>();
    }

    public PortCSVIn(String filePath, String devPath) {
        this.mDb = OrbitApp.getCurDb();
        this.mDevPath = DevicePath.fromString((Db)this.mDb, (String)devPath);
        this.f = new File(filePath);
        this.mUnit = Design.getUnit((Db)this.mDb);
        this.mPinF = new CreatePinFactory();
    }

    private boolean validate() {
        if (this.mDb == null || this.mDb.closed()) {
            ALog.logError((String)"Cannot find active database.");
            return false;
        }
        if (this.mDevPath == null) {
            ALog.logError((String)"Cannot find device path.");
            return false;
        }
        if (!this.f.exists()) {
            ALog.logError((String)"Cannot read non-existent file '%s'.", (Object[])new Object[]{this.f});
            return false;
        }
        return true;
    }

    public void importPinList() {
        if (!this.validate()) {
            return;
        }
        try {
            if (this.mMode == Mode.REPLACE) {
                this.deleteContents();
            }
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            CSVDocument csvDoc = parser2.parse(this.f.getPath());
            if (!parser2.validateHeader(NECESSARY_HEADER)) {
                ALog.logError((String)"Unexpected header in input file %s.", (Object[])new Object[]{this.f});
                ALog.logError((String)"Header should be %s", (Object[])new Object[]{PortCSVOut.HEADER});
                return;
            }
            this.mPinF.setType(this.mType);
            this.mPinF.setPortCenter(this.mPortCenter);
            for (int i = 0; i != csvDoc.getItemCount(); ++i) {
                this.mPinF.addPin(this.createPinData(csvDoc, i));
            }
            this.mPinF.createPins();
            OrbitIO.refreshViewsOf(this.mDb);
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)"Problems reading %s", (Object[])new Object[]{this.f});
        }
    }

    private void deleteContents() {
        DeviceTemplate devT = this.mDevPath.getDeviceTemplate();
        devT.removePins();
        devT.deleteChildDevices();
    }

    private CreatePinFactory.PinData createPinData(final CSVDocument doc, final int idx) {
        return new CreatePinFactory.PinData(){

            public Net.Use getNetUse() {
                return PortCSVIn.getNetUseBy(doc.getItemValue(idx, "PIN_USE"));
            }

            public Net.Direction getNetDir() {
                return PortCSVIn.getNetDirBy(doc.getItemValue(idx, "PIN_DIRECTION"));
            }

            public Term.Use getTermUse() {
                return PortCSVIn.getTermUseBy(doc.getItemValue(idx, "PIN_USE"));
            }

            public Term.Type getTermType() {
                return PortCSVIn.getTermTypeBy(doc.getItemValue(idx, "PIN_DIRECTION"));
            }

            public PinTemplate.Use getPinUse() {
                return PortCSVIn.getPinUseBy(doc.getItemValue(idx, "PIN_USE"));
            }

            public PinTemplate.Direction getPinDir() {
                return PortCSVIn.getPinDirBy(doc.getItemValue(idx, "PIN_DIRECTION"));
            }

            public String getPinNum() {
                String name = doc.getItemValue(idx, "PIN_NUMBER");
                if (name == null || name.isBlank()) {
                    PortCSVIn.logAndShowWarningForMissingField("PIN_NUMBER", PortCSVIn.this.f.getPath(), idx + 1);
                    return null;
                }
                return name;
            }

            public String getTermName() {
                return doc.getItemValue(idx, "PIN_NAME");
            }

            public String getNetName() {
                String name = doc.getItemValue(idx, "NET_NAME");
                if (name == null || name.isBlank()) {
                    name = doc.getItemValue(idx, "PIN_NAME");
                }
                return name;
            }

            public String getPinPersonality() {
                return doc.getItemValue(idx, "PIN_PERSONALITY");
            }

            public boolean getFixed() {
                String fixed = doc.getItemValue(idx, "FIXED");
                return ABoolean.fromString((String)fixed);
            }

            public long getX() {
                long x;
                try {
                    x = PortCSVIn.this.mUnit.fromUser(Double.parseDouble(doc.getItemValue(idx, "X")));
                }
                catch (NumberFormatException e) {
                    PortCSVIn.logAndShowWarningForMissingField("X", PortCSVIn.this.f.getPath(), idx + 1);
                    return 0L;
                }
                return x;
            }

            public long getY() {
                long y;
                try {
                    y = PortCSVIn.this.mUnit.fromUser(Double.parseDouble(doc.getItemValue(idx, "Y")));
                }
                catch (NumberFormatException e) {
                    PortCSVIn.logAndShowWarningForMissingField("Y", PortCSVIn.this.f.getPath(), idx + 1);
                    return 0L;
                }
                return y;
            }

            public float getRotate() {
                return 0.0f;
            }

            public String getPadTemplate() {
                return doc.getItemValue(idx, "PADSTACK");
            }

            public Device getDev() {
                return PortCSVIn.this.mDevPath.getLast();
            }

            public DeviceTemplate getDevT() {
                return PortCSVIn.this.mDevPath.getDeviceTemplate();
            }

            public Db getDb() {
                return PortCSVIn.this.mDevPath.getDb();
            }

            public Unit getUnit() {
                return PortCSVIn.this.mUnit;
            }

            public String getDiffPair() {
                return null;
            }

            public String getDevicePinTemplate() {
                if (doc.getItemValue(idx, "DEVICE_PIN_TEMPLATE") == null || doc.getItemValue(idx, "DEVICE_PIN_TEMPLATE").isBlank()) {
                    if (this.getPadTemplate() != null && !this.getPadTemplate().isBlank()) {
                        return this.getPadTemplate();
                    }
                    return "Bump";
                }
                return doc.getItemValue(idx, "DEVICE_PIN_TEMPLATE");
            }

            public String getDevicePinTerm() {
                if (doc.getItemValue(idx, "DEVICE_PIN_TERM") == null || doc.getItemValue(idx, "DEVICE_PIN_TERM").isBlank()) {
                    return "pin";
                }
                return doc.getItemValue(idx, "DEVICE_PIN_TERM");
            }
        };
    }

    private static void logAndShowWarningForMissingField(String field, String pinFilePath, int line) {
        String title = "Invalid CSV Format";
        String msg = String.format("Missing field: %s on line %d in file%n'%s'.", field, line, pinFilePath);
        OrbitApp.logAndDisplayWarningDialog((String)msg, (String)title);
    }

    public static Net.Use getNetUseBy(String pinUse) {
        String token = AUtil.deSpace((String)pinUse);
        Net.Use use = null;
        try {
            if (token != null && !token.isBlank()) {
                use = Net.Use.valueOf((String)token);
            }
        }
        catch (Exception e) {
            ALog.flogDebug((String)"Missing %s in Net Use", (Object[])new Object[]{token});
        }
        return use == null || use == Net.Use.UNKNOWN ? Net.Use.SIGNAL : use;
    }

    public static Net.Direction getNetDirBy(String pindir) {
        String token = AUtil.deSpace((String)pindir);
        Net.Direction type = null;
        try {
            if (token != null && !token.isBlank()) {
                type = Net.Direction.valueOf((String)token);
            }
        }
        catch (Exception e) {
            ALog.flogDebug((String)"Missing %s in Net Direction", (Object[])new Object[]{token});
        }
        return type == null || type == Net.Direction.UNKNOWN ? Net.Direction.INOUT : type;
    }

    public static Term.Use getTermUseBy(String pinUse) {
        String token = AUtil.deSpace((String)pinUse);
        Term.Use use = null;
        try {
            if (token != null && !token.isBlank()) {
                use = Term.Use.valueOf((String)token);
            }
        }
        catch (Exception e) {
            ALog.flogDebug((String)"Missing %s in Term Use", (Object[])new Object[]{token});
        }
        return use == null ? Term.Use.SIGNAL : use;
    }

    public static Term.Type getTermTypeBy(String pindir) {
        String token = AUtil.deSpace((String)pindir);
        Term.Type type = null;
        try {
            if (token != null && !token.isBlank()) {
                type = Term.Type.valueOf((String)token);
            }
        }
        catch (Exception e) {
            ALog.flogDebug((String)"Missing %s in Term Type", (Object[])new Object[]{token});
        }
        return type == null ? Term.Type.INOUT : type;
    }

    public static PinTemplate.Use getPinUseBy(String pinUse) {
        String token = AUtil.deSpace((String)pinUse);
        PinTemplate.Use use = null;
        try {
            if (token != null && !token.isBlank()) {
                use = PinTemplate.Use.valueOf((String)token);
            }
        }
        catch (Exception e) {
            ALog.flogDebug((String)"Missing %s in Pin Use", (Object[])new Object[]{token});
        }
        return use == null || use == PinTemplate.Use.UNKNOWN ? PinTemplate.Use.SIGNAL : use;
    }

    public static PinTemplate.Direction getPinDirBy(String pindir) {
        String token = AUtil.deSpace((String)pindir);
        PinTemplate.Direction type = null;
        try {
            if (token != null && !token.isBlank()) {
                type = PinTemplate.Direction.valueOf((String)token);
            }
        }
        catch (Exception e) {
            ALog.flogDebug((String)"Missing %s in Pin Direction", (Object[])new Object[]{token});
        }
        return type == null || type == PinTemplate.Direction.UNKNOWN ? PinTemplate.Direction.INOUT : type;
    }

    public static enum Mode {
        REPLACE,
        MERGE;

    }
}

