/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.CSVIOWizard;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PortCSVOut {
    public static final String SETTINGS_SECTION = AReflection.getJavaClassName(PortCSVOut.class);
    private static final String VERSION = "0.1";
    public static final String COL_X = "X";
    public static final String COL_Y = "Y";
    public static final String COL_PIN_NAME = "PIN_NAME";
    public static final String COL_NET_NAME = "NET_NAME";
    public static final String COL_DEVICE_PIN_DEVT = "DEVICE_PIN_TEMPLATE";
    public static final String COL_DEVICE_PIN_TERM = "DEVICE_PIN_TERM";
    public static final String COL_PIN_NUMBER = "PIN_NUMBER";
    public static final String COL_PIN_USE = "PIN_USE";
    public static final String COL_PIN_DIRECTION = "PIN_DIRECTION";
    public static final String COL_PIN_PERSONALITY = "PIN_PERSONALITY";
    public static final String COL_PAD = "PADSTACK";
    public static final String COL_FIXED = "FIXED";
    static final List<String> HEADER = AUtil.arrayList((Object[])new String[]{"PIN_NUMBER", "PIN_NAME", "PIN_USE", "PIN_DIRECTION", "X", "Y", "PADSTACK", "PIN_PERSONALITY", "NET_NAME", "FIXED", "DEVICE_PIN_TEMPLATE", "DEVICE_PIN_TERM"});
    protected boolean mAbsoluteLocations = true;
    protected boolean mPortCenterLoc = false;
    private Db mDb;
    private Unit mUnit;
    private DevicePath mOutPath;
    private CSVIOWizard mWiz = new CSVIOWizard(HEADER);

    public static List<String> getHeader() {
        return HEADER;
    }

    public static boolean writeNow(String filePath, String devicePath) {
        PortCSVOut pOut = new PortCSVOut();
        return pOut.write(OrbitApp.getCurDb(), filePath, devicePath);
    }

    public void setAbsoluteLocations(boolean b) {
        this.mAbsoluteLocations = b;
    }

    public void setPortCenter(boolean b) {
        this.mPortCenterLoc = b;
    }

    public boolean write(Db db, String filePath, String devicePath) {
        boolean bl;
        block9: {
            DevicePath startDevPath = DevicePath.fromString((Db)db, (String)devicePath);
            if (startDevPath == null) {
                ALog.logWarn((String)"Invalid device path '%s'.", (Object[])new Object[]{devicePath});
                return false;
            }
            this.mDb = db;
            this.mUnit = Design.getUnit((Db)db);
            this.mOutPath = startDevPath;
            ACsvWriter writer = ACsvWriter.open((String)filePath);
            try {
                bl = this.write(writer);
                if (writer == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Unable to open '%s' for writing.", (Object[])new Object[]{filePath});
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    public void setCSVIOWizard(CSVIOWizard wiz) {
        this.mWiz = wiz;
    }

    private void writeCSVInfo(ACsvWriter writer) {
        writer.row(new String[]{"#. Version: 0.1"});
        writer.row(new String[]{"#. Date: " + new Date()});
        writer.row(new String[]{"#. Orbit: " + OrbitIO.getApp().getBuildVersion()});
        writer.row(new String[]{"#. FilePath: " + this.mDb.getCanonicalPath()});
        writer.row(new String[]{"#. DevicePath: " + this.mOutPath.toString()});
        writer.row(new String[]{"#. Unit: " + this.mUnit.getUserName()});
    }

    private void writeHeader(ACsvWriter writer) {
        List newHeader = this.mWiz.toNewOrder(HEADER);
        for (String head : newHeader) {
            writer.colData(head);
        }
        writer.endRow();
    }

    private boolean write(ACsvWriter writer) {
        int count = 0;
        try {
            this.writeCSVInfo(writer);
            this.writeHeader(writer);
            count = this.writePins(writer, this.mOutPath);
            ALog.logInfo((String)"Wrote %d pins to file", (Object[])new Object[]{count});
            return true;
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Problem writing", (Object[])new Object[0]);
            return false;
        }
    }

    private int writePins(ACsvWriter writer, DevicePath outputPath) {
        int count = 0;
        for (HierInst hierPin : outputPath.getDeviceTemplate().getPinsAndDescendants(true)) {
            PinData pindata = PinData.create((PinTemplate)hierPin.getDbObject(), hierPin.getPath(), outputPath, this.mAbsoluteLocations, this.mPortCenterLoc);
            if (pindata == null) continue;
            count += this.writePins(writer, pindata);
        }
        return count;
    }

    private int writePins(ACsvWriter writer, PinData pindata) {
        assert (pindata != null);
        ArrayList<String> befWizRow = new ArrayList<String>();
        for (String column : HEADER) {
            if (column.equals(COL_X)) {
                befWizRow.add(pindata.getX());
                continue;
            }
            if (column.equals(COL_Y)) {
                befWizRow.add(pindata.getY());
                continue;
            }
            if (column.equals(COL_PIN_NAME)) {
                befWizRow.add(pindata.getDieLevelTerm());
                continue;
            }
            if (column.equals(COL_PIN_NUMBER)) {
                befWizRow.add(pindata.getPinNumber());
                continue;
            }
            if (column.equals(COL_PIN_USE)) {
                befWizRow.add(pindata.getPinUse());
                continue;
            }
            if (column.equals(COL_PIN_DIRECTION)) {
                befWizRow.add(pindata.getPinDir());
                continue;
            }
            if (column.equals(COL_PIN_PERSONALITY)) {
                befWizRow.add(pindata.getPinPersonality());
                continue;
            }
            if (column.equals(COL_NET_NAME)) {
                befWizRow.add(pindata.getDieLevelNet());
                continue;
            }
            if (column.equals(COL_FIXED)) {
                befWizRow.add(pindata.getFixed());
                continue;
            }
            if (column.equals(COL_PAD)) {
                befWizRow.add(pindata.getPadstack());
                continue;
            }
            if (column.equals(COL_DEVICE_PIN_DEVT)) {
                befWizRow.add(pindata.getDevicePinDevT());
                continue;
            }
            if (column.equals(COL_DEVICE_PIN_TERM)) {
                befWizRow.add(pindata.getDevicePinTerm());
                continue;
            }
            throw new UnsupportedOperationException("Unimplemented Column " + column);
        }
        this.mWiz.toNewOrder(befWizRow).forEach(arg_0 -> ((ACsvWriter)writer).colData(arg_0));
        writer.endRow();
        return 1;
    }

    public static class PinData {
        private final PinTemplate mPinT;
        private final DevicePath mPath;
        private final DevicePath mOutputDevP;
        private final boolean mAbsLoc;
        private final boolean mPortCenter;
        private Type mType;
        private Net mDieLevelNet;
        private String mX = "";
        private String mY = "";
        private String mDieLevelTermName = "";
        private String mPinNumber = "";
        private String mPinUse = "";
        private String mPinDir = "";
        private String mPinPersonality = "";
        private String mDieLevelNetName = "";
        private String mFixed = "";
        private String mPadstack = "";
        private String mDevicePinDevTName = "";
        private String mDevicePinTermName = "";

        public static PinData create(PinTemplate pinT, DevicePath path, DevicePath outputDev, boolean abs, boolean center) {
            PinData pin = new PinData(pinT, path, outputDev, abs, center);
            if (!pin.init()) {
                return null;
            }
            return pin;
        }

        private PinData(PinTemplate pin, DevicePath path, DevicePath outputDev, boolean abs, boolean center) {
            this.mPinT = pin;
            this.mPath = path;
            this.mOutputDevP = outputDev;
            this.mAbsLoc = abs;
            this.mPortCenter = center;
        }

        public String getX() {
            return this.mX;
        }

        public String getY() {
            return this.mY;
        }

        public String getDieLevelTerm() {
            return this.mDieLevelTermName;
        }

        public String getPinNumber() {
            return this.mPinNumber;
        }

        public String getPinUse() {
            return this.mPinUse;
        }

        public String getPinDir() {
            return this.mPinDir;
        }

        public String getPinPersonality() {
            return this.mPinPersonality;
        }

        public String getDieLevelNet() {
            return this.mDieLevelNetName;
        }

        public String getFixed() {
            return this.mFixed;
        }

        public String getPadstack() {
            return this.mPadstack;
        }

        public String getDevicePinDevT() {
            return this.mDevicePinDevTName;
        }

        public String getDevicePinTerm() {
            return this.mDevicePinTermName;
        }

        private boolean init() {
            this.mType = this.mPath.getDeviceTemplate().amIAPin() ? Type.DEVICE_PIN : Type.PIN;
            this.initLoc();
            this.initPinNumber();
            this.initDieLevelNet();
            if (!this.initDieLevelTerm()) {
                return false;
            }
            this.initDevicePinDevT();
            if (!this.initDevicePinLevelTerm()) {
                return false;
            }
            DevicePath fullPath = new DevicePath(this.mOutputDevP, this.mPath);
            Device device = fullPath.getLast();
            PinInstance pinInst = PinInstance.getPinInstance((Device)device, (PinTemplate)this.mPinT);
            if (pinInst != null) {
                this.mPinPersonality = pinInst.getPersonalitiesString(false, true);
                this.mFixed = Boolean.toString(pinInst.fixed());
                String string = this.mPinNumber = device.getTemplate().amIAPin() ? device.getName() : pinInst.getName();
            }
            if (this.mPinT.getUse() != null) {
                this.mPinUse = this.mPinT.getUse().name();
            }
            if (this.mPinT.getDirection() != null) {
                this.mPinDir = this.mPinT.getDirection().name();
            }
            if (this.mPinT.getPadTemplate() != null) {
                this.mPadstack = this.mPinT.getPadTemplate().getName();
            }
            return true;
        }

        private void initLoc() {
            APoint2D loc = this.mType == Type.PIN ? this.mPinT.getWorldLoc(new DevicePath(this.mOutputDevP, this.mPath)) : (this.mType == Type.DEVICE_PIN ? (this.mPortCenter ? this.mPinT.getFirstPortTemplate().getWorldLoc(new DevicePath(this.mOutputDevP, this.mPath)) : this.mPath.getLast().getWorldLoc(new DevicePath(this.mOutputDevP, this.mPath))) : new APoint2D());
            if (!this.mAbsLoc) {
                loc = this.mOutputDevP.getDeviceRelativePoint(loc);
            }
            this.mX = this.toUserUnit(loc.getX());
            this.mY = this.toUserUnit(loc.getY());
        }

        private void initDieLevelNet() {
            Net netAtSubstrate = this.mType == Type.DEVICE_PIN ? NetMap.getNetAt((Net)this.mPinT.getNet(), (DevicePath)this.mPath, (DeviceTemplate)this.mOutputDevP.getDeviceTemplate()) : this.mPinT.getNet();
            this.mDieLevelNetName = "NetUnused";
            if (netAtSubstrate.getDeviceTemplate().equals(this.mOutputDevP.getDeviceTemplate())) {
                this.mDieLevelNet = netAtSubstrate;
                this.mDieLevelNetName = netAtSubstrate.getName();
            }
        }

        private boolean initDieLevelTerm() {
            DevicePath pinPath = DevicePath.fromString((Db)this.mPath.getDb(), (String)this.mPath.toString(), (DeviceTemplate)this.mOutputDevP.getDeviceTemplate());
            PinLabel label = PinLabel.get((DevicePath)pinPath, (PinTemplate)this.mPinT);
            if (label != null && label.getTerm() != null) {
                this.mDieLevelTermName = label.getTerm().getName();
                return true;
            }
            if (this.mDieLevelNet != null && this.mDieLevelNet.getTermsCount() == 1) {
                this.mDieLevelTermName = ((Term)this.mDieLevelNet.getTerms().next()).getName();
                return true;
            }
            if (this.mDieLevelNet != null && this.mDieLevelNet.getTermsCount() > 1) {
                String msg = String.format("Invalid: Can not determine term on %s. There are multiple terms on the net %s.", this.mPinT.getName(), this.mDieLevelNet.getName());
                OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Invalid Export");
                return false;
            }
            return true;
        }

        private boolean initDevicePinLevelTerm() {
            if (this.mType != Type.DEVICE_PIN) {
                return true;
            }
            PinLabel label = PinLabel.get((PinTemplate)this.mPinT);
            if (label != null && label.getTerm() != null) {
                this.mDevicePinTermName = label.getTerm().getName();
            }
            if (this.mDevicePinTermName == null || this.mDevicePinTermName.isBlank()) {
                IterableIterator netTerm = this.mPinT.getNet().getTerms();
                if (netTerm.hasNext() && netTerm.count() > 1L) {
                    String msg = String.format("Invalid: Can not determine term on %s. There are multiple terms on the net %s.", this.mPinT.getName(), this.mPinT.getNet());
                    OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Invalid Export");
                    return false;
                }
                if (netTerm.hasNext() && netTerm.count() == 1L) {
                    this.mDevicePinTermName = ((Term)netTerm.next()).getName();
                }
            }
            return true;
        }

        private void initDevicePinDevT() {
            if (this.mType == Type.PIN) {
                return;
            }
            this.mDevicePinDevTName = this.mPath.getDeviceTemplate().getName();
        }

        private void initPinNumber() {
            this.mPinNumber = this.mType == Type.PIN ? this.mPinT.getName() : this.mPath.getLast().getName();
        }

        protected String toUserUnit(long d) {
            Unit unit = Design.getUnit((Db)this.mPath.getDb());
            return unit == null ? Long.toString(d) : "" + unit.toUser(d);
        }

        public static enum Type {
            DEVICE_PIN,
            PIN;

        }
    }
}

