/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PortOrder {
    private ArrayList<HierPin> mPorts = null;
    private DevicePath mDp;
    private float mOldR = -1.0f;
    private boolean mMirror = false;
    protected ArrayList<ArrayList<HierPin>> mQPorts = new ArrayList();
    protected ARect mBound = null;
    private APoint2D mCenter = null;
    private boolean mCCW = true;
    private boolean mDebug = false;

    public PortOrder(ArrayList<HierPin> ports, DevicePath dp, boolean CCW) {
        this.mPorts = ports;
        this.mDp = dp;
        this.mCCW = CCW;
    }

    public void setPinNumberInCCW() {
        this.init();
        int pinNum = 1;
        int shift = StartCorner.UpperLeft.ordinal();
        for (int quad = 0; quad < 4; ++quad) {
            int shiftedQuad = (quad - shift + 4) % 4;
            ArrayList<HierPin> ports = this.mQPorts.get(shiftedQuad);
            if (ports.isEmpty()) continue;
            Collections.sort(ports, shiftedQuad % 2 == 0 ? new SortV(shiftedQuad == 0) : new SortH(shiftedQuad == 3));
            for (HierPin ppp : ports) {
                PinInstance wbPort = ppp.getPin();
                wbPort.setPinNum(pinNum++);
            }
        }
        this.reset();
        this.dumpSortedPorts();
    }

    private void init() {
        boolean m;
        Device d = this.mDp.getLast();
        float r = this.mDp.getRot();
        if (r != 0.0f) {
            this.mOldR = d.getRotate();
            d.setRotate(ATransformUtil.normRot((float)(this.mOldR + (360.0f - r))));
        }
        if (m = this.mDp.getMirror()) {
            this.mMirror = true;
            d.setMirror(!d.getMirror());
        }
        this.mBound = this.mDp.getBB();
        this.mCenter = this.mBound.center();
        this.deriveQuads();
    }

    private void deriveQuads() {
        for (int i = 0; i < 4; ++i) {
            this.mQPorts.add(new ArrayList());
        }
        for (HierPin p : this.mPorts) {
            APoint2D loc = p.getWorldLoc();
            int quad = AGeomUtil.getQuadrant((APoint2D)loc, (ARect)this.mBound);
            this.mQPorts.get(quad).add(p);
        }
    }

    private void reset() {
        Device d = this.mDp.getLast();
        if (this.mOldR != -1.0f) {
            d.setRotate(this.mOldR);
        }
        if (this.mMirror) {
            d.setMirror(!d.getMirror());
        }
    }

    private void dumpSortedPorts() {
        if (!this.mDebug) {
            return;
        }
        System.out.println("------------------- order " + this.mPorts.size() + " pins in " + (this.mCCW ? "CCW" : "CW") + " ----------------");
        System.out.println("Pin no.     DevicePath-PinName     Angle to center" + this.mCenter);
        for (HierPin ppp : this.mPorts) {
            PinInstance wbPort = ppp.getPin();
            ALine l = new ALine(this.mCenter, ppp.getWorldLoc());
            System.out.println(" " + wbPort.getPinNum() + " " + ppp.getPath().getString() + "-" + wbPort.getName() + " " + l.getAngle());
        }
    }

    public static void setCCWOrder(ArrayList<HierPin> ports, DevicePath dp) {
        PortOrder po = new PortOrder(ports, dp, true);
        po.setPinNumberInCCW();
    }

    public static enum StartCorner {
        LowerRight,
        LowerLeft,
        UpperLeft,
        UpperRight;

    }

    public class SortAngle
    implements Comparator<HierPin> {
        private APoint2D mCenter;
        private boolean mCCW;
        private double startAngle = 225.0;

        public SortAngle(APoint2D center, boolean CCW) {
            this.mCenter = center;
            this.mCCW = CCW;
        }

        @Override
        public int compare(HierPin p0, HierPin p1) {
            ALine l0 = new ALine(this.mCenter, p0.getWorldLoc());
            ALine l1 = new ALine(this.mCenter, p1.getWorldLoc());
            double a0 = (l0.getAngle() - this.startAngle + 360.0) % 360.0;
            double a1 = (l1.getAngle() - this.startAngle + 360.0) % 360.0;
            double dd = a1 - a0;
            if (dd < 0.0) {
                return this.mCCW ? 1 : -1;
            }
            if (dd > 0.0) {
                return this.mCCW ? -1 : 1;
            }
            long d0 = p0.getWorldLoc().distance(this.mCenter);
            long d1 = p1.getWorldLoc().distance(this.mCenter);
            long d = d1 - d0;
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public static class SortH
    implements Comparator<HierPin> {
        private boolean mLowBound;

        public SortH(boolean lowBound) {
            this.mLowBound = lowBound;
        }

        @Override
        public int compare(HierPin o1, HierPin o2) {
            long d = o1.getWorldLoc().getX() - o2.getWorldLoc().getX();
            if (d < 0L) {
                return this.mLowBound ? -1 : 1;
            }
            if (d > 0L) {
                return this.mLowBound ? 1 : -1;
            }
            d = o1.getWorldLoc().getY() - o2.getWorldLoc().getY();
            if (d < 0L) {
                return this.mLowBound ? -1 : 1;
            }
            if (d > 0L) {
                return this.mLowBound ? 1 : -1;
            }
            return 0;
        }
    }

    public static class SortV
    implements Comparator<HierPin> {
        private boolean mLowBound;

        public SortV(boolean lowBound) {
            this.mLowBound = lowBound;
        }

        @Override
        public int compare(HierPin o1, HierPin o2) {
            long d = o1.getWorldLoc().getY() - o2.getWorldLoc().getY();
            if (d < 0L) {
                return this.mLowBound ? -1 : 1;
            }
            if (d > 0L) {
                return this.mLowBound ? 1 : -1;
            }
            d = o1.getWorldLoc().getX() - o2.getWorldLoc().getX();
            if (d < 0L) {
                return this.mLowBound ? 1 : -1;
            }
            if (d > 0L) {
                return this.mLowBound ? -1 : 1;
            }
            return 0;
        }
    }
}

