/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.export.AIFOut;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PortShapeOrder {
    private ArrayList<PortShape> mPortShapes = new ArrayList();
    private DevicePath mDp;
    private float mOldR = -1.0f;
    private boolean mMirror = false;
    protected ArrayList<ArrayList<PortShape>> mQPortShapes = new ArrayList();
    protected ARect mBound = null;
    private APoint2D mCenter = null;
    private APoint2D mRefCenter = null;
    private SortType mSortType = SortType.SORT_SHAPES_CCW;
    private boolean mPrefer;
    private boolean mDebug = false;

    public PortShapeOrder(ArrayList<HierPin> ports, DevicePath parentPath, APoint2D refCenter, SortType sortType, boolean prefer) {
        this.mDp = parentPath;
        this.mRefCenter = refCenter;
        this.mSortType = sortType;
        this.mPrefer = prefer;
        this.init(ports);
    }

    public ArrayList<PortShape> orderPinShapes() {
        this.reset();
        if (this.mSortType != SortType.NO_SORT) {
            this.mPortShapes.clear();
            int shift = StartCorner.UpperLeft.ordinal();
            for (int quad = 0; quad < 4; ++quad) {
                int shiftedQuad = (quad - shift + 4) % 4;
                ArrayList<PortShape> portShapes = this.mQPortShapes.get(shiftedQuad);
                if (portShapes.isEmpty()) continue;
                Collections.sort(portShapes, shiftedQuad % 2 == 0 ? new SortV(shiftedQuad == 0) : new SortH(shiftedQuad == 3));
                for (PortShape ps : portShapes) {
                    ps.setOffsetCenterShape(this.mRefCenter);
                    this.mPortShapes.add(ps);
                }
            }
        }
        this.dumpSortedPorts();
        return this.mPortShapes;
    }

    private void init(ArrayList<HierPin> ports) {
        boolean m;
        Device d = this.mDp.getLast();
        float r = this.mDp.getRot();
        if (r != 0.0f) {
            this.mOldR = d.getRotate();
            d.setRotate(ATransformUtil.normRot((float)(this.mOldR + (360.0f - r))));
        }
        if (m = this.mDp.getMirror()) {
            this.mMirror = true;
            d.setMirror(!d.getMirror());
        }
        this.mBound = new ARect(this.mDp.getBB());
        for (HierPin ppp : ports) {
            PinInstance port = ppp.getPin();
            DevicePath childPath = ppp.getPath();
            this.addPortShapes(childPath, port);
        }
        this.deriveQuads();
        this.mCenter = this.mBound.center();
    }

    private void addPortShapes(DevicePath childPath, PinInstance port) {
        PinTemplate dtp = port.getPinTemplate();
        PadTemplate pt = dtp.getPadTemplate();
        String ptName = pt == null ? "-" : pt.getName();
        ArrayList<LayerShape> layerShapes = AIFOut.getSortedLayerShapes(pt, this.mPrefer);
        if (layerShapes.size() < 2) {
            LayerShape ls = layerShapes.get(0);
            AGeom s = ls != null ? ls.getGeom() : null;
            ARect r = null;
            if (s == null) {
                APoint2D wloc = port.getWorldLoc(childPath);
                r = new ARect(wloc, wloc);
                ls = null;
            }
            this.addPortShape(childPath, port, ptName, ls, r);
            return;
        }
        LayerShape last = layerShapes.get(layerShapes.size() - 1);
        Layer topLayer = last.getLayer();
        for (LayerShape ls : layerShapes) {
            AGeom s;
            Layer layer = ls.getLayer();
            if (layer != topLayer || (s = ls.getGeom()) == null) continue;
            AffineTransform xform = port.getWorldTransform(childPath);
            s = s.transform(xform);
            ARect r = s.getBounds();
            int index = layerShapes.indexOf(ls);
            String attachIndex = "_" + Integer.toString(index);
            String outPtName = index == 0 ? ptName : ptName + attachIndex;
            this.addPortShape(childPath, port, outPtName, ls, r);
        }
    }

    private void addPortShape(DevicePath childPath, PinInstance port, String outPtName, LayerShape ls, ARect boundShape) {
        this.mBound.expand(boundShape);
        this.mPortShapes.add(new PortShape(childPath, port, outPtName, ls, boundShape));
    }

    private void deriveQuads() {
        for (int i = 0; i < 4; ++i) {
            this.mQPortShapes.add(new ArrayList());
        }
        for (PortShape s : this.mPortShapes) {
            APoint2D loc = s.shape.center();
            int quad = AGeomUtil.getQuadrant((APoint2D)loc, (ARect)this.mBound);
            this.mQPortShapes.get(quad).add(s);
        }
    }

    private void reset() {
        Device d = this.mDp.getLast();
        if (this.mOldR != -1.0f) {
            d.setRotate(this.mOldR);
        }
        if (this.mMirror) {
            d.setMirror(!d.getMirror());
        }
    }

    private void dumpSortedPorts() {
        if (!this.mDebug) {
            return;
        }
        System.out.println("------------------- order " + this.mPortShapes.size() + " pin shapes in " + this.mSortType.name() + " ----------------");
        System.out.println("Pin no.     ARect    Angle to center" + this.mCenter);
        for (PortShape s : this.mPortShapes) {
            ALine l = new ALine(this.mCenter, s.shape.center());
            System.out.println(" " + this.mPortShapes.indexOf(s) + s.path.toString() + "-" + s.port.getName() + " " + l.getAngle());
        }
    }

    public static ArrayList<PortShape> setCCWOrder(ArrayList<HierPin> ports, DevicePath dp, APoint2D refCenter, SortType sortType, boolean prefer) {
        PortShapeOrder po = new PortShapeOrder(ports, dp, refCenter, sortType, prefer);
        return po.orderPinShapes();
    }

    public static enum StartCorner {
        LowerRight,
        LowerLeft,
        UpperLeft,
        UpperRight;

    }

    public class SortAngle
    implements Comparator<PortShape> {
        private APoint2D mCenter;
        private boolean mCCW;
        private double startAngle = 225.0;

        public SortAngle(APoint2D center, boolean CCW) {
            this.mCenter = center;
            this.mCCW = CCW;
        }

        @Override
        public int compare(PortShape s0, PortShape s1) {
            ALine l0 = new ALine(this.mCenter, s0.shape.center());
            ALine l1 = new ALine(this.mCenter, s1.shape.center());
            double a0 = (l0.getAngle() - this.startAngle + 360.0) % 360.0;
            double a1 = (l1.getAngle() - this.startAngle + 360.0) % 360.0;
            double dd = a1 - a0;
            if (dd < 0.0) {
                return this.mCCW ? 1 : -1;
            }
            if (dd > 0.0) {
                return this.mCCW ? -1 : 1;
            }
            long d0 = s0.shape.center().distance(this.mCenter);
            long d1 = s1.shape.center().distance(this.mCenter);
            long d = d1 - d0;
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public static class SortH
    implements Comparator<PortShape> {
        private boolean mLowBound;

        public SortH(boolean lowBound) {
            this.mLowBound = lowBound;
        }

        @Override
        public int compare(PortShape s1, PortShape s2) {
            long d = s1.shape.centerX() - s2.shape.centerX();
            if (d < 0L) {
                return this.mLowBound ? -1 : 1;
            }
            if (d > 0L) {
                return this.mLowBound ? 1 : -1;
            }
            d = s1.shape.centerY() - s2.shape.centerY();
            if (d < 0L) {
                return this.mLowBound ? -1 : 1;
            }
            if (d > 0L) {
                return this.mLowBound ? 1 : -1;
            }
            return 0;
        }
    }

    public static class SortV
    implements Comparator<PortShape> {
        private boolean mLowBound;

        public SortV(boolean lowBound) {
            this.mLowBound = lowBound;
        }

        @Override
        public int compare(PortShape s1, PortShape s2) {
            long d = s1.shape.centerY() - s2.shape.centerY();
            if (d < 0L) {
                return this.mLowBound ? -1 : 1;
            }
            if (d > 0L) {
                return this.mLowBound ? 1 : -1;
            }
            d = s1.shape.centerX() - s2.shape.centerX();
            if (d < 0L) {
                return this.mLowBound ? 1 : -1;
            }
            if (d > 0L) {
                return this.mLowBound ? -1 : 1;
            }
            return 0;
        }
    }

    public static class PortShape {
        DevicePath path;
        PinInstance port;
        String ptName;
        LayerShape layerShape;
        ARect shape;

        public PortShape(DevicePath path, PinInstance port, String ptName, LayerShape ls, ARect boundShape) {
            this.path = path;
            this.port = port;
            this.ptName = ptName;
            this.layerShape = ls;
            this.shape = boundShape;
        }

        public void setOffsetCenterShape(APoint2D refCenter) {
            if (this.layerShape == null) {
                APoint2D wloc = this.port.getWorldLoc(this.path);
                wloc = wloc.sub(refCenter);
                this.shape = new ARect(wloc, wloc);
            } else {
                AffineTransform xform = this.port.getWorldTransform(this.path);
                AGeom s = this.layerShape.getGeom().transform(xform);
                this.shape = new ARect(s.getBounds());
            }
        }
    }

    public static enum SortType {
        NO_SORT,
        SORT_PORTS,
        SORT_SHAPES_CCW;

    }
}

