/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class PowerConfigExport {
    private static final String ALIAS_NAME = "Alias: ";
    private final Db mDb;
    private final Set<APair<HierInst<Net>, HierInst<Net>>> mCheckedNetPairSet = new HashSet<APair<HierInst<Net>, HierInst<Net>>>();

    public PowerConfigExport() {
        this.mDb = OrbitIO.getCurDb();
    }

    public void export(String filePath) {
        if (this.mDb == null || this.mDb.closed()) {
            ALog.flogError((String)"Open database error.", (Object[])new Object[0]);
            return;
        }
        File file = new File(filePath);
        try (PrintWriter writer = new PrintWriter(file);){
            this.writeFileHeader(writer);
            this.writePwrCfg(writer);
            ALog.flogInfo((String)"Write power config to %s.", (Object[])new Object[]{file});
        }
        catch (FileNotFoundException fnfe) {
            ALog.logError((Throwable)fnfe, (String)"Unable to write to output file '%s'.", (Object[])new Object[]{file});
        }
    }

    private void writeFileHeader(PrintWriter writer) {
        writer.format("# OrbitIO System Planner version %s", OrbitIO.getApp().getVersion());
        writer.println();
        writer.format("# Build: %s (%s)", OrbitIO.getApp().getBuildVersion(), OrbitIO.getApp().getBuildTimestamp());
        writer.println();
        writer.format("# User: %s", System.getProperty("user.name"));
        writer.println();
        writer.format("# Time: %s", new Date());
        writer.println();
        writer.format("# Source design: %s", this.mDb.getFile());
        writer.println();
        writer.println();
    }

    private void writePwrCfg(PrintWriter writer) {
        writer.println(ALIAS_NAME);
        ContactLayer.getValid((Db)this.mDb).forEach(cl -> this.writeContactLayer((ContactLayer)cl, writer));
    }

    private void writeContactLayer(ContactLayer cl, PrintWriter writer) {
        DevicePath pathA = PowerConfigExport.getPureSubstrateInstDevPath(cl.getDevicePathA());
        DevicePath pathB = PowerConfigExport.getPureSubstrateInstDevPath(cl.getDevicePathB());
        if (pathA == null || pathB == null) {
            return;
        }
        writer.format("#. Contact layer %s(%s)-%s(%s)", pathA.getString().substring(1), cl.getContactLayerA().getName(), pathB.getString().substring(1), cl.getContactLayerB().getName());
        writer.println();
        PinMap.get((ContactLayer)cl).forEach(pm -> this.writeNetConnection(writer, (HierInst<Net>)pm.getHierNetA(), (HierInst<Net>)pm.getHierNetB()));
        writer.println();
    }

    private void writeNetConnection(PrintWriter writer, HierInst<Net> a, HierInst<Net> b) {
        if (a == null || b == null) {
            return;
        }
        HierInst<Net> netA = PowerConfigExport.getParentHierNetOnSubstrateInst(a);
        HierInst<Net> netB = PowerConfigExport.getParentHierNetOnSubstrateInst(b);
        if (netA == null || netB == null) {
            return;
        }
        if (!Net.isPowerNet(netA) || !Net.isPowerNet(netB)) {
            return;
        }
        APair pair = APair.create(netA, netB);
        if (!this.mCheckedNetPairSet.contains(pair)) {
            this.mCheckedNetPairSet.add((APair<HierInst<Net>, HierInst<Net>>)pair);
            ((Net)netA.getDbObject()).getTerms().forEach(termA -> ((Net)netB.getDbObject()).getTerms().forEach(termB -> this.writeConnectTerms(writer, (Term)termA, netA.getPath(), (Term)termB, netB.getPath())));
        }
    }

    private boolean termIsConnected(Term termA, DevicePath pathA, Term termB, DevicePath pathB) {
        DevicePath copyPathA = pathA.copy();
        DevicePath copyPathB = pathB.copy();
        Device devA = copyPathA.removeLast();
        Device devB = copyPathB.removeLast();
        Net parentNetA = TermMap.getParentNet((Device)devA, (Term)termA);
        Net parentNetB = TermMap.getParentNet((Device)devB, (Term)termB);
        if (parentNetA == null || parentNetB == null) {
            return false;
        }
        return NetMap.isConnected((Net)parentNetA, (DevicePath)copyPathA, (Net)parentNetB, (DevicePath)copyPathB);
    }

    private void writeConnectTerms(PrintWriter writer, Term termA, DevicePath pathA, Term termB, DevicePath pathB) {
        if (!this.termIsConnected(termA, pathA, termB, pathB)) {
            return;
        }
        writer.format("%s/%s %s/%s", pathA.getString().substring(1), termA.getName(), pathB.getString().substring(1), termB.getName());
        writer.println();
    }

    private static HierInst<Net> getParentHierNetOnBump(HierInst<Net> hierNet) {
        if (hierNet == null) {
            return null;
        }
        DevicePath path = hierNet.getPath();
        Net net = (Net)hierNet.getDbObject();
        if (path.getLast().getType() != DeviceTemplate.Type.BUMP) {
            return hierNet;
        }
        return NetMap.getParent((DevicePath)path, (Net)net);
    }

    protected static HierInst<Net> getParentHierNetOnSubstrateInst(HierInst<Net> hierNet) {
        HierInst<Net> bumpParentNet = PowerConfigExport.getParentHierNetOnBump(hierNet);
        if (bumpParentNet == null) {
            return null;
        }
        DevicePath path = bumpParentNet.getPath();
        Net net = (Net)bumpParentNet.getDbObject();
        if (!path.getLast().getIsSubstrate()) {
            return PowerConfigExport.getParentHierNetOnSubstrateInst((HierInst<Net>)NetMap.getParent((DevicePath)path, (Net)net));
        }
        return bumpParentNet;
    }

    private static DevicePath getPureSubstrateInstDevPath(DevicePath path) {
        DevicePath newPath = path.copy();
        while (newPath.getLast() != null && !newPath.getLast().getIsSubstrate()) {
            newPath.removeLast();
        }
        if (newPath.getLast() == null) {
            return null;
        }
        return newPath;
    }
}

