/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.ConstraintContext;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceRegion;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.export.CCTFileOutDo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RouterRules
implements CCTFileOutDo.RuleNode {
    protected static final String DEFINE = "define";
    protected static final String RULE = "rule";
    protected static final String CLASS = "class";
    protected static final String WIDTH = "width";
    protected static final String CLEARANCE = "clearance";
    protected static final String PCB = "PCB";
    protected static final String TYPE = "type";
    protected static final String LAYER_RULE = "layer_rule";
    protected static final String REGION = "region";
    protected static final String REGION_CLASS = "region_class";
    protected static final String PAIR = "pair";
    protected static final String NETS = "nets";
    protected static final String CLASS_CLASS = "class_class";
    protected static final String CLASSES = "classes";
    String mTag;
    List<String> mValues;
    List<CCTFileOutDo.RuleNode> mChildren;

    public static CCTFileOutDo.RuleNode build(Db db) {
        RouterRules root = new RouterRules("");
        ClassCounter counter = new ClassCounter();
        RouterRules.buildPCB(db, root);
        RouterRules.buildClass(db, root, counter);
        RouterRules.buildClassClass(db, root, counter);
        RouterRules.buildRegion(db, root, counter);
        RouterRules.buildDiffPair(db, root);
        return root;
    }

    protected static void buildPCB(Db db, RouterRules root) {
        APair<Long, Long> majorRule = RouterRules.getMajorityWidthClearance(db);
        Unit unit = Design.getUnit((Db)db);
        String widthUU = unit.toUserStr(((Long)majorRule.first).longValue());
        String clearUU = unit.toUserStr(((Long)majorRule.second).longValue());
        RouterRules r = new RouterRules(RULE);
        r.addValue(PCB);
        RouterRules wn = new RouterRules(WIDTH);
        wn.addValue(widthUU);
        r.addChild(wn);
        root.addChild(r);
        RouterRules cn = new RouterRules(RULE);
        cn.addValue(PCB);
        RouterRules cn2 = new RouterRules(CLEARANCE);
        cn2.addValue(clearUU);
        cn.addChild(cn2);
        root.addChild(cn);
    }

    protected static APair<Long, Long> getMajorityWidthClearance(Db db) {
        Long defaultDbu = Design.getUnit((Db)db).fromUserString("20.0");
        HashMap widthCounter = new HashMap();
        HashMap clearanceCounter = new HashMap();
        db.getObjects(ConstraintContext.class).stream().forEach(cc -> {
            Long numNets = cc.getPrimary().getObjects(Net.class).count();
            RouterRules.getWidth(cc).ifPresent(w -> {
                if (widthCounter.containsKey(w)) {
                    Long newSum = numNets + (Long)widthCounter.get(w);
                    widthCounter.put(w, newSum);
                } else {
                    widthCounter.put(w, numNets);
                }
            });
            RouterRules.getClearance(cc).ifPresent(c -> {
                if (clearanceCounter.containsKey(c)) {
                    Long newSum = numNets + (Long)clearanceCounter.get(c);
                    clearanceCounter.put(c, newSum);
                } else {
                    clearanceCounter.put(c, numNets);
                }
            });
        });
        APair ret = new APair((Object)defaultDbu, (Object)defaultDbu);
        if (!widthCounter.isEmpty()) {
            ret.first = Collections.max(widthCounter.entrySet(), Comparator.comparingLong(Map.Entry::getValue)).getKey();
        }
        if (!clearanceCounter.isEmpty()) {
            ret.second = Collections.max(clearanceCounter.entrySet(), Comparator.comparingLong(Map.Entry::getValue)).getKey();
        }
        return ret;
    }

    protected static void sortByPrecedence(List<ConstraintContext> classes) {
        Collections.sort(classes, (c1, c2) -> c1.getPrecedence() - c2.getPrecedence());
    }

    protected static void buildClass(Db db, RouterRules root, ClassCounter counter) {
        List<ConstraintContext> classes = db.getObjects(ConstraintContext.class).stream().filter(RouterRules::isClass).collect(Collectors.toList());
        RouterRules.sortByPrecedence(classes);
        for (ConstraintContext cc : classes) {
            String name = counter.getName();
            RouterRules.buildOneClass(root, cc, name);
        }
    }

    protected static boolean isClass(ConstraintContext cc) {
        boolean noRelatedClass = false;
        Optional rel = cc.getRelated();
        if (rel.isPresent()) {
            if (rel.get() == cc.getPrimary()) {
                noRelatedClass = true;
            }
        } else {
            noRelatedClass = true;
        }
        return noRelatedClass && cc.getRegion().isEmpty();
    }

    protected static void buildOneClass(RouterRules root, ConstraintContext cc, String name) {
        RouterRules classNode = RouterRules.buildOneNetGrpClass(root, cc.getPrimary(), name);
        RouterRules.buildLayeredRules(classNode, cc, false);
    }

    protected static void buildLayeredRules(RouterRules classNode, ConstraintContext cc, boolean clearOnly) {
        cc.getLayer().getObjects(Layer.class).forEach(layer -> {
            RouterRules layerNode = new RouterRules(LAYER_RULE);
            layerNode.addValue(((Layer)layer.getDbObject()).getName());
            classNode.addChild(layerNode);
            RouterRules ruleNode = new RouterRules(RULE);
            layerNode.addChild(ruleNode);
            RouterRules.buildConstraints(cc, ruleNode, clearOnly);
        });
    }

    protected static void buildConstraints(ConstraintContext cc, RouterRules ruleNode, boolean clearOnly) {
        RouterRules.addClearance(cc, ruleNode);
        if (!clearOnly) {
            RouterRules.addRouterRules(cc, ruleNode);
        }
    }

    protected static Optional<Long> getWidth(ConstraintContext cc) {
        Constraint cons = Constraint.getConstraint((DbObject)cc, (Constraint.Descriptor)Constraint.getDescriptor((String)WIDTH));
        if (cons == null) {
            return Optional.empty();
        }
        return Optional.of((Long)cons.getValue());
    }

    protected static void addWidth(ConstraintContext cc, RouterRules parent) {
        RouterRules.getWidth(cc).ifPresent(w -> {
            RouterRules widthNode = new RouterRules(WIDTH);
            parent.addChild(widthNode);
            widthNode.addValue(RouterRules.toUserUnit(w, cc));
        });
    }

    protected static Optional<Long> getClearance(ConstraintContext cc) {
        List<APair<Long, String>> cData = RouterRules.getClearances(cc);
        if (cData.isEmpty()) {
            return Optional.empty();
        }
        return cData.stream().map(d -> (Long)d.first).min(Long::compareTo);
    }

    protected static List<APair<Long, String>> getClearances(ConstraintContext cc) {
        ArrayList<APair<Long, String>> ret = new ArrayList<APair<Long, String>>();
        for (Constraint.Descriptor desc : Constraint.getRouterTypedClearanceDescriptors()) {
            Constraint cons = Constraint.getConstraint((DbObject)cc, (Constraint.Descriptor)desc);
            if (cons == null) continue;
            Object typeStr = "";
            if (cons.getName().contains("_")) {
                String[] typeArr = cons.getName().split("_");
                typeStr = typeArr[1] + "_" + typeArr[2];
            }
            ret.add((APair<Long, String>)new APair((Object)((Long)cons.getValue()), typeStr));
        }
        return ret;
    }

    protected static void addClearance(ConstraintContext cc, RouterRules parent) {
        for (APair<Long, String> pair : RouterRules.getClearances(cc)) {
            String clearUU = RouterRules.toUserUnit((Long)pair.first, cc);
            RouterRules clearanceNode = new RouterRules(CLEARANCE);
            clearanceNode.addValue(clearUU);
            parent.addChild(clearanceNode);
            if (!((String)pair.second).contains("_")) continue;
            RouterRules typeNode = new RouterRules(TYPE);
            typeNode.addValue((String)pair.second);
            clearanceNode.addChild(typeNode);
        }
    }

    protected static void addRouterRules(ConstraintContext cc, RouterRules parent) {
        for (Constraint.Descriptor typ : Constraint.getRouterDescriptors()) {
            Constraint cons = Constraint.getConstraint((DbObject)cc, (Constraint.Descriptor)typ);
            if (cons == null) continue;
            RouterRules ruleNode = new RouterRules(typ.getName());
            parent.addChild(ruleNode);
            ruleNode.addValue(RouterRules.toUserUnit((Long)cons.getValue(), cc));
        }
    }

    protected static void buildRegion(Db db, RouterRules root, ClassCounter counter) {
        List<ConstraintContext> classes = db.getObjects(ConstraintContext.class).stream().filter(cc -> cc.getRegion().isPresent()).collect(Collectors.toList());
        RouterRules.sortByPrecedence(classes);
        for (ConstraintContext cc2 : classes) {
            String name = counter.getName();
            RouterRules.buildOneDeviceRegion(root, cc2, name);
        }
    }

    protected static void buildOneDeviceRegion(RouterRules root, ConstraintContext cc, String name) {
        Optional r = cc.getRegion();
        if (r.isEmpty()) {
            return;
        }
        DeviceRegion region = (DeviceRegion)r.get();
        DeviceTemplate devT = region.getOwner();
        for (DevicePath devicePath : devT.getHierarchicalInstances()) {
            RouterRules.buildOneRegion(devicePath, region, root, cc, name);
        }
    }

    protected static String toUserUnit(long dbUnitVal, ConstraintContext cc) {
        Double retValue = Design.getUnit((Db)cc.getDb()).toUser(dbUnitVal);
        return retValue.toString();
    }

    protected static List<String> toUserUnit(APoint2D pt, ConstraintContext cc) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(RouterRules.toUserUnit(pt.getX(), cc));
        ret.add(RouterRules.toUserUnit(pt.getY(), cc));
        return ret;
    }

    protected static void buildOneRegion(DevicePath devicePath, DeviceRegion region, RouterRules root, ConstraintContext cc, String name) {
        APoint2D loc = devicePath.getLoc();
        AGeom shape = region.getShape().copy();
        shape.moveBy(loc.getX(), loc.getY());
        RouterRules.buildOneNetGrpClass(root, cc.getPrimary(), name);
        cc.getLayer().getObjects(Layer.class).forEach(layer -> {
            RouterRules defineNode = new RouterRules(DEFINE);
            root.addChild(defineNode);
            RouterRules regionNode = new RouterRules(REGION);
            defineNode.addChild(regionNode);
            RouterRules.buildShapeNode(shape, regionNode, ((Layer)layer.getDbObject()).getName(), cc);
            RouterRules classNode = new RouterRules(REGION_CLASS);
            regionNode.addChild(classNode);
            classNode.addValue(name);
            RouterRules ruleNode = new RouterRules(RULE);
            regionNode.addChild(ruleNode);
            RouterRules.buildConstraints(cc, ruleNode, false);
        });
    }

    protected static RouterRules buildShapeNode(AGeom shape, RouterRules parent, String layerName, ConstraintContext cc) {
        String shapeStr = "rect";
        if (shape.getName().compareTo("APolygon") == 0) {
            shapeStr = "polygon";
        }
        RouterRules shapeNode = new RouterRules(shapeStr);
        parent.addChild(shapeNode);
        shapeNode.addValue(layerName);
        if (shapeStr.compareTo("rect") == 0) {
            RouterRules.toUserUnit(((ARect)shape).getLL(), cc).forEach(shapeNode::addValue);
            RouterRules.toUserUnit(((ARect)shape).getUR(), cc).forEach(shapeNode::addValue);
        } else {
            for (APoint2D pt : ((APolygon)shape).getPointList()) {
                RouterRules.toUserUnit(pt, cc).forEach(shapeNode::addValue);
            }
        }
        return shapeNode;
    }

    protected static void buildClassClass(Db db, RouterRules root, ClassCounter counter) {
        List<ConstraintContext> classes = db.getObjects(ConstraintContext.class).stream().filter(cc -> cc.getRelated().isPresent() && cc.getRelated().get() != cc.getPrimary() && cc.getRegion().isEmpty()).collect(Collectors.toList());
        RouterRules.sortByPrecedence(classes);
        for (ConstraintContext cc2 : classes) {
            String name1 = counter.getName();
            String name2 = counter.getName();
            RouterRules.buildOneClassClass(root, cc2, name1, name2);
        }
    }

    protected static RouterRules buildOneNetGrpClass(RouterRules root, Personality netGrp, String name) {
        RouterRules defineNode = new RouterRules(DEFINE);
        root.addChild(defineNode);
        RouterRules classNode = new RouterRules(CLASS);
        classNode.addValue(name);
        defineNode.addChild(classNode);
        netGrp.getObjects(Net.class).forEach(n -> classNode.addValue(((Net)n.getDbObject()).getName()));
        return classNode;
    }

    protected static void buildOneClassClass(RouterRules root, ConstraintContext cc, String name1, String name2) {
        Optional rel = cc.getRelated();
        if (!rel.isPresent()) {
            return;
        }
        RouterRules.buildOneNetGrpClass(root, cc.getPrimary(), name1);
        RouterRules.buildOneNetGrpClass(root, (Personality)rel.get(), name2);
        RouterRules defineNode = new RouterRules(DEFINE);
        root.addChild(defineNode);
        RouterRules classNode = new RouterRules(CLASS_CLASS);
        defineNode.addChild(classNode);
        RouterRules classesNode = new RouterRules(CLASSES);
        classNode.addChild(classesNode);
        classesNode.addValue(name1);
        classesNode.addValue(name2);
        RouterRules.buildLayeredRules(classNode, cc, true);
    }

    protected static void buildDiffPair(Db db, RouterRules root) {
        Design design = Design.getDesign((Db)db);
        Device topDevice = AUtil.ifExactlyOne((Stream)design.getChildren().stream()).orElse(null);
        if (topDevice != null) {
            DeviceTemplate devT = topDevice.getTemplate();
            DevicePath path = devT.getPathToPresentUser();
            HashSet<Net> diffPairSet = new HashSet<Net>();
            for (Net net : devT.getNets()) {
                Net mate = Net.getDiffPairMate((Net)net, (DevicePath)path);
                if (net.isUnused() || mate == null || diffPairSet.contains(mate)) continue;
                diffPairSet.add(net);
                diffPairSet.add(mate);
                RouterRules defineNode = new RouterRules(DEFINE);
                root.addChild(defineNode);
                RouterRules pairNode = new RouterRules(PAIR);
                defineNode.addChild(pairNode);
                RouterRules netNode = new RouterRules(NETS);
                pairNode.addChild(netNode);
                netNode.addValue(net.getName());
                netNode.addValue(mate.getName());
            }
        }
    }

    protected RouterRules(String tag) {
        this.mTag = tag;
        this.mValues = new ArrayList<String>();
        this.mChildren = new ArrayList<CCTFileOutDo.RuleNode>();
    }

    protected void addChild(CCTFileOutDo.RuleNode c) {
        this.mChildren.add(c);
    }

    protected void addValue(String val) {
        this.mValues.add(val);
    }

    @Override
    public String getTag() {
        return this.mTag;
    }

    @Override
    public List<String> getValues() {
        return this.mValues;
    }

    @Override
    public List<CCTFileOutDo.RuleNode> getChildren() {
        return this.mChildren;
    }

    protected static class ClassCounter {
        int mCnt = 1;

        public String getName() {
            String name = "C_" + this.mCnt;
            ++this.mCnt;
            return name;
        }
    }
}

