/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.export;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.spd2000.SpdDBProcessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SPDOut {
    protected Db mDb = null;
    protected long mKeyIndex = 0L;
    protected FileWriter mWriter = null;
    protected String mRootSubstrateName = null;
    protected boolean mRecursiveSubstrate = true;
    protected SpdDBProcessor.SpdUnit mSpdUnit = null;
    protected HashSet<String> mSubstrates = new HashSet();
    protected HashMap<String, String> mNodeNameMap = new HashMap();
    protected HashMap<String, String> mRenamedLayers = new HashMap();

    public SPDOut(boolean recursiveSubstrate) {
        this.mDb = OrbitIO.getCurDb();
        this.mRecursiveSubstrate = recursiveSubstrate;
        this.mSpdUnit = new SpdDBProcessor.SpdUnit(this.mDb);
    }

    protected void getExportSubstrates(String substrate) {
        this.mSubstrates.clear();
        if (Substrate.getSubstrate((Db)this.mDb, (String)substrate) == null) {
            return;
        }
        this.mSubstrates.add(substrate);
        if (this.mRecursiveSubstrate) {
            for (Device d : this.getSubstrateDevices(substrate)) {
                HashSet<String> subs = new HashSet<String>();
                this.getMeAndChildSubstrate(d, subs);
                this.mSubstrates.addAll(subs);
            }
        }
    }

    protected void getMeAndChildSubstrate(Device device, HashSet<String> substrates) {
        substrates.add(device.getSubstrate().getName());
        for (Device d : device.getChildren()) {
            this.getMeAndChildSubstrate(d, substrates);
        }
    }

    public boolean exportSpd(String fileName, String substrate) {
        this.getExportSubstrates(substrate);
        if (this.mSubstrates.isEmpty()) {
            return false;
        }
        this.mRootSubstrateName = substrate;
        try {
            Files.deleteIfExists(Paths.get(fileName, new String[0]));
            File file = new File(fileName);
            this.mWriter = new FileWriter(file);
            this.writeHeader();
            this.writePackage();
            this.mWriter.flush();
            this.mWriter.close();
        }
        catch (IOException e) {
            ALog.logError((String)e.getMessage());
            return false;
        }
        return true;
    }

    protected void writeHeader() throws IOException {
        String title = "Title - SPEED2000 file for version 2000.09 translated from ORBitIO file.\n\n";
        String trans = ".Transient Timesteps = 100 Viewstep = 10 DC = No Window = Yes\n\n";
        assert (this.mWriter != null);
        this.mWriter.write("Title - SPEED2000 file for version 2000.09 translated from ORBitIO file.\n\n");
        this.mWriter.write(".Transient Timesteps = 100 Viewstep = 10 DC = No Window = Yes\n\n");
    }

    protected void writePackage() throws IOException {
        int meshx = 60;
        int meshy = 60;
        assert (!this.mSubstrates.isEmpty());
        ArrayList<Device> devs = this.getSubstrateDevices(this.mRootSubstrateName);
        if (devs.isEmpty()) {
            return;
        }
        this.mWriter.write(String.format(".Mesh  Pkg = %s Mesh_X = %d  Mesh_Y = %d%n%n", devs.get(0).getName(), 60, 60));
        this.mWriter.write(String.format(".package %s%n", devs.get(0).getName()));
        this.writeLayer();
        for (Device device : devs) {
            this.writeNode(device);
            this.writeTrace(device);
        }
        this.writePadStack();
        this.mWriter.write(".EndPackage\n");
        for (Device device : devs) {
            this.writeCircuit(device);
        }
        this.mWriter.write(".End\n");
    }

    protected void writeLayer() throws IOException {
        String defThickness = "3.56e-002mm";
        HashSet<Object> ls = new HashSet<Object>();
        ArrayList ll = new ArrayList();
        for (String sname : this.mSubstrates) {
            Substrate ss = Substrate.getSubstrate((Db)this.mDb, (String)sname);
            ArrayList<Layer> tmp = new ArrayList<Layer>();
            for (Layer l : ss.getLayers()) {
                if (l.getOrder() < 0) continue;
                Object n = l.getName();
                int i = 0;
                while (ls.contains(n)) {
                    n = l.getName() + i++;
                }
                if (!((String)n).equals(l.getName())) {
                    this.mRenamedLayers.put(l.getKeyStr(), (String)n);
                }
                ls.add(n);
                tmp.add(l);
            }
            Collections.sort(tmp, Collections.reverseOrder());
            ll.addAll(tmp);
        }
        for (Metal m : this.mDb.getObjects(Metal.class)) {
            Layer l = m.getLayer();
            if (!this.mSubstrates.contains(l.getSubstrate().getName())) continue;
            String name = "Shape$" + this.getLayerName(l);
            this.mWriter.write(".Shape " + name + "\n");
            String s1 = this.toSpdGeomString(m.getGeom());
            int i = s1.indexOf(32);
            if (i <= 0) continue;
            String s2 = this.mKeyIndex++ + "::" + this.getLayerName(l) + "+";
            this.mWriter.write(s1.substring(0, i) + s2 + s1.substring(i) + "\n");
        }
        boolean firstMedium = true;
        int i = 0;
        for (Layer l : ll) {
            if (!firstMedium) {
                this.mWriter.write("Medium$" + (i += 2) + " Thickness = 3.56e-002mm");
                this.mWriter.write("\n");
            } else {
                firstMedium = false;
            }
            this.mWriter.write(this.getSpdLayerName(l, "signal"));
            if (l.getWidth() > 0L) {
                this.mWriter.write(" Width = " + String.format("%emm", this.internalUnitToSpd(l.getWidth())));
            }
            if (l.getHeight() > 0L) {
                this.mWriter.write(" Thickness = " + String.format("%emm", this.internalUnitToSpd(l.getHeight())));
            } else {
                this.mWriter.write(" Thickness = 3.56e-002mm");
            }
            this.mWriter.write("\n");
        }
        for (Metal m : this.mDb.getObjects(Metal.class)) {
            Layer l = m.getLayer();
            if (!this.mSubstrates.contains(l.getSubstrate().getName())) continue;
            String ln = this.getShortLayerName(l);
            this.mWriter.write("Patch$" + ln + " Shape = Shape$" + ln + "\n+\t Layer = " + this.getSpdLayerName(l, "signal") + "\n");
        }
        this.mWriter.write("\n");
    }

    protected String getLayerName(Layer layer) {
        String n = this.mRenamedLayers.get(layer.getKeyStr());
        if (n == null || n.isEmpty()) {
            n = layer.getName();
        }
        return n;
    }

    protected void writeNode(Device device) throws IOException {
        if (!this.mSubstrates.contains(device.getSubstrate().getName())) {
            return;
        }
        DevicePath surrogate = device.getADevicePath();
        APoint2D devLoc = surrogate.getOrigin();
        for (PinInstance p : device.getPins()) {
            String nodeName = this.mNodeNameMap.get(p.getKeyStr());
            if (nodeName != null) continue;
            PinTemplate dpt = p.getPinTemplate();
            PadTemplate pt = dpt.getPadTemplate();
            APoint2D loc = p.getLoc();
            Layer l = device.getSubstrate().getTopLayer();
            String lsName = this.getSpdLayerName(l, "signal");
            nodeName = this.getNodeName(p);
            this.mNodeNameMap.put(p.getKeyStr(), nodeName);
            String n = String.format("%s x = %emm y = %emm Layer = %s PadStack = %s%n", nodeName, this.internalUnitToSpd((double)loc.getX() + (double)devLoc.getX()), this.internalUnitToSpd((double)loc.getY() + (double)devLoc.getY()), lsName, pt.getName());
            this.mWriter.write(n);
        }
        for (Device d : device.getChildren()) {
            this.writeNode(d);
        }
    }

    protected void writeTrace(Device device) throws IOException {
        for (Wire w : this.mDb.getObjects(Wire.class)) {
            if (!this.mSubstrates.contains(w.getLayer().getSubstrate().getName())) continue;
            APath path = w.getPath();
            PinInstance portStart = this.getPortByLoc(device, path.getFirstPoint());
            PinInstance portEnd = this.getPortByLoc(device, path.getLastPoint());
            if (portStart == null || portEnd == null) continue;
            String n = String.format("%s StartingNode = %s EndingNode = %s Width = %emm%n", this.getTraceName(w), this.mNodeNameMap.get(portStart.getKeyStr()), this.mNodeNameMap.get(portEnd.getKeyStr()), path.getWidth());
            this.mWriter.write(n);
        }
    }

    protected void writePadStack() throws IOException {
        for (PadTemplate pt : this.mDb.getObjects(PadTemplate.class)) {
            this.mWriter.write(".PadStackDef " + pt.getName() + "\n");
            for (LayerShape ls : pt.getLayerShapes()) {
                Layer l = ls.getLayer();
                this.mWriter.write(".PadDef " + this.getSpdLayerName(l, "signal") + "\n");
                this.mWriter.write("Regular " + this.toSpdGeomString(ls.getGeom()) + "\n");
                this.mWriter.write(".EndPadDef\n");
            }
            this.mWriter.write(".EndPadStackDef\n\n");
        }
    }

    protected void writeCircuit(Device devParent) throws IOException {
        HashSet<String> partials = new HashSet<String>();
        this.writePartialCkt(devParent, partials);
        this.writeComponent(devParent.getName(), devParent, partials);
    }

    protected String getExtNodeString(Device device) {
        int pinCnt = 0;
        StringBuilder builder = new StringBuilder();
        for (PinInstance port : device.getPins()) {
            if (pinCnt > 0 && pinCnt % 15 == 0) {
                builder.append("\n+\t");
            }
            ++pinCnt;
            PinTemplate tp = port.getPinTemplate();
            ArrayList<String> tokens = this.parseTokens(tp.getName(), new String[]{"!!", "::"});
            String pinName = tokens.get(1);
            if (pinName == null || pinName.isEmpty()) {
                pinName = tokens.get(0);
            }
            builder.append(pinName + " ");
        }
        return builder.toString();
    }

    protected void writePartialCkt(Device device, HashSet<String> partials) throws IOException {
        for (Device d : device.getChildren()) {
            if (!this.mSubstrates.contains(d.getSubstrate().getName())) continue;
            String dtName = d.getTemplate().getName();
            String dtKey = d.getTemplate().getKeyStr();
            if (partials.contains(dtKey)) continue;
            String extNodes = this.getExtNodeString(d);
            partials.add(dtKey);
            this.mWriter.write(".PartialCkt " + dtName + " ExtNode = " + extNodes + "\n");
            this.mWriter.write(".EndPartialCkt\n\n");
            this.writePartialCkt(d, partials);
        }
    }

    protected void writeComponent(String pkgName, Device devParent, HashSet<String> partials) throws IOException {
        for (Device d : devParent.getChildren()) {
            DeviceTemplate dt;
            if (!this.mSubstrates.contains(d.getSubstrate().getName()) || !partials.contains((dt = d.getTemplate()).getKeyStr())) continue;
            this.mWriter.write(".Connect  " + d.getName() + " " + dt.getName() + "\n");
            for (PinInstance p : d.getPins()) {
                ArrayList<String> tokens = this.parseTokens(p.getPinTemplate().getName(), new String[]{"!!", "::"});
                String pinName = tokens.get(1);
                if (pinName == null || pinName.isEmpty()) {
                    pinName = tokens.get(0);
                }
                this.mWriter.write(pinName + " " + pkgName + "." + this.mNodeNameMap.get(p.getKeyStr()) + "\n");
            }
            this.mWriter.write(".EndC\n\n");
            this.writeComponent(pkgName, d, partials);
        }
    }

    protected String toSpdGeomString(AGeom geom) {
        Object n = "";
        if (geom instanceof APolygon) {
            APolygon g = (APolygon)geom;
            n = "Polygon ";
            int i = 0;
            for (APoint2D p : g.getPoints()) {
                if (i > 0 && i % 8 == 0) {
                    n = (String)n + "\n+\t";
                }
                ++i;
                n = (String)n + String.format("%emm", this.internalUnitToSpd(p.getX())) + " ";
                n = (String)n + String.format("%emm", this.internalUnitToSpd(p.getY())) + " ";
            }
            n = (String)n + "\n";
        } else if (geom instanceof ACircle) {
            ACircle c = (ACircle)geom;
            n = "Circle " + String.format("%emm", this.internalUnitToSpd(c.getR()));
        } else if (geom instanceof ARect) {
            ARect r = (ARect)geom;
            n = "Box ";
            n = (String)n + String.format("%emm", this.internalUnitToSpd(r.width())) + " ";
            n = (String)n + String.format("%emm", this.internalUnitToSpd(r.height()));
        } else {
            ALog.logError((Throwable)new Exception(), (String)"Unsupported geometry type %s", (Object[])new Object[]{geom.getClass().getSimpleName()});
        }
        return n;
    }

    protected String getSpdLayerName(Layer layer, String preFix) {
        String n = this.getLayerName(layer).toLowerCase();
        preFix = ((String)preFix).toLowerCase();
        if (n.startsWith((String)(preFix = (String)preFix + "$"))) {
            return n;
        }
        return (String)preFix + n;
    }

    protected String getShortLayerName(Layer layer) {
        String[] layerPreFix = new String[]{"signal$", "plane$", "medium$"};
        String ln = this.getLayerName(layer).toLowerCase();
        for (int i = 0; i < layerPreFix.length; ++i) {
            if (!ln.startsWith(layerPreFix[i])) continue;
            ln = ln.substring(layerPreFix.length);
            break;
        }
        return ln;
    }

    protected String getNodeName(PinInstance port) {
        Object n = this.mNodeNameMap.get(port.getKeyStr());
        if (n != null) {
            return n;
        }
        ArrayList<String> tokens = this.parseTokens(port.getName(), new String[]{"!!", "::"});
        Object nodeName = tokens.get(0);
        Object pinName = tokens.get(1);
        String netName = tokens.get(2);
        if (nodeName == null) {
            return null;
        }
        if (((String)(nodeName = ((String)nodeName).toLowerCase())).length() <= 4 || !((String)nodeName).startsWith("node")) {
            pinName = nodeName;
            nodeName = "Node" + this.mKeyIndex++;
        }
        if (pinName == null || ((String)pinName).isEmpty()) {
            pinName = "" + this.mKeyIndex++;
        }
        Net topNet = NetMap.getTopmostNet((Net)port.getNet(), (DevicePath)port.getDevice().getADevicePath());
        if (netName == null || !netName.equals(topNet.getName())) {
            netName = topNet.getName();
        }
        n = (String)nodeName + "!!" + (String)pinName + "::" + netName;
        return n;
    }

    protected double internalUnitToSpd(double v) {
        return this.mSpdUnit.internalToSpd(v, "m", "m");
    }

    protected String getTraceName(Wire wire) {
        return "Trace" + this.mKeyIndex++ + "::" + wire.getNet().getName();
    }

    protected PinInstance getPortByLoc(Device device, APoint2D point) {
        for (PinInstance p : device.getPins()) {
            APoint2D loc = p.getLoc();
            if (loc.getX() != point.getX() || loc.getY() != point.getY()) continue;
            return p;
        }
        return null;
    }

    protected ArrayList<Device> getSubstrateDevices(String sName) {
        ArrayList<Device> devices = new ArrayList<Device>();
        Substrate substrate = Substrate.getSubstrate((Db)this.mDb, (String)sName);
        for (Device d : this.mDb.getObjects(Device.class)) {
            Substrate s;
            if (!d.getIsSubstrate() || (s = d.getSubstrate()) == null || s != substrate) continue;
            devices.add(d);
        }
        return devices;
    }

    protected ArrayList<String> parseTokens(String str, String[] delimiters) {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Integer> pos = new ArrayList<Integer>();
        tokens.add("");
        for (int i = 0; str != null && i < delimiters.length; ++i) {
            pos.add(str.indexOf(delimiters[i]));
        }
        int minPos = Integer.MAX_VALUE;
        for (int i = 0; i < pos.size(); ++i) {
            int startPos = (Integer)pos.get(i);
            if (startPos < 0) {
                tokens.add("");
                continue;
            }
            if (minPos > startPos) {
                minPos = startPos;
            }
            int endPos = str.length();
            Iterator iterator = pos.iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                if (k <= startPos || k >= endPos) continue;
                endPos = k;
            }
            if (startPos + delimiters[i].length() == str.length()) {
                tokens.add("");
                continue;
            }
            tokens.add(str.substring(startPos + delimiters[i].length(), endPos));
        }
        tokens.set(0, minPos == Integer.MAX_VALUE ? str : str.substring(0, minPos));
        return tokens;
    }
}

